/*
 * Decompiled with CFR 0.152.
 */
package Display;

import javax.swing.JLabel;
import javax.swing.JTextArea;

public class LoggerDisplay {
    private JLabel Header = new JLabel();
    private JTextArea DisplayArea = new JTextArea();
    private String DisplayHead = new String("");
    private String DisplayText = new String("");
    private boolean Enable = false;
    private int DisplayType = 0;
    private int MaxSize = 0;
    public static final int INPUT_Display_TYPE = 0;
    public static final int DECOD_Display_TYPE = 1;

    public LoggerDisplay(JTextArea _DisplayArea, int _MaxSize) {
        this.DisplayArea = _DisplayArea;
        this.MaxSize = _MaxSize;
    }

    public void DisplayInit() {
        this.DisplayText = "";
    }

    public void DisplaySetType(int Type) {
        this.DisplayType = Type;
        this.DisplayInit();
    }

    public void DisplayStart() {
        this.Enable = true;
    }

    public void DisplayStop() {
        this.Enable = false;
    }

    public void DisplaySetHeadFrame(String Frame) {
        this.DisplayHead = Frame.compareToIgnoreCase("") == 0 ? "" : Frame + "\r\n";
    }

    public void DisplayAddFrame(String Frame, int Type) {
        if (!this.Enable) {
            return;
        }
        if (Type != this.DisplayType) {
            return;
        }
        if (Frame.equalsIgnoreCase("") || Frame.length() < 10) {
            return;
        }
        this.DisplayText = Frame.contains("\r\n") || Frame.contains("\n") || Frame.contains("\r\n") ? this.DisplayText + Frame : this.DisplayText + Frame + "\r\n";
        this.DisplayResizeText();
    }

    public void DisplayAddFrame(byte[] Frame, int Lenght, int Type) {
        if (!this.Enable) {
            return;
        }
        if (Type != this.DisplayType) {
            return;
        }
        this.DisplayText = this.DisplayText + new String(Frame, 0, Lenght);
        this.DisplayResizeText();
    }

    private void DisplayResizeText() {
        int i = 0;
        boolean CR_found = false;
        if (this.DisplayText.length() > this.MaxSize) {
            this.DisplayText = this.DisplayText.substring(this.DisplayText.length() - this.MaxSize);
            for (i = 0; i < this.DisplayText.length(); ++i) {
                if (this.DisplayText.charAt(i) != '\r') continue;
                CR_found = true;
                break;
            }
            if (CR_found) {
                this.DisplayText = this.DisplayText.substring(i);
            }
        }
    }

    public void DisplayUpdate() {
        if (this.Enable) {
            this.Header.setToolTipText(this.DisplayHead);
            try {
                this.DisplayArea.setText(this.DisplayText.substring(0, Math.max(this.DisplayText.length() - 2, 0)) + "\r\n" + this.DisplayHead);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

