/*
 * Decompiled with CFR 0.152.
 */
package LoggerDecoder;

import java.util.prefs.Preferences;

public class LogInfo {
    Preferences prefs;
    int FlowType = 0;
    int Protocol_Id = 0;
    String Protocol_Name = "None";
    int Frequency = 200;
    String InputFile = "";
    int EthConnType = 0;
    String IPAdress = "192.168.36.122";
    String IPPort = "8115";
    String RSPort = "COM1";
    int Baudrate_Id = 4;
    int Databits_Id = 1;
    int Parity_Id = 0;
    int StopBits_Id = 0;
    boolean[] LogFileEnable = new boolean[2];
    String[] LogFileName = new String[2];
    int[] LogSegType = new int[2];
    int[] LogSegParam = new int[2];
    int[] LogDecimType = new int[2];
    int[] LogDecimFreq = new int[2];
    int[] LogDecimRatio = new int[2];
    String WorkingDirectory = new String();
    String Revision = "";
    String RevisionDate = "";
    public static final int FLOW_NONE = 0;
    public static final int FILE_FLOW = 1;
    public static final int ETHERNET_FLOW = 2;
    public static final int SERIAL_FLOW = 3;
    public static final int PROTOCOL_NONE = 0;
    public static final int BAUDRATE_600 = 0;
    public static final int BAUDRATE_1200 = 1;
    public static final int BAUDRATE_2400 = 2;
    public static final int BAUDRATE_4800 = 3;
    public static final int BAUDRATE_9600 = 4;
    public static final int BAUDRATE_19200 = 5;
    public static final int BAUDRATE_38400 = 6;
    public static final int BAUDRATE_57600 = 7;
    public static final int BAUDRATE_115200 = 8;
    public static final int BAUDRATE_230400 = 9;
    public static final int BAUDRATE_460800 = 10;
    public static final int BAUDRATE_921600 = 11;
    public static final int DATABITS_7 = 0;
    public static final int DATABITS_8 = 1;
    public static final int Parity_NONE = 0;
    public static final int Parity_EVEN = 1;
    public static final int Parity_ODD = 2;
    public static final int StopBit_None = 0;
    public static final int StopBit_05 = 1;
    public static final int StopBit_1 = 2;
    public static final int StopBit_2 = 3;
    public static final int TCP_CLIENT = 0;
    public static final int TCP_SERVEUR = 1;
    public static final int UDP = 2;
    public static final int UDP_MULTICAST = 3;
    public static final int SEG_TYPE_NONE = 0;
    public static final int SEG_TYPE_TIME = 1;
    public static final int SEG_TYPE_SIZE = 2;
    public static final int INPUT_LOG_TYPE = 0;
    public static final int DECOD_LOG_TYPE = 1;
    public static final int DECIM_TYPE_NONE = 0;
    public static final int DECIM_TYPE_FREQ = 1;
    public static final int DECIM_TYPE_RATIO = 2;
    public static final int FREQ_1HZ = 0;
    public static final int FREQ_2HZ = 1;
    public static final int FREQ_5HZ = 2;
    public static final int FREQ_10HZ = 3;
    public static final int FREQ_20HZ = 4;
    public static final int FREQ_50HZ = 5;
    public static final int FREQ_100HZ = 6;
    public static final int RATIO_1_2 = 0;
    public static final int RATIO_1_3 = 1;
    public static final int RATIO_1_5 = 2;
    public static final int RATIO_1_10 = 3;
    public static final int RATIO_1_20 = 4;
    public static final int RATIO_1_50 = 5;
    public static final int RATIO_1_100 = 6;
    public static final int RATIO_1_127 = 7;
    private String separator = "";
    private int[] Precisions = new int[7];
    private static final String REG_FLOWTYPE = "flowtype";
    private static final String REG_PROTO = "protocole";
    private static final String REG_DIRECTORY = "directory";
    private static final String REG_ETHCONNTYPE = "ethconntype";
    private static final String REG_IPADRESS = "ipadress";
    private static final String REG_IPPORT = "ipport";
    private static final String REG_COMMPORT = "rscommport";
    private static final String REG_BAUDRATE = "baudrate";
    private static final String REG_DATABITS = "databits";
    private static final String REG_PARITY = "parity";
    private static final String REG_STOPBITS = "stopbits";
    private static final String REG_PRES_ = "precision_";
    private static final String REG_SEPARATOR = "separator";
    private static final String REG_FREQUENCY = "frequency";
    public static final int NBR_POINT = 1999;
    public static final int DATA_TYPE_DEFAULT = 0;
    public static final int DATA_TYPE_HRP = 1;
    public static final int DATA_TYPE_HRP_RATE = 2;
    public static final int DATA_TYPE_POSITION = 3;
    public static final int DATA_TYPE_SPEEDS = 4;
    public static final int DATA_TYPE_ACC = 5;
    public static final int DATA_TYPE_ROT = 6;
    public static final int DATA_TYPE_MAX = 7;
    public static final int UTC_TIME = 100;
    public static final int SYSTEM_TIME = 101;
    public static final int EPOCH_TIME = 102;
    public static final int HEADING = 103;
    public static final int ROLL = 104;
    public static final int PITCH = 105;
    public static final int POLAR_HEADING = 106;
    public static final int HEADING_SD = 107;
    public static final int ROLL_SD = 108;
    public static final int PITCH_SD = 109;
    public static final int HEADING_RATE = 110;
    public static final int ROLL_RATE = 111;
    public static final int PITCH_RATE = 112;
    public static final int POLAR_HEADING_RATE = 113;
    public static final int XV1_ROT_RATE_COMP_ER = 114;
    public static final int XV2_ROT_RATE_COMP_ER = 115;
    public static final int XV3_ROT_RATE_COMP_ER = 116;
    public static final int DELAYED_HEAVE = 117;
    public static final int NORTH_ACC = 118;
    public static final int EAST_ACC = 119;
    public static final int VERTICAL_ACC = 120;
    public static final int XV1_ACC_COMP_G = 121;
    public static final int XV2_ACC_COMP_G = 122;
    public static final int XV3_ACC_COMP_G = 123;
    public static final int LATITUDE = 124;
    public static final int LONGITUDE = 125;
    public static final int ALTITUDE = 126;
    public static final int POLAR_LATITUDE = 127;
    public static final int POLAR_LONGITUDE = 128;
    public static final int LATITUDE_SD = 129;
    public static final int LONGITUDE_SD = 130;
    public static final int ALTITUDE_SD = 131;
    public static final int COV_LATLONG = 132;
    public static final int XV1_SPEED = 133;
    public static final int XV2_SPEED = 134;
    public static final int XV3_SPEED = 135;
    public static final int NORTH_SPEED = 136;
    public static final int EAST_SPEED = 137;
    public static final int VERTICAL_SPEED = 138;
    public static final int POLAR_NORTH_SPEED = 139;
    public static final int POLAR_EAST_SPEED = 140;
    public static final int NORTH_SPEED_SD = 141;
    public static final int EAST_SPEED_SD = 142;
    public static final int VERTICAL_SPEED_SD = 143;
    public static final int INTEGRAL_SPEED_NORTH = 144;
    public static final int INTEGRAL_SPEED_EAST = 145;
    public static final int SPEED_OVER_GROUND = 146;
    public static final int COURSE_OVER_GROUND = 147;
    public static final int HEAVE = 148;
    public static final int HEAVE_NLA = 149;
    public static final int SURGE = 150;
    public static final int SWAY = 151;
    public static final int HEAVE_SPEED = 152;
    public static final int SURGE_SPEED = 153;
    public static final int SWAY_SPEED = 154;
    public static final int DAY = 155;
    public static final int MONTH = 156;
    public static final int YEAR = 157;
    public static final int LOCAL_ZONE_H = 158;
    public static final int LOCAL_ZONE_M = 159;
    public static final int GPS_DATA_VALIDITY_TIME = 160;
    public static final int GPS_DELAY = 161;
    public static final int GPS_LATITUDE = 162;
    public static final int GPS_LONGITUDE = 163;
    public static final int GPS_ALTITUDE = 164;
    public static final int GPS_QUALITY = 165;
    public static final int GPS_LATITUDE_SD = 166;
    public static final int GPS_LONGITUDE_SD = 167;
    public static final int GPS_ALTITUDE_SD = 168;
    public static final int GPS_COV_LATLONG = 169;
    public static final int GPS_GEOIDAL_SEP = 170;
    public static final int GPS2_DATA_VALIDITY_TIME = 171;
    public static final int GPS2_DELAY = 172;
    public static final int GPS2_LATITUDE = 173;
    public static final int GPS2_LONGITUDE = 174;
    public static final int GPS2_ALTITUDE = 175;
    public static final int GPS2_QUALITY = 176;
    public static final int GPS2_LATITUDE_SD = 177;
    public static final int GPS2_LONGITUDE_SD = 178;
    public static final int GPS2_ALTITUDE_SD = 179;
    public static final int GPS2_COV_LATLONG = 180;
    public static final int GPS2_GEOIDAL_SEP = 181;
    public static final int GPSM_DATA_VALIDITY_TIME = 182;
    public static final int GPSM_DELAY = 183;
    public static final int GPSM_LATITUDE = 184;
    public static final int GPSM_LONGITUDE = 185;
    public static final int GPSM_ALTITUDE = 186;
    public static final int GPSM_QUALITY = 187;
    public static final int GPSM_LATITUDE_SD = 188;
    public static final int GPSM_LONGITUDE_SD = 189;
    public static final int GPSM_ALTITUDE_SD = 190;
    public static final int GPSM_COV_LATLONG = 191;
    public static final int GPSM_GEOIDAL_SEP = 192;
    public static final int USBL_ID = 193;
    public static final int USBL_TPCODE = 194;
    public static final int USBL_MODE = 195;
    public static final int USBL_DATA_VALIDITY_TIME = 196;
    public static final int USBL_DELAY = 197;
    public static final int USBL_LATITUDE = 198;
    public static final int USBL_LONGITUDE = 199;
    public static final int USBL_ALTITUDE = 200;
    public static final int USBL_LATITUDE_SD = 201;
    public static final int USBL_LONGITUDE_SD = 202;
    public static final int USBL_ALTITUDE_SD = 203;
    public static final int USBL_COV_LATLONG = 204;
    public static final int USBL_REJ_MODE = 205;
    public static final int SOUND_SPEED = 206;
    public static final int DVL_ID = 207;
    public static final int DVL_RANGE_TO_BOTTOM = 208;
    public static final int DVL_SOUND_SPEED = 209;
    public static final int DVL_WT_DATA_VALIDITY_TIME = 210;
    public static final int DVL_WT_DELAY = 211;
    public static final int DVL_WT_SPEED_XV1 = 212;
    public static final int DVL_WT_SPEED_XV2 = 213;
    public static final int DVL_WT_SPEED_XV3 = 214;
    public static final int DVL_WT_SPEED_XV1_SD = 215;
    public static final int DVL_WT_SPEED_XV2_SD = 216;
    public static final int DVL_WT_SPEED_XV3_SD = 217;
    public static final int DVL_WT_REJ_MODE = 218;
    public static final int DVL_BT_DATA_VALIDITY_TIME = 219;
    public static final int DVL_BT_DELAY = 220;
    public static final int DVL_BT_SPEED_XV1 = 221;
    public static final int DVL_BT_SPEED_XV2 = 222;
    public static final int DVL_BT_SPEED_XV3 = 223;
    public static final int DVL_BT_SPEED_XV1_SD = 224;
    public static final int DVL_BT_SPEED_XV2_SD = 225;
    public static final int DVL_BT_SPEED_XV3_SD = 226;
    public static final int DVL_BT_REJ_MODE = 227;
    public static final int LBL_ID = 228;
    public static final int LBL_TPCODE = 229;
    public static final int LBL_DATA_VALIDITY_TIME = 230;
    public static final int LBL_DELAY = 231;
    public static final int LBL_LATITUDE = 232;
    public static final int LBL_LONGITUDE = 233;
    public static final int LBL_ALTITUDE = 234;
    public static final int LBL_RANGE = 235;
    public static final int LBL_RANGE_SD = 236;
    public static final int LBL_REJ_MODE = 237;
    public static final int LOCH_ID = 238;
    public static final int LOCH_DATA_VALIDITY_TIME = 239;
    public static final int LOCH_DELAY = 240;
    public static final int LOCH_SPEED = 241;
    public static final int LOCH_SPEED_SD = 242;
    public static final int LOCH_REJ_MODE = 243;
    public static final int DEPTH_DATA_VALIDITY_TIME = 244;
    public static final int DEPTH_DELAY = 245;
    public static final int DEPTH = 246;
    public static final int DEPTH_SD = 247;
    public static final int DEPTH_REJ_MODE = 248;
    public static final int PRESSURE = 249;
    public static final int CURRENT_NORTH_SPEED = 250;
    public static final int CURRENT_EAST_SPEED = 251;
    public static final int CURRENT_NORTH_SPEED_SD = 252;
    public static final int CURRENT_EAST_SPEED_SD = 253;
    public static final int CURRENT_DIRECTION = 254;
    public static final int CURRENT_SPEED = 255;
    public static final int DMI_DATA_VALIDITY_TIME = 256;
    public static final int DMI_SPEED = 257;
    public static final int LOG_MISALIGNMENT = 258;
    public static final int XV1_ROT_BIAS = 259;
    public static final int XV2_ROT_BIAS = 260;
    public static final int XV3_ROT_BIAS = 261;
    public static final int XV1_ACC_BIAS = 262;
    public static final int XV2_ACC_BIAS = 263;
    public static final int XV3_ACC_BIAS = 264;
    public static final int TRAVELLED_DISTANCE = 265;
    public static final int VERTICAL_ERROR = 266;
    public static final int HORIZONTAL_ERROR = 267;
    public static final int DRE_LATITUDE = 268;
    public static final int DRE_LONGITUDE = 269;
    public static final int DRE_ALTITUDE = 270;
    public static final int DRE_HEADING_LOG_MISALIGNMENT = 271;
    public static final int DRE_PITCH_LOG_MISALIGNMENT = 272;
    public static final int DRE_SCALE_FACTOR = 273;
    public static final int DVL2_RANGE_TO_BOTTOM = 274;
    public static final int DVL2_SOUND_SPEED = 275;
    public static final int DVL2_WT_DATA_VALIDITY_TIME = 276;
    public static final int DVL2_WT_DELAY = 277;
    public static final int DVL2_WT_SPEED_XV1 = 278;
    public static final int DVL2_WT_SPEED_XV2 = 279;
    public static final int DVL2_WT_SPEED_XV3 = 280;
    public static final int DVL2_WT_SPEED_XV1_SD = 281;
    public static final int DVL2_WT_SPEED_XV2_SD = 282;
    public static final int DVL2_WT_SPEED_XV3_SD = 283;
    public static final int DVL2_WT_REJ_MODE = 284;
    public static final int DVL2_BT_DATA_VALIDITY_TIME = 285;
    public static final int DVL2_BT_DELAY = 286;
    public static final int DVL2_BT_SPEED_XV1 = 287;
    public static final int DVL2_BT_SPEED_XV2 = 288;
    public static final int DVL2_BT_SPEED_XV3 = 289;
    public static final int DVL2_BT_SPEED_XV1_SD = 290;
    public static final int DVL2_BT_SPEED_XV2_SD = 291;
    public static final int DVL2_BT_SPEED_XV3_SD = 292;
    public static final int DVL2_BT_REJ_MODE = 293;
    public static final int DELAYED_HEAVE_NLA = 294;
    public static final int RTHEAVE_DELAYED = 295;
    public static final int RTHEAVE_DELAYED_NLA = 296;
    public static final int RTHEAVE_DELAY = 297;
    public static final int DELAYED_HEAVE_DELAY = 298;
    public static final int TEMP_FOG = 299;
    public static final int TEMP_ACC = 300;
    public static final int TEMP_ANA = 301;
    public static final int TEMP_SRC = 302;
    public static final int TEMP_FOGX = 303;
    public static final int TEMP_FOGY = 304;
    public static final int TEMP_FOGZ = 305;
    public static final int TEMP_ACCX = 306;
    public static final int TEMP_ACCY = 307;
    public static final int TEMP_ACCZ = 308;
    public static final int XV1_ACC = 309;
    public static final int XV2_ACC = 310;
    public static final int XV3_ACC = 311;
    public static final int XV1_ROT_RATE = 312;
    public static final int XV2_ROT_RATE = 313;
    public static final int XV3_ROT_RATE = 314;
    public static final int XV1_ACC_SD = 315;
    public static final int XV2_ACC_SD = 316;
    public static final int XV3_ACC_SD = 317;
    public static final int XV1_ROT_RATE_SD = 318;
    public static final int XV2_ROT_RATE_SD = 319;
    public static final int XV3_ROT_RATE_SD = 320;
    public static final int XV1_ROT_ACC = 321;
    public static final int XV2_ROT_ACC = 322;
    public static final int XV3_ROT_ACC = 323;
    public static final int XV1_ROT_ACC_SD = 324;
    public static final int XV2_ROT_ACC_SD = 325;
    public static final int XV3_ROT_ACC_SD = 326;
    public static final int ATT_QUAT0 = 327;
    public static final int ATT_QUAT1 = 328;
    public static final int ATT_QUAT2 = 329;
    public static final int ATT_QUAT3 = 330;
    public static final int ATT_QUAT0_SD = 331;
    public static final int ATT_QUAT1_SD = 332;
    public static final int ATT_QUAT2_SD = 333;
    public static final int REMAIN_ALIGN_TIME = 334;
    public static final int NORTH_ACC_COMP_G = 335;
    public static final int EAST_ACC_COMP_G = 336;
    public static final int VERTICAL_ACC_COMP_G = 337;
    public static final int XV1_ACC_FULL_COMP = 338;
    public static final int XV2_ACC_FULL_COMP = 339;
    public static final int XV3_ACC_FULL_COMP = 340;
    public static final int ALTITUDE_REF = 341;
    public static final int HEAVE_TIME = 342;
    public static final int LOCH2_ID = 343;
    public static final int LOCH2_DATA_VALIDITY_TIME = 344;
    public static final int LOCH2_DELAY = 345;
    public static final int LOCH2_SPEED = 346;
    public static final int LOCH2_SPEED_SD = 347;
    public static final int LOCH2_REJ_MODE = 348;
    public static final int USBL2_ID = 349;
    public static final int USBL2_TPCODE = 350;
    public static final int USBL2_MODE = 351;
    public static final int USBL2_DATA_VALIDITY_TIME = 352;
    public static final int USBL2_DELAY = 353;
    public static final int USBL2_LATITUDE = 354;
    public static final int USBL2_LONGITUDE = 355;
    public static final int USBL2_ALTITUDE = 356;
    public static final int USBL2_LATITUDE_SD = 357;
    public static final int USBL2_LONGITUDE_SD = 358;
    public static final int USBL2_ALTITUDE_SD = 359;
    public static final int USBL2_COV_LATLONG = 360;
    public static final int USBL2_REJ_MODE = 361;
    public static final int USBL3_ID = 362;
    public static final int USBL3_TPCODE = 363;
    public static final int USBL3_MODE = 364;
    public static final int USBL3_DATA_VALIDITY_TIME = 365;
    public static final int USBL3_DELAY = 366;
    public static final int USBL3_LATITUDE = 367;
    public static final int USBL3_LONGITUDE = 368;
    public static final int USBL3_ALTITUDE = 369;
    public static final int USBL3_LATITUDE_SD = 370;
    public static final int USBL3_LONGITUDE_SD = 371;
    public static final int USBL3_ALTITUDE_SD = 372;
    public static final int USBL3_COV_LATLONG = 373;
    public static final int USBL3_REJ_MODE = 374;
    public static final int LBL2_ID = 375;
    public static final int LBL2_TPCODE = 376;
    public static final int LBL2_DATA_VALIDITY_TIME = 377;
    public static final int LBL2_DELAY = 378;
    public static final int LBL2_LATITUDE = 379;
    public static final int LBL2_LONGITUDE = 380;
    public static final int LBL2_ALTITUDE = 381;
    public static final int LBL2_RANGE = 382;
    public static final int LBL2_RANGE_SD = 383;
    public static final int LBL2_REJ_MODE = 384;
    public static final int LBL3_ID = 385;
    public static final int LBL3_TPCODE = 386;
    public static final int LBL3_DATA_VALIDITY_TIME = 387;
    public static final int LBL3_DELAY = 388;
    public static final int LBL3_LATITUDE = 389;
    public static final int LBL3_LONGITUDE = 390;
    public static final int LBL3_ALTITUDE = 391;
    public static final int LBL3_RANGE = 392;
    public static final int LBL3_RANGE_SD = 393;
    public static final int LBL3_REJ_MODE = 394;
    public static final int LBL4_ID = 395;
    public static final int LBL4_TPCODE = 396;
    public static final int LBL4_DATA_VALIDITY_TIME = 397;
    public static final int LBL4_DELAY = 398;
    public static final int LBL4_LATITUDE = 399;
    public static final int LBL4_LONGITUDE = 400;
    public static final int LBL4_ALTITUDE = 401;
    public static final int LBL4_RANGE = 402;
    public static final int LBL4_RANGE_SD = 403;
    public static final int LBL4_REJ_MODE = 404;
    public static final int GPS_ID = 405;
    public static final int GPS2_ID = 406;
    public static final int GPSM_ID = 407;
    public static final int DVL2_ID = 408;
    public static final int XV1_ROT_RATE_FULL_COMP = 409;
    public static final int XV2_ROT_RATE_FULL_COMP = 410;
    public static final int XV3_ROT_RATE_FULL_COMP = 411;
    public static final int ROLL_TSS = 412;
    public static final int DVL_HEADING_MISALIGNMENT = 413;
    public static final int DVL_ROLL_MISALIGNMENT = 414;
    public static final int DVL_PITCH_MISALIGNMENT = 415;
    public static final int DVL_SCALE_FACTOR = 416;
    public static final int POINTING_ANGLE_HEADING = 417;
    public static final int POINTING_ANGLE_ROLL = 418;
    public static final int POINTING_ANGLE_PITCH = 419;
    public static final int POINTING_ANGLE_HEADING_SD = 420;
    public static final int POINTING_ANGLE_ROLL_SD = 421;
    public static final int POINTING_ANGLE_PITCH_SD = 422;
    public static final int TURRET_DATA_VALIDITY_TIME = 423;
    public static final int TURRET_HEADING = 424;
    public static final int TURRET_ROLL = 425;
    public static final int TURRET_PITCH = 426;
    public static final int DVL_BT_SPEED_GEO_XV1 = 427;
    public static final int DVL_BT_SPEED_GEO_XV2 = 428;
    public static final int DVL_BT_SPEED_GEO_XV3 = 429;
    public static final int DVL2_BT_SPEED_GEO_XV1 = 430;
    public static final int DVL2_BT_SPEED_GEO_XV2 = 431;
    public static final int DVL2_BT_SPEED_GEO_XV3 = 432;
    public static final int POLAR_HEADING_SD = 433;
    public static final int YAW = 434;
    public static final int YAW_SD = 435;
    public static final int HEADING_RATE_SD = 436;
    public static final int ROLL_RATE_SD = 437;
    public static final int PITCH_RATE_SD = 438;
    public static final int SPEED_OVER_GROUND_SD = 439;
    public static final int COURSE_OVER_GROUND_SD = 440;
    public static final int HEAVE_ACC = 441;
    public static final int SURGE_ACC = 442;
    public static final int SWAY_ACC = 443;
    public static final int HEAVE_ACC_SD = 444;
    public static final int SURGE_ACC_SD = 445;
    public static final int SWAY_ACC_SD = 446;
    public static final int HEAVE_ACC_RATE = 447;
    public static final int SURGE_ACC_RATE = 448;
    public static final int SWAY_ACC_RATE = 449;
    public static final int HEAVE_ACC_RATE_SD = 450;
    public static final int SURGE_ACC_RATE_SD = 451;
    public static final int SWAY_ACC_RATE_SD = 452;
    public static final int VERTICAL_REF = 453;
    public static final int VERTICAL_REF_SD = 454;
    public static final int XV1_ANGLE = 455;
    public static final int XV2_ANGLE = 456;
    public static final int XV3_ANGLE = 457;
    public static final int XV1_VELOCITY = 458;
    public static final int XV2_VELOCITY = 459;
    public static final int XV3_VELOCITY = 460;
    public static final int YAW_RATE = 461;
    public static final int YAW_RATE_SD = 462;
    public static final int XV1_ROT_RATE_NO_COMP = 463;
    public static final int XV2_ROT_RATE_NO_COMP = 464;
    public static final int XV3_ROT_RATE_NO_COMP = 465;
    public static final int XV1_ACC_NO_COMP = 466;
    public static final int XV2_ACC_NO_COMP = 467;
    public static final int XV3_ACC_NO_COMP = 468;
    public static final int MEAN_ACC_FOG_TEMPERATURE = 469;
    public static final int VTG1_DATA_VALIDITY_TIME = 470;
    public static final int VTG1_ID = 471;
    public static final int VTG1_TRUE_COURSE = 472;
    public static final int VTG1_MAGNETIC_COURSE = 473;
    public static final int VTG1_SPEED_OVER_GROUND = 474;
    public static final int VTG2_DATA_VALIDITY_TIME = 475;
    public static final int VTG2_ID = 476;
    public static final int VTG2_TRUE_COURSE = 477;
    public static final int VTG2_MAGNETIC_COURSE = 478;
    public static final int VTG2_SPEED_OVER_GROUND = 479;
    public static final int LOGBOOK_DATA_VALIDITY_TIME = 480;
    public static final int LOGBOOK_ID = 481;
    public static final int LOGBOOK_MESSAGE = 482;
    public static final int XV1_ACC_SYS = 483;
    public static final int XV2_ACC_SYS = 484;
    public static final int XV3_ACC_SYS = 485;
    public static final int XV1_ROT_RATE_SYS = 486;
    public static final int XV2_ROT_RATE_SYS = 487;
    public static final int XV3_ROT_RATE_SYS = 488;
    public static final int SYSTEM_STATUS_1 = 600;
    public static final int SYSTEM_STATUS_2 = 601;
    public static final int SYSTEM_STATUS_3 = 602;
    public static final int SENSOR_STATUS_1 = 603;
    public static final int SENSOR_STATUS_2 = 604;
    public static final int SENSOR_STATUS_3 = 605;
    public static final int ALGO_STATUS_1 = 606;
    public static final int ALGO_STATUS_2 = 607;
    public static final int ALGO_STATUS_3 = 608;
    public static final int ALGO_STATUS_4 = 609;
    public static final int USER_STATUS = 610;
    public static final int ALGO_STATUS_5 = 611;
    public static final int ALGO_STATUS_6 = 612;
    public static final int CDAT_TIME_FRACTION = 700;
    public static final int CDAT_TX_COUNTER = 701;
    public static final int CDAT_INS_ID = 702;
    public static final int CDAT_TIME_TRANSMIT = 704;
    public static final int CDAT_TIME_LAST_FIX = 705;
    public static final int CDAT_SOURCE_LAST_FIX = 706;
    public static final int CDAT_ATTITUDE_AGE = 707;
    public static final int CDAT_HEADER_1 = 708;
    public static final int CDAT_HEADER_2 = 709;
    public static final int CDAT_VERSION = 710;
    public static final int CDAT_TELEGRAM_SIZE = 711;
    public static final int CDAT_NAV_BITMASK = 712;
    public static final int CDAT_EXTNAV_BITMASK = 713;
    public static final int CDAT_EXT_BITMASK = 714;
    public static final int CDAT_EVTA_ID = 715;
    public static final int CDAT_EVTA_VALIDITY_TIME = 716;
    public static final int CDAT_EVTA_COUNT = 717;
    public static final int CDAT_EVTB_ID = 718;
    public static final int CDAT_EVTB_VALIDITY_TIME = 719;
    public static final int CDAT_EVTB_COUNT = 720;
    public static final int CDAT_EVTC_ID = 721;
    public static final int CDAT_EVTC_VALIDITY_TIME = 722;
    public static final int CDAT_EVTC_COUNT = 723;
    public static final int CDAT_CHECKSUM = 724;
    public static final int CDAT_HORIZACC = 725;
    public static final int CDAT_HDOP_TOGPS_QUALITY = 726;
    public static final int CDAT_NBSAT = 727;
    public static final int CDAT_HDOP = 728;
    public static final int CDAT_UTM_ZONE_NUMBER = 729;
    public static final int CDAT_UTM_ZONE_LETTER = 730;
    public static final int CDAT_UTM_EASTING = 731;
    public static final int CDAT_UTM_NORTHING = 732;
    public static final int CDAT_UTM_ALTITUDE = 733;
    public static final int CDAT_DSTTRV = 734;
    public static final int CDAT_HT_STS = 735;
    public static final int CDAT_LATENCY = 736;
    public static final int CDAT_HPOS_SD = 737;
    public static final int CDAT_UPS_NORTHING = 738;
    public static final int CDAT_UPS_EASTING = 739;
    public static final int CDAT_UPS_ALTITUDE = 740;
    public static final int CDAT_UPS_ZONE_LETTER = 741;
    public static final int CDAT_UPS_GRID_LETTER1 = 742;
    public static final int CDAT_UPS_GRID_LETTER2 = 743;
    public static final int CDAT_UPT_LATITUDE = 744;
    public static final int CDAT_UPT_LONGITUDE = 745;
    public static final int CDAT_UPT_ALTITUDE = 746;
    public static final int CDAT_BNG_NORTHING = 747;
    public static final int CDAT_BNG_EASTING = 748;
    public static final int CDAT_BNG_ALTITUDE = 749;
    public static final int CDAT_BNG_500KM_GRID_LETTER = 750;
    public static final int CDAT_BNG_100KM_GRID_LETTER = 751;
    public static final int CDAT_MGRS_NORTHING = 752;
    public static final int CDAT_MGRS_EASTING = 753;
    public static final int CDAT_MGRS_ALTITUDE = 754;
    public static final int CDAT_MGRS_GRID_ZONE_NUMBER = 755;
    public static final int CDAT_MGRS_GRID_ZONE_LETTER = 756;
    public static final int CDAT_MGRS_SQUARE_COLUMN = 757;
    public static final int CDAT_GEOREF_NORTHING = 758;
    public static final int CDAT_GEOREF_EASTING = 759;
    public static final int CDAT_GEOREF_ALTITUDE = 760;
    public static final int CDAT_GEOREF_15DEG_LONGITUDE_LETTER = 761;
    public static final int CDAT_GEOREF_15DEG_LATITUDE_LETTER = 762;
    public static final int CDAT_GEOREF_1DEG_LONGITUDE_LETTER = 763;
    public static final int CDAT_GEOREF_1DEG_LATITUDE_LETTER = 764;
    public static final int CDAT_ECEF_X = 765;
    public static final int CDAT_ECEF_Y = 766;
    public static final int CDAT_ECEF_Z = 767;
    public static final int CDAT_ELAPSED_TIME = 768;
    public static final int CDAT_GPS_NBSAT = 769;
    public static final int CDAT_GPS_HDOP = 770;
    public static final int CDAT_GPS_VALIDITY = 771;
    public static final int CDAT_GPS_MODE = 772;
    public static final int CDAT_ANSTO_CDICMD = 773;
    public static final int CDAT_CDICMD = 774;
    public static final int CDAT_CDIDATA = 775;
    public static final int CDAT_UPDATE_CMDANS = 776;
    public static final int CDAT_MODE_CMDANS = 777;
    public static final int CDAT_TIME_STAMP = 778;
    public static final int EXT_POS_CONVENTION = 779;
    public static final int EXT_POS_VALIDITY = 780;
    public static final int CDAT_UTM_FIELD_F = 781;
    public static final int CDAT_UTM_FIELD_G = 782;
    public static final int CDAT_UPS_FIELD_G = 783;
    public static final int CDAT_UPT_FIELD_D = 784;
    public static final int CDAT_UPT_FIELD_E = 785;
    public static final int CDAT_UPT_FIELD_F = 786;
    public static final int CDAT_UPT_FIELD_G = 787;
    public static final int CDAT_BNG_FIELD_F = 788;
    public static final int CDAT_BNG_FIELD_G = 789;
    public static final int CDAT_MGRS_SQUARE_ROW = 790;
    public static final int CDAT_ECEF_FIELD_D = 791;
    public static final int CDAT_ECEF_FIELD_E = 792;
    public static final int CDAT_ECEF_FIELD_F = 793;
    public static final int CDAT_ECEF_FIELD_G = 794;
    public static final int CSTA_A = 1000;
    public static final int CSTA_B = 1001;
    public static final int CSTA_FG = 1002;
    public static final int CSTA_ALIGNMENT = 1003;
    public static final int CSTA_SIMULATION = 1004;
    public static final int CSTA_POSITION = 1005;
    public static final int CSTA_SPEED = 1006;
    public static final int CSTA_SPEEDWT = 1007;
    public static final int CSTA_ATTITUDE = 1008;
    public static final int CSTA_DEPTH = 1009;
    public static final int CSTA_ALTITUDE = 1010;
    public static final int CSTA_ATTITUDE_SD = 1011;
    public static final int CSTA_SPEED_SD = 1012;
    public static final int CSTA_POSITION_SD = 1013;
    public static final int CSTA_ALTITUDE_SD = 1014;
    public static final int CSTA_POLAR_POSITION = 1015;
    public static final int CSTA_POLAR_ATTITUDE = 1016;
    public static final int CSTA_POLAR_ATTITUDE_RATE = 1017;
    public static final int CSTA_POLAR_SPEED = 1018;
    public static final int CSTA_WARNING = 1019;
    public static final int CSTA_ALARM = 1020;
    public static final int CSTA_MALFUNCTION = 1021;
    public static final int CSTA_FAIL = 1022;
    public static final int CSTA_BITE = 1023;
    public static final int CSTA_MODE = 1024;
    public static final int CSTA_HRPVAL = 1025;
    public static final int CSTA_GPSTIMEVAL = 1026;
    public static final int CSTA_NAVIGATION = 1027;
    public static final int CSTA_IPADDRESS = 1028;
    public static final int CSTA_UTCTIME = 1029;
    public static final int CSTA_HEAVE = 1030;
    public static final int CSTA_SENSOR_LIST = 1031;
    public static final int CSTA_SENSOR_OPTNAV = 1032;

    public LogInfo() {
        this.prefs = Preferences.userRoot().node("ixblue/loggerdecoder");
        int FlowTypeDft = this.prefs.getInt(REG_FLOWTYPE, 0);
        this.SetFlowType(FlowTypeDft);
        this.SetProtocol(this.prefs.getInt(REG_PROTO, 0), "None");
        this.SetFrequency(this.prefs.getInt(REG_FREQUENCY, 200));
        this.SetInputFile("");
        int EthConnTypeDft = this.prefs.getInt(REG_ETHCONNTYPE, 0);
        String IpAdressDft = this.prefs.get(REG_IPADRESS, "192.168.36.122");
        String IpPortDft = this.prefs.get(REG_IPPORT, "8115");
        this.SetEthernetParam(EthConnTypeDft, IpAdressDft, IpPortDft);
        int BaudrateDft = this.prefs.getInt(REG_BAUDRATE, 4);
        int DataBitsDft = this.prefs.getInt(REG_DATABITS, 1);
        int ParityDft = this.prefs.getInt(REG_PARITY, 0);
        int StopBitDft = this.prefs.getInt(REG_STOPBITS, 0);
        this.SetSerialParam("COM1", BaudrateDft, DataBitsDft, ParityDft, StopBitDft);
        this.SetLogParam(0, false, 0, 0, 0, 0, 0, "");
        this.SetLogParam(1, false, 0, 0, 0, 0, 0, "");
        this.SetWorkDirectory(this.prefs.get(REG_DIRECTORY, "C:\\"));
        this.SetSeparator(this.prefs.get(REG_SEPARATOR, ","));
        for (int DataType = 0; DataType < 7; ++DataType) {
            this.SetPrecisionWithDataType(DataType, this.prefs.getInt(REG_PRES_ + Integer.toString(DataType), 3));
        }
    }

    public void SetFlowType(int FlowType) {
        this.FlowType = FlowType;
        this.prefs.putInt(REG_FLOWTYPE, FlowType);
    }

    public int GetFlowType() {
        return this.FlowType;
    }

    public void SetFrequency(double _Frequency) {
        this.Frequency = (int)_Frequency;
        this.prefs.putInt(REG_FREQUENCY, (int)_Frequency);
    }

    public double GetFrequency() {
        return this.Frequency;
    }

    public void SetProtocol(int Protocol_Id, String Protocol_Name) {
        this.Protocol_Id = Protocol_Id;
        this.Protocol_Name = Protocol_Name;
        this.prefs.putInt(REG_PROTO, Protocol_Id);
    }

    public int GetProtocolId() {
        return this.Protocol_Id;
    }

    public String GetProtocolName() {
        return this.Protocol_Name;
    }

    public void SetInputFile(String InputFile) {
        this.InputFile = this.ModifyFileName(InputFile);
    }

    public String GetInputFileName() {
        return this.InputFile;
    }

    public String GetReducedInputFileName(int MaxLenght) {
        return this.ReducedFileName(this.InputFile, MaxLenght);
    }

    public void SetEthernetParam(int EthConnType, String IPAdress, String IPPort) {
        this.EthConnType = EthConnType;
        this.IPAdress = IPAdress;
        this.IPPort = IPPort;
        this.prefs.putInt(REG_ETHCONNTYPE, EthConnType);
        this.prefs.put(REG_IPADRESS, IPAdress);
        this.prefs.put(REG_IPPORT, IPPort);
    }

    public int GetEthernetConnType() {
        return this.EthConnType;
    }

    public String GetEthernetIPAdress() {
        return this.IPAdress;
    }

    public String GetEthernetIPPort() {
        return this.IPPort;
    }

    public void SetSerialParam(String RSPort, int Baudrate, int DataBits, int Parity, int StopBits) {
        this.RSPort = RSPort;
        this.Baudrate_Id = Baudrate;
        this.Databits_Id = DataBits;
        this.Parity_Id = Parity;
        this.StopBits_Id = StopBits;
        this.prefs.putInt(REG_BAUDRATE, Baudrate);
        this.prefs.putInt(REG_DATABITS, DataBits);
        this.prefs.putInt(REG_PARITY, Parity);
        this.prefs.putInt(REG_STOPBITS, StopBits);
    }

    public String GetSerialPort() {
        return this.RSPort;
    }

    public int GetBaudrate() {
        return this.Baudrate_Id;
    }

    public int GetDataBits() {
        return this.Databits_Id;
    }

    public int GetParity() {
        return this.Parity_Id;
    }

    public int GetStopBits() {
        return this.StopBits_Id;
    }

    public void SetLogParam(int LogType, boolean LogEnable) {
        this.LogFileEnable[LogType] = LogEnable;
        this.LogSegType[LogType] = 0;
        this.LogSegParam[LogType] = 0;
        this.LogDecimType[LogType] = 0;
        this.LogDecimFreq[LogType] = 0;
        this.LogDecimRatio[LogType] = 0;
        this.LogFileName[LogType] = "";
    }

    public void SetLogParam(int LogType, boolean LogEnable, int LogSegmentType, int LogSegParam, int LogDecimType, int LogDecimFreq, int LogDecimRatio, String LogFile) {
        this.LogFileEnable[LogType] = LogEnable;
        this.LogSegType[LogType] = LogSegmentType;
        this.LogSegParam[LogType] = LogSegParam;
        this.LogDecimType[LogType] = LogDecimType;
        this.LogDecimFreq[LogType] = LogDecimFreq;
        this.LogDecimRatio[LogType] = LogDecimRatio;
        this.LogFileName[LogType] = this.ModifyFileName(LogFile);
    }

    public boolean IsInputLogEnable(int LogType) {
        if (!this.LogFileEnable[LogType]) {
            return false;
        }
        return this.LogFileName[LogType].toLowerCase().contains(".txt") || this.LogFileName[LogType].toLowerCase().contains(".log");
    }

    public int GetLogSegmentType(int LogType) {
        if (this.LogSegParam[LogType] == 0) {
            return 0;
        }
        return this.LogSegType[LogType];
    }

    public int GetLogSegmentParam(int LogType) {
        if (this.LogSegType[LogType] == 0) {
            return 0;
        }
        return this.LogSegParam[LogType];
    }

    public int GetLogSegmentSize(int LogType) {
        if (this.GetLogSegmentType(LogType) == 2) {
            return this.GetLogSegmentParam(LogType);
        }
        return 0;
    }

    public int GetLogSegmentTime(int LogType) {
        if (this.GetLogSegmentType(LogType) == 1) {
            return this.GetLogSegmentParam(LogType);
        }
        return 0;
    }

    public int GetLogDecimType(int LogType) {
        return this.LogDecimType[LogType];
    }

    public int GetLogDecimFreqInd(int LogType) {
        if (this.LogDecimType[LogType] != 1) {
            return 0;
        }
        return this.LogDecimFreq[LogType];
    }

    public int GetLogDecimFreqValue(int LogType) {
        if (this.LogDecimType[LogType] != 1) {
            return 0;
        }
        switch (this.LogDecimFreq[LogType]) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 10;
            }
            case 4: {
                return 20;
            }
            case 5: {
                return 50;
            }
            case 6: {
                return 100;
            }
        }
        return 0;
    }

    public int GetLogDecimRatioInd(int LogType) {
        if (this.LogDecimType[LogType] != 2) {
            return 0;
        }
        return this.LogDecimRatio[LogType];
    }

    public int GetLogDecimRatioValue(int LogType) {
        if (this.LogDecimType[LogType] != 2) {
            return 0;
        }
        switch (this.LogDecimRatio[LogType]) {
            case 0: {
                return 2;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 10;
            }
            case 4: {
                return 20;
            }
            case 5: {
                return 50;
            }
            case 6: {
                return 100;
            }
            case 7: {
                return 127;
            }
        }
        return 0;
    }

    public String GetLogFileName(int LogType) {
        return this.LogFileName[LogType];
    }

    public String GetReducedFileName(int LogType, int MaxLenght) {
        return this.ReducedFileName(this.LogFileName[LogType], MaxLenght);
    }

    public void SetPrecisionWithDataType(int _data_type, int _precision) {
        this.prefs.putInt(REG_PRES_ + Integer.toString(_data_type), _precision);
        this.Precisions[_data_type] = _precision;
    }

    public int GetPrecisionWithDataType(int _data_type) {
        return this.Precisions[_data_type];
    }

    public int GetPrecisionWithDataId(int _data_id) {
        return this.Precisions[this.Get_DataType_From_DataId(_data_id)];
    }

    public void SetSeparator(String _separator) {
        this.prefs.put(REG_SEPARATOR, _separator);
        this.separator = _separator;
    }

    public String GetSeparator() {
        return this.separator;
    }

    private int Get_DataType_From_DataId(int _DataId) {
        switch (_DataId) {
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 258: {
                return 1;
            }
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                return 2;
            }
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 144: 
            case 145: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 162: 
            case 163: 
            case 164: 
            case 173: 
            case 174: 
            case 175: 
            case 184: 
            case 185: 
            case 186: 
            case 246: 
            case 247: 
            case 265: 
            case 266: 
            case 267: {
                return 3;
            }
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 152: 
            case 153: 
            case 154: 
            case 212: 
            case 213: 
            case 214: 
            case 221: 
            case 222: 
            case 223: 
            case 241: 
            case 242: 
            case 278: 
            case 279: 
            case 280: 
            case 287: 
            case 288: 
            case 289: {
                return 4;
            }
            case 118: 
            case 119: 
            case 120: 
            case 262: 
            case 263: 
            case 264: 
            case 309: 
            case 310: 
            case 311: {
                return 5;
            }
            case 312: 
            case 313: 
            case 314: {
                return 6;
            }
        }
        return 0;
    }

    public void SetWorkDirectory(String Rep) {
        this.WorkingDirectory = Rep;
        this.prefs.put(REG_DIRECTORY, Rep);
    }

    public String GetWorkDirectory() {
        return this.WorkingDirectory;
    }

    public void setRevision(String Revision) {
        this.Revision = Revision;
    }

    public void setRevisionDate(String RevisionDate) {
        this.RevisionDate = RevisionDate;
    }

    public String getRevision() {
        return this.Revision;
    }

    public String getRevisionDate() {
        return this.RevisionDate;
    }

    public String ModifyFileName(String FileName) {
        String _FileName = FileName;
        if (_FileName.compareTo("") == 0) {
            return "";
        }
        if (!_FileName.contains(":\\")) {
            _FileName = "C:\\" + _FileName;
        }
        if (_FileName.lastIndexOf(".") < 0) {
            _FileName = _FileName + ".log";
        }
        return _FileName;
    }

    private String ReducedFileName(String FileName, int MaxLenght) {
        String _FullFileName = FileName;
        String _FileName = "";
        String _Extension = "";
        if (_FullFileName.compareTo("") == 0) {
            return "";
        }
        String[] slash_tab = _FullFileName.replace("\\", "/").split("/");
        _FileName = slash_tab[slash_tab.length - 1];
        _Extension = _FileName.substring(_FileName.lastIndexOf("."), _FileName.length());
        _FileName = (_FileName = _FileName.substring(0, _FileName.lastIndexOf("."))).length() > MaxLenght ? _FileName.substring(0, MaxLenght) + "_.._" + _Extension : _FileName + _Extension;
        return slash_tab[0] + "\\...\\" + _FileName;
    }
}

