/*
 * Decompiled with CFR 0.152.
 */
package LoggerDecoder;

import Display.LoggerDisplay;
import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.FlowReadManager;
import LoggerDecoder.LightPanel;
import LoggerDecoder.LogInfo;
import Protocols.ADVANS_NAV_IMU_Decoder;
import Protocols.AIPOV_Decoder;
import Protocols.ANSCHUTZ_STD20_Decoder;
import Protocols.ATLAS_F20_decoder;
import Protocols.AUVG3000_Decoder;
import Protocols.BHO_GRAVI_Decoder;
import Protocols.BUC_Decoder;
import Protocols.CONTROL_Decoder;
import Protocols.CONTROL_NO_G_Decoder;
import Protocols.DCN_FAA_Decoder;
import Protocols.DCN_NAV1_Fxx_Decoder;
import Protocols.DCN_STD_LOCH_Decoder;
import Protocols.DCN_STD_NAV10_Decoder;
import Protocols.DOLOG_HRP_Decoder;
import Protocols.EMT_SDV_CGS_Decoder;
import Protocols.FOG_HAUTE_VITESSE;
import Protocols.GAPS_BIN_Decoder;
import Protocols.GENERIC_ASCII_Decoder;
import Protocols.HALLIBURTON_SAS_Decoder;
import Protocols.HDMS_Decoder;
import Protocols.HEAVE_POSTPRO_Decoder;
import Protocols.HEHDT_Decoder;
import Protocols.HEHDT_FIXED_Decoder;
import Protocols.HEHDT_HEROT_Decoder;
import Protocols.HYDROGRAPHY_Decoder;
import Protocols.IFREMER_VICTOR_Decoder;
import Protocols.IMU_BINARY_Decoder;
import Protocols.IMU_BIN_EXT_Decoder;
import Protocols.IMU_INCSYS_Decoder;
import Protocols.IMU_RAW_DATA_Decoder;
import Protocols.IMU_RD_Decoder;
import Protocols.IMU_SYS_FLOAT_Decoder;
import Protocols.IMU_SYS_INTEGER_Decoder;
import Protocols.INDYN_Decoder;
import Protocols.INSITU_Decoder;
import Protocols.INS_STD_NMEA_Decoder;
import Protocols.IXBLUE_STD_BIN_Decoder;
import Protocols.IXBLUE_STD_BIN_HP_Decoder;
import Protocols.IXSEA_TAH_Decoder;
import Protocols.KINETIC_SCIENTIFIC_Decoder;
import Protocols.KM_BINARY_Decoder;
import Protocols.LM_NAV_Decoder;
import Protocols.LODESTAR_Msg02_Decoder;
import Protocols.LODESTAR_Msg03_Decoder;
import Protocols.LODESTAR_Msg04_Decoder;
import Protocols.LONG_BINARY_NAV_Decoder;
import Protocols.LONG_BIN_NAV_HR_2_Decoder;
import Protocols.LONG_BIN_NAV_HR_Decoder;
import Protocols.LONG_BIN_NAV_SM_Decoder;
import Protocols.LRS100_32_IC_Decoder;
import Protocols.LRS100_32_IIC_Decoder;
import Protocols.LRS100_35_IC_Decoder;
import Protocols.LRS100_35_IIC_Decoder;
import Protocols.LRS10_78_IC_Decoder;
import Protocols.LRS10_78_IIC_Decoder;
import Protocols.MDL2_Decoder;
import Protocols.MDL_TRIM_CUBE_Decoder;
import Protocols.MINIFOG_OTG_MSG8_Decoder;
import Protocols.NAVIGATION_HDLC_Decoder;
import Protocols.NAVIGATION_LONG_Decoder;
import Protocols.NAV_BINARY_1_Decoder;
import Protocols.NAV_BINARY_Decoder;
import Protocols.NAV_BINARY_HR_Decoder;
import Protocols.OCTANS_STANDARD_Decoder;
import Protocols.PEGASE_CMS_Decoder;
import Protocols.PEGASE_NAV_Decoder;
import Protocols.PHINS_STD_LIGHT_Decoder;
import Protocols.PH_STD_BIAIS_EXTRACT_Decoder;
import Protocols.POLAR_NAV_Decoder;
import Protocols.POSTPROCESSING_Decoder;
import Protocols.POS_MV_GROUP111_Decoder;
import Protocols.PP_Decoder;
import Protocols.PRDID_Decoder;
import Protocols.PROTOCOL_NONE_Decoder;
import Protocols.PTNL_GGK_Decoder;
import Protocols.Protocols_List;
import Protocols.RDI_PD4_Decoder;
import Protocols.RSTA_RCS_Decoder;
import Protocols.RTCM_SIX_Decoder;
import Protocols.S40_NAV100_Decoder;
import Protocols.S40_NAV10_Decoder;
import Protocols.SAS2_Decoder;
import Protocols.SEANAV_ID1_Decoder;
import Protocols.SEAPATH_Decoder;
import Protocols.SEATEX_DHEAVE_Decoder;
import Protocols.SENSOR_RD_Decoder;
import Protocols.SIGRS1_Decoder;
import Protocols.SIGRS4_Decoder;
import Protocols.SIMRAD_EM_Decoder;
import Protocols.SIMRAD_EM_HEAVE2_Decoder;
import Protocols.SIMRAD_EM_TSS_Decoder;
import Protocols.SOC_AUTOSUB_Decoder;
import Protocols.SPERRY_ATT_Decoder;
import Protocols.SPERRY_ATT_STAN_Decoder;
import Protocols.SPERRY_STD_BIN_Decoder;
import Protocols.STANDARD_2_Decoder;
import Protocols.STOLT_OFFSHORE_Decoder;
import Protocols.TAH_BIN_SMT_Decoder;
import Protocols.TECHSAS_Decoder;
import Protocols.TMS_CCV_IMBAT_Decoder;
import Protocols.TRS_AHRS_Decoder;
import Protocols.TSS1_DMS_Decoder;
import Protocols.TSS335B_Decoder;
import Protocols.TUS_Decoder;
import Protocols.Units_List;
import Protocols.XC_ACC_IMU50_Decoder;
import Protocols.XC_ACC_INC_SRC_Decoder;
import Protocols.XC_FOG_IMU50_Decoder;
import Protocols.XC_FOG_INC_SRC_Decoder;
import Protocols.XC_FOG_RAW_DATA_Decoder;
import Protocols.XC_IMU_AVG_POSTPRO_Decoder;
import Protocols.XC_IMU_POSTPRO_Decoder;
import Protocols.XC_POSTPROINCSYS_Decoder;
import Protocols.XC_PPINCSYS2_Decoder;
import Tools.JTextFieldFilter;
import Tools.JTxtFileFilter;
import Tools.jFreeChart_XY;
import gnu.io.CommPortIdentifier;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Calendar;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class LoggerDecoderFrame
extends JFrame {
    private static FlowReadManager Manager = null;
    public LoggerDisplay Display = null;
    public LightPanel Light = null;
    private LogInfo Info;
    private Encoder Encod = null;
    private Units_List units_List = null;
    public static boolean FrameReady = false;
    public static Protocols_List Proto_List;
    public static Boolean IsConnected;
    public static Boolean IsLogging;
    public static Boolean IsStdDecoding;
    Boolean IsViewing = false;
    int PaneIndexPrec = 0;
    public static final int NB_MAX_PROTOCOLS = 150;
    public static final int TAB_INPUTFLOW_IND = 0;
    public static final int TAB_OUTPUTFLOW_IND = 1;
    public static final int TAB_DECODPARAMS_IND = 2;
    public static final int TAB_VIEW_IND = 3;
    public static final int TAB_CURVES_TRACER_IND = 4;
    public static final int TAB_CURVES_INTERFACE_IND = 5;
    public static final boolean START = true;
    public static final boolean STOP = false;
    public static final int MESSAGE_CONNECTION = 0;
    public static final int MESSAGE_INPUT = 1;
    public static final int MESSAGE_LOG = 2;
    public static final int MESSAGE_DECOD = 3;
    public static final int USER = 0;
    public static final int MANAGER = 1;
    public static boolean trace_start;
    public static boolean automatic_scale;
    public static boolean automatic_scale_X;
    public static boolean first_use;
    private boolean Curve_Param_Changing = false;
    public static int curves_count;
    public static int fenetre;
    private JButton jButton1;
    public static JButton jButton_Connect;
    public static JButton jButton_Curves_Reinit;
    public static JButton jButton_Log;
    public static JButton jButton_SelectInputFile;
    public static JButton jButton_SelectLogDecod;
    public static JButton jButton_SelectLogInput;
    public static JButton jButton_View;
    public static JCheckBox jCheckBox_Automatic_Scale;
    private JCheckBox jCheckBox_Automatic_Scale_X;
    public static JCheckBox jCheckBox_LogDecod;
    public static JCheckBox jCheckBox_LogInput;
    public static JCheckBox jCheckBox_NormalizedDatas;
    public static JCheckBox jCheckBox_glissant;
    public static final JComboBox<String> jComboBoxBoardType;
    public static JComboBox jComboBox_Baudrate;
    public static JComboBox jComboBox_ConnectionType;
    public static JComboBox jComboBox_Curve_Param;
    public static JComboBox jComboBox_Curve_Param_abscisse;
    public static JComboBox jComboBox_DataBits;
    public static JComboBox jComboBox_DecodLog_DecimType;
    public static JComboBox jComboBox_DecodLog_DecimVal;
    public static JComboBox jComboBox_FlowType;
    public static JComboBox jComboBox_InputLog_DecimType;
    public static JComboBox jComboBox_InputLog_DecimVal;
    public static JComboBox jComboBox_LogDecodSegType;
    public static JComboBox jComboBox_LogInputSegType;
    public static JComboBox jComboBox_Parity;
    public static JComboBox jComboBox_Port;
    public static JComboBox jComboBox_Protocol;
    public static JComboBox jComboBox_SelectView;
    public static JComboBox jComboBox_StopBits;
    public static JComboBox jComboBox_X_units;
    public static JComboBox jComboBox_Y_units;
    private JLabel jLabel1;
    private JLabel jLabel10;
    public static JLabel jLabel11;
    private JLabel jLabel12;
    public static JLabel jLabel13;
    private JLabel jLabel14;
    public static JLabel jLabel15;
    private JLabel jLabel16;
    public static JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    public static JLabel jLabel20;
    public static JLabel jLabel21;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    public static JLabel jLabel7;
    private JLabel jLabel8;
    public static JLabel jLabel9;
    private JLabel jLabelBoardType;
    public static JLabel jLabel_Baudrate;
    public static JLabel jLabel_ConnState;
    public static JLabel jLabel_ConnectionType;
    public static JLabel jLabel_Databits;
    public static JLabel jLabel_DecodLogFMax;
    public static JLabel jLabel_DecodLogSegParam;
    public static JLabel jLabel_DecodState;
    public static JLabel jLabel_IPAdress;
    private JLabel jLabel_Info1;
    private JLabel jLabel_Info2;
    private JLabel jLabel_Info3;
    private JLabel jLabel_Info4;
    public static JLabel jLabel_InfoConnectiontype;
    public static JLabel jLabel_InfoDecodLog;
    public static JLabel jLabel_InfoInputLog;
    public static JLabel jLabel_InfoProtocol;
    public static JLabel jLabel_InputFile;
    public static JLabel jLabel_InputLogDecim;
    public static JLabel jLabel_InputLogSegParam;
    public static JLabel jLabel_InputState;
    public static JLabel jLabel_InputStateId;
    public static JLabel jLabel_LogState;
    public static JLabel jLabel_Name_Protocole;
    public static JLabel jLabel_P1;
    public static JLabel jLabel_P2;
    public static JLabel jLabel_P3;
    public static JLabel jLabel_Parity;
    public static JLabel jLabel_PortIP;
    public static JLabel jLabel_PortRS;
    public static JLabel jLabel_SegDecod;
    public static JLabel jLabel_SegInput;
    public static JLabel jLabel_StopBits;
    private JLabel jLabel_X;
    private JLabel jLabel_Y;
    private JPanel jPanel1;
    private JPanel jPanel11;
    private JPanel jPanel12;
    private JPanel jPanel13;
    private JPanel jPanel14;
    private JPanel jPanel15;
    private JPanel jPanel16;
    private JPanel jPanel2;
    private JPanel jPanel3;
    public static JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    public static JPanel jPanel8;
    public static JPanel jPanel9;
    public static JPanel jPanel_Chart;
    public static JPanel jPanel_Curves_Interface;
    public static JPanel jPanel_DecodData;
    public static JPanel jPanel_DecoderViewer;
    public static JPanel jPanel_Ethernet;
    public static JPanel jPanel_File;
    public static JPanel jPanel_InputData;
    public static JPanel jPanel_Serial;
    public static JPanel jPanel_Voyants;
    private JScrollPane jScrollPane1;
    public static JTabbedPane jTabbedPane_Main;
    public static JTextArea jTextArea_Display;
    public static JTextField jTextField_ACCPrecision;
    public static JTextField jTextField_Fenetre;
    public static JTextField jTextField_File;
    public static JTextField jTextField_Frequency;
    public static JTextField jTextField_HRPPrecision;
    public static JTextField jTextField_HRPRatesPrecision;
    public static JTextField jTextField_IPAdress1;
    public static JTextField jTextField_IPAdress2;
    public static JTextField jTextField_IPAdress3;
    public static JTextField jTextField_IPAdress4;
    public static JTextField jTextField_IPPort;
    public static JTextField jTextField_LogDecod;
    public static JTextField jTextField_LogDecodSegParam;
    public static JTextField jTextField_LogInput;
    public static JTextField jTextField_LogInputSegParam;
    public static JTextField jTextField_PositionPrecision;
    public static JTextField jTextField_ROTPrecision;
    public static JTextField jTextField_Separator;
    public static JTextField jTextField_SpeedsPrecision;
    public static JTextField jTextField_Xmax;
    public static JTextField jTextField_Xmin;
    public static JTextField jTextField_Ymax;
    public static JTextField jTextField_Ymin;
    public static JTextField jTextField_substract_value;
    public static JToggleButton jToggleButton_Start;

    public LoggerDecoderFrame(String _Revision, String _Date) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initComponents();
        this.setTitle("iXBlue LoggerDecoder  Rev:" + _Revision);
        this.setIconImage(new ImageIcon("./images/chevron.png").getImage());
        this.setResizable(false);
        Toolkit kit = Toolkit.getDefaultToolkit();
        Dimension Screensize = kit.getScreenSize();
        this.setLocation(Screensize.width / 2 - this.getWidth() / 2, Screensize.height / 2 - this.getHeight() / 2 - 10);
        this.Encod = new Encoder();
        this.units_List = new Units_List();
        this.SetStandardDecoding(false);
        jTabbedPane_Main.setEnabledAt(4, false);
        jTabbedPane_Main.setEnabledAt(5, false);
        this.Info = new LogInfo();
        this.Info.setRevisionDate(_Date);
        this.Info.setRevision(_Revision);
        Proto_List = new Protocols_List(150);
        Proto_List.Add_Protocol("None", new PROTOCOL_NONE_Decoder(this.Encod));
        Proto_List.Add_Protocol("ADVANS_NAV_IMU", new ADVANS_NAV_IMU_Decoder(this.Encod));
        Proto_List.Add_Protocol("AHRS_S10", new TRS_AHRS_Decoder(this.Encod));
        Proto_List.Add_Protocol("AIPOV", new AIPOV_Decoder(this.Encod));
        Proto_List.Add_Protocol("ANSCHUTZ_STD20", new ANSCHUTZ_STD20_Decoder(this.Encod));
        Proto_List.Add_Protocol("ATLAS_F20", new ATLAS_F20_decoder(this.Encod));
        Proto_List.Add_Protocol("AUVG3000", new AUVG3000_Decoder(this.Encod));
        Proto_List.Add_Protocol("BHO_GRAVI", new BHO_GRAVI_Decoder(this.Encod));
        Proto_List.Add_Protocol("BUC", new BUC_Decoder(this.Encod));
        Proto_List.Add_Protocol("CONTROL", new CONTROL_Decoder(this.Encod));
        Proto_List.Add_Protocol("CONTROL_NO_G", new CONTROL_NO_G_Decoder(this.Encod));
        Proto_List.Add_Protocol("DCN_FAA", new DCN_FAA_Decoder(this.Encod));
        Proto_List.Add_Protocol("DCN_NAV1_Fxx", new DCN_NAV1_Fxx_Decoder(this.Encod));
        Proto_List.Add_Protocol("DCN_STD_NAV10", new DCN_STD_NAV10_Decoder(this.Encod));
        Proto_List.Add_Protocol("DCN_STD_LOCH", new DCN_STD_LOCH_Decoder(this.Encod));
        Proto_List.Add_Protocol("DOLOG_HRP", new DOLOG_HRP_Decoder(this.Encod));
        Proto_List.Add_Protocol("DORADO", new SOC_AUTOSUB_Decoder(this.Encod));
        Proto_List.Add_Protocol("DORADO_2", new SOC_AUTOSUB_Decoder(this.Encod));
        Proto_List.Add_Protocol("EMT_SDV_CGS", new EMT_SDV_CGS_Decoder(this.Encod));
        Proto_List.Add_Protocol("EXT_SENSOR_BIN", new SOC_AUTOSUB_Decoder(this.Encod));
        Proto_List.Add_Protocol("FOG HAUTE VITESSE", new FOG_HAUTE_VITESSE(this.Encod));
        Proto_List.Add_Protocol("GAPS_BIN", new GAPS_BIN_Decoder(this.Encod));
        Proto_List.Add_Protocol("GENERIC_ASCII", new GENERIC_ASCII_Decoder(this.Encod));
        Proto_List.Add_Protocol("GYROCOMPASS", new INS_STD_NMEA_Decoder(this.Encod));
        Proto_List.Add_Protocol("HALLIBURTON_SAS", new HALLIBURTON_SAS_Decoder(this.Encod));
        Proto_List.Add_Protocol("HDMS", new HDMS_Decoder(this.Encod));
        Proto_List.Add_Protocol("HEAVE_POSTPRO", new HEAVE_POSTPRO_Decoder(this.Encod));
        Proto_List.Add_Protocol("HEHDT", new HEHDT_Decoder(this.Encod));
        Proto_List.Add_Protocol("HEHDT_FIXED", new HEHDT_FIXED_Decoder(this.Encod));
        Proto_List.Add_Protocol("HEHDT_HEROT", new HEHDT_HEROT_Decoder(this.Encod));
        Proto_List.Add_Protocol("HYDROGRAPHY", new HYDROGRAPHY_Decoder(this.Encod));
        Proto_List.Add_Protocol("IFREMER_VICTOR", new IFREMER_VICTOR_Decoder(this.Encod));
        Proto_List.Add_Protocol("INDYN", new INDYN_Decoder(this.Encod));
        Proto_List.Add_Protocol("INSITU", new INSITU_Decoder(this.Encod));
        Proto_List.Add_Protocol("IMU_BINARY", new IMU_BINARY_Decoder(this.Encod));
        Proto_List.Add_Protocol("IMU_INCSYS", new IMU_INCSYS_Decoder(this.Encod));
        Proto_List.Add_Protocol("IMU_INCSYS_OUTPUT2", new IMU_INCSYS_Decoder(this.Encod));
        Proto_List.Add_Protocol("IMU_RAW_DATA", new IMU_RAW_DATA_Decoder(this.Encod));
        Proto_List.Add_Protocol("IMU_BIN_EXT", new IMU_BIN_EXT_Decoder(this.Encod));
        Proto_List.Add_Protocol("IMU_RD", new IMU_RD_Decoder(this.Encod));
        Proto_List.Add_Protocol("IMU_SYS_FLOAT", new IMU_SYS_FLOAT_Decoder(this.Encod));
        Proto_List.Add_Protocol("IMU_SYS_INTEGER", new IMU_SYS_INTEGER_Decoder(this.Encod));
        Proto_List.Add_Protocol("IXBLUE_STD_BIN", new IXBLUE_STD_BIN_Decoder(this.Encod));
        Proto_List.Add_Protocol("IXBLUE_STD_BIN_V2", new IXBLUE_STD_BIN_Decoder(this.Encod));
        Proto_List.Add_Protocol("IXBLUE_STD_BIN_V3", new IXBLUE_STD_BIN_Decoder(this.Encod));
        Proto_List.Add_Protocol("IXBLUE_STD_BIN_V4", new IXBLUE_STD_BIN_Decoder(this.Encod));
        Proto_List.Add_Protocol("IXBLUE_STD_BIN_V5", new IXBLUE_STD_BIN_Decoder(this.Encod));
        Proto_List.Add_Protocol("IXBLUE_STD_BIN_HP", new IXBLUE_STD_BIN_HP_Decoder(this.Encod));
        Proto_List.Add_Protocol("SPERRY_STD_BIN", new SPERRY_STD_BIN_Decoder(this.Encod));
        Proto_List.Add_Protocol("IXSEA_TAH", new IXSEA_TAH_Decoder(this.Encod));
        Proto_List.Add_Protocol("KINETIC_SCIENTIFIC", new KINETIC_SCIENTIFIC_Decoder(this.Encod));
        Proto_List.Add_Protocol("KM_BINARY", new KM_BINARY_Decoder(this.Encod));
        Proto_List.Add_Protocol("LANDINS_STANDARD", new INS_STD_NMEA_Decoder(this.Encod));
        Proto_List.Add_Protocol("LM_NAV", new LM_NAV_Decoder(this.Encod));
        Proto_List.Add_Protocol("LODESTAR_Msg02", new LODESTAR_Msg02_Decoder(this.Encod));
        Proto_List.Add_Protocol("LODESTAR_Msg03", new LODESTAR_Msg03_Decoder(this.Encod));
        Proto_List.Add_Protocol("LODESTAR_Msg04", new LODESTAR_Msg04_Decoder(this.Encod));
        Proto_List.Add_Protocol("LONG_BINARY_NAV", new LONG_BINARY_NAV_Decoder(this.Encod));
        Proto_List.Add_Protocol("LONG_BIN_NAV_HR", new LONG_BIN_NAV_HR_Decoder(this.Encod));
        Proto_List.Add_Protocol("LONG_BIN_NAV_HR_2", new LONG_BIN_NAV_HR_2_Decoder(this.Encod));
        Proto_List.Add_Protocol("LONG_BIN_NAV_SM", new LONG_BIN_NAV_SM_Decoder(this.Encod));
        Proto_List.Add_Protocol("LRS10_78_IC", new LRS10_78_IC_Decoder(this.Encod));
        Proto_List.Add_Protocol("LRS10_78_IIC", new LRS10_78_IIC_Decoder(this.Encod));
        Proto_List.Add_Protocol("LRS100_32_IC", new LRS100_32_IC_Decoder(this.Encod));
        Proto_List.Add_Protocol("LRS100_32_IIC", new LRS100_32_IIC_Decoder(this.Encod));
        Proto_List.Add_Protocol("LRS100_35_IC", new LRS100_35_IC_Decoder(this.Encod));
        Proto_List.Add_Protocol("LRS100_35_IIC", new LRS100_35_IIC_Decoder(this.Encod));
        Proto_List.Add_Protocol("MDL_TRIM_CUBE", new MDL_TRIM_CUBE_Decoder(this.Encod));
        Proto_List.Add_Protocol("MDL2", new MDL2_Decoder(this.Encod));
        Proto_List.Add_Protocol("MINIFOG_OTG_MSG8", new MINIFOG_OTG_MSG8_Decoder(this.Encod));
        Proto_List.Add_Protocol("NAV_BINARY", new NAV_BINARY_Decoder(this.Encod));
        Proto_List.Add_Protocol("NAV_BINARY_1", new NAV_BINARY_1_Decoder(this.Encod));
        Proto_List.Add_Protocol("NAV_BINARY_HR", new NAV_BINARY_HR_Decoder(this.Encod));
        Proto_List.Add_Protocol("NAVIGATION", new INS_STD_NMEA_Decoder(this.Encod));
        Proto_List.Add_Protocol("NAVIGATION_HDLC", new NAVIGATION_HDLC_Decoder(this.Encod));
        Proto_List.Add_Protocol("NAVIGATION_LONG", new NAVIGATION_LONG_Decoder(this.Encod));
        Proto_List.Add_Protocol("OCTANS_STANDARD", new OCTANS_STANDARD_Decoder(this.Encod));
        Proto_List.Add_Protocol("PEGASE_CMS", new PEGASE_CMS_Decoder(this.Encod));
        Proto_List.Add_Protocol("PEGASE_NAV", new PEGASE_NAV_Decoder(this.Encod));
        Proto_List.Add_Protocol("PHINS_STANDARD", new INS_STD_NMEA_Decoder(this.Encod));
        Proto_List.Add_Protocol("PHINS_STANDARD_LIGHT", new PHINS_STD_LIGHT_Decoder(this.Encod));
        Proto_List.Add_Protocol("PH_STD_BIAS_EXTRACT", new PH_STD_BIAIS_EXTRACT_Decoder(this.Encod));
        Proto_List.Add_Protocol("POLAR_NAV", new POLAR_NAV_Decoder(this.Encod));
        Proto_List.Add_Protocol("POS_MV_GROUP111", new POS_MV_GROUP111_Decoder(this.Encod));
        Proto_List.Add_Protocol("POSTPROCESSING_JBL", new POSTPROCESSING_Decoder(this.Encod));
        Proto_List.Add_Protocol("POSTPROCESSING (New Output format)", new PP_Decoder(this.Encod));
        Proto_List.Add_Protocol("PRDID", new PRDID_Decoder(this.Encod));
        Proto_List.Add_Protocol("PRDID_TSS", new PRDID_Decoder(this.Encod));
        Proto_List.Add_Protocol("PTNL_GGK", new PTNL_GGK_Decoder(this.Encod));
        Proto_List.Add_Protocol("RDI_PD4", new RDI_PD4_Decoder(this.Encod));
        Proto_List.Add_Protocol("RSTA_RCS", new RSTA_RCS_Decoder(this.Encod));
        Proto_List.Add_Protocol("RTCM_SIX", new RTCM_SIX_Decoder(this.Encod));
        Proto_List.Add_Protocol("SAS_2", new SAS2_Decoder(this.Encod));
        Proto_List.Add_Protocol("SEANAV_ID1", new SEANAV_ID1_Decoder(this.Encod));
        Proto_List.Add_Protocol("SEAPATH", new SEAPATH_Decoder(this.Encod));
        Proto_List.Add_Protocol("SEATEX_DHEAVE", new SEATEX_DHEAVE_Decoder(this.Encod));
        Proto_List.Add_Protocol("SENSOR_RD", new SENSOR_RD_Decoder(this.Encod));
        Proto_List.Add_Protocol("SIGRS1", new SIGRS1_Decoder(this.Encod));
        Proto_List.Add_Protocol("SIGRS4", new SIGRS4_Decoder(this.Encod));
        Proto_List.Add_Protocol("SIMRAD_EM", new SIMRAD_EM_Decoder(this.Encod));
        Proto_List.Add_Protocol("SIMRAD_EM_TSS", new SIMRAD_EM_TSS_Decoder(this.Encod));
        Proto_List.Add_Protocol("SIMRAD_EM_HEAVE2", new SIMRAD_EM_HEAVE2_Decoder(this.Encod));
        Proto_List.Add_Protocol("SOC_AUTOSUB", new SOC_AUTOSUB_Decoder(this.Encod));
        Proto_List.Add_Protocol("SPERRY_ATT", new SPERRY_ATT_Decoder(this.Encod));
        Proto_List.Add_Protocol("SPERRY_ATT_STAN", new SPERRY_ATT_STAN_Decoder(this.Encod));
        Proto_List.Add_Protocol("STANDARD_2", new STANDARD_2_Decoder(this.Encod));
        Proto_List.Add_Protocol("STOLT_OFFSHORE", new STOLT_OFFSHORE_Decoder(this.Encod));
        Proto_List.Add_Protocol("STOLT_OFFSHORE2", new STOLT_OFFSHORE_Decoder(this.Encod));
        Proto_List.Add_Protocol("S40_NAV10", new S40_NAV10_Decoder(this.Encod));
        Proto_List.Add_Protocol("S40_NAV100", new S40_NAV100_Decoder(this.Encod));
        Proto_List.Add_Protocol("TAH_BIN_SMT", new TAH_BIN_SMT_Decoder(this.Encod));
        Proto_List.Add_Protocol("TECHSAS", new TECHSAS_Decoder(this.Encod));
        Proto_List.Add_Protocol("TMS_CCV_IMBAT", new TMS_CCV_IMBAT_Decoder(this.Encod));
        Proto_List.Add_Protocol("TSS1_DMS", new TSS1_DMS_Decoder(this.Encod));
        Proto_List.Add_Protocol("TSS335B", new TSS335B_Decoder(this.Encod));
        Proto_List.Add_Protocol("TUS", new TUS_Decoder(this.Encod));
        Proto_List.Add_Protocol("XC_ACC_INC_SRC", new XC_ACC_INC_SRC_Decoder(this.Encod));
        Proto_List.Add_Protocol("XC_ACC_IMU50", new XC_ACC_IMU50_Decoder(this.Encod));
        Proto_List.Add_Protocol("XC_FOG_IMU50", new XC_FOG_IMU50_Decoder(this.Encod));
        Proto_List.Add_Protocol("XC_FOG_INC_SRC", new XC_FOG_INC_SRC_Decoder(this.Encod));
        Proto_List.Add_Protocol("XC_FOG_RAW_DATA", new XC_FOG_RAW_DATA_Decoder(this.Encod));
        Proto_List.Add_Protocol("XC_IMU_AVG_POSTPRO", new XC_IMU_AVG_POSTPRO_Decoder(this.Encod, this.Info));
        Proto_List.Add_Protocol("XC_IMU_POSTPRO", new XC_IMU_POSTPRO_Decoder(this.Encod, this.Info));
        Proto_List.Add_Protocol("XC_POSTPROINCSYS", new XC_POSTPROINCSYS_Decoder(this.Encod));
        Proto_List.Add_Protocol("XC_PPINCSYS2", new XC_PPINCSYS2_Decoder(this.Encod));
        this.Display = new LoggerDisplay(jTextArea_Display, 1000);
        this.Light = new LightPanel(jPanel_Voyants);
        Manager = new FlowReadManager(this.Info, this);
        Manager.start();
        this.Init_InputFlow_Interface();
        this.Init_OutputFlow_Interface();
        this.Init_DecodParams_Interface();
        this.UpdateLogggerDecoderParam();
        this.Update_ConnectButtonState();
        this.Update_LogButtonState();
        jTabbedPane_Main.setSelectedIndex(3);
        this.setDefaultCloseOperation(3);
    }

    public void SetStandardDecoding(boolean ed) {
        IsStdDecoding = ed;
    }

    public LoggerDecoderFrame(String _Revision, String _Date, String ProName, String InFile, String OutFile, boolean isStandardDecoding, String Frequency) {
        this(_Revision, _Date);
        System.out.println("Request of decoding. Please wait ...\n");
        this.UpdateSpecificDecoderParamDefault(_Revision, _Date);
        this.UpdateLogggerDecoderParamDefault(ProName, InFile, OutFile, Frequency);
        this.SetStandardDecoding(isStandardDecoding);
        this.Start_Logging();
        this.Start_Manager(0);
        Timer DecoderTimer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (!LoggerDecoderFrame.IsLogging()) {
                    System.out.println("\nDecoding ENDED.\n");
                    System.exit(0);
                }
            }
        });
        DecoderTimer.start();
    }

    public LoggerDecoderFrame(String _Revision, String _Date, String ProName, String Duration2, String LogFile, String Port, String Mode, String IPAddress) {
        this(_Revision, _Date);
        System.out.println("Request of recording during " + Duration2 + " seconds. Please wait ...\n");
        this.UpdateLogggerDecoderParamDefault(ProName, LogFile, Mode, IPAddress, Port);
        this.Log(Integer.parseInt(Duration2));
    }

    public LoggerDecoderFrame(String _Revision, String _Date, String ProName, String Duration2, String LogFile, String Port, String BaudRate, String DataBits, String Parity, String StopBits) {
        this(_Revision, _Date);
        System.out.println("Request of recording during " + Duration2 + " seconds. Please wait ...\n");
        this.UpdateLogggerDecoderParamDefault(ProName, LogFile, Port, BaudRate, DataBits, Parity, StopBits);
        this.Log(Integer.parseInt(Duration2));
    }

    public void Log(int LogTime) {
        this.Start_Logging();
        this.Start_Manager(0);
        Timer LoggerTimer = new Timer(LogTime * 1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                System.out.println("\nRecording ENDED.\n");
                System.exit(0);
            }
        });
        LoggerTimer.start();
    }

    void Init_InputFlow_Interface() {
        int Proto_Id = 0;
        while (Proto_List.IsAvailable(Proto_Id)) {
            jComboBox_Protocol.addItem(Proto_List.GetProtocolNameById(Proto_Id));
            ++Proto_Id;
        }
        this.SetjComboSelectedIndex(jComboBox_Protocol, this.Info.GetProtocolId());
        jComboBox_FlowType.addItem("None");
        jComboBox_FlowType.addItem("File Connection");
        jComboBox_FlowType.addItem("Ethernet Connection");
        jComboBox_FlowType.addItem("Serial Connection");
        this.SetjComboSelectedIndex(jComboBox_FlowType, this.Info.GetFlowType());
        jTextField_Frequency.setDocument(new JTextFieldFilter("0123456789", 3, 1000));
        jTextField_Frequency.setText(new Integer((int)this.Info.GetFrequency()).toString());
        jComboBox_ConnectionType.addItem("TCP Client");
        jComboBox_ConnectionType.addItem("TCP Serveur");
        jComboBox_ConnectionType.addItem("UDP");
        jComboBox_ConnectionType.addItem("UDP MultiCast");
        this.SetjComboSelectedIndex(jComboBox_ConnectionType, this.Info.GetEthernetConnType());
        jTextField_IPAdress1.setDocument(new JTextFieldFilter("0123456789", 3, 255));
        jTextField_IPAdress2.setDocument(new JTextFieldFilter("0123456789", 3, 255));
        jTextField_IPAdress3.setDocument(new JTextFieldFilter("0123456789", 3, 255));
        jTextField_IPAdress4.setDocument(new JTextFieldFilter("0123456789", 3, 255));
        String[] IP = this.Info.GetEthernetIPAdress().split("\\.");
        jTextField_IPAdress1.setText(IP[0]);
        jTextField_IPAdress2.setText(IP[1]);
        jTextField_IPAdress3.setText(IP[2]);
        jTextField_IPAdress4.setText(IP[3]);
        jTextField_IPPort.setDocument(new JTextFieldFilter("0123456789", 5, 65535));
        jTextField_IPPort.setText(this.Info.GetEthernetIPPort());
        int PortNumber = 0;
        Enumeration portList = CommPortIdentifier.getPortIdentifiers();
        while (portList.hasMoreElements()) {
            ++PortNumber;
            CommPortIdentifier Port_Dispo = (CommPortIdentifier)portList.nextElement();
            if (!Port_Dispo.getName().contains("COM")) continue;
            jComboBox_Port.addItem(Port_Dispo.getName());
        }
        if (PortNumber == 0 || jComboBox_Port.getItemCount() == 0) {
            jComboBox_Port.addItem("NONE");
        }
        jComboBox_Baudrate.addItem("600");
        jComboBox_Baudrate.addItem("1200");
        jComboBox_Baudrate.addItem("2400");
        jComboBox_Baudrate.addItem("4800");
        jComboBox_Baudrate.addItem("9600");
        jComboBox_Baudrate.addItem("19200");
        jComboBox_Baudrate.addItem("38400");
        jComboBox_Baudrate.addItem("57600");
        jComboBox_Baudrate.addItem("115200");
        jComboBox_Baudrate.addItem("230400");
        jComboBox_Baudrate.addItem("460800");
        jComboBox_Baudrate.addItem("921600");
        this.SetjComboSelectedIndex(jComboBox_Baudrate, this.Info.GetBaudrate());
        jComboBox_DataBits.addItem("7 bits");
        jComboBox_DataBits.addItem("8 bits");
        this.SetjComboSelectedIndex(jComboBox_DataBits, this.Info.GetDataBits());
        jComboBox_Parity.addItem("No Parity");
        jComboBox_Parity.addItem("Even");
        jComboBox_Parity.addItem("Odd");
        this.SetjComboSelectedIndex(jComboBox_Parity, this.Info.GetParity());
        jComboBox_StopBits.addItem("0 bit");
        jComboBox_StopBits.addItem("0.5 bit");
        jComboBox_StopBits.addItem("1 bit");
        jComboBox_StopBits.addItem("2 bits");
        this.SetjComboSelectedIndex(jComboBox_StopBits, this.Info.GetStopBits());
        this.Update_InputParam_Visibility();
    }

    void Init_OutputFlow_Interface() {
        jComboBox_LogInputSegType.addItem("None");
        jComboBox_LogInputSegType.addItem("Time (s)");
        jComboBox_LogInputSegType.addItem("Size (Mo)");
        jComboBox_LogInputSegType.setSelectedIndex(this.Info.GetLogSegmentType(0));
        jComboBox_LogDecodSegType.addItem("None");
        jComboBox_LogDecodSegType.addItem("Time (s)");
        jComboBox_LogDecodSegType.addItem("Size (Mo)");
        jComboBox_LogDecodSegType.setSelectedIndex(this.Info.GetLogSegmentType(1));
        jTextField_LogInputSegParam.setDocument(new JTextFieldFilter("0123456789", 5, 100000));
        jTextField_LogDecodSegParam.setDocument(new JTextFieldFilter("0123456789", 5, 100000));
        jTextField_LogInputSegParam.setText(Integer.toString(this.Info.GetLogSegmentParam(0)));
        jTextField_LogDecodSegParam.setText(Integer.toString(this.Info.GetLogSegmentParam(1)));
        jComboBox_InputLog_DecimType.addItem("None");
        jComboBox_InputLog_DecimType.addItem("Freq.");
        jComboBox_InputLog_DecimType.addItem("Ratio");
        jComboBox_InputLog_DecimType.setSelectedIndex(this.Info.GetLogDecimType(0));
        jComboBox_DecodLog_DecimType.addItem("None");
        jComboBox_DecodLog_DecimType.addItem("Freq.");
        jComboBox_DecodLog_DecimType.addItem("Ratio");
        jComboBox_DecodLog_DecimType.setSelectedIndex(this.Info.GetLogDecimType(1));
        this.Update_OutputParam_Visibility();
    }

    void Init_DecodParams_Interface() {
        jTextField_HRPPrecision.setDocument(new JTextFieldFilter("0123456789", 2, 12));
        jTextField_HRPRatesPrecision.setDocument(new JTextFieldFilter("0123456789", 2, 12));
        jTextField_PositionPrecision.setDocument(new JTextFieldFilter("0123456789", 2, 12));
        jTextField_SpeedsPrecision.setDocument(new JTextFieldFilter("0123456789", 2, 12));
        jTextField_ACCPrecision.setDocument(new JTextFieldFilter("0123456789", 2, 12));
        jTextField_ROTPrecision.setDocument(new JTextFieldFilter("0123456789", 2, 12));
        jTextField_HRPPrecision.setText(Integer.toString(this.Info.GetPrecisionWithDataType(1)));
        jTextField_HRPRatesPrecision.setText(Integer.toString(this.Info.GetPrecisionWithDataType(2)));
        jTextField_PositionPrecision.setText(Integer.toString(this.Info.GetPrecisionWithDataType(3)));
        jTextField_SpeedsPrecision.setText(Integer.toString(this.Info.GetPrecisionWithDataType(4)));
        jTextField_ACCPrecision.setText(Integer.toString(this.Info.GetPrecisionWithDataType(5)));
        jTextField_ROTPrecision.setText(Integer.toString(this.Info.GetPrecisionWithDataType(6)));
        jTextField_Separator.setText(this.Info.GetSeparator());
    }

    void Update_InputParam_Visibility() {
        this.Set_FileConnection_Visible(jComboBox_FlowType.getSelectedIndex() == 1);
        this.Set_EthernetConnection_Visible(jComboBox_FlowType.getSelectedIndex() == 2);
        this.Set_SerialConnection_Visible(jComboBox_FlowType.getSelectedIndex() == 3);
    }

    void Set_FileConnection_Visible(boolean set_unset) {
        jTextField_File.setEnabled(set_unset);
        jButton_SelectInputFile.setEnabled(set_unset);
        jLabel_InputFile.setForeground(set_unset ? Color.black : Color.GRAY);
        jPanel_File.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "File", 0, 0, new Font("Tahoma", 1, 11), set_unset ? Color.black : Color.GRAY));
    }

    void Set_EthernetConnection_Visible(boolean set_unset) {
        jComboBox_ConnectionType.setEnabled(set_unset);
        jTextField_IPAdress1.setEnabled(set_unset);
        jTextField_IPAdress2.setEnabled(set_unset);
        jTextField_IPAdress3.setEnabled(set_unset);
        jTextField_IPAdress4.setEnabled(set_unset);
        jTextField_IPPort.setEnabled(set_unset);
        jLabel_ConnectionType.setForeground(set_unset ? Color.black : Color.GRAY);
        jLabel_IPAdress.setForeground(set_unset ? Color.black : Color.GRAY);
        jLabel_P1.setForeground(set_unset ? Color.black : Color.GRAY);
        jLabel_P2.setForeground(set_unset ? Color.black : Color.GRAY);
        jLabel_P3.setForeground(set_unset ? Color.black : Color.GRAY);
        jLabel_PortIP.setForeground(set_unset ? Color.black : Color.GRAY);
        jPanel_Ethernet.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Ethernet", 0, 0, new Font("Tahoma", 1, 11), set_unset ? Color.black : Color.GRAY));
    }

    void Set_SerialConnection_Visible(boolean set_unset) {
        jComboBox_Port.setEnabled(set_unset);
        jComboBox_Baudrate.setEnabled(set_unset);
        jComboBox_DataBits.setEnabled(set_unset);
        jComboBox_Parity.setEnabled(set_unset);
        jComboBox_StopBits.setEnabled(set_unset);
        jLabel_PortRS.setForeground(set_unset ? Color.black : Color.GRAY);
        jLabel_Baudrate.setForeground(set_unset ? Color.black : Color.GRAY);
        jLabel_Databits.setForeground(set_unset ? Color.black : Color.GRAY);
        jLabel_Parity.setForeground(set_unset ? Color.black : Color.GRAY);
        jLabel_StopBits.setForeground(set_unset ? Color.black : Color.GRAY);
        jPanel_Serial.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Serial", 0, 0, new Font("Tahoma", 1, 11), set_unset ? Color.black : Color.GRAY));
    }

    void Update_OutputParam_Visibility() {
        if (jComboBox_FlowType.getSelectedIndex() == 0) {
            this.Set_InputDataLogEnable(false);
            this.Set_InputDataLog_Visible(false);
        } else {
            this.Set_InputDataLogEnable(true);
            if (!jCheckBox_LogInput.isSelected()) {
                this.Set_InputDataLog_Visible(false);
            } else {
                this.Set_InputDataLog_Visible(true);
            }
        }
        if (jComboBox_Protocol.getSelectedIndex() == 0) {
            this.Set_DecodDataLogEnable(false);
            this.Set_DecodDataLog_Visible(false);
        } else {
            this.Set_DecodDataLogEnable(true);
            if (!jCheckBox_LogDecod.isSelected()) {
                this.Set_DecodDataLog_Visible(false);
            } else {
                this.Set_DecodDataLog_Visible(true);
            }
        }
    }

    void Set_InputDataLogEnable(boolean enable) {
        jPanel_InputData.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Input Datas Log", 0, 0, new Font("Tahoma", 1, 11), enable ? Color.black : Color.GRAY));
        jCheckBox_LogInput.setEnabled(enable);
    }

    void Set_InputDataLog_Visible(boolean set_unset) {
        jCheckBox_LogInput.setSelected(set_unset);
        jTextField_LogInput.setEnabled(set_unset);
        jButton_SelectLogInput.setEnabled(set_unset);
        jComboBox_LogInputSegType.setEnabled(set_unset);
        jTextField_LogInputSegParam.setEnabled(set_unset);
        jLabel_InputLogSegParam.setEnabled(set_unset);
        jTextField_LogInputSegParam.setEnabled(set_unset);
        jLabel_SegInput.setForeground(set_unset ? Color.black : Color.GRAY);
        jComboBox_InputLog_DecimType.setEnabled(set_unset);
        jComboBox_InputLog_DecimVal.setEnabled(set_unset);
        jLabel_InputLogDecim.setForeground(set_unset ? Color.black : Color.GRAY);
        if (!set_unset) {
            jTextField_LogInput.setText("");
        }
    }

    void Set_DecodDataLogEnable(boolean enable) {
        jPanel_DecodData.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Decoded Datas Log", 0, 0, new Font("Tahoma", 1, 11), enable ? Color.black : Color.GRAY));
        jCheckBox_LogDecod.setEnabled(enable);
    }

    void Set_DecodDataLog_Visible(boolean set_unset) {
        jCheckBox_LogDecod.setSelected(set_unset);
        jTextField_LogDecod.setEnabled(set_unset);
        jButton_SelectLogDecod.setEnabled(set_unset);
        jComboBox_LogDecodSegType.setEnabled(set_unset);
        jTextField_LogDecodSegParam.setEnabled(set_unset);
        jLabel_DecodLogSegParam.setEnabled(set_unset);
        jTextField_LogDecodSegParam.setEnabled(set_unset);
        jLabel_SegDecod.setForeground(set_unset ? Color.black : Color.GRAY);
        jComboBox_DecodLog_DecimType.setEnabled(set_unset);
        jComboBox_DecodLog_DecimVal.setEnabled(set_unset);
        jLabel_DecodLogFMax.setForeground(set_unset ? Color.black : Color.GRAY);
        if (!set_unset) {
            jTextField_LogDecod.setText("");
        }
    }

    void InfosBulle() {
        ToolTipManager.sharedInstance().setInitialDelay(100);
        ToolTipManager.sharedInstance().setDismissDelay(100000);
        jComboBox_Protocol.setToolTipText("<html>- GREEN color protocols are implemented for normalization and drawing<br/>- BLACK color protocols are usable but not normalizable nor traceable</html>");
        String bulle = !Proto_List.GetDecoderByName(jComboBox_Protocol.getSelectedItem().toString()).GetCurvePlotImplementation() ? "<html>Protocol : " + jComboBox_Protocol.getSelectedItem().toString() + "<br/>--> NOT IMPLEMENTED</html>" : null;
        jCheckBox_NormalizedDatas.setToolTipText(bulle);
        jTabbedPane_Main.setToolTipTextAt(4, bulle);
        jTabbedPane_Main.setToolTipTextAt(5, bulle);
    }

    private void initComponents() {
        this.jPanel7 = new JPanel();
        jTabbedPane_Main = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabel2 = new JLabel();
        jComboBox_Protocol = new JComboBox();
        this.jLabel18 = new JLabel();
        jComboBox_FlowType = new JComboBox();
        jLabel21 = new JLabel();
        jTextField_Frequency = new JTextField();
        jPanel_Ethernet = new JPanel();
        jLabel_ConnectionType = new JLabel();
        jComboBox_ConnectionType = new JComboBox();
        jLabel_IPAdress = new JLabel();
        jLabel_PortIP = new JLabel();
        jTextField_IPPort = new JTextField();
        jTextField_IPAdress1 = new JTextField();
        jLabel_P1 = new JLabel();
        jTextField_IPAdress2 = new JTextField();
        jLabel_P2 = new JLabel();
        jTextField_IPAdress3 = new JTextField();
        jLabel_P3 = new JLabel();
        jTextField_IPAdress4 = new JTextField();
        jPanel_Serial = new JPanel();
        jLabel_PortRS = new JLabel();
        jLabel_Baudrate = new JLabel();
        jComboBox_Port = new JComboBox();
        jComboBox_Baudrate = new JComboBox();
        jComboBox_StopBits = new JComboBox();
        jLabel_StopBits = new JLabel();
        jLabel_Parity = new JLabel();
        jComboBox_Parity = new JComboBox();
        jLabel_Databits = new JLabel();
        jComboBox_DataBits = new JComboBox();
        jPanel_File = new JPanel();
        jTextField_File = new JTextField();
        jLabel_InputFile = new JLabel();
        jButton_SelectInputFile = new JButton();
        this.jPanel5 = new JPanel();
        jPanel_InputData = new JPanel();
        jTextField_LogInput = new JTextField();
        jButton_SelectLogInput = new JButton();
        jCheckBox_LogInput = new JCheckBox();
        jComboBox_LogInputSegType = new JComboBox();
        jLabel_SegInput = new JLabel();
        jTextField_LogInputSegParam = new JTextField();
        jLabel_InputLogSegParam = new JLabel();
        this.jPanel12 = new JPanel();
        jLabel_InputLogDecim = new JLabel();
        jComboBox_InputLog_DecimType = new JComboBox();
        jComboBox_InputLog_DecimVal = new JComboBox();
        jPanel_DecodData = new JPanel();
        jCheckBox_LogDecod = new JCheckBox();
        jTextField_LogDecod = new JTextField();
        jButton_SelectLogDecod = new JButton();
        jLabel_SegDecod = new JLabel();
        jComboBox_LogDecodSegType = new JComboBox();
        jTextField_LogDecodSegParam = new JTextField();
        jLabel_DecodLogSegParam = new JLabel();
        this.jPanel11 = new JPanel();
        jLabel_DecodLogFMax = new JLabel();
        jComboBox_DecodLog_DecimType = new JComboBox();
        jComboBox_DecodLog_DecimVal = new JComboBox();
        jCheckBox_NormalizedDatas = new JCheckBox();
        jPanel8 = new JPanel();
        this.jPanel13 = new JPanel();
        this.jPanel14 = new JPanel();
        jLabel7 = new JLabel();
        jLabel9 = new JLabel();
        jLabel11 = new JLabel();
        jTextField_PositionPrecision = new JTextField();
        jTextField_HRPRatesPrecision = new JTextField();
        jTextField_HRPPrecision = new JTextField();
        this.jPanel15 = new JPanel();
        jLabel13 = new JLabel();
        jLabel15 = new JLabel();
        jLabel17 = new JLabel();
        jTextField_ROTPrecision = new JTextField();
        jTextField_ACCPrecision = new JTextField();
        jTextField_SpeedsPrecision = new JTextField();
        this.jPanel16 = new JPanel();
        jLabel20 = new JLabel();
        jTextField_Separator = new JTextField();
        this.jLabelBoardType = new JLabel();
        jPanel4 = new JPanel();
        jPanel_DecoderViewer = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        jTextArea_Display = new JTextArea();
        jButton_View = new JButton();
        jButton_Connect = new JButton();
        jButton_Log = new JButton();
        jComboBox_SelectView = new JComboBox();
        this.jPanel3 = new JPanel();
        this.jLabel_Info1 = new JLabel();
        this.jLabel_Info2 = new JLabel();
        this.jLabel_Info3 = new JLabel();
        this.jLabel_Info4 = new JLabel();
        jLabel_InfoConnectiontype = new JLabel();
        jLabel_InfoProtocol = new JLabel();
        jLabel_InfoDecodLog = new JLabel();
        jLabel_InfoInputLog = new JLabel();
        jPanel9 = new JPanel();
        jLabel_ConnState = new JLabel();
        this.jLabel1 = new JLabel();
        jLabel_InputStateId = new JLabel();
        jLabel_InputState = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        jLabel_LogState = new JLabel();
        jLabel_DecodState = new JLabel();
        jPanel_Voyants = new JPanel();
        this.jPanel6 = new JPanel();
        jPanel_Chart = new JPanel();
        jComboBox_Curve_Param = new JComboBox();
        jButton_Curves_Reinit = new JButton();
        jLabel_Name_Protocole = new JLabel();
        jComboBox_Curve_Param_abscisse = new JComboBox();
        jTextField_Ymin = new JTextField();
        jTextField_Ymax = new JTextField();
        this.jLabel3 = new JLabel();
        jToggleButton_Start = new JToggleButton();
        this.jLabel6 = new JLabel();
        this.jLabel_Y = new JLabel();
        this.jLabel_X = new JLabel();
        jCheckBox_Automatic_Scale = new JCheckBox();
        jTextField_substract_value = new JTextField();
        this.jLabel8 = new JLabel();
        jComboBox_Y_units = new JComboBox();
        this.jLabel10 = new JLabel();
        jTextField_Xmin = new JTextField();
        jTextField_Xmax = new JTextField();
        this.jLabel14 = new JLabel();
        this.jLabel16 = new JLabel();
        this.jCheckBox_Automatic_Scale_X = new JCheckBox();
        this.jButton1 = new JButton();
        jCheckBox_glissant = new JCheckBox();
        jTextField_Fenetre = new JTextField();
        this.jLabel19 = new JLabel();
        this.jLabel12 = new JLabel();
        jComboBox_X_units = new JComboBox();
        jPanel_Curves_Interface = new JPanel();
        this.setDefaultCloseOperation(3);
        jTabbedPane_Main.setFont(new Font("Tahoma", 1, 11));
        jTabbedPane_Main.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                LoggerDecoderFrame.this.ChangeListener(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Input", 0, 0, new Font("Tahoma", 1, 11)));
        this.jLabel2.setText("Protocol");
        jComboBox_Protocol.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoggerDecoderFrame.this.jComboBox_ProtocolActionPerformed(evt);
            }
        });
        this.jLabel18.setText("Input Flow");
        jComboBox_FlowType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoggerDecoderFrame.this.jComboBox_FlowTypeActionPerformed(evt);
            }
        });
        jLabel21.setText("Frequency:");
        jTextField_Frequency.setHorizontalAlignment(0);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jComboBox_Protocol, -2, 249, -2).addComponent(this.jLabel2, -2, 89, -2)).addGap(65, 65, 65).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(jComboBox_FlowType, -2, 156, -2).addGap(46, 46, 46).addComponent(jLabel21, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jTextField_Frequency, -2, 55, -2)).addComponent(this.jLabel18, -2, 89, -2)).addContainerGap(21, -2)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jLabel18)).addGap(2, 2, 2).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jTextField_Frequency, -2, -1, -2).addComponent(jLabel21)).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jComboBox_Protocol, -2, -1, -2).addComponent(jComboBox_FlowType, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel_Ethernet.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Ethernet", 0, 0, new Font("Tahoma", 1, 11)));
        jLabel_ConnectionType.setText("Connection Type:");
        jLabel_IPAdress.setText("IP Adress:");
        jLabel_PortIP.setText("Port:");
        jTextField_IPPort.setHorizontalAlignment(0);
        jTextField_IPAdress1.setHorizontalAlignment(0);
        jLabel_P1.setText(".");
        jTextField_IPAdress2.setHorizontalAlignment(0);
        jLabel_P2.setText(".");
        jTextField_IPAdress3.setHorizontalAlignment(0);
        jLabel_P3.setText(".");
        jTextField_IPAdress4.setHorizontalAlignment(0);
        GroupLayout jPanel_EthernetLayout = new GroupLayout(jPanel_Ethernet);
        jPanel_Ethernet.setLayout(jPanel_EthernetLayout);
        jPanel_EthernetLayout.setHorizontalGroup(jPanel_EthernetLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_EthernetLayout.createSequentialGroup().addContainerGap().addComponent(jLabel_ConnectionType).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jComboBox_ConnectionType, -2, 91, -2).addGap(47, 47, 47).addComponent(jLabel_IPAdress, -2, 63, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jTextField_IPAdress1, -2, 27, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel_P1).addGap(2, 2, 2).addComponent(jTextField_IPAdress2, -2, 27, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel_P2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jTextField_IPAdress3, -2, 27, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel_P3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jTextField_IPAdress4, -2, 27, -2).addGap(48, 48, 48).addComponent(jLabel_PortIP, -2, 31, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jTextField_IPPort, -2, 46, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel_EthernetLayout.setVerticalGroup(jPanel_EthernetLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_EthernetLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_EthernetLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel_ConnectionType).addComponent(jComboBox_ConnectionType, -2, -1, -2).addComponent(jTextField_IPAdress1, -2, -1, -2).addComponent(jLabel_P1).addComponent(jTextField_IPAdress2, -2, -1, -2).addComponent(jLabel_P2).addComponent(jTextField_IPAdress3, -2, -1, -2).addComponent(jLabel_P3).addComponent(jTextField_IPAdress4, -2, -1, -2).addComponent(jTextField_IPPort, -2, -1, -2).addComponent(jLabel_PortIP).addComponent(jLabel_IPAdress)).addContainerGap(14, Short.MAX_VALUE)));
        jPanel_Serial.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Serial", 0, 0, new Font("Tahoma", 1, 11)));
        jLabel_PortRS.setText("Port:");
        jLabel_Baudrate.setText("Baudrate:");
        jLabel_StopBits.setText("Stop bits:");
        jLabel_Parity.setText("Parity:");
        jLabel_Databits.setText("DataBits:");
        GroupLayout jPanel_SerialLayout = new GroupLayout(jPanel_Serial);
        jPanel_Serial.setLayout(jPanel_SerialLayout);
        jPanel_SerialLayout.setHorizontalGroup(jPanel_SerialLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_SerialLayout.createSequentialGroup().addContainerGap().addComponent(jLabel_PortRS).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jComboBox_Port, -2, 75, -2).addGap(18, 18, 18).addComponent(jLabel_Baudrate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jComboBox_Baudrate, -2, 74, -2).addGap(18, 18, 18).addComponent(jLabel_Databits).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jComboBox_DataBits, -2, 72, -2).addGap(18, 18, 18).addComponent(jLabel_Parity).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jComboBox_Parity, -2, 72, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(jLabel_StopBits).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jComboBox_StopBits, -2, 69, -2).addGap(7, 7, 7)));
        jPanel_SerialLayout.setVerticalGroup(jPanel_SerialLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_SerialLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_SerialLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel_PortRS).addComponent(jComboBox_Port, -2, -1, -2).addComponent(jLabel_StopBits).addComponent(jComboBox_StopBits, -2, -1, -2).addComponent(jLabel_Baudrate).addComponent(jComboBox_Baudrate, -2, -1, -2).addComponent(jLabel_Databits).addComponent(jComboBox_DataBits, -2, -1, -2).addComponent(jLabel_Parity).addComponent(jComboBox_Parity, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel_File.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "File", 0, 0, new Font("Tahoma", 1, 11)));
        jLabel_InputFile.setText("Input File:");
        jButton_SelectInputFile.setText("Select");
        jButton_SelectInputFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoggerDecoderFrame.this.jButton_SelectInputFileActionPerformed(evt);
            }
        });
        GroupLayout jPanel_FileLayout = new GroupLayout(jPanel_File);
        jPanel_File.setLayout(jPanel_FileLayout);
        jPanel_FileLayout.setHorizontalGroup(jPanel_FileLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_FileLayout.createSequentialGroup().addContainerGap().addComponent(jLabel_InputFile, -2, 61, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jTextField_File).addGap(18, 18, 18).addComponent(jButton_SelectInputFile, -2, 95, -2).addContainerGap()));
        jPanel_FileLayout.setVerticalGroup(jPanel_FileLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel_FileLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel_FileLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel_InputFile).addComponent(jTextField_File, -2, -1, -2).addComponent(jButton_SelectInputFile)).addContainerGap()));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jPanel_Serial, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(jPanel_Ethernet, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(jPanel_File, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jPanel_File, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jPanel_Ethernet, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jPanel_Serial, -2, -1, -2).addContainerGap()));
        jTabbedPane_Main.addTab("      Input Flow      ", this.jPanel1);
        jPanel_InputData.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Input Datas Log", 0, 0, new Font("Tahoma", 1, 11)));
        jButton_SelectLogInput.setText("Select");
        jButton_SelectLogInput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoggerDecoderFrame.this.jButton_SelectLogInputActionPerformed(evt);
            }
        });
        jCheckBox_LogInput.setText("Log Input Datas to File");
        jCheckBox_LogInput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoggerDecoderFrame.this.jCheckBox_LogInputActionPerformed(evt);
            }
        });
        jComboBox_LogInputSegType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoggerDecoderFrame.this.jComboBox_LogInputSegTypeActionPerformed(evt);
            }
        });
        jLabel_SegInput.setText("Segmentation:");
        jTextField_LogInputSegParam.setHorizontalAlignment(0);
        jLabel_InputLogSegParam.setText("Param:");
        this.jPanel12.setEnabled(false);
        this.jPanel12.setMaximumSize(new Dimension(231, 20));
        this.jPanel12.setMinimumSize(new Dimension(231, 20));
        this.jPanel12.setRequestFocusEnabled(false);
        this.jPanel12.setVerifyInputWhenFocusTarget(false);
        jLabel_InputLogDecim.setText("Decimation:");
        jComboBox_InputLog_DecimType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoggerDecoderFrame.this.jComboBox_InputLog_DecimTypeActionPerformed(evt);
            }
        });
        GroupLayout jPanel12Layout = new GroupLayout(this.jPanel12);
        this.jPanel12.setLayout(jPanel12Layout);
        jPanel12Layout.setHorizontalGroup(jPanel12Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel12Layout.createSequentialGroup().addComponent(jLabel_InputLogDecim).addGap(4, 4, 4).addComponent(jComboBox_InputLog_DecimType, -2, 60, -2).addGap(20, 20, 20).addComponent(jComboBox_InputLog_DecimVal, -2, 60, -2)));
        jPanel12Layout.setVerticalGroup(jPanel12Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabel_InputLogDecim, -2, 20, -2).addComponent(jComboBox_InputLog_DecimType, -2, -1, -2).addComponent(jComboBox_InputLog_DecimVal, -2, -1, -2));
        GroupLayout jPanel_InputDataLayout = new GroupLayout(jPanel_InputData);
        jPanel_InputData.setLayout(jPanel_InputDataLayout);
        jPanel_InputDataLayout.setHorizontalGroup(jPanel_InputDataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_InputDataLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_InputDataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jCheckBox_LogInput, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jPanel_InputDataLayout.createSequentialGroup().addGroup(jPanel_InputDataLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, jPanel_InputDataLayout.createSequentialGroup().addComponent(jLabel_SegInput).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jComboBox_LogInputSegType, -2, 75, -2).addGap(18, 18, 18).addComponent(jLabel_InputLogSegParam).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jTextField_LogInputSegParam, -2, 59, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jPanel12, -2, 226, -2)).addComponent(jTextField_LogInput)).addGap(18, 18, 18).addComponent(jButton_SelectLogInput, -2, 87, -2))).addContainerGap()));
        jPanel_InputDataLayout.setVerticalGroup(jPanel_InputDataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_InputDataLayout.createSequentialGroup().addContainerGap().addComponent(jCheckBox_LogInput).addGap(3, 3, 3).addGroup(jPanel_InputDataLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jTextField_LogInput, -2, -1, -2).addComponent(jButton_SelectLogInput)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel_InputDataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_InputDataLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel_SegInput).addComponent(jComboBox_LogInputSegType, -2, -1, -2).addComponent(jTextField_LogInputSegParam, -2, -1, -2).addComponent(jLabel_InputLogSegParam)).addComponent(this.jPanel12, -2, -1, -2)).addContainerGap(22, Short.MAX_VALUE)));
        jPanel_DecodData.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Decoded Datas Log", 0, 0, new Font("Tahoma", 1, 11)));
        jCheckBox_LogDecod.setText("Log Decoded Datas to File");
        jCheckBox_LogDecod.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoggerDecoderFrame.this.jCheckBox_LogDecodActionPerformed(evt);
            }
        });
        jButton_SelectLogDecod.setText("Select");
        jButton_SelectLogDecod.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoggerDecoderFrame.this.jButton_SelectLogDecodActionPerformed(evt);
            }
        });
        jLabel_SegDecod.setText("Segmentation:");
        jComboBox_LogDecodSegType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoggerDecoderFrame.this.jComboBox_LogDecodSegTypeActionPerformed(evt);
            }
        });
        jTextField_LogDecodSegParam.setHorizontalAlignment(0);
        jLabel_DecodLogSegParam.setText("Param:");
        jLabel_DecodLogFMax.setText("Decimation:");
        jComboBox_DecodLog_DecimType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoggerDecoderFrame.this.jComboBox_DecodLog_DecimTypeActionPerformed(evt);
            }
        });
        GroupLayout jPanel11Layout = new GroupLayout(this.jPanel11);
        this.jPanel11.setLayout(jPanel11Layout);
        jPanel11Layout.setHorizontalGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel11Layout.createSequentialGroup().addGap(19, 19, 19).addComponent(jLabel_DecodLogFMax).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jComboBox_DecodLog_DecimType, -2, 60, -2).addGap(18, 18, 18).addComponent(jComboBox_DecodLog_DecimVal, -2, 60, -2).addGap(22, 22, 22)));
        jPanel11Layout.setVerticalGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jComboBox_DecodLog_DecimVal, -2, -1, -2).addComponent(jLabel_DecodLogFMax, -2, 20, -2).addComponent(jComboBox_DecodLog_DecimType, -2, -1, -2)));
        jCheckBox_NormalizedDatas.setText("Tabular Form (Normalized Datas)");
        jCheckBox_NormalizedDatas.setToolTipText("");
        jCheckBox_NormalizedDatas.setEnabled(false);
        jCheckBox_NormalizedDatas.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoggerDecoderFrame.this.jCheckBox_NormalizedDatasActionPerformed(evt);
            }
        });
        GroupLayout jPanel_DecodDataLayout = new GroupLayout(jPanel_DecodData);
        jPanel_DecodData.setLayout(jPanel_DecodDataLayout);
        jPanel_DecodDataLayout.setHorizontalGroup(jPanel_DecodDataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_DecodDataLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_DecodDataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_DecodDataLayout.createSequentialGroup().addGroup(jPanel_DecodDataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_DecodDataLayout.createSequentialGroup().addComponent(jCheckBox_LogDecod).addGap(18, 18, 18).addComponent(jCheckBox_NormalizedDatas).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, jPanel_DecodDataLayout.createSequentialGroup().addComponent(jTextField_LogDecod).addGap(18, 18, 18).addComponent(jButton_SelectLogDecod, -2, 87, -2))).addContainerGap()).addGroup(jPanel_DecodDataLayout.createSequentialGroup().addComponent(jLabel_SegDecod).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jComboBox_LogDecodSegType, -2, 71, -2).addGap(18, 18, 18).addComponent(jLabel_DecodLogSegParam).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jTextField_LogDecodSegParam, -2, 61, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jPanel11, -2, -1, -2).addGap(115, 115, 115)))));
        jPanel_DecodDataLayout.setVerticalGroup(jPanel_DecodDataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_DecodDataLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_DecodDataLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jCheckBox_LogDecod).addComponent(jCheckBox_NormalizedDatas)).addGap(3, 3, 3).addGroup(jPanel_DecodDataLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jTextField_LogDecod, -2, -1, -2).addComponent(jButton_SelectLogDecod)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel_DecodDataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_DecodDataLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel_SegDecod).addComponent(jComboBox_LogDecodSegType, -2, -1, -2).addComponent(jTextField_LogDecodSegParam, -2, -1, -2).addComponent(jLabel_DecodLogSegParam)).addComponent(this.jPanel11, -2, -1, -2)).addContainerGap(19, Short.MAX_VALUE)));
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jPanel_DecodData, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(jPanel_InputData, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(jPanel_InputData, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jPanel_DecodData, -2, -1, -2).addContainerGap(52, Short.MAX_VALUE)));
        jTabbedPane_Main.addTab("      Output Flow      ", this.jPanel5);
        this.jPanel13.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Datas Precision", 0, 0, new Font("Tahoma", 1, 11)));
        jLabel7.setText("HRP:");
        jLabel9.setText("HRP Rates:");
        jLabel11.setText("Positions/Ranges:");
        jTextField_PositionPrecision.setHorizontalAlignment(0);
        jTextField_HRPRatesPrecision.setHorizontalAlignment(0);
        jTextField_HRPPrecision.setHorizontalAlignment(0);
        jTextField_HRPPrecision.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoggerDecoderFrame.this.jTextField_HRPPrecisionActionPerformed(evt);
            }
        });
        jLabel13.setText("Speeds:");
        jLabel15.setText("Acceleration:");
        jLabel17.setText("Rotations:");
        jTextField_ROTPrecision.setHorizontalAlignment(0);
        jTextField_ACCPrecision.setHorizontalAlignment(0);
        jTextField_SpeedsPrecision.setHorizontalAlignment(0);
        GroupLayout jPanel15Layout = new GroupLayout(this.jPanel15);
        this.jPanel15.setLayout(jPanel15Layout);
        jPanel15Layout.setHorizontalGroup(jPanel15Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel15Layout.createSequentialGroup().addContainerGap().addGroup(jPanel15Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jLabel17, -1, -1, Short.MAX_VALUE).addComponent(jLabel13, -1, -1, Short.MAX_VALUE).addComponent(jLabel15, -1, 87, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel15Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel15Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jTextField_ROTPrecision, -2, 41, -2).addGroup(GroupLayout.Alignment.TRAILING, jPanel15Layout.createSequentialGroup().addComponent(jTextField_ACCPrecision, -2, 41, -2).addGap(52, 52, 52))).addGroup(GroupLayout.Alignment.TRAILING, jPanel15Layout.createSequentialGroup().addComponent(jTextField_SpeedsPrecision, -2, 41, -2).addGap(52, 52, 52))).addGap(10, 10, 10)));
        jPanel15Layout.setVerticalGroup(jPanel15Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel15Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel15Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jTextField_SpeedsPrecision, -2, -1, -2).addComponent(jLabel13)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel15Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jTextField_ACCPrecision, -2, -1, -2).addComponent(jLabel15)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel15Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jTextField_ROTPrecision, -2, -1, -2).addComponent(jLabel17)).addContainerGap()));
        GroupLayout jPanel14Layout = new GroupLayout(this.jPanel14);
        this.jPanel14.setLayout(jPanel14Layout);
        jPanel14Layout.setHorizontalGroup(jPanel14Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel14Layout.createSequentialGroup().addContainerGap().addGroup(jPanel14Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(jLabel11, -1, -1, Short.MAX_VALUE).addComponent(jLabel9, -1, -1, Short.MAX_VALUE).addComponent(jLabel7, -2, 78, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel14Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jTextField_HRPRatesPrecision, -2, 41, -2).addComponent(jTextField_PositionPrecision, -2, 41, -2).addComponent(jTextField_HRPPrecision, -2, 41, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 36, Short.MAX_VALUE).addComponent(this.jPanel15, -2, -1, -2).addContainerGap()));
        jPanel14Layout.setVerticalGroup(jPanel14Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel14Layout.createSequentialGroup().addContainerGap().addGroup(jPanel14Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel7).addComponent(jTextField_HRPPrecision, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel14Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel9).addComponent(jTextField_HRPRatesPrecision, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel14Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel11).addComponent(jTextField_PositionPrecision, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)).addComponent(this.jPanel15, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        GroupLayout jPanel13Layout = new GroupLayout(this.jPanel13);
        this.jPanel13.setLayout(jPanel13Layout);
        jPanel13Layout.setHorizontalGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel13Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jPanel14, -2, -1, -2).addGap(243, 243, 243)));
        jPanel13Layout.setVerticalGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel13Layout.createSequentialGroup().addComponent(this.jPanel14, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel16.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Others", 0, 0, new Font("Tahoma", 1, 11)));
        jLabel20.setText("Separator:");
        jTextField_Separator.setHorizontalAlignment(0);
        this.jLabelBoardType.setText("Board Type:");
        jComboBoxBoardType.setModel(new DefaultComboBoxModel<String>(new String[]{"None", "Source2", "Source3", "Senseur1/2", "Senseur3", "Senseur IXAL", "Senseur IMU50", "Senseur MEMS"}));
        GroupLayout jPanel16Layout = new GroupLayout(this.jPanel16);
        this.jPanel16.setLayout(jPanel16Layout);
        jPanel16Layout.setHorizontalGroup(jPanel16Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel16Layout.createSequentialGroup().addContainerGap().addGroup(jPanel16Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabelBoardType, -1, -1, Short.MAX_VALUE).addComponent(jLabel20, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel16Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jTextField_Separator, -2, 35, -2).addComponent(jComboBoxBoardType, -2, -1, -2)).addGap(32, 32, 32)));
        jPanel16Layout.setVerticalGroup(jPanel16Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel16Layout.createSequentialGroup().addContainerGap().addGroup(jPanel16Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jTextField_Separator, -2, -1, -2).addComponent(jLabel20)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel16Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelBoardType).addComponent(jComboBoxBoardType, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel8Layout = new GroupLayout(jPanel8);
        jPanel8.setLayout(jPanel8Layout);
        jPanel8Layout.setHorizontalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel13, -2, 408, -2).addGap(18, 18, 18).addComponent(this.jPanel16, -1, -1, Short.MAX_VALUE).addGap(80, 80, 80)));
        jPanel8Layout.setVerticalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addContainerGap().addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel16, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel13, GroupLayout.Alignment.LEADING, -2, 119, -2)).addContainerGap(196, Short.MAX_VALUE)));
        jTabbedPane_Main.addTab("    Decoder Params   ", jPanel8);
        jPanel_DecoderViewer.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Decoder Viewer", 0, 0, new Font("Tahoma", 1, 11)));
        jTextArea_Display.setColumns(20);
        jTextArea_Display.setEditable(false);
        jTextArea_Display.setFont(new Font("Tahoma", 0, 11));
        jTextArea_Display.setRows(5);
        this.jScrollPane1.setViewportView(jTextArea_Display);
        jButton_View.setFont(new Font("Tahoma", 1, 11));
        jButton_View.setText("View");
        jButton_View.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoggerDecoderFrame.this.jButton_ViewActionPerformed(evt);
            }
        });
        jButton_Connect.setFont(new Font("Tahoma", 1, 11));
        jButton_Connect.setText("Connect");
        jButton_Connect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoggerDecoderFrame.this.jButton_ConnectActionPerformed(evt);
            }
        });
        jButton_Log.setFont(new Font("Tahoma", 1, 11));
        jButton_Log.setText("Start Logging");
        jButton_Log.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoggerDecoderFrame.this.jButton_LogActionPerformed(evt);
            }
        });
        jComboBox_SelectView.setModel(new DefaultComboBoxModel<String>(new String[]{"Input", "Decoded"}));
        jComboBox_SelectView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoggerDecoderFrame.this.jComboBox_SelectViewActionPerformed(evt);
            }
        });
        GroupLayout jPanel_DecoderViewerLayout = new GroupLayout(jPanel_DecoderViewer);
        jPanel_DecoderViewer.setLayout(jPanel_DecoderViewerLayout);
        jPanel_DecoderViewerLayout.setHorizontalGroup(jPanel_DecoderViewerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel_DecoderViewerLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_DecoderViewerLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 643, Short.MAX_VALUE).addGroup(jPanel_DecoderViewerLayout.createSequentialGroup().addComponent(jButton_Connect, -2, 197, -2).addGap(18, 18, 18).addComponent(jButton_Log, -2, 199, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 70, Short.MAX_VALUE).addComponent(jComboBox_SelectView, -2, 71, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jButton_View, -2, 82, -2))).addContainerGap()));
        jPanel_DecoderViewerLayout.setVerticalGroup(jPanel_DecoderViewerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_DecoderViewerLayout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 119, -2).addGap(11, 11, 11).addGroup(jPanel_DecoderViewerLayout.createParallelGroup(GroupLayout.Alignment.BASELINE, false).addComponent(jButton_View).addComponent(jButton_Connect, -2, 23, -2).addComponent(jButton_Log).addComponent(jComboBox_SelectView, -2, -1, -2)).addContainerGap()));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Info", 0, 0, new Font("Tahoma", 1, 11)));
        this.jLabel_Info1.setText("Connection type:");
        this.jLabel_Info2.setText("Protocol:");
        this.jLabel_Info3.setText("Input File log:");
        this.jLabel_Info4.setText("Decoded File Log:");
        jLabel_InfoConnectiontype.setText("[none]");
        jLabel_InfoProtocol.setText("[none]");
        jLabel_InfoDecodLog.setText("[none]");
        jLabel_InfoInputLog.setText("[none]");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel_Info4, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel_Info3, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel_Info2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel_Info1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabel_InfoInputLog, -1, -1, Short.MAX_VALUE).addComponent(jLabel_InfoDecodLog, -1, -1, Short.MAX_VALUE).addComponent(jLabel_InfoProtocol, -1, -1, Short.MAX_VALUE).addComponent(jLabel_InfoConnectiontype, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_Info1).addComponent(jLabel_InfoConnectiontype)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_Info2).addComponent(jLabel_InfoProtocol)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_Info3).addComponent(jLabel_InfoInputLog)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_Info4).addComponent(jLabel_InfoDecodLog)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel9.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "State", 0, 0, new Font("Tahoma", 1, 11)));
        jLabel_ConnState.setHorizontalAlignment(0);
        jLabel_ConnState.setText("...");
        this.jLabel1.setText("Connection:");
        jLabel_InputStateId.setText("Reception:");
        jLabel_InputState.setHorizontalAlignment(0);
        jLabel_InputState.setText("...");
        this.jLabel4.setText("Logging:");
        this.jLabel5.setText("Decoding:");
        jLabel_LogState.setHorizontalAlignment(0);
        jLabel_LogState.setText("...");
        jLabel_DecodState.setHorizontalAlignment(0);
        jLabel_DecodState.setText("...");
        jPanel_Voyants.setPreferredSize(new Dimension(16, 16));
        GroupLayout jPanel_VoyantsLayout = new GroupLayout(jPanel_Voyants);
        jPanel_Voyants.setLayout(jPanel_VoyantsLayout);
        jPanel_VoyantsLayout.setHorizontalGroup(jPanel_VoyantsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 16, Short.MAX_VALUE));
        jPanel_VoyantsLayout.setVerticalGroup(jPanel_VoyantsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        GroupLayout jPanel9Layout = new GroupLayout(jPanel9);
        jPanel9.setLayout(jPanel9Layout);
        jPanel9Layout.setHorizontalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel9Layout.createSequentialGroup().addContainerGap().addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel5, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel4, -1, -1, Short.MAX_VALUE).addComponent(jLabel_InputStateId, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE)).addGap(10, 10, 10).addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabel_DecodState, -1, 160, Short.MAX_VALUE).addComponent(jLabel_LogState, -1, 160, Short.MAX_VALUE).addComponent(jLabel_InputState, -1, 160, Short.MAX_VALUE).addComponent(jLabel_ConnState, -1, 160, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jPanel_Voyants, -2, -1, -2).addContainerGap()));
        jPanel9Layout.setVerticalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel9Layout.createSequentialGroup().addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel_ConnState).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel_InputStateId).addComponent(jLabel_InputState)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(jLabel_LogState)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(jLabel_DecodState)).addContainerGap(-1, Short.MAX_VALUE)).addComponent(jPanel_Voyants, -1, 98, Short.MAX_VALUE));
        GroupLayout jPanel4Layout = new GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jPanel9, -2, -1, -2)).addComponent(jPanel_DecoderViewer, -2, -1, -2)).addGap(691, 691, 691)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jPanel9, -2, -1, -2).addComponent(this.jPanel3, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jPanel_DecoderViewer, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jTabbedPane_Main.addTab("      Control View      ", jPanel4);
        GroupLayout jPanel_ChartLayout = new GroupLayout(jPanel_Chart);
        jPanel_Chart.setLayout(jPanel_ChartLayout);
        jPanel_ChartLayout.setHorizontalGroup(jPanel_ChartLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 483, Short.MAX_VALUE));
        jPanel_ChartLayout.setVerticalGroup(jPanel_ChartLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 317, Short.MAX_VALUE));
        jComboBox_Curve_Param.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoggerDecoderFrame.this.jComboBox_Curve_ParamActionPerformed(evt);
            }
        });
        jButton_Curves_Reinit.setText("RESET");
        jButton_Curves_Reinit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoggerDecoderFrame.this.jButton_Curves_ReinitActionPerformed(evt);
            }
        });
        jLabel_Name_Protocole.setText("Protocole_Name");
        jComboBox_Curve_Param_abscisse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoggerDecoderFrame.this.jComboBox_Curve_Param_abscisseActionPerformed(evt);
            }
        });
        jTextField_Ymin.setText("0");
        jTextField_Ymin.setCursor(new Cursor(2));
        jTextField_Ymin.setEnabled(false);
        jTextField_Ymin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoggerDecoderFrame.this.jTextField_YminActionPerformed(evt);
            }
        });
        jTextField_Ymax.setText("10");
        jTextField_Ymax.setEnabled(false);
        jTextField_Ymax.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoggerDecoderFrame.this.jTextField_YmaxActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Ymin");
        jToggleButton_Start.setText("START");
        jToggleButton_Start.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoggerDecoderFrame.this.jToggleButton_StartActionPerformed(evt);
            }
        });
        this.jLabel6.setText("Ymax");
        this.jLabel_Y.setHorizontalAlignment(0);
        this.jLabel_Y.setText("Y");
        this.jLabel_X.setHorizontalAlignment(0);
        this.jLabel_X.setText("X");
        jCheckBox_Automatic_Scale.setSelected(true);
        jCheckBox_Automatic_Scale.setText("Auto");
        jCheckBox_Automatic_Scale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoggerDecoderFrame.this.jCheckBox_Automatic_ScaleActionPerformed(evt);
            }
        });
        jTextField_substract_value.setText("0");
        jTextField_substract_value.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoggerDecoderFrame.this.jTextField_substract_valueActionPerformed(evt);
            }
        });
        this.jLabel8.setText("Value to Subtract");
        jComboBox_Y_units.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoggerDecoderFrame.this.jComboBox_Y_unitsActionPerformed(evt);
            }
        });
        this.jLabel10.setHorizontalAlignment(0);
        this.jLabel10.setText("Y Unit");
        jTextField_Xmin.setText("0");
        jTextField_Xmin.setEnabled(false);
        jTextField_Xmin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoggerDecoderFrame.this.jTextField_XminActionPerformed(evt);
            }
        });
        jTextField_Xmax.setText("100");
        jTextField_Xmax.setEnabled(false);
        jTextField_Xmax.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoggerDecoderFrame.this.jTextField_XmaxActionPerformed(evt);
            }
        });
        this.jLabel14.setText("Xmin");
        this.jLabel16.setText("Xmax");
        this.jCheckBox_Automatic_Scale_X.setSelected(true);
        this.jCheckBox_Automatic_Scale_X.setText("Auto");
        this.jCheckBox_Automatic_Scale_X.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoggerDecoderFrame.this.jCheckBox_Automatic_Scale_XActionPerformed(evt);
            }
        });
        this.jButton1.setText("new");
        this.jButton1.setMargin(new Insets(2, 10, 2, 10));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoggerDecoderFrame.this.jButton1ActionPerformed(evt);
            }
        });
        jCheckBox_glissant.setText("Sliding");
        jCheckBox_glissant.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoggerDecoderFrame.this.jCheckBox_glissantActionPerformed(evt);
            }
        });
        jTextField_Fenetre.setText("600");
        jTextField_Fenetre.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoggerDecoderFrame.this.jTextField_FenetreActionPerformed(evt);
            }
        });
        this.jLabel19.setText("Window");
        this.jLabel12.setHorizontalAlignment(0);
        this.jLabel12.setText("X Unit");
        jComboBox_X_units.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoggerDecoderFrame.this.jComboBox_X_unitsActionPerformed(evt);
            }
        });
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addComponent(jPanel_Chart, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabel_Name_Protocole).addGroup(jPanel6Layout.createSequentialGroup().addGap(6, 6, 6).addComponent(jTextField_substract_value, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel8)).addGroup(jPanel6Layout.createSequentialGroup().addGap(4, 4, 4).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.jLabel12).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jComboBox_X_units, -2, 89, -2)).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel_Y, -2, 25, -2).addComponent(this.jLabel_X, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(jComboBox_Curve_Param_abscisse, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addComponent(jComboBox_Curve_Param, GroupLayout.Alignment.TRAILING, 0, 154, Short.MAX_VALUE))).addGroup(jPanel6Layout.createSequentialGroup().addGap(18, 18, 18).addComponent(jToggleButton_Start, -2, 85, -2).addGap(18, 18, 18).addComponent(jButton_Curves_Reinit)).addGroup(jPanel6Layout.createSequentialGroup().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jTextField_Ymin, -2, 40, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6).addGroup(jPanel6Layout.createSequentialGroup().addComponent(jTextField_Ymax, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jCheckBox_Automatic_Scale)))).addGroup(jPanel6Layout.createSequentialGroup().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jTextField_Xmin, -2, 40, -2).addComponent(this.jLabel14)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jTextField_Xmax, -2, 40, -2).addComponent(this.jLabel16)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBox_Automatic_Scale_X)).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.jLabel19).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jTextField_Fenetre, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jCheckBox_glissant)).addGroup(GroupLayout.Alignment.TRAILING, jPanel6Layout.createSequentialGroup().addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jComboBox_Y_units, -2, 89, -2).addGap(18, 18, 18).addComponent(this.jButton1, -2, 45, -2)))))).addContainerGap()));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jPanel_Chart, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(jPanel6Layout.createSequentialGroup().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addGap(31, 31, 31).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jComboBox_Curve_Param, -2, -1, -2).addComponent(this.jLabel_Y)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jComboBox_Curve_Param_abscisse, -2, -1, -2).addComponent(this.jLabel_X))).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addComponent(jLabel_Name_Protocole))).addGap(9, 9, 9).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jComboBox_Y_units, -2, -1, -2).addComponent(this.jLabel10).addComponent(this.jButton1, -2, 23, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jComboBox_X_units, -2, -1, -2).addComponent(this.jLabel12)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jTextField_Ymin, -2, -1, -2).addComponent(jTextField_Ymax, -2, -1, -2).addComponent(jCheckBox_Automatic_Scale)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel16).addComponent(this.jLabel14, -2, 14, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jTextField_Xmin, -2, -1, -2).addComponent(jTextField_Xmax, -2, -1, -2).addComponent(this.jCheckBox_Automatic_Scale_X, -2, 14, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 9, Short.MAX_VALUE).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jTextField_Fenetre, -2, -1, -2).addComponent(jCheckBox_glissant).addComponent(this.jLabel19)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jTextField_substract_value, -2, -1, -2).addComponent(this.jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jToggleButton_Start).addComponent(jButton_Curves_Reinit)))).addContainerGap()));
        jTabbedPane_Main.addTab("     Curves Tracer     ", this.jPanel6);
        GroupLayout jPanel_Curves_InterfaceLayout = new GroupLayout(jPanel_Curves_Interface);
        jPanel_Curves_Interface.setLayout(jPanel_Curves_InterfaceLayout);
        jPanel_Curves_InterfaceLayout.setHorizontalGroup(jPanel_Curves_InterfaceLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 696, Short.MAX_VALUE));
        jPanel_Curves_InterfaceLayout.setVerticalGroup(jPanel_Curves_InterfaceLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 328, Short.MAX_VALUE));
        jTabbedPane_Main.addTab("Curves Interface", jPanel_Curves_Interface);
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel7Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(jTabbedPane_Main, -2, 701, -2).addContainerGap()));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel7Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(jTabbedPane_Main, -2, 356, -2).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel7, -2, -1, -2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel7, -2, -1, -2));
        this.pack();
    }

    private void ChangeListener(ChangeEvent evt) {
        if (this.isVisible()) {
            this.UpdateSpecificDecoderParam();
            if (jTabbedPane_Main.getSelectedIndex() == 0) {
                // empty if block
            }
            if (jTabbedPane_Main.getSelectedIndex() == 1) {
                // empty if block
            }
            if (jTabbedPane_Main.getSelectedIndex() == 3 && (this.PaneIndexPrec == 0 || this.PaneIndexPrec == 1 || this.PaneIndexPrec == 2)) {
                this.UpdateLogggerDecoderParam();
                this.Update_ConnectButtonState();
                this.Update_LogButtonState();
                if (!IsConnected.booleanValue()) {
                    Manager.ReInit();
                }
            }
        }
        this.PaneIndexPrec = jTabbedPane_Main.getSelectedIndex();
    }

    private void jComboBox_SelectViewActionPerformed(ActionEvent evt) {
    }

    private void jButton_LogActionPerformed(ActionEvent evt) {
        if (IsLogging.booleanValue()) {
            jButton_Connect.setEnabled(true);
            this.Stop_Logging();
        } else {
            jButton_Connect.setEnabled(false);
            this.Start_Logging();
        }
    }

    private void jButton_ConnectActionPerformed(ActionEvent evt) {
        if (IsConnected.booleanValue()) {
            this.Stop_Manager(0);
            FrameReady = false;
            FlowReadManager.initCurve = true;
        } else {
            this.Start_Manager(1);
            if (this.Info.GetFlowType() == 1) {
                this.Start_Logging();
            }
            this.Start_Display();
        }
    }

    private void jButton_ViewActionPerformed(ActionEvent evt) {
        if (this.IsViewing.booleanValue()) {
            this.Stop_Display();
        } else {
            this.Start_Display();
        }
    }

    private void jComboBox_DecodLog_DecimTypeActionPerformed(ActionEvent evt) {
        switch (jComboBox_DecodLog_DecimType.getSelectedIndex()) {
            case 1: {
                jComboBox_DecodLog_DecimVal.removeAllItems();
                jComboBox_DecodLog_DecimVal.addItem("1 Hz");
                jComboBox_DecodLog_DecimVal.addItem("2 Hz");
                jComboBox_DecodLog_DecimVal.addItem("5 Hz");
                jComboBox_DecodLog_DecimVal.addItem("10 Hz");
                jComboBox_DecodLog_DecimVal.addItem("20 Hz");
                jComboBox_DecodLog_DecimVal.addItem("50 Hz");
                jComboBox_DecodLog_DecimVal.addItem("100 Hz");
                jComboBox_DecodLog_DecimVal.setSelectedItem(this.Info.GetLogDecimFreqInd(1));
                jComboBox_DecodLog_DecimVal.setVisible(true);
                break;
            }
            case 2: {
                jComboBox_DecodLog_DecimVal.removeAllItems();
                jComboBox_DecodLog_DecimVal.addItem("1/2");
                jComboBox_DecodLog_DecimVal.addItem("1/3");
                jComboBox_DecodLog_DecimVal.addItem("1/5");
                jComboBox_DecodLog_DecimVal.addItem("1/10");
                jComboBox_DecodLog_DecimVal.addItem("1/20");
                jComboBox_DecodLog_DecimVal.addItem("1/50");
                jComboBox_DecodLog_DecimVal.addItem("1/100");
                jComboBox_DecodLog_DecimVal.addItem("1/127");
                jComboBox_DecodLog_DecimVal.setSelectedItem(this.Info.GetLogDecimRatioInd(1));
                jComboBox_DecodLog_DecimVal.setVisible(true);
                break;
            }
            default: {
                jComboBox_DecodLog_DecimVal.setVisible(false);
            }
        }
    }

    private void jComboBox_LogDecodSegTypeActionPerformed(ActionEvent evt) {
        switch (jComboBox_LogDecodSegType.getSelectedIndex()) {
            case 2: {
                jLabel_DecodLogSegParam.setText("Size:");
                jLabel_DecodLogSegParam.setVisible(true);
                jTextField_LogDecodSegParam.setVisible(true);
                break;
            }
            case 1: {
                jLabel_DecodLogSegParam.setText("Time:");
                jLabel_DecodLogSegParam.setVisible(true);
                jTextField_LogDecodSegParam.setVisible(true);
                break;
            }
            default: {
                jLabel_DecodLogSegParam.setVisible(false);
                jTextField_LogDecodSegParam.setVisible(false);
            }
        }
    }

    private void jButton_SelectLogDecodActionPerformed(ActionEvent evt) {
        String File2 = this.FileSelection();
        if (File2.compareToIgnoreCase("") != 0) {
            jTextField_LogDecod.setText(File2);
        }
    }

    private void jCheckBox_LogDecodActionPerformed(ActionEvent evt) {
        this.Update_OutputParam_Visibility();
        if (jCheckBox_LogDecod.isSelected()) {
            if (Proto_List.GetDecoderByName(jComboBox_Protocol.getSelectedItem().toString()).GetCurvePlotImplementation()) {
                jCheckBox_NormalizedDatas.setEnabled(true);
            } else {
                jCheckBox_NormalizedDatas.setEnabled(false);
            }
        } else {
            jCheckBox_NormalizedDatas.setEnabled(false);
        }
    }

    private void jComboBox_InputLog_DecimTypeActionPerformed(ActionEvent evt) {
        switch (jComboBox_InputLog_DecimType.getSelectedIndex()) {
            case 1: {
                jComboBox_InputLog_DecimVal.removeAllItems();
                jComboBox_InputLog_DecimVal.addItem("1 Hz");
                jComboBox_InputLog_DecimVal.addItem("2 Hz");
                jComboBox_InputLog_DecimVal.addItem("5 Hz");
                jComboBox_InputLog_DecimVal.addItem("10 Hz");
                jComboBox_InputLog_DecimVal.addItem("20 Hz");
                jComboBox_InputLog_DecimVal.addItem("50 Hz");
                jComboBox_InputLog_DecimVal.addItem("100 Hz");
                jComboBox_InputLog_DecimVal.setSelectedItem(this.Info.GetLogDecimFreqInd(0));
                jComboBox_InputLog_DecimVal.setVisible(true);
                break;
            }
            case 2: {
                jComboBox_InputLog_DecimVal.removeAllItems();
                jComboBox_InputLog_DecimVal.addItem("1/2");
                jComboBox_InputLog_DecimVal.addItem("1/3");
                jComboBox_InputLog_DecimVal.addItem("1/5");
                jComboBox_InputLog_DecimVal.addItem("1/10");
                jComboBox_InputLog_DecimVal.addItem("1/20");
                jComboBox_InputLog_DecimVal.addItem("1/50");
                jComboBox_InputLog_DecimVal.addItem("1/100");
                jComboBox_InputLog_DecimVal.setSelectedItem(this.Info.GetLogDecimRatioInd(0));
                jComboBox_InputLog_DecimVal.setVisible(true);
                break;
            }
            default: {
                jComboBox_InputLog_DecimVal.setVisible(false);
            }
        }
    }

    private void jComboBox_LogInputSegTypeActionPerformed(ActionEvent evt) {
        switch (jComboBox_LogInputSegType.getSelectedIndex()) {
            case 2: {
                jLabel_InputLogSegParam.setText("Size:");
                jLabel_InputLogSegParam.setVisible(true);
                jTextField_LogInputSegParam.setVisible(true);
                break;
            }
            case 1: {
                jLabel_InputLogSegParam.setText("Time:");
                jLabel_InputLogSegParam.setVisible(true);
                jTextField_LogInputSegParam.setVisible(true);
                break;
            }
            default: {
                jLabel_InputLogSegParam.setVisible(false);
                jTextField_LogInputSegParam.setVisible(false);
            }
        }
    }

    private void jCheckBox_LogInputActionPerformed(ActionEvent evt) {
        this.Update_OutputParam_Visibility();
    }

    private void jButton_SelectLogInputActionPerformed(ActionEvent evt) {
        String File2 = this.FileSelection();
        if (File2.compareToIgnoreCase("") != 0) {
            jTextField_LogInput.setText(File2);
        }
    }

    private void jButton_SelectInputFileActionPerformed(ActionEvent evt) {
        String File2 = this.FileSelection();
        if (File2.compareToIgnoreCase("") != 0) {
            jTextField_File.setText(File2);
        }
    }

    private void jComboBox_FlowTypeActionPerformed(ActionEvent evt) {
        this.Update_InputParam_Visibility();
        this.Update_OutputParam_Visibility();
    }

    private void jComboBox_ProtocolActionPerformed(ActionEvent evt) {
        this.Update_OutputParam_Visibility();
        Encoder.Param_List.clearParams();
        FlowReadManager.initCurve = true;
        switch (Proto_List.GetDecoderByName(jComboBox_Protocol.getSelectedItem().toString()).GetProtoType()) {
            case 1: 
            case 2: {
                jComboBox_SelectView.setSelectedIndex(0);
                break;
            }
            case 0: {
                jComboBox_SelectView.setSelectedIndex(1);
            }
        }
        jComboBox_Protocol.setRenderer(new AlternateRowColorListCellRenderer());
        this.InfosBulle();
    }

    private void jButton_Curves_ReinitActionPerformed(ActionEvent evt) {
        FlowReadManager.Current_Chart.initallvalues();
        FlowReadManager.Current_Chart.setMessageCurve("Click On Start");
        FlowReadManager.point = 1;
    }

    private void jComboBox_Curve_ParamActionPerformed(ActionEvent evt) {
        jComboBox_Y_units.removeAllItems();
        if (jComboBox_Curve_Param.getItemCount() != 0) {
            String param = jComboBox_Curve_Param.getSelectedItem().toString();
            int idUnit = Encoder.Param_List.getParam(param).getIdUnit();
            int idTypeUnit = this.units_List.getTypeUnitById(idUnit);
            for (int i = 0; i < this.units_List.size(); ++i) {
                if (this.units_List.getTypeUnitByIndex(i) != idTypeUnit) continue;
                jComboBox_Y_units.addItem(this.units_List.getShortNameByIndex(i));
            }
            int ind_ordonnee = Encoder.Param_List.getIndexParam(jComboBox_Curve_Param.getSelectedItem().toString());
            String VarUnit = Encoder.Param_List.getParam(ind_ordonnee).getStringUnit();
            for (int i = 0; i < jComboBox_Y_units.getItemCount(); ++i) {
                if (!jComboBox_Y_units.getItemAt(i).toString().matches(VarUnit)) continue;
                jComboBox_Y_units.setSelectedIndex(i);
            }
            this.Curve_Param_Changing = true;
        }
    }

    private void jComboBox_Curve_Param_abscisseActionPerformed(ActionEvent evt) {
        jComboBox_X_units.removeAllItems();
        if (jComboBox_Curve_Param_abscisse.getItemCount() != 0) {
            String param = jComboBox_Curve_Param_abscisse.getSelectedItem().toString();
            int idUnit = Encoder.Param_List.getParam(param).getIdUnit();
            int idTypeUnit = this.units_List.getTypeUnitById(idUnit);
            for (int i = 0; i < this.units_List.size(); ++i) {
                if (this.units_List.getTypeUnitByIndex(i) != idTypeUnit) continue;
                jComboBox_X_units.addItem(this.units_List.getShortNameByIndex(i));
            }
            int ind_abscisse = Encoder.Param_List.getIndexParam(jComboBox_Curve_Param_abscisse.getSelectedItem().toString());
            String VarUnit = Encoder.Param_List.getParam(ind_abscisse).getStringUnit();
            for (int i = 0; i < jComboBox_X_units.getItemCount(); ++i) {
                if (!jComboBox_X_units.getItemAt(i).toString().matches(VarUnit)) continue;
                jComboBox_X_units.setSelectedIndex(i);
            }
            this.Curve_Param_Changing = true;
        }
    }

    private void jTextField_YminActionPerformed(ActionEvent evt) {
        if (!automatic_scale) {
            Double Ymax;
            Double Ymin;
            try {
                Ymin = new Double(jTextField_Ymin.getText());
            }
            catch (NumberFormatException e) {
                Ymin = new Double("0");
                jTextField_Ymin.setText("0");
            }
            try {
                Ymax = new Double(jTextField_Ymax.getText());
            }
            catch (NumberFormatException e) {
                Ymax = new Double("10");
                jTextField_Ymax.setText("0");
            }
            FlowReadManager.Current_Chart.setYaxisRange(Ymin, Ymax, (Ymax - Ymin) / 10.0);
        }
    }

    private void jTextField_HRPPrecisionActionPerformed(ActionEvent evt) {
    }

    private void jTextField_YmaxActionPerformed(ActionEvent evt) {
        if (!automatic_scale) {
            Double Ymax;
            Double Ymin;
            try {
                Ymin = new Double(jTextField_Ymin.getText());
            }
            catch (NumberFormatException e) {
                Ymin = new Double("0");
                jTextField_Ymin.setText("0");
            }
            try {
                Ymax = new Double(jTextField_Ymax.getText());
            }
            catch (NumberFormatException e) {
                Ymax = new Double("10");
                jTextField_Ymax.setText("0");
            }
            FlowReadManager.Current_Chart.setYaxisRange(Ymin, Ymax, (Ymax - Ymin) / 10.0);
        }
    }

    private void jToggleButton_StartActionPerformed(ActionEvent evt) {
        boolean bl = trace_start = !trace_start;
        if (trace_start) {
            jToggleButton_Start.setText("STOP");
            jComboBox_Curve_Param.setEnabled(false);
            jComboBox_Curve_Param_abscisse.setEnabled(false);
            jComboBox_Y_units.setEnabled(false);
            jComboBox_X_units.setEnabled(false);
            jButton_Curves_Reinit.setEnabled(false);
            if (this.Curve_Param_Changing) {
                FlowReadManager.Current_Chart = null;
                FlowReadManager.point = 1;
                String[] Chart_Legend = new String[4];
                Chart_Legend[0] = jComboBox_Curve_Param.getSelectedItem().toString();
                String yAxisLabel = jComboBox_Y_units.getSelectedItem().toString();
                String xAxisLabel = jComboBox_X_units.getSelectedItem().toString();
                FlowReadManager.Current_Chart = new jFreeChart_XY("Graph", 1, Chart_Legend, xAxisLabel, yAxisLabel);
                FlowReadManager.Current_Chart.setTitle("", new Font("Tahoma", 2, 11));
                FlowReadManager.Current_Chart.setChartPanel(jPanel_Chart);
                FlowReadManager.Current_Chart.viewChart(jPanel_Chart);
                this.Curve_Param_Changing = false;
                first_use = true;
            }
            if (first_use) {
                if (automatic_scale) {
                    FlowReadManager.Current_Chart.setYaxisAutoRange();
                    first_use = false;
                }
                if (automatic_scale_X) {
                    FlowReadManager.Current_Chart.setXaxisAutoRange();
                    first_use = false;
                }
            }
        } else {
            jToggleButton_Start.setText("START");
            jComboBox_Curve_Param.setEnabled(true);
            jComboBox_Curve_Param_abscisse.setEnabled(true);
            jComboBox_Y_units.setEnabled(true);
            jComboBox_X_units.setEnabled(true);
            jButton_Curves_Reinit.setEnabled(true);
        }
    }

    private void jCheckBox_Automatic_ScaleActionPerformed(ActionEvent evt) {
        if (jCheckBox_Automatic_Scale.isSelected()) {
            automatic_scale = true;
            FlowReadManager.Current_Chart.setYaxisAutoRange();
            jTextField_Ymax.setEnabled(false);
            jTextField_Ymin.setEnabled(false);
        } else {
            automatic_scale = false;
            jTextField_Ymax.setEnabled(true);
            jTextField_Ymin.setEnabled(true);
            jTextField_Ymax.postActionEvent();
        }
    }

    private void jTextField_substract_valueActionPerformed(ActionEvent evt) {
    }

    private void jComboBox_Y_unitsActionPerformed(ActionEvent evt) {
        this.Curve_Param_Changing = true;
    }

    private void jTextField_XminActionPerformed(ActionEvent evt) {
        if (!automatic_scale_X) {
            Double Xmax;
            Double Xmin;
            try {
                Xmin = new Double(jTextField_Xmin.getText());
            }
            catch (NumberFormatException e) {
                Xmin = new Double("0");
                jTextField_Xmin.setText("0");
            }
            try {
                Xmax = new Double(jTextField_Xmax.getText());
            }
            catch (NumberFormatException e) {
                Xmax = new Double("100");
                jTextField_Xmax.setText("0");
            }
            FlowReadManager.Current_Chart.setXaxisDomain(Xmin, Xmax, (Xmax - Xmin) / 10.0);
        }
    }

    private void jTextField_XmaxActionPerformed(ActionEvent evt) {
        if (!automatic_scale_X) {
            Double Xmax;
            Double Xmin;
            try {
                Xmin = new Double(jTextField_Xmin.getText());
            }
            catch (NumberFormatException e) {
                Xmin = new Double("0");
                jTextField_Xmin.setText("0");
            }
            try {
                Xmax = new Double(jTextField_Xmax.getText());
            }
            catch (NumberFormatException e) {
                Xmax = new Double("100");
                jTextField_Xmax.setText("0");
            }
            FlowReadManager.Current_Chart.setXaxisDomain(Xmin, Xmax, (Xmax - Xmin) / 10.0);
        }
    }

    private void jCheckBox_Automatic_Scale_XActionPerformed(ActionEvent evt) {
        if (this.jCheckBox_Automatic_Scale_X.isSelected()) {
            automatic_scale_X = true;
            FlowReadManager.Current_Chart.setXaxisAutoRange();
            jTextField_Xmax.setEnabled(false);
            jTextField_Xmin.setEnabled(false);
        } else {
            automatic_scale_X = false;
            jTextField_Xmax.setEnabled(true);
            jTextField_Xmin.setEnabled(true);
            jTextField_Xmax.postActionEvent();
        }
    }

    private void jCheckBox_glissantActionPerformed(ActionEvent evt) {
        try {
            fenetre = new Integer(jTextField_Fenetre.getText());
        }
        catch (NumberFormatException e) {
            fenetre = new Integer("600");
            jTextField_Fenetre.setText("600");
        }
        if (!jCheckBox_glissant.isSelected()) {
            this.jCheckBox_Automatic_Scale_XActionPerformed(evt);
        }
    }

    private void jTextField_FenetreActionPerformed(ActionEvent evt) {
        if (!jCheckBox_glissant.isSelected()) {
            this.jCheckBox_Automatic_Scale_XActionPerformed(evt);
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        Calendar calendar = Calendar.getInstance();
        int ind_abscisse = Encoder.Param_List.getIndexParam(jComboBox_Curve_Param_abscisse.getSelectedItem().toString());
        System.out.println(calendar.get(11) + ":" + calendar.get(12) + ":" + calendar.get(13) + " - unit\u00e9 d'origine : " + Encoder.Param_List.getParam(ind_abscisse).getStringUnit());
    }

    private void jCheckBox_NormalizedDatasActionPerformed(ActionEvent evt) {
        IsStdDecoding = jCheckBox_NormalizedDatas.isSelected() ? Boolean.valueOf(true) : Boolean.valueOf(false);
    }

    private void jComboBox_X_unitsActionPerformed(ActionEvent evt) {
        this.Curve_Param_Changing = true;
    }

    public void Start_Manager(int _Mode) {
        jTabbedPane_Main.setEnabledAt(0, false);
        Decoder FlowDecoder = Proto_List.GetDecoderByName(this.Info.GetProtocolName());
        if (FlowDecoder.GetCurvePlotImplementation()) {
            jTabbedPane_Main.setEnabledAt(4, true);
            jTabbedPane_Main.setEnabledAt(5, true);
        }
        Manager.Start(FlowDecoder, this.Encod, _Mode);
        IsConnected = true;
        this.Update_ConnectButtonState();
        this.Update_LogButtonState();
        this.Update_ViewSelectionState();
    }

    public void Stop_Manager(int Source) {
        jTabbedPane_Main.setEnabledAt(0, true);
        jTabbedPane_Main.setEnabledAt(4, false);
        jTabbedPane_Main.setEnabledAt(5, false);
        this.Stop_Logging();
        this.Stop_Display();
        if (Source == 0) {
            Manager.Stop();
        }
        IsConnected = false;
        this.Update_ConnectButtonState();
        this.Update_LogButtonState();
        this.Update_ViewSelectionState();
    }

    void Update_ConnectButtonState() {
        if (!IsConnected.booleanValue()) {
            switch (this.Info.GetFlowType()) {
                case 0: {
                    jButton_Connect.setText("No Input Flow");
                    break;
                }
                case 1: {
                    jButton_Connect.setText("Open File");
                    break;
                }
                case 2: {
                    jButton_Connect.setText("Connect on Ethernet");
                    break;
                }
                case 3: {
                    jButton_Connect.setText("Connect on Serial");
                }
            }
        } else {
            switch (this.Info.GetFlowType()) {
                case 0: {
                    jButton_Connect.setText("No Input Flow");
                    break;
                }
                case 1: {
                    jButton_Connect.setText("Close File");
                    break;
                }
                case 2: {
                    jButton_Connect.setText("Disconnect from Ethernet");
                    break;
                }
                case 3: {
                    jButton_Connect.setText("Disconnect from Serial");
                }
            }
        }
        if (this.Info.GetFlowType() == 0 || this.Info.GetFlowType() == 1 && this.Info.GetInputFileName().equalsIgnoreCase("")) {
            jButton_Connect.setEnabled(false);
        } else {
            jButton_Connect.setEnabled(true);
        }
    }

    void Update_LogButtonState() {
        boolean Available = true;
        if (this.Info.GetFlowType() == 0) {
            Available = false;
        }
        if (!IsConnected.booleanValue()) {
            Available = false;
        }
        if (!this.Info.IsInputLogEnable(0) && !this.Info.IsInputLogEnable(1)) {
            Available = false;
        }
        if (!Available) {
            jButton_Log.setText("Start Logging");
            jButton_Log.setEnabled(false);
        } else {
            if (IsLogging.booleanValue()) {
                jButton_Log.setText("Stop Logging");
            } else {
                jButton_Log.setText("Start Logging");
            }
            jButton_Log.setEnabled(true);
        }
    }

    void Update_ViewButtonState() {
        if (this.IsViewing.booleanValue()) {
            jButton_View.setText("Pause");
        } else {
            jButton_View.setText("View");
        }
    }

    void Update_ViewSelectionState() {
        if (IsConnected.booleanValue()) {
            jComboBox_SelectView.setEnabled(false);
        } else {
            jComboBox_SelectView.setEnabled(true);
        }
    }

    public void Start_Logging() {
        Manager.SetLogEnable(true);
        IsLogging = true;
        jTabbedPane_Main.setEnabledAt(1, false);
        this.Update_LogButtonState();
    }

    public void Stop_Logging() {
        Manager.SetLogEnable(false);
        IsLogging = false;
        jTabbedPane_Main.setEnabledAt(1, true);
        this.Update_LogButtonState();
    }

    public static boolean IsLogging() {
        return IsLogging;
    }

    public void Stop_Display() {
        this.Display.DisplayStop();
        this.IsViewing = false;
        this.Update_ViewButtonState();
    }

    public void Start_Display() {
        this.Display.DisplayStart();
        this.IsViewing = true;
        this.Update_ViewButtonState();
    }

    void UpdateLogggerDecoderParam() {
        if (jTextField_IPAdress1.getText().equalsIgnoreCase("")) {
            jTextField_IPAdress1.setText("0");
        }
        if (jTextField_IPAdress2.getText().equalsIgnoreCase("")) {
            jTextField_IPAdress2.setText("0");
        }
        if (jTextField_IPAdress3.getText().equalsIgnoreCase("")) {
            jTextField_IPAdress3.setText("0");
        }
        if (jTextField_IPAdress4.getText().equalsIgnoreCase("")) {
            jTextField_IPAdress4.setText("0");
        }
        if (jTextField_IPPort.getText().equalsIgnoreCase("")) {
            jTextField_IPPort.setText("0");
        }
        if (jTextField_LogInput.getText().compareTo(jTextField_LogDecod.getText()) == 0) {
            jTextField_LogDecod.setText("");
        }
        this.Info.SetFlowType(jComboBox_FlowType.getSelectedIndex());
        this.Info.SetProtocol(jComboBox_Protocol.getSelectedIndex(), jComboBox_Protocol.getSelectedItem().toString());
        this.Info.SetFrequency(new Integer(jTextField_Frequency.getText()).intValue());
        this.Info.SetInputFile(jTextField_File.getText());
        this.Info.SetEthernetParam(jComboBox_ConnectionType.getSelectedIndex(), jTextField_IPAdress1.getText() + "." + jTextField_IPAdress2.getText() + "." + jTextField_IPAdress3.getText() + "." + jTextField_IPAdress4.getText(), jTextField_IPPort.getText());
        this.Info.SetSerialParam(jComboBox_Port.getSelectedItem().toString(), jComboBox_Baudrate.getSelectedIndex(), jComboBox_DataBits.getSelectedIndex(), jComboBox_Parity.getSelectedIndex(), jComboBox_StopBits.getSelectedIndex());
        int Decimation_Freq = 0;
        int Decimation_Ratio = 0;
        switch (jComboBox_InputLog_DecimType.getSelectedIndex()) {
            case 1: {
                Decimation_Freq = jComboBox_InputLog_DecimVal.getSelectedIndex();
                Decimation_Ratio = 0;
                break;
            }
            case 2: {
                Decimation_Freq = 0;
                Decimation_Ratio = jComboBox_InputLog_DecimVal.getSelectedIndex();
                break;
            }
            default: {
                Decimation_Freq = 0;
                Decimation_Ratio = 0;
            }
        }
        this.Info.SetLogParam(0, jCheckBox_LogInput.isSelected(), jComboBox_LogInputSegType.getSelectedIndex(), Integer.parseInt("0" + jTextField_LogInputSegParam.getText()), jComboBox_InputLog_DecimType.getSelectedIndex(), Decimation_Freq, Decimation_Ratio, jTextField_LogInput.getText());
        switch (jComboBox_DecodLog_DecimType.getSelectedIndex()) {
            case 1: {
                Decimation_Freq = jComboBox_DecodLog_DecimVal.getSelectedIndex();
                Decimation_Ratio = 0;
                break;
            }
            case 2: {
                Decimation_Freq = 0;
                Decimation_Ratio = jComboBox_DecodLog_DecimVal.getSelectedIndex();
                break;
            }
            default: {
                Decimation_Freq = 0;
                Decimation_Ratio = 0;
            }
        }
        this.Info.SetLogParam(1, jCheckBox_LogDecod.isSelected(), jComboBox_LogDecodSegType.getSelectedIndex(), Integer.parseInt("0" + jTextField_LogDecodSegParam.getText()), jComboBox_DecodLog_DecimType.getSelectedIndex(), Decimation_Freq, Decimation_Ratio, jTextField_LogDecod.getText());
        String InfoConnection = new String();
        Color InfoConnectionColor = Color.BLUE;
        InfoConnection = "";
        switch (jComboBox_FlowType.getSelectedIndex()) {
            case 0: {
                InfoConnection = InfoConnection + "None";
                InfoConnectionColor = Color.BLACK;
                break;
            }
            case 1: {
                InfoConnection = InfoConnection + "File  [ ";
                InfoConnection = InfoConnection + (this.Info.GetReducedInputFileName(24).equalsIgnoreCase("") ? "None" : this.Info.GetReducedInputFileName(24));
                InfoConnection = InfoConnection + " ]";
                break;
            }
            case 2: {
                InfoConnection = InfoConnection + "Ethernet  [ ";
                InfoConnection = InfoConnection + jComboBox_ConnectionType.getItemAt(this.Info.GetEthernetConnType()).toString();
                InfoConnection = InfoConnection + " - ";
                InfoConnection = InfoConnection + this.Info.GetEthernetIPAdress();
                InfoConnection = InfoConnection + " - ";
                InfoConnection = InfoConnection + this.Info.GetEthernetIPPort();
                InfoConnection = InfoConnection + " ]";
                break;
            }
            case 3: {
                InfoConnection = InfoConnection + "Serial  [ ";
                InfoConnection = InfoConnection + this.Info.GetSerialPort();
                InfoConnection = InfoConnection + " - ";
                InfoConnection = InfoConnection + jComboBox_Baudrate.getItemAt(this.Info.GetBaudrate()).toString();
                InfoConnection = InfoConnection + " - ";
                InfoConnection = InfoConnection + jComboBox_DataBits.getItemAt(this.Info.GetDataBits()).toString();
                InfoConnection = InfoConnection + " - ";
                InfoConnection = InfoConnection + jComboBox_Parity.getItemAt(this.Info.GetParity()).toString();
                InfoConnection = InfoConnection + " - ";
                InfoConnection = InfoConnection + jComboBox_StopBits.getItemAt(this.Info.GetStopBits()).toString().replace("bit", "stop");
                InfoConnection = InfoConnection + " ]";
            }
        }
        String InfoProtocol = new String();
        Color InfoProtocolColor = Color.BLUE;
        InfoProtocol = "";
        if (this.Info.GetProtocolId() == 0) {
            InfoProtocolColor = Color.BLACK;
        }
        InfoProtocol = InfoProtocol + jComboBox_Protocol.getItemAt(this.Info.GetProtocolId()).toString();
        String InfoInputLogSeg = new String();
        Color InfoInputLogSegColor = Color.BLUE;
        InfoInputLogSeg = "";
        if (!this.Info.IsInputLogEnable(0)) {
            InfoInputLogSeg = InfoInputLogSeg + "None";
            InfoInputLogSegColor = Color.BLACK;
        } else {
            InfoInputLogSeg = InfoInputLogSeg + "[";
            switch (this.Info.GetLogSegmentType(0)) {
                case 2: {
                    InfoInputLogSeg = InfoInputLogSeg + this.Info.GetLogSegmentParam(0) + "Mo";
                    InfoInputLogSeg = InfoInputLogSeg + " - ";
                    break;
                }
                case 1: {
                    InfoInputLogSeg = InfoInputLogSeg + this.Info.GetLogSegmentParam(0) + "s";
                    InfoInputLogSeg = InfoInputLogSeg + " - ";
                }
            }
            switch (this.Info.GetLogDecimType(0)) {
                case 1: {
                    InfoInputLogSeg = InfoInputLogSeg + jComboBox_InputLog_DecimVal.getItemAt(this.Info.GetLogDecimFreqInd(0)).toString();
                    break;
                }
                case 2: {
                    InfoInputLogSeg = InfoInputLogSeg + jComboBox_InputLog_DecimVal.getItemAt(this.Info.GetLogDecimRatioInd(0)).toString();
                }
            }
            InfoInputLogSeg = InfoInputLogSeg + "]";
            InfoInputLogSeg = InfoInputLogSeg.replace(" - ]", "]").replace("[]", "");
            InfoInputLogSeg = this.Info.GetReducedFileName(0, 30 - InfoInputLogSeg.length()) + "  " + InfoInputLogSeg;
            InfoInputLogSeg = InfoInputLogSeg + "  ";
        }
        String InfoDecodLogSeg = new String();
        Color InfoDecodLogSegColor = Color.BLUE;
        InfoDecodLogSeg = "";
        if (!this.Info.IsInputLogEnable(1)) {
            InfoDecodLogSeg = InfoDecodLogSeg + "None";
            InfoDecodLogSegColor = Color.BLACK;
        } else {
            InfoDecodLogSeg = InfoDecodLogSeg + "[";
            switch (this.Info.GetLogSegmentType(1)) {
                case 2: {
                    InfoDecodLogSeg = InfoDecodLogSeg + this.Info.GetLogSegmentParam(1) + "Mo";
                    InfoDecodLogSeg = InfoDecodLogSeg + " - ";
                    break;
                }
                case 1: {
                    InfoDecodLogSeg = InfoDecodLogSeg + this.Info.GetLogSegmentParam(1) + "s";
                    InfoDecodLogSeg = InfoDecodLogSeg + " - ";
                }
            }
            switch (this.Info.GetLogDecimType(1)) {
                case 1: {
                    InfoDecodLogSeg = InfoDecodLogSeg + jComboBox_DecodLog_DecimVal.getItemAt(this.Info.GetLogDecimFreqInd(1)).toString();
                    break;
                }
                case 2: {
                    InfoDecodLogSeg = InfoDecodLogSeg + jComboBox_DecodLog_DecimVal.getItemAt(this.Info.GetLogDecimRatioInd(1)).toString();
                }
            }
            InfoDecodLogSeg = InfoDecodLogSeg + "]";
            InfoDecodLogSeg = InfoDecodLogSeg.replace(" - ]", "]").replace("[]", "");
            InfoDecodLogSeg = this.Info.GetReducedFileName(1, 30 - InfoDecodLogSeg.length()) + "  " + InfoDecodLogSeg;
        }
        jLabel_InfoConnectiontype.setText(InfoConnection);
        jLabel_InfoProtocol.setText(InfoProtocol);
        jLabel_InfoInputLog.setText(InfoInputLogSeg);
        jLabel_InfoDecodLog.setText(InfoDecodLogSeg);
        jLabel_InfoConnectiontype.setForeground(InfoConnectionColor);
        jLabel_InfoProtocol.setForeground(InfoProtocolColor);
        jLabel_InfoInputLog.setForeground(InfoInputLogSegColor);
        jLabel_InfoDecodLog.setForeground(InfoDecodLogSegColor);
        if (this.Info.GetFlowType() == 1) {
            jLabel_InputStateId.setText("Reading:");
        } else {
            jLabel_InputStateId.setText("Reception:");
        }
    }

    public void UpdateLogggerDecoderParamDefault(String ProName, String InFile, String OutFile, String Frequency) {
        this.Info.SetFlowType(1);
        if (Proto_List.GetDecoderIdByName(ProName) != 0) {
            this.Info.SetProtocol(Proto_List.GetDecoderIdByName(ProName), ProName);
        } else {
            System.out.println("The specified protocol is not available.");
            System.exit(0);
        }
        this.Info.SetFrequency(Integer.parseInt(Frequency));
        this.Info.SetInputFile(InFile);
        this.Info.SetLogParam(0, false);
        this.Info.SetLogParam(1, true, 0, 0, 0, 0, 0, OutFile);
    }

    public void UpdateLogggerDecoderParamDefault(String ProName, String LogFile, String Mode, String IPAdr, String Port) {
        if (Proto_List.GetDecoderIdByName(ProName) != 0) {
            this.Info.SetProtocol(Proto_List.GetDecoderIdByName(ProName), ProName);
        } else {
            System.out.println("The specified protocol is not available.");
            System.exit(0);
        }
        this.Info.SetFlowType(2);
        this.Info.SetEthernetParam(Integer.parseInt(Mode), IPAdr, Port);
        this.Info.SetLogParam(1, false);
        this.Info.SetLogParam(0, true, 0, 0, 0, 0, 0, LogFile);
    }

    public void UpdateLogggerDecoderParamDefault(String ProName, String LogFile, String Port, String BaudRate, String DataBits, String Parity, String StopBits) {
        if (Proto_List.GetDecoderIdByName(ProName) != 0) {
            this.Info.SetProtocol(Proto_List.GetDecoderIdByName(ProName), ProName);
        } else {
            System.out.println("The specified protocol is not available.");
            System.exit(0);
        }
        this.Info.SetFlowType(3);
        this.Info.SetSerialParam(Port, Integer.parseInt(BaudRate), Integer.parseInt(DataBits), Integer.parseInt(Parity), Integer.parseInt(StopBits));
        this.Info.SetLogParam(1, false);
        this.Info.SetLogParam(0, true, 0, 0, 0, 0, 0, LogFile);
    }

    public void UpdateSpecificDecoderParam() {
        this.Info.SetPrecisionWithDataType(1, new Integer(jTextField_HRPPrecision.getText()));
        this.Info.SetPrecisionWithDataType(2, new Integer(jTextField_HRPRatesPrecision.getText()));
        this.Info.SetPrecisionWithDataType(3, new Integer(jTextField_PositionPrecision.getText()));
        this.Info.SetPrecisionWithDataType(4, new Integer(jTextField_SpeedsPrecision.getText()));
        this.Info.SetPrecisionWithDataType(5, new Integer(jTextField_ACCPrecision.getText()));
        this.Info.SetPrecisionWithDataType(6, new Integer(jTextField_ROTPrecision.getText()));
        this.Info.SetSeparator(jTextField_Separator.getText());
    }

    public void UpdateSpecificDecoderParamDefault(String Rev, String RevDate) {
        this.Info.SetPrecisionWithDataType(1, 6);
        this.Info.SetPrecisionWithDataType(2, 6);
        this.Info.SetPrecisionWithDataType(3, 6);
        this.Info.SetPrecisionWithDataType(4, 6);
        this.Info.SetPrecisionWithDataType(5, 6);
        this.Info.SetPrecisionWithDataType(6, 6);
        this.Info.SetSeparator("\t");
        this.Info.SetFrequency(100.0);
        this.Info.setRevisionDate(RevDate);
        this.Info.setRevision(Rev);
    }

    public void SetjComboSelectedIndex(JComboBox _ComboBox, int Selected_Item) {
        if (_ComboBox.getItemCount() != 0) {
            if (Selected_Item < _ComboBox.getItemCount()) {
                _ComboBox.setSelectedIndex(Selected_Item);
            } else {
                _ComboBox.setSelectedIndex(0);
            }
        }
    }

    public static void SetMessage(int Type2, String _Message, Color _Color) {
        switch (Type2) {
            case 0: {
                jLabel_ConnState.setText(_Message);
                jLabel_ConnState.setForeground(_Color);
                break;
            }
            case 1: {
                jLabel_InputState.setText(_Message);
                jLabel_InputState.setForeground(_Color);
                break;
            }
            case 2: {
                jLabel_LogState.setText(_Message);
                jLabel_LogState.setForeground(_Color);
                break;
            }
            case 3: {
                jLabel_DecodState.setText(_Message);
                jLabel_DecodState.setForeground(_Color);
            }
        }
    }

    String FileSelection() {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Protocol Logger/Decoder: Open");
        chooser.setCurrentDirectory(new File(this.Info.GetWorkDirectory()));
        chooser.setFileFilter(new JTxtFileFilter());
        if (chooser.showOpenDialog(this) == 0) {
            this.Info.SetWorkDirectory(chooser.getSelectedFile().getParent());
            return chooser.getSelectedFile().getAbsolutePath();
        }
        return "";
    }

    static {
        IsConnected = false;
        IsLogging = false;
        IsStdDecoding = false;
        trace_start = false;
        automatic_scale = true;
        automatic_scale_X = true;
        first_use = true;
        curves_count = 0;
        fenetre = 600;
        jComboBoxBoardType = new JComboBox();
    }

    private static class AlternateRowColorListCellRenderer
    extends DefaultListCellRenderer {
        private AlternateRowColorListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel cmp = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            cmp.setOpaque(true);
            if (Proto_List.GetDecoderById(index).GetCurvePlotImplementation()) {
                cmp.setForeground(new Color(80, 220, 80));
            }
            return cmp;
        }
    }
}

