/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;

public class ADVANS_NAV_IMU_Decoder
extends Decoder {
    private Encoder Encod;

    public ADVANS_NAV_IMU_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(true);
        int Start_Blk_Length = 2;
        byte[] Start_Blk = new byte[Start_Blk_Length];
        Start_Blk[0] = 36;
        Start_Blk[1] = 0;
        int Length_Blk = 118;
        this.DecodeInit(0, Length_Blk, Start_Blk, Start_Blk_Length);
    }

    @Override
    public String GetFileHeading() {
        String sep = "\t";
        this.Info.SetSeparator(sep);
        return "Standard decoding only";
    }

    @Override
    public int InterpretFrame(byte[] Detected_Frame, int Lenght) {
        int Chk = 0;
        for (int i = 0; i < 116; ++i) {
            Chk += this.Bytes_Frame[i] & 0xFF;
        }
        int ChkRec = this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 116, 1);
        if (Chk != ChkRec) {
            System.out.print("Checksum error\n");
            this.InterpretedFrame = this.InterpretString("Checksum error");
            return -1;
        }
        if (this.Bytes_Frame[0] != 36) {
            this.InterpretedFrame = this.InterpretString("Header 1 error");
            return -1;
        }
        if (this.Bytes_Frame[1] != 0) {
            this.InterpretedFrame = this.InterpretString("Header 2 error");
            return -1;
        }
        int Time = (int)this.Convert_4Bytes_to_UnsignedInt(this.Bytes_Frame, 2, 1);
        int hours = (Time & 0xF8000000) >> 27;
        if (hours > 24) {
            this.InterpretedFrame = this.InterpretString("Hour field is upper than 24 hours");
            return -1;
        }
        int minutes = (Time & 0x7E00000) >> 21;
        if (minutes > 60) {
            this.InterpretedFrame = this.InterpretString("Minute field is upper than 60 minutes");
            return -1;
        }
        int secs = (Time & 0x1F8000) >> 15;
        if (secs > 60) {
            this.InterpretedFrame = this.InterpretString("Second field is upper than 60 seconds");
            return -1;
        }
        int microsec = Time & Short.MAX_VALUE;
        double TimeInSeconds = (double)hours * 3600.0 + (double)minutes * 60.0 + (double)secs + (double)microsec / 20000.0;
        float RawRotXV1 = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 6, 1);
        float RawRotXV2 = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 10, 1);
        float RawRotXV3 = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 14, 1);
        float AccXV1 = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 18, 1);
        float AccXV2 = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 22, 1);
        float AccXV3 = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 26, 1);
        float Roll = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 30, 1);
        float Pitch = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 34, 1);
        float Heading = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 38, 1);
        float Longitude = (float)(180.0 * (double)this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 42, 1) / 2.147483648E9);
        float Latitude = (float)(180.0 * (double)this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 46, 1) / 2.147483648E9);
        float Altitude = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 50, 1);
        float NorthSpeed = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 54, 1);
        float EastSpeed = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 58, 1);
        float VertSpeed = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 62, 1);
        float RollSD = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 66, 1);
        float PitchSD = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 70, 1);
        float HeadingSD = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 74, 1);
        float NorthSpeedSD = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 78, 1);
        float EastSpeedSD = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 82, 1);
        float VertSpeedSD = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 86, 1);
        float LatitudeSD = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 90, 1);
        float LongitudeSD = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 94, 1);
        float AltitudeSD = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 98, 1);
        int UserStatus = this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 102, 1);
        int Alg1tatus = this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 106, 1);
        int Alg2Status = this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 110, 1);
        float Temperature = (float)((double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 114, 1) / 10.0 - 273.15);
        this.Encod.setValue(708, Character.valueOf((char)this.Bytes_Frame[0]), 1000);
        this.Encod.setValue(710, this.Bytes_Frame[1], 1000);
        this.Encod.setValue(778, TimeInSeconds, 31);
        this.Encod.setValue(610, Integer.toHexString(UserStatus), 1000);
        this.Encod.setValue(606, Integer.toHexString(Alg1tatus), 1000);
        this.Encod.setValue(607, Integer.toHexString(Alg2Status), 1000);
        if (this.GetCurvePlotImplementation()) {
            this.Encod.setValue(103, Float.valueOf(Heading), 2);
            this.Encod.setValue(107, Float.valueOf(HeadingSD), 2);
            this.Encod.setValue(104, Float.valueOf(Roll), 2);
            this.Encod.setValue(108, Float.valueOf(RollSD), 2);
            this.Encod.setValue(105, Float.valueOf(Pitch), 2);
            this.Encod.setValue(109, Float.valueOf(PitchSD), 2);
            this.Encod.setValue(463, Float.valueOf(RawRotXV1), 52);
            this.Encod.setValue(464, Float.valueOf(RawRotXV2), 52);
            this.Encod.setValue(465, Float.valueOf(RawRotXV3), 52);
            this.Encod.setValue(466, Float.valueOf(AccXV1), 43);
            this.Encod.setValue(467, Float.valueOf(AccXV2), 43);
            this.Encod.setValue(468, Float.valueOf(AccXV3), 43);
            this.Encod.setValue(136, Float.valueOf(NorthSpeed), 21);
            this.Encod.setValue(141, Float.valueOf(NorthSpeedSD), 21);
            this.Encod.setValue(137, Float.valueOf(EastSpeed), 21);
            this.Encod.setValue(142, Float.valueOf(EastSpeedSD), 21);
            this.Encod.setValue(138, Float.valueOf(VertSpeed), 21);
            this.Encod.setValue(143, Float.valueOf(VertSpeedSD), 21);
            this.Encod.setValue(124, Float.valueOf(Latitude), 1);
            this.Encod.setValue(129, Float.valueOf(LatitudeSD), 11);
            this.Encod.setValue(125, Float.valueOf(Longitude), 1);
            this.Encod.setValue(130, Float.valueOf(LongitudeSD), 11);
            this.Encod.setValue(126, Float.valueOf(Altitude), 11);
            this.Encod.setValue(131, Float.valueOf(AltitudeSD), 11);
            this.Encod.setValue(469, Float.valueOf(Temperature), 1000);
            this.Encod.setValue(724, ChkRec, 1000);
            LoggerDecoderFrame.FrameReady = true;
        }
        return 0;
    }
}

