/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;

public class AUVG3000_Decoder
extends Decoder {
    private final Encoder Encod;

    public AUVG3000_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(true);
        byte[] Start2 = new byte[5];
        Start2[0] = 113;
        Start2[1] = 113;
        Start2[2] = 113;
        Start2[3] = 113;
        super.DecodeInit(0, 98, Start2, 4);
    }

    @Override
    public String GetFileHeading() {
        String sep = this.Info.GetSeparator();
        return "Time(s)" + sep + "FractionOfSeconds(s)" + sep + "Lat(deg)" + sep + "Long(deg)" + sep + "LatStd(m)" + sep + "LongStd(m)" + sep + "HeadingStd(deg)" + sep + "RollStd(deg)" + sep + "PitchStd(deg)" + sep + "Depth(m)" + sep + "Heading(deg)" + sep + "Roll(deg)" + sep + "Pitch(deg)" + sep + "VNorth(m/s)" + sep + "VWest(m/s)" + sep + "VDepth(m/s)" + sep + "RollRate(deg/s)" + sep + "PitchRate(deg/s)" + sep + "HeadingRate(deg/s)" + sep + "AccXV1(m/s2)" + sep + "AccXV2(m/s2)" + sep + "AccXV3(m/s2)" + sep + "UserStatus";
    }

    @Override
    public int InterpretFrame(byte[] Decoded_Frame, int Lenght) {
        float TimeSec = this.Convert_4Bytes_to_UnsignedInt(this.Bytes_Frame, 4, 1);
        float TimeMicroSec = (float)((double)this.Convert_2Bytes_to_UnsignedInt(this.Bytes_Frame, 8, 1) / 9999.0);
        float Lat = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 10, 1);
        float Long2 = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 14, 1);
        float LatStd = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 18, 1);
        float LongStd = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 22, 1);
        float HeadingStd = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 26, 1);
        float RollStd = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 30, 1);
        float PitchStd = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 34, 1);
        float Depth = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 38, 1);
        float Heading = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 42, 1);
        float Roll = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 46, 1);
        float Pitch = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 50, 1);
        float VNorth = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 54, 1);
        float VWest = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 58, 1);
        float VDepth = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 62, 1);
        float RollRate = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 66, 1);
        float PitchRate = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 70, 1);
        float HeadingRate = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 74, 1);
        float AccXV1 = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 78, 1);
        float AccXV2 = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 82, 1);
        float AccXV3 = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 86, 1);
        String UserStatus = Integer.toHexString(this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 90, 1));
        this.InterpretedFrame = this.InterpretFloat(TimeSec, 101);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(TimeMicroSec, 101);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Lat, 124);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Long2, 125);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(LatStd, 129);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(LongStd, 130);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(HeadingStd, 107);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(RollStd, 108);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(PitchStd, 109);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Depth, 246);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Heading, 103);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Roll, 104);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Pitch, 105);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(VNorth, 136);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(VWest, 137);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(VDepth, 138);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(RollRate, 111);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(PitchRate, 112);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(HeadingRate, 110);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(AccXV1, 121);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(AccXV2, 122);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(AccXV3, 123);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretString(UserStatus);
        this.InterpretedFrame_AddToList(this.InterpretedFrame);
        if (this.GetCurvePlotImplementation()) {
            this.Encod.setValue(100, Float.valueOf(TimeSec), 31);
            this.Encod.setValue(700, Float.valueOf(TimeMicroSec), 32);
            this.Encod.setValue(124, Float.valueOf(Lat), 1);
            this.Encod.setValue(125, Float.valueOf(Long2), 1);
            this.Encod.setValue(129, Float.valueOf(LatStd), 11);
            this.Encod.setValue(130, Float.valueOf(LongStd), 11);
            this.Encod.setValue(107, Float.valueOf(HeadingStd), 1);
            this.Encod.setValue(108, Float.valueOf(RollStd), 1);
            this.Encod.setValue(109, Float.valueOf(PitchStd), 1);
            this.Encod.setValue(126, Float.valueOf(-Depth), 11);
            this.Encod.setValue(103, Float.valueOf(Heading), 1);
            this.Encod.setValue(104, Float.valueOf(Roll), 1);
            this.Encod.setValue(105, Float.valueOf(-Pitch), 1);
            this.Encod.setValue(136, Float.valueOf(VNorth), 21);
            this.Encod.setValue(137, Float.valueOf(-VWest), 21);
            this.Encod.setValue(138, Float.valueOf(-VDepth), 21);
            this.Encod.setValue(110, Float.valueOf(HeadingRate), 51);
            this.Encod.setValue(111, Float.valueOf(RollRate), 51);
            this.Encod.setValue(112, Float.valueOf(PitchRate), 51);
            this.Encod.setValue(121, Float.valueOf(AccXV1), 43);
            this.Encod.setValue(122, Float.valueOf(AccXV2), 43);
            this.Encod.setValue(123, Float.valueOf(AccXV3), 43);
            this.Encod.setValue(610, UserStatus, 1000);
            LoggerDecoderFrame.FrameReady = true;
        }
        return 0;
    }
}

