/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;
import RegExp.RegExp;
import java.util.regex.Matcher;

public class BHO_GRAVI_Decoder
extends Decoder {
    private Encoder Encod;
    private int current_line;
    private boolean FirstFrameReceived = false;

    public BHO_GRAVI_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(true);
        this.current_line = 0;
        int Start_Blk_Length = 1;
        byte[] Start_Blk = new byte[Start_Blk_Length];
        Start_Blk[0] = 36;
        int Length_Blk = 0;
        this.DecodeInit(1, Length_Blk, Start_Blk, Start_Blk_Length);
    }

    @Override
    public int InterpretFrame(byte[] Decoded_Frame, int Lenght) {
        String sFrame_no_crlf = new String(Decoded_Frame, 0, Lenght - 2);
        ++this.current_line;
        String[] params = sFrame_no_crlf.replace("*", ",").split(",");
        if (!this.NmeaChkMatches(sFrame_no_crlf)) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " NMEA checksum error");
            return -1;
        }
        if (params[0].contentEquals("$GPGLL")) {
            if (this.FirstFrameReceived) {
                LoggerDecoderFrame.FrameReady = true;
            } else {
                this.FirstFrameReceived = true;
            }
            if (params.length != 9) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Format error");
                return -1;
            }
            Matcher m = RegExp.ptn_d2_ns_f2pt8.matcher(params[1]);
            if (!m.matches()) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Latitude format error:" + sFrame_no_crlf);
                return -1;
            }
            double Latitude = (double)Integer.parseInt(m.group(1)) + Double.parseDouble(m.group(2)) / 60.0;
            if (!RegExp.is_NS(params[2])) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Latitude sign format error:" + sFrame_no_crlf);
                return -1;
            }
            if (params[2].contentEquals("S")) {
                Latitude = -Latitude;
            }
            if (!(m = RegExp.ptn_d3_ns_f2pt8.matcher(params[3])).matches()) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Longitude format error:" + sFrame_no_crlf);
                return -1;
            }
            double Longitude = (double)Integer.parseInt(m.group(1)) + Double.parseDouble(m.group(2)) / 60.0;
            if (!RegExp.is_EW(params[4])) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Longitude sign format error:" + sFrame_no_crlf);
                return -1;
            }
            if (params[4].contentEquals("W")) {
                Longitude = -Longitude;
            }
            if (this.GetCurvePlotImplementation()) {
                this.Encod.setValue(124, Float.valueOf((float)Latitude), 1);
                this.Encod.setValue(125, Float.valueOf((float)Longitude), 1);
                this.Encod.setValue(100, Float.valueOf(new Double(params[5]).floatValue()), 34);
                this.Encod.setValue(1000, params[6], 1000);
                this.Encod.setValue(165, params[7], 1000);
            }
            this.InterpretedFrame_AddToList(sFrame_no_crlf);
        } else if (params[0].contentEquals("$GPVTG")) {
            if (params.length != 11) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Format error");
                return -1;
            }
            if (!RegExp.is_fpt3(params[1])) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Horizontal speed course format error:" + sFrame_no_crlf);
                return -1;
            }
            if (!RegExp.is_fpt3(params[5])) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Horizontal speed format error:" + sFrame_no_crlf);
                return -1;
            }
            double speedknots_in_ms = (double)new Double(params[5]).floatValue() * 0.5144444444444445;
            if (!RegExp.is_fpt3(params[7])) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Horizontal speed format error:" + sFrame_no_crlf);
                return -1;
            }
            if (this.GetCurvePlotImplementation()) {
                this.Encod.setValue(147, Float.valueOf(new Double(params[1]).floatValue()), 1);
                this.Encod.setValue(146, speedknots_in_ms, 21);
            }
            this.InterpretedFrame_AddToList(sFrame_no_crlf);
        } else {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Header error");
            return -1;
        }
        return 0;
    }
}

