/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;

public class DCN_NAV1_Fxx_Decoder
extends Decoder {
    private Encoder Encod;

    public DCN_NAV1_Fxx_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(false);
        int Start_Blk_Length = 1;
        byte[] Start_Blk_n1 = new byte[Start_Blk_Length];
        byte[] Start_Blk_n2 = new byte[Start_Blk_Length];
        Start_Blk_n1[0] = 27;
        Start_Blk_n2[0] = 40;
        int Length_Blk_n1 = 27;
        int Length_Blk_n2 = 40;
        this.DecodeInit(0, Length_Blk_n1, Start_Blk_n1, Start_Blk_Length);
        this.DecodeInit(0, Length_Blk_n2, Start_Blk_n2, Start_Blk_Length);
    }

    @Override
    public String GetFileHeading() {
        String sep = this.Info.GetSeparator();
        return "Status1" + sep + "Status2" + sep + "Hour(h)" + sep + "Ageing(ms)" + sep + "Heading(\u00b0)" + sep + "Roll(\u00b0)" + sep + "Pitch(\u00b0)" + sep + "Lat(\u00b0)" + sep + "Long(\u00b0)" + sep + "NorthSpeed(m/s)" + sep + "WestSpeed(m/s)" + sep + "DayOfYear" + sep + "Heave(m)" + sep + "EMLogSpeed(m/s)" + sep + "VerticalSpeed(m/s)" + sep + "LatStd(Nm)" + sep + "LongStd(Nm)" + sep + "HeadingStd(\u00b0)" + sep + "PosErr(Nm)";
    }

    @Override
    public int InterpretFrame(byte[] Detected_Frame, int Lenght) {
        int Status1 = this.Convert_1Byte_to_UnsignedInt(Detected_Frame, 1, 1);
        int Status2 = this.Convert_1Byte_to_UnsignedInt(Detected_Frame, 2, 1);
        float Hour = (float)((double)(this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, 3, 1) * 12L) / 2.147483648E9);
        int Ageing = this.Convert_1Byte_to_SignedInt(Detected_Frame, 7, 1);
        if (Ageing != 3) {
            return -1;
        }
        float Heading = (float)((double)this.Convert_3Bytes_to_UnsignedInt(Detected_Frame, 8, 1) * 180.0 / 8388608.0);
        float Roll = (float)((double)this.Convert_3Bytes_to_SignedInt(Detected_Frame, 11, 1) * 90.0 / 8388608.0);
        float Pitch = (float)((double)this.Convert_3Bytes_to_SignedInt(Detected_Frame, 14, 1) * 90.0 / 8388608.0);
        double Lat = (float)((double)this.Convert_3Bytes_to_SignedInt(Detected_Frame, 17, 1) * 90.0 / 8388608.0);
        double Long2 = (float)((double)this.Convert_3Bytes_to_SignedInt(Detected_Frame, 20, 1) * 180.0 / 8388608.0);
        float NorthVel = (float)((double)this.Convert_2Bytes_to_SignedInt(Detected_Frame, 23, 1) * 0.003662109375 * 0.5144444444444445);
        float WestVel = (float)((double)this.Convert_2Bytes_to_SignedInt(Detected_Frame, 25, 1) * 0.003662109375 * 0.5144444444444445);
        this.InterpretedFrame = this.InterpretIntegerAsBin(Status1);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsBin(Status2);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Hour, 3);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Ageing, 3);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Heading, 103);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Roll, 104);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Pitch, 105);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Lat, 124);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Long2, 125);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(NorthVel, 136);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(WestVel, 137);
        if (Detected_Frame[0] == 40) {
            float DayOfYear = (float)((double)this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 27, 1) * 256.0 / 32768.0);
            float Heave = (float)((double)this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 29, 1) * 360.0 / 32768.0);
            float EMLogSpeed = (float)((double)this.Convert_2Bytes_to_SignedInt(Detected_Frame, 31, 1) * 0.003662109375 * 0.5144444444444445);
            float VerticalSpeed = (float)((double)this.Convert_2Bytes_to_SignedInt(Detected_Frame, 33, 1) * 40.0 / 32768.0);
            int LatStd_ScaleBit = Detected_Frame[35] % 2;
            Detected_Frame[35] = (byte)(Detected_Frame[35] & 0xFE);
            float LatStd = this.Convert_1Byte_to_UnsignedInt(Detected_Frame, 35, 1);
            LatStd = LatStd_ScaleBit == 0 ? (float)((double)LatStd * 5.0 / 128.0) : (float)((double)LatStd * 0.121 / 128.0);
            int LongStd_ScaleBit = Detected_Frame[36] % 2;
            Detected_Frame[36] = (byte)(Detected_Frame[36] & 0xFE);
            float LongStd = this.Convert_1Byte_to_UnsignedInt(Detected_Frame, 36, 1);
            LongStd = LongStd_ScaleBit == 0 ? (float)((double)LongStd * 5.0 / 128.0) : (float)((double)LongStd * 0.121 / 128.0);
            float HeadingStd = (float)((double)this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 37, 1) / 32768.0);
            int PosErr_ScaleBit = Detected_Frame[39] % 2;
            Detected_Frame[39] = (byte)(Detected_Frame[39] & 0xFE);
            float PosErr = this.Convert_1Byte_to_UnsignedInt(Detected_Frame, 39, 1);
            PosErr = PosErr_ScaleBit == 0 ? (float)((double)PosErr * 5.0 / 128.0) : (float)((double)PosErr * 0.121 / 128.0);
            float CEP95 = (float)(1.2254 * (double)(LatStd + LongStd));
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(DayOfYear, 3);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Heave, 148);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(EMLogSpeed, 241);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(VerticalSpeed, 138);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(LatStd, 129);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(LongStd, 130);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(HeadingStd, 107);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(PosErr, 132);
        }
        this.InterpretedFrame_AddToList(this.InterpretedFrame);
        return 0;
    }
}

