/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;

public class DCN_STD_NAV10_Decoder
extends Decoder {
    private Encoder Encod;

    public DCN_STD_NAV10_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(true);
        int Start_Blk_Length = 1;
        byte[] Start_Blk = new byte[Start_Blk_Length];
        Start_Blk[0] = 15;
        int Length_Blk = 15;
        this.DecodeInit(0, Length_Blk, Start_Blk, Start_Blk_Length);
    }

    @Override
    public String GetFileHeading() {
        return "Standard Decoding only";
    }

    @Override
    public int InterpretFrame(byte[] Detected_Frame, int Lenght) {
        int Status = this.Convert_1Byte_to_UnsignedInt(Detected_Frame, 1, 1);
        double Heading = (double)this.Convert_3Bytes_to_UnsignedInt(Detected_Frame, 2, 1) * 180.0 / 8388608.0;
        double Roll = (double)this.Convert_3Bytes_to_SignedInt(Detected_Frame, 5, 1) * 90.0 / 8388608.0;
        double Pitch = (double)this.Convert_3Bytes_to_SignedInt(Detected_Frame, 8, 1) * 90.0 / 8388608.0;
        double VerticalSpeed = (double)this.Convert_2Bytes_to_SignedInt(Detected_Frame, 11, 1) * 40.0 / 32768.0;
        double Heave = (double)this.Convert_2Bytes_to_SignedInt(Detected_Frame, 13, 1) * 400.0 / 32768.0;
        if (this.GetCurvePlotImplementation()) {
            int Status_IpAddress = Status & 0x18;
            int Status_HRPVal = (Status &= 0x27) & 1;
            int Status_MalFunction = Status & 2;
            int Status_Alignment = Status & 4;
            int Status_Simulation = Status & 0x20;
            this.Encod.setValue(1028, Status_IpAddress, 1000);
            this.Encod.setValue(1025, Status_HRPVal, 1000);
            this.Encod.setValue(1021, Status_MalFunction, 1000);
            this.Encod.setValue(1004, Status_Simulation, 1000);
            this.Encod.setValue(1003, Status_Alignment, 1000);
            this.Encod.setValue(1000, Status, 1000);
            this.Encod.setValue(103, Float.valueOf((float)Heading), 1);
            this.Encod.setValue(104, Float.valueOf(-((float)Roll)), 1);
            this.Encod.setValue(105, Float.valueOf((float)Pitch), 1);
            this.Encod.setValue(138, Float.valueOf(-((float)VerticalSpeed)), 11);
            this.Encod.setValue(148, Float.valueOf(-((float)Heave)), 11);
            LoggerDecoderFrame.FrameReady = true;
        }
        this.InterpretedFrame_AddToList(this.InterpretedFrame);
        return 0;
    }
}

