/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;

public class EMT_SDV_CGS_Decoder
extends Decoder {
    private final Encoder Encod;

    public EMT_SDV_CGS_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(true);
        int Start_Blk_Length = 2;
        int Length_Blk = 11;
        byte[] Start_Blk_n1 = new byte[Start_Blk_Length];
        byte[] Start_Blk_n2 = new byte[Start_Blk_Length];
        Start_Blk_n1[0] = -112;
        Start_Blk_n1[1] = -112;
        Start_Blk_n2[0] = -102;
        Start_Blk_n2[1] = -112;
        this.DecodeInit(0, Length_Blk, Start_Blk_n1, Start_Blk_Length);
        this.DecodeInit(0, Length_Blk, Start_Blk_n2, Start_Blk_Length);
    }

    @Override
    public String GetFileHeading() {
        return "Standard Decoding only";
    }

    @Override
    public int InterpretFrame(byte[] Decoded_Frame, int Lenght) {
        byte[] Chk = new byte[]{0};
        for (int i = 0; i < 10; ++i) {
            Chk[0] = (byte)(Chk[0] ^ this.Bytes_Frame[i]);
        }
        if (Chk[0] != this.Bytes_Frame[10]) {
            this.InterpretedFrame = this.InterpretString("Checksum error");
            this.InterpretedFrame_AddToList(this.InterpretedFrame);
            return -1;
        }
        int Status = this.Bytes_Frame[0] & 0xFF;
        double Roll = (double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 2, 0) * 0.01;
        double Pitch = (double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 4, 0) * 0.01;
        double Depth = (double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 6, 0) * 0.001;
        double Heading = (double)this.Convert_2Bytes_to_UnsignedInt(this.Bytes_Frame, 8, 0) * 0.01;
        if (this.GetCurvePlotImplementation()) {
            this.Encod.setValue(1000, Status, 1000);
            this.Encod.setValue(412, Float.valueOf((float)Roll), 1);
            this.Encod.setValue(105, Float.valueOf(-((float)Pitch)), 1);
            this.Encod.setValue(126, Float.valueOf(-((float)Depth)), 11);
            this.Encod.setValue(103, Float.valueOf((float)Heading), 1);
            LoggerDecoderFrame.FrameReady = true;
        }
        this.InterpretedFrame = "Standard Decoding only";
        this.InterpretedFrame_AddToList(this.InterpretedFrame);
        return 0;
    }
}

