/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;
import RegExp.RegExp;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HALLIBURTON_SAS_Decoder
extends Decoder {
    private Encoder Encod;
    private int current_line;
    private boolean FirstFrameReceived = false;

    public HALLIBURTON_SAS_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(true);
        this.current_line = 0;
        int Start_Blk_Length = 1;
        byte[] Start_Blk = new byte[Start_Blk_Length];
        Start_Blk[0] = 36;
        int Length_Blk = 0;
        this.DecodeInit(1, Length_Blk, Start_Blk, Start_Blk_Length);
    }

    @Override
    public int InterpretFrame(byte[] Decoded_Frame, int Lenght) {
        String sFrame_no_crlf = new String(Decoded_Frame, 0, Lenght - 2);
        ++this.current_line;
        if (!this.NmeaChkMatches(sFrame_no_crlf)) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " NMEA checksum error:" + sFrame_no_crlf);
            return -1;
        }
        String[] params = sFrame_no_crlf.replace("*", ",").split(",");
        if (!params[0].contentEquals("$PIXSE")) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Header error:" + sFrame_no_crlf);
            return -1;
        }
        if (params[1].contentEquals("HSPOS_")) {
            if (this.FirstFrameReceived) {
                LoggerDecoderFrame.FrameReady = true;
            } else {
                this.FirstFrameReceived = true;
            }
            if (params.length != 21) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Format error:" + sFrame_no_crlf);
                return -1;
            }
            if (!RegExp.is_tpt2(params[2])) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " UTC Time format error:" + sFrame_no_crlf);
                return -1;
            }
            Matcher m = RegExp.ptn_d2_ns_f2pt6.matcher(params[3]);
            if (!m.matches()) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Latitude format error:" + sFrame_no_crlf);
                return -1;
            }
            double Latitude = (double)Integer.parseInt(m.group(1)) + Double.parseDouble(m.group(2)) / 60.0;
            if (!RegExp.is_NS(params[4])) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Latitude sign format error:" + sFrame_no_crlf);
                return -1;
            }
            if (params[4].contentEquals("S")) {
                Latitude = -Latitude;
            }
            if (!(m = RegExp.ptn_d3_ns_f2pt6.matcher(params[5])).matches()) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Longitude format error:" + sFrame_no_crlf);
                return -1;
            }
            double Longitude = (double)Integer.parseInt(m.group(1)) + Double.parseDouble(m.group(2)) / 60.0;
            if (!RegExp.is_EW(params[6])) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Longitude sign format error:" + sFrame_no_crlf);
                return -1;
            }
            if (params[6].contentEquals("W")) {
                Longitude = -Longitude;
            }
            if (!RegExp.is_fpt2(params[7])) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Depth format error:" + sFrame_no_crlf);
                return -1;
            }
            if (!RegExp.is_fpt2(params[8])) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " DVL Altitude format error:" + sFrame_no_crlf);
                return -1;
            }
            if (!RegExp.is_fpt2(params[9])) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Latitude SD format error:" + sFrame_no_crlf);
                return -1;
            }
            if (!RegExp.is_fpt2(params[10])) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Longitude SD format error:" + sFrame_no_crlf);
                return -1;
            }
            if (!RegExp.is_fpt2(params[11])) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Covariance LatLong format error:" + sFrame_no_crlf);
                return -1;
            }
            if (!RegExp.is_fpt2(params[12])) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Depth SD format error:" + sFrame_no_crlf);
                return -1;
            }
            if (!RegExp.is_d2(params[13])) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " UTM Zone format error:" + sFrame_no_crlf);
                return -1;
            }
            if (!RegExp.is_c1(params[14])) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " UTM Zone letter format error:" + sFrame_no_crlf);
                return -1;
            }
            if (!RegExp.is_fpt1(params[15])) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " UTM Pos East format error:" + sFrame_no_crlf);
                return -1;
            }
            if (!RegExp.is_fpt1(params[16])) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " UTM Pos North format error:" + sFrame_no_crlf);
                return -1;
            }
            if (!RegExp.is_fpt1(params[19])) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " DVL Sound Speed format error:" + sFrame_no_crlf);
                return -1;
            }
            if (!RegExp.is_fpt4(params[17])) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " DVL course format error:" + sFrame_no_crlf);
                return -1;
            }
            if (!RegExp.is_fpt4(params[18])) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " DVL scale factor format error:" + sFrame_no_crlf);
                return -1;
            }
            if (this.GetCurvePlotImplementation()) {
                this.Encod.setValue(100, Float.valueOf(new Double(params[2]).floatValue()), 34);
                this.Encod.setValue(124, Float.valueOf((float)Latitude), 1);
                this.Encod.setValue(125, Float.valueOf((float)Longitude), 1);
                this.Encod.setValue(126, Float.valueOf(-new Double(params[7]).floatValue()), 11);
                this.Encod.setValue(208, Float.valueOf(new Double(params[8]).floatValue()), 11);
                this.Encod.setValue(129, Float.valueOf(new Double(params[9]).floatValue()), 11);
                this.Encod.setValue(130, Float.valueOf(new Double(params[10]).floatValue()), 11);
                this.Encod.setValue(132, Float.valueOf(new Double(params[11]).floatValue()), 11);
                this.Encod.setValue(131, Float.valueOf(new Double(params[12]).floatValue()), 11);
                this.Encod.setValue(729, Integer.parseInt(params[13]), 1000);
                this.Encod.setValue(730, params[14], 1000);
                this.Encod.setValue(731, Float.valueOf(new Double(params[15]).floatValue()), 11);
                this.Encod.setValue(732, Float.valueOf(new Double(params[16]).floatValue()), 11);
                this.Encod.setValue(413, Float.valueOf(new Double(params[17]).floatValue()), 1);
                this.Encod.setValue(416, (double)new Double(params[18]).floatValue() / 100.0, 1000);
                this.Encod.setValue(206, Float.valueOf(new Double(params[19]).floatValue()), 21);
            }
            this.InterpretedFrame_AddToList(sFrame_no_crlf);
        } else if (params[1].contentEquals("HSATIT")) {
            if (params.length != 21) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Format error:" + sFrame_no_crlf);
                return -1;
            }
            if (!RegExp.is_fpt3fpt5(params[2])) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Heading format error:" + sFrame_no_crlf);
                return -1;
            }
            if (!RegExp.is_fpt3fpt5(params[3])) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Roll format error:" + sFrame_no_crlf);
                return -1;
            }
            if (!RegExp.is_fpt3fpt5(params[4])) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Pitch format error:" + sFrame_no_crlf);
                return -1;
            }
            if (!RegExp.is_fpt3(params[5])) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Heave format error:" + sFrame_no_crlf);
                return -1;
            }
            if (!RegExp.is_fpt3(params[6])) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " XV3 RotRate format error:" + sFrame_no_crlf);
                return -1;
            }
            if (!RegExp.is_fpt3(params[7])) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " XV1 RotRate format error:" + sFrame_no_crlf);
                return -1;
            }
            if (!RegExp.is_fpt3(params[8])) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " XV2 RotRate format error:" + sFrame_no_crlf);
                return -1;
            }
            if (!RegExp.is_fpt3(params[9])) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Horizontal speed course format error:" + sFrame_no_crlf);
                return -1;
            }
            if (!RegExp.is_fpt3(params[10])) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Horizontal speed format error:" + sFrame_no_crlf);
                return -1;
            }
            if (!RegExp.is_fpt3(params[11])) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " XV1 Speed format error:" + sFrame_no_crlf);
                return -1;
            }
            if (!RegExp.is_fpt3(params[12])) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " XV2 Speed format error:" + sFrame_no_crlf);
                return -1;
            }
            if (!RegExp.is_fpt3(params[13])) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " XV3 Speed format error:" + sFrame_no_crlf);
                return -1;
            }
            if (!RegExp.is_fpt2(params[14])) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Heading SD format error:" + sFrame_no_crlf);
                return -1;
            }
            if (!RegExp.is_fpt2(params[15])) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Roll SD format error:" + sFrame_no_crlf);
                return -1;
            }
            if (!RegExp.is_fpt2(params[16])) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Pitch SD format error:" + sFrame_no_crlf);
                return -1;
            }
            if (!RegExp.is_fpt2(params[17])) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " North Speed SD format error:" + sFrame_no_crlf);
                return -1;
            }
            if (!RegExp.is_fpt2(params[18])) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " East Speed SD format error:" + sFrame_no_crlf);
                return -1;
            }
            if (!RegExp.is_fpt2(params[19])) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Vertical Speed SD format error:" + sFrame_no_crlf);
                return -1;
            }
            if (this.GetCurvePlotImplementation()) {
                this.Encod.setValue(103, Float.valueOf(new Double(params[2]).floatValue()), 1);
                this.Encod.setValue(104, Float.valueOf(new Double(params[3]).floatValue()), 1);
                this.Encod.setValue(105, Float.valueOf(new Double(params[4]).floatValue()), 1);
                this.Encod.setValue(148, Float.valueOf(new Double(params[5]).floatValue()), 11);
                this.Encod.setValue(116, Float.valueOf(new Double(params[6]).floatValue()), 51);
                this.Encod.setValue(114, Float.valueOf(new Double(params[7]).floatValue()), 51);
                this.Encod.setValue(115, Float.valueOf(new Double(params[8]).floatValue()), 51);
                this.Encod.setValue(147, Float.valueOf(new Double(params[9]).floatValue()), 1);
                this.Encod.setValue(146, Float.valueOf(new Double(params[10]).floatValue()), 21);
                this.Encod.setValue(133, Float.valueOf(new Double(params[11]).floatValue()), 21);
                this.Encod.setValue(134, Float.valueOf(new Double(params[12]).floatValue()), 21);
                this.Encod.setValue(135, Float.valueOf(new Double(params[13]).floatValue()), 21);
                this.Encod.setValue(107, Float.valueOf(new Double(params[14]).floatValue()), 1);
                this.Encod.setValue(108, Float.valueOf(new Double(params[15]).floatValue()), 1);
                this.Encod.setValue(109, Float.valueOf(new Double(params[16]).floatValue()), 1);
                this.Encod.setValue(141, Float.valueOf(new Double(params[17]).floatValue()), 21);
                this.Encod.setValue(142, Float.valueOf(new Double(params[18]).floatValue()), 21);
                this.Encod.setValue(143, Float.valueOf(new Double(params[19]).floatValue()), 21);
            }
            this.InterpretedFrame_AddToList(sFrame_no_crlf);
        } else if (params[1].contentEquals("HSSTAT")) {
            if (params.length != 4) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Format error:" + sFrame_no_crlf);
                return -1;
            }
            Pattern p = Pattern.compile("([0-8]{2})([0-8]{2})([0-8]{2})([0-8]{2})");
            Matcher m = p.matcher(params[2]);
            if (!m.matches()) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Status format error:" + sFrame_no_crlf);
                return -1;
            }
            if (this.GetCurvePlotImplementation()) {
                String sStatusFF = m.group(1);
                String sStatusAA = m.group(2);
                String sStatusVV = m.group(3);
                String sStatusQQ = m.group(4);
                this.Encod.setValue(1022, Integer.parseInt(sStatusFF, 16), 1000);
                this.Encod.setValue(1000, Integer.parseInt(sStatusAA, 16), 1000);
                this.Encod.setValue(1001, Integer.parseInt(sStatusVV, 16), 1000);
                this.Encod.setValue(1003, Integer.parseInt(sStatusQQ, 16), 1000);
            }
            this.InterpretedFrame_AddToList(sFrame_no_crlf);
        } else {
            this.InterpretedFrame_AddToList("Header error");
            return -1;
        }
        return 0;
    }
}

