/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.DecoderFIFO;
import LoggerDecoder.Encoder;

public class HEAVE_POSTPRO_Decoder
extends Decoder {
    char LastKeyH = '\u0000';
    char LastKeyL = '\u0000';
    int CipheredFrameNb = 0;
    int ToDecipherFrameNb = 0;
    DecoderFIFO FIFO;
    private Encoder Encod;

    public HEAVE_POSTPRO_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(false);
        this.FIFO = new DecoderFIFO(6500);
        byte[] Start2 = new byte[]{36};
        super.DecodeInit(0, 0, Start2, 1, 1, 0, 1);
    }

    @Override
    public void ReInitialize_SpecificParameters() {
        this.LastKeyL = '\u0000';
        this.LastKeyH = '\u0000';
        this.ToDecipherFrameNb = 0;
        this.CipheredFrameNb = 0;
        this.FirstFrame = true;
        this.FIFO.FIFO_Init();
    }

    @Override
    public String GetFileHeading() {
        return "$HEAVE,HeaveTime,AccX,AccY,AccZ,Surge,Sway,Heave,DelayedHeaveTime,DelayedHeave,Status,Mode,Period,Amplitude";
    }

    @Override
    public int InterpretFrame(byte[] Decoded_Frame, int Lenght) {
        byte[] PopFrame = new byte[1024];
        char KeyH = (char)this.Bytes_Frame[10];
        char KeyL = (char)this.Bytes_Frame[11];
        if (this.FirstFrame) {
            this.LastKeyH = KeyH;
            this.LastKeyL = KeyL;
            this.FIFO.FIFO_Push(this.Bytes_Frame, Lenght);
            ++this.CipheredFrameNb;
            this.FirstFrame = false;
        } else {
            if (KeyH != this.LastKeyH || KeyL != this.LastKeyL) {
                this.LastKeyH = KeyH;
                this.LastKeyL = KeyL;
                this.ToDecipherFrameNb = this.CipheredFrameNb;
                this.CipheredFrameNb = 0;
            }
            this.FIFO.FIFO_Push(this.Bytes_Frame, Lenght);
            ++this.CipheredFrameNb;
            if (this.ToDecipherFrameNb > 0) {
                PopFrame = this.FIFO.FIFO_Pop();
                this.DecipherFrame(PopFrame, this.LastKeyH, this.LastKeyL);
                --this.ToDecipherFrameNb;
            }
        }
        return 0;
    }

    public int DecipherFrame(byte[] Decoded_Frame, char KeyH, char KeyL) {
        int Version = Decoded_Frame[3] & 0xFF;
        if (Version == 16) {
            byte[] acc = new byte[4];
            float[] ACC = new float[3];
            float[] HSS = new float[3];
            long Time100us = this.Convert_4Bytes_to_SignedInt(Decoded_Frame, 4, 1);
            double HeaveTime = (double)Time100us / 10000.0;
            for (int accId = 0; accId < 3; ++accId) {
                acc[0] = (byte)(Decoded_Frame[4 * accId + 12] ^ KeyH & 0xFF);
                acc[1] = (byte)(Decoded_Frame[4 * accId + 13] ^ KeyL & 0xFF);
                acc[2] = (byte)(Decoded_Frame[4 * accId + 14] ^ KeyH & 0xFF);
                acc[3] = (byte)(Decoded_Frame[4 * accId + 15] ^ KeyL & 0xFF);
                ACC[accId] = this.Convert_4Bytes_to_Float(acc, 0, 1);
            }
            for (int hssId = 0; hssId < 3; ++hssId) {
                HSS[hssId] = this.Convert_4Bytes_to_Float(Decoded_Frame, 4 * hssId + 24, 1);
            }
            int HeaveDelay100us = this.Convert_4Bytes_to_SignedInt(Decoded_Frame, 36, 1);
            double DelayedHeaveTime = HeaveTime - (double)HeaveDelay100us / 10000.0;
            if (DelayedHeaveTime < 0.0) {
                DelayedHeaveTime = 0.0;
            }
            float DelayedHeave = this.Convert_4Bytes_to_Float(Decoded_Frame, 40, 1);
            int Heave_Status = this.Convert_1Byte_to_SignedInt(Decoded_Frame, 44, 1);
            Heave_Status = Heave_Status != 0 ? 1 : 0;
            int Heave_Mode = this.Convert_1Byte_to_SignedInt(Decoded_Frame, 45, 1);
            float HeavePeriod = this.Convert_4Bytes_to_Float(Decoded_Frame, 46, 1);
            float HeaveAmplitude = this.Convert_4Bytes_to_Float(Decoded_Frame, 50, 1);
            this.InterpretedFrame = this.InterpretString("$H");
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(HeaveTime, 3);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(ACC[0], 309);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(ACC[1], 310);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(ACC[2], 311);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(HSS[0], 150);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(HSS[1], 151);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(HSS[2], 148);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(DelayedHeaveTime, 3);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(DelayedHeave, 117);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(Heave_Status);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(Heave_Mode);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(HeavePeriod, 2);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(HeaveAmplitude, 2);
            this.InterpretedFrame_AddToList(this.InterpretedFrame);
            return 0;
        }
        return -1;
    }
}

