/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;
import RegExp.RegExp;

public class HYDROGRAPHY_Decoder
extends Decoder {
    private Encoder Encod;
    private int current_line;

    public HYDROGRAPHY_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(true);
        this.current_line = 0;
        int Start_Blk_Length = 1;
        byte[] Start_Blk = new byte[Start_Blk_Length];
        Start_Blk[0] = 36;
        int Length_Blk = 0;
        this.DecodeInit(1, Length_Blk, Start_Blk, Start_Blk_Length);
    }

    @Override
    public int InterpretFrame(byte[] Decoded_Frame, int Lenght) {
        String sFrame_no_crlf = new String(Decoded_Frame, 0, Lenght - 2);
        ++this.current_line;
        if (!this.NmeaChkMatches(sFrame_no_crlf)) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " NMEA checksum error");
            return -1;
        }
        String[] params = sFrame_no_crlf.replace("*", ",").split(",");
        if (!params[0].contentEquals("$HYDRO")) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Header error");
            return -1;
        }
        if (params.length != 9) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Format error");
            return -1;
        }
        if (!RegExp.is_fpt3(params[1])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Heading format error");
            return -1;
        }
        if (!RegExp.is_fpt3(params[2])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Roll format error");
            return -1;
        }
        if (!RegExp.is_fpt3(params[3])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Pitch format error");
            return -1;
        }
        if (!RegExp.is_fpt3(params[6])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Altitude format error");
            return -1;
        }
        if (!RegExp.is_fpt3(params[7])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Heave format error");
            return -1;
        }
        if (!RegExp.is_fpt7(params[4])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Latitude format error");
            return -1;
        }
        if (!RegExp.is_fpt7(params[5])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Longitude format error");
            return -1;
        }
        if (this.GetCurvePlotImplementation()) {
            this.Encod.setValue(103, Float.valueOf(new Double(params[1]).floatValue()), 1);
            this.Encod.setValue(104, Float.valueOf(new Double(params[2]).floatValue()), 1);
            this.Encod.setValue(105, Float.valueOf(new Double(params[3]).floatValue()), 1);
            this.Encod.setValue(124, new Double(params[4]), 1);
            this.Encod.setValue(125, new Double(params[5]), 1);
            this.Encod.setValue(126, Float.valueOf(new Double(params[6]).floatValue()), 11);
            this.Encod.setValue(148, Float.valueOf(new Double(params[7]).floatValue()), 11);
            LoggerDecoderFrame.FrameReady = true;
        }
        this.InterpretedFrame_AddToList(sFrame_no_crlf);
        return 0;
    }
}

