/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;
import Tools.ConvertTool;

public class IMU_BINARY_Decoder
extends Decoder {
    private Encoder Encod;
    private ConvertTool Conv;
    double TimePrec = 0.0;

    public IMU_BINARY_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(true);
        int Start_Blk_Length = 1;
        byte[] Start_Blk = new byte[Start_Blk_Length];
        Start_Blk[0] = 36;
        int Length_Blk = 37;
        this.DecodeInit(0, Length_Blk, Start_Blk, Start_Blk_Length);
        this.Conv = new ConvertTool();
    }

    @Override
    public String GetFileHeading() {
        String sep = this.Info.GetSeparator();
        return "Time(s)" + sep + "XV1_Rot" + sep + "XV2_Rot" + sep + "XV3_Rot" + sep + "XV1_Acc" + sep + "XV2_Acc" + sep + "XV3_Acc" + sep + "Status" + sep + "Temp(inc)" + sep + "Temp(\u00b0C)";
    }

    @Override
    public int InterpretFrame(byte[] Decoded_Frame, int Lenght) {
        double Time = this.Convert_4Bytes_to_UnsignedInt(this.Bytes_Frame, 1, 1);
        Time = Time * 50.0 / 1000000.0;
        float XV1_Rot = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 5, 1);
        float XV2_Rot = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 9, 1);
        float XV3_Rot = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 13, 1);
        float XV1_Acc = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 17, 1);
        float XV2_Acc = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 21, 1);
        float XV3_Acc = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 25, 1);
        long Sensor_Status = this.Convert_4Bytes_to_UnsignedInt(this.Bytes_Frame, 29, 1);
        int Temp_inc = this.Convert_2Bytes_to_UnsignedInt(this.Bytes_Frame, 33, 1);
        double Temp_deg = this.Conv.INC2unite(Temp_inc, 202, LoggerDecoderFrame.jComboBoxBoardType.getSelectedIndex());
        this.InterpretedFrame = this.InterpretDouble(Time, 101);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV1_Rot, 312);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV2_Rot, 313);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV3_Rot, 314);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV1_Acc, 309);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV2_Acc, 310);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV3_Acc, 311);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex((int)Sensor_Status);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(Temp_inc);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Temp_deg);
        if (this.GetCurvePlotImplementation()) {
            this.Encod.setValue(100, new Float(Time), 31);
            this.Encod.setValue(312, Float.valueOf(XV1_Rot), 52);
            this.Encod.setValue(313, Float.valueOf(XV2_Rot), 52);
            this.Encod.setValue(314, Float.valueOf(XV3_Rot), 52);
            this.Encod.setValue(309, Float.valueOf(XV1_Acc), 43);
            this.Encod.setValue(310, Float.valueOf(XV2_Acc), 43);
            this.Encod.setValue(311, Float.valueOf(XV3_Acc), 43);
            this.Encod.setValue(469, Temp_inc, 202);
            this.Encod.setValue(604, Long.toHexString(Sensor_Status), 1000);
            LoggerDecoderFrame.FrameReady = true;
        }
        this.InterpretedFrame_AddToList(this.InterpretedFrame);
        return 0;
    }
}

