/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;

public class IMU_INCSYS_Decoder
extends Decoder {
    public static final int DATABLOCK_LENGTH = 116;
    public static final int ASYNC_DATABLOCK_LENGTH = 120;

    public IMU_INCSYS_Decoder(Encoder Encod) {
        this.SetCurvePlotImplementation(false);
        int Start_Blk_Length = 2;
        byte[] Start_Blk_n1 = new byte[Start_Blk_Length];
        byte[] Start_Blk_n2 = new byte[Start_Blk_Length];
        Start_Blk_n1[0] = -91;
        Start_Blk_n1[1] = 0;
        Start_Blk_n2[0] = 126;
        Start_Blk_n2[1] = -91;
        int Length_Blk_n1 = 116;
        int Length_Blk_n2 = 120;
        this.DecodeInit(0, Length_Blk_n1, Start_Blk_n1, Start_Blk_Length);
        this.DecodeInit(0, Length_Blk_n2, Start_Blk_n2, Start_Blk_Length);
    }

    @Override
    public String GetFileHeading() {
        String sep = this.Info.GetSeparator();
        if (this.Info.GetProtocolName().matches("IMU_INCSYS_OUTPUT2")) {
            return "Time(s)" + sep + "RotRateXV1(\u00b0/h)" + sep + "RotRateXV2(\u00b0/h)" + sep + "RotRateXV3(\u00b0/h)" + sep + "AccXV1(m/s2)" + sep + "AccXV2(m/s2)" + sep + "AccXV3(m/s2)" + sep + "SensorStatus1(Hexa)" + sep + "TempFogX1(\u00b0C)" + sep + "TempFogX2(\u00b0C)" + sep + "TempFogX3(\u00b0C)" + sep + "TempAccX1(\u00b0C)" + sep + "TempAccX2(\u00b0C)" + sep + "TempAccX3(\u00b0C)" + sep + "TempSrc(\u00b0C)" + sep + "TempAna(\u00b0C)";
        }
        return "Time(s)" + sep + "Counter" + sep + "FogX1(inc)" + sep + "FogX2(inc)" + sep + "FogX3(inc)" + sep + "AccX1(inc)" + sep + "AccX2(inc)" + sep + "AccX3(inc)" + sep + "XV1Rot(\u00b0/h)" + sep + "XV2Rot(\u00b0/h)" + sep + "XV3Rot(\u00b0/h)" + sep + "XV1Acc(m/s2)" + sep + "XV2Acc(m/s2)" + sep + "XV3Acc(m/s2)" + sep + "TempFogX1(inc)" + sep + "TempFogX2(inc)" + sep + "TempFogX3(inc)" + sep + "TempAccX1(inc)" + sep + "TempAccX2(inc)" + sep + "TempAccX3(inc)" + sep + "TempSrc(inc)" + sep + "TempAna(inc)" + sep + "SensorStatus1(Hexa)" + sep + "SensorStatus2(Hexa)" + sep + "AlgoStatus1(Hexa)" + sep + "AlgoStatus2(Hexa)" + sep + "SystemStatus1(Hexa)" + sep + "SystemStatus2(Hexa)" + sep + "UserStatus(Hexa)";
    }

    @Override
    public int InterpretFrame(byte[] Detected_Frame, int Length) {
        int endianness = 0;
        int index = 0;
        if (Length == 116) {
            if (Detected_Frame[0] != -91) {
                this.InterpretedFrame = "ERR0xA5: Unexpected start byte 1";
                return -1;
            }
            if (Detected_Frame[1] != 0) {
                this.InterpretedFrame = "ERR0x00: Unexpected start byte 2";
                return -1;
            }
        }
        if (Length == 120) {
            int crc2;
            if (Detected_Frame[0] != 126) {
                this.InterpretedFrame = "ERR0x7E: Unexpected start byte 1";
                return -1;
            }
            if (Detected_Frame[1] != -91) {
                this.InterpretedFrame = "ERR0xA5: Unexpected start byte 2";
                return -1;
            }
            if (Detected_Frame[119] != 126) {
                this.InterpretedFrame = "ERR0x7E: Unexpected end byte";
                return -1;
            }
            int crc1 = this.Convert_2Bytes_to_SignedInt(Detected_Frame, 117, endianness);
            if (crc1 != (crc2 = this.Compute_CRC16_CCITT(Detected_Frame, 1, 116))) {
                this.InterpretedFrame = "ERR____: Unexpected checksum";
                return -1;
            }
            index = 1;
        }
        float Time = this.Convert_4Bytes_to_Float(Detected_Frame, index + 2, endianness);
        int Counter = this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, index + 6, endianness);
        float FogX1 = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, index + 8, endianness);
        float FogX2 = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, index + 12, endianness);
        float FogX3 = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, index + 16, endianness);
        float AccX1 = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, index + 20, endianness);
        float AccX2 = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, index + 24, endianness);
        float AccX3 = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, index + 28, endianness);
        float XV1Rot = this.Convert_4Bytes_to_Float(Detected_Frame, index + 32, endianness);
        float XV2Rot = this.Convert_4Bytes_to_Float(Detected_Frame, index + 36, endianness);
        float XV3Rot = this.Convert_4Bytes_to_Float(Detected_Frame, index + 40, endianness);
        float XV1Acc = this.Convert_4Bytes_to_Float(Detected_Frame, index + 44, endianness);
        float XV2Acc = this.Convert_4Bytes_to_Float(Detected_Frame, index + 48, endianness);
        float XV3Acc = this.Convert_4Bytes_to_Float(Detected_Frame, index + 52, endianness);
        float TempFogX1 = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, index + 56, endianness);
        float TempFogX2 = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, index + 60, endianness);
        float TempFogX3 = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, index + 64, endianness);
        float TempAccX1 = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, index + 68, endianness);
        float TempAccX2 = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, index + 72, endianness);
        float TempAccX3 = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, index + 76, endianness);
        float TempSrc = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, index + 80, endianness);
        float TempAna = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, index + 84, endianness);
        long SensorStatus1 = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, index + 88, endianness);
        long SensorStatus2 = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, index + 92, endianness);
        long AlgoStatus1 = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, index + 96, endianness);
        long AlgoStatus2 = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, index + 100, endianness);
        long SystemStatus1 = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, index + 104, endianness);
        long SystemStatus2 = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, index + 108, endianness);
        long UserStatus = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, index + 112, endianness);
        if (this.Info.GetProtocolName().matches("IMU_INCSYS_OUTPUT2")) {
            this.InterpretedFrame = this.InterpretFloat(Time);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV1Rot);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV2Rot);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV3Rot);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV1Acc);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV2Acc);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV3Acc);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex((int)SensorStatus1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(this.IncToDegCelsius(TempFogX1));
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(this.IncToDegCelsius(TempFogX2));
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(this.IncToDegCelsius(TempFogX3));
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(this.IncToDegCelsius(TempAccX1));
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(this.IncToDegCelsius(TempAccX2));
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(this.IncToDegCelsius(TempAccX3));
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(this.IncToDegCelsius(TempSrc));
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(this.IncToDegCelsius(TempAna));
        } else {
            this.InterpretedFrame = this.InterpretFloat(Time);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(Counter);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(FogX1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(FogX2);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(FogX3);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(AccX1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(AccX2);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(AccX3);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV1Rot);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV2Rot);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV3Rot);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV1Acc);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV2Acc);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV3Acc);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(TempFogX1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(TempFogX2);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(TempFogX3);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(TempAccX1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(TempAccX2);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(TempAccX3);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(TempSrc);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(TempAna);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex((int)SensorStatus1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex((int)SensorStatus1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex((int)SensorStatus2);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex((int)AlgoStatus1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex((int)AlgoStatus2);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex((int)SystemStatus1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex((int)SystemStatus2);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex((int)UserStatus);
        }
        this.InterpretedFrame_AddToList(this.InterpretedFrame);
        return 0;
    }

    private float IncToDegCelsius(float Temp) {
        Temp = (float)((double)Temp / 10.0 - 273.15);
        return Temp;
    }
}

