/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;
import RegExp.RegExp;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class INSITU_Decoder
extends Decoder {
    private final Encoder Encod;
    private int current_line;
    private String HEHDT_heading = "0";
    private String TIROT_heading_rate = "0";
    private int TIROT_Status_HRPVal = 0;
    private String PPLAR_roll = "0";
    private String PPLAR_pitch = "0";

    public INSITU_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(true);
        this.current_line = 0;
        int Start_Blk_Length = 1;
        byte[] Start_Blk = new byte[Start_Blk_Length];
        Start_Blk[0] = 36;
        int Length_Blk = 0;
        this.DecodeInit(1, Length_Blk, Start_Blk, Start_Blk_Length);
    }

    @Override
    public int InterpretFrame(byte[] Decoded_Frame, int Lenght) {
        String sFrame_no_crlf = new String(Decoded_Frame, 0, Lenght - 2);
        ++this.current_line;
        String[] params = sFrame_no_crlf.replace("*", ",").split(",");
        if (!this.NmeaChkMatches(sFrame_no_crlf)) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " NMEA checksum error");
            return -1;
        }
        if (params[0].contentEquals("$HEHDT")) {
            if (params.length != 4) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Format error");
                return -1;
            }
            if (!params[2].contentEquals("T")) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Format error");
                return -1;
            }
            if (!RegExp.is_ns_fpt2fpt5(params[1])) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Heading format error");
                return -1;
            }
            if (this.GetCurvePlotImplementation()) {
                this.HEHDT_heading = params[1];
            }
            this.InterpretedFrame_AddToList(sFrame_no_crlf);
        } else if (params[0].contentEquals("$TIROT")) {
            if (params.length != 4) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Format error");
                return -1;
            }
            if (!RegExp.is_f5pt1(params[1])) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Heading rate of turn format error");
                return -1;
            }
            Pattern p = Pattern.compile("(A?|V?)");
            Matcher m = p.matcher(params[2]);
            if (!m.matches()) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Valid status field format error");
                return -1;
            }
            if (this.GetCurvePlotImplementation()) {
                if ("A".equals(params[2])) {
                    this.TIROT_Status_HRPVal = 65;
                }
                if ("V".equals(params[2])) {
                    this.TIROT_Status_HRPVal = 86;
                }
                this.TIROT_heading_rate = params[1];
            }
            this.InterpretedFrame_AddToList(sFrame_no_crlf);
        } else if (params[0].contentEquals("$PPLAR")) {
            if (params.length != 4) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Format error");
                return -1;
            }
            if (!this.NmeaChkMatches(sFrame_no_crlf)) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " NMEA checksum error");
                return -1;
            }
            if (!RegExp.is_f3pt2(params[1])) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Roll format error");
                return -1;
            }
            if (!RegExp.is_f3pt2(params[2])) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Pitch format error");
                return -1;
            }
            if (this.GetCurvePlotImplementation()) {
                this.PPLAR_roll = params[1];
                this.PPLAR_pitch = params[2];
            }
            this.InterpretedFrame_AddToList(sFrame_no_crlf);
        } else if (params[0].contentEquals("$PPLAX")) {
            if (params.length != 4) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Format error");
                return -1;
            }
            if (!this.NmeaChkMatches(sFrame_no_crlf)) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " NMEA checksum error");
                return -1;
            }
            if (!RegExp.is_f3pt2(params[1])) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Roll format error");
                return -1;
            }
            if (!RegExp.is_f3pt2(params[2])) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Pitch format error");
                return -1;
            }
            if (this.GetCurvePlotImplementation()) {
                this.Encod.setValue(103, Float.valueOf(new Double(this.HEHDT_heading).floatValue()), 1);
                this.Encod.setValue(110, (double)new Double(this.TIROT_heading_rate).floatValue() / 60.0, 51);
                this.Encod.setValue(1025, this.TIROT_Status_HRPVal, 1000);
                this.Encod.setValue(104, Float.valueOf(new Double(this.PPLAR_roll).floatValue()), 1);
                this.Encod.setValue(105, Float.valueOf(-new Double(this.PPLAR_pitch).floatValue()), 1);
                this.Encod.setValue(111, Float.valueOf(new Double(params[1]).floatValue()), 51);
                this.Encod.setValue(112, Float.valueOf(-new Double(params[2]).floatValue()), 51);
                LoggerDecoderFrame.FrameReady = true;
            }
            this.InterpretedFrame_AddToList(sFrame_no_crlf);
        } else {
            this.InterpretedFrame_AddToList("Header error");
            return -1;
        }
        return 0;
    }
}

