/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;
import RegExp.RegExp;

public class INS_STD_NMEA_Decoder
extends Decoder {
    private Encoder Encod;
    private int isFirstHEHDT = 0;
    private int nbTIMEFrames = 0;
    private String HEHDT_heading = "0";
    private String HETHS_heading = "0";
    private String ATITUD_roll = "0";
    private String ATITUD_pitch = "0";
    private String POSITI_latitude = "0";
    private String POSITI_longitude = "0";
    private String POSITI_altitude = "0";
    private String SPEED_east_speed = "0";
    private String SPEED_north_speed = "0";
    private String SPEED_vertical_speed = "0";
    private String UTMWGS_cdat_utm_letter = "0";
    private String UTMWGS_cdat_utm_zone = "0";
    private String UTMWGS_cdat_utm_east = "0";
    private String UTMWGS_cdat_utm_north = "0";
    private String UTMWGS_cdat_utm_alti = "0";
    private String HEAVE_surge = "0";
    private String HEAVE_sway = "0";
    private String HEAVE_heave = "0";
    private String TIME_system_time = "0";
    private String STDHRP_heading_sd = "0";
    private String STDHRP_roll_sd = "0";
    private String STDHRP_pitch_sd = "0";
    private String STDPOS_latitude_sd = "0";
    private String STDPOS_longitude_sd = "0";
    private String STDPOS_altitude_sd = "0";
    private String STDSPD_north_speed_sd = "0";
    private String STDSPD_east_speed_sd = "0";
    private String STDSPD_vertical_speed_sd = "0";
    private String FOGEST_xv1_rot_bias = "0";
    private String FOGEST_xv2_rot_bias = "0";
    private String FOGEST_xv3_rot_bias = "0";
    private String ACCEST_xv1_acc_bias = "0";
    private String ACCEST_xv2_acc_bias = "0";
    private String ACCEST_xv3_acc_bias = "0";
    private String LOGEST_log_misalignment = "0";
    private String UTCIN_utc_time = "0";
    private String GPSIN_gps_latitude = "0";
    private String GPSIN_gps_longitude = "0";
    private String GPSIN_gps_altitude = "0";
    private String GPSIN_gps_data_validity_time = "0";
    private String GPSIN_gps_quality = "0";
    private String GP2IN_gps_latitude = "0";
    private String GP2IN_gps_longitude = "0";
    private String GP2IN_gps_altitude = "0";
    private String GP2IN_gps_data_validity_time = "0";
    private String GP2IN_gps_quality = "0";
    private String GPMIN_gps_latitude = "0";
    private String GPMIN_gps_longitude = "0";
    private String GPMIN_gps_altitude = "0";
    private String GPMIN_gps_data_validity_time = "0";
    private String GPMIN_gps_quality = "0";
    private String DEPIN_depth = "0";
    private String DEPIN_depth_data_validity_time = "0";
    private String USBIN_usbl_latitude = "0";
    private String USBIN_usbl_longitude = "0";
    private String USBIN_usbl_altitude = "0";
    private String USBIN_usbl_delay = "0";
    private String USBIN_usbl_data_validity_time = "0";
    private String LBLIN_lbl_latitude = "0";
    private String LBLIN_lbl_longitude = "0";
    private String LBLIN_lbl_altitude = "0";
    private String LBLIN_lbl_id = "0";
    private String LBLIN_lbl_range = "0";
    private String LBLIN_lbl_data_validity_time = "0";
    private String LOGDVL_dvl_sound_speed = "0";
    private String LOGDVL_sound_speed = "0";
    private String LOGDVL_dvl_range_to_bottom = "0";
    private String LOGWAT_dvl_wt_speed_xv1 = "0";
    private String LOGWAT_dvl_wt_speed_xv2 = "0";
    private String LOGWAT_dvl_wt_speed_xv3 = "0";
    private String LOGWAT_current_north_speed = "0";
    private String LOGWAT_current_east_speed = "0";
    private String LOGWAT_current_north_speed_sd = "0";
    private String LOGWAT_current_east_speed_sd = "0";
    private String LOGWAT_wt_data_validity_time = "0";
    private String LOGIN_dvl_bt_speed_xv1 = "0";
    private String LOGIN_dvl_bt_speed_xv2 = "0";
    private String LOGIN_dvl_bt_speed_xv3 = "0";
    private String LOGIN_log_misalignment = "0";
    private String LOGIN_dvl_bt_data_validity_time = "0";
    private String DRECK_dre_latitude = "0";
    private String DRECK_dre_longitude = "0";
    private String DRECK_dre_altitude = "0";
    private String DRECK_dre_heading_log_misalignment = "0";
    private String DRECK_dre_scale_factor = "0";
    private String DRECK_dre_pitch_log_misalignment = "0";
    private String CALCHK_travelled_distance = "0";
    private String CALCHK_vertical_error = "0";
    private String CALCHK_horizontal_error = "0";
    private String LMNIN_loch_speed = "0";
    private String LMNIN_current_north_speed = "0";
    private String LMNIN_current_east_speed = "0";
    private String LMNIN_current_north_speed_sd = "0";
    private String LMNIN_current_east_speed_sd = "0";
    private String LMNIN_loch_data_validity_time = "0";
    private String ODOIN_dmi_speed = "0";
    private String ODOIN_dmi_data_validity_time = "0";
    private String DSTTRV_cdat_dsttrv = "0";
    private String ALGSTS_algo_status_1 = "0";
    private String ALGSTS_algo_status_2 = "0";
    private String ALGSTS_algo_status_3 = "0";
    private String ALGSTX_algo_status_4 = "0";
    private String ALGSTX_algo_status_5 = "0";
    private String ALGSTX_algo_status_6 = "0";
    private String STATUS_system_status_1 = "0";
    private String STATUS_system_status_2 = "0";
    private String STATUS_system_status_3 = "0";
    private String HT_STS_cdat_ht_sts = "0";
    private String SORSTS_sensor_status_1 = "0";
    private String SORSTS_sensor_status_2 = "0";
    private String ANGLIN_turret_heading = "0";
    private String ANGLIN_turret_roll = "0";
    private String ANGLIN_turret_pitch = "0";
    private String ANGLIN_turret_data_validity_time = "0";
    private String PTGATT_pointing_angle_heading = "0";
    private String PTGATT_pointing_angle_roll = "0";
    private String PTGATT_pointing_angle_pitch = "0";
    private String STDPTG_pointing_angle_heading_sd = "0";
    private String STDPTG_pointing_angle_roll_sd = "0";
    private String STDPTG_pointing_angle_pitch_sd = "0";

    public INS_STD_NMEA_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(true);
        int Start_Blk_Length = 1;
        byte[] Start_Blk = new byte[Start_Blk_Length];
        Start_Blk[0] = 36;
        int Length_Blk = 0;
        this.DecodeInit(1, Length_Blk, Start_Blk, Start_Blk_Length);
    }

    @Override
    public int InterpretFrame(byte[] Decoded_Frame, int Lenght) {
        String sFrame_no_crlf = new String(Decoded_Frame, 0, Lenght - 2);
        String ProtocolName = this.Info.GetProtocolName();
        if (!this.NmeaChkMatches(sFrame_no_crlf)) {
            this.InterpretedFrame_AddToList("NMEA checksum error : " + sFrame_no_crlf);
            return -1;
        }
        String[] params = sFrame_no_crlf.replace("*", ",").split(",");
        block5 : switch (params[0]) {
            case "$HEHDT": {
                if (params.length != 4) {
                    this.InterpretedFrame_AddToList(params[0] + " Format error : " + sFrame_no_crlf);
                    return -1;
                }
                if (!params[2].contentEquals("T")) {
                    this.InterpretedFrame_AddToList(params[0] + " Format error : " + sFrame_no_crlf);
                    return -1;
                }
                if (params[1].isEmpty()) {
                    this.InterpretedFrame_AddToList(params[0] + " Format error : " + sFrame_no_crlf);
                    return -1;
                }
                if (!RegExp.is_ns_fpt2fpt5(params[1])) {
                    this.InterpretedFrame_AddToList(params[0] + " Format error : " + sFrame_no_crlf);
                    return -1;
                }
                if (this.GetCurvePlotImplementation()) {
                    this.HEHDT_heading = params[1];
                    if (ProtocolName.matches("GYROCOMPASS") || ProtocolName.matches("NAVIGATION")) {
                        this.isFirstHEHDT = this.isFirstHEHDT == 0 ? 1 : 0;
                        if (this.isFirstHEHDT == 0) {
                            this.Encod.setValue(103, Float.valueOf(new Double(this.HEHDT_heading).floatValue()), 1);
                            this.Encod.setValue(104, Float.valueOf(new Double(this.ATITUD_roll).floatValue()), 1);
                            this.Encod.setValue(105, Float.valueOf(new Double(this.ATITUD_pitch).floatValue()), 1);
                            this.Encod.setValue(600, this.STATUS_system_status_1, 1000);
                            this.Encod.setValue(601, this.STATUS_system_status_2, 1000);
                            this.Encod.setValue(602, this.STATUS_system_status_3, 1000);
                            if (ProtocolName.matches("NAVIGATION")) {
                                this.Encod.setValue(124, Float.valueOf(new Double(this.POSITI_latitude).floatValue()), 1);
                                this.Encod.setValue(125, Float.valueOf(new Double(this.POSITI_longitude).floatValue()), 1);
                                this.Encod.setValue(126, Float.valueOf(new Double(this.POSITI_altitude).floatValue()), 11);
                            }
                            LoggerDecoderFrame.FrameReady = true;
                        }
                    }
                }
                this.InterpretedFrame_AddToList(sFrame_no_crlf);
                break;
            }
            case "$HETHS": {
                if (!RegExp.is_AEMSV(params[2])) {
                    this.InterpretedFrame_AddToList(params[0] + " Format error : " + sFrame_no_crlf);
                    return -1;
                }
                if (params[1].isEmpty()) {
                    params[1] = "0";
                } else if (!RegExp.is_ns_fpt2fpt5(params[1])) {
                    this.InterpretedFrame_AddToList(params[0] + " Format error :" + sFrame_no_crlf);
                    return -1;
                }
                if (this.GetCurvePlotImplementation()) {
                    this.HEHDT_heading = params[1];
                }
                this.InterpretedFrame_AddToList(sFrame_no_crlf);
                break;
            }
            case "$PIXSE": {
                switch (params[1]) {
                    case "TIME__": {
                        if (!RegExp.is_tpt6(params[2])) {
                            this.InterpretedFrame_AddToList(params[1] + " Format error : " + sFrame_no_crlf);
                            return -1;
                        }
                        if (this.GetCurvePlotImplementation()) {
                            this.TIME_system_time = params[2];
                            this.Encod.setValue(103, Float.valueOf(new Double(this.HEHDT_heading).floatValue()), 1);
                            if (ProtocolName.matches("PHINS_STANDARD")) {
                                this.Encod.setValue(103, Float.valueOf(new Double(this.HEHDT_heading).floatValue()), 1);
                            }
                            this.Encod.setValue(104, Float.valueOf(new Double(this.ATITUD_roll).floatValue()), 1);
                            this.Encod.setValue(105, Float.valueOf(new Double(this.ATITUD_pitch).floatValue()), 1);
                            this.Encod.setValue(124, Float.valueOf(new Double(this.POSITI_latitude).floatValue()), 1);
                            this.Encod.setValue(125, Float.valueOf(new Double(this.POSITI_longitude).floatValue()), 1);
                            this.Encod.setValue(126, Float.valueOf(new Double(this.POSITI_altitude).floatValue()), 11);
                            this.Encod.setValue(137, Float.valueOf(new Double(this.SPEED_east_speed).floatValue()), 21);
                            this.Encod.setValue(136, Float.valueOf(new Double(this.SPEED_north_speed).floatValue()), 21);
                            this.Encod.setValue(138, Float.valueOf(new Double(this.SPEED_vertical_speed).floatValue()), 21);
                            this.Encod.setValue(730, this.UTMWGS_cdat_utm_letter, 1000);
                            this.Encod.setValue(729, Float.valueOf(new Double(this.UTMWGS_cdat_utm_zone).floatValue()), 1000);
                            this.Encod.setValue(731, Float.valueOf(new Double(this.UTMWGS_cdat_utm_east).floatValue()), 11);
                            this.Encod.setValue(732, Float.valueOf(new Double(this.UTMWGS_cdat_utm_north).floatValue()), 11);
                            this.Encod.setValue(733, Float.valueOf(new Double(this.UTMWGS_cdat_utm_alti).floatValue()), 11);
                            if (ProtocolName.matches("PHINS_STANDARD")) {
                                this.Encod.setValue(150, Float.valueOf(new Double(this.HEAVE_surge).floatValue()), 11);
                                this.Encod.setValue(151, Float.valueOf(new Double(this.HEAVE_sway).floatValue()), 11);
                                this.Encod.setValue(148, Float.valueOf(new Double(this.HEAVE_heave).floatValue()), 11);
                            }
                            this.Encod.setValue(101, Float.valueOf(new Double(this.TIME_system_time).floatValue()), 34);
                            this.Encod.setValue(107, Float.valueOf(new Double(this.STDHRP_heading_sd).floatValue()), 1);
                            this.Encod.setValue(108, Float.valueOf(new Double(this.STDHRP_roll_sd).floatValue()), 1);
                            this.Encod.setValue(109, Float.valueOf(new Double(this.STDHRP_pitch_sd).floatValue()), 1);
                            this.Encod.setValue(129, Float.valueOf(new Double(this.STDPOS_latitude_sd).floatValue()), 11);
                            this.Encod.setValue(130, Float.valueOf(new Double(this.STDPOS_longitude_sd).floatValue()), 11);
                            this.Encod.setValue(131, Float.valueOf(new Double(this.STDPOS_altitude_sd).floatValue()), 11);
                            this.Encod.setValue(141, Float.valueOf(new Double(this.STDSPD_north_speed_sd).floatValue()), 21);
                            this.Encod.setValue(142, Float.valueOf(new Double(this.STDSPD_east_speed_sd).floatValue()), 21);
                            this.Encod.setValue(143, Float.valueOf(new Double(this.STDSPD_vertical_speed_sd).floatValue()), 21);
                            if (ProtocolName.matches("PHINS_STANDARD")) {
                                this.Encod.setValue(259, Float.valueOf(new Double(this.FOGEST_xv1_rot_bias).floatValue()), 54);
                                this.Encod.setValue(260, Float.valueOf(new Double(this.FOGEST_xv2_rot_bias).floatValue()), 54);
                                this.Encod.setValue(261, Float.valueOf(new Double(this.FOGEST_xv3_rot_bias).floatValue()), 54);
                                this.Encod.setValue(262, Float.valueOf(new Double(this.ACCEST_xv1_acc_bias).floatValue()), 42);
                                this.Encod.setValue(263, Float.valueOf(new Double(this.ACCEST_xv2_acc_bias).floatValue()), 42);
                                this.Encod.setValue(264, Float.valueOf(new Double(this.ACCEST_xv3_acc_bias).floatValue()), 42);
                                this.Encod.setValue(258, Float.valueOf(new Double(this.LOGEST_log_misalignment).floatValue()), 1);
                            }
                            this.Encod.setValue(100, Float.valueOf(new Double(this.UTCIN_utc_time).floatValue()), 34);
                            this.Encod.setValue(162, Float.valueOf(new Double(this.GPSIN_gps_latitude).floatValue()), 1);
                            this.Encod.setValue(163, Float.valueOf(new Double(this.GPSIN_gps_longitude).floatValue()), 1);
                            this.Encod.setValue(164, Float.valueOf(new Double(this.GPSIN_gps_altitude).floatValue()), 11);
                            this.Encod.setValue(160, Float.valueOf(new Double(this.GPSIN_gps_data_validity_time).floatValue()), 34);
                            this.Encod.setValue(165, Float.valueOf(new Double(this.GPSIN_gps_quality).floatValue()), 1000);
                            if (ProtocolName.matches("PHINS_STANDARD")) {
                                this.Encod.setValue(173, Float.valueOf(new Double(this.GP2IN_gps_latitude).floatValue()), 1);
                                this.Encod.setValue(174, Float.valueOf(new Double(this.GP2IN_gps_longitude).floatValue()), 1);
                                this.Encod.setValue(175, Float.valueOf(new Double(this.GP2IN_gps_altitude).floatValue()), 11);
                                this.Encod.setValue(171, Float.valueOf(new Double(this.GP2IN_gps_data_validity_time).floatValue()), 34);
                                this.Encod.setValue(176, Float.valueOf(new Double(this.GP2IN_gps_quality).floatValue()), 1000);
                            }
                            this.Encod.setValue(184, Float.valueOf(new Double(this.GPMIN_gps_latitude).floatValue()), 1);
                            this.Encod.setValue(185, Float.valueOf(new Double(this.GPMIN_gps_longitude).floatValue()), 1);
                            this.Encod.setValue(186, Float.valueOf(new Double(this.GPMIN_gps_altitude).floatValue()), 11);
                            this.Encod.setValue(182, Float.valueOf(new Double(this.GPMIN_gps_data_validity_time).floatValue()), 34);
                            this.Encod.setValue(187, Float.valueOf(new Double(this.GPMIN_gps_quality).floatValue()), 1000);
                            if (ProtocolName.matches("PHINS_STANDARD")) {
                                this.Encod.setValue(246, Float.valueOf(new Double(this.DEPIN_depth).floatValue()), 11);
                                this.Encod.setValue(244, Float.valueOf(new Double(this.DEPIN_depth_data_validity_time).floatValue()), 34);
                                this.Encod.setValue(198, Float.valueOf(new Double(this.USBIN_usbl_latitude).floatValue()), 1);
                                this.Encod.setValue(199, Float.valueOf(new Double(this.USBIN_usbl_longitude).floatValue()), 1);
                                this.Encod.setValue(200, Float.valueOf(new Double(this.USBIN_usbl_altitude).floatValue()), 11);
                                this.Encod.setValue(197, Float.valueOf(new Double(this.USBIN_usbl_delay).floatValue()), 31);
                                this.Encod.setValue(196, Float.valueOf(new Double(this.USBIN_usbl_data_validity_time).floatValue()), 34);
                                this.Encod.setValue(232, Float.valueOf(new Double(this.LBLIN_lbl_latitude).floatValue()), 1);
                                this.Encod.setValue(233, Float.valueOf(new Double(this.LBLIN_lbl_longitude).floatValue()), 1);
                                this.Encod.setValue(234, Float.valueOf(new Double(this.LBLIN_lbl_altitude).floatValue()), 11);
                                this.Encod.setValue(228, Float.valueOf(new Double(this.LBLIN_lbl_id).floatValue()), 1000);
                                this.Encod.setValue(235, Float.valueOf(new Double(this.LBLIN_lbl_range).floatValue()), 11);
                                this.Encod.setValue(230, Float.valueOf(new Double(this.LBLIN_lbl_data_validity_time).floatValue()), 34);
                            }
                            if (ProtocolName.matches("PHINS_STANDARD")) {
                                this.Encod.setValue(209, Float.valueOf(new Double(this.LOGDVL_dvl_sound_speed).floatValue()), 21);
                                this.Encod.setValue(206, Float.valueOf(new Double(this.LOGDVL_sound_speed).floatValue()), 21);
                                this.Encod.setValue(208, Float.valueOf(new Double(this.LOGDVL_dvl_range_to_bottom).floatValue()), 11);
                                this.Encod.setValue(212, Float.valueOf(new Double(this.LOGWAT_dvl_wt_speed_xv1).floatValue()), 21);
                                this.Encod.setValue(213, Float.valueOf(new Double(this.LOGWAT_dvl_wt_speed_xv2).floatValue()), 21);
                                this.Encod.setValue(214, Float.valueOf(new Double(this.LOGWAT_dvl_wt_speed_xv3).floatValue()), 21);
                                this.Encod.setValue(250, Float.valueOf(new Double(this.LOGWAT_current_north_speed).floatValue()), 21);
                                this.Encod.setValue(251, Float.valueOf(new Double(this.LOGWAT_current_east_speed).floatValue()), 21);
                                this.Encod.setValue(252, Float.valueOf(new Double(this.LOGWAT_current_north_speed_sd).floatValue()), 21);
                                this.Encod.setValue(253, Float.valueOf(new Double(this.LOGWAT_current_east_speed_sd).floatValue()), 21);
                                this.Encod.setValue(210, Float.valueOf(new Double(this.LOGWAT_wt_data_validity_time).floatValue()), 34);
                                this.Encod.setValue(221, Float.valueOf(new Double(this.LOGIN_dvl_bt_speed_xv1).floatValue()), 21);
                                this.Encod.setValue(222, Float.valueOf(new Double(this.LOGIN_dvl_bt_speed_xv2).floatValue()), 21);
                                this.Encod.setValue(223, Float.valueOf(new Double(this.LOGIN_dvl_bt_speed_xv3).floatValue()), 21);
                                this.Encod.setValue(258, Float.valueOf(new Double(this.LOGIN_log_misalignment).floatValue()), 1);
                                this.Encod.setValue(219, Float.valueOf(new Double(this.LOGIN_dvl_bt_data_validity_time).floatValue()), 34);
                            }
                            this.Encod.setValue(268, Float.valueOf(new Double(this.DRECK_dre_latitude).floatValue()), 1);
                            this.Encod.setValue(269, Float.valueOf(new Double(this.DRECK_dre_longitude).floatValue()), 1);
                            this.Encod.setValue(270, Float.valueOf(new Double(this.DRECK_dre_altitude).floatValue()), 11);
                            this.Encod.setValue(271, Float.valueOf(new Double(this.DRECK_dre_heading_log_misalignment).floatValue()), 1);
                            this.Encod.setValue(273, Float.valueOf(new Double(this.DRECK_dre_scale_factor).floatValue()), 1000);
                            this.Encod.setValue(272, Float.valueOf(new Double(this.DRECK_dre_pitch_log_misalignment).floatValue()), 1);
                            if (ProtocolName.matches("PHINS_STANDARD")) {
                                this.Encod.setValue(265, Float.valueOf(new Double(this.CALCHK_travelled_distance).floatValue()), 11);
                                this.Encod.setValue(266, Float.valueOf(new Double(this.CALCHK_vertical_error).floatValue()), 11);
                                this.Encod.setValue(267, Float.valueOf(new Double(this.CALCHK_horizontal_error).floatValue()), 11);
                                this.Encod.setValue(241, Float.valueOf(new Double(this.LMNIN_loch_speed).floatValue()), 21);
                                this.Encod.setValue(250, Float.valueOf(new Double(this.LMNIN_current_north_speed).floatValue()), 21);
                                this.Encod.setValue(251, Float.valueOf(new Double(this.LMNIN_current_east_speed).floatValue()), 21);
                                this.Encod.setValue(252, Float.valueOf(new Double(this.LMNIN_current_north_speed_sd).floatValue()), 21);
                                this.Encod.setValue(253, Float.valueOf(new Double(this.LMNIN_current_east_speed_sd).floatValue()), 21);
                                this.Encod.setValue(239, Float.valueOf(new Double(this.LMNIN_loch_data_validity_time).floatValue()), 34);
                            }
                            this.Encod.setValue(257, Float.valueOf(new Double(this.ODOIN_dmi_speed).floatValue()), 21);
                            this.Encod.setValue(256, Float.valueOf(new Double(this.ODOIN_dmi_data_validity_time).floatValue()), 34);
                            this.Encod.setValue(734, Float.valueOf(new Double(this.DSTTRV_cdat_dsttrv).floatValue()), 11);
                            this.Encod.setValue(606, this.ALGSTS_algo_status_1, 1000);
                            this.Encod.setValue(607, this.ALGSTS_algo_status_2, 1000);
                            this.Encod.setValue(608, this.ALGSTS_algo_status_3, 1000);
                            this.Encod.setValue(609, this.ALGSTX_algo_status_4, 1000);
                            this.Encod.setValue(611, this.ALGSTX_algo_status_5, 1000);
                            this.Encod.setValue(612, this.ALGSTX_algo_status_6, 1000);
                            this.Encod.setValue(600, this.STATUS_system_status_1, 1000);
                            this.Encod.setValue(601, this.STATUS_system_status_2, 1000);
                            this.Encod.setValue(735, this.HT_STS_cdat_ht_sts, 1000);
                            if (ProtocolName.matches("PHINS_STANDARD")) {
                                this.Encod.setValue(603, this.SORSTS_sensor_status_1, 1000);
                                this.Encod.setValue(604, this.SORSTS_sensor_status_2, 1000);
                            }
                            if (ProtocolName.matches("LANDINS_STANDARD")) {
                                this.Encod.setValue(424, Float.valueOf(new Double(this.ANGLIN_turret_heading).floatValue()), 1);
                                this.Encod.setValue(425, Float.valueOf(new Double(this.ANGLIN_turret_roll).floatValue()), 1);
                                this.Encod.setValue(426, Float.valueOf(new Double(this.ANGLIN_turret_pitch).floatValue()), 1);
                                this.Encod.setValue(423, Float.valueOf(new Double(this.ANGLIN_turret_data_validity_time).floatValue()), 34);
                                this.Encod.setValue(417, Float.valueOf(new Double(this.PTGATT_pointing_angle_heading).floatValue()), 1);
                                this.Encod.setValue(418, Float.valueOf(new Double(this.PTGATT_pointing_angle_roll).floatValue()), 1);
                                this.Encod.setValue(419, Float.valueOf(new Double(this.PTGATT_pointing_angle_pitch).floatValue()), 1);
                                this.Encod.setValue(420, Float.valueOf(new Double(this.STDPTG_pointing_angle_heading_sd).floatValue()), 1);
                                this.Encod.setValue(421, Float.valueOf(new Double(this.STDPTG_pointing_angle_roll_sd).floatValue()), 1);
                                this.Encod.setValue(422, Float.valueOf(new Double(this.STDPTG_pointing_angle_pitch_sd).floatValue()), 1);
                            }
                            ++this.nbTIMEFrames;
                            if (this.nbTIMEFrames != 1) {
                                LoggerDecoderFrame.FrameReady = true;
                            }
                        }
                        this.InterpretedFrame_AddToList(sFrame_no_crlf);
                        break block5;
                    }
                    case "ATITUD": {
                        if (!RegExp.is_fpt3fpt5(params[2]) || !RegExp.is_fpt3fpt5(params[3])) {
                            this.InterpretedFrame_AddToList(params[1] + " Format error:" + sFrame_no_crlf);
                            return -1;
                        }
                        if (this.GetCurvePlotImplementation()) {
                            this.ATITUD_roll = params[2];
                            this.ATITUD_pitch = params[3];
                        }
                        this.InterpretedFrame_AddToList(sFrame_no_crlf);
                        break block5;
                    }
                    case "HEAVE_": {
                        if (!(RegExp.is_fpt3(params[2]) && RegExp.is_fpt3(params[3]) && RegExp.is_fpt3(params[4]))) {
                            this.InterpretedFrame_AddToList(params[1] + " Format error : " + sFrame_no_crlf);
                            return -1;
                        }
                        if (this.GetCurvePlotImplementation()) {
                            this.HEAVE_surge = params[2];
                            this.HEAVE_sway = params[3];
                            this.HEAVE_heave = params[4];
                        }
                        this.InterpretedFrame_AddToList(sFrame_no_crlf);
                        break block5;
                    }
                    case "STDHRP": {
                        if (!(RegExp.is_fpt3(params[2]) && RegExp.is_fpt3fpt5(params[3]) && RegExp.is_fpt3fpt5(params[4]))) {
                            this.InterpretedFrame_AddToList(params[1] + " Format error : " + sFrame_no_crlf);
                            return -1;
                        }
                        if (this.GetCurvePlotImplementation()) {
                            this.STDHRP_heading_sd = params[2];
                            this.STDHRP_roll_sd = params[3];
                            this.STDHRP_pitch_sd = params[4];
                        }
                        this.InterpretedFrame_AddToList(sFrame_no_crlf);
                        break block5;
                    }
                    case "STDPOS": {
                        if (!(RegExp.is_fpt2(params[2]) && RegExp.is_fpt2(params[3]) && RegExp.is_fpt2(params[4]))) {
                            this.InterpretedFrame_AddToList(params[1] + " Format error : " + sFrame_no_crlf);
                            return -1;
                        }
                        if (this.GetCurvePlotImplementation()) {
                            this.STDPOS_latitude_sd = params[2];
                            this.STDPOS_longitude_sd = params[3];
                            this.STDPOS_altitude_sd = params[4];
                        }
                        this.InterpretedFrame_AddToList(sFrame_no_crlf);
                        break block5;
                    }
                    case "POSITI": {
                        if (!(RegExp.is_fpt8(params[2]) && RegExp.is_fpt8(params[3]) && RegExp.is_fpt3(params[4]))) {
                            this.InterpretedFrame_AddToList(params[1] + " Format error : " + sFrame_no_crlf);
                            return -1;
                        }
                        if (this.GetCurvePlotImplementation()) {
                            this.POSITI_latitude = params[2];
                            this.POSITI_longitude = params[3];
                            this.POSITI_altitude = params[4];
                        }
                        this.InterpretedFrame_AddToList(sFrame_no_crlf);
                        break block5;
                    }
                    case "SPEED_": {
                        if (!(RegExp.is_fpt3(params[2]) && RegExp.is_fpt3(params[3]) && RegExp.is_fpt3(params[4]))) {
                            this.InterpretedFrame_AddToList(params[1] + " Format error : " + sFrame_no_crlf);
                            return -1;
                        }
                        if (this.GetCurvePlotImplementation()) {
                            this.SPEED_east_speed = params[2];
                            this.SPEED_north_speed = params[3];
                            this.SPEED_vertical_speed = params[4];
                        }
                        this.InterpretedFrame_AddToList(sFrame_no_crlf);
                        break block5;
                    }
                    case "STDSPD": {
                        if (!(RegExp.is_fpt3(params[2]) && RegExp.is_fpt3(params[3]) && RegExp.is_fpt3(params[4]))) {
                            this.InterpretedFrame_AddToList(params[1] + " Format error : " + sFrame_no_crlf);
                            return -1;
                        }
                        if (this.GetCurvePlotImplementation()) {
                            this.STDSPD_north_speed_sd = params[2];
                            this.STDSPD_east_speed_sd = params[3];
                            this.STDSPD_vertical_speed_sd = params[4];
                        }
                        this.InterpretedFrame_AddToList(sFrame_no_crlf);
                        break block5;
                    }
                    case "LOGIN_": {
                        if (!(RegExp.is_fpt3(params[2]) && RegExp.is_fpt3(params[3]) && RegExp.is_fpt3(params[4]) && RegExp.is_fpt3(params[5]) && RegExp.is_tpt6(params[6]))) {
                            this.InterpretedFrame_AddToList(params[1] + " Format error : " + sFrame_no_crlf);
                            return -1;
                        }
                        if (this.GetCurvePlotImplementation()) {
                            this.LOGIN_dvl_bt_speed_xv1 = params[2];
                            this.LOGIN_dvl_bt_speed_xv2 = params[3];
                            this.LOGIN_dvl_bt_speed_xv3 = params[4];
                            this.LOGIN_log_misalignment = params[5];
                            this.LOGIN_dvl_bt_data_validity_time = params[6];
                        }
                        this.InterpretedFrame_AddToList(sFrame_no_crlf);
                        break block5;
                    }
                    case "LOGDVL": {
                        if (!(RegExp.is_fpt2(params[2]) && RegExp.is_fpt2(params[3]) && RegExp.is_fpt2(params[4]))) {
                            this.InterpretedFrame_AddToList(params[1] + " Format error : " + sFrame_no_crlf);
                            return -1;
                        }
                        if (this.GetCurvePlotImplementation()) {
                            this.LOGDVL_dvl_sound_speed = params[2];
                            this.LOGDVL_sound_speed = params[3];
                            this.LOGDVL_dvl_range_to_bottom = params[4];
                        }
                        this.InterpretedFrame_AddToList(sFrame_no_crlf);
                        break block5;
                    }
                    case "LOGWAT": {
                        if (!(RegExp.is_fpt3(params[2]) && RegExp.is_fpt3(params[3]) && RegExp.is_fpt3(params[4]) && RegExp.is_fpt3(params[5]) && RegExp.is_fpt3(params[6]) && RegExp.is_fpt3(params[7]) && RegExp.is_fpt3(params[8]) && RegExp.is_tpt6(params[9]))) {
                            this.InterpretedFrame_AddToList(params[1] + " Format error : " + sFrame_no_crlf);
                            return -1;
                        }
                        if (this.GetCurvePlotImplementation()) {
                            this.LOGWAT_dvl_wt_speed_xv1 = params[2];
                            this.LOGWAT_dvl_wt_speed_xv2 = params[3];
                            this.LOGWAT_dvl_wt_speed_xv3 = params[4];
                            this.LOGWAT_current_north_speed = params[5];
                            this.LOGWAT_current_east_speed = params[6];
                            this.LOGWAT_current_north_speed_sd = params[7];
                            this.LOGWAT_current_east_speed_sd = params[8];
                            this.LOGWAT_wt_data_validity_time = params[9];
                        }
                        this.InterpretedFrame_AddToList(sFrame_no_crlf);
                        break block5;
                    }
                    case "GPSIN_": {
                        if (!(RegExp.is_fpt8(params[2]) && RegExp.is_fpt8(params[3]) && RegExp.is_fpt3(params[4]) && RegExp.is_tpt6(params[5]) && RegExp.is_d1(params[6]))) {
                            this.InterpretedFrame_AddToList(params[1] + " Format error : " + sFrame_no_crlf);
                            return -1;
                        }
                        if (this.GetCurvePlotImplementation()) {
                            this.GPSIN_gps_latitude = params[2];
                            this.GPSIN_gps_longitude = params[3];
                            this.GPSIN_gps_altitude = params[4];
                            this.GPSIN_gps_data_validity_time = params[5];
                            this.GPSIN_gps_quality = params[6];
                        }
                        this.InterpretedFrame_AddToList(sFrame_no_crlf);
                        break block5;
                    }
                    case "GP2IN_": {
                        if (!(RegExp.is_fpt8(params[2]) && RegExp.is_fpt8(params[3]) && RegExp.is_fpt3(params[4]) && RegExp.is_tpt6(params[5]) && RegExp.is_d1(params[6]))) {
                            this.InterpretedFrame_AddToList(params[1] + " Format error : " + sFrame_no_crlf);
                            return -1;
                        }
                        if (this.GetCurvePlotImplementation()) {
                            this.GP2IN_gps_latitude = params[2];
                            this.GP2IN_gps_longitude = params[3];
                            this.GP2IN_gps_altitude = params[4];
                            this.GP2IN_gps_data_validity_time = params[5];
                            this.GP2IN_gps_quality = params[6];
                        }
                        this.InterpretedFrame_AddToList(sFrame_no_crlf);
                        break block5;
                    }
                    case "GPMIN_": {
                        if (!(RegExp.is_fpt8(params[2]) && RegExp.is_fpt8(params[3]) && RegExp.is_fpt3(params[4]) && RegExp.is_tpt6(params[5]) && RegExp.is_d1(params[6]))) {
                            this.InterpretedFrame_AddToList(params[1] + " Format error : " + sFrame_no_crlf);
                            return -1;
                        }
                        if (this.GetCurvePlotImplementation()) {
                            this.GPMIN_gps_latitude = params[2];
                            this.GPMIN_gps_longitude = params[3];
                            this.GPMIN_gps_altitude = params[4];
                            this.GPMIN_gps_data_validity_time = params[5];
                            this.GPMIN_gps_quality = params[6];
                        }
                        this.InterpretedFrame_AddToList(sFrame_no_crlf);
                        break block5;
                    }
                    case "DEPIN_": {
                        if (!RegExp.is_fpt3(params[2]) || !RegExp.is_tpt6(params[3])) {
                            this.InterpretedFrame_AddToList(params[1] + " Format error : " + sFrame_no_crlf);
                            return -1;
                        }
                        if (this.GetCurvePlotImplementation()) {
                            this.DEPIN_depth = params[2];
                            this.DEPIN_depth_data_validity_time = params[3];
                        }
                        this.InterpretedFrame_AddToList(sFrame_no_crlf);
                        break block5;
                    }
                    case "UTCIN_": {
                        if (!RegExp.is_tpt6(params[2])) {
                            this.InterpretedFrame_AddToList(params[1] + " Format error : " + sFrame_no_crlf);
                            return -1;
                        }
                        if (this.GetCurvePlotImplementation()) {
                            this.UTCIN_utc_time = params[2];
                        }
                        this.InterpretedFrame_AddToList(sFrame_no_crlf);
                        break block5;
                    }
                    case "DDRECK": 
                    case "ODRECK": {
                        if (!(RegExp.is_fpt8(params[2]) && RegExp.is_fpt8(params[3]) && RegExp.is_fpt3(params[4]) && RegExp.is_fpt3(params[5]) && RegExp.is_ns_fpt6(params[6]) && RegExp.is_fpt3(params[7]))) {
                            this.InterpretedFrame_AddToList(params[1] + " Format error : " + sFrame_no_crlf);
                            return -1;
                        }
                        if (this.GetCurvePlotImplementation()) {
                            this.DRECK_dre_latitude = params[2];
                            this.DRECK_dre_longitude = params[3];
                            this.DRECK_dre_altitude = params[4];
                            this.DRECK_dre_heading_log_misalignment = params[5];
                            this.DRECK_dre_scale_factor = params[6];
                            this.DRECK_dre_pitch_log_misalignment = params[7];
                        }
                        this.InterpretedFrame_AddToList(sFrame_no_crlf);
                        break block5;
                    }
                    case "ODOIN_": {
                        if (!RegExp.is_fpt3(params[2]) || !RegExp.is_tpt6(params[3])) {
                            this.InterpretedFrame_AddToList(params[1] + " Format error : " + sFrame_no_crlf);
                            return -1;
                        }
                        if (this.GetCurvePlotImplementation()) {
                            this.ODOIN_dmi_speed = params[2];
                            this.ODOIN_dmi_data_validity_time = params[3];
                        }
                        this.InterpretedFrame_AddToList(sFrame_no_crlf);
                        break block5;
                    }
                    case "ALGSTS": {
                        if (params.length == 6 && !RegExp.is_hexa8(params[4])) {
                            this.InterpretedFrame_AddToList(params[1] + " Format error : " + sFrame_no_crlf);
                            return -1;
                        }
                        if (!RegExp.is_hexa8(params[2]) || !RegExp.is_hexa8(params[3])) {
                            this.InterpretedFrame_AddToList(params[1] + " Format error : " + sFrame_no_crlf);
                            return -1;
                        }
                        if (this.GetCurvePlotImplementation()) {
                            this.ALGSTS_algo_status_1 = params[2];
                            this.ALGSTS_algo_status_2 = params[3];
                            if (params.length == 6) {
                                this.ALGSTS_algo_status_3 = params[4];
                            }
                        }
                        this.InterpretedFrame_AddToList(sFrame_no_crlf);
                        break block5;
                    }
                    case "ALGSTX": {
                        if (!(RegExp.is_hexa8(params[2]) && RegExp.is_hexa8(params[3]) && RegExp.is_hexa8(params[4]))) {
                            this.InterpretedFrame_AddToList(params[1] + " Format error : " + sFrame_no_crlf);
                            return -1;
                        }
                        if (this.GetCurvePlotImplementation()) {
                            this.ALGSTX_algo_status_4 = params[2];
                            this.ALGSTX_algo_status_5 = params[3];
                            this.ALGSTX_algo_status_6 = params[4];
                        }
                        this.InterpretedFrame_AddToList(sFrame_no_crlf);
                        break block5;
                    }
                    case "STATUS": {
                        if (!RegExp.is_hexa8(params[2]) || !RegExp.is_hexa8(params[3])) {
                            this.InterpretedFrame_AddToList(params[1] + " Format error : " + sFrame_no_crlf);
                            return -1;
                        }
                        if (this.GetCurvePlotImplementation()) {
                            this.STATUS_system_status_1 = params[2];
                            this.STATUS_system_status_2 = params[3];
                            if (RegExp.is_hexa8(params[4])) {
                                this.STATUS_system_status_3 = params[4];
                            }
                        }
                        this.InterpretedFrame_AddToList(sFrame_no_crlf);
                        break block5;
                    }
                    case "SORSTS": {
                        if (!RegExp.is_hexa8(params[2]) || !RegExp.is_hexa8(params[3])) {
                            this.InterpretedFrame_AddToList(params[1] + " Format error : " + sFrame_no_crlf);
                            return -1;
                        }
                        if (this.GetCurvePlotImplementation()) {
                            this.SORSTS_sensor_status_1 = params[2];
                            this.SORSTS_sensor_status_2 = params[3];
                        }
                        this.InterpretedFrame_AddToList(sFrame_no_crlf);
                        break block5;
                    }
                    case "HT_STS": {
                        if (!RegExp.is_hexa8(params[2])) {
                            this.InterpretedFrame_AddToList(params[1] + " Format error : " + sFrame_no_crlf);
                            return -1;
                        }
                        if (this.GetCurvePlotImplementation()) {
                            this.HT_STS_cdat_ht_sts = params[2];
                        }
                        this.InterpretedFrame_AddToList(sFrame_no_crlf);
                        break block5;
                    }
                    case "FOGEST": {
                        if (!(RegExp.is_fpt4(params[2]) && RegExp.is_fpt4(params[3]) && RegExp.is_fpt4(params[4]))) {
                            this.InterpretedFrame_AddToList(params[1] + " Format error : " + sFrame_no_crlf);
                            return -1;
                        }
                        if (this.GetCurvePlotImplementation()) {
                            this.FOGEST_xv1_rot_bias = params[2];
                            this.FOGEST_xv2_rot_bias = params[3];
                            this.FOGEST_xv3_rot_bias = params[4];
                        }
                        this.InterpretedFrame_AddToList(sFrame_no_crlf);
                        break block5;
                    }
                    case "ACCEST": {
                        if (!(RegExp.is_fpt4(params[2]) && RegExp.is_fpt4(params[3]) && RegExp.is_fpt4(params[4]))) {
                            this.InterpretedFrame_AddToList(params[1] + " Format error : " + sFrame_no_crlf);
                            return -1;
                        }
                        if (this.GetCurvePlotImplementation()) {
                            this.ACCEST_xv1_acc_bias = params[2];
                            this.ACCEST_xv2_acc_bias = params[3];
                            this.ACCEST_xv3_acc_bias = params[4];
                        }
                        this.InterpretedFrame_AddToList(sFrame_no_crlf);
                        break block5;
                    }
                    case "LOGEST": {
                        if (!RegExp.is_fpt4(params[2])) {
                            this.InterpretedFrame_AddToList(params[1] + " Format error : " + sFrame_no_crlf);
                            return -1;
                        }
                        if (this.GetCurvePlotImplementation()) {
                            this.LOGEST_log_misalignment = params[2];
                        }
                        this.InterpretedFrame_AddToList(sFrame_no_crlf);
                        break block5;
                    }
                    case "PTGATT": {
                        if (!(RegExp.is_fpt3fpt5(params[2]) && RegExp.is_fpt3fpt5(params[3]) && RegExp.is_fpt3fpt5(params[4]))) {
                            this.InterpretedFrame_AddToList(params[1] + " Format error : " + sFrame_no_crlf);
                            return -1;
                        }
                        if (this.GetCurvePlotImplementation()) {
                            this.PTGATT_pointing_angle_heading = params[2];
                            this.PTGATT_pointing_angle_roll = params[3];
                            this.PTGATT_pointing_angle_pitch = params[4];
                        }
                        this.InterpretedFrame_AddToList(sFrame_no_crlf);
                        break block5;
                    }
                    case "STDPTG": {
                        if (!(RegExp.is_fpt3(params[2]) && RegExp.is_fpt3(params[3]) && RegExp.is_fpt3(params[4]))) {
                            this.InterpretedFrame_AddToList(params[1] + " Format error : " + sFrame_no_crlf);
                            return -1;
                        }
                        if (this.GetCurvePlotImplementation()) {
                            this.STDPTG_pointing_angle_heading_sd = params[2];
                            this.STDPTG_pointing_angle_roll_sd = params[3];
                            this.STDPTG_pointing_angle_pitch_sd = params[4];
                        }
                        this.InterpretedFrame_AddToList(sFrame_no_crlf);
                        break block5;
                    }
                    case "ANGLIN": {
                        if (!(RegExp.is_fpt3(params[2]) && RegExp.is_fpt3(params[3]) && RegExp.is_fpt3(params[4]) && RegExp.is_tpt6(params[5]))) {
                            this.InterpretedFrame_AddToList(params[1] + " Format error : " + sFrame_no_crlf);
                            return -1;
                        }
                        if (this.GetCurvePlotImplementation()) {
                            this.ANGLIN_turret_heading = params[2];
                            this.ANGLIN_turret_roll = params[3];
                            this.ANGLIN_turret_pitch = params[4];
                            this.ANGLIN_turret_data_validity_time = params[5];
                        }
                        this.InterpretedFrame_AddToList(sFrame_no_crlf);
                        break block5;
                    }
                    case "DSTTRV": {
                        if (!RegExp.is_fpt3(params[2])) {
                            this.InterpretedFrame_AddToList(params[1] + " Format error : " + sFrame_no_crlf);
                            return -1;
                        }
                        if (!this.GetCurvePlotImplementation()) break block5;
                        this.DSTTRV_cdat_dsttrv = params[2];
                        break block5;
                    }
                    case "UTMWGS": {
                        if (!(RegExp.is_c1(params[2]) && RegExp.is_d2(params[3]) && RegExp.is_fpt3(params[4]) && RegExp.is_fpt3(params[5]) && RegExp.is_fpt3(params[6]))) {
                            this.InterpretedFrame_AddToList(params[1] + " Format error : " + sFrame_no_crlf);
                            return -1;
                        }
                        if (this.GetCurvePlotImplementation()) {
                            this.UTMWGS_cdat_utm_letter = params[2];
                            this.UTMWGS_cdat_utm_zone = params[3];
                            this.UTMWGS_cdat_utm_east = params[4];
                            this.UTMWGS_cdat_utm_north = params[5];
                            this.UTMWGS_cdat_utm_alti = params[6];
                        }
                        this.InterpretedFrame_AddToList(sFrame_no_crlf);
                        break block5;
                    }
                    case "CALCHK": {
                        if (this.GetCurvePlotImplementation()) {
                            this.CALCHK_travelled_distance = params[2];
                            this.CALCHK_vertical_error = params[3];
                            this.CALCHK_horizontal_error = params[4];
                        }
                        this.InterpretedFrame_AddToList(sFrame_no_crlf);
                        break block5;
                    }
                    case "USBIN_": {
                        if (this.GetCurvePlotImplementation()) {
                            this.USBIN_usbl_latitude = params[2];
                            this.USBIN_usbl_longitude = params[3];
                            this.USBIN_usbl_altitude = params[4];
                            this.USBIN_usbl_delay = params[5];
                            this.USBIN_usbl_data_validity_time = params[6];
                        }
                        this.InterpretedFrame_AddToList(sFrame_no_crlf);
                        break block5;
                    }
                    case "LBLIN_": {
                        if (this.GetCurvePlotImplementation()) {
                            this.LBLIN_lbl_latitude = params[2];
                            this.LBLIN_lbl_longitude = params[3];
                            this.LBLIN_lbl_altitude = params[4];
                            this.LBLIN_lbl_id = params[5];
                            this.LBLIN_lbl_range = params[6];
                            this.LBLIN_lbl_data_validity_time = params[7];
                        }
                        this.InterpretedFrame_AddToList(sFrame_no_crlf);
                        break block5;
                    }
                    case "LMNIN_": {
                        if (this.GetCurvePlotImplementation()) {
                            this.LMNIN_loch_speed = params[2];
                            this.LMNIN_current_north_speed = params[3];
                            this.LMNIN_current_east_speed = params[4];
                            this.LMNIN_current_north_speed_sd = params[5];
                            this.LMNIN_current_east_speed_sd = params[6];
                            this.LMNIN_loch_data_validity_time = params[7];
                        }
                        this.InterpretedFrame_AddToList(sFrame_no_crlf);
                        break block5;
                    }
                    default: {
                        this.InterpretedFrame_AddToList("Unexpected header : " + sFrame_no_crlf);
                        return -1;
                    }
                }
            }
            default: {
                this.InterpretedFrame_AddToList("Unexpected header : " + sFrame_no_crlf);
                return -1;
            }
        }
        return 0;
    }
}

