/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;
import Protocols.CRC16Modbus;

public class LODESTAR_Msg02_Decoder
extends Decoder {
    public static final int INS_MSG_LENGTH = 26;
    private Encoder Encod;
    private double UtmEasting = 0.0;
    private double UtmNorthing = 0.0;
    private double Depth = 0.0;
    private double DvlRangeToBottom = 0.0;
    private double Heading = 0.0;
    private double Pitch = 0.0;
    private double Roll = 0.0;
    private double HoriPosSD = 0.0;
    private int InsStatus = 0;

    public LODESTAR_Msg02_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(true);
        byte[] Start2 = new byte[]{85};
        this.DecodeInit(0, 26, Start2, 1);
    }

    @Override
    public String GetFileHeading() {
        String sep = this.Info.GetSeparator();
        return "UtmEasting(cm)" + sep + "UtmNorthing(cm)" + sep + "Depth(cm)" + sep + "DvlRangeToBottom(cm)" + sep + "Heading(\u00b0)" + sep + "Pitch(\u00b0)" + sep + "Roll(\u00b0)" + sep + "HoriPosSD(m)" + sep + "InsStatus(decimal)";
    }

    @Override
    public int InterpretFrame(byte[] Detected_Frame, int Length) {
        int i;
        int endianness = 0;
        CRC16Modbus crc2 = new CRC16Modbus();
        if (Detected_Frame[2] != 2) {
            this.InterpretedFrame = "Err INS Message : Unexpected message ID.";
            return -1;
        }
        for (i = 3; i < 26; ++i) {
            if (Detected_Frame[i] != Detected_Frame[1]) continue;
            Detected_Frame[i] = 85;
        }
        int crc1 = this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 24, endianness);
        crc2.reset();
        for (i = 2; i < 24; ++i) {
            crc2.update(Detected_Frame[i]);
        }
        if ((long)crc1 != crc2.getValue()) {
            this.InterpretedFrame = "Err INS Message : Unexpected checksum";
            return -1;
        }
        this.UtmEasting = (double)this.Convert_4Bytes_to_SignedInt(Detected_Frame, 3, endianness) * 0.5;
        this.UtmNorthing = (double)this.Convert_4Bytes_to_SignedInt(Detected_Frame, 7, endianness) * 0.5;
        this.Depth = (double)this.Convert_3Bytes_to_SignedInt(Detected_Frame, 11, endianness) * 0.5;
        this.DvlRangeToBottom = (double)this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 14, endianness) * 1.0;
        this.Heading = (double)this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 16, endianness) * 0.01;
        this.Pitch = (double)this.Convert_2Bytes_to_SignedInt(Detected_Frame, 18, endianness) * 0.01;
        this.Roll = (double)this.Convert_2Bytes_to_SignedInt(Detected_Frame, 20, endianness) * 0.01;
        this.HoriPosSD = (double)this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 22, endianness) * 0.1;
        this.InsStatus = Detected_Frame[23];
        if (this.GetCurvePlotImplementation()) {
            this.Encod.setValue(731, this.UtmEasting / 100.0, 11);
            this.Encod.setValue(732, this.UtmNorthing / 100.0, 11);
            this.Encod.setValue(126, -this.Depth / 100.0, 11);
            this.Encod.setValue(103, this.Heading, 1);
            this.Encod.setValue(104, this.Roll, 1);
            this.Encod.setValue(105, -this.Pitch, 1);
            this.Encod.setValue(208, this.DvlRangeToBottom / 100.0, 11);
            this.Encod.setValue(737, this.HoriPosSD, 11);
            this.Encod.setValue(1000, this.InsStatus, 1000);
            LoggerDecoderFrame.FrameReady = true;
        }
        this.InterpretedFrame = this.InterpretDouble(this.UtmEasting);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(this.UtmNorthing);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(this.Depth);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(this.DvlRangeToBottom);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(this.Heading);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(this.Pitch);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(this.Roll);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(this.HoriPosSD);
        this.InterpretedFrame = this.InterpretedFrame + this.InsStatus;
        this.InterpretedFrame_AddToList(this.InterpretedFrame);
        return 0;
    }
}

