/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;
import Protocols.CRC16Modbus;

public class LODESTAR_Msg04_Decoder
extends Decoder {
    public static final int GYRO_MSG_LENGTH = 12;
    private Encoder Encod;
    private double Heading = 0.0;
    private double Pitch = 0.0;
    private double Roll = 0.0;
    private int InsStatus = 0;

    public LODESTAR_Msg04_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(true);
        byte[] Start2 = new byte[]{85};
        this.DecodeInit(0, 12, Start2, 1);
    }

    @Override
    public String GetFileHeading() {
        String sep = this.Info.GetSeparator();
        return "Heading(\u00b0)" + sep + "Pitch(\u00b0)" + sep + "Roll(\u00b0)" + sep + "InsStatus(decimal)";
    }

    @Override
    public int InterpretFrame(byte[] Detected_Frame, int Length) {
        int i;
        int endianness = 0;
        CRC16Modbus crc2 = new CRC16Modbus();
        if (Detected_Frame[2] != 4) {
            this.InterpretedFrame = "Err GYRO Message: Unexpected message ID.";
            return -1;
        }
        for (i = 3; i < 12; ++i) {
            if (Detected_Frame[i] != Detected_Frame[1]) continue;
            Detected_Frame[i] = 85;
        }
        int crc1 = this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 10, endianness);
        crc2.reset();
        for (i = 2; i < 10; ++i) {
            crc2.update(Detected_Frame[i]);
        }
        if ((long)crc1 != crc2.getValue()) {
            this.InterpretedFrame = "Err GYRO Message : Unexpected checksum";
            return -1;
        }
        this.Heading = (double)this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 3, endianness) / 100.0;
        this.Pitch = (double)this.Convert_2Bytes_to_SignedInt(Detected_Frame, 5, endianness) / 100.0;
        this.Roll = (double)this.Convert_2Bytes_to_SignedInt(Detected_Frame, 7, endianness) / 100.0;
        this.InsStatus = Detected_Frame[9];
        if (this.GetCurvePlotImplementation()) {
            this.Encod.setValue(103, this.Heading, 1);
            this.Encod.setValue(105, -this.Pitch, 1);
            this.Encod.setValue(104, this.Roll, 1);
            this.Encod.setValue(1000, this.InsStatus, 1000);
            LoggerDecoderFrame.FrameReady = true;
        }
        this.InterpretedFrame = this.InterpretDouble(this.Heading);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(this.Pitch);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(this.Roll);
        this.InterpretedFrame = this.InterpretedFrame + this.InsStatus;
        this.InterpretedFrame_AddToList(this.InterpretedFrame);
        return 0;
    }
}

