/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;

public class LRS10_78_IC_Decoder
extends Decoder {
    private Encoder Encod;

    public LRS10_78_IC_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(true);
        int Start_Blk_Length = 4;
        byte[] Start_Blk = new byte[Start_Blk_Length];
        Start_Blk[0] = 90;
        Start_Blk[1] = -91;
        Start_Blk[2] = 72;
        Start_Blk[3] = 2;
        int Length_Blk = 78;
        this.DecodeInit(0, Length_Blk, Start_Blk, Start_Blk_Length);
    }

    @Override
    public String GetFileHeading() {
        String sep = this.Info.GetSeparator();
        return "Sta1" + sep + "Sta2" + sep + "Sta3" + sep + "Day" + sep + "UTCTime(s)" + sep + "Heading(\u00b0)" + sep + "Roll(\u00b0)" + sep + "Pitch(\u00b0)" + sep + "HeadingRate(rad/s)" + sep + "RollRate(rad/s)" + sep + "PitchRate(rad/s)" + sep + "Lat(\u00b0)" + sep + "Long(\u00b0)" + sep + "Depth or Altitude(m)" + sep + "LatSD(Nm)" + sep + "LongSD(Nm)" + sep + "PosCorr" + sep + "GPSLat(\u00b0)" + sep + "GPSLong(\u00b0)" + sep + "NorthSpeed(m/s)" + sep + "EastSpeed(m/s)" + sep + "DownSpeed(m/s)" + sep + "LogSpeed(m/s)" + sep + "CourseOverGround(\u00b0)" + sep + "SpeedOverGround(m/s)" + sep + "CurrentDirection(\u00b0)" + sep + "CurrentSpeed(m/s)";
    }

    @Override
    public int InterpretFrame(byte[] Decoded_Frame, int Lenght) {
        int i;
        byte[] Chk = new byte[1];
        for (i = 2; i < 76; ++i) {
            Chk[0] = (byte)(Chk[0] + this.Bytes_Frame[i]);
        }
        if (Chk[0] != this.Bytes_Frame[76]) {
            this.InterpretedFrame = this.InterpretString("Checksum error");
            return -1;
        }
        if (this.Bytes_Frame[77] != -86) {
            this.InterpretedFrame = this.InterpretString("End of frame error");
            return -1;
        }
        if (this.Bytes_Frame[12] != 0 || this.Bytes_Frame[13] != 0) {
            this.InterpretedFrame = this.InterpretString("Spare error");
            return -1;
        }
        for (i = 70; i < 76; ++i) {
            if (this.Bytes_Frame[i] == 0) continue;
            this.InterpretedFrame = this.InterpretString("Spare error");
            return -1;
        }
        int Sta1 = this.Convert_1Byte_to_UnsignedInt(this.Bytes_Frame, 4, 1);
        int Sta2 = this.Convert_1Byte_to_UnsignedInt(this.Bytes_Frame, 5, 1);
        int Sta3 = this.Convert_1Byte_to_UnsignedInt(this.Bytes_Frame, 6, 1);
        int Day = this.Convert_2Bytes_to_UnsignedInt(this.Bytes_Frame, 7, 1);
        double UTCTime = (double)this.Convert_3Bytes_to_UnsignedInt(this.Bytes_Frame, 9, 1) * 0.01;
        double Heading = (double)this.Convert_2Bytes_to_UnsignedInt(this.Bytes_Frame, 14, 1) * 180.0 / 32768.0;
        double Roll = (double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 16, 1) * 90.0 / 32768.0;
        double Pitch = (double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 18, 1) * 90.0 / 32768.0;
        double HeadingRate = (double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 20, 1) * 1.0 / 32768.0;
        double RollRate = (double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 22, 1) * 1.0 / 32768.0;
        double PitchRate = (double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 24, 1) * 1.0 / 32768.0;
        double Latitude = (double)this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 26, 1) * 90.0 / 2.147483648E9;
        double Longitude = (double)this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 30, 1) * 180.0 / 2.147483648E9;
        double Depth = (double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 34, 1) * 655.36 / 32768.0;
        double LatitudeSD = (double)this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 36, 1) * 10800.0 / 2.147483648E9 / 3.0;
        double LongitudeSD = (double)this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 40, 1) * 10800.0 / 2.147483648E9 / 3.0;
        double PositionCorrelation = (double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 44, 1) / 32768.0;
        double GPSLatitude = (double)this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 46, 1) * 90.0 / 2.147483648E9;
        double GPSLongitude = (double)this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 50, 1) * 180.0 / 2.147483648E9;
        double NorthVel = (double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 54, 1) * 65.536 / 32768.0;
        double EastVel = (double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 56, 1) * 65.536 / 32768.0;
        double DownVel = (double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 58, 1) * 65.536 / 32768.0;
        double LogSpeed = (double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 60, 1) * 65.536 / 32768.0;
        double CourseOverGround = (double)this.Convert_2Bytes_to_UnsignedInt(this.Bytes_Frame, 62, 1) * 180.0 / 32768.0;
        double SpeedOverGround = (double)this.Convert_2Bytes_to_UnsignedInt(this.Bytes_Frame, 64, 1) * 65.536 / 32768.0;
        double CurrentDirection = (double)this.Convert_2Bytes_to_UnsignedInt(this.Bytes_Frame, 66, 1) * 180.0 / 32768.0;
        double CurrentSpeed = (double)this.Convert_2Bytes_to_UnsignedInt(this.Bytes_Frame, 68, 1) * 65.536 / 32768.0;
        if (this.GetCurvePlotImplementation()) {
            int Status_Bite = Sta1 & 7;
            int Status_Mode = Sta1 & 0x18;
            int Status_HRPVal = Sta1 & 0x60;
            int Status_GpsTimeVal = Sta2 & 1;
            int Status_Navigation = Sta2 & 0x10;
            int Status_Simulation = Sta2 & 0x40;
            this.Encod.setValue(1023, Status_Bite, 1000);
            this.Encod.setValue(1024, Status_Mode, 1000);
            this.Encod.setValue(1025, Status_HRPVal, 1000);
            this.Encod.setValue(1026, Status_GpsTimeVal, 1000);
            this.Encod.setValue(1004, Status_Simulation, 1000);
            this.Encod.setValue(1027, Status_Navigation, 1000);
            this.Encod.setValue(1000, Sta3, 1000);
            this.Encod.setValue(155, Day, 1000);
            this.Encod.setValue(100, UTCTime, 31);
            this.Encod.setValue(103, Float.valueOf((float)Heading), 1);
            this.Encod.setValue(104, Float.valueOf((float)Roll), 1);
            this.Encod.setValue(105, Float.valueOf(-((float)Pitch)), 1);
            this.Encod.setValue(110, Float.valueOf((float)HeadingRate), 52);
            this.Encod.setValue(111, Float.valueOf((float)RollRate), 52);
            this.Encod.setValue(112, Float.valueOf(-((float)PitchRate)), 52);
            this.Encod.setValue(124, Float.valueOf((float)Latitude), 1);
            this.Encod.setValue(125, Float.valueOf((float)Longitude), 1);
            this.Encod.setValue(126, Float.valueOf(-((float)Depth)), 11);
            this.Encod.setValue(148, Float.valueOf((float)Depth), 11);
            this.Encod.setValue(129, Float.valueOf((float)(LatitudeSD * 1852.0)), 11);
            this.Encod.setValue(130, Float.valueOf((float)(LongitudeSD * 1852.0)), 11);
            this.Encod.setValue(162, Float.valueOf((float)Latitude), 1);
            this.Encod.setValue(163, Float.valueOf((float)Longitude), 1);
            this.Encod.setValue(136, Float.valueOf((float)NorthVel), 21);
            this.Encod.setValue(137, Float.valueOf((float)EastVel), 21);
            this.Encod.setValue(138, Float.valueOf(-((float)DownVel)), 21);
            this.Encod.setValue(241, Float.valueOf((float)LogSpeed), 21);
            this.Encod.setValue(147, Float.valueOf((float)CourseOverGround), 1);
            this.Encod.setValue(146, Float.valueOf((float)SpeedOverGround), 21);
            this.Encod.setValue(254, Float.valueOf((float)CurrentDirection), 1);
            this.Encod.setValue(255, Float.valueOf((float)CurrentSpeed), 21);
            LoggerDecoderFrame.FrameReady = true;
        }
        this.InterpretedFrame = this.InterpretIntegerAsBin(Sta1);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsBin(Sta2);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsBin(Sta3);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Day);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(UTCTime);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Heading);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Roll);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Pitch);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(HeadingRate);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(RollRate);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(PitchRate);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Latitude);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Longitude);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Depth);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(LatitudeSD);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(LongitudeSD);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(PositionCorrelation);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(GPSLatitude);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(GPSLongitude);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(NorthVel);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(EastVel);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(DownVel);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(LogSpeed);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(CourseOverGround);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(SpeedOverGround);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(CurrentDirection);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(CurrentSpeed);
        this.InterpretedFrame_AddToList(this.InterpretedFrame);
        return 0;
    }
}

