/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MDL2_Decoder
extends Decoder {
    private Encoder Encod;
    private int current_line;

    public MDL2_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(true);
        this.current_line = 0;
        int Start_Blk_Length = 1;
        byte[] Start_Blk = new byte[Start_Blk_Length];
        Start_Blk[0] = 72;
        int Length_Blk = 0;
        this.DecodeInit(1, Length_Blk, Start_Blk, Start_Blk_Length);
    }

    @Override
    public int InterpretFrame(byte[] Decoded_Frame, int Lenght) {
        String sFrame_no_crlf = new String(Decoded_Frame, 0, Lenght - 2);
        boolean Status = false;
        ++this.current_line;
        Pattern p = Pattern.compile("(H)(\\d{4})(P)([-+])(\\d{4})(R)([-+])(\\d{4})([M,N,E])");
        Matcher m = p.matcher(sFrame_no_crlf);
        if (!m.matches()) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Format error");
            return -1;
        }
        if (this.GetCurvePlotImplementation()) {
            String sHeading = m.group(2);
            String sPitch = m.group(5);
            String sRoll = m.group(8);
            String sStatus = m.group(9);
            double Heading = (double)Integer.parseInt(sHeading) * 0.1;
            double Pitch = (double)Integer.parseInt(sPitch) * 0.01;
            if (m.group(4).matches("-")) {
                Pitch = -Pitch;
            }
            double Roll = (double)Integer.parseInt(sRoll) * 0.01;
            if (m.group(7).matches("-")) {
                Roll = -Roll;
            }
            this.Encod.setValue(103, Float.valueOf((float)Heading), 1);
            this.Encod.setValue(104, Float.valueOf((float)Roll), 1);
            this.Encod.setValue(105, Float.valueOf((float)Pitch), 1);
            this.Encod.setValue(1000, sStatus, 1000);
            LoggerDecoderFrame.FrameReady = true;
        }
        this.InterpretedFrame_AddToList(sFrame_no_crlf);
        return 0;
    }
}

