/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MINIFOG_OTG_MSG8_Decoder
extends Decoder {
    private Encoder Encod;
    private int current_line;

    public MINIFOG_OTG_MSG8_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(true);
        int Start_Blk_Length = 1;
        byte[] Start_Blk = new byte[Start_Blk_Length];
        Start_Blk[0] = 72;
        int Length_Blk = 0;
        this.DecodeInit(1, Length_Blk, Start_Blk, Start_Blk_Length);
    }

    @Override
    public int InterpretFrame(byte[] Decoded_Frame, int Lenght) {
        String sFrame_no_crlf = new String(Decoded_Frame, 0, Lenght - 2);
        int Status = 0;
        ++this.current_line;
        Pattern p = Pattern.compile("(H)(\\d{4})(P)([-+])(\\d{4})(R)([-+])(\\d{4})(X)([-+])(\\d{4})(Y)([-+])(\\d{4})(Z)([-+])(\\d{4})(E?|D?)");
        Matcher m = p.matcher(sFrame_no_crlf);
        if (!m.matches()) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Format error");
            return -1;
        }
        if (this.GetCurvePlotImplementation()) {
            String sStatus;
            String sHeading = m.group(2);
            String sPitchSign = m.group(4);
            String sPitch = m.group(5);
            String sRollSign = m.group(7);
            String sRoll = m.group(8);
            String sHeadingRateSign = m.group(10);
            String sHeadingRate = m.group(11);
            String sPitchRateSign = m.group(13);
            String sPitchRate = m.group(14);
            String sRollRateSign = m.group(16);
            String sRollRate = m.group(17);
            switch (sStatus = m.group(18)) {
                case "D": {
                    Status = 68;
                    break;
                }
                case "E": {
                    Status = 69;
                    break;
                }
                default: {
                    this.InterpretedFrame_AddToList("Status format error");
                    return -1;
                }
            }
            double Heading = (double)Integer.parseInt(sHeading) * 0.1;
            double Pitch = (double)Integer.parseInt(sPitch) * 0.1;
            if (sPitchSign.matches("-")) {
                Pitch = -Pitch;
            }
            double Roll = (double)Integer.parseInt(sRoll) * 0.1;
            if (sRollSign.matches("-")) {
                Roll = -Roll;
            }
            double HeadingRate = (double)Integer.parseInt(sHeadingRate) * 0.01;
            if (sHeadingRateSign.matches("-")) {
                HeadingRate = -HeadingRate;
            }
            double PitchRate = (double)Integer.parseInt(sPitchRate) * 0.01;
            if (sPitchRateSign.matches("-")) {
                PitchRate = -PitchRate;
            }
            double RollRate = (double)Integer.parseInt(sRollRate) * 0.01;
            if (sRollRateSign.matches("-")) {
                RollRate = -RollRate;
            }
            this.Encod.setValue(103, Float.valueOf((float)Heading), 1);
            this.Encod.setValue(105, Float.valueOf(-((float)Pitch)), 1);
            this.Encod.setValue(104, Float.valueOf((float)Roll), 1);
            this.Encod.setValue(110, Float.valueOf((float)HeadingRate), 51);
            this.Encod.setValue(112, Float.valueOf(-((float)PitchRate)), 51);
            this.Encod.setValue(111, Float.valueOf((float)RollRate), 51);
            this.Encod.setValue(1025, Status, 1000);
            LoggerDecoderFrame.FrameReady = true;
        }
        this.InterpretedFrame_AddToList(sFrame_no_crlf);
        return 0;
    }
}

