/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;

public class PEGASE_NAV_Decoder
extends Decoder {
    private Encoder Encod;

    public PEGASE_NAV_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(true);
        int Start_Blk_Length = 8;
        byte[] Start_Blk = new byte[Start_Blk_Length];
        Start_Blk[0] = 0;
        Start_Blk[1] = 0;
        Start_Blk[2] = 0;
        Start_Blk[3] = 101;
        Start_Blk[4] = 0;
        Start_Blk[5] = 0;
        Start_Blk[6] = 0;
        Start_Blk[7] = 40;
        int Length_Blk = 40;
        this.DecodeInit(0, Length_Blk, Start_Blk, Start_Blk_Length);
    }

    @Override
    public String GetFileHeading() {
        String sep = this.Info.GetSeparator();
        return "msgid" + sep + "msglength" + sep + "Day(in year)" + sep + "Time(tenth of s)" + sep + "Heading(\u00b0)" + sep + "XV1Speed(knots)" + sep + "EMLOGSpeed(knots)" + sep + "Depth(m)" + sep + "Latitude(\u00b0)" + sep + "Longitude(\u00b0)";
    }

    @Override
    public int InterpretFrame(byte[] Decoded_Frame, int Lenght) {
        boolean block_notvalid = false;
        long msgid = this.Convert_4Bytes_to_UnsignedInt(this.Bytes_Frame, 0, 1);
        long msglength = this.Convert_4Bytes_to_UnsignedInt(this.Bytes_Frame, 4, 1);
        if (this.Bytes_Frame[8] == -1) {
            block_notvalid = true;
        }
        if (block_notvalid) {
            long day = this.Convert_4Bytes_to_UnsignedInt(this.Bytes_Frame, 8, 1);
            long time = this.Convert_4Bytes_to_UnsignedInt(this.Bytes_Frame, 12, 1);
            long heading = this.Convert_4Bytes_to_UnsignedInt(this.Bytes_Frame, 16, 1);
            long xv1speed = this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 20, 1);
            long emlogspeed = this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 24, 1);
            long altitude = this.Convert_4Bytes_to_UnsignedInt(this.Bytes_Frame, 28, 1);
            long latitude = this.Convert_4Bytes_to_UnsignedInt(this.Bytes_Frame, 32, 1);
            long longitude = this.Convert_4Bytes_to_UnsignedInt(this.Bytes_Frame, 36, 1);
            this.InterpretedFrame = this.InterpretIntegerAsInt((int)msgid);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt((int)msglength);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex((int)day);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex((int)time);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex((int)heading);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex((int)xv1speed);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex((int)emlogspeed);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex((int)altitude);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex((int)latitude);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex((int)longitude);
        } else {
            double longitude;
            long day = this.Convert_4Bytes_to_UnsignedInt(this.Bytes_Frame, 8, 1);
            float time = (float)this.Convert_4Bytes_to_UnsignedInt(this.Bytes_Frame, 12, 1) / 10.0f;
            float heading = (float)((double)this.Convert_4Bytes_to_UnsignedInt(this.Bytes_Frame, 16, 1) * 180.0 / 32768.0);
            float xv1speed = (float)((double)this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 20, 1) * 0.01);
            float emlogspeed = (float)((double)this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 24, 1) * 0.01);
            int altitude = (int)this.Convert_4Bytes_to_UnsignedInt(this.Bytes_Frame, 28, 1);
            double latitude = (float)((double)this.Convert_4Bytes_to_UnsignedInt(this.Bytes_Frame, 32, 1) * 180.0 / 2.147483648E9);
            if (latitude >= 90.0) {
                latitude -= 180.0;
            }
            if ((longitude = (double)((float)((double)this.Convert_4Bytes_to_UnsignedInt(this.Bytes_Frame, 36, 1) * 180.0 / 2.147483648E9))) >= 180.0) {
                longitude -= 360.0;
            }
            this.InterpretedFrame = this.InterpretIntegerAsInt((int)msgid);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt((int)msglength);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt((int)day);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(time, 3);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(heading, 103);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(xv1speed, 133);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(emlogspeed, 241);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(altitude, 126);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(latitude, 124);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(longitude, 125);
            if (this.GetCurvePlotImplementation()) {
                this.Encod.setValue(155, day, 1000);
                this.Encod.setValue(100, Float.valueOf(time), 31);
                this.Encod.setValue(103, Float.valueOf(heading), 1);
                this.Encod.setValue(133, Float.valueOf(xv1speed), 25);
                this.Encod.setValue(241, Float.valueOf(emlogspeed), 25);
                this.Encod.setValue(126, -altitude, 11);
                this.Encod.setValue(124, latitude, 1);
                this.Encod.setValue(125, longitude, 1);
                LoggerDecoderFrame.FrameReady = true;
            }
        }
        this.InterpretedFrame_AddToList(this.InterpretedFrame);
        return 0;
    }
}

