/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;

public class POLAR_NAV_Decoder
extends Decoder {
    private Encoder Encod;

    public POLAR_NAV_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(true);
        int Start_Blk_Length = 4;
        byte[] Start_Blk = new byte[Start_Blk_Length];
        Start_Blk[0] = 0;
        Start_Blk[1] = 1;
        Start_Blk[2] = 3;
        Start_Blk[3] = 20;
        int Length_Blk = 288;
        this.DecodeInit(0, Length_Blk, Start_Blk, Start_Blk_Length);
    }

    @Override
    public String GetFileHeading() {
        String sep = this.Info.GetSeparator();
        return "TRCnt" + sep + "InsId" + sep + "TimeVal(s)" + sep + "Context" + sep + "TimeTR(s)" + sep + "TimeSM(s)" + sep + "AlignSta" + sep + "TimeLF(s)" + sep + "SrcLF" + sep + "Lat(\u00b0)" + sep + "Long(\u00b0)" + sep + "PosVal" + sep + "VEast(m/s)" + sep + "VNorth(m/s)" + sep + "VUp(m/s)" + sep + "VVal" + sep + "Vwt(m/s)" + sep + "VwtVal" + sep + "CurNorth" + sep + "CurEast" + sep + "IVNorth" + sep + "IVEast" + sep + "Heading(\u00b0)" + sep + "Pitch(\u00b0)" + sep + "Roll(\u00b0)" + sep + "HeadingRate(\u00b0/s)" + sep + "PitchRate(\u00b0/s)" + sep + "RollRate(\u00b0/s)" + sep + "HPRVal" + sep + "SensorDepth" + sep + "SensorDepthVal" + sep + "InsDepth" + sep + "InsDepthVal" + sep + "HeadingStd" + sep + "PitchStd" + sep + "RollStd" + sep + "HPRstdVal" + sep + "VEastStd" + sep + "VNorthStd" + sep + "VUpStd" + sep + "VStdVal" + sep + "LatStd" + sep + "LongStd" + sep + "PosStdVal" + sep + "InsDepthStd" + sep + "InsDepthStdVal" + sep + "PolLat" + sep + "PolLong" + sep + "PolPosVal" + sep + "PolHeading" + sep + "PolHeadingVal" + sep + "UsrStatus" + sep + "PolHeadRate" + sep + "PolHeadRateVal" + sep + "PolEastSpd" + sep + "PolNorthSpd" + sep + "PolSpdVal" + sep;
    }

    @Override
    public int InterpretFrame(byte[] Decoded_Frame, int Lenght) {
        int protocole_V = 1;
        int TRCounter = this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 4, 1);
        int AttNavMsgLenght = this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 8, 1);
        if (AttNavMsgLenght == 260) {
            protocole_V = 2;
        }
        if (this.Bytes_Frame[12] != 124) {
            return -1;
        }
        if (this.Bytes_Frame[13] != -59) {
            return -1;
        }
        if (this.Bytes_Frame[14] != -44) {
            return -1;
        }
        if (this.Bytes_Frame[15] != 116) {
            return -1;
        }
        if (this.Bytes_Frame[20] != 65) {
            return -1;
        }
        if (this.Bytes_Frame[21] != 78) {
            return -1;
        }
        if (this.Bytes_Frame[22] != 68) {
            return -1;
        }
        for (int i = 23; i < 27; ++i) {
            if (this.Bytes_Frame[i] == 120) continue;
            return -1;
        }
        if (this.Bytes_Frame[29] != 46 || this.Bytes_Frame[30] != 115) {
            return -1;
        }
        if (this.Bytes_Frame[31] != 110 || this.Bytes_Frame[32] != 97) {
            return -1;
        }
        if (this.Bytes_Frame[33] != 46 || this.Bytes_Frame[34] != 112) {
            return -1;
        }
        if (this.Bytes_Frame[35] != 114 || this.Bytes_Frame[36] != 105) {
            return -1;
        }
        if (this.Bytes_Frame[37] != 118 || this.Bytes_Frame[38] != 103) {
            return -1;
        }
        if (this.Bytes_Frame[39] != 114 || this.Bytes_Frame[40] != 111) {
            return -1;
        }
        if (this.Bytes_Frame[41] != 117 || this.Bytes_Frame[42] != 112) {
            return -1;
        }
        if (this.Bytes_Frame[43] != 46) {
            return -1;
        }
        double TimeVAL = this.Convert_8Bytes_to_Double(this.Bytes_Frame, 44, 0);
        int Context = this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 52, 0);
        int InsID = this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 56, 0);
        double TimeTR = (double)(50 * this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 60, 0)) / 1000000.0;
        double TimeSM = (double)(50 * this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 64, 0)) / 1000000.0;
        int AlignStatus = this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 68, 0);
        int TimeLF = this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 72, 0);
        int SourceLF = this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 76, 0);
        double Lat = (double)this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 80, 0) * Math.PI / 2.147483648E9;
        Lat *= 57.29577951308232;
        double Long2 = (double)this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 84, 0) * Math.PI / 2.147483648E9;
        Long2 *= 57.29577951308232;
        int PosVal = this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 88, 0);
        float VelEast = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 92, 0);
        float VelNorth = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 96, 0);
        float VelVertical = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 100, 0);
        int VelVal = this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 104, 0);
        float VelWT = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 108, 0);
        int WTVal = this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 112, 0);
        float OCNorth = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 116, 0);
        float OCEast = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 120, 0);
        double IVelNorth = this.Convert_8Bytes_to_Double(this.Bytes_Frame, 124, 0);
        double IVelEast = this.Convert_8Bytes_to_Double(this.Bytes_Frame, 132, 0);
        float Head = (float)((double)this.Convert_4Bytes_to_Float(this.Bytes_Frame, 140, 0) * (Math.PI * 2));
        Head = (float)((double)Head * 57.29577951308232);
        float Pitch = (float)(((double)this.Convert_4Bytes_to_Float(this.Bytes_Frame, 144, 0) - 0.25) * -360.0);
        float Roll = (float)((double)this.Convert_4Bytes_to_Float(this.Bytes_Frame, 148, 0) * (Math.PI * 2));
        Roll = (float)((double)Roll * 57.29577951308232);
        float HeadRate = (float)((double)this.Convert_4Bytes_to_Float(this.Bytes_Frame, 152, 0) * (Math.PI * 2));
        HeadRate = (float)((double)HeadRate * 57.29577951308232);
        float PitchRate = (float)((double)this.Convert_4Bytes_to_Float(this.Bytes_Frame, 156, 0) * (Math.PI * 2));
        PitchRate = (float)((double)PitchRate * 57.29577951308232);
        float RollRate = (float)((double)this.Convert_4Bytes_to_Float(this.Bytes_Frame, 160, 0) * (Math.PI * 2));
        RollRate = (float)((double)RollRate * 57.29577951308232);
        int HPRVal = this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 164, 0);
        float SensorDepth = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 168, 0);
        int SensorDepthVal = this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 172, 0);
        float INSDepth = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 176, 0);
        int INSDepthVal = this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 180, 0);
        float HeadStd = (float)((double)this.Convert_4Bytes_to_Float(this.Bytes_Frame, 184, 0) * (Math.PI * 2));
        HeadStd = (float)((double)HeadStd * 57.29577951308232);
        float PitchStd = (float)((double)this.Convert_4Bytes_to_Float(this.Bytes_Frame, 188, 0) * (Math.PI * 2));
        PitchStd = (float)((double)PitchStd * 57.29577951308232);
        float RollStd = (float)((double)this.Convert_4Bytes_to_Float(this.Bytes_Frame, 192, 0) * (Math.PI * 2));
        RollStd = (float)((double)RollStd * 57.29577951308232);
        int HPRStdVal = this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 196, 0);
        float VelEastStd = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 200, 0);
        float VelNorthStd = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 204, 0);
        float VelVerticalStd = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 208, 0);
        int VelStdVal = this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 212, 0);
        float LatStd = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 216, 0);
        float LongStd = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 220, 0);
        int PosStdVal = this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 224, 0);
        float INSDepthStd = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 228, 0);
        int INSDepthStdVal = this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 232, 0);
        float PolLat = (float)((double)this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 236, 0) * Math.PI / 2.147483648E9);
        PolLat = (float)((double)PolLat * 57.29577951308232);
        float PolLong = (float)((double)this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 240, 0) * Math.PI / 2.147483648E9);
        PolLong = (float)((double)PolLong * 57.29577951308232);
        int PolPosVal = this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 244, 0);
        float PolHead = (float)((double)this.Convert_4Bytes_to_Float(this.Bytes_Frame, 248, 0) * (Math.PI * 2));
        PolHead = (float)((double)PolHead * 57.29577951308232);
        int PolHeadVal = this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 252, 0);
        int UsrStatus = this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 256, 0);
        float PolarHeadRate = 0.0f;
        int PolarHeadRateVal = 0;
        float PolarVelEast = 0.0f;
        float PolarVelNorth = 0.0f;
        int PolarVelVal = 0;
        if (protocole_V == 2) {
            PolarHeadRate = (float)((double)this.Convert_4Bytes_to_Float(this.Bytes_Frame, 264, 0) * (Math.PI * 2));
            PolarHeadRate = (float)((double)PolarHeadRate * 57.29577951308232);
            PolarHeadRateVal = this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 268, 0);
            PolarVelEast = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 272, 0);
            PolarVelNorth = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 276, 0);
            PolarVelVal = this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 280, 0);
        }
        String _TRCounter = this.InterpretIntegerAsInt(TRCounter);
        String _InsID = this.InterpretIntegerAsInt(InsID);
        String _TimeVAL = this.InterpretDouble(TimeVAL, 8);
        String _Context = this.InterpretIntegerAsInt(Context);
        String _TimeTR = this.InterpretDouble(TimeTR);
        String _TimeSM = this.InterpretDouble(TimeSM);
        String _AlignStatus = this.InterpretIntegerAsInt(AlignStatus);
        String _TimeLF = this.InterpretIntegerAsInt(TimeLF);
        String _SourceLF = this.InterpretIntegerAsInt(SourceLF);
        String _Lat = this.InterpretDouble(Lat, 124);
        String _Long = this.InterpretDouble(Long2, 125);
        String _PosVal = this.InterpretIntegerAsInt(PosVal);
        String _VelEast = this.InterpretFloat(VelEast, 137);
        String _VelNorth = this.InterpretFloat(VelNorth, 136);
        String _VelVertical = this.InterpretFloat(VelVertical, 138);
        String _VelVal = this.InterpretIntegerAsInt(VelVal);
        String _VelWT = this.InterpretFloat(VelWT);
        String _WTVal = this.InterpretIntegerAsInt(WTVal);
        String _OCNorth = this.InterpretFloat(OCNorth);
        String _OCEast = this.InterpretFloat(OCEast);
        String _IVelNorth = this.InterpretDouble(IVelNorth, 144);
        String _IVelEast = this.InterpretDouble(IVelEast, 145);
        String _Head = this.InterpretFloat(Head, 103);
        String _Pitch = this.InterpretFloat(Pitch, 105);
        String _Roll = this.InterpretFloat(Roll, 104);
        String _HeadRate = this.InterpretFloat(HeadRate, 110);
        String _PitchRate = this.InterpretFloat(PitchRate, 112);
        String _RollRate = this.InterpretFloat(RollRate, 111);
        String _HPRVal = this.InterpretIntegerAsInt(HPRVal);
        String _SensorDepth = this.InterpretFloat(SensorDepth);
        String _SensorDepthVal = this.InterpretIntegerAsInt(SensorDepthVal);
        String _INSDepth = this.InterpretFloat(INSDepth, 246);
        String _INSDepthVal = this.InterpretIntegerAsInt(INSDepthVal);
        String _HeadStd = this.InterpretFloat(HeadStd, 107);
        String _PitchStd = this.InterpretFloat(PitchStd, 109);
        String _RollStd = this.InterpretFloat(RollStd, 108);
        String _HPRStdVal = this.InterpretIntegerAsInt(HPRStdVal);
        String _VelEastStd = this.InterpretFloat(VelEastStd, 142);
        String _VelNorthStd = this.InterpretFloat(VelNorthStd, 141);
        String _VelVerticalStd = this.InterpretFloat(VelVerticalStd, 143);
        String _VelStdVal = this.InterpretIntegerAsInt(VelStdVal);
        String _LatStd = this.InterpretFloat(LatStd, 129);
        String _LongStd = this.InterpretFloat(LongStd, 130);
        String _PosStdVal = this.InterpretIntegerAsInt(PosStdVal);
        String _INSDepthStd = this.InterpretFloat(INSDepthStd, 247);
        String _INSDepthStdVal = this.InterpretIntegerAsInt(INSDepthStdVal);
        String _PolLat = this.InterpretFloat(PolLat, 127);
        String _PolLong = this.InterpretFloat(PolLong, 128);
        String _PolPosVal = this.InterpretIntegerAsInt(PolPosVal);
        String _PolHead = this.InterpretFloat(PolHead, 106);
        String _PolHeadVal = this.InterpretIntegerAsInt(PolHeadVal);
        String _UsrStatus = this.InterpretIntegerAsHex(UsrStatus);
        String _PolHeadrate = this.InterpretFloat(PolarHeadRate, 113);
        String _PolHeadRateVal = this.InterpretIntegerAsInt(PolarHeadRateVal);
        String _PolarVelEast = this.InterpretFloat(PolarVelEast, 140);
        String _PolarVelNorth = this.InterpretFloat(PolarVelNorth, 139);
        String _PolarVelVal = this.InterpretIntegerAsInt(PolarVelVal);
        this.InterpretedFrame = _TRCounter + _InsID + _TimeVAL + _Context + _TimeTR + _TimeSM + _AlignStatus + _TimeLF + _SourceLF + _Lat + _Long + _PosVal + _VelEast + _VelNorth + _VelVertical + _VelVal + _VelWT + _WTVal + _OCNorth + _OCEast + _IVelNorth + _IVelEast + _Head + _Pitch + _Roll + _HeadRate + _PitchRate + _RollRate + _HPRVal + _SensorDepth + _SensorDepthVal + _INSDepth + _INSDepthVal + _HeadStd + _PitchStd + _RollStd + _HPRStdVal + _VelEastStd + _VelNorthStd + _VelVerticalStd + _VelStdVal + _LatStd + _LongStd + _PosStdVal + _INSDepthStd + _INSDepthStdVal + _PolLat + _PolLong + _PolPosVal + _PolHead + _PolHeadVal + _UsrStatus + _PolHeadrate + _PolHeadRateVal + _PolarVelEast + _PolarVelNorth + _PolarVelVal;
        this.InterpretedFrame_AddToList(this.InterpretedFrame);
        System.out.println(this.InterpretedFrame);
        if (this.GetCurvePlotImplementation()) {
            this.Encod.setValue(701, TRCounter, 100);
            this.Encod.setValue(702, InsID, 1000);
            this.Encod.setValue(102, TimeVAL, 31);
            this.Encod.setValue(1004, Context, 1000);
            this.Encod.setValue(704, TimeTR, 31);
            this.Encod.setValue(100, TimeSM, 31);
            this.Encod.setValue(1003, AlignStatus, 1000);
            this.Encod.setValue(705, TimeLF, 31);
            this.Encod.setValue(706, SourceLF, 1000);
            this.Encod.setValue(124, Lat, 1);
            this.Encod.setValue(125, Long2, 1);
            this.Encod.setValue(1005, PosVal, 1000);
            this.Encod.setValue(137, Float.valueOf(VelEast), 21);
            this.Encod.setValue(136, Float.valueOf(VelNorth), 21);
            this.Encod.setValue(138, Float.valueOf(VelVertical), 21);
            this.Encod.setValue(1006, VelVal, 1000);
            this.Encod.setValue(241, Float.valueOf(VelWT), 21);
            this.Encod.setValue(1007, WTVal, 1000);
            this.Encod.setValue(250, Float.valueOf(OCNorth), 21);
            this.Encod.setValue(251, Float.valueOf(OCEast), 21);
            this.Encod.setValue(144, IVelNorth, 21);
            this.Encod.setValue(145, IVelEast, 21);
            this.Encod.setValue(103, Float.valueOf(Head), 1);
            this.Encod.setValue(105, Float.valueOf(-Pitch), 1);
            this.Encod.setValue(104, Float.valueOf(Roll), 1);
            this.Encod.setValue(110, Float.valueOf(Head), 1);
            this.Encod.setValue(112, Float.valueOf(-Pitch), 1);
            this.Encod.setValue(111, Float.valueOf(Roll), 1);
            this.Encod.setValue(1008, HPRVal, 1000);
            this.Encod.setValue(246, Float.valueOf(SensorDepth), 11);
            this.Encod.setValue(1009, SensorDepthVal, 1000);
            this.Encod.setValue(126, Float.valueOf(-INSDepth), 11);
            this.Encod.setValue(1010, INSDepthVal, 1000);
            this.Encod.setValue(107, Float.valueOf(HeadStd), 1);
            this.Encod.setValue(109, Float.valueOf(PitchStd), 1);
            this.Encod.setValue(108, Float.valueOf(RollStd), 1);
            this.Encod.setValue(1011, HPRStdVal, 1000);
            this.Encod.setValue(142, Float.valueOf(VelEastStd), 21);
            this.Encod.setValue(141, Float.valueOf(VelNorthStd), 21);
            this.Encod.setValue(143, Float.valueOf(VelVerticalStd), 21);
            this.Encod.setValue(1012, VelStdVal, 1000);
            this.Encod.setValue(129, Float.valueOf(LatStd), 11);
            this.Encod.setValue(130, Float.valueOf(LongStd), 11);
            this.Encod.setValue(1013, PosStdVal, 1000);
            this.Encod.setValue(131, Float.valueOf(INSDepthStd), 11);
            this.Encod.setValue(1014, PosStdVal, 1000);
            this.Encod.setValue(127, Float.valueOf(PolLat), 1);
            this.Encod.setValue(128, Float.valueOf(PolLong), 1);
            this.Encod.setValue(1015, PolPosVal, 1000);
            this.Encod.setValue(106, Float.valueOf(PolHead), 1);
            this.Encod.setValue(1016, PolHeadVal, 1000);
            this.Encod.setValue(113, Float.valueOf(PolarHeadRate), 1);
            this.Encod.setValue(1017, PolHeadVal, 1000);
            this.Encod.setValue(140, Float.valueOf(PolarVelEast), 21);
            this.Encod.setValue(139, Float.valueOf(PolarVelNorth), 21);
            this.Encod.setValue(1018, PolarVelVal, 1000);
            this.Encod.setValue(610, UsrStatus, 1000);
        }
        LoggerDecoderFrame.FrameReady = true;
        return 0;
    }
}

