/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.DecoderFIFO;
import LoggerDecoder.Encoder;
import Protocols.ImuBlk_Item;
import java.util.ArrayList;

public class POSTPROCESSING_Decoder
extends Decoder {
    private ArrayList ImuBlk_ItemList = new ArrayList();
    private int Nb_ImuBlk_Decoded = 0;
    private int Save_Nb_ImuBlk_Decoded = 0;
    int KeyBlk_KeyId_Prec = 0;
    long Fog1Rot_Key_Prec;
    long Fog2Rot_Key_Prec;
    long Fog3Rot_Key_Prec;
    long Acc1Speed_Key_Prec;
    long Acc2Speed_Key_Prec;
    long Acc3Speed_Key_Prec;
    public static final int HEADER_BYTE = 36;
    public static final int MAXNB_FRAMES_IMU = 12000;
    public static final int BT_BLOCK_IDENT = 1;
    public static final int GPS1_BLOCK_IDENT = 2;
    public static final int DEPTH_BLOCK_IDENT = 3;
    public static final int USBL_BLOCK_IDENT = 4;
    public static final int UTC_BLOCK_IDENT = 5;
    public static final int WT_BLOCK_IDENT = 6;
    public static final int GPS2_BLOCK_IDENT = 7;
    public static final int LBL_BLOCK_IDENT = 8;
    public static final int LOGEM_BLOCK_IDENT = 9;
    public static final int GPSM_BLOCK_IDENT = 13;
    public static final int EVM_BLOCK_IDENT = 15;
    public static final int TEM_BLOCK_IDENT = 16;
    public static final int IMU2_BLOCK_IDENT = 17;
    public static final int NAV_BLOCK_IDENT = 18;
    public static final int KAL_BLOCK_IDENT = 19;
    public static final int CNF_BLOCK_IDENT = 20;
    public static final int PLATT_BLOCK_IDENT = 21;
    public static final int KEY_BLOCK_IDENT = 22;
    public static final int STA_BLOCK_IDENT = 23;
    public static final int DMI_BLOCK_IDENT = 24;
    public static final int DOV_BLOCK_IDENT = 35;
    public static final int HEXAPOD_BLOCK_IDENT = 36;
    public static final int MANS_BLOCK_IDENT = 37;
    public static final int LOGB_BLOCK_IDENT = 38;
    public static final int IMU2_BLOCK_VERSION = 32;
    public static final int KEY_BLOCK_VERSION = 16;
    public static final int NAV_BLOCK_VERSION = 32;
    public static final int KAL_BLOCK_VERSION_10 = 16;
    public static final int KAL_BLOCK_VERSION_11 = 17;
    public static final int CNF_BLOCK_VERSION = 16;
    public static final int TEM_BLOCK_VERSION = 17;
    public static final int BT_BLOCK_VERSION = 18;
    public static final int GPS_BLOCK_VERSION = 21;
    public static final int DEPTH_BLOCK_VERSION = 19;
    public static final int USBL_BLOCK_VERSION = 20;
    public static final int UTC_BLOCK_VERSION = 19;
    public static final int WT_BLOCK_VERSION = 18;
    public static final int LBL_BLOCK_VERSION = 19;
    public static final int LOGEM_BLOCK_VERSION = 18;
    public static final int EVM_BLOCK_VERSION = 17;
    public static final int PLATT_BLOCK_VERSION = 16;
    public static final int DOV_BLOCK_VERSION = 16;
    public static final int STA_BLOCK_VERSION = 16;
    public static final int DMI_BLOCK_VERSION = 16;
    public static final int HEXAPOD_BLOCK_VERSION = 16;
    public static final int MANS_BLOCK_VERSION = 16;
    public static final int LOGB_BLOCK_VERSION = 16;
    public static final int CNF_BLOCK_LENGTH_8BYTES = 8;
    public static final int CNF_BLOCK_LENGTH_9BYTES = 9;
    public static final int CNF_BLOCK_LENGTH_11BYTES = 11;
    public static final int CNF_BLOCK_LENGTH_12BYTES = 12;
    public static final int CNF_BLOCK_LENGTH_14BYTES = 14;
    public static final int CNF_BLOCK_LENGTH_15BYTES = 15;
    public static final int CNF_BLOCK_LENGTH_19BYTES = 19;
    public static final int CNF_BLOCK_LENGTH_23BYTES = 23;
    public static final int CNF_BLOCK_LENGTH_33BYTES = 33;
    public static final int CONF_IDENT_IDORIENT = 0;
    public static final int CONF_IDENT_MESACRT = 1;
    public static final int CONF_IDENT_BLV0 = 2;
    public static final int CONF_IDENT_BLV1 = 3;
    public static final int CONF_IDENT_BLV2 = 4;
    public static final int CONF_IDENT_BLV3 = 5;
    public static final int CONF_IDENT_COG = 6;
    public static final int CONF_IDENT_GPS1_BLV = 7;
    public static final int CONF_IDENT_GPS2_BLV = 8;
    public static final int CONF_IDENT_GPSM_BLV = 9;
    public static final int CONF_IDENT_USBL1_BLV = 10;
    public static final int CONF_IDENT_USBL2_BLV = 11;
    public static final int CONF_IDENT_USBL3_BLV = 12;
    public static final int CONF_IDENT_LBL_BLV = 13;
    public static final int CONF_IDENT_DVL1_BLV = 14;
    public static final int CONF_IDENT_DVL1_MESACRT = 15;
    public static final int CONF_IDENT_DVL1_FE = 16;
    public static final int CONF_IDENT_DEPTH_BLV = 17;
    public static final int CONF_IDENT_EMLOG1_BLV = 18;
    public static final int CONF_IDENT_EMLOG2_BLV = 19;
    public static final int CONF_IDENT_USBL1_TPNAME = 20;
    public static final int CONF_IDENT_USBL2_TPNAME = 21;
    public static final int CONF_IDENT_USBL3_TPNAME = 22;
    public static final int CONF_IDENT_DVLPRMCOURANT = 23;
    public static final int CONF_IDENT_POSMAN = 24;
    public static final int CONF_IDENT_MODFCT_START = 25;
    public static final int CONF_IDENT_MODFCT_ZUP = 26;
    public static final int CONF_IDENT_MODFCT_ALTI = 27;
    public static final int CONF_IDENT_HEAVE_MODE = 28;
    public static final int CONF_IDENT_SYSTEM_GEN = 29;
    public static final int CONF_IDENT_ALGO_CNF = 30;
    public static final int CONF_IDENT_SN_NUMBER = 31;
    public static final int CONF_IDENT_CDSPFRM_VER = 32;
    public static final int CONF_IDENT_CINTFRM_VER = 33;
    public static final int CONF_IDENT_ALGSIM_VER = 34;
    public static final int CONF_IDENT_DPSETTINGS = 35;
    public static final int CONF_IDENT_ODO_BLV = 36;
    public static final int CONF_IDENT_ODO_MESACRT = 37;
    public static final int CONF_IDENT_ODO_FE = 38;
    public static final int CONF_IDENT_EMBEDDED_GPS = 39;
    public static final int CONF_IDENT_MODFCT_SYST = 40;
    public static final int CONF_IDENT_DPSETTINGS2 = 41;
    public static final int CONF_IDENT_TIMESYNCMODE = 42;
    DecoderFIFO FIFO;

    public POSTPROCESSING_Decoder(Encoder Encod) {
        this.SetCurvePlotImplementation(false);
        this.SetMaximumFramesNumber(12000);
        this.FIFO = new DecoderFIFO(6500);
        byte[] Start2 = new byte[]{36};
        this.DecodeInit(0, 0, Start2, 1, 1, 0, 1);
    }

    @Override
    public void ReInitialize_SpecificParameters() {
        this.ImuBlk_ItemList.clear();
        this.Nb_ImuBlk_Decoded = 0;
        this.Save_Nb_ImuBlk_Decoded = 0;
    }

    @Override
    public String GetFileHeading() {
        if (this.Info.GetFlowType() == 1) {
            String sep = "\t";
            return "\r";
        }
        return " ";
    }

    @Override
    public int InterpretFrame(byte[] Detected_Frame, int Lenght) {
        byte[] PopTelegramList = new byte[1024];
        this.FIFO.FIFO_Push(this.Bytes_Frame, Lenght);
        PopTelegramList = this.FIFO.FIFO_Pop();
        this.ProcessDetectedTelegram(PopTelegramList, Lenght);
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int ProcessDetectedTelegram(byte[] Detected_Frame, int Length) {
        block79: {
            int BlocStart;
            block99: {
                block108: {
                    block107: {
                        block106: {
                            block105: {
                                block104: {
                                    block103: {
                                        block102: {
                                            block101: {
                                                block100: {
                                                    block98: {
                                                        block97: {
                                                            block96: {
                                                                block95: {
                                                                    block94: {
                                                                        block93: {
                                                                            block92: {
                                                                                block91: {
                                                                                    block90: {
                                                                                        block89: {
                                                                                            block88: {
                                                                                                block87: {
                                                                                                    block86: {
                                                                                                        block85: {
                                                                                                            block84: {
                                                                                                                block83: {
                                                                                                                    block82: {
                                                                                                                        block81: {
                                                                                                                            block80: {
                                                                                                                                BlocStart = 0;
                                                                                                                                if (!this.IsChecksumValid(Detected_Frame, BlocStart, Length)) {
                                                                                                                                    return 0;
                                                                                                                                }
                                                                                                                                if (Detected_Frame[BlocStart + 2] == 22) {
                                                                                                                                    if (Detected_Frame[BlocStart + 3] != 16) {
                                                                                                                                        this.InterpretedFrame = "KEY___: Decoding is not intended for the version 0x" + Integer.toHexString(Detected_Frame[BlocStart + 3]);
                                                                                                                                    } else {
                                                                                                                                        int KeyBlk_KeyId = this.Convert_1Byte_to_UnsignedInt(Detected_Frame, BlocStart + 4, 1);
                                                                                                                                        long Fog1Rot_Key = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 5, 1);
                                                                                                                                        long Fog2Rot_Key = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 9, 1);
                                                                                                                                        long Fog3Rot_Key = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 13, 1);
                                                                                                                                        long Acc1Speed_Key = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 17, 1);
                                                                                                                                        long Acc2Speed_Key = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 21, 1);
                                                                                                                                        long Acc3Speed_Key = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 25, 1);
                                                                                                                                        if (KeyBlk_KeyId != this.KeyBlk_KeyId_Prec) {
                                                                                                                                            this.Fog1Rot_Key_Prec = Fog1Rot_Key;
                                                                                                                                            this.Fog2Rot_Key_Prec = Fog2Rot_Key;
                                                                                                                                            this.Fog3Rot_Key_Prec = Fog3Rot_Key;
                                                                                                                                            this.Acc1Speed_Key_Prec = Acc1Speed_Key;
                                                                                                                                            this.Acc2Speed_Key_Prec = Acc2Speed_Key;
                                                                                                                                            this.Acc3Speed_Key_Prec = Acc3Speed_Key;
                                                                                                                                            this.KeyBlk_KeyId_Prec = KeyBlk_KeyId;
                                                                                                                                        } else if (this.Fog1Rot_Key_Prec != Fog1Rot_Key || this.Fog2Rot_Key_Prec != Fog2Rot_Key || this.Fog3Rot_Key_Prec != Fog3Rot_Key || this.Acc1Speed_Key_Prec != Acc1Speed_Key || this.Acc2Speed_Key_Prec != Acc2Speed_Key || this.Acc3Speed_Key_Prec != Acc3Speed_Key) {
                                                                                                                                            System.out.println("Bad Key Repetition: " + KeyBlk_KeyId + "\n" + this.Fog1Rot_Key_Prec + " " + this.Fog2Rot_Key_Prec + " " + this.Fog3Rot_Key_Prec + " " + this.Acc1Speed_Key_Prec + " " + this.Acc2Speed_Key_Prec + " " + this.Acc2Speed_Key_Prec + "\n" + Fog1Rot_Key + " " + Fog2Rot_Key + " " + Fog3Rot_Key + " " + Acc1Speed_Key + " " + Acc2Speed_Key + " " + Acc2Speed_Key + " ");
                                                                                                                                        }
                                                                                                                                        for (int N = 0; N < this.ImuBlk_ItemList.size(); ++N) {
                                                                                                                                            Object o = this.ImuBlk_ItemList.get(N);
                                                                                                                                            ImuBlk_Item BlkItem = (ImuBlk_Item)o;
                                                                                                                                            if (KeyBlk_KeyId != BlkItem.KeyId) continue;
                                                                                                                                            BlkItem.cXorFields[0] = (byte)(BlkItem.cXorFields[0] ^ (byte)(Fog1Rot_Key & 0xFFL));
                                                                                                                                            BlkItem.cXorFields[1] = (byte)(BlkItem.cXorFields[1] ^ (byte)(Fog1Rot_Key >> 8 & 0xFFL));
                                                                                                                                            BlkItem.cXorFields[2] = (byte)(BlkItem.cXorFields[2] ^ (byte)(Fog1Rot_Key >> 16 & 0xFFL));
                                                                                                                                            BlkItem.cXorFields[3] = (byte)(BlkItem.cXorFields[3] ^ (byte)(Fog1Rot_Key >> 24 & 0xFFL));
                                                                                                                                            BlkItem.cXorFields[4] = (byte)(BlkItem.cXorFields[4] ^ (byte)(Fog2Rot_Key & 0xFFL));
                                                                                                                                            BlkItem.cXorFields[5] = (byte)(BlkItem.cXorFields[5] ^ (byte)(Fog2Rot_Key >> 8 & 0xFFL));
                                                                                                                                            BlkItem.cXorFields[6] = (byte)(BlkItem.cXorFields[6] ^ (byte)(Fog2Rot_Key >> 16 & 0xFFL));
                                                                                                                                            BlkItem.cXorFields[7] = (byte)(BlkItem.cXorFields[7] ^ (byte)(Fog2Rot_Key >> 24 & 0xFFL));
                                                                                                                                            BlkItem.cXorFields[8] = (byte)(BlkItem.cXorFields[8] ^ (byte)(Fog3Rot_Key & 0xFFL));
                                                                                                                                            BlkItem.cXorFields[9] = (byte)(BlkItem.cXorFields[9] ^ (byte)(Fog3Rot_Key >> 8 & 0xFFL));
                                                                                                                                            BlkItem.cXorFields[10] = (byte)(BlkItem.cXorFields[10] ^ (byte)(Fog3Rot_Key >> 16 & 0xFFL));
                                                                                                                                            BlkItem.cXorFields[11] = (byte)(BlkItem.cXorFields[11] ^ (byte)(Fog3Rot_Key >> 24 & 0xFFL));
                                                                                                                                            BlkItem.cXorFields[12] = (byte)(BlkItem.cXorFields[12] ^ (byte)(Acc1Speed_Key & 0xFFL));
                                                                                                                                            BlkItem.cXorFields[13] = (byte)(BlkItem.cXorFields[13] ^ (byte)(Acc1Speed_Key >> 8 & 0xFFL));
                                                                                                                                            BlkItem.cXorFields[14] = (byte)(BlkItem.cXorFields[14] ^ (byte)(Acc1Speed_Key >> 16 & 0xFFL));
                                                                                                                                            BlkItem.cXorFields[15] = (byte)(BlkItem.cXorFields[15] ^ (byte)(Acc1Speed_Key >> 24 & 0xFFL));
                                                                                                                                            BlkItem.cXorFields[16] = (byte)(BlkItem.cXorFields[16] ^ (byte)(Acc2Speed_Key & 0xFFL));
                                                                                                                                            BlkItem.cXorFields[17] = (byte)(BlkItem.cXorFields[17] ^ (byte)(Acc2Speed_Key >> 8 & 0xFFL));
                                                                                                                                            BlkItem.cXorFields[18] = (byte)(BlkItem.cXorFields[18] ^ (byte)(Acc2Speed_Key >> 16 & 0xFFL));
                                                                                                                                            BlkItem.cXorFields[19] = (byte)(BlkItem.cXorFields[19] ^ (byte)(Acc2Speed_Key >> 24 & 0xFFL));
                                                                                                                                            BlkItem.cXorFields[20] = (byte)(BlkItem.cXorFields[20] ^ (byte)(Acc3Speed_Key & 0xFFL));
                                                                                                                                            BlkItem.cXorFields[21] = (byte)(BlkItem.cXorFields[21] ^ (byte)(Acc3Speed_Key >> 8 & 0xFFL));
                                                                                                                                            BlkItem.cXorFields[22] = (byte)(BlkItem.cXorFields[22] ^ (byte)(Acc3Speed_Key >> 16 & 0xFFL));
                                                                                                                                            BlkItem.cXorFields[23] = (byte)(BlkItem.cXorFields[23] ^ (byte)(Acc3Speed_Key >> 24 & 0xFFL));
                                                                                                                                            BlkItem.Fog1Rot = this.Convert_4Bytes_to_Float(BlkItem.cXorFields, 0, 1);
                                                                                                                                            BlkItem.Fog2Rot = this.Convert_4Bytes_to_Float(BlkItem.cXorFields, 4, 1);
                                                                                                                                            BlkItem.Fog3Rot = this.Convert_4Bytes_to_Float(BlkItem.cXorFields, 8, 1);
                                                                                                                                            BlkItem.Acc1Speed = this.Convert_4Bytes_to_Float(BlkItem.cXorFields, 12, 1);
                                                                                                                                            BlkItem.Acc2Speed = this.Convert_4Bytes_to_Float(BlkItem.cXorFields, 16, 1);
                                                                                                                                            BlkItem.Acc3Speed = this.Convert_4Bytes_to_Float(BlkItem.cXorFields, 20, 1);
                                                                                                                                            this.InterpretedFrame = this.FormatImu2DecodedLine(BlkItem);
                                                                                                                                            this.InterpretedFrame_AddToList(this.InterpretedFrame);
                                                                                                                                            ++this.Nb_ImuBlk_Decoded;
                                                                                                                                        }
                                                                                                                                        this.Save_Nb_ImuBlk_Decoded = this.Nb_ImuBlk_Decoded;
                                                                                                                                        if (this.Nb_ImuBlk_Decoded != 0 && this.Nb_ImuBlk_Decoded == this.ImuBlk_ItemList.size()) {
                                                                                                                                            this.ImuBlk_ItemList.clear();
                                                                                                                                            this.Nb_ImuBlk_Decoded = 0;
                                                                                                                                            this.GetInterpretedFrameNb();
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                    System.out.println("Decoding... [" + Integer.toString(this.Save_Nb_ImuBlk_Decoded) + "][" + Integer.toString(this.ImuBlk_ItemList.size()) + "]");
                                                                                                                                    return 0;
                                                                                                                                }
                                                                                                                                if (Detected_Frame[BlocStart + 2] == 17) {
                                                                                                                                    if (Detected_Frame[BlocStart + 3] != 32) {
                                                                                                                                        this.InterpretedFrame = "IMU2___: Decoding is not intended for the version 0x" + Integer.toHexString(Detected_Frame[BlocStart + 3]);
                                                                                                                                        break block79;
                                                                                                                                    } else {
                                                                                                                                        if (this.ImuBlk_ItemList.size() > 12000) {
                                                                                                                                            this.ImuBlk_ItemList.clear();
                                                                                                                                        }
                                                                                                                                        ImuBlk_Item imublk_item = new ImuBlk_Item(Detected_Frame, BlocStart);
                                                                                                                                        this.ImuBlk_ItemList.add(imublk_item);
                                                                                                                                        return 0;
                                                                                                                                    }
                                                                                                                                }
                                                                                                                                if (Detected_Frame[BlocStart + 2] != 18) break block80;
                                                                                                                                if (Detected_Frame[BlocStart + 3] != 32) {
                                                                                                                                    this.InterpretedFrame = "NAV___: Decoding is not intended for the version 0x" + Integer.toHexString(Detected_Frame[BlocStart + 3]);
                                                                                                                                    break block79;
                                                                                                                                } else {
                                                                                                                                    double Time = (double)this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 4, 1) * 1.0E-4;
                                                                                                                                    int dec = 0;
                                                                                                                                    double Heading = (double)this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 8 + dec, 1) * 1.4629180792671596E-9;
                                                                                                                                    double Roll = (double)this.Convert_4Bytes_to_SignedInt(Detected_Frame, BlocStart + 12 + dec, 1) * 1.4629180792671596E-9;
                                                                                                                                    double Pitch = (double)this.Convert_4Bytes_to_SignedInt(Detected_Frame, BlocStart + 16 + dec, 1) * 1.4629180792671596E-9;
                                                                                                                                    double Lat = this.Convert_8Bytes_to_Double(Detected_Frame, BlocStart + 20 + dec, 1);
                                                                                                                                    double Long2 = this.Convert_8Bytes_to_Double(Detected_Frame, BlocStart + 28 + dec, 1);
                                                                                                                                    float Altitude = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 36 + dec, 1);
                                                                                                                                    float NSpeed = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 40 + dec, 1);
                                                                                                                                    float ESpeed = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 44 + dec, 1);
                                                                                                                                    float VSpeed = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 48 + dec, 1);
                                                                                                                                    float Heave = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 52 + dec, 1);
                                                                                                                                    float Surge = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 56 + dec, 1);
                                                                                                                                    float Sway = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 60 + dec, 1);
                                                                                                                                    this.InterpretedFrame = "NAV___:";
                                                                                                                                    this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(17);
                                                                                                                                    this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex(0);
                                                                                                                                    this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex(0);
                                                                                                                                    this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex(0);
                                                                                                                                    this.InterpretedFrame = this.InterpretedFrame + "|";
                                                                                                                                    this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Heading * 57.29577951308232, 8);
                                                                                                                                    this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Roll * 57.29577951308232, 8);
                                                                                                                                    this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Pitch * 57.29577951308232, 8);
                                                                                                                                    this.InterpretedFrame = this.InterpretedFrame + "|";
                                                                                                                                    this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Lat * 57.29577951308232, 8);
                                                                                                                                    this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Long2 * 57.29577951308232, 8);
                                                                                                                                    this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Altitude, 6);
                                                                                                                                    this.InterpretedFrame = this.InterpretedFrame + "|";
                                                                                                                                    this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(NSpeed, 6);
                                                                                                                                    this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(ESpeed, 6);
                                                                                                                                    this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(VSpeed, 6);
                                                                                                                                    this.InterpretedFrame = this.InterpretedFrame + "|";
                                                                                                                                    this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Time, 8);
                                                                                                                                }
                                                                                                                                break block79;
                                                                                                                            }
                                                                                                                            if (Detected_Frame[BlocStart + 2] != 2 && Detected_Frame[BlocStart + 2] != 7 && Detected_Frame[BlocStart + 2] != 13) break block81;
                                                                                                                            if (Detected_Frame[BlocStart + 3] != 21) {
                                                                                                                                if (Detected_Frame[BlocStart + 2] == 2) {
                                                                                                                                    this.InterpretedFrame = "GPS1__: Decoding is not intended for the version 0x" + Integer.toHexString(Detected_Frame[BlocStart + 3]);
                                                                                                                                }
                                                                                                                                if (Detected_Frame[BlocStart + 2] == 7) {
                                                                                                                                    this.InterpretedFrame = "GPS2__: Decoding is not intended for the version 0x" + Integer.toHexString(Detected_Frame[BlocStart + 3]);
                                                                                                                                }
                                                                                                                                if (Detected_Frame[BlocStart + 2] == 13) {
                                                                                                                                    this.InterpretedFrame = "GPSM__: Decoding is not intended for the version 0x" + Integer.toHexString(Detected_Frame[BlocStart + 3]);
                                                                                                                                }
                                                                                                                                break block79;
                                                                                                                            } else {
                                                                                                                                double Time = (double)this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 4, 1) * 1.0E-4;
                                                                                                                                byte Quality = Detected_Frame[BlocStart + 8];
                                                                                                                                double Lat = this.Convert_8Bytes_to_Double(Detected_Frame, BlocStart + 9, 1);
                                                                                                                                double Long3 = this.Convert_8Bytes_to_Double(Detected_Frame, BlocStart + 17, 1);
                                                                                                                                float Altitude = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 25, 1);
                                                                                                                                float NStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 29, 1);
                                                                                                                                float EStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 33, 1);
                                                                                                                                float VStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 37, 1);
                                                                                                                                byte RejMode = Detected_Frame[BlocStart + 41];
                                                                                                                                float CovLatLong = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 42, 1);
                                                                                                                                float Latency = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 46, 1);
                                                                                                                                float GeoidalSep = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 50, 1);
                                                                                                                                if (Detected_Frame[BlocStart + 2] == 2) {
                                                                                                                                    this.InterpretedFrame = "GPS___:";
                                                                                                                                }
                                                                                                                                if (Detected_Frame[BlocStart + 2] == 7) {
                                                                                                                                    this.InterpretedFrame = "GPS2__:";
                                                                                                                                }
                                                                                                                                if (Detected_Frame[BlocStart + 2] == 13) {
                                                                                                                                    this.InterpretedFrame = "GPSM__:";
                                                                                                                                }
                                                                                                                                this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(20);
                                                                                                                                this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Lat * 57.29577951308232, 8);
                                                                                                                                this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Long3 * 57.29577951308232, 8);
                                                                                                                                this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Altitude, 6);
                                                                                                                                this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(Quality);
                                                                                                                                this.InterpretedFrame = this.InterpretedFrame + "|";
                                                                                                                                this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(NStd, 6);
                                                                                                                                this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(EStd, 6);
                                                                                                                                this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(VStd, 6);
                                                                                                                                this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(CovLatLong, 6);
                                                                                                                                this.InterpretedFrame = this.InterpretedFrame + "|";
                                                                                                                                this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex(RejMode);
                                                                                                                                this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Latency, 6);
                                                                                                                                this.InterpretedFrame = this.InterpretedFrame + "|";
                                                                                                                                this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(GeoidalSep, 6);
                                                                                                                                this.InterpretedFrame = this.InterpretedFrame + "|";
                                                                                                                                this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Time, 8);
                                                                                                                            }
                                                                                                                            break block79;
                                                                                                                        }
                                                                                                                        if (Detected_Frame[BlocStart + 2] != 8) break block82;
                                                                                                                        if (Detected_Frame[BlocStart + 3] != 19) {
                                                                                                                            this.InterpretedFrame = "LBL___: Decoding is not intended for the version 0x" + Integer.toHexString(Detected_Frame[BlocStart + 3]);
                                                                                                                            break block79;
                                                                                                                        } else {
                                                                                                                            double Time = (double)this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 4, 1) * 1.0E-4;
                                                                                                                            char[] TpCode = new char[8];
                                                                                                                            for (int i = 0; i < 8; ++i) {
                                                                                                                                TpCode[i] = (char)Detected_Frame[BlocStart + 8 + i];
                                                                                                                            }
                                                                                                                            double Lat = (double)this.Convert_4Bytes_to_SignedInt(Detected_Frame, BlocStart + 16, 1) * 1.4629180792671596E-9;
                                                                                                                            double Long4 = (double)this.Convert_4Bytes_to_SignedInt(Detected_Frame, BlocStart + 20, 1) * 1.4629180792671596E-9;
                                                                                                                            float Altitude = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 24, 1);
                                                                                                                            float Range = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 28, 1);
                                                                                                                            float Latency = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 32, 1);
                                                                                                                            float RangeStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 36, 1);
                                                                                                                            byte RejMode = Detected_Frame[BlocStart + 40];
                                                                                                                            this.InterpretedFrame = "LBL___: ";
                                                                                                                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Time, 8);
                                                                                                                            for (int i = 0; i < 8; ++i) {
                                                                                                                                if (TpCode[i] == '\u0000') continue;
                                                                                                                                this.InterpretedFrame = this.InterpretedFrame + TpCode[i];
                                                                                                                            }
                                                                                                                            this.InterpretedFrame = this.InterpretedFrame + this.Info.GetSeparator();
                                                                                                                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Lat, 8);
                                                                                                                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Long4, 8);
                                                                                                                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Altitude, 6);
                                                                                                                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Range, 6);
                                                                                                                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Latency, 6);
                                                                                                                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(RangeStd, 6);
                                                                                                                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(RejMode);
                                                                                                                        }
                                                                                                                        break block79;
                                                                                                                    }
                                                                                                                    if (Detected_Frame[BlocStart + 2] != 24) break block83;
                                                                                                                    if (Detected_Frame[BlocStart + 3] != 16) {
                                                                                                                        this.InterpretedFrame = "DMI___: Decoding is not intended for the version 0x" + Integer.toHexString(Detected_Frame[BlocStart + 3]);
                                                                                                                        break block79;
                                                                                                                    } else {
                                                                                                                        double Time = (double)this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 4, 1) * 1.0E-4;
                                                                                                                        double PulseCount = this.Convert_4Bytes_to_SignedInt(Detected_Frame, BlocStart + 8, 1);
                                                                                                                        long SamplingTime = this.Convert_4Bytes_to_SignedInt(Detected_Frame, BlocStart + 12, 1);
                                                                                                                        this.InterpretedFrame = "DMI___: ";
                                                                                                                        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Time, 8);
                                                                                                                        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(PulseCount, 8);
                                                                                                                        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(SamplingTime, 6);
                                                                                                                    }
                                                                                                                    break block79;
                                                                                                                }
                                                                                                                if (Detected_Frame[BlocStart + 2] != 16) break block84;
                                                                                                                if (Detected_Frame[BlocStart + 3] != 17) {
                                                                                                                    this.InterpretedFrame = "TEM___: Decoding is not intended for the version 0x" + Integer.toHexString(Detected_Frame[BlocStart + 3]);
                                                                                                                    break block79;
                                                                                                                } else {
                                                                                                                    double Time = (double)this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 4, 1) * 1.0E-4;
                                                                                                                    float TFog1 = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 8, 1);
                                                                                                                    TFog1 = this.Kelvin_To_DegCelsius(TFog1);
                                                                                                                    float TFog2 = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 12, 1);
                                                                                                                    TFog2 = this.Kelvin_To_DegCelsius(TFog2);
                                                                                                                    float TFog3 = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 16, 1);
                                                                                                                    TFog3 = this.Kelvin_To_DegCelsius(TFog3);
                                                                                                                    float TAcc1 = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 20, 1);
                                                                                                                    TAcc1 = this.Kelvin_To_DegCelsius(TAcc1);
                                                                                                                    float TAcc2 = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 24, 1);
                                                                                                                    TAcc2 = this.Kelvin_To_DegCelsius(TAcc2);
                                                                                                                    float TAcc3 = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 28, 1);
                                                                                                                    TAcc3 = this.Kelvin_To_DegCelsius(TAcc3);
                                                                                                                    float TSrc = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 32, 1);
                                                                                                                    TSrc = this.Kelvin_To_DegCelsius(TSrc);
                                                                                                                    float TAna = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 36, 1);
                                                                                                                    TAna = this.Kelvin_To_DegCelsius(TAna);
                                                                                                                    this.InterpretedFrame = "TEM___: ";
                                                                                                                    this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Time, 8);
                                                                                                                    this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(TFog1, 6);
                                                                                                                    this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(TFog2, 6);
                                                                                                                    this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(TFog3, 6);
                                                                                                                    this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(TAcc1, 6);
                                                                                                                    this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(TAcc2, 6);
                                                                                                                    this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(TAcc3, 6);
                                                                                                                    this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(TSrc, 6);
                                                                                                                    this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(TAna, 6);
                                                                                                                }
                                                                                                                break block79;
                                                                                                            }
                                                                                                            if (Detected_Frame[BlocStart + 2] != 36) break block85;
                                                                                                            if (Detected_Frame[BlocStart + 3] != 16) {
                                                                                                                this.InterpretedFrame = "HEX___: Decoding is not intended for the version 0x" + Integer.toHexString(Detected_Frame[BlocStart + 3]);
                                                                                                                break block79;
                                                                                                            } else {
                                                                                                                double Time = (double)this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 4, 1) * 1.0E-4;
                                                                                                                double TimeCounter = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 8, 1);
                                                                                                                float PosX = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 12, 1);
                                                                                                                float PosY = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 16, 1);
                                                                                                                float PosZ = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 20, 1);
                                                                                                                float OriX = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 24, 1);
                                                                                                                float OriY = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 28, 1);
                                                                                                                float OriZ = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 32, 1);
                                                                                                                double Status = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 36, 1);
                                                                                                                this.InterpretedFrame = "HEX___: ";
                                                                                                                this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Time, 8);
                                                                                                                this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(TimeCounter, 8);
                                                                                                                this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(PosX, 6);
                                                                                                                this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(PosY, 6);
                                                                                                                this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(PosZ, 6);
                                                                                                                this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(OriX, 6);
                                                                                                                this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(OriY, 6);
                                                                                                                this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(OriZ, 6);
                                                                                                                this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Status, 8);
                                                                                                            }
                                                                                                            break block79;
                                                                                                        }
                                                                                                        if (Detected_Frame[BlocStart + 2] != 19) break block86;
                                                                                                        if (Detected_Frame[BlocStart + 3] == 16 || Detected_Frame[BlocStart + 3] == 17) {
                                                                                                            float BiaisAccZStd;
                                                                                                            float BiaisAccZ;
                                                                                                            float BiaisAccYStd;
                                                                                                            float BiaisAccY;
                                                                                                            float BiaisAccXStd;
                                                                                                            float BiaisAccX;
                                                                                                            float BiaisFogZStd;
                                                                                                            float BiaisFogZ;
                                                                                                            float BiaisFogYStd;
                                                                                                            float BiaisFogY;
                                                                                                            float BiaisFogXStd;
                                                                                                            float BiaisFogX;
                                                                                                            float AltiStd;
                                                                                                            float LongiStd;
                                                                                                            float LatiStd;
                                                                                                            float PitchStd;
                                                                                                            float RollStd;
                                                                                                            float HeadingStd;
                                                                                                            double Time;
                                                                                                            if (Detected_Frame[BlocStart + 3] == 16) {
                                                                                                                Time = (double)this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 4, 1) * 1.0E-4;
                                                                                                                HeadingStd = (float)((double)this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 8, 1) * 1.0E-4);
                                                                                                                RollStd = (float)((double)this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 10, 1) * 1.0E-4);
                                                                                                                PitchStd = (float)((double)this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 12, 1) * 1.0E-4);
                                                                                                                LatiStd = (float)((double)this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 14, 1) * 0.01);
                                                                                                                LongiStd = (float)((double)this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 16, 1) * 0.01);
                                                                                                                AltiStd = (float)((double)this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 18, 1) * 0.01);
                                                                                                                BiaisFogX = (float)((double)this.Convert_2Bytes_to_SignedInt(Detected_Frame, BlocStart + 20, 1) * 1.0E-4);
                                                                                                                BiaisFogXStd = (float)((double)this.Convert_2Bytes_to_SignedInt(Detected_Frame, BlocStart + 22, 1) * 1.0E-4);
                                                                                                                BiaisFogY = (float)((double)this.Convert_2Bytes_to_SignedInt(Detected_Frame, BlocStart + 24, 1) * 1.0E-4);
                                                                                                                BiaisFogYStd = (float)((double)this.Convert_2Bytes_to_SignedInt(Detected_Frame, BlocStart + 26, 1) * 1.0E-4);
                                                                                                                BiaisFogZ = (float)((double)this.Convert_2Bytes_to_SignedInt(Detected_Frame, BlocStart + 28, 1) * 1.0E-4);
                                                                                                                BiaisFogZStd = (float)((double)this.Convert_2Bytes_to_SignedInt(Detected_Frame, BlocStart + 30, 1) * 1.0E-4);
                                                                                                                BiaisAccX = (float)((double)this.Convert_2Bytes_to_SignedInt(Detected_Frame, BlocStart + 32, 1) * 1.0E-5);
                                                                                                                BiaisAccXStd = (float)((double)this.Convert_2Bytes_to_SignedInt(Detected_Frame, BlocStart + 34, 1) * 1.0E-5);
                                                                                                                BiaisAccY = (float)((double)this.Convert_2Bytes_to_SignedInt(Detected_Frame, BlocStart + 36, 1) * 1.0E-5);
                                                                                                                BiaisAccYStd = (float)((double)this.Convert_2Bytes_to_SignedInt(Detected_Frame, BlocStart + 38, 1) * 1.0E-5);
                                                                                                                BiaisAccZ = (float)((double)this.Convert_2Bytes_to_SignedInt(Detected_Frame, BlocStart + 40, 1) * 1.0E-5);
                                                                                                                BiaisAccZStd = (float)((double)this.Convert_2Bytes_to_SignedInt(Detected_Frame, BlocStart + 42, 1) * 1.0E-5);
                                                                                                            } else {
                                                                                                                Time = (double)this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 4, 1) * 1.0E-4;
                                                                                                                HeadingStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 8, 1);
                                                                                                                RollStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 12, 1);
                                                                                                                PitchStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 16, 1);
                                                                                                                LatiStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 20, 1);
                                                                                                                LongiStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 24, 1);
                                                                                                                AltiStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 28, 1);
                                                                                                                BiaisFogX = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 32, 1);
                                                                                                                BiaisFogXStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 36, 1);
                                                                                                                BiaisFogY = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 40, 1);
                                                                                                                BiaisFogYStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 44, 1);
                                                                                                                BiaisFogZ = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 48, 1);
                                                                                                                BiaisFogZStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 52, 1);
                                                                                                                BiaisAccX = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 56, 1);
                                                                                                                BiaisAccXStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 60, 1);
                                                                                                                BiaisAccY = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 64, 1);
                                                                                                                BiaisAccYStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 68, 1);
                                                                                                                BiaisAccZ = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 72, 1);
                                                                                                                BiaisAccZStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 76, 1);
                                                                                                            }
                                                                                                            this.InterpretedFrame = "KAL___: ";
                                                                                                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Time, 8);
                                                                                                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(HeadingStd, 6);
                                                                                                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(RollStd, 6);
                                                                                                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(PitchStd, 6);
                                                                                                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(LatiStd, 6);
                                                                                                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(LongiStd, 6);
                                                                                                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(AltiStd, 6);
                                                                                                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(BiaisFogX, 6);
                                                                                                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(BiaisFogXStd, 6);
                                                                                                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(BiaisFogY, 6);
                                                                                                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(BiaisFogYStd, 6);
                                                                                                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(BiaisFogZ, 6);
                                                                                                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(BiaisFogZStd, 6);
                                                                                                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(BiaisAccX, 6);
                                                                                                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(BiaisAccXStd, 6);
                                                                                                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(BiaisAccY, 6);
                                                                                                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(BiaisAccYStd, 6);
                                                                                                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(BiaisAccZ, 6);
                                                                                                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(BiaisAccZStd, 6);
                                                                                                            break block79;
                                                                                                        } else {
                                                                                                            this.InterpretedFrame = "KAL___: Decoding is not intended for the version 0x" + Integer.toHexString(Detected_Frame[BlocStart + 3]);
                                                                                                        }
                                                                                                        break block79;
                                                                                                    }
                                                                                                    if (Detected_Frame[BlocStart + 2] != 1) break block87;
                                                                                                    if (Detected_Frame[BlocStart + 3] != 18) {
                                                                                                        this.InterpretedFrame = "BT____: Decoding is not intended for the version 0x" + Integer.toHexString(Detected_Frame[BlocStart + 3]);
                                                                                                        break block79;
                                                                                                    } else {
                                                                                                        double Time = (double)this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 4, 1) * 1.0E-4;
                                                                                                        float SpeedX = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 8, 1);
                                                                                                        float SpeedY = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 12, 1);
                                                                                                        float SpeedZ = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 16, 1);
                                                                                                        float DvlSos = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 20, 1);
                                                                                                        float ExtSos = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 24, 1);
                                                                                                        float DvlAlti = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 28, 1);
                                                                                                        float StdX = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 32, 1);
                                                                                                        float StdY = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 36, 1);
                                                                                                        float StdZ = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 40, 1);
                                                                                                        byte RejMode = Detected_Frame[BlocStart + 44];
                                                                                                        float Delay = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 45, 1);
                                                                                                        this.InterpretedFrame = "BT____: ";
                                                                                                        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Time, 8);
                                                                                                        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(SpeedX, 6);
                                                                                                        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(SpeedY, 6);
                                                                                                        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(SpeedZ, 6);
                                                                                                        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(DvlSos, 6);
                                                                                                        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(ExtSos, 6);
                                                                                                        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(DvlAlti, 6);
                                                                                                        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(StdX, 6);
                                                                                                        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(StdY, 6);
                                                                                                        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(StdZ, 6);
                                                                                                        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(RejMode);
                                                                                                        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Delay, 6);
                                                                                                    }
                                                                                                    break block79;
                                                                                                }
                                                                                                if (Detected_Frame[BlocStart + 2] != 6) break block88;
                                                                                                if (Detected_Frame[BlocStart + 3] != 18) {
                                                                                                    this.InterpretedFrame = "WT____: Decoding is not intended for the version 0x" + Integer.toHexString(Detected_Frame[BlocStart + 3]);
                                                                                                    break block79;
                                                                                                } else {
                                                                                                    double Time = (double)this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 4, 1) * 1.0E-4;
                                                                                                    float SpeedX = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 8, 1);
                                                                                                    float SpeedY = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 12, 1);
                                                                                                    float SpeedZ = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 16, 1);
                                                                                                    float DvlSos = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 20, 1);
                                                                                                    float ExtSos = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 24, 1);
                                                                                                    float DvlAlti = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 28, 1);
                                                                                                    float StdX = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 32, 1);
                                                                                                    float StdY = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 36, 1);
                                                                                                    float StdZ = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 40, 1);
                                                                                                    byte RejMode = Detected_Frame[BlocStart + 44];
                                                                                                    float Delay = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 45, 1);
                                                                                                    this.InterpretedFrame = "WT____: ";
                                                                                                    this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Time, 8);
                                                                                                    this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(SpeedX, 6);
                                                                                                    this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(SpeedY, 6);
                                                                                                    this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(SpeedZ, 6);
                                                                                                    this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(DvlSos, 6);
                                                                                                    this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(ExtSos, 6);
                                                                                                    this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(DvlAlti, 6);
                                                                                                    this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(StdX, 6);
                                                                                                    this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(StdY, 6);
                                                                                                    this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(StdZ, 6);
                                                                                                    this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(RejMode);
                                                                                                    this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Delay, 6);
                                                                                                }
                                                                                                break block79;
                                                                                            }
                                                                                            if (Detected_Frame[BlocStart + 2] != 3) break block89;
                                                                                            if (Detected_Frame[BlocStart + 3] != 19) {
                                                                                                this.InterpretedFrame = "DEPTH_: Decoding is not intended for the version 0x" + Integer.toHexString(Detected_Frame[BlocStart + 3]);
                                                                                                break block79;
                                                                                            } else {
                                                                                                double Time = (double)this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 4, 1) * 1.0E-4;
                                                                                                float Depth = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 8, 1);
                                                                                                float DepthStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 12, 1);
                                                                                                byte RejMode = Detected_Frame[BlocStart + 16];
                                                                                                float Delay = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 17, 1);
                                                                                                float Pressure = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 21, 1);
                                                                                                this.InterpretedFrame = "DEPTH_: ";
                                                                                                this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Time, 8);
                                                                                                this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Depth, 6);
                                                                                                this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(DepthStd, 6);
                                                                                                this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(RejMode);
                                                                                                this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Delay, 6);
                                                                                                this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Pressure, 6);
                                                                                            }
                                                                                            break block79;
                                                                                        }
                                                                                        if (Detected_Frame[BlocStart + 2] != 4) break block90;
                                                                                        if (Detected_Frame[BlocStart + 3] != 20) {
                                                                                            this.InterpretedFrame = "USBL__: Decoding is not intended for the version 0x" + Integer.toHexString(Detected_Frame[BlocStart + 3]);
                                                                                            break block79;
                                                                                        } else {
                                                                                            double Time = (double)this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 4, 1) * 1.0E-4;
                                                                                            byte Id = Detected_Frame[BlocStart + 8];
                                                                                            byte UsblMode = Detected_Frame[BlocStart + 9];
                                                                                            double Lat = (double)this.Convert_4Bytes_to_SignedInt(Detected_Frame, BlocStart + 10, 1) * 1.4629180792671596E-9;
                                                                                            double Long5 = (double)this.Convert_4Bytes_to_SignedInt(Detected_Frame, BlocStart + 14, 1) * 1.4629180792671596E-9;
                                                                                            float Delay = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 18, 1);
                                                                                            float Alt = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 22, 1);
                                                                                            float NorthStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 26, 1);
                                                                                            float EastStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 30, 1);
                                                                                            float LatLongCov = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 34, 1);
                                                                                            float AltStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 38, 1);
                                                                                            byte RejMode = Detected_Frame[BlocStart + 42];
                                                                                            this.InterpretedFrame = "USBL__: ";
                                                                                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Time, 8);
                                                                                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(Id);
                                                                                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(UsblMode);
                                                                                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Lat, 8);
                                                                                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Long5, 8);
                                                                                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Delay, 6);
                                                                                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Alt, 6);
                                                                                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(NorthStd, 6);
                                                                                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(EastStd, 6);
                                                                                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(LatLongCov, 6);
                                                                                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(AltStd, 6);
                                                                                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(RejMode);
                                                                                        }
                                                                                        break block79;
                                                                                    }
                                                                                    if (Detected_Frame[BlocStart + 2] != 5) break block91;
                                                                                    if (Detected_Frame[BlocStart + 3] != 19) {
                                                                                        this.InterpretedFrame = "UTC___:Decoding is not intended for the version 0x" + Integer.toHexString(Detected_Frame[BlocStart + 3]);
                                                                                        break block79;
                                                                                    } else {
                                                                                        double Time = (double)this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 4, 1) * 1.0E-4;
                                                                                        double UTCTime = (double)this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 8, 1) * 1.0E-4;
                                                                                        byte Day = Detected_Frame[BlocStart + 12];
                                                                                        byte Month = Detected_Frame[BlocStart + 13];
                                                                                        int Year = this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 14, 1);
                                                                                        this.InterpretedFrame = "UTC___:";
                                                                                        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(18);
                                                                                        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(UTCTime, 8);
                                                                                        this.InterpretedFrame = this.InterpretedFrame + "|";
                                                                                        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Time, 8);
                                                                                        this.InterpretedFrame = this.InterpretedFrame + "|";
                                                                                        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(Year);
                                                                                        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(Month);
                                                                                        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(Day);
                                                                                    }
                                                                                    break block79;
                                                                                }
                                                                                if (Detected_Frame[BlocStart + 2] != 15) break block92;
                                                                                if (Detected_Frame[BlocStart + 3] != 17) {
                                                                                    this.InterpretedFrame = "EVM___: Decoding is not intended for the version 0x" + Integer.toHexString(Detected_Frame[BlocStart + 3]);
                                                                                    break block79;
                                                                                } else {
                                                                                    double Time = (double)this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 4, 1) * 1.0E-4;
                                                                                    byte ID = Detected_Frame[BlocStart + 8];
                                                                                    double Counter = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 9, 1);
                                                                                    this.InterpretedFrame = "EVM___: ";
                                                                                    this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Time, 8);
                                                                                    this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(ID);
                                                                                    this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Counter);
                                                                                }
                                                                                break block79;
                                                                            }
                                                                            if (Detected_Frame[BlocStart + 2] != 35) break block93;
                                                                            if (Detected_Frame[BlocStart + 3] != 16) {
                                                                                this.InterpretedFrame = "DOV___: Decoding is not intended for the version 0x" + Integer.toHexString(Detected_Frame[BlocStart + 3]);
                                                                                break block79;
                                                                            } else {
                                                                                double Time = (double)this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 4, 1) * 1.0E-4;
                                                                                double Lati = this.Convert_8Bytes_to_Double(Detected_Frame, BlocStart + 8, 1);
                                                                                double Longi = this.Convert_8Bytes_to_Double(Detected_Frame, BlocStart + 16, 1);
                                                                                float ChiVert = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 24, 1);
                                                                                float EtaVert = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 28, 1);
                                                                                float GravAno = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 32, 1);
                                                                                this.InterpretedFrame = "DOV___: ";
                                                                                this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Time, 8);
                                                                                this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Lati, 8);
                                                                                this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Longi, 8);
                                                                                this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(ChiVert, 6);
                                                                                this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(EtaVert, 6);
                                                                                this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(GravAno, 6);
                                                                            }
                                                                            break block79;
                                                                        }
                                                                        if (Detected_Frame[BlocStart + 2] != 9) break block94;
                                                                        if (Detected_Frame[BlocStart + 3] != 18) {
                                                                            this.InterpretedFrame = "LOGEM_: Decoding is not intended for the version 0x" + Integer.toHexString(Detected_Frame[BlocStart + 3]);
                                                                            break block79;
                                                                        } else {
                                                                            double Time = (double)this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 4, 1) * 1.0E-4;
                                                                            byte Id = Detected_Frame[BlocStart + 8];
                                                                            float Speed = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 9, 1);
                                                                            float SpeedStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 13, 1);
                                                                            byte RejMode = Detected_Frame[BlocStart + 17];
                                                                            float Delay = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 18, 1);
                                                                            this.InterpretedFrame = "LOGEM_: ";
                                                                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Time, 8);
                                                                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(Id);
                                                                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Speed, 6);
                                                                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(SpeedStd, 6);
                                                                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(RejMode);
                                                                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Delay, 6);
                                                                        }
                                                                        break block79;
                                                                    }
                                                                    if (Detected_Frame[BlocStart + 2] != 21) break block95;
                                                                    if (Detected_Frame[BlocStart + 3] != 16) {
                                                                        this.InterpretedFrame = "PLATT_: Decoding is not intended for the version 0x" + Integer.toHexString(Detected_Frame[BlocStart + 3]);
                                                                        break block79;
                                                                    } else {
                                                                        double Time = (double)this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 4, 1) * 1.0E-4;
                                                                        double Roll = (double)this.Convert_4Bytes_to_SignedInt(Detected_Frame, BlocStart + 8, 1) * 1.4629180792671596E-9;
                                                                        double Pitch = (double)this.Convert_4Bytes_to_SignedInt(Detected_Frame, BlocStart + 12, 1) * 1.4629180792671596E-9;
                                                                        double Drift = (double)this.Convert_4Bytes_to_SignedInt(Detected_Frame, BlocStart + 16, 1) * 1.4629180792671596E-9;
                                                                        this.InterpretedFrame = "PLATT_: ";
                                                                        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Time, 8);
                                                                        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Roll, 8);
                                                                        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Pitch, 8);
                                                                        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Drift, 8);
                                                                    }
                                                                    break block79;
                                                                }
                                                                if (Detected_Frame[BlocStart + 2] != 23) break block96;
                                                                this.InterpretedFrame = Detected_Frame[BlocStart + 3] != 16 ? "STA___: Decoding is not intended for the version 0x" + Integer.toHexString(Detected_Frame[BlocStart + 3]) : "STA___: Decoding is not intended for the version 0x" + Integer.toHexString(Detected_Frame[BlocStart + 3]);
                                                                break block79;
                                                            }
                                                            if (Detected_Frame[BlocStart + 2] != 37) break block97;
                                                            this.InterpretedFrame = Detected_Frame[BlocStart + 3] != 16 ? "MANS__: Decoding is not intended for the version 0x" + Integer.toHexString(Detected_Frame[BlocStart + 3]) : "MANS__: Decoding is not intended for the version 0x" + Integer.toHexString(Detected_Frame[BlocStart + 3]);
                                                            break block79;
                                                        }
                                                        if (Detected_Frame[BlocStart + 2] != 38) break block98;
                                                        this.InterpretedFrame = Detected_Frame[BlocStart + 3] != 16 ? "LOGB__: Decoding is not intended for the version 0x" + Integer.toHexString(Detected_Frame[BlocStart + 3]) : "LOGB__: Decoding is not intended for the version 0x" + Integer.toHexString(Detected_Frame[BlocStart + 3]);
                                                        break block79;
                                                    }
                                                    if (Detected_Frame[BlocStart + 2] != 20) break block99;
                                                    if (Detected_Frame[BlocStart + 3] == 16) break block100;
                                                    this.InterpretedFrame = "CNF___: Decoding is not intended for the version 0x" + Integer.toHexString(Detected_Frame[BlocStart + 3]);
                                                    break block79;
                                                }
                                                if (Detected_Frame[BlocStart + 1] != 8) break block101;
                                                if (Detected_Frame[BlocStart + 4] == 0 || Detected_Frame[BlocStart + 4] == 25 || Detected_Frame[BlocStart + 4] == 26 || Detected_Frame[BlocStart + 4] == 27 || Detected_Frame[BlocStart + 4] == 28 || Detected_Frame[BlocStart + 4] == 29 || Detected_Frame[BlocStart + 4] == 39 || Detected_Frame[BlocStart + 4] == 40 || Detected_Frame[BlocStart + 4] == 42) {
                                                    byte iTmp = Detected_Frame[BlocStart + 5];
                                                    this.InterpretedFrame = "CNF" + String.format("%02d", Detected_Frame[BlocStart + 4]) + "_: ";
                                                    this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(iTmp);
                                                    this.InterpretedFrame = this.InterpretedFrame + " ";
                                                    break block79;
                                                } else {
                                                    this.InterpretedFrame = "CNF" + String.format("%02d", Detected_Frame[BlocStart + 4]) + "_: Not supported";
                                                }
                                                break block79;
                                            }
                                            if (Detected_Frame[BlocStart + 1] != 9) break block102;
                                            if (Detected_Frame[BlocStart + 4] == 32 || Detected_Frame[BlocStart + 4] == 33 || Detected_Frame[BlocStart + 4] == 34) {
                                                byte Major = Detected_Frame[BlocStart + 5];
                                                byte Minor = Detected_Frame[BlocStart + 6];
                                                this.InterpretedFrame = "CNF" + String.format("%02d", Detected_Frame[BlocStart + 4]) + "_: ";
                                                this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(Major);
                                                this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(Minor);
                                                this.InterpretedFrame = this.InterpretedFrame + " ";
                                                break block79;
                                            } else {
                                                this.InterpretedFrame = "CNF" + String.format("%02d", Detected_Frame[BlocStart + 4]) + "_: Not supported";
                                            }
                                            break block79;
                                        }
                                        if (Detected_Frame[BlocStart + 1] != 11) break block103;
                                        if (Detected_Frame[BlocStart + 4] == 16 || Detected_Frame[BlocStart + 4] == 38) {
                                            float f1 = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 5, 1);
                                            this.InterpretedFrame = "CNF" + String.format("%02d", Detected_Frame[BlocStart + 4]) + "_: ";
                                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(f1, 6);
                                            this.InterpretedFrame = this.InterpretedFrame + " ";
                                            break block79;
                                        } else {
                                            this.InterpretedFrame = "CNF" + String.format("%02d", Detected_Frame[BlocStart + 4]) + "_: Not supported";
                                        }
                                        break block79;
                                    }
                                    if (Detected_Frame[BlocStart + 1] != 12) break block104;
                                    if (Detected_Frame[BlocStart + 4] == 30) {
                                        byte Equip = Detected_Frame[BlocStart + 5];
                                        byte Meca = Detected_Frame[BlocStart + 6];
                                        byte Fog = Detected_Frame[BlocStart + 7];
                                        byte Acc = Detected_Frame[BlocStart + 8];
                                        byte Sat = Detected_Frame[BlocStart + 9];
                                        this.InterpretedFrame = "CNF" + String.format("%02d", Detected_Frame[BlocStart + 4]) + "_: ";
                                        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(Equip);
                                        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(Meca);
                                        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(Fog);
                                        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(Acc);
                                        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(Sat);
                                        this.InterpretedFrame = this.InterpretedFrame + " ";
                                        break block79;
                                    } else {
                                        this.InterpretedFrame = "CNF" + String.format("%02d", Detected_Frame[BlocStart + 4]) + "_: Not supported";
                                    }
                                    break block79;
                                }
                                if (Detected_Frame[BlocStart + 1] != 14) break block105;
                                if (Detected_Frame[BlocStart + 4] == 20 || Detected_Frame[BlocStart + 4] == 21 || Detected_Frame[BlocStart + 4] == 22) {
                                    int i;
                                    char[] TpCode = new char[8];
                                    for (i = 0; i < 8; ++i) {
                                        TpCode[i] = (char)Detected_Frame[BlocStart + 5 + i];
                                    }
                                    this.InterpretedFrame = "CNF" + String.format("%02d", Detected_Frame[BlocStart + 4]) + "_: ";
                                    for (i = 0; i < 8; ++i) {
                                        if (TpCode[i] == '\u0000') continue;
                                        this.InterpretedFrame = this.InterpretedFrame + TpCode[i];
                                    }
                                    this.InterpretedFrame = this.InterpretedFrame + " ";
                                    break block79;
                                } else {
                                    this.InterpretedFrame = "CNF" + String.format("%02d", Detected_Frame[BlocStart + 4]) + "_: Not supported";
                                }
                                break block79;
                            }
                            if (Detected_Frame[BlocStart + 1] != 15) break block106;
                            if (Detected_Frame[BlocStart + 4] == 23) {
                                float f1 = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 5, 1);
                                float f2 = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 9, 1);
                                this.InterpretedFrame = "CNF" + String.format("%02d", Detected_Frame[BlocStart + 4]) + "_: ";
                                this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(f1, 6);
                                this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(f2, 6);
                            }
                            break block79;
                        }
                        if (Detected_Frame[BlocStart + 1] != 19) break block107;
                        if (Detected_Frame[BlocStart + 4] == 1 || Detected_Frame[BlocStart + 4] == 2 || Detected_Frame[BlocStart + 4] == 3 || Detected_Frame[BlocStart + 4] == 4 || Detected_Frame[BlocStart + 4] == 5 || Detected_Frame[BlocStart + 4] == 6 || Detected_Frame[BlocStart + 4] == 7 || Detected_Frame[BlocStart + 4] == 8 || Detected_Frame[BlocStart + 4] == 9 || Detected_Frame[BlocStart + 4] == 10 || Detected_Frame[BlocStart + 4] == 11 || Detected_Frame[BlocStart + 4] == 12 || Detected_Frame[BlocStart + 4] == 13 || Detected_Frame[BlocStart + 4] == 14 || Detected_Frame[BlocStart + 4] == 15 || Detected_Frame[BlocStart + 4] == 17 || Detected_Frame[BlocStart + 4] == 18 || Detected_Frame[BlocStart + 4] == 19 || Detected_Frame[BlocStart + 4] == 36 || Detected_Frame[BlocStart + 4] == 37 || Detected_Frame[BlocStart + 4] == 41) {
                            float f1 = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 5, 1);
                            float f2 = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 9, 1);
                            float f3 = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 13, 1);
                            this.InterpretedFrame = "CNF" + String.format("%02d", Detected_Frame[BlocStart + 4]) + "_: ";
                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(f1, 6);
                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(f2, 6);
                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(f3, 6);
                            break block79;
                        } else if (Detected_Frame[BlocStart + 4] == 24) {
                            double Lat = (double)this.Convert_4Bytes_to_SignedInt(Detected_Frame, BlocStart + 5, 1) * 1.4629180792671596E-9;
                            double Long6 = (double)this.Convert_4Bytes_to_SignedInt(Detected_Frame, BlocStart + 9, 1) * 1.4629180792671596E-9;
                            float Alti = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 13, 1);
                            this.InterpretedFrame = "CNF" + String.format("%02d", Detected_Frame[BlocStart + 4]) + "_: ";
                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Lat, 8);
                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Long6, 8);
                            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Alti, 6);
                            break block79;
                        } else {
                            this.InterpretedFrame = "CNF" + String.format("%02d", Detected_Frame[BlocStart + 4]) + "_: Not supported";
                        }
                        break block79;
                    }
                    if (Detected_Frame[BlocStart + 1] != 23) break block108;
                    if (Detected_Frame[BlocStart + 4] == 31) {
                        int i;
                        char[] SnNumber = new char[16];
                        for (i = 0; i < 16; ++i) {
                            SnNumber[i] = (char)Detected_Frame[BlocStart + 5 + i];
                        }
                        this.InterpretedFrame = "CNF" + String.format("%02d", Detected_Frame[BlocStart + 4]) + "_: ";
                        for (i = 0; i < 16; ++i) {
                            if (SnNumber[i] == '\u0000') continue;
                            this.InterpretedFrame = this.InterpretedFrame + SnNumber[i];
                        }
                        this.InterpretedFrame = this.InterpretedFrame + " ";
                        break block79;
                    } else {
                        this.InterpretedFrame = "CNF" + String.format("%02d", Detected_Frame[BlocStart + 4]) + "_: Not supported";
                    }
                    break block79;
                }
                if (Detected_Frame[BlocStart + 1] == 33) {
                    if (Detected_Frame[BlocStart + 4] == 35) {
                        float f1 = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 5, 1);
                        float f2 = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 9, 1);
                        byte I1 = Detected_Frame[BlocStart + 13];
                        float f3 = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 14, 1);
                        float f4 = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 18, 1);
                        byte I2 = Detected_Frame[BlocStart + 22];
                        float f5 = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 23, 1);
                        float f6 = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + 27, 1);
                        this.InterpretedFrame = "CNF" + String.format("%02d", Detected_Frame[BlocStart + 4]) + "_: ";
                        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(f1, 6);
                        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(f2, 6);
                        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(I1);
                        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(f3, 6);
                        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(f4, 6);
                        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(I2);
                        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(f5, 6);
                        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(f6, 6);
                        break block79;
                    } else {
                        this.InterpretedFrame = "CNF" + String.format("%02d", Detected_Frame[BlocStart + 4]) + "_: Not supported";
                    }
                }
                break block79;
            }
            this.InterpretedFrame = String.format("%02d", Detected_Frame[BlocStart + 2]) + " : Telegram identifier not supported";
        }
        this.InterpretedFrame_AddToList(this.InterpretedFrame);
        return 0;
    }

    private boolean IsChecksumValid(byte[] Frame2, int BlocStart, int Nb) {
        int sum = 0;
        for (int i = BlocStart; i < BlocStart + Nb - 2; ++i) {
            sum += Frame2[i] & 0xFF;
        }
        int chk_read = this.Convert_2Bytes_to_UnsignedInt(Frame2, BlocStart + Nb - 2, 1);
        return chk_read == sum;
    }

    private String FormatImu2DecodedLine(ImuBlk_Item BlkItem) {
        String formatted_line = "IMU2__:";
        formatted_line = formatted_line + this.InterpretIntegerAsInt(16);
        formatted_line = formatted_line + this.InterpretIntegerAsInt(BlkItem.Counter);
        formatted_line = formatted_line + this.InterpretDouble((double)BlkItem.Fog1Rot * this.Info.GetFrequency() * 3600.0 * 180.0 / Math.PI);
        formatted_line = formatted_line + this.InterpretDouble((double)BlkItem.Fog2Rot * this.Info.GetFrequency() * 3600.0 * 180.0 / Math.PI);
        formatted_line = formatted_line + this.InterpretDouble((double)BlkItem.Fog3Rot * this.Info.GetFrequency() * 3600.0 * 180.0 / Math.PI);
        formatted_line = formatted_line + this.InterpretFloat(BlkItem.Acc1Speed * (float)this.Info.GetFrequency());
        formatted_line = formatted_line + this.InterpretFloat(BlkItem.Acc2Speed * (float)this.Info.GetFrequency());
        formatted_line = formatted_line + this.InterpretFloat(BlkItem.Acc3Speed * (float)this.Info.GetFrequency());
        formatted_line = formatted_line + "|";
        formatted_line = formatted_line + this.InterpretIntegerAsHex((int)BlkItem.SensorSta);
        formatted_line = formatted_line + "|";
        formatted_line = formatted_line + this.InterpretDouble(BlkItem.Time, 8);
        return formatted_line;
    }

    private float Kelvin_To_DegCelsius(float KTemp) {
        float DegCelsiusTemp = (float)((double)KTemp - 273.15);
        return DegCelsiusTemp;
    }
}

