/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;

public class RDI_PD4_Decoder
extends Decoder {
    private Encoder Encod;

    public RDI_PD4_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(false);
        int Start_Blk_Length = 2;
        byte[] Start_Blk = new byte[Start_Blk_Length];
        Start_Blk[0] = 125;
        Start_Blk[1] = 0;
        int Length_Blk = 47;
        this.DecodeInit(0, Length_Blk, Start_Blk, Start_Blk_Length);
    }

    @Override
    public String GetFileHeading() {
        String sep = this.Info.GetSeparator();
        return "SystemConf" + sep + "X_BT_velocity" + sep + "Y_BT_velocity" + sep + "Z_BT_velocity" + sep + "X_WT_velocity" + sep + "Y_WT_velocity" + sep + "Z_WT_velocity" + sep + "Beam1RangeToBottom" + sep + "Beam2RangeToBottom" + sep + "Beam3RangeToBottom" + sep + "Beam4RangeToBottom" + sep + "SoundOfSpeed";
    }

    @Override
    public int InterpretFrame(byte[] Decoded_Frame, int Lenght) {
        int SystConf = this.Convert_1Byte_to_SignedInt(Decoded_Frame, 4, 0) / 64;
        int X_BT_velocity = this.Convert_2Bytes_to_SignedInt(Decoded_Frame, 5, 0);
        int Y_BT_velocity = this.Convert_2Bytes_to_SignedInt(Decoded_Frame, 7, 0);
        int Z_BT_velocity = this.Convert_2Bytes_to_SignedInt(Decoded_Frame, 9, 0);
        double X_BT_velocity_m = (double)X_BT_velocity * 0.001;
        double Y_BT_velocity_m = (double)Y_BT_velocity * 0.001;
        double Z_BT_velocity_m = (double)Z_BT_velocity * 0.001;
        int X_WT_velocity = this.Convert_2Bytes_to_SignedInt(Decoded_Frame, 22, 0);
        int Y_WT_velocity = this.Convert_2Bytes_to_SignedInt(Decoded_Frame, 24, 0);
        int Z_WT_velocity = this.Convert_2Bytes_to_SignedInt(Decoded_Frame, 26, 0);
        double X_WT_velocity_m = (double)X_WT_velocity * 0.001;
        double Y_WT_velocity_m = (double)Y_WT_velocity * 0.001;
        double Z_WT_velocity_m = (double)Z_WT_velocity * 0.001;
        int B1_RangeToBottom = this.Convert_2Bytes_to_SignedInt(Decoded_Frame, 13, 0);
        int B2_RangeToBottom = this.Convert_2Bytes_to_SignedInt(Decoded_Frame, 15, 0);
        int B3_RangeToBottom = this.Convert_2Bytes_to_SignedInt(Decoded_Frame, 17, 0);
        int B4_RangeToBottom = this.Convert_2Bytes_to_SignedInt(Decoded_Frame, 19, 0);
        double B1_RangeToBottom_m = (double)B1_RangeToBottom * 0.01;
        double B2_RangeToBottom_m = (double)B2_RangeToBottom * 0.01;
        double B3_RangeToBottom_m = (double)B3_RangeToBottom * 0.01;
        double B4_RangeToBottom_m = (double)B4_RangeToBottom * 0.01;
        int SoundOfSpeed = this.Convert_2Bytes_to_SignedInt(Decoded_Frame, 41, 0);
        this.InterpretedFrame = this.InterpretIntegerAsInt(SystConf);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(X_BT_velocity_m);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Y_BT_velocity_m);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Z_BT_velocity_m);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(X_WT_velocity_m);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Y_WT_velocity_m);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Z_WT_velocity_m);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(B1_RangeToBottom_m);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(B2_RangeToBottom_m);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(B3_RangeToBottom_m);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(B4_RangeToBottom_m);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(SoundOfSpeed);
        this.InterpretedFrame_AddToList(this.InterpretedFrame);
        return 0;
    }
}

