/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;

public class SAS2_Decoder
extends Decoder {
    private Encoder Encod;

    public SAS2_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(true);
        int Start_Blk_Length = 1;
        byte[] Start_Blk = new byte[Start_Blk_Length];
        Start_Blk[0] = 36;
        int Length_Blk = 106;
        this.DecodeInit(0, Length_Blk, Start_Blk, Start_Blk_Length);
    }

    @Override
    public String GetFileHeading() {
        String sep = this.Info.GetSeparator();
        return "Time(s)" + sep + "AlgoStatus1" + sep + "AlgoStatus2" + sep + "AlgoStatus3" + sep + "SysStatus1" + sep + "SysStatus2" + sep + "SensorStatus1" + sep + "SensorStatus2" + sep + "Heading(\u00b0)" + sep + "Roll(\u00b0)" + sep + "Pitch(\u00b0)" + sep + "Latitude(\u00b0)" + sep + "Longitude(\u00b0)" + sep + "Heave(m)" + sep + "VitEst(m/s)" + sep + "VitNord(m/s)" + sep + "VitUp(m/s)" + sep + "DVLAlti(m)" + sep + "CTDAlti(m)" + sep + "SoundSpeed(m/s)" + sep + "LatStdDev(m)" + sep + "LongStdDev(m)" + sep + "LatLongStdDev(m2)" + sep + "CRC";
    }

    @Override
    public int InterpretFrame(byte[] Decoded_Frame, int Lenght) {
        if (this.Bytes_Frame[0] != 36) {
            return -1;
        }
        int Day = 10 * (this.Bytes_Frame[2] >> 4 & 0xF) + (this.Bytes_Frame[2] & 0xF);
        int Hour = 10 * (this.Bytes_Frame[3] >> 4 & 0xF) + (this.Bytes_Frame[3] & 0xF);
        int Minutes = 10 * (this.Bytes_Frame[4] >> 4 & 0xF) + (this.Bytes_Frame[4] & 0xF);
        int Seconds = 10 * (this.Bytes_Frame[5] >> 4 & 0xF) + (this.Bytes_Frame[5] & 0xF);
        int CentiSeconds = 10 * (this.Bytes_Frame[6] >> 4 & 0xF) + (this.Bytes_Frame[6] & 0xF);
        int CentiMicroSeconds = 10 * (this.Bytes_Frame[7] >> 4 & 0xF) + (this.Bytes_Frame[7] & 0xF);
        int MicroSeconds = 10 * (this.Bytes_Frame[8] >> 4 & 0xF) + (this.Bytes_Frame[8] & 0xF);
        double dsec = (double)Day * 24.0 * 3600.0 + (double)Hour * 3600.0 + (double)Minutes * 60.0 + (double)Seconds;
        dsec += 0.01 * (double)CentiSeconds + 1.0E-4 * (double)CentiMicroSeconds + 1.0E-6 * (double)MicroSeconds;
        long AlgoStatus1 = this.Convert_4Bytes_to_UnsignedInt(this.Bytes_Frame, 9, 1);
        long AlgoStatus2 = this.Convert_4Bytes_to_UnsignedInt(this.Bytes_Frame, 13, 1);
        long AlgoStatus3 = this.Convert_4Bytes_to_UnsignedInt(this.Bytes_Frame, 17, 1);
        long SysStatus1 = this.Convert_4Bytes_to_UnsignedInt(this.Bytes_Frame, 21, 1);
        long SysStatus2 = this.Convert_4Bytes_to_UnsignedInt(this.Bytes_Frame, 25, 1);
        long SensorStatus1 = this.Convert_4Bytes_to_UnsignedInt(this.Bytes_Frame, 29, 1);
        long SensorStatus2 = this.Convert_4Bytes_to_UnsignedInt(this.Bytes_Frame, 33, 1);
        float Heading = (float)(57.29577951308232 * (double)this.Convert_4Bytes_to_Float(this.Bytes_Frame, 37, 1));
        float Roll = (float)(57.29577951308232 * (double)this.Convert_4Bytes_to_Float(this.Bytes_Frame, 41, 1));
        float Pitch = (float)(57.29577951308232 * (double)this.Convert_4Bytes_to_Float(this.Bytes_Frame, 45, 1));
        double Latitude = 57.29577951308232 * this.Convert_8Bytes_to_Double(this.Bytes_Frame, 49, 1);
        double Longitude = 57.29577951308232 * this.Convert_8Bytes_to_Double(this.Bytes_Frame, 57, 1);
        float Heave = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 65, 1);
        float VelEast = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 69, 1);
        float VelNorth = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 73, 1);
        float VelVertical = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 77, 1);
        float DVLAltitude = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 81, 1);
        float CTDAltitude = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 85, 1);
        float CTDSoundSpeed = this.Convert_2Bytes_to_UnsignedInt(this.Bytes_Frame, 89, 1);
        float LatStd = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 91, 1);
        float LongStd = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 95, 1);
        float LatLongCov = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 99, 1);
        int CRC = this.Convert_2Bytes_to_UnsignedInt(this.Bytes_Frame, 103, 1);
        if (this.GetCurvePlotImplementation()) {
            this.Encod.setValue(101, dsec, 31);
            this.Encod.setValue(606, Integer.toHexString((int)AlgoStatus1), 1000);
            this.Encod.setValue(607, Integer.toHexString((int)AlgoStatus2), 1000);
            this.Encod.setValue(608, Integer.toHexString((int)AlgoStatus3), 1000);
            this.Encod.setValue(600, Integer.toHexString((int)SysStatus1), 1000);
            this.Encod.setValue(601, Integer.toHexString((int)SysStatus2), 1000);
            this.Encod.setValue(603, Integer.toHexString((int)SensorStatus1), 1000);
            this.Encod.setValue(604, Integer.toHexString((int)SensorStatus2), 1000);
            this.Encod.setValue(103, Float.valueOf(Heading), 1);
            this.Encod.setValue(104, Float.valueOf(Roll), 1);
            this.Encod.setValue(105, Float.valueOf(Pitch), 1);
            this.Encod.setValue(124, Latitude, 1);
            this.Encod.setValue(125, Longitude, 1);
            this.Encod.setValue(148, Float.valueOf(Heave), 11);
            this.Encod.setValue(129, Float.valueOf(LatStd), 11);
            this.Encod.setValue(130, Float.valueOf(LongStd), 11);
            this.Encod.setValue(132, Float.valueOf(LatLongCov), 301);
            this.Encod.setValue(136, Float.valueOf(VelNorth), 21);
            this.Encod.setValue(137, Float.valueOf(VelEast), 21);
            this.Encod.setValue(138, Float.valueOf(VelVertical), 21);
            this.Encod.setValue(246, Float.valueOf(CTDAltitude), 11);
            this.Encod.setValue(208, Float.valueOf(DVLAltitude), 11);
            this.Encod.setValue(206, Float.valueOf(CTDSoundSpeed / 10.0f), 21);
            LoggerDecoderFrame.FrameReady = true;
        }
        return 0;
    }
}

