/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;

public class SEAPATH_Decoder
extends Decoder {
    private Encoder Encod;

    public SEAPATH_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(true);
        int Start_Blk_Length = 1;
        byte[] Start_Blk = new byte[Start_Blk_Length];
        Start_Blk[0] = 113;
        int Length_Blk = 42;
        this.DecodeInit(0, Length_Blk, Start_Blk, Start_Blk_Length);
    }

    @Override
    public String GetFileHeading() {
        String sep = this.Info.GetSeparator();
        return "Time(s)" + sep + "Lat(\u00b0)" + sep + "Long(\u00b0)" + sep + "Alt(cm)" + sep + "Heave(cm)" + sep + "NorthVel(cm/s)" + sep + "EastVel(cm/s)" + sep + "DownVel(cm/s)" + sep + "Roll(\u00b0)" + sep + "Pitch(\u00b0)" + sep + "Head(\u00b0)" + sep + "RollRate(\u00b0)" + sep + "PitchRate(\u00b0)" + sep + "Headrate(\u00b0)" + sep + "Status";
    }

    @Override
    public int InterpretFrame(byte[] Decoded_Frame, int Lenght) {
        int crc2;
        int crc1 = this.Convert_2Bytes_to_UnsignedInt(this.Bytes_Frame, 40, 1);
        if (crc1 != (crc2 = this.Compute_CRC16_CCITT_R(Decoded_Frame, 1, 39, 65535))) {
            return -1;
        }
        double Time_s = this.Convert_4Bytes_to_UnsignedInt(this.Bytes_Frame, 1, 1);
        double Time_10us = this.Bytes_Frame[5];
        double Lat = (double)this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 6, 1) * 90.0 / Math.pow(2.0, 30.0);
        double Long2 = (double)this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 10, 1) * 90.0 / Math.pow(2.0, 30.0);
        float Alt = this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 14, 1);
        float Heave = this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 18, 1);
        float NorthSpeed = this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 20, 1);
        float EastSpeed = this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 22, 1);
        float DownSpeed = this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 24, 1);
        double Roll = (double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 26, 1) * 90.0 / Math.pow(2.0, 14.0);
        double Pitch = (double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 28, 1) * 90.0 / Math.pow(2.0, 14.0);
        double Heading = (double)this.Convert_2Bytes_to_UnsignedInt(this.Bytes_Frame, 30, 1) * 90.0 / Math.pow(2.0, 14.0);
        double RollRate = (double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 32, 1) * 90.0 / Math.pow(2.0, 14.0);
        double PitchRate = (double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 34, 1) * 90.0 / Math.pow(2.0, 14.0);
        double HeadingRate = (double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 36, 1) * 90.0 / Math.pow(2.0, 14.0);
        int Status = this.Bytes_Frame[39] & 0xFF;
        if (this.GetCurvePlotImplementation()) {
            this.Encod.setValue(100, Time_s + Time_10us * 0.01, 31);
            this.Encod.setValue(124, Float.valueOf((float)Lat), 1);
            this.Encod.setValue(125, Float.valueOf((float)Long2), 1);
            this.Encod.setValue(126, Float.valueOf(Alt), 15);
            this.Encod.setValue(148, Float.valueOf(-Heave), 15);
            this.Encod.setValue(136, Float.valueOf(NorthSpeed), 26);
            this.Encod.setValue(137, Float.valueOf(EastSpeed), 26);
            this.Encod.setValue(138, Float.valueOf(-DownSpeed), 26);
            this.Encod.setValue(103, Float.valueOf((float)Heading), 1);
            this.Encod.setValue(104, Float.valueOf((float)Roll), 1);
            this.Encod.setValue(105, Float.valueOf(-((float)Pitch)), 1);
            this.Encod.setValue(110, Float.valueOf((float)HeadingRate), 51);
            this.Encod.setValue(111, Float.valueOf((float)RollRate), 51);
            this.Encod.setValue(112, Float.valueOf(-((float)PitchRate)), 51);
            this.Encod.setValue(1000, Status, 1000);
            LoggerDecoderFrame.FrameReady = true;
        }
        this.InterpretedFrame = "SEAPATH" + this.Info.GetSeparator();
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Time_s + Time_10us * 0.01);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Lat, 124);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Long2, 125);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Alt, 126);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Heave, 148);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(NorthSpeed, 136);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(EastSpeed, 137);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(DownSpeed, 138);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Roll, 104);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Pitch, 105);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Heading, 103);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(RollRate, 111);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(PitchRate, 112);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(HeadingRate, 110);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex(Status);
        this.InterpretedFrame_AddToList(this.InterpretedFrame);
        return 0;
    }
}

