/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class SEATEX_DHEAVE_Decoder
extends Decoder {
    private Encoder Encod;

    public SEATEX_DHEAVE_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(true);
        int Start_Blk_Length = 2;
        byte[] Start_Blk = new byte[Start_Blk_Length];
        Start_Blk[0] = -86;
        Start_Blk[1] = 82;
        int Length_Blk = 13;
        this.DecodeInit(0, Length_Blk, Start_Blk, Start_Blk_Length);
    }

    @Override
    public String GetFileHeading() {
        String sep = this.Info.GetSeparator();
        return "Standard decoding only";
    }

    @Override
    public int InterpretFrame(byte[] Decoded_Frame, int Lenght) {
        if ((this.Bytes_Frame[0] & 0xFF) != 170 || (this.Bytes_Frame[1] & 0xFF) != 82) {
            return -1;
        }
        int Time_s = this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 2, 1);
        int Time_us = this.Convert_2Bytes_to_UnsignedInt(this.Bytes_Frame, 6, 1);
        double Heave_Time = (double)Time_s + (double)Time_us / 10000.0;
        int Heave = -this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 8, 1) / 100;
        int Heave_Valid = this.Convert_1Byte_to_SignedInt(this.Bytes_Frame, 10, 1);
        long timeStamp = (long)Time_s * 1000L;
        GregorianCalendar c = new GregorianCalendar();
        c.setTimeInMillis(timeStamp);
        c.setTimeZone(TimeZone.getTimeZone("GMT"));
        float Heave_DayTime = (float)(3600 * c.get(11) + 60 * c.get(12) + c.get(13)) + (float)Time_us / 10000.0f;
        if (this.GetCurvePlotImplementation()) {
            this.Encod.setValue(342, Heave_Time, 31);
            this.Encod.setValue(155, Float.valueOf(Heave_DayTime), 31);
            this.Encod.setValue(117, Heave, 11);
            this.Encod.setValue(1030, Heave_Valid, 1000);
            LoggerDecoderFrame.FrameReady = true;
        }
        return 0;
    }
}

