/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;

public class SENSOR_RD_Decoder
extends Decoder {
    private Encoder Encod;

    public SENSOR_RD_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(true);
        int Start_Blk_Length = 2;
        byte[] Start_Blk = new byte[Start_Blk_Length];
        Start_Blk[0] = 36;
        Start_Blk[1] = -16;
        int Length_Blk = 88;
        this.DecodeInit(0, Length_Blk, Start_Blk, Start_Blk_Length);
    }

    @Override
    public String GetFileHeading() {
        String sep = this.Info.GetSeparator();
        return "UTC Time(s)" + sep + "XV1_angl(inc)" + sep + "XV2_angl(inc)" + sep + "XV3_angl(inc)" + sep + "XV1_vel(inc)" + sep + "XV2_vel(inc)" + sep + "XV3_vel(inc)" + sep + "XV2_Speed(m/s)" + sep + "XV1_Speed(m/s)" + sep + "DVL_Alt(m)" + sep + "XV3_Speed(m/s)" + sep + "GPS_lat(\u00b0)" + sep + "GPS_long(\u00b0)" + sep + "GPS_alt(m)" + sep + "USBL_lat(\u00b0)" + sep + "USBL_long(\u00b0)" + sep + "USBL_alt(m)" + sep + "LBL_lat(\u00b0)" + sep + "LBL_long(\u00b0)" + sep + "LBL_alt(m)" + sep + "LBL_Beacon_id" + sep + "LBL_Range(m)";
    }

    @Override
    public int InterpretFrame(byte[] Detected_Frame, int Lenght) {
        float Angl_inc_XV1 = this.Convert_4Bytes_to_Float(Detected_Frame, 2, 1);
        float Angl_inc_XV2 = this.Convert_4Bytes_to_Float(Detected_Frame, 6, 1);
        float Angl_inc_XV3 = this.Convert_4Bytes_to_Float(Detected_Frame, 10, 1);
        float Velo_inc_XV1 = this.Convert_4Bytes_to_Float(Detected_Frame, 14, 1);
        float Velo_inc_XV2 = this.Convert_4Bytes_to_Float(Detected_Frame, 18, 1);
        float Velo_inc_XV3 = this.Convert_4Bytes_to_Float(Detected_Frame, 22, 1);
        float Speed_XV2 = this.Convert_4Bytes_to_Float(Detected_Frame, 26, 1);
        float Speed_XV1 = this.Convert_4Bytes_to_Float(Detected_Frame, 30, 1);
        float DVL_alt = this.Convert_4Bytes_to_Float(Detected_Frame, 34, 1);
        float Speed_XV3 = this.Convert_4Bytes_to_Float(Detected_Frame, 38, 1);
        double GPS_lat = (double)this.Convert_4Bytes_to_SignedInt(Detected_Frame, 42, 1) * 180.0 / 2.147483648E9;
        double GPS_long = (double)this.Convert_4Bytes_to_SignedInt(Detected_Frame, 46, 1) * 180.0 / 2.147483648E9;
        float GPS_alt = this.Convert_4Bytes_to_Float(Detected_Frame, 50, 1);
        double USBL_lat = (double)this.Convert_4Bytes_to_SignedInt(Detected_Frame, 54, 1) * 180.0 / 2.147483648E9;
        double USBL_long = (double)this.Convert_4Bytes_to_SignedInt(Detected_Frame, 58, 1) * 180.0 / 2.147483648E9;
        float USBL_alt = this.Convert_4Bytes_to_Float(Detected_Frame, 62, 1);
        double LBL_lat = (double)this.Convert_4Bytes_to_SignedInt(Detected_Frame, 66, 1) * 180.0 / 2.147483648E9;
        double LBL_long = (double)this.Convert_4Bytes_to_SignedInt(Detected_Frame, 70, 1) * 180.0 / 2.147483648E9;
        float LBL_alt = this.Convert_4Bytes_to_Float(Detected_Frame, 74, 1);
        int LBL_asciiID_MSB = this.Convert_1Byte_to_UnsignedInt(Detected_Frame, 78, 1);
        int LBL_asciiID_LSB = this.Convert_1Byte_to_UnsignedInt(Detected_Frame, 79, 1);
        String s1 = Character.toString((char)LBL_asciiID_MSB);
        String s2 = Character.toString((char)LBL_asciiID_LSB);
        float LBL_range = this.Convert_4Bytes_to_Float(Detected_Frame, 80, 1);
        long Tmp = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, 84, 1);
        long Hours = (Tmp & 0xFFFFFFFFF8000000L) >> 27;
        long Minutes = (Tmp & 0x7E00000L) >> 21;
        long Seconds = (Tmp & 0x1F8000L) >> 15;
        long MilliSeconds = (Tmp & 0x7FE0L) >> 5;
        double Time = (double)(Hours * 3600L + Minutes * 60L + Seconds) + (double)MilliSeconds * 0.001;
        if (this.GetCurvePlotImplementation()) {
            this.Encod.setValue(100, Time, 31);
            this.Encod.setValue(455, Float.valueOf(Angl_inc_XV1), 203);
            this.Encod.setValue(456, Float.valueOf(Angl_inc_XV2), 203);
            this.Encod.setValue(457, Float.valueOf(Angl_inc_XV3), 203);
            this.Encod.setValue(458, Float.valueOf(Velo_inc_XV1), 203);
            this.Encod.setValue(459, Float.valueOf(Velo_inc_XV2), 203);
            this.Encod.setValue(460, Float.valueOf(Velo_inc_XV3), 203);
            this.Encod.setValue(134, Float.valueOf(Speed_XV2), 21);
            this.Encod.setValue(133, Float.valueOf(Speed_XV1), 21);
            this.Encod.setValue(208, Float.valueOf(DVL_alt), 11);
            this.Encod.setValue(135, Float.valueOf(Speed_XV3), 21);
            this.Encod.setValue(162, GPS_lat, 1);
            this.Encod.setValue(163, GPS_long, 1);
            this.Encod.setValue(164, Float.valueOf(GPS_alt), 11);
            this.Encod.setValue(198, USBL_lat, 1);
            this.Encod.setValue(199, USBL_long, 1);
            this.Encod.setValue(200, Float.valueOf(USBL_alt), 11);
            this.Encod.setValue(232, LBL_lat, 1);
            this.Encod.setValue(233, LBL_long, 1);
            this.Encod.setValue(234, Float.valueOf(LBL_alt), 11);
            this.Encod.setValue(235, Float.valueOf(LBL_range), 11);
            LoggerDecoderFrame.FrameReady = true;
        }
        this.InterpretedFrame = this.InterpretDouble(Time);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Angl_inc_XV1);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Angl_inc_XV2);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Angl_inc_XV3);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Velo_inc_XV1);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Velo_inc_XV2);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Velo_inc_XV3);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Speed_XV2);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Speed_XV1);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(DVL_alt);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Speed_XV3);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(GPS_lat);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(GPS_long);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(GPS_alt);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(USBL_lat);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(USBL_long);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(USBL_alt);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(LBL_lat);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(LBL_long);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(LBL_alt);
        this.InterpretedFrame = this.InterpretedFrame + s1 + s2 + this.Info.GetSeparator();
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(LBL_range);
        this.InterpretedFrame_AddToList(this.InterpretedFrame);
        return 0;
    }
}

