/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import java.text.SimpleDateFormat;
import java.util.Date;

public class XC_ACC_IMU50_Decoder
extends Decoder {
    SimpleDateFormat Formatheure;
    int[] Temperature;
    int LastAddr = -1;
    private Encoder Encod;

    public XC_ACC_IMU50_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(false);
        byte[] Start2 = new byte[]{-86};
        this.Formatheure = new SimpleDateFormat("HH:mm:ss.SSS");
        this.Temperature = new int[8];
        super.DecodeInit(0, 15, Start2, 1);
    }

    @Override
    public String GetFileHeading() {
        return "Time,ACCX,ACCY,ACCZ,TEMPX,TEMPY,TEMPZ,Missed";
    }

    @Override
    public int InterpretFrame(byte[] Decoded_Frame, int Lenght) {
        Date DateCourante = new Date();
        int ACC_X = this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 1, 0);
        int ACC_Y = this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 5, 0);
        int ACC_Z = this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 9, 0);
        int Temp = this.Convert_2Bytes_to_UnsignedInt(this.Bytes_Frame, 13, 0);
        int Missed = 0;
        int Addr = Temp >> 13 & 7;
        this.Temperature[Addr] = Temp &= 0xFFF;
        if (this.LastAddr != -1 && Addr != (this.LastAddr + 1 & 7)) {
            Missed = 1;
        }
        this.LastAddr = Addr;
        this.InterpretedFrame = this.InterpretString(this.Formatheure.format(DateCourante));
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(ACC_X);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(ACC_Y);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(ACC_Z);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(this.Temperature[0]);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(this.Temperature[1]);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(this.Temperature[2]);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(Missed);
        this.InterpretedFrame_AddToList(this.InterpretedFrame);
        return Missed;
    }
}

