/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;

public class XC_FOG_RAW_DATA_Decoder
extends Decoder {
    public static final int DATABLOCK_LENGTH = 64;
    private Encoder Encod;

    public XC_FOG_RAW_DATA_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(false);
        int Start_Blk_Length = 2;
        byte[] Start_Blk = new byte[Start_Blk_Length];
        Start_Blk[0] = 126;
        Start_Blk[1] = -91;
        this.DecodeInit(0, 64, Start_Blk, Start_Blk_Length);
    }

    @Override
    public String GetFileHeading() {
        String sep = "\t";
        this.Info.SetSeparator(sep);
        return "ProID" + sep + "frame_cnt" + sep + "status" + sep + "speed_imu(deg/s)" + sep + "speed_raw(deg/s)" + sep + "angle_inc_raw(inc)" + sep + "temp_fog(degC)" + sep + "temp_ana(degC)" + sep + "temp_res(degC)" + sep + "vpi(inc)" + sep + "ramp(inc)" + sep + "current(inc)";
    }

    @Override
    public int InterpretFrame(byte[] Detected_Frame, int Length) {
        int crc2;
        int endianness = 0;
        if (Detected_Frame[0] != 126) {
            this.InterpretedFrame = "ERR____: Unexpected SOF";
            return -1;
        }
        if (Detected_Frame[1] != -91) {
            this.InterpretedFrame = "ERR____: Unexpected Protocol ID";
            return -1;
        }
        if (Detected_Frame[63] != 126) {
            this.InterpretedFrame = "ERR____: Unexpected EOF";
            return -1;
        }
        int crc1 = this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 61, endianness);
        if (crc1 != (crc2 = this.Compute_CRC16_CCITT(Detected_Frame, 1, 60))) {
            this.InterpretedFrame = "ERR____: Unexpected checksum";
            return -1;
        }
        int id = this.Convert_1Byte_to_UnsignedInt(Detected_Frame, 1, endianness);
        int frame_cnt = this.Convert_1Byte_to_UnsignedInt(Detected_Frame, 2, endianness);
        int status = this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 3, endianness);
        double speed_imu = this.Convert_8Bytes_Q1548_to_Double(Detected_Frame, 5, endianness);
        double speed_raw = this.Convert_8Bytes_Q1548_to_Double(Detected_Frame, 13, endianness);
        float angle_inc_raw = this.Convert_4Bytes_to_SignedInt(Detected_Frame, 21, endianness);
        double temp_fog = this.Convert_8Bytes_Q1548_to_Double(Detected_Frame, 25, endianness);
        double temp_ana = this.Convert_8Bytes_Q1548_to_Double(Detected_Frame, 33, endianness);
        double temp_res = this.Convert_8Bytes_Q1548_to_Double(Detected_Frame, 41, endianness);
        float vpi = this.Convert_4Bytes_to_SignedInt(Detected_Frame, 49, endianness);
        float ramp = this.Convert_4Bytes_to_SignedInt(Detected_Frame, 53, endianness);
        float current = this.Convert_4Bytes_to_SignedInt(Detected_Frame, 57, endianness);
        this.InterpretedFrame = this.InterpretIntegerAsInt(id);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(frame_cnt);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(status);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(speed_imu);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(speed_raw);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(angle_inc_raw);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(temp_fog);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(temp_ana);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(temp_res);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(vpi);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(ramp);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(current);
        this.InterpretedFrame_AddToList(this.InterpretedFrame);
        return 0;
    }
}

