/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;

public class XC_PPINCSYS2_Decoder
extends Decoder {
    private Encoder Encod;
    public static final int DATABLOCK_LENGTH = 117;
    public static final int STX = -90;
    public static final int VER = 0;
    private int LastCounter;

    public XC_PPINCSYS2_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(true);
        this.LastCounter = -1;
        int Start_Blk_Length = 2;
        byte[] Start_Blk = new byte[Start_Blk_Length];
        Start_Blk[0] = -90;
        Start_Blk[1] = 0;
        this.DecodeInit(0, 117, Start_Blk, Start_Blk_Length);
    }

    @Override
    public String GetFileHeading() {
        String sep = "\t";
        this.Info.SetSeparator(sep);
        return "";
    }

    @Override
    public int InterpretFrame(byte[] Detected_Frame, int Length) {
        int endianness = 1;
        int Missed = 0;
        int index = 0;
        int Checksum = 0;
        if (Length == 117) {
            if (Detected_Frame[0] != -90) {
                this.InterpretedFrame = "ERR_STX: Unexpected start byte 0";
                return -1;
            }
            if (Detected_Frame[1] != 0) {
                this.InterpretedFrame = "ERR_VER: Unexpected start byte 1";
                return -1;
            }
        }
        for (index = 0; index < 117; ++index) {
            Checksum ^= Detected_Frame[index];
        }
        if (Checksum != Detected_Frame[117]) {
            this.InterpretedFrame = "ERR_CHK: Unexpected checksum";
            return -1;
        }
        this.InterpretedFrame = "";
        index = 0;
        double Time = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, index + 2, endianness);
        Time /= 10000.0;
        int Counter = this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, index + 6, endianness);
        if (this.LastCounter > 0) {
            ++this.LastCounter;
            if (Counter != this.LastCounter && Counter + 65536 != this.LastCounter) {
                Missed = Counter - this.LastCounter;
                if (Missed < 0) {
                    Missed += 65536;
                }
                System.out.println("MISSED:" + this.InterpretIntegerAsInt(Missed) + "\r\n");
            }
        }
        this.LastCounter = Counter;
        float FogIncX = this.Convert_4Bytes_to_Float(Detected_Frame, index + 8, endianness);
        float FogIncY = this.Convert_4Bytes_to_Float(Detected_Frame, index + 12, endianness);
        float FogIncZ = this.Convert_4Bytes_to_Float(Detected_Frame, index + 16, endianness);
        float AccIncX = this.Convert_4Bytes_to_Float(Detected_Frame, index + 20, endianness);
        float AccIncY = this.Convert_4Bytes_to_Float(Detected_Frame, index + 24, endianness);
        float AccIncZ = this.Convert_4Bytes_to_Float(Detected_Frame, index + 28, endianness);
        float FogSysX = this.Convert_4Bytes_to_Float(Detected_Frame, index + 32, endianness);
        float FogSysY = this.Convert_4Bytes_to_Float(Detected_Frame, index + 36, endianness);
        float FogSysZ = this.Convert_4Bytes_to_Float(Detected_Frame, index + 40, endianness);
        float AccSysX = this.Convert_4Bytes_to_Float(Detected_Frame, index + 44, endianness);
        float AccSysY = this.Convert_4Bytes_to_Float(Detected_Frame, index + 48, endianness);
        float AccSysZ = this.Convert_4Bytes_to_Float(Detected_Frame, index + 52, endianness);
        float TempFogX = this.Convert_4Bytes_to_Float(Detected_Frame, index + 56, endianness);
        float TempFogY = this.Convert_4Bytes_to_Float(Detected_Frame, index + 60, endianness);
        float TempFogZ = this.Convert_4Bytes_to_Float(Detected_Frame, index + 64, endianness);
        float TempAccX = this.Convert_4Bytes_to_Float(Detected_Frame, index + 68, endianness);
        float TempAccY = this.Convert_4Bytes_to_Float(Detected_Frame, index + 72, endianness);
        float TempAccZ = this.Convert_4Bytes_to_Float(Detected_Frame, index + 76, endianness);
        float TempSrc = this.Convert_4Bytes_to_Float(Detected_Frame, index + 80, endianness);
        float TempAna = this.Convert_4Bytes_to_Float(Detected_Frame, index + 84, endianness);
        long SensorStatus1 = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, index + 88, endianness);
        long SensorStatus2 = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, index + 92, endianness);
        long AlgoStatus1 = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, index + 96, endianness);
        long AlgoStatus2 = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, index + 100, endianness);
        long SystemStatus1 = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, index + 104, endianness);
        long SystemStatus2 = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, index + 108, endianness);
        long UserStatus = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, index + 112, endianness);
        this.InterpretedFrame = this.InterpretedFrame + "INCSYS:" + this.InterpretIntegerAsInt(Counter);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(FogIncX);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(FogIncY);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(FogIncZ);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(AccIncX);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(AccIncY);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(AccIncZ) + "|\t";
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(FogSysX);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(FogSysY);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(FogSysZ);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(AccSysX);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(AccSysY);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(AccSysZ) + "|";
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(TempFogX);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(TempFogY);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(TempFogZ);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(TempAccX);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(TempAccY);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(TempAccZ);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(TempSrc);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(TempAna) + "|";
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex((int)SensorStatus1);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex((int)SensorStatus2);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex((int)AlgoStatus1);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex((int)AlgoStatus2);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex((int)SystemStatus1);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex((int)SystemStatus2);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex((int)UserStatus) + "|";
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Time);
        this.InterpretedFrame_AddToList(this.InterpretedFrame);
        if (this.GetCurvePlotImplementation()) {
            this.Encod.setValue(486, Float.valueOf(FogSysX), 51);
            this.Encod.setValue(487, Float.valueOf(FogSysY), 51);
            this.Encod.setValue(488, Float.valueOf(FogSysZ), 51);
            this.Encod.setValue(483, Float.valueOf(AccSysX), 43);
            this.Encod.setValue(484, Float.valueOf(AccSysY), 43);
            this.Encod.setValue(485, Float.valueOf(AccSysZ), 43);
            this.Encod.setValue(303, Float.valueOf(TempFogX), 202);
            this.Encod.setValue(304, Float.valueOf(TempFogY), 202);
            this.Encod.setValue(305, Float.valueOf(TempFogZ), 202);
            this.Encod.setValue(306, Float.valueOf(TempAccX), 202);
            this.Encod.setValue(307, Float.valueOf(TempAccY), 202);
            this.Encod.setValue(308, Float.valueOf(TempAccZ), 202);
            this.Encod.setValue(302, Float.valueOf(TempSrc), 202);
            this.Encod.setValue(301, Float.valueOf(TempAna), 202);
            this.Encod.setValue(603, Integer.toHexString((int)SensorStatus1), 1000);
            this.Encod.setValue(604, Integer.toHexString((int)SensorStatus2), 1000);
            this.Encod.setValue(606, Integer.toHexString((int)AlgoStatus1), 1000);
            this.Encod.setValue(607, Integer.toHexString((int)AlgoStatus2), 1000);
            this.Encod.setValue(600, Integer.toHexString((int)SystemStatus1), 1000);
            this.Encod.setValue(601, Integer.toHexString((int)SystemStatus2), 1000);
            this.Encod.setValue(610, Integer.toHexString((int)UserStatus), 1000);
            this.Encod.setValue(101, Time, 31);
            LoggerDecoderFrame.FrameReady = true;
        }
        return 0;
    }
}

