/*
 * Decompiled with CFR 0.152.
 */
package Tools;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Paint;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.RectangleEdge;

public class jFreeChart_XY {
    private int nb_series = 0;
    private XYSeries[] series = new XYSeries[10];
    private XYSeriesCollection xyDataset = null;
    private JFreeChart chart = null;
    private NumberAxis valueScaleDomain = null;
    private NumberAxis valueScaleRange = null;
    private XYPlot plot = null;
    private JPanel chart_panel = null;

    public jFreeChart_XY(String title, int serie_nb, String[] serie_name, String xAxisLabel, String yAxisLabel) {
        int i;
        this.nb_series = serie_nb;
        for (i = 0; i < serie_nb; ++i) {
            this.series[i] = new XYSeries((Comparable)((Object)serie_name[i]), false, true);
        }
        this.xyDataset = new XYSeriesCollection();
        for (i = 0; i < serie_nb; ++i) {
            this.xyDataset.addSeries(this.series[i]);
        }
        this.chart = ChartFactory.createXYLineChart((String)title, (String)"", (String)"", (XYDataset)this.xyDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        this.chart.setBackgroundPaint((Paint)Color.WHITE);
        this.plot = this.chart.getXYPlot();
        this.plot.setBackgroundPaint((Paint)new Color(220, 220, 220));
        this.plot.setForegroundAlpha(1.0f);
        this.valueScaleDomain = new NumberAxis();
        this.valueScaleDomain.setLabel(xAxisLabel);
        this.valueScaleDomain.setLabelFont(new Font("Tahoma", 0, 11));
        this.plot.setDomainAxis((ValueAxis)this.valueScaleDomain);
        this.valueScaleRange = new NumberAxis();
        this.valueScaleRange.setLabel(yAxisLabel);
        this.valueScaleRange.setLabelFont(new Font("Tahoma", 0, 11));
        this.plot.setRangeAxis((ValueAxis)this.valueScaleRange);
        LegendTitle sl = this.chart.getLegend();
        sl.setItemFont(new Font("Tahoma", 2, 11));
        sl.setBorder(0.0, 0.0, 0.0, 0.0);
        sl.setBackgroundPaint((Paint)Color.WHITE);
        sl.setPosition(RectangleEdge.TOP);
    }

    public void setTitle(String title, Font font) {
        this.chart.setTitle(new TextTitle(title, new Font("Tahoma", 0, 11)));
        if (this.chart_panel != null) {
            this.viewChart(this.chart_panel);
        }
    }

    public int setXaxis(String Xlegend, double min, double max, double tick) {
        int status = 0;
        if (min > max) {
            double tmp = max;
            max = min;
            min = tmp;
            status = 1;
        }
        this.valueScaleDomain.setLabel(Xlegend);
        this.valueScaleDomain.setRange(min, max);
        this.valueScaleDomain.setTickUnit(new NumberTickUnit(tick));
        this.plot.setDomainAxis((ValueAxis)this.valueScaleDomain);
        if (this.chart_panel != null) {
            this.viewChart(this.chart_panel);
        }
        return status;
    }

    public void setXaxisDomain(double min, double max, double tick) {
        this.valueScaleDomain.setRange(min, max);
        this.valueScaleDomain.setTickUnit(new NumberTickUnit(tick));
        this.plot.setDomainAxis((ValueAxis)this.valueScaleDomain);
        if (this.chart_panel != null) {
            this.viewChart(this.chart_panel);
        }
    }

    public void setXLabel(String Xlabel) {
        this.valueScaleDomain.setLabel(Xlabel);
    }

    public void setYaxis(String Ylegend, double min, double max, double tick) {
        this.valueScaleRange.setLabel(Ylegend);
        this.valueScaleRange.setRange(min, max);
        this.valueScaleRange.setTickUnit(new NumberTickUnit(tick));
        this.valueScaleRange.setLabelFont(new Font("Tahoma", 2, 11));
        this.plot.setRangeAxis((ValueAxis)this.valueScaleRange);
        if (this.chart_panel != null) {
            this.viewChart(this.chart_panel);
        }
    }

    public void setYaxisRange(double min, double max, double tick) {
        this.valueScaleRange.setRange(min, max);
        this.plot.setRangeAxis((ValueAxis)this.valueScaleRange);
        if (this.chart_panel != null) {
            this.viewChart(this.chart_panel);
        }
    }

    public void setYaxisAutoRange() {
        this.valueScaleRange.setAutoRange(true);
        this.valueScaleRange.setAutoRangeIncludesZero(false);
        if (this.chart_panel != null) {
            this.viewChart(this.chart_panel);
        }
    }

    public void setXaxisAutoRange() {
        this.valueScaleDomain.setAutoRange(true);
        this.valueScaleDomain.setAutoTickUnitSelection(true);
        this.valueScaleDomain.setAutoRangeIncludesZero(false);
        if (this.chart_panel != null) {
            this.viewChart(this.chart_panel);
        }
    }

    public void setYLabel(String Ylabel) {
        this.valueScaleRange.setLabel(Ylabel);
    }

    public void addvalue(int serie, double X, double Y) {
        this.series[serie].add(new XYDataItem(X, Y));
        this.viewChart(this.chart_panel);
    }

    public void initvalue(int serie) {
        this.series[serie].clear();
        this.viewChart(this.chart_panel);
    }

    public void initallvalues() {
        for (int i = 0; i < this.nb_series; ++i) {
            this.initvalue(i);
        }
    }

    public void setChartPanel(JPanel panel) {
        this.chart_panel = panel;
    }

    public void setMessageCurve(String message) {
        this.plot.setNoDataMessage(message);
        if (this.chart_panel != null) {
            this.viewChart(this.chart_panel);
        }
    }

    public void viewChart(JPanel panel) {
        JLabel image = new JLabel(new ImageIcon(this.chart.createBufferedImage(panel.getWidth() - 10, panel.getHeight() - 10)));
        image.setSize(new Dimension(panel.getSize()));
        panel.removeAll();
        panel.add(image);
        panel.repaint();
    }
}

