/*
 * Decompiled with CFR 0.152.
 */
package org.ixsea.datamanager;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.ixsea.datamanager.Decoder;

public class DataWriter {
    String file;
    FileOutputStream out = null;
    File outFile = null;
    Decoder decoder = null;
    FileChannel channel = null;
    int mode;

    DataWriter(String file_) {
        this.file = file_;
    }

    public void write(final String s) {
        if (this.out == null) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    FileLock lock = DataWriter.this.channel.lock();
                    DataWriter.this.out.write(s.getBytes());
                    DataWriter.this.out.write("\r\n".getBytes());
                    lock.release();
                }
                catch (IOException e) {
                    System.out.println(e);
                }
                return null;
            }
        });
    }

    public void write(final byte[] s, final int size) {
        if (this.out == null) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    FileLock lock = DataWriter.this.channel.lock();
                    DataWriter.this.out.write(s, 0, size);
                    lock.release();
                }
                catch (IOException e) {
                    System.out.println(e);
                }
                return null;
            }
        });
    }

    public int FlowOpen() {
        Integer itmp = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    DataWriter.this.outFile = new File(DataWriter.this.file);
                    if (DataWriter.this.outFile.exists()) {
                        return new Integer(-2);
                    }
                    DataWriter.this.out = new FileOutputStream(DataWriter.this.outFile);
                    DataWriter.this.channel = DataWriter.this.out.getChannel();
                }
                catch (IOException e) {
                    System.out.println("Header : " + e);
                    DataWriter.this.out = null;
                    return new Integer(-1);
                }
                return new Integer(0);
            }
        });
        return itmp;
    }

    public void FlowClose() {
        try {
            if (this.channel != null) {
                this.channel.close();
            }
            if (this.out != null) {
                this.out.close();
            }
            this.out = null;
            this.channel = null;
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }
}

