// PLUGIN JSON

// Déclaration de l'objet qui va stocker toutes les données JSON retournées par le serveur

window.system  = 'SYSTEM';
window[system] = {};

// Fonction de mise en mémoire de données JSON dans l'objet SYSTEM
GIWIK.analyzeJSON = function (json)
{
	if (typeof json == 'string')
	{
		if (json == "") {return true;}

		var json = JSON.parse(json);

		if (!json) {return false;}
	}
	else if (typeof json != 'object')
	{
		return false;
	}

	var param,
		_matches,
		param_sliced,
		index_sliced;

	for (param in json)
	{
		// Cas particulier du passage d'index dans la clé (MyParameter['index']) --------------------------------------------------------------------
		if (param.indexOf("[",1) != -1) 							// "indexOf" et pas directement "match" pour sauvegarder le temps cpu
		{
			_matches = param.match(/^([\w]+)\['?([\w]+)'?\]$/i);

			param_sliced = _matches[1];
			index_sliced = _matches[2];

			if (typeof SYSTEM[param_sliced] != 'object')
			{
				window[system][param_sliced] = {};
			}
			window[system][param_sliced][index_sliced] = json[param];
			continue;
		}
		//-------------------------------------------------------------------------------------------------------------------------------------------

		// Si une fonction de traitement spécifique existe pour la donnée
		if (typeof GIWIK.analyzeJSON[param] == 'function')
		{
			GIWIK.analyzeJSON[param](json[param]);
		}
		// Cas standard : la nouvelle donnée écrase l'ancienne
		else
		{
			window[system][param] = json[param];
		}
	}

	// GIWIK.debug('SYSTEM', SYSTEM);

	return true;
};