// PLUGIN LEVER ARMS

GIWIK.init.js(['css','msg'], 'lever_arms');


// Gestion de l'affichage de la croix du bras de levier primaire
// target : int correspondant au n° du bras de levier
// lv1, lv2, lv3 : float valeurs des 3 axes
// letter (optionnel) : lettre du bras de levier
HEADING.displayLeverarmImg = function (target, lv1, lv2, lv3, letter, frame_type)
{
	var target = parseFloat(target);
	var lv1 = parseFloat(lv1);
	var lv2 = parseFloat(lv2);
	var lv3 = parseFloat(lv3);
	var img1rot = img2rot = 0;

	//console.log("displayLeverarmImg:"+target+" * "+lv1+" * "+lv2+" * "+lv3+" * "+letter+" * "+frame_type);
	if (isNaN(target) || isNaN(lv1) || isNaN(lv2) || isNaN(lv3))
	{
		return false;
	}

	// Gestion dynamique de l'affichage en fonction du type de système --------------------------------------------------------------------------------------------------
	// (pas de test HEADING.init.isdone pour le cas où la fonction est appelée pour la 1ère fois APRES la phase d'init comme sur une page inputs avec matrice)	
	var crp_suffix = (GIWIK._plugins.lever_arms.origin) ? "_crp" : "";


	// Determine le type de vehicule à afficher
	var vehicule_suffix = GIWIK.vehicule_type;
	if(GIWIK._plugins.mechanical.turret)
	{	
		if( typeof frame_type != 'undefined' ){
			vehicule_suffix = ( (frame_type==='' || frame_type==='base') ? GIWIK.vehicule_type : 'turret');
		}
	}

	// Determine si le système gère le repère independemmant de l'image
	var axe_out_of_picture = false;	
	if(GIWIK._plugins.mechanical.turret)
	{
		if( typeof frame_type != 'undefined' ){
			if(frame_type!='' && frame_type!='base') { axe_out_of_picture=true;}
		}	
	}	

	
	// Affichage de l'illustration
	$('.leverarms'+target+'_img1').css({
		'background' : "no-repeat center center url("+GIWIK.directories.img_lva+"/"+vehicule_suffix+"_top"+crp_suffix+GIWIK.css.night_suffix+".gif)",
		'width' : GIWIK.lva_top_width
	});
	
	// Gestion de l'affichage des axes en dehors de l'image principale
	if( axe_out_of_picture===true )
	{
		// Type d'axes
		if( GIWIK._plugins.mechanical.frame_convention 	=== 'front_right_down' ){
			// TO COMPLETE
		}
		else{
			axe_side_image = "car_axe_side";
			axe_top_image = "car_axe_top";			
		}
		
		// Affichage des axes
		$('#leverarms'+target+'_axe1').css({
			'background' : "no-repeat 0 -1px url("+GIWIK.directories.img_lva+"/"+axe_top_image+".gif)",
			'transform-origin' : '112px 186px'
		});

		$('#leverarms'+target+'_axe2').css({
			'background' : "no-repeat 0 -1px url("+GIWIK.directories.img_lva+"/"+axe_side_image+".gif)",
			'transform-origin': '58px 90px'
		});	
		
		// Rotation des axes		
		switch(frame_type)
		{
			case "vehicule":	
				img1rot = 0;
				img2rot = 0;
				break;
			case "turret":	
				img1rot = -15;
				img2rot = 0;
				break;					
			case "barrel":	
				img1rot = -15;
				img2rot = -17;
				break;					
		}	
		$('#leverarms'+target+'_axe1').velocity('stop').velocity({'rotateZ': img1rot+'deg'});
		$('#leverarms'+target+'_axe2').velocity('stop').velocity({'rotateZ': img2rot+'deg'});

		// Animation de la croix
		// Cf. plus bas
		
	}
	else
	{	
		// Suppression des axes
		$('#leverarms'+target+'_axe1').css({
			'background' : ""
		});

		$('#leverarms'+target+'_axe2').css({
			"background" : ""
		});			
	}
	
	
	var code = "";

	for (var i=1; i<4; i++)
	{
		if      (eval("lv"+i+" < 0"))  {code += "m";}
		else if (eval("lv"+i+" == 0")) {code += "z";}
		else if (eval("lv"+i+" > 0"))  {code += "p";}
	}

	var code_top  = code.substr(0,2);
	var code_side = code.substr(0,1)+code.substr(2,1);

	//console.log(code+' '+code_top+' '+code_side);

	// Si le code de bras de levier primaire a changé
	//if (code_top != window['lv'+target+'_code_top'] || (target == 2 && HEADING.lever_arms_letter != letter))
	{
		window['lv'+target+'_code_top'] = ''+code_top;

		var x,y;

		var x0 = 106;
		var y0 = 182;
		var Dx = 42;
		var dx = (img1rot==0) ? 0 : 12;
		var Dy = 50;
		var dy = (img1rot==0) ? 0 : 11;
		
		if( GIWIK._plugins.mechanical.frame_convention 	=== 'front_right_down' )
		{
			switch (code_top)
			{
				case 'pp': x = x0+Dx-dx;  	y = y0-Dy-dy;	break; 
				case 'pm': x = x0-Dx-dx; 	y = y0-Dy+dy;	break; 
				case 'pz': x = x0-dx;  		y = y0-Dy;		break; 
				case 'mp': x = x0+Dx+dx;  	y = y0+Dy-dy;	break;
				case 'mm': x = x0-Dx+dx; 	y = y0+Dy+dy;	break;
				case 'mz': x = x0+dx; 		y = y0+Dy;		break;
				case 'zp': x = x0+Dx;  		y = y0-dy;		break; 
				case 'zm': x = x0-Dx; 		y = y0+dy;		break; 
				case 'zz': x = x0; 			y = y0;			break;
			}	
		}
		else
		{
			switch (code_top)
			{
				case 'pp': x = x0-Dx-dx;  	y = y0-Dy+dy;	break; 
				case 'pm': x = x0+Dx-dx; 	y = y0-Dy-dy;	break; 
				case 'pz': x = x0-dx;  		y = y0-Dy;		break; 
				case 'mp': x = x0-Dx+dx;  	y = y0+Dy+dy;	break;
				case 'mm': x = x0+Dx+dx; 	y = y0+Dy-dy;	break;
				case 'mz': x = x0+dx; 		y = y0+Dy;		break;
				case 'zp': x = x0-Dx;  		y = y0+dy;		break; 
				case 'zm': x = x0+Dx; 		y = y0-dy;		break; 
				case 'zz': x = x0; 			y = y0;			break;
			}	
		}		

		// On ajuste la position de la croix pour certains cas :
		// pour l'illustration du bateau avec repère CRP		
		switch(GIWIK.vehicule_type)
		{
			// pour l'illustration du bateau avec repère CRP
			case 'boat': 	
				if(GIWIK._plugins.lever_arms.origin) 
																y -= 5;		break;
			// pour l'avion
			case 'plane':	x -= GIWIK._context.webkit ? 4 : 3; y -= 20;	break;					
			// pour le rov
			case 'rov':		x -= 8; 							y += 4;		break;
			// pour l'auv			
			case 'auv':		x -= 8; 							y += 4;		break;
			// pour la jeep
			case 'jeep':	x -= 38; 							y -= 34;	break;
			// pour la fusée
			case 'rocket':	x -= GIWIK._context.webkit ? 4 : 3; y -= 20;	break;	
		}
			
		// On ajuste la position verticale de la croix en fonction du navigateur
		if      (GIWIK._context.ie < 9) {x -= 1;}
		else if (GIWIK._context.webkit) {y += 1;}
		else if (GIWIK._context.opera)  {x -= 1; y += 10;}
			

		// Construction du système
		if( target==0 )
		{
			// Image système
			$('#leverarms'+target+'_syst1').css({
				'background' : "no-repeat 0 -1px url("+GIWIK.directories.img_lva+"/system.gif)",
				'transform-origin': '20px 20px'
				
			});	

			// Rotation
			$('#leverarms'+target+'_syst1').velocity('stop').velocity({'rotateZ': img1rot+'deg'});

			// Animation image selon LVA
			$('#leverarms'+target+'_syst1').animate({left:x-10,top:y-16});
		}
		// Ou de la croix
		else 
		{
			// Affichage croix
			if ($('#leverarms'+target+'_cross1').html() == ''){
				$('#leverarms'+target+'_cross1').html('<div>&#215;</div>'/*×*/);
			}
			
			// Animation de la croix selon LVA
			$('#leverarms'+target+'_cross1 div').animate({left:x,top:y});
		}
		

		// Pour les bras de levier secondaires on affiche la lettre
		if (target == 2)
		{
			if ($('#leverarms'+target+'_crossletter1').html() == '')
			{
				$('#leverarms'+target+'_crossletter1').html('<div>'+letter+'</div>');
			}
			$('#leverarms'+target+'_crossletter1>div').html(letter);
			$('#leverarms'+target+'_crossletter1>div').animate({left:x-20,top:y-20});
		}
	}

	//if (code_side != window['lv'+target+'_code_side'] || (target == 2 && HEADING.lever_arms_letter != letter))
	{
		window['lv'+target+'_code_side'] = code_side;

		var x,y;
	
		var x0 = 68;
		var y0 = 138;
		var Dx = 42;
		var dx = (img2rot==0) ? 0 : 14;
		var Dy = 50;
		var dy = (img2rot==0) ? 0 : 13;

		if( GIWIK._plugins.mechanical.frame_convention 	=== 'front_right_down' )
		{		
			switch (code_side)
			{
				case 'pp': x = x0+Dx+dx;  	y = y0+Dy-dy;	break; 
				case 'pm': x = x0+Dx-dx; 	y = y0-Dy-dy;	break; 
				case 'pz': x = x0+Dx;  		y = y0-dy;		break; 
				case 'mp': x = x0-Dx+dx;  	y = y0+Dy+dy;	break;
				case 'mm': x = x0-Dx-dx; 	y = y0-Dy+dy;	break;
				case 'mz': x = x0-Dx; 		y = y0+dy;		break;
				case 'zp': x = x0+dx;  		y = y0+Dy;		break; 
				case 'zm': x = x0-dx; 		y = y0-Dy;		break; 
				case 'zz': x = x0; 			y = y0;			break;
			}	
		}
		else{
			switch (code_side)
			{
				case 'pp': x = x0+Dx-dx;  	y = y0-Dy-dy;	break; 
				case 'pm': x = x0+Dx+dx; 	y = y0+Dy-dy;	break; 
				case 'pz': x = x0+Dx;  		y = y0-dy;		break; 
				case 'mp': x = x0-Dx-dx;  	y = y0-Dy+dy;	break;
				case 'mm': x = x0-Dx+dx; 	y = y0+Dy+dy;	break;
				case 'mz': x = x0-Dx; 		y = y0+dy;		break;
				case 'zp': x = x0-dx;  		y = y0-Dy;		break; 
				case 'zm': x = x0+dx; 		y = y0+Dy;		break; 
				case 'zz': x = x0; 			y = y0;			break;
			}			

		}		

		// On ajuste la position verticale de la croix pour certains cas :
	// pour l'illustration de la voiture,
		switch(GIWIK.vehicule_type){
			// pour l'illustration de la voiture,				
			case 'car': 				y -= 26;	break;
			// pour l'illustration du bateau avec repère CRP				
			case 'boat': 	
				if(GIWIK._plugins.lever_arms.origin) 
										y += 24;	break;
			// pour l'avion										
			case 'plane':	x += 13; 	y -= 21;	break;
			// pour le rov				
			case 'rov':		x += 14; 	y -= 38;	break;
			// pour l'auv
			case 'auv':		x += 14; 	y -= 38;	break;
			// pour la jeep
			case 'jeep':	x += 15; 	y -= 79;	break;
			// pour la fusée									
			case 'rocket':	x += 13; 	y -= 21;	break;
		}		

		// On ajuste la position de la croix en fonction du navigateur
		if      (GIWIK._context.ie < 9) {x += 0;}
		else if (GIWIK._context.webkit) {y += 1;}
		else if (GIWIK._context.opera)  {x += 0; y += 9;}
			
		// Construction du système
		if( target==0 )
		{
			// Image système
			$('#leverarms'+target+'_syst2').css({
				'background' : "no-repeat 0 -1px url("+GIWIK.directories.img_lva+"/system.gif)",
				'transform-origin': '18px 10px'
				
			});	
		
			// Rotation
			$('#leverarms'+target+'_syst2').velocity('stop').velocity({'rotateZ': img2rot+'deg'});
		
			// Animation image selon LVA
			$('#leverarms'+target+'_syst2').animate({left:x-10,top:y-18});
		}
		// Ou de la croix
		else 
		{
			// Affichage croix
			if ($('#leverarms'+target+'_cross2').html() == ''){
				$('#leverarms'+target+'_cross2').html('<div>&#215;</div>'/*×*/);
			}
			
			// Animation de la croix selon LVA
			$('#leverarms'+target+'_cross2 div').animate({left:x,top:y});
		}
		

		// Pour les bras de levier secondaires on affiche la lettre
		if (target == 2)
		{
			if ($('#leverarms'+target+'_crossletter2').html() == ''){
				$('#leverarms'+target+'_crossletter2').html('<div>'+letter+'</div>');
			}
			$('#leverarms'+target+'_crossletter2>div').html(letter);
			$('#leverarms'+target+'_crossletter2>div').animate({left:x-20,top:y-20});
		}
	}

	if (target == 2)
	{
		HEADING.lever_arms_letter = letter;
	}

	
	
	// Ajout des labels des origines
	if (GIWIK._plugins.lever_arms.origin)
	{
		// Label associé à l'origine des axes ("CRP" par défaut)
		var crp_label = (typeof GIWIK._plugins.lever_arms.origin == 'string') ? GIWIK._plugins.lever_arms.origin : "CRP";

		$('.leverarms'+target+'_img1').append('<div class="leverarms_origin1">'+crp_label+'</div>');
		$('.leverarms'+target+'_img2').append('<div class="leverarms_origin2">'+crp_label+'</div>');

		$('.leverarms_origin1,.leverarms_origin2').css({
			'position':'absolute',
			'font':'normal 12px Blair',
			'color':'rgb(228,35,34)',
			'text-shadow': '0px 0px 5px '+GIWIK.css.color_background
		});

		$('.leverarms_origin1').css({
			'margin-top':'183px',
			'margin-left':'118px'
		});

		$('.leverarms_origin2').css({
			'margin-top':'168px',
			'text-align':'right',
			'width':'70px'
		});
	}

	$('.leverarms_cross1,.leverarms_crossletter1').css('width', GIWIK.lva_top_width);

	$('.leverarms'+target+'_img2').css({
		'background' : "no-repeat "+GIWIK.lva_side_bgpos_left+" center url("+GIWIK.directories.img_lva+"/"+vehicule_suffix+"_side"+crp_suffix+GIWIK.css.night_suffix+".gif)",
		'width' : GIWIK.lva_side_width
	});

	$('.leverarms_cross2,.leverarms_crossletter2').css('width', GIWIK.lva_side_width);
	//-------------------------------------------------------------------------------------------------------------------------------------------------------------------
};

HEADING.construct._plugins.lever_arms = function ()
{
	GIWIK.lva_top_width       = ((GIWIK.vehicule_type == 'plane') || (GIWIK.vehicule_type == 'rocket')) ? '218px' : '178px';
	GIWIK.lva_side_width      = ((GIWIK.vehicule_type == 'plane') || (GIWIK.vehicule_type == 'rocket')) ? '218px' : '258px';
	GIWIK.lva_side_bgpos_left = ((GIWIK.vehicule_type == 'plane') || (GIWIK.vehicule_type == 'rocket')) ? '5px'   : '18px';
};