// PLUGIN INPUT MATRIX

GIWIK.init.js(['css','msg'], 'matrix');


// Déclaration des fonctions dépendant de la réponse du serveur
GIWIK.init.plugins.matrix = function ()
{
	if (typeof GIWIK._plugins.matrix._object_names      != 'object') {GIWIK._plugins.matrix._object_names      = {};                }
	if (typeof GIWIK._plugins.matrix._object_names.rows != 'string') {GIWIK._plugins.matrix._object_names.rows = 'Menu_matrix_rows';}
	if (typeof GIWIK._plugins.matrix._object_names.cols != 'string') {GIWIK._plugins.matrix._object_names.cols = 'Menu_matrix_cols';}

	// Si la matrice est en mode "gestion des associations port/capteur"
	if (GIWIK._plugins.matrix.inputs_exts)
	{
		// NOTE PRIMORDIALE : Le cochage ET les protocoles doivent être transversaux TOUS LES DEUX car ils sont interdépendants !!!!

		HEADING.getIProConf = function ()
		{
			// Actualisation du tableau d'affectation protocole<->port
			var port,i;

			for (i in GIWIK._input_ports)
			{
				port = GIWIK._input_ports[i];

				// Récupération de l'index du protocole en fonction du mode de communication CGI (PortConfI ou PortConf)
				if (!in_array(port,['X','R','CAN']))
				{
					window._ipro_port[port] = (eval("typeof window[system].PortConfI"+port+" == 'object'"))
											? eval("window[system].PortConfI"+port+"[1]")
											: eval("window[system].PortConf"+port+"[5]");
				}
			}
		};

		// Construction de la liste AVANT filtrage par updateProtocols() (au chargement de la page)
		HEADING.constructProtocolsList = function ()
		{
			// Construction de la liste des protocoles en fonction des capteurs disponibles pour le produit
			window._input_protocols = [];
			window._input_protocols['0'] = window[system].IProList[0]; // quotes car autrement 0 n'est pas pris en compte !

			var ext_s_cgisyntax,
				protocol_index,
				index, name, i;

			// Si le tableau des index des protocoles n'est pas défini, on considère que les index correspondent exactement à ceux de IProList
			// (IProList peut être définit sous forme de tableau ou d'objet si les index sont dans le désordre)
			if (typeof window[system].IProNum != 'object')
			{
				window[system].IProNum = array_keys(window[system].IProList);
			}

			// Si le flag d'affichage de tous les protocoles par défaut est défini à true
			if (GIWIK._plugins.matrix.all_protocols_by_default)
			{
				for (i in window[system].IProList)
				{
					index = window[system].IProNum[i];
					name  = window[system].IProList[i];
					window._input_protocols[index] = name;
				}
			}
			// Par défaut on affiche uniquement les protocoles disponibles pour les capteurs externes définis dans GIWIK._ext_sensors
			else
			{
				for (var ext_s in GIWIK._ext_sensors)
				{
					// Récupération de la syntaxe CGI du capteur
					ext_s_cgisyntax = GIWIK._extsensors_fulllist_cgisyntax[array_search(ext_s, GIWIK._extsensors_fulllist)];

					for (var i in window[system]['IProNum_'+ext_s_cgisyntax])
					{
						protocol_index = window[system]['IProNum_'+ext_s_cgisyntax][i];

						if (!array_key_exists(protocol_index, window._input_protocols))
						{
							window._input_protocols[protocol_index] = window[system].IProList[array_search(protocol_index, window[system].IProNum)];
						}
					}
				}
			}

			if (!HEADING.init.isdone)
			{
				var _num,
					_list;

				// Si tri alphabéthique des protocoles
				if (HEADING.sort_protocols)
				{
					var _protocols_sorted = GIWIK.sort_protocol_labels_and_indexes(array_keys(window._input_protocols), array_values(window._input_protocols), true);
					_num  = _protocols_sorted['_num'];
					_list = _protocols_sorted['_list'];

					_protocols_sorted = null;
				}
				else
				{
					_num  = array_keys(window._input_protocols);
					_list = array_values(window._input_protocols);
				}

				// PROTOCOLE (pas concerné par le HEADING.current_port_settings_changed mais fait passer window.settings_modified_unload à true car n'étant pas concerné par window.settings_modified=true, il faut window.settings_modified_unload=true pour activer le garde fou d'unload)
				window.Select_IPro = new Input_select('Select_IPro', true);
				window.Select_IPro.label_width = window.heading_labels_width;
				window.Select_IPro.construct('select_ipro','linear',MSG(['parameters','protocol']),_num,_list,'',true);
				window.Select_IPro.setAction("/*HEADING.association_changed = true;*/ HEADING.current_port_settings_changed = true; window._ipro_port[window.current_port]=window.Select_IPro.getValue(); HEADING.updateProtocols();", true);
				window.Select_IPro.show();

				_num = null;
				_list = null;
			}

			// alert(print_r(window._input_protocols));
		};

		HEADING.updateProtocols = function ()
		{
			//alert("UpdateProtocols()");

			// 1 - Actualisation des labels des protocoles
			// 2 - Actualisation de la couleur d'arrière plan des cellules pour indiquer la compatibilité du capteur avec le protocole du port
			var port,
				port_index,
				id_cell,
				ipro_port_label,
				ipro_port_index,
				ext_s_index,
				ext_sensor_cgisyntax,
				ipi;

			for (var i in GIWIK._input_ports)
			{
				port = GIWIK._input_ports[i];
				port_index = parseFloat(i)+1;

				ipi = (!in_array(port,['X','R','CAN'])) ? window._ipro_port[port] : 0;

				// Actualisation du label du protocole du port
				ipro_port_label = (in_array(port,['X','R','CAN'])) ? MSG(['shared','n_a']) : window._input_protocols[ipi]; //if (port == window.current_port){alert(window._ipro_port[port]+'->'+ipro_port_label);}
				GIWIK.write("ipro"+port+"_label", ipro_port_label);

				for (var ext_s in GIWIK._ext_sensors)
				{
					id_cell = 'row-'+ext_s+'_col-'+port_index;

					ext_s_index = array_search(ext_s, GIWIK._extsensors_fulllist);

					ext_sensor_cgisyntax = GIWIK._extsensors_fulllist_cgisyntax[array_search(ext_s, GIWIK._extsensors_fulllist)];
					//alert(window._ipro_port[port]+' \n'+eval("window[system].IProNum_"+ext_sensor_cgisyntax));
					// Si le protocole est à none ou si le protocole est compatible avec le capteur externe
					if (window._ipro_port[port] == 0 || in_array(window._ipro_port[port], eval("window[system].IProNum_"+ext_sensor_cgisyntax))||in_array(port,['X','R','CAN']))
					{
						document.getElementById(id_cell).style.backgroundImage = "";
						//document.getElementById(id_cell).style.backgroundColor = "transparent";
					}
					else
					{
						document.getElementById(id_cell).style.backgroundImage = "url("+GIWIK.directories.img+"/bg_not_checkable"+GIWIK.css.night_suffix+".gif)";
						//document.getElementById(id_cell).style.backgroundColor = "red";
					}
				}
			}

			if (HEADING.init.isdone)
			{
				// Construction des listes dynamiques de protocoles pour chaque port
				var port = null,
					port_index = null,
					ext_s = null,
					ext_sensor_cgisyntax = null,
					_ext_protocols_index = null;

				for (var i in GIWIK._input_ports)
				{
					port = GIWIK._input_ports[i];
					port_index = parseFloat(i)+1;

					window._dynamic_ipro_lists[port] = [];
					window._dynamic_ipro_lists_labels[port] = [];

					// Construction dynamiques des couples index/label des protocoles

					// Si aucun capteur d'associé, tous les protocoles sont possibles
					if (window._exts_port[port].length === 0)
					{//alert('port'+port);
						window._dynamic_ipro_lists[port] = array_keys(window._input_protocols);
						window._dynamic_ipro_lists_labels[port] = array_values(window._input_protocols);
					}
					else
					{
						//alert(window._exts_port[port]);
						for (var i=0; i<window._exts_port[port].length; i++)
						{
							ext_s = window._exts_port[port][i];

							ext_sensor_cgisyntax = GIWIK._extsensors_fulllist_cgisyntax[array_search(ext_s, GIWIK._extsensors_fulllist)];
							_ext_protocols_index = eval("window[system].IProNum_"+ext_sensor_cgisyntax);
							//alert(_ext_protocols_index);
							if (!in_array(0, _ext_protocols_index)){_ext_protocols_index.unshift(0);}

							if (i === 0)
							{
								window._dynamic_ipro_lists[port] = _ext_protocols_index;
							}
							else
							{
								window._dynamic_ipro_lists[port] = array_intersect(window._dynamic_ipro_lists[port], _ext_protocols_index);
							}
						}
						//alert(window._dynamic_ipro_lists[port]);
						var ipro_index = null;


						// Construction des listes dynamiques de labels des protocoles
						for (var j in window._dynamic_ipro_lists[port])
						{
							ipro_index = window._dynamic_ipro_lists[port][j]; //alert('ipro_index :'+ ipro_index);

							window._dynamic_ipro_lists_labels[port].push(window._input_protocols[ipro_index]);
						}
					}

				       //if (port == window.current_port){ alert(window._dynamic_ipro_lists[port].join('\n')+'\n\n'+window._dynamic_ipro_lists_labels[port].join('\n'));}
				}

				//alert(window._ipro_port[window.current_port]+'\n'+window._dynamic_ipro_lists[window.current_port]);

				if (window.current_port !== undefined)
				{
					// Définition de la valeur du select (NONE si le protocole choisi n'est pas compatible avec la combinaison capteurs/port
					if (!in_array(window._ipro_port[window.current_port], window._dynamic_ipro_lists[window.current_port]))
					{
						window._ipro_port[window.current_port] = 0;

						HEADING.current_port_settings_changed = true;

						// On met à jour les protocols comme lors d'un "onchange" du menu de sélection du protocol
						HEADING.updateProtocols();

						return;
					}
				}

				if (window[GIWIK._plugins.matrix._object_names.cols].getValue() !== undefined)
				{
					var _num,
						_list;

					// Si tri alphabéthique des protocoles
					if (HEADING.sort_protocols)
					{
						var _protocols_sorted = GIWIK.sort_protocol_labels_and_indexes(window._dynamic_ipro_lists[window.current_port], window._dynamic_ipro_lists_labels[window.current_port], true);
						_num  = _protocols_sorted['_num'];
						_list = _protocols_sorted['_list'];

						_protocols_sorted = null;
					}
					else
					{
						_num  = window._dynamic_ipro_lists[window.current_port];
						_list = window._dynamic_ipro_lists_labels[window.current_port];
					}

					// Mise à jour du select ipro (liste de protocoles et éventuellement protocol sélectionné) //////////////////////////////////////////////////////////////////////////
					window.Select_IPro.setList(_num, _list);
					window.Select_IPro.setValue(window._ipro_port[window.current_port], 'no_action');

					_num = null;
					_list = null;
				}
			}
		};

		HEADING.updateInputsTable = function (onclick_id_cell)
		{
			//alert("UpdateInputsTable("+onclick_id_cell+")"); //\n\n"+HEADING.updateInputsTable.caller

			var ext_s_clicked = null;

			// Cas d'un clic sur une cellule du tableau
			if (onclick_id_cell)
			{
				var _split = onclick_id_cell.split("_");

				ext_s_clicked = _split[0].replace(/^row-/,'');
				var cell_port_index = _split[1].replace(/^col-/,'');
				var css;

				// La cellule se coche
				if (GIWIK.css.getClass(onclick_id_cell).indexOf('cell_unchecked') != -1)
				{
					//alert('cochage');

					// Gestion du cochage de toutes les cellules de la ligne du capteur
					for (var i in GIWIK._input_ports)
					{
						port_index = parseFloat(i)+1;

						// Seule la cellule correspondant au port sélectionné est cochée
						css = (port_index == cell_port_index) ? 'cell_checked' : 'cell_unchecked';

						GIWIK.css.setClass('row-'+ext_s_clicked+'_col-'+port_index, css);
					}
				}
				// La cellule se décoche
				else
				{
					//alert('décochage');
					GIWIK.css.setClass(onclick_id_cell, 'cell_unchecked');
				}

				_split = null;
				cell_port_index = null;
				css = null;
				ext_s_clicked = null;
			}
			else
			{
				// Lecture de la conf d'association capteur/port pour le cochage des cases
				var port,
					port_index,
					id_cell,
					ext_s_index,
					ext_s_code,
					ext_s_port,
					cell_checked   = "GIWIK.css.setClass(id_cell, 'cell_checked');",
					cell_unchecked = "GIWIK.css.setClass(id_cell, 'cell_unchecked');";


				// Pour les IHM utilisant le paramètre "DeviceConfI"
				if (typeof window[system].DeviceConfIA == 'object')
				{
					// Initialisation du tableau associatif capteur externe <-> port
					window._ext_sensors_to_input_ports = new Array();

					// Construction du tableau
					for (var ext_s in GIWIK._ext_sensors)
					{
						// Récupération de l'index CGI du capteur externe
						ext_s_code = GIWIK._extsensors_fulllist_indexes[array_search(ext_s, GIWIK._extsensors_fulllist)];

						for (var i in GIWIK._input_ports)
						{
							port = GIWIK._input_ports[i];
							port_index = parseFloat(i)+1;

							// Si le capteur est associé à ce port, on renseigne le tableau et on casse la boucle
							if (in_array(ext_s_code,eval("window[system].DeviceConfI"+port)))
							{
								window._ext_sensors_to_input_ports[ext_s] = port_index;
								break;
							}
							// S'il s'agit du dernier input on marque que le capteur n'est associé à aucun port
							else if (i == (count(GIWIK._input_ports)-1))
							{
								window._ext_sensors_to_input_ports[ext_s] = 0;
							}
						}
					}
					//alert(print_r(window._ext_sensors_to_input_ports));
				}

				for (var i in GIWIK._input_ports)
				{
					port = GIWIK._input_ports[i];
					port_index = parseFloat(i)+1;

					window._exts_port[port] = new Array();

					// Actualisation de l'affectation des capteurs externes aux ports d'entrée
					for (var ext_s in GIWIK._ext_sensors)
					{
						id_cell = 'row-'+ext_s+'_col-'+port_index;

						// Pour les IHM utilisant le paramètre "DeviceConfI"
						if (typeof window[system].DeviceConfIA == 'object')
						{
							if (window._ext_sensors_to_input_ports[ext_s] == port_index)
							{
								eval(cell_checked);
							}
							else
							{
								eval(cell_unchecked);
							}
						}
						else
						{
							ext_s_index = array_search(ext_s, GIWIK._extsensors_fulllist);

							if (window[system].ExtSToSerial[ext_s_index] == GIWIK._input_ports_index[i])
							{
								eval(cell_checked);

							}
							else
							{
								eval(cell_unchecked);
							}
						}
					}
				}

				port = null;
				port_index = null;
				id_cell = null;
				ext_s_index = null;
			}


			// Construction du tableau window._exts_port[port] listant les capteurs aux ports (utile pour la définition dynamique des protocoles dispos pour un port)
			for (var i in GIWIK._input_ports)
			{
				port = GIWIK._input_ports[i];
				port_index = parseFloat(i)+1;

				window._exts_port[port] = [];

				// Actualisation de l'affectation des capteurs externes aux ports d'entrée
				for (var ext_s in GIWIK._ext_sensors)
				{
					id_cell = 'row-'+ext_s+'_col-'+port_index;

					if (GIWIK.css.getClass(id_cell).indexOf('cell_checked') != -1)
					{
						window._exts_port[port].push(ext_s);
					}
				}
			}
			port = null;
			port_index = null;
			id_cell = null;


			// S'il s'agit d'un clic sur une cellule et qu'aucun capteur n'est associé au port, on masque les paramètres du port et des capteurs externes
			if (onclick_id_cell)
			{
				var n = 0;
				for (var i in GIWIK._input_ports)
				{
					if (window._exts_port[GIWIK._input_ports[i]].length > 0){n++;}
				}

				if (n == 0)
				{
					window[GIWIK._plugins.matrix._object_names.cols].setValue();
					window[GIWIK._plugins.matrix._object_names.rows].setValue();
				}
			}

			HEADING.updateProtocols();
		};

		HEADING.setSettingsModified = function (already_confirmed)
		{
			if (HEADING.init.isdone)
			{
				// Appel depuis Menu.setValue() : Si l'utilisateur vient de confirmer le changement d'affichage, on évite qu'il y ait un 2ème prompt lors de l'Initialization du 2ème Menu (port ou extsensor)
				if (already_confirmed)
				{
					//var msg = "already confirmed !";

					HEADING.current_port_settings_changed = false;
					HEADING.current_extsensor_settings_changed = false;

					window.settings_modified = false;
				}
				// On définit window.settings_modified en fonction du contexte pour éviter d'afficher des prompts superflus lors des Menu.setValue()
				else
				{
					//var msg = "HEADING.current_port_changed = "+HEADING.current_port_changed+"\nHEADING.current_port_settings_changed = "+HEADING.current_port_settings_changed+"\n\nHEADING.current_extsensor_changed = "+HEADING.current_extsensor_changed+"\nHEADING.current_extsensor_settings_changed = "+HEADING.current_extsensor_settings_changed+"\n\nHEADING.association_changed = "+HEADING.association_changed;

					if ((HEADING.current_port_settings_changed && HEADING.current_port_changed)
					 || (HEADING.current_extsensor_settings_changed && HEADING.current_extsensor_changed))
					{
						window.settings_modified = true;
					}
					else
					{
						window.settings_modified = false;
					}
				}

				//msg += "\n==================================\nwindow.settings_modified = "+window.settings_modified;
				//alert(msg);
			}
		};

		HEADING.displayParamGroups = function (mode)
		{
			if (!mode)
			{
				// Masquage du tuto si aucun port ni capteur externe sélectionné
				if (!(window[GIWIK._plugins.matrix._object_names.cols].getValue() === undefined && window[GIWIK._plugins.matrix._object_names.rows].getValue() === undefined))
				{
					// S'il s'agit du message tuto, on le masque
					if (window.Usermsg_inputs.getValue().match(/<div id="usermsg_tuto"/gi))
					{
						window.Usermsg_inputs.hide();
					}
					else
					{
				       window.Usermsg_inputs.element_path.style.borderBottom = 'solid 20px '+GIWIK.css.color_background; // Marge basse pour les messages de warning (il y a du contenu en dessous)  (border et pas margin ou padding car problème avec l'effet de slide)
					}
				}

				HEADING.displayParamGroups('port');
				return;
			}

			if (mode == 'port')
			{
				// Si un port est sélectionné, on affiche le groupe de paramètres correspondant

				if (window[GIWIK._plugins.matrix._object_names.cols].getValue() !== undefined && !in_array(window[GIWIK._plugins.matrix._object_names.cols].getValue(),['X','R']))
				{
					if (document.getElementById('port_conf').style.display != 'none')
					{
						document.getElementById('port_conf').style.display = 'block';
						HEADING.displayParamGroups('extsensor');
					}
					else
					{
						document.getElementById('port_conf').style.display = 'none';
						$('#port_conf').slideDown(200, function(){HEADING.displayParamGroups('extsensor');});
					}
				}
				else
				{
					$('#port_conf').slideUp(200, function(){HEADING.displayParamGroups('extsensor');});
				}
				return;
			}

			if (mode == 'extsensor')
			{
				// Affichage du séparateur si un port ET un capteur externe sont sélectionnés
				if (window[GIWIK._plugins.matrix._object_names.cols].getValue() !== undefined && window[GIWIK._plugins.matrix._object_names.rows].getValue() !== undefined)
				{
					GIWIK.css.setClass('inputs_params_separator', 'displayblock');
				}
				else
				{
					GIWIK.css.setClass('inputs_params_separator', 'displaynone');
				}

				// Si un capteur externe est sélectionné, on affiche le groupe de paramètres correspondant
				if (window[GIWIK._plugins.matrix._object_names.rows].getValue() !== undefined)
				{
					if (document.getElementById('extsensor_conf').style.display != 'none')
					{
						document.getElementById('extsensor_conf').style.display = 'block';
						HEADING.displayParamGroups('last');
					}
					else
					{
						document.getElementById('extsensor_conf').style.display = 'none';
						$('#extsensor_conf').slideDown(200, function(){HEADING.displayParamGroups('last');});
					}
				}
				else
				{
					$('#extsensor_conf').slideUp(200, function(){setTimeout("HEADING.displayParamGroups('last');", 250);});
				}
				return;
			}

			if (mode == 'last')
			{
				// Affichage du tuto si aucun port ni capteur externe sélectionné
				if (window[GIWIK._plugins.matrix._object_names.cols].getValue() === undefined && window[GIWIK._plugins.matrix._object_names.rows].getValue() === undefined)
				{
					window.Usermsg_inputs.setValue(HEADING.tuto_msg)
					window.Usermsg_inputs.setStatus(1,false)
					window.Usermsg_inputs.show();
				}
			}
		};

		HEADING.readConf._plugins.matrix = function ()
		{
			if (!HEADING.init.isdone)
			{
				HEADING.constructProtocolsList();
			}

			if (!HEADING.init.isdone || HEADING.cancel_conf || HEADING.send_conf)
			{
				HEADING.getIProConf();
				HEADING.updateInputsTable();
			}
			else if (HEADING.current_port_changed)
			{
				HEADING.updateProtocols();
			}
		};

		// Exécuté à la tute fin du readConf, APRÈS readConf.local (c'est pourquoi la fonction ne se trouve pas dans "readConf._plugins")
		HEADING.readConf.afterLocal = function ()
		{
			// Si la matrice est verouillée
			if (GIWIK._plugins.matrix.locked)
			{
				// Les cellules non cochées n'étant pas clicables, on applique un curseur par défaut
				$('div.cell_unchecked').each(function(i){$(this).css('cursor','default');});
			}

			// Gestion de l'affichage de l'adresse IP en fonction de la couche de transport
			HEADING.showHideIP();

			// Gestion de l'affichage des groupes de paramètres (port et/ou capteur externe)
			HEADING.displayParamGroups();

			// Remise à false de tous les flags sauf celui qui est tranversal :
			HEADING.current_port_changed = false;
			HEADING.current_port_settings_changed = false;
			HEADING.current_extsensor_changed = false;
			HEADING.current_extsensor_settings_changed = false;

			HEADING.cancel_conf = false;
			HEADING.send_conf = false;
		};

		HEADING.onClickCell_specific = function (id_cell, port, ext_s)
		{
			HEADING.current_port_changed = true;
			HEADING.current_extsensor_changed = true;

			// Actualisation des variable du port en cours et du capteur externe en cours
			eval(window[GIWIK._plugins.matrix._object_names.cols].raw_action + window[GIWIK._plugins.matrix._object_names.rows].raw_action);

			// Si la matrice n'est pas verouillée
			if (!GIWIK._plugins.matrix.locked)
			{
				window.settings_modified_unload = true;		// Pour activer le garde fou lors de l'unload de la page
				HEADING.association_changed = true;			// Indique que le tableau des associations a changé

				// Mise à jour du tableau (cochage + protocoles)
				HEADING.updateInputsTable(id_cell);
			}

			HEADING.getConf();
		};

		// Affectation de l'action spécifique au clic sur une cellule
		if (typeof GIWIK._plugins.matrix.cell_click_action == 'undefined')
		{
			GIWIK._plugins.matrix.cell_click_action = HEADING.onClickCell_specific;
		}
	}
};

HEADING.onClickCell = function (id_cell, id_col, id_row)
{
	// Activation des items correpondants à la cellule active
	window[GIWIK._plugins.matrix._object_names.cols].setValue(id_col, 'no_action');
	window[GIWIK._plugins.matrix._object_names.rows].setValue(id_row, 'no_action');

	// Gestion de la surbrillance de la cellule courante
	HEADING.highlightCell(id_cell);

	var action = GIWIK._plugins.matrix.cell_click_action;

	// Si une action spécifique a été définie
	switch (typeof action)
	{
		case 'function' : action(id_cell, id_col, id_row); break;
		case 'string'   : eval(action);					   break;
	}

};

// Mise en surbrillance d'une cellule
HEADING.highlightCell = function (id_cell)
{
	// Suppression d'éventuelles surbrillances précédentes
	$('.cell_checked,.cell_unchecked').css('background-color','');

	// Si un id est passé, la cellule est mise en surbrillance
	if (typeof id_cell == 'string')
	{
		$('#'+id_cell).css('background-color',GIWIK.css.color_input_cells_over);
	}
};

// COnstruction des cellules de la matrice
HEADING.constructCells = function ()
{
	var tab_content = '',
		id_cell = '',
		col_index,
		onclick_action,
		i,j,
		row,
		col,
		_rows = window[GIWIK._plugins.matrix._object_names.rows].getList()._values,
		_cols = window[GIWIK._plugins.matrix._object_names.cols].getList()._values;

	tab_content += '<table id="tab_matrix2">';


	for (j in _rows)
	{
		row = _rows[j];

		tab_content += '<tr id="row-'+j+'">';

		for (i in _cols)
		{
			col = _cols[i];
			col_index = parseFloat(i)+1;

			if (i == 0) {tab_content += '<td class="v_sep"></td>';}

			id_cell = 'row-'+row+'_col-'+col_index;

			tab_content += '<td class="dat">'
				+ '<div id="'+id_cell+'" class="cell_unchecked" onclick="HEADING.onClickCell(\''+id_cell+'\', '+((typeof col == 'string') ? '\''+col+'\'' : col)+', '+((typeof row == 'string') ? '\''+row+'\'' : row)+');">'
					+ '<div></div>'
				+ '</div>' /*&#9679; ●*/
			+ '</td>'
			+ '<td class="v_sep"></td>';
		}

		tab_content += '</tr>'

		// on ajoute le séparateur horizontal
		+ '<tr><td colspan="'+(_cols.length*2+1)+'" class="h_sep"></td></tr>';
	}

	tab_content += '</table>'

	+ '<div id="mask_tab_matrix"></div>'
	+ '<div id="table_separator"></div>';

	GIWIK.write('tab_input_ctnr', tab_content);


	// construction des intitulés des colonnes (même la matrice standard en a besoin pour l'alignement des items de l'objet Menu_cols avec les cellules --------------

	// Listes des protocoles de chacun des ports
	var ipro_content = '',
		port = '',
		id_ipro_label = '',
		id_select_ipro = '',
		id_select_ipro_ctnr = '',
		i,
		_ports = window[GIWIK._plugins.matrix._object_names.cols].getList()._values;

	ipro_content += '<table id="tab_matrix"><tr>'
		+ '<td valign="top">'
				+ '<div class="inputs_proto_separator"></div>'
			+ '</td>';

	for (i in _ports)
	{
		port = _ports[i];
		id_ipro_label = 'ipro'+port+'_label';
		id_select_ipro = 'select_ipro'+port;
		id_select_ipro_ctnr = id_select_ipro+'_ctnr';

		ipro_content += '<td valign="top" class="proto">'
			+ '<div id="'+id_ipro_label+'" class="protocol_label" onmouseover="if (window[GIWIK._plugins.matrix._object_names.cols].getValue() != \''+port+'\'){document.getElementById(\''+window[GIWIK._plugins.matrix._object_names.cols].idelem+i+'\').style.color=\''+GIWIK.css.color_1+'\';}" onmouseout="document.getElementById(\''+window[GIWIK._plugins.matrix._object_names.cols].idelem+i+'\').style.color=\'\';" onclick="document.getElementById(\''+window[GIWIK._plugins.matrix._object_names.cols].idelem+i+'\').style.color=\'\';window[GIWIK._plugins.matrix._object_names.cols].setValue(\''+port+'\')"></div>'
		+ '</td>'

		+ '<td valign="top">'
			+ '<div class="inputs_proto_separator"></div>'
		+ '</td>';
	}

	ipro_content += '</tr></table>'

	+ '<div id="mask_tab_matrix_label"></div>';

	GIWIK.write('ipro_ctnr', ipro_content);

	// Matrice polyvalente (non orientée port/capteur)
	if (!GIWIK._plugins.matrix.inputs_exts)
	{
		// Masquage de la ligne "protocoles"
		$('#matrix_ctnr table tr:nth-child(2) td div').css({'height':0});

		// Masquage des éléments liés à la gestion des entrées/capteurs
		$('#mask_tab_matrix_label,#inputs_protocol_title,#port_conf,#table_separator').hide();

		// Marge entre l'objet Menu horizontal et la matrice
		$('#menu_port_table').css('padding-bottom','5px');
	}

	if (HEADING.init.isdone)
	{
		this.display();
	}
};


HEADING.display._plugins.matrix = function ()
{
	// Pour le centrage horizontal de la matrice quand sa taille dépasse le width max normalement autorisé pour la taille de fenêtre (> 5 ports comme pour ADVANS)
	$('#content').css({width:'auto'/*,'background':'red'*/});

	var css_full,
		port_item_width,
		extsensor_item_width,
		item_fontsize,
		protocol_fontsize,
		cell_width,
		num_cols = window[GIWIK._plugins.matrix._object_names.cols].options_number;

	// Affichage compact si forcé dans app.js ou que la place est insuffisante pour l'affichage large
	if (GIWIK._plugins.matrix.force_compact || (num_cols >= 5 && $(window).width() < (num_cols+1/*ordonnées*/)*105/*largeur d'une colonne*/))
	{
		css_full = '';
		port_item_width = 70;
		extsensor_item_width = 62;
		item_fontsize = '12px';
		protocol_fontsize = '11px';
	}
	// Affichage large
	else
	{
		css_full =  '_full';
		port_item_width = 100;
		extsensor_item_width = 70;
		item_fontsize = '13px';
		protocol_fontsize = '12px';
	}
	// if (num_cols < 5 || (num_cols === 5 && (GIWIK.window_size == 'full' || (GIWIK.window_size == 'medium' && !GIWIK.ihm_compactmode))))
	// {
	// 	css_full =  '_full';
	// 	port_item_width = 100;
	// 	extsensor_item_width = 70;
	// 	item_fontsize = '13px';
	// 	protocol_fontsize = '12px';
	// }
	// // Affichage compact
	// else
	// {
	// 	css_full = '';
	// 	port_item_width = 70;
	// 	extsensor_item_width = 62;
	// 	item_fontsize = '12px';
	// 	protocol_fontsize = '11px';
	// }

	window[GIWIK._plugins.matrix._object_names.cols].resize(port_item_width);
	window[GIWIK._plugins.matrix._object_names.rows].resize(extsensor_item_width);

	GIWIK.css.setClass('box_content', 'box_content');

	if (document.getElementById('tab_matrix'))
	{
		GIWIK.css.setClass('tab_matrix',  'tab_matrix'+css_full);
	}

	GIWIK.css.setClass('tab_matrix2', 'tab_matrix2'+css_full);

	// Adaptation de la taille de la police des items de la classe "Menu" en fonction de la taille de la fenêtre et du nombre de ports
	$('.objmenu0').css('font-size',item_fontsize);
	$('#inputs_protocol_title').css('font-size',protocol_fontsize);

	// Gestion de la taille des cellules et de l'objet Menu_matrix_cols pour les produits dotés de moins de 5 ports et ceux de 6 et + en mode "full" (et "medium")
	switch (num_cols)
	{
		case 2:  cell_width = 178; break;
		case 3:  cell_width = 118; break;
		case 4:  cell_width = 88;  break;
		default: cell_width = port_item_width; // 5 et +
	}

	$("td.proto div, td.dat").css('width',cell_width+4);

	window[GIWIK._plugins.matrix._object_names.cols].resize(cell_width);
};

HEADING.construct._plugins.matrix = function ()
{
	var rtn,		// objet à retourner si défini
		cnt = ''

	+'<div id="usermsg_conflicts" class="displaynone"></div>'

	+'<div id="matrix_ctnr">'

		+'<table>'
			+'<tr>'
				+'<td></td>'
				+'<td valign=top><div id="menu_port_table"></div></td>'
			+'</tr>'
			+'<tr>'
				+'<td align="center"><div id="inputs_protocol_title"></div><div id="mask_tab_matrix_protocol"></div></td>'
				+'<td valign="top"><div id="ipro_ctnr"></div></td>'
			+'</tr>'
			+'<tr>'
				+'<td valign=top><div id="menu_extsensor_table"></div></td>'
				+'<td valign=top align=right><div id="tab_input_ctnr"></div></td>'
			+'</tr>'
		+'</table>'


		+'<div id="usermsg_inputs" class="displaynone"></div>'


		+'<div id="port_conf" class="displaynone">'

			+'<div class="clearboth"></div>'


			+'<div id="params_menuport_label" class="inputs_params_label"></div>'

			+'<div id="params_protocol">'
				+'<table class="one_param_ctnr">'
					+'<tr>'
						+'<td align="left" class="inputs_params_padding">'
							+'<div id="select_ipro"></div>'
						+'</td>'
					+'</tr>'
				+'</table>'
			+'</div>'

			+'<div id="params_information" style="display:none"></div>'

			+'<div id="params_device">'
				+'<table class="one_param_ctnr">'
					+'<tr>'
						+'<td align="left" class="inputs_params_padding">'
							+'<div id="select_edirix"></div>'
						+'</td>'
					+'</tr>'
				+'</table>'
			+'</div>'

			+'<div id="params_timeout" style="display:none">'
				+'<table class="one_param_ctnr">'
					+'<tr>'
						+'<td align="left" class="inputs_params_padding">'
							+'<div id="input_timeout"></div>'
						+'</td>'
					+'</tr>'
				+'</table>'
			+'</div>'

			+'<div id="params_serial">'
				+'<table class="one_param_ctnr">'
					+'<tr>'
						+'<td align="left" class="inputs_params_padding">'
							+'<div id="select_port"></div>'
						+'</td>'
					+'</tr>'
					+'<tr>'
						+'<td align="left" class="inputs_params_padding">'
							+'<div id="select_parity"></div>'
						+'</td>'
					+'</tr>'
					+'<tr>'
						+'<td align="left" class="inputs_params_padding">'
							+'<div id="select_stopbits"></div>'
						+'</td>'
					+'</tr>'
					+'<tr>'
						+'<td align="left" class="inputs_params_padding">'
							+'<div id="select_level"></div>'
						+'</td>'
					+'</tr>'
					+'<tr>'
						+'<td align="left" class="inputs_params_padding">'
							+'<div id="select_baudrate"></div>'
						+'</td>'
					+'</tr>'
				+'</table>'
			+'</div>'

			+'<div id="params_ethernet">'
				+'<table class="one_param_ctnr">'
					+'<tr>'
						+'<td align="left" class="inputs_params_padding">'
							+'<div id="select_elcfix"></div>'
						+'</td>'
					+'</tr>'
					+'<tr>'
						+'<td align="left" class="inputs_params_padding">'
							+'<div id="ip_ctnr">'
								+'<table>'
									+'<tr>'
										+'<td><div id="input_ip_part1"></div></td>'
										+'<td class="param_ipdot">&bull;</td>'
										+'<td><div id="input_ip_part2"></div></td>'
										+'<td class="param_ipdot">&bull;</td>'
										+'<td><div id="input_ip_part3"></div></td>'
										+'<td class="param_ipdot">&bull;</td>'
										+'<td><div id="input_ip_part4"></div></td>'
									+'</tr>'
								+'</table>'
							+'</div>'
							+'<div id="input_ip_port"></div>'
						+'</td>'
					+'</tr>'
				+'</table>'
			+'</div>'

			+'<div id="params_sensorcontrol" style="display:none"></div>'
		+'</div>'


		+'<div id="inputs_params_separator" class="displaynone"><div class="inputs_params_separator"></div></div>'


		+'<div id="extsensor_conf" class="displaynone">'

			+'<div id="params_extsensor_label" class="inputs_params_label"></div>'

			+'<div id="params_extsensor_ctnr"></div>'

		+'</div>'

	+'</div>';


	// Construction de la boite
	$('#content').append(GIWIK.box(cnt, MSG(['box','input_extsensors_title']),true,[],['box_content']));

	var _cols_labels = [],
		_cols_values = [],
		_rows_labels = [],
		_rows_values = [];
		
	if (GIWIK._plugins.matrix.inputs_exts)
	{
		if (typeof GIWIK._input_ports == 'object')
		{
			for (var i in GIWIK._input_ports)
			{
				if (GIWIK._input_ports[i] == 'X' )
				{
					_cols_labels.push(MSG(['parameters','internal']));
				}
				else if (GIWIK._input_ports[i] == 'CAN' )
				{
					_cols_labels.push(MSG(['parameters','can']));
				}
				else if (GIWIK._input_ports[i] == 'R' )
				{
					_cols_labels.push(MSG(['parameters','repeater']));
				}
				else
				{
					_cols_labels.push(MSG(['parameters','input'])+' '+GIWIK._input_ports_label[i]);
				}
			}

			_cols_values = GIWIK._input_ports;
		}


		var _rows_labels = [],
			_rows_values = [];

		if (typeof GIWIK._ext_sensors == 'object')
		{
			_rows_values = array_keys(GIWIK._ext_sensors)

			for (var ext_sensor_id in GIWIK._ext_sensors)
			{
				_rows_labels.push(MSG(['ext_sensors',ext_sensor_id]));
			}
		}
	}

	// Menu de sélection du port
	window[GIWIK._plugins.matrix._object_names.cols] = new Menu(GIWIK._plugins.matrix._object_names.cols, true);
	window[GIWIK._plugins.matrix._object_names.cols].num_item_per_row = count(_cols_values);
	window[GIWIK._plugins.matrix._object_names.cols].construct('menu_port_table', 'horizontal', _cols_values, _cols_labels, false);
	window[GIWIK._plugins.matrix._object_names.cols].setAction(function () {window[GIWIK._plugins.matrix._object_names.rows].setValue(); HEADING.highlightCell();});
	window[GIWIK._plugins.matrix._object_names.cols].setValue();
	window[GIWIK._plugins.matrix._object_names.cols].show();

	// Menu de sélection du capteur externe
	window[GIWIK._plugins.matrix._object_names.rows] = new Menu(GIWIK._plugins.matrix._object_names.rows, true);
	window[GIWIK._plugins.matrix._object_names.rows].construct('menu_extsensor_table', 'vertical', _rows_values, _rows_labels, false, 62, 25);
	window[GIWIK._plugins.matrix._object_names.rows].setAction(function () {window[GIWIK._plugins.matrix._object_names.cols].setValue(); HEADING.highlightCell();});
	window[GIWIK._plugins.matrix._object_names.rows].setValue();
	window[GIWIK._plugins.matrix._object_names.rows].show();

	if (GIWIK._plugins.matrix.inputs_exts)
	{
		window[GIWIK._plugins.matrix._object_names.cols].raw_action = 'window.current_port=window[GIWIK._plugins.matrix._object_names.cols].getValue();'; // action sans la réinitialisation du menu ext sensor ni le getConf() (pour l'onclick sur une cellule du tableau qui doit activer une entrée dans chaque menu)
		window[GIWIK._plugins.matrix._object_names.cols].setActionBefore('HEADING.current_port_changed = true; if (window[GIWIK._plugins.matrix._object_names.rows].getValue() !== undefined){HEADING.current_extsensor_changed = true;}', true); // action survenant AVANT le garde-fou de "settings_modified" lors d'un setValue()
		window[GIWIK._plugins.matrix._object_names.cols].setAction(window[GIWIK._plugins.matrix._object_names.cols].raw_action+'window[GIWIK._plugins.matrix._object_names.rows].setValue(); window.Usermsg_conflicts.hide(); HEADING.highlightCell(); HEADING.getConf();');

		window[GIWIK._plugins.matrix._object_names.rows].raw_action = 'window.current_extsensor=window[GIWIK._plugins.matrix._object_names.rows].getValue();'; // action sans la réinitialisation du menu port ni le getConf() (pour l'onclick sur une cellule du tableau qui doit activer une entrée dans chaque menu)
		window[GIWIK._plugins.matrix._object_names.rows].setActionBefore('HEADING.current_extsensor_changed = true; if (window[GIWIK._plugins.matrix._object_names.cols].getValue() !== undefined){HEADING.current_port_changed = true;}', true); // action survenant AVANT le garde-fou de "settings_modified" lors d'un setValue()
		window[GIWIK._plugins.matrix._object_names.rows].setAction(window[GIWIK._plugins.matrix._object_names.rows].raw_action+'window[GIWIK._plugins.matrix._object_names.cols].setValue(); window.Usermsg_conflicts.hide(); HEADING.highlightCell(); HEADING.getConf();');


		// flags pour indiquer le port courrant et/ou le capteur courant ont changé pour afficher ou non l'alert contre la perte de conf
		HEADING.current_port_changed = false;
		HEADING.current_port_settings_changed = false;
		HEADING.current_extsensor_changed = false;
		HEADING.current_extsensor_settings_changed = false;

		HEADING.association_changed = false; // association de tous les ports/protocoles/capteurs

		window.settings_modified = false;

		// Ecriture du titre "protocol"
		GIWIK.write('inputs_protocol_title',MSG(['box','protocol_title']));

		// Construction des groupes de paramètres
		GIWIK.paramGroup.construct('params_protocol', MSG(['box','params_protocol']), 'show');
		GIWIK.paramGroup.construct('params_device',   MSG(['box','params_device']), 'show');
		GIWIK.paramGroup.construct('params_serial',   MSG(['box','params_serial']), 'show');		// L'affichage des paramètres dépend du type de lien choisi (série/éthernet)
		GIWIK.paramGroup.construct('params_ethernet', MSG(['box','params_ethernet']), 'show');		// L'affichage des paramètres dépend du type de lien choisi (série/éthernet)

		if (GIWIK._plugins.sensor_control && GIWIK._plugins.sensor_control.in_use)
		{
			HEADING.constructParamSensorControl("HEADING.launchSensorControl(window.current_port, window._input_protocols[window._ipro_port[window.current_port]]);");
		}

		window._ipro_port = [];						// Liste des affectations protocole<->port
		window._exts_port = [];						// Liste des affectations capteurs<->port
		window._dynamic_ipro_lists = [];			// Tableau contenant les index des protocols valides pour chaque port en fonction de l'association avec les capteurs externes
		window._dynamic_ipro_lists_labels = [];		// idem mais avec des labels à la place des index

		window.current_port = undefined;


		window.heading_labels_width = 60; 	// Définit la largeur des labels des paramètres de la page
		window.ip_input_width = 36; 		// Définit la largeur des champs des paramètres de la page


		// Construction du message de conflits
		window.Usermsg_conflicts = new User_msg('Usermsg_conflicts', true);
		window.Usermsg_conflicts.margin = '-5px 0 20px 0';
		window.Usermsg_conflicts.construct('usermsg_conflicts', 1, '');
		window.Usermsg_conflicts.hide();

		// Construction du message d'aide s'affichant au chargement de la page
		HEADING.tuto_msg = '<div id="usermsg_tuto">'+MSG(['box','usermsg_inputs'])+'</div>';

		window.Usermsg_inputs = new User_msg('Usermsg_inputs', true);
		window.Usermsg_inputs.margin = '-5px 0 0 0';
		window.Usermsg_inputs.construct('usermsg_inputs', 1, HEADING.tuto_msg, '', false);	// pas de bordure autour du message du tuto

		// Définition de l'objet à retourner
		rtn = {
			validation_buttons : {
				cancel : {action : "HEADING.cancel_conf = true; HEADING.association_changed = false; window.Usermsg_conflicts.hide();"},
				send   : {action : "HEADING.send_conf = true; HEADING.association_changed = false;"}
			}
		};
	}

	// Construction des cellules de la matrice
	HEADING.constructCells();

	if (rtn)
	{
		return rtn;
	}
};
