// GIWIK APPLICATION

// "use strict";  // JavaScript strict mode


// INITIALISATION ———————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————

	// Chargement d'un fichier JavaScript
	GIWIK.init.js = function (_files, plugin_name)
	{
		// Le 1er paramètre est sous forme (string) si un seul fichier à charger ou (array) pour n fichiers
		// Chaque fichier à charger est sous forme de (string) et peut être :
		// - un chemin complet pour charger un fichier JS spécifique
		// - un type de fichier qui sera appelé sous la forme nom_de_page.mon_type.js (ex. "app","css","inc")
		// (optionnel) Le 2nd paramètre est le nom du plugin (string) obligatoire dans le cas d'un plugin

		// Pour un fichier dont le chemin doit être construit
		var base_path = plugin_name	? (GIWIK._plugins[plugin_name].shared ? GIWIK.directories.plugins_shared : GIWIK.directories.plugins)+'/'+plugin_name+'/plugin.'+plugin_name+'.'	// cas d'un plugin
			: ((!GIWIK._files['app.js'].loaded) ? '../'	// si appel depuis app.js --> A AMÉLIORER !!!
				: './'+HEADING.name.replace(GIWIK.regexp.get_page_parent, '')+'.'),	// Si appel depuis un fichier xxx.app.js, suppression du niveau parent
			full_path,
			file,
			script,
			i;

		// Si le 1er argument est une chaîne, on l'inclue dans un tableau
		if (typeof _files == 'string')
		{
			_files = [_files];
		}

		// Pour chaque fichier à traiter
		for (i in _files)
		{
			file = _files[i];

			// Si le nom de fichier est une chaîne non nulle
			if (!(typeof file == 'string' && file != '')) {continue;}

			// Construction de la balise "script"
			full_path = (file.match(/\.js$/i)) ? file : base_path+file+'.js';

			script = '<script src="'+full_path+'"></script>';

			// Si la phase d'init est terminée on appelle les fichiers via ajax
			if (HEADING.init.isdone)
			{
				$('head').append(script);
			}
			// Sinon on écrit directement le tag <script> dans le document
			else
			{
				document.write(script);
			}
		}
	};

	// Détection du navigateur et de la plateforme
	GIWIK.init.getBrowserType = function ()
	{
		// Initialisation de l'objet "_context" qui va contenir toutes les infos liées à l'environnement (os, navigateur, type de device...)
		if (!GIWIK._context ){GIWIK._context = {};}
		if (!GIWIK._context._browser) {GIWIK._context._browser = {};}

		var _matches;

		// Detection de l'iPhone/iPod Touch
		if (navigator.userAgent.indexOf("iPhone") != -1 || navigator.userAgent.indexOf("iPod") != -1)
		{
			GIWIK._context.iphone = true;
			GIWIK._context.mobile_device = true;
			GIWIK._context.ios = true;
		}
		// Detection de l'iPad
		else if (navigator.userAgent.indexOf("iPad") != -1)
		{
			GIWIK._context.ipad = true;
			GIWIK._context.ios = true;
		}

		// Appareil ne disposant pas de plugins (JavaRE, Flash)
		if (GIWIK._context.ios)
		{
			GIWIK._context.no_plugin_available = true;
		}

		// Détection de l'OS
		GIWIK._context.windows = (navigator.appVersion.indexOf("Win") != -1);
		GIWIK._context.mac     = (navigator.appVersion.indexOf("Mac") != -1);
		GIWIK._context.linux   = (navigator.appVersion.indexOf("Lin") != -1);

		// Détection des appareils tactiles
		GIWIK._context.touch_device = ("ontouchstart" in document.documentElement) ? true : false;

		// WebKit
		if (navigator.userAgent.indexOf("WebKit") != -1)
		{
			_matches = navigator.userAgent.match(/AppleWebKit\/(\d+)(\.(\d+)(\+)?)?/i);
			if (count(_matches) > 1)
			{
				// ex: 534.2+ devient 534.20
				if (_matches[4] == "+")
				{
					_matches[3] += "0";
				}
				// ex: 534.1 vaut en fait 534.01
				else if (parseFloat(_matches[3]) < 10)
				{
					_matches[3] = "0"+_matches[3];
				}

				GIWIK._context.webkit = parseFloat(_matches[1]+((typeof _matches[3] != 'undefined') ? "\."+_matches[3] : ""));
			}

			// Opera
			if (navigator.userAgent.indexOf("OPR") != -1)
			{
				_matches = navigator.userAgent.match(/OPR\/(\d+\.\d+)/i);
				if (count(_matches) > 1)
				{
					GIWIK._context.opera = parseFloat(_matches[1]);
				}

				GIWIK._context._browser = {
					name: "Opera",
					version: GIWIK._context.opera,
					min_version: 15,	// Version du passage de Presto à Webkit (Blink)
					engine_codename: "webkit"
				};
			}
			// Chrome
			else if (navigator.userAgent.indexOf("Chrome") != -1)
			{
				_matches = navigator.userAgent.match(/Chrome\/(\d+\.\d+)/i);
				if (count(_matches) > 1)
				{
					GIWIK._context.chrome = parseFloat(_matches[1]);
				}

				GIWIK._context._browser = {
					name: "Chrome",
					version: GIWIK._context.chrome,
					min_version: 10,
					engine_codename: "webkit"
				};
			}
			// Safari
			else if (navigator.userAgent.indexOf("Safari") != -1)
			{
				_matches = navigator.userAgent.match(/Version\/(\d+\.\d+)/i);
				if (count(_matches) > 1)
				{
					GIWIK._context.safari = parseFloat(_matches[1]);
				}

				GIWIK._context._browser = {
					name: "Safari",
					version: GIWIK._context.safari,
					min_version: 4,
					engine_codename: "webkit"
				};
			}
			// Cas d'utilisation sous forme de WebApp (le userAgent ne retourne pas "Safari")
			else if (GIWIK._context.ios)
			{
				GIWIK._context.webApp = true;

				// Comme elle n'est pas fournie, on considère que la version de Safari correspond à la version d'iOS
				_matches = navigator.userAgent.match(/OS (\d+)(_\d+)?/i);
				if (count(_matches) > 1)
				{
					GIWIK._context.safari = parseFloat(_matches[1].replace('_','.'));
				}

				GIWIK._context._browser = {
					name: "Safari",
					version: GIWIK._context.safari,
					min_version: 4,
					engine_codename: "webkit"
				};
			}
		}
		// IE
		else if (navigator.userAgent.indexOf("Trident") != -1)
		{
			// IE <= 10
			if (window.ActiveXObject && !window.opera)
			{
				_matches = navigator.userAgent.match(/MSIE (\d+)/i);
				if (count(_matches) > 1)
				{
					GIWIK._context.ie_user_agent = _matches[1];	// pas fiable avec l'existance des "browser modes" pour la compatibilité
				}

				// IE8+
				if (document.documentMode)	// fiable pour détecter IE8+
				{
					if (document.documentMode >= 8)
					{
						GIWIK._context.ie = document.documentMode;
					}
					// Si le "document mode" est trop bas (7)
					else
					{
						GIWIK._context.ie = 7;

						GIWIK._context.error_msg = 'ie_document_mode';
					}

					// Si le "browser mode" est trop bas
					if (GIWIK._context.ie_user_agent < 8)
					{
						GIWIK._context.ie = parseFloat(_matches[1]);

						GIWIK._context.error_msg = 'ie_browser_mode';
					}
				}
				// IE7-
				else
				{
					GIWIK._context.ie = GIWIK._context.ie_user_agent;
				}
			}
			// IE >= 11
			else if (navigator.userAgent.indexOf("rv:") != -1)
			{
				_matches = navigator.userAgent.match(/rv\s?:\s?(\d+)/i);
				if (count(_matches) > 1)
				{
					GIWIK._context.ie = parseFloat(_matches[1]);
				}
			}

			GIWIK._context._browser = {
				name: "Internet Explorer",
				version: GIWIK._context.ie,
				min_version: 8,
				engine_codename: "trident"
			};
		}
		// Gecko
		else if (navigator.userAgent.indexOf("Gecko") != -1)
		{
			_matches = navigator.userAgent.match(/rv:(\d+\.\d)/i);
			if (count(_matches) > 1)
			{
				GIWIK._context.gecko = parseFloat(_matches[1]);

			}

			_matches = navigator.userAgent.match(/Firefox\/(\d+\.\d+)/i);
			if (count(_matches) > 1)
			{
				GIWIK._context.firefox = parseFloat(_matches[1]);

				GIWIK._context._browser = {
					name: "Firefox",
					version: GIWIK._context.firefox,
					min_version: 3.5,
					engine_codename: "gecko"
				};
			}
		}

		/*
		VERSION NAVIGATEUR   VERSION MOTEUR

		PRESTO :
		Opera 12   -> 2.10
		Opera 11.5 -> 2.9
		Opera 11.0 -> 2.7
		Opera 10.6 -> 2.6
		Opera 10.5 -> 2.5
		Opera 10.0 -> 2.2
		Opera 9.6  -> 2.1
		Opera 11.0 mobile -> 2.7
		Opera 10.1 mobile -> 2.5
		Opera 10.0 mobile -> 2.4

		GECKO
		etc.
		Firefox 6.0	  -> 6.0
		Firefox 5.0	  -> 5.0
		Firefox 4.0	  -> 2.0
		Firefox 3-3.6 -> 1.9
		Firefox 2.0	  -> 1.8

		WEBKIT :
		Safari 6.0  -> 536.25
		Safari 5.1.7-> 534.57
		Safari 5.1.5-> 534.55
		Safari 5.1.3-> 534.53
		Safari 5.1.1-> 534.51
		Safari 5.1  -> 534.50 (gestion des propriétés CCS3 : border-radius et box-shadow)
		Safari 5.05 -> 533.21
		Safari 5.04 -> 533.20
		Safari 5    -> 533.16
		Safari 4.05 -> 531.22
		Safari 4.04 -> 531.21
		Safari 4.00 -> 528
		Safari 3.2  -> 525
		Safari 3.1  -> 525
		Safari mobile 5.1   (iOS 5.0/5.1) -> 534.46
		Safari mobile 5.0.2 (iOS 4.3)     -> 533.17
		Safari mobile 5.0.2 (iOS 4.2)     -> 533.17
		Safari mobile 4.0.5 (iOS 4.0)     -> 532.9
		Safari mobile 4.0   (iOS 3.1)     -> 528
		Safari mobile 3.1.2               -> 528

		Chrome 24 	-> 537.17
		Chrome 19	-> 536.5
		Chrome 18	-> 535.19
		Chrome 17	-> 535.11
		Chrome 15	-> 535.2
		Chrome 14	-> 535.1
		Chrome 13	-> 535.1
		Chrome 12	-> 534.29
		Chrome 11	-> 534.24
		Chrome 10	-> 534.16
		Chrome 9	-> 534.13
		Chrome 8	-> 534.10
		Chrome 7	-> 534.7
		Chrome 6	-> 534.3
		Chrome 5	-> 533.0
		Chrome 4	-> 532.0
		Chrome 3	-> 532.0
		Chrome 2	-> 530.0
		Chrome 1	-> 528.0
		*/
	};

	// Vérification du navigateur par rapport au navigateur utilisé pour la qualification
	GIWIK.init.checkBrowser = function ()
	{
		if (!GIWIK._context.error_msg)
		{
			// Si le navigateur se trouve sous les specs minimales
			if (GIWIK._context._browser.version < GIWIK._context._browser.min_version)
			{
				GIWIK._context.error_msg = 'browser_version';
			}
			// Si le navigateur n'est pas le navigateur utilisé pour la qualification
			else if (GIWIK._context._browser.name.toLowerCase() != GIWIK._qualified_browser.name.toLowerCase())
			{
				GIWIK._context.error_msg = 'non_qualified_browser';
			}
			// Si le navigateur est bien celui utilisé pour la qualification mais pas au niveau de la version recommandée
			else if (GIWIK._context._browser.version < GIWIK._qualified_browser.version)
			{
				GIWIK._context.error_msg = 'qualified_browser_version';
			}
		}
	};

	// 1ère phase d'init AVANT l'évènement "load" (utile pour le chargement dynamique de giwik.css.js)
	GIWIK.init.beforeLoadEvent = function ()
	{
		// On s'assure que l'app.js est bien chargé (init_app() obligatoirement présente)
		if (!GIWIK._files['app.js'].loaded)
		{
			setTimeout("GIWIK.init.beforeLoadEvent()", 10);
			return;
		}

		// Gestion du system_type === false en mode simulation (le batch IPD induit ce "false")
		if (GIWIK.system_type === false && GIWIK.simulation_mode)
		{
			console.log("system_type === false  -->  fallback to system_type 0");
			GIWIK.system_type = 0;
		}

		// Si le system_type est défini en dur (dans app.js) ET n'est pas valide [protection de la phase d'init avant l'évènement "load"]
		if (typeof GIWIK.system_type != 'undefined' && !GIWIK._systems[GIWIK.system_type])
		{
			// Si on se trouve sur la page de chargement
			if (GIWIK.preload_mode)
			{
				alert("Error : system type is not valid.");
			}
			// Sinon, on y va
			else
			{
				GIWIK.goToPreloadPage();
			}
			return;
		}

		// Affectation de la 2nd phase d'init au chargement de la page (évènement "load")
		if (window.addEventListener)
		{
			window.addEventListener('load', GIWIK.init.afterLoadEvent, false);
		}
		else
		{
			window.attachEvent('onload', GIWIK.init.afterLoadEvent);
		}

		// Construction de la version complète de l'IHM ([version GIWIK]-[version IHM spécifique])
		GIWIK.full_ihm_version = GIWIK.giwik_version+'-'+GIWIK.ihm_version;


		// Déclaration de l'objet de stockage des données de l'embarqué
		//   - "SYSTEM" pour réponse JSON
		//   - "System_state" pour réponse JavaScript
		window.system = "System_state";
		window[system] = {};


		// Détection du navigateur
		GIWIK.init.getBrowserType();

		// Récupération des paramètres d'url dans une variable _get semblable à PHP
		window._GET = GIWIK.getParamsFromString(window.location.href);


		// Instanciation de l'objet principal
		window.HEADING = new Heading('HEADING');


		// COOKIE ———————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
		// Définition du nom du cookie
		var cookie_name = encodeURIComponent
		(
			GIWIK.ihm_codename		// nom de code l'IHM
			+'_'+window.location.port	// port si différent de 80 ou 443
			+'_'+window.location.pathname.replace(new RegExp("/"+HEADING.name+"(/[^/]*)?$", "i"), "")+"/"	// chemin d'installation absolu
		);

		// Instanciation de l'objet de stockage des infos des cookies.
		window.STORAGE = new Storage(cookie_name);
		//———————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————

		// Mesurer les conséquences au niveau du processus de mise à jour des produits IPD et APD
		// // Si la version de l'IHM stockée ne correspond pas à la version de l'IHM courante
		// if (STORAGE.get('full_ihm_version') !== GIWIK.full_ihm_version)
		// {
		// 	// Effacement tous les cookies pour éviter tout conflit si l'opérateur ne vide pas ses cookies
		// 	STORAGE.reset();

		// 	// On stoc
		// 	STORAGE.setPermanent('full_ihm_version', GIWIK.full_ihm_version);
		// }

		// On determine la langue desiree par l'utilisateur —————————————————————————————————————————————————————————————————————————————————————————————————————————
		// - la langue est determinee par la configuration dans les cookies
		// - sinon, en l'absence de configuration, on choisit la langue du navigateur
		// - en dernier lieu, on se rabat sur la langue par defaut (index 0 du tableau des langues disponibles)

		// Si la langue est stockée dans les cookies et se trouve dans le domaine du possible
		if (in_array(STORAGE.get('lang'), GIWIK._available_languages))
		{
			GIWIK.lang = STORAGE.get('lang');
		}
		else
		{
			var navigator_language = ((navigator.userLanguage) ? navigator.userLanguage : navigator.language).substring(0,2);

			if (in_array(navigator_language, GIWIK._available_languages))
			{
				GIWIK.lang = navigator_language;
			}
			else
			{
				GIWIK.lang = GIWIK._available_languages[0];
			}

			// Ecriture du cookie (au cas où la langue aurait juste été déduite (absente du cookie))
			STORAGE.setPermanent('lang', GIWIK.lang);
		}

		// Si le type de système est dynamique ----------------------------------------------------------------------------------------------------------------------
		// Principes :
		// 1 - Si SYSTEM.system_type est renvoyé dans les modes 0/1/2, il aura toujours le dessus sur un GIWIK.system_type déclaré en dur (dans app.js)
		// 2 - Si l'embarqué est en is_started=false et que le system_type n'est pas encore connu (-1), on passe en mode préload en attendant de le connaître
		// 3 - Si le SYSTEM.system_type renvoyé par l'embarqué n'est pas valide alors que le système est démarré (SYSTEM.is_started=true),
		//     on force le system_mode par défaut (cas des produits vierges à la prod)

		// Si le type de système n'est pas défini en dur (dans app.js) OU qu'il est défini dans les cookies
		if (typeof GIWIK.system_type != 'number' || typeof STORAGE.get('system_type') != 'undefined')
		{
			// Si le type de système est stocké dans le cookie ET est valide
			if (typeof STORAGE.get('system_type') != 'undefined' && GIWIK._systems[eval(STORAGE.get('system_type'))])
			{
				// Si le type de système est dans le domaine du possible, on récupère sa valeur, sinon on affecte la valeur par défaut (0)
				GIWIK.system_type = eval(STORAGE.get('system_type'));
			}
			// Si on n'y se trouve pas déjà, affichage de la page de chargement
			else if (!GIWIK.preload_mode)
			{
				GIWIK.goToPreloadPage();
				return;
			}
			// Page de chargement : attribution d'un system_type par défaut le temps de récupérer une valeur de l'embarqué
			else
			{
				// On le met à 0 pour faire que le script s'éxécute sans accrocs le temps de le récupérer de l'embarqué
				GIWIK.system_type = 0;

				// Flag pour indiquer qu'il s'agit du tou 1er démarrage de l'IHM et que le system_type est inconnu
				// (pour masquage de la partie globale de l'IHM en attendant le system_type via le 1er mode 0/1/2)
				GIWIK.system_type_has_to_be_confirmed = true;
			}
		}

		// Transformation en fonction des propriétés des types de systèmes de GIWIK._systems -------------------------------------------------------------------------------------------------
		// --> possibilité d'utiliser l'objet MSG via l'utilisation de fonctions
		var systype, propname, propvalue;

		for (systype in GIWIK._systems)
		{
			for (propname in GIWIK._systems[systype])
			{
				propvalue = GIWIK._systems[systype][propname];

				if (propname != 'codename' && typeof propvalue != 'function')
				{
					delete GIWIK._systems[systype][propname];

					eval("GIWIK._systems['"+systype+"']['"+propname+"'] = function () {return '"+propvalue+"';}");
				}
			}
		}

		// Récupération du nom de code
		GIWIK.system_codename = GIWIK._systems[GIWIK.system_type].codename;

		// GESTION DES INCLUDES --------------------------------------------------------------------------------------------------------------------------------------------------------------

		var includes = '',
		    plugins = '',
		    heading_uses_plugin,
		    name,
		    script;

		// Plugins
		for (name in GIWIK._plugins)
		{
			// console.log("plugin "+name);

			// Chargement du plugin si la page fait partie de son champ d'action
			if (GIWIK.isPluginAvailable(name))
			{
				script = (GIWIK._plugins[name].shared ? GIWIK.directories.plugins_shared : GIWIK.directories.plugins)+'/'+name+'/plugin.'+name+'.app.js';
				plugins += '<script src="'+script+'"></script>';
				// console.log("-> chargé");
			}
		}

		// Définition anticipée du mode nuit et de la couleur de fond de la page  contre l'effet de flash au chargement :::::::::
		GIWIK.css.init('night_mode', (STORAGE.get('night_mode') === true) ? true : false);
		GIWIK.css.init('color_background', (GIWIK.css.night_mode) ? GIWIK.css.RGBA(0,0,0,1) : GIWIK.css.RGBA(255,255,255,1));
		// ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

		document.write
		(
			// Contre le falsh lumineux qui peut apparaitre au chargement de la page (notamment sous WebKit/Blink)
			 '<style>html,body{background:'+GIWIK.css.color_background+';}</style>'

			+'<script src="'+GIWIK.directories.giwik+'/giwik.inc.js"></script>'
			+'<script src="'+GIWIK.directories.giwik+'/giwik.css.js"></script>'
			+'<script src="'+GIWIK.directories.giwik+'/giwik.msg.js"></script>'

			+plugins

			+'<script src="'+GIWIK.directories.root+'/css.js"></script>'
			+'<script src="'+GIWIK.directories.root+'/msg.js"></script>'
			+'<script src="'+GIWIK.directories.root+'/status.js"></script>'

			+'<script src="'+GIWIK.directories.root+'/'+HEADING.name+'/'+HEADING.name.replace(GIWIK.regexp.get_page_parent, "")+'.app.js"></script>'
		);
		//------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

		// Marque le fait que la 1ère phase d'init est bien terminée
		GIWIK.init.beforeLoadEvent.isdone = true;
	};

	// A l'évènement "load" (tous les fichiers chargés et DOM initialisé)
	GIWIK.init.afterLoadEvent = function ()
	{
		// Récupération du nom du produit
		GIWIK.system_name = GIWIK._systems[GIWIK.system_type].name().trim().replace(/\s+/gi, "_");

		// Ecriture du nom de la page
		if (!GIWIK.system_type_has_to_be_confirmed)
		{
			GIWIK.window.setTitle();
		}

		// Si les cookies sont désactivés, on arrête le processus d'init
		if (!STORAGE.checkCookies())
		{
			return;
		}

		// Si mode preload ET que le type de système est déjà connu (écrit en dur dans app.js ou stocké dans les cookies),
		// on redirige vers la page par défaut (au bout d'un certain temps pour avoir le temps de voir la page de chargement)
		if (GIWIK.preload_mode && !GIWIK.system_type_has_to_be_confirmed)
		{
			setTimeout("window.location.replace('"+document.location.pathname+"')", 1500);
			return;
		}

		// TESTS DE COMPATIBILITÉ ———————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————

		// Vérification de la compatibilité du navigateur par rapport à la version utilisée pour la qualification
		GIWIK.init.checkBrowser();

		// On stoppe l'init si le navigateur est en dehors des specs (GIWIK._context.browser_under_required est défini dans GIWIK.init.getBrowserType())
		if (in_array(GIWIK._context.error_msg,['browser_version', 'ie_document_mode', 'ie_browser_mode']))
		{
			alert(MSG(['init', GIWIK._context.error_msg]));
			return;
		}
		// Si le navigateur est Firefox au dessus des specs minimales mais pas au niveau de la version recommandée
		// OU Si le navigateur n'est pas Firefox
		else if (in_array(GIWIK._context.error_msg, ['non_qualified_browser', 'qualified_browser_version']) &&
				 STORAGE.get(GIWIK._context.error_msg+'_acknowledged') != GIWIK._context._browser.name+GIWIK._context._browser.version)
		{
			STORAGE[(confirm(MSG(['init', GIWIK._context.error_msg]))) ? 'setPermanent' : 'set']
			(
				GIWIK._context.error_msg+'_acknowledged',
				GIWIK._context._browser.name +GIWIK._context._browser.version
			);
		}


		// TEST DE BON CHARGEMENT DE TOUS LES FICHIERS + PRÉSENCE DES ELEMENTS INDISPENSABLES DANS LA PARTIE PRODUIT ——————————————————————————————————————————————————————
		if (!(GIWIK.init.beforeLoadEvent.isdone &&
			  GIWIK._files['giwik.inc.js'].loaded &&
			  GIWIK._files['giwik.css.js'].loaded &&
			  GIWIK._files['giwik.msg.js'].loaded))
		{
			setTimeout("GIWIK.init.afterLoadEvent()", 10);
			return;
		}

		// Détection de l'activité de chaque plugin pour la rubrique en cours via le flag "in_use" (GIWIK._plugins est défini dans app.js)
		for (var name in GIWIK._plugins)
		{
			if (!in_array(typeof GIWIK._plugins[name].use_on, ['string','object']))
			{
				GIWIK._plugins[name].use_on = [];
				continue;
			}

			switch (typeof GIWIK._plugins[name].use_on)
			{
				case 'string':
					GIWIK._plugins[name].in_use = in_array(GIWIK._plugins[name].use_on, [HEADING.name,'all_headings']) ? true : false;
					break;

				case 'object':
					GIWIK._plugins[name].in_use = (in_array(HEADING.name, GIWIK._plugins[name].use_on) || in_array('all_headings', GIWIK._plugins[name].use_on)) ? true : false;
					break;
			}
		}

		// Appel de la fonction d'init déclarée dans le fichier de configuration de la partie spécifique (app.js) —————————————————————————————————————————————————————————
		GIWIK.init.app();
		//—————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————

		// Définition du mode d'affichage compact

		// Si erroné (GIWIK.ihm_compactmode)
		if (typeof GIWIK._maincontrol_buttons == 'object' && GIWIK.ihm_compactmode === true)
		{
			delete GIWIK.ihm_compactmode;
		}
		// si absent GIWIK.init.app.js
		if (typeof GIWIK.ihm_compactmode != 'boolean')
		{
			// Si aucun bouton de contrôle principal n'a été définit, passage en mode d'affichage "compact"
			GIWIK.ihm_compactmode = (typeof GIWIK._maincontrol_buttons == 'undefined') ? true : false;
		}

		// Récupération de la taille de la fenêtre (small,medium,full)
		GIWIK.window_size = GIWIK.window.getSize();

		// Définition de la taille des éléments de controle principaux (chevron, logo, boutons de contrôle)
		GIWIK.maincontrol_size = (HEADING.name == 'control') ? GIWIK.window_size : 'mini';

		// Exécution de la fonction init de chaque plugin —————————————————————————————————————————————————————————————————————————————————————————————————————————————————
		GIWIK.init.plugins();
		//—————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————


		// REBOOT PROGRAMMÉ ———————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————

		if (typeof eval(STORAGE.get('reboot_scheduled')) == 'number')
		{
			setTimeout("GIWIK.getRestartAction(function () {STORAGE.set('reboot_scheduled', false);}, 'skip_confirm')()", STORAGE.get('reboot_scheduled'));
		}


		// GESTION DE LA FREQUENCE DE RAFRAICHISSEMENT ————————————————————————————————————————————————————————————————————————————————————————————————————————————————————

		// Définition de la fréquence de rafraîchissement par défaut pour la page "control".
		// De cette valeur découlent les valeurs de rafraîchissement de toutes les autres pages
		if (typeof GIWIK.update_timeout != 'number')
		{
			GIWIK.update_timeout = 500;
		}

		// Si le plugin control est chargé (--> IHM "classique" avec page control et pages de conf), on gère la fréquence de rafraîchissement en fonction de la page
		if (GIWIK._plugins.control)
		{
			// Sinon les pages autres que "control" doivent rafraîchir moins vite
			if      (HEADING.name == 'control') 										 {												}
			else if (in_array(HEADING.name,['control_expertview','control_chartsview'])) {GIWIK.update_timeout = GIWIK.update_timeout * 2;}
			else if (HEADING.is_external_popup)											 {GIWIK.update_timeout = GIWIK.update_timeout * 4;}
			else																		 {GIWIK.update_timeout = GIWIK.update_timeout * 2;}
		}


		// Les appareils mobiles doivent rafraîchir moins vite
		if (GIWIK._context.mobile_device)
		{
			GIWIK.update_timeout = GIWIK.update_timeout * 1.5;
		}
		if (typeof GIWIK.connection_timeout_factor != 'number')
		{
			GIWIK.connection_timeout_num_queries = 10;
		}

		// Valeur du timeout de connexion (ms) : Si l'IHM ne reçoit pas de réponse de l'embarqué pendant n secondes elle considère que la connexion perdue
		GIWIK.connection_timeout = GIWIK.update_timeout * GIWIK.connection_timeout_num_queries;


		// Initialisation des tableaux des capteurs externes : suppression des capteurs déclarés "false"
		if (GIWIK._ext_sensors)
		{
			for (var ext_s in GIWIK._ext_sensors)
			{
				if (GIWIK._ext_sensors[ext_s] === false) {delete GIWIK._ext_sensors[ext_s];}
			}
		}

		// Définition de la précision des latitudes/longitudes (précision centimétrique par défaut (7))
		if (typeof GIWIK.latlong_precision != 'number')
		{
			GIWIK.latlong_precision = (GIWIK._plugins.options && typeof GIWIK._plugins.options.latlong_precision == 'number') ? GIWIK._plugins.options.latlong_precision : 7;
		}
		//—————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————

		// Déclaration de l'action sur l'évènement "unload" (changement de page)
		window.onbeforeunload = HEADING.confirmUnload;


		window.settings_modified = false;
		window.settings_modified_unload = false;


		GIWIK.init.isdone = true;


		// Lancement de la phase d'init de l'objet HEADING
		HEADING.init();
	};

	// Déclaration de la fonction init des plugins
	GIWIK.init.plugins = function ()
	{
		for (var plugin in GIWIK.init.plugins)
		{
			if (typeof GIWIK.init.plugins[plugin] == 'function')
			{
				GIWIK.init.plugins[plugin]();
			}
		}
	};

	// Preload des images
	GIWIK.init.preloadImages = function ()
	{
		// Initialisation du tableau des images à preloader
		if (typeof window._images_to_be_preloaded != 'object'){window._images_to_be_preloaded = new Array();}

		//alert(STORAGE.get('preload_img_main_isdone')+' '+STORAGE.get('preload_img_mechanical_isdone'));

		// Pour un affichage plus rapide du chevron
		window._images_to_be_preloaded.push
		(
			GIWIK.directories.img+'/chevron'+GIWIK.css.night_suffix+'.png'
		);

		// Preload des images communes si la connexion n'est pas trop lente
		if (!STORAGE.get('preload_img_main_isdone'))
		{
			window._images_to_be_preloaded.push
			(
				GIWIK.directories.img+'/button'+GIWIK.css.night_suffix+'.png',
				GIWIK.directories.img+'/buttoni'+GIWIK.css.night_suffix+'.png',

				GIWIK.directories.img+'/input_led0.png',
				GIWIK.directories.img+'/input_led1.png',
				GIWIK.directories.img+'/input_next0.gif',
				GIWIK.directories.img+'/input_next1.gif',
				GIWIK.directories.img+'/input_next1i.gif',
				GIWIK.directories.img+'/input_prev0.gif',
				GIWIK.directories.img+'/input_prev1.gif',
				GIWIK.directories.img+'/input_prev1i.gif',

				GIWIK.directories.img+'/activity'+GIWIK.css.color_suffix+((GIWIK.css.graphic_charter == 'green') ? GIWIK.css.night_suffix : '')+'.gif',

				GIWIK.directories.img+'/box_border0.gif',
				GIWIK.directories.img+'/box_corner_bl0.png',
				GIWIK.directories.img+'/box_corner_br0.png',
				GIWIK.directories.img+'/box_corner_tl0.png',
				GIWIK.directories.img+'/box_corner_tr0.png',

				GIWIK.directories.img+'/box_border1'+GIWIK.css.color_suffix+'.gif',
				GIWIK.directories.img+'/box_corner_bl1'+GIWIK.css.color_suffix+'.png',
				GIWIK.directories.img+'/box_corner_br1'+GIWIK.css.color_suffix+'.png',
				GIWIK.directories.img+'/box_corner_tl1'+GIWIK.css.color_suffix+'.png',
				GIWIK.directories.img+'/box_corner_tr1'+GIWIK.css.color_suffix+'.png',

				GIWIK.directories.img+'/folderi.png',
				GIWIK.directories.img+'/folder_upi.png'
			);

			//document.title += ' preload_main';

			// On écrit dans le cookie de session que le preload a bien été effectué
			STORAGE.setSession('preload_img_main_isdone', true);
		}
		// Preload des images spécifiques à l'installation méchanique (si pas déjà effectué et s'il n'y a pas preload des images principales en même temps)
		// else if (HEADING.name == 'installation_mechanical' && !STORAGE.get('preload_img_mechanical_isdone') && STORAGE.get('preload_img_main_isdone'))
		// {
		// 	var color_suffix = '';

		// 	// Illustrations d'orientation grossière

		// 	// Cas particulier de GAPS qui n'a que la position mesaorient 1 possible
		// 	var nb_mesaorient = (GIWIK.ihm_codename == 'usbl' && GIWIK.system_type === 1) ? 1 : 24;

		// 	for (var i=0; i<nb_mesaorient; i++)
		// 	{
		// 		// On définit si l'illustration comporte un logo visible --> nécessite un suffixe dans le nom du fichier
		// 		color_suffix = (in_array(i, HEADING._mechanical_img_with_visible_logo['mesaorient'])) ? GIWIK.css.color_suffix : '';

		// 		window._images_to_be_preloaded.push(GIWIK.mechanical_case_img_dir+'/'+'mesaorient'+i+color_suffix+'.png');
		// 	}


		// 	// Illustrations de mésalignement fin
		// 	var _misalignment_codes = new Array();

		// 	// Cas particulier de GAPS
		// 	if (GIWIK.ihm_codename == 'usbl' && GIWIK.system_type == 1)
		// 	{
		// 		var _misalignment_codes =  ['fc_cv_lu','fd_cd_lv','fl_cl_lu'];
		// 	}
		// 	else
		// 	{
		// 		var _misalignment_codes =  ['fc_ci_ld','fc_ci_ll','fc_ci_lr','fc_ci_lu','fc_cv_ld','fc_cv_ll','fc_cv_lr','fc_cv_lu','fd_cd_li','fd_cd_lv','fd_cl_li','fd_cl_lv','fd_cr_li','fd_cr_lv','fd_cu_li','fd_cu_lv','fl_cd_ll','fl_cd_lr','fl_cl_ld','fl_cl_lu','fl_cr_ld','fl_cr_lu','fl_cu_ll','fl_cu_lr'];
		// 	}

		// 	for (var i in _misalignment_codes)
		// 	{
		// 		// On définit si l'illustration comporte un logo visible --> nécessite un suffixe dans le nom du fichier
		// 		color_suffix = (in_array(_misalignment_codes[i], HEADING._mechanical_img_with_visible_logo['misalignment'])) ? GIWIK.css.color_suffix : '';

		// 		window._images_to_be_preloaded.push(GIWIK.mechanical_case_img_dir+'/'+_misalignment_codes[i]+'_m'+color_suffix+'.png');
		// 		window._images_to_be_preloaded.push(GIWIK.mechanical_case_img_dir+'/'+_misalignment_codes[i]+'_p'+color_suffix+'.png');
		// 		window._images_to_be_preloaded.push(GIWIK.mechanical_case_img_dir+'/'+_misalignment_codes[i]+'_z'+color_suffix+'.png');
		// 	}

		// 	//document.title += ' preload_mechanical';

		// 	// On écrit dans le cookie de session que le preload a bien été effectué
		// 	STORAGE.setSession('preload_img_mechanical_isdone', true);
		// }

		//alert(window._images_to_be_preloaded.join("\n"));

		var style = "position:absolute;top:0px;left:0px;width:1px;height:1px;visibility:hidden;";

		var images = '';

		for (var i=0; i<window._images_to_be_preloaded.length; i++)
		{
			images += '<div style="background:url('+window._images_to_be_preloaded[i]+');'+style+'"></div>';
		}

		GIWIK.write('preload_images', images);
	};


// DONNÉES (GIWIK.data) —————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————

	GIWIK.data =
	{
		// Pour stockage des Id DOM des données affichées
		_dom_ids : {},

		// Gestion des conventions d'attitude
		attitude_convention :
		{
			_heading_sign_norms  : ['positive_clockwise','positive_anticlockwise'],
			_heading_range_norms : ['full_cycle','half_cycle'],
			_roll_sign_norms     : ['positive_port_up','positive_port_down'],
			_pitch_sign_norms    : ['positive_bow_down','positive_bow_up'],

			heading_sign_norm    : 'positive_clockwise',
			heading_range_norm   : 'full_cycle',
			roll_sign_norm       : 'positive_port_up',
			pitch_sign_norm      : 'positive_bow_down',

			process : function (data_name, data_value, data_type)
			{
				var value = data_value;

				switch (data_name)
				{
					// Heading: Manage range and sign norm (positive clockwise by default)
					case 'heading':

						switch (GIWIK.data.attitude_convention.heading_range_norm)
						{
						    case 'full_cycle': value = value;                           break;
						    case 'half_cycle': value = (value>180) ? value-360 : value; break;
						    default          :                                          break;
						}

						switch (GIWIK.data.attitude_convention.heading_sign_norm)
						{
						    case 'positive_clockwise'    : value = value;               break;
						    case 'positive_anticlockwise': value = -value;              break;
						    default                      :                              break;
						}
						break;

					// Roll: Manage sign norm (positive positive_port_up by default)
					case 'roll':

						switch (GIWIK.data.attitude_convention.roll_sign_norm)
						{
						    case 'positive_port_up'  : value = value;                   break;
						    case 'positive_port_down': value = -value;                  break;
						    default                  :                                  break;
						}
						break;

					// Pitch: Manage sign norm (positive positive_bow_down by default)
					case 'pitch':
						switch (GIWIK.data.attitude_convention.pitch_sign_norm)
						{
						    case 'positive_bow_down': value = value;                    break;
						    case 'positive_bow_up'  : value = -value;                   break;
						    default                 :                                   break;
						}
						break;
				}

				return value;
			}
		},

		// Gestion de la notation des coordonnées
		coordinates :
		{
			modes : [
				/*LatLong      */ {id: 0, num_values: 2, specific_altitude: false},
				/*UTM          */ {id: 1, num_values: 3, specific_altitude: false},
				/*Polar LatLong*/ {id: 2, num_values: 2, specific_altitude: false},
				/*UPS          */ {id: 3, num_values: 3, specific_altitude: false},
				/*OSGB         */ {id: 4, num_values: 4, specific_altitude: true },
				/*MGRS         */ {id: 5, num_values: 4, specific_altitude: true },
				/*GEOREF       */ {id: 6, num_values: 4, specific_altitude: true },
				/*ECEF         */ {id: 7, num_values: 3, specific_altitude: true }
			],

			getModesListFromStorage : function ()
			{
				var _modes = STORAGE.get('_coordinate_modes');

				// Si le mode coordonnées est stocké dans les cookies (pour les firmware à coordonnées polaires, on est susceptible de passer ici au 1er appel de la fonction lors du 1er mode 0/1/2)
				if (typeof _modes == 'object' && count(_modes))
				{
					return _modes;
				}
				// Mode de coordonnées par défaut (pour les firmware à coordonnées polaires, on est susceptible de passer ici au 1er appel de la fonction lors du 1er mode 0/1/2)
				else
				{
					_modes = [0];
					STORAGE.setPermanent('_coordinate_modes', _modes);
					return _modes;
				}
			},

			getModeFromStorage : function ()
			{
				var mode = STORAGE.get('coordinate_mode');

				// Si le mode coordonnées est stocké dans les cookies (pour les firmware à coordonnées polaires, on est susceptible de passer ici au 1er appel de la fonction lors du 1er mode 0/1/2)
				if (typeof mode == 'number' && in_array(mode, GIWIK._plugins.options._coordinate_modes))
				{
					return mode;
				}
				// Mode de coordonnées par défaut (pour les firmware à coordonnées polaires, on est susceptible de passer ici au 1er appel de la fonction lors du 1er mode 0/1/2)
				else
				{
					mode = (GIWIK.lang == 'fr' && in_array(1,GIWIK._plugins.options._coordinate_modes)) ? 1/*UTM*/ : 0/*LatLong*/;
					STORAGE.setPermanent('coordinate_mode', mode);
					return mode;
				}
			},

			setMode : function ()
			{
				// Cas de la récupération dynamique des modes de coordonnées
				if (GIWIK._plugins.options.get_coordinate_modes_from_firmware)
				{
					// Par défaut seul le mode latlong est supporté (0)
					if (typeof window[system].CoordinateModesList == 'object' && typeof window[system].CoordinateMode == 'number')
					{
						// Si la liste des modes a changé, on programme un rechargement de la page
						if (typeof GIWIK._plugins.options._coordinate_modes == 'undefined' || window[system].CoordinateModesList.join() != GIWIK._plugins.options._coordinate_modes.join())
						{
							if (typeof GIWIK._plugins.options._coordinate_modes != 'undefined')
							{
								var reload = true;
							}

							GIWIK._plugins.options._coordinate_modes = window[system].CoordinateModesList;
							STORAGE.setPermanent('_coordinate_modes',GIWIK._plugins.options._coordinate_modes);
						}

						// Si on est dans le contexte où le firmware gère le mode de coordonnées courant (latlong polaires) et qu'il a changé, on programme un rechargement de la page
						if (in_array(2,GIWIK._plugins.options._coordinate_modes) && typeof GIWIK.coordinate_mode == 'undefined' || GIWIK.coordinate_mode !== window[system].CoordinateMode)
						{
							if (typeof GIWIK.coordinate_mode != 'undefined')
							{
								var reload = true;
							}

							GIWIK.coordinate_mode = window[system].CoordinateMode;
							STORAGE.setPermanent('coordinate_mode',GIWIK.coordinate_mode);
						}
					}
					else
					{
						GIWIK._plugins.options._coordinate_modes = GIWIK.data.coordinates.getModesListFromStorage();
						GIWIK.coordinate_mode = GIWIK.data.coordinates.getModeFromStorage();
					}
				}
				else
				{
					var mode = GIWIK.data.coordinates.getModeFromStorage();

					if (HEADING.init.isdone && typeof GIWIK.coordinate_mode != 'undefined') // "&& typeof GIWIK.coordinate_mode" indispensable pour éviter un problème d'asynchronisme
					{																		// en cas de lenteur de la réponse de l'embarqué (du au fait que pour cette page on force
						if (mode !== GIWIK.coordinate_mode)									// HEADING.init.isdone à true de façon prématurée pour pouvoir faire des update firmware même
						{																	// en cas de problème)
							STORAGE.setPermanent('coordinate_mode',mode);
							var reload = true;
						}
					}
					GIWIK.coordinate_mode = mode;
				}

				if (reload)
				{
					window.location.reload();
					return;
				}
			},

			// Fonctions de gestion des notations de latitude/longitude
			latlong :
			{
				// Expressions régulières de détection des notations de latitudes/longitudes
				_regexp :
				{
					d:   /^(\d+)(?:\.(\d+))?\s*°\s*([NSEW])$/i,
					dm:  /^(\d+)\s*°\s*(\d+)(?:\.(\d+))?\s*'\s*([NSEW])$/i,
					dms: /^(\d+)\s*°\s*(\d+)\s*'\s*(\d+)(?:\.(\d+))?\s*"\s*([NSEW])$/i
				},

				// Valeur renvoyée en cas d'erreur
				err_value : '???',

				// Converti les notations de latitudes/longitudes de degrés décimaux en degrés décimaux|degrés minutes décimales|degrés minutes secondes décimales + hémisphère
				// 		arguments :
				//			data_name : nom de la donnée (doit contenir "latitude" ou "longitude" si data_type === position)
				//			value : valeur en degrés décimaux
				// 			options :
				//				notation : 'd','dm' ou 'dms'
				//				precision : nombre
				d2dmdms : function (data_type, data_value, _options)
				{
					var data_type;

					// Le type doit être latitude ou longitude
					if (!(data_type == 'latitude' || data_type == 'longitude'))
					{
						return GIWIK.data.coordinates.latlong.err_value;
					}

					// Cas particulier d'une valeur N/A : on la renvoie telle quelle
					if (data_value === 'N/A')
					{
						return data_value;
					}
					// Si la valeur n'est pas un nombre, on retourne la valeur d'erreur
					else if (isNaN(data_value))
					{
						return GIWIK.data.coordinates.latlong.err_value;
					}
					// Si la valeur est une string, on la passe en number
					else if (typeof data_value == 'string')
					{
						data_value = parseFloat(data_value);
					}

					if (typeof _options != 'object')
					{
						_options = {};
					}

					// Notation par défaut
					if (!in_array(_options.notation, ['d','dm','dms']))
					{
						_options.notation = GIWIK.latlong_notation;
					}

					// Précision par défaut
					if (typeof _options.precision != 'number')
					{
						_options.precision = GIWIK.latlong_precision;
					}

					var letter,
						raw_value     = Number(data_value),
						abs_value     = Math.abs(raw_value),
						abs_value_str = abs_value.toFixed(_options.precision);

					// Si latitude
					if (data_type == 'latitude')
					{
						// Si le firmware renvoie des valeurs de 0 à 180°, on convertit les valeurs comprises entre 90 et 180°
						if (data_value > 90) {data_value -= 180;}
						letter = (data_value < 0) ? 'S' : 'N';
						if (data_value < -90 || data_value > 90) {return GIWIK.data.coordinates.latlong.err_value;}
					}
					// Si longitude
					else if (data_type == 'longitude')
					{
						// Si le firmware renvoie des valeurs de 0 à 360°, on convertit les valeurs comprises entre 180 et 360°
						if (data_value > 180) {data_value -= 360;}
						letter = (data_value < 0) ? 'W' : 'E';
						if (data_value < -180 || data_value > 180) {return GIWIK.data.coordinates.latlong.err_value;}
					}

					// Si la valeur a changé suite aux traitements ci-dessus, on actualise la valeurs absolue et sa version sous forme de string
					if (data_value !== raw_value)
					{
						abs_value = Math.abs(data_value);
						abs_value_str = abs_value.toFixed(_options.precision);
					}

					// Adaptation de la précision en fonction de la notation
					if (_options.notation == 'dm')
					{
						_options.precision -= 2;
					}
					else if (_options.notation == 'dms')
					{
						_options.precision -= 4;
					}

					// La précision ne peut pas être négative
					if (_options.precision < 0)
					{
						_options.precision = 0;
					}

					if (in_array(_options.notation, ['dm','dms']))
					{
						var _deg_split = abs_value_str.split(".");
						var deg = _deg_split[0];
						var min = (_deg_split[1]) ? Number('0.'+_deg_split[1]) * 60 : 0;

						if (_options.notation == 'dms')
						{
							var _min_split = min.toString(10).split('.');
							var min_int = _min_split[0];
							var min_dec = (_min_split[1]) ? _min_split[1] : 0;
							var sec = Number('0.'+min_dec) * 60;
						}
					}

					// console.log(data_name+" : "+_options.precision+" ("+raw_value+"->"+data_value+"->"+abs_value+")");
					// console.log(deg+MSG(['units','degree'])+''+minutes+'\''+lat_sec.toFixed(_options.precision)+'" '+letter);

					switch (_options.notation)
					{
						case 'd'  : return abs_value.toFixed(_options.precision)+MSG(['units','degree'])+' '+letter; break;
						case 'dm' : return deg+MSG(['units','degree'])+''+('0'+min.toFixed(_options.precision)).slice(-(_options.precision+3))+'\' '+letter; break;
						case 'dms':	return deg+MSG(['units','degree'])+''+('0'+min_int).slice(-2)+'\''+('0'+sec.toFixed(_options.precision)).slice(-(_options.precision+3))+'" '+letter; break;
					}
				},

				// Converti les notations de latitudes/longitudes de degrés décimaux|degrés minutes décimales|degrés minutes secondes décimales + hémisphère en de degrés décimaux avec signe
				dms2d: function(data_type, data_value, _options)
				{
					// latitude ou longitude sinon return
					if (!in_array(data_type, ['latitude','longitude']))
					{
						return GIWIK.data.coordinates.latlong.err_value;
					}

					// Déduction de la notation passé
					data_value = trim(data_value);

					var	_values = [],
						notation,
						letter,
						sign,
						precision,
						deg,
						deg_int,
						deg_dec,
						deg_signed,
						min,
						min_int,
						min_dec,
						sec,
						sec_int,
						sec_dec,
						letter;

					// options disponibles :
					//		precision : nombre
					if (typeof _options != 'object')
					{
						_options = {};
					}

					// Degrés décimaux
					if (_values = data_value.match(GIWIK.data.coordinates.latlong._regexp.d))
					{
						notation = 'd';

						deg_int = parseInt(_values[1]);
						deg_dec = parseFloat('0.'+_values[2]);
						deg     = deg_int + deg_dec;

						letter = _values[3];
						precision = count_decimals(deg_dec);
					}
					// Degrés minutes décimales
					else if (_values = data_value.match(GIWIK.data.coordinates.latlong._regexp.dm))
					{
						notation = 'dm';

						min_int = parseInt(_values[2]);
						min_dec = parseFloat('0.'+_values[3]);
						min     = min_int + min_dec;

						deg_int = parseInt(_values[1]);
						deg_dec = min / 60;
						deg     = deg_int + deg_dec;

						letter = _values[4];
						precision = count_decimals(min_dec);
					}
					// Degrés minutes secondes décimales
					else if (_values = data_value.match(GIWIK.data.coordinates.latlong._regexp.dms))
					{
						notation = 'dms';

						sec_int = parseInt(_values[3]);
						sec_dec = parseFloat('0.'+_values[4]);
						sec     = sec_int + sec_dec;

						min_int = parseInt(_values[2]);
						min_dec = sec / 60;
						min     = min_int + min_dec;

						deg_int = parseInt(_values[1]);
						deg_dec = min / 60;
						deg     = deg_int + deg_dec;

						letter = _values[5];
						precision = count_decimals(sec_dec);
					}
					else
					{
						return GIWIK.data.coordinates.latlong.err_value;
					}

					//print_r(_values);

					// Définition du signe
					deg_signed = in_array(letter, ['S','W']) ? -1 * deg : deg;

					// Si pas fournie, définition de la précision en fonction de la précision de la valeur source
					if (!(typeof _options.precision == 'number' && _options.precision >= 0))
					{
						_options.precision = precision;
					}

					// Si la valeur est incorrecte (non comprise entre -90 et 90 pour une latitude et entre -180 et 180 pour une longitude)
					if ((data_type == 'latitude'  && !(deg_signed >= -90 && deg_signed <= 90)) ||
					    (data_type == 'longitude' && !(deg_signed >= -180 && deg_signed <= 180)))
					{
						return GIWIK.data.coordinates.latlong.err_value;
					}

					//alert(deg_int+'+'+deg_dec+'='+deg+' '+deg_signed+' toFixed('+_options.precision+')->'+deg_signed.toFixed(_options.precision));

					return deg_signed.toFixed(_options.precision);
				},

				// Définition de la notation des latitudes / longitudes
				setNotation: function()
				{
					var stored_latlong_notation;
					GIWIK.latlong_notation = stored_latlong_notation = STORAGE.get('latlong_notation');

					// Vérification de la validité de la notation stockée
					if (!in_array(stored_latlong_notation, ['d','dm','dms']) || !GIWIK._plugins.options.latlong_notation)
					{
						GIWIK.latlong_notation = (GIWIK.latlong_precision > 0) ? 'dm' : 'd';
					}

					// Si la précision est insuffisante pour la gestion de notation courante
					if (GIWIK.latlong_precision == 0 && GIWIK.latlong_notation != 'd')   {GIWIK.latlong_notation = 'd';}
					if (GIWIK.latlong_precision  < 4 && GIWIK.latlong_notation == 'dms') {GIWIK.latlong_notation = 'dm';}

					// Sauvegarde de la notation si elle a été modifiée par les tests ci-dessus
					if (GIWIK.latlong_notation != stored_latlong_notation)
					{
						STORAGE.setPermanent('latlong_notation', GIWIK.latlong_notation);
					}
				}
			}
		},

		// Gestion des dates
		dates :
		{
			// Construction de la chaine de formatage à évaluer à partir du format de date "date_format" contenu dans giwik.msg
			eval_format : "",

			// Formatage de la date en fonction de la langue (le format de date en fonction de la langue "dd/mm/yyyy" ou "yyyy/mm/dd" est défini dans giwik.msg.js)
			// La date peut-être passée soit :
			// - sous forme de string "dd/mm/yyyy" ou "yyyy/mm/dd" ou "dd/mm/yyyy hh:mm:ss"  ou "yyyy/mm/dd hh:mm:ss"
			//	 ou "dd/mm/yyyy hh:mm:ss.sss" ou "yyyy/mm/dd hh:mm:ss.sss" ou "hh:mm:ss.sss" ou "hh:mm:ss"
			// - sous forme de timestamp UNIX avec ou sans offset (par défaut) en "s" ex. "1293840000" ou en "ms" (détection automatique)
			//   si le timestamp contient directement l'offset local, il faut que le PC client soit paramétré à la même date que le serveur et passer l'option utc:false
			// OPTIONS :
			// format (string)
			//	 -> date  // retourne la date uniquement
			//   -> time  // retourne l'heure uniquement
			//   -> date_time (défaut)  // retourne la date et l'heure
			// utc (boolean):   (cas d'un timestamp uniquement)
			//	 -> indique si le timestamp est au format UTC si true (par défaut, pour n'appliquer aucun offset) ou local si false
			// time_in_ms (boolean):
			//   -> indique si les millisecondes doivent être affichées (par défaut true si les ms sont disponibles dans le timestamp ou la string)
			formate : function (date, _options)
			{
				if (typeof _options != 'object')        {_options = {};}
				if (typeof _options.format != 'string') {_options.format = 'date_time';}

				var time, source_in_ms;

				// Si la date est sous forme de timestamp (nbre de secondes depuis le 1 janvier 1970) sous forme de chaîne ou de nombre
				if (!isNaN(date))
				{
					// Si le timestamp est sous forme de chaîne, on le transforme en nombre
					if (typeof date == 'string') {date = Number(date);}

					source_in_ms = (date > 5000000000) ? true : false; // Détection auto d'un timestamp en ms
					_options.time_in_ms = (source_in_ms && (_options.time_in_ms === true || typeof _options.time_in_ms === 'undefined')) ? true : false; // affichage du temps en ms
					if (typeof _options.utc != 'boolean')             {_options.utc = true;}	// UTC par défaut

					var tstp = (!source_in_ms) ? date*1000 : date,
						d    = new Date(tstp);

					if (_options.format === 'date_time' || _options.format === 'date')
					{
						var date, dd, mm, yyyy;

						if (_options.utc) {dd = d.getUTCDate(); mm = d.getUTCMonth()+1; yyyy = d.getUTCFullYear();}
						else              {dd = d.getDate()   ;	mm = d.getMonth()+1   ; yyyy = d.getFullYear()   ;}

						if (dd < 10) {dd = '0'+dd};
						if (mm < 10) {mm = '0'+mm};

						date = dd+'/'+mm+'/'+yyyy;
					}

					if (_options.format === 'date_time' || _options.format === 'time')
					{
						var hrs, min, sec;

						if (_options.utc) {hrs = d.getUTCHours(); min = d.getUTCMinutes(); sec = d.getUTCSeconds();}
						else              {hrs = d.getHours()   ; min = d.getMinutes()   ; sec = d.getSeconds()   ;}

						if (hrs < 10)  {hrs = '0' +hrs;}
						if (min < 10)  {min = '0' +min;}
						if (sec < 10)  {sec = '0' +sec;}

						time = hrs+':'+min+':'+sec;

						if (source_in_ms && _options.time_in_ms)
						{
							var ms;

							if (_options.utc) {ms = d.getUTCMilliseconds();}
							else              {ms = d.getMilliseconds()   ;}

							if      (ms < 10)  {ms = '00'+ms;}
							else if (ms < 100) {ms = '0' +ms;}

							time += '.'+ms;
						}
					}
				}
				// Si la date est fournie sous forme de chaine ("2015/08/29" ou "29/08/2015" ou "2015/08/29 15:34:12" ou "29/08/2015 15:34:12.873" etc.)
				else if (typeof date == 'string')
				{
					// Si la date est passée avec une heure, on isole la date et l'heure
					if (date.indexOf(' ') !== -1)
					{
						var _split = date.split(' '),
							date   = _split[0],
							time   = (_split.length === 2) ? _split[1] : '';
					}
					// Si une date seule est passée
					else if (date.indexOf('/') !== -1)
					{
						time = '';
					}
					// Si une heure seule est passée
					else
					{
						time = date;
						date = '';
					}

					// Si une heure doit être retournée
					if (_options.format === 'date_time' || _options.format === 'time')
					{
						source_in_ms = (time.indexOf('.') !== -1) ? true : false;

						_options.time_in_ms = ((_options.time_in_ms === true || typeof _options.time_in_ms === 'undefined') && source_in_ms) ? true : false; // affichage du temps en ms

						// Si les ms sont fournies et ne doivent pas être affichées
						if (source_in_ms && !_options.time_in_ms)
						{
							_split = time.split('.'),
							time = _split[0];
						}
					}
				}
				// La date est indéfinie ou dans un format non supporté
				else
				{
					return;
				}

				if (_options.format === 'date_time' || _options.format === 'date')
				{
					// A ce stade la date doit être sous forme de chaîne
					if (typeof date != "string")
					{
						console.log("GIWIK.dates.formate() : wrong date format");
						return;
					}

					// si une date est fournie (il peut s'agir d'une heure)
					if (date)
					{
						// Découpage de la date fournie
						var _date = date.split("/");

						// Si la date est incorrecte
						if (_date.length !== 3)
						{
							console.log("GIWIK.dates.formate() : wrong date format");
							return date;
						}

						var src_date_format = (_date[0].length === 4) ? 'yyyy/mm/dd' : 'dd/mm/yyyy',	// format source
							des_date_format = MSG(['date_format']);										// format cible

						// Si la date n'est pas au bon format pour la langue en cours
						if (src_date_format != des_date_format)
						{
							// Définition des variables dd mm et yyyy en fonction du format source
							switch (src_date_format)
							{
								case 'yyyy/mm/dd': var dd = _date[2], mm = _date[1], yyyy = _date[0]; break;
								case 'dd/mm/yyyy': var dd = _date[0], mm = _date[1], yyyy = _date[2]; break;
							}

							// Si la chaine de formatage n'a pas encore été définie
							if (!this.eval_format)
							{
								// Construction de la chaine de formatage à évaluer à partir du format de date "date_format" contenu dans giwik.msg
								this.eval_format = MSG(['date_format']).replace(/\//g,"+'/'+");
							}
							date = eval(this.eval_format);
						}
					}
				}

				switch(_options.format)
				{
					case 'date'      :           return date;                           break;
					case 'time'      :           return time;                           break;
					case 'date_time' : default : return date+((time) ? (date ? ' ' : '')+time : '');  break;
				}
			}
		},

		// Retourne l'Id DOM d'une donnée particulière
		getDomId : function (data_name)
		{
			// Au 1er passage, définition et stockage des id dom à partir du data_name
			if (!GIWIK.data._dom_ids[data_name])
			{
				GIWIK.data.setDomId(data_name);
			}

			return GIWIK.data._dom_ids[data_name];
		},

		// Stockage des Id DOM d'une donnée particulière
		setDomId : function (data_name)
		{
			// L'ID DOM du paramètre ne peut pas contenir de "." ou de "[]"; Ils sont remplacés par "_" ("]" est purement supprimé)
			GIWIK.data._dom_ids[data_name] = data_name.replace(/(\.|\[['"]?)(\w+)(['"]?\])?/g,"_$2");
		},
		// Adaptation de la précision en fonction de l'unité courante (la précision est initialement définie pour l'unité source)
		getPrecisionForUnit : function (data_name, data_value)
		{
			var _data_info = GIWIK.data.info[data_name],
				data_type  = _data_info.type,
				precision  = _data_info.precision,
				unit       = _data_info.unit,
				data_processed,
				ratio;

			if (typeof precision === 'number' && !isNaN(data_value) && GIWIK.data.types[data_type])
			{
 				data_processed = GIWIK.data.types[data_type].value(data_name, data_value, data_type);

				// Si la donnée traitée est un nombre
				if (!isNaN(data_processed))
 				{
					if (typeof data_processed === 'string')
					{
						data_processed = Number(data_processed);
					}

					if (typeof data_value === 'string')
					{
						data_value = Number(data_value);
					}

					// /* m/s -> c   */ data_value = 1; data_processed = 0.0000000033356409519815;
					// /* °   -> rad */ data_value = 1; data_processed = 0.017453292519943;

					ratio = Math.abs(data_processed / data_value);

					if (ratio > 1)
					{
						if      (ratio >= 1            && ratio < 10          ) {precision -= 0 ;}
						else if (ratio >= 10           && ratio < 100         ) {precision -= 1 ;}
						else if (ratio >= 100          && ratio < 1000        ) {precision -= 2 ;}
						else if (ratio >= 1000         && ratio < 10000       ) {precision -= 3 ;}
						else if (ratio >= 10000        && ratio < 100000      ) {precision -= 4 ;}
						else if (ratio >= 100000       && ratio < 1000000     ) {precision -= 5 ;}
						else if (ratio >= 1000000      && ratio < 10000000    ) {precision -= 6 ;}
						else if (ratio >= 10000000     && ratio < 100000000   ) {precision -= 7 ;}
						else if (ratio >= 100000000    && ratio < 1000000000  ) {precision -= 8 ;}
						else if (ratio >= 1000000000   && ratio < 10000000000 ) {precision -= 9 ;}
						else if (ratio >= 10000000000                         ) {precision -= 10;}
					}
					else if (ratio < 1)
					{
						if      (ratio <= 1            && ratio > 0.1         ) {precision += 0 ;}
						else if (ratio <= 0.1          && ratio > 0.01        ) {precision += 1 ;}
						else if (ratio <= 0.01         && ratio > 0.001       ) {precision += 2 ;}
						else if (ratio <= 0.001        && ratio > 0.0001      ) {precision += 3 ;}
						else if (ratio <= 0.0001       && ratio > 0.00001     ) {precision += 4 ;}
						else if (ratio <= 0.00001      && ratio > 0.000001    ) {precision += 5 ;}
						else if (ratio <= 0.000001     && ratio > 0.0000001   ) {precision += 6 ;}
						else if (ratio <= 0.0000001    && ratio > 0.00000001  ) {precision += 7 ;}
						else if (ratio <= 0.00000001   && ratio > 0.000000001 ) {precision += 8 ;}
						else if (ratio <= 0.000000001  && ratio > 0.0000000001) {precision += 9 ;}
						else if (ratio <= 0.0000000001                        ) {precision += 10;}
					}

					if      (precision < 0 ) {precision = 0 ;}	// precision min de 0
					else if (precision > 10) {precision = 10;}	// precision max de 10

 					// console.log(data_name, data_value, '/', GIWIK.data.types[data_type].value(data_name, data_value, data_type), 'ratio:', ratio, '->', precision);
				}
			}
			return precision;
		},
		// Retourne la précision d'une valeur donnée (valeur sous forme de chaîne) sous forme d'entier (3 pour 10-3)
		getPrecisionFromData : function (data_value, data_type)
		{
			var precision = null;

			// Si la valeur est un nombre ET que son type existe et qu'il n'est pas "other" (--> aucun traitement), on peut déterminer sa précision
			if (!isNaN(data_value) && typeof GIWIK.data.types[data_type] === 'object' && data_type !== 'other')
			{
				switch (typeof data_value)
				{
					case 'number' : data_value = data_value.toString();
					case 'string' : precision = data_value.replace(/^-?(\d)+\./,"").length; break;
				}
			}
			return precision;
		},

		// Retourne la version chaîne d'un data_type passé sous forme de nombre
		getDataTypeFromCode : function (type_code)
		{
			var data_type;

			for (data_type in GIWIK.data.types)
			{
				if (GIWIK.data.types[data_type].code == type_code)
				{
					return data_type;
				}
			}
		},

		// Tableau de gestion de la valeur et de l'unité d'une donnée en fonction de son type
		//	 nom_du_type :
		//	 {
		//	 		code      : 0, // code utilisé pour appel court via GIWIK.data.types[code] au lieu du label
		//			precision : 2, // précision optionnelle à définir dans app.js
		//	 		value     : function (data_name, data_value, data_type) {return XXXXX;}, // traitement sur la valeur
		//	 		unit      : function (data_name, data_value, data_type) {return GIWIK.data.units.getDataTypeUnit(data_name, data_value, data_type);},	// unité courante pour le type
		//	 		units     : function (data_name, data_value, data_type) {return ['meter_per_second2'];},	// liste des unités disponibles pour le type
		//	 		'default' : function (data_name, data_value, data_type) {return this.units(data_name, data_value, data_type)[0];}	// unité par défaut pour le type
		//	 }
		types :
		{
			acceleration : // source : m/s2
			{
				code      : 0,
				precision : null,
				value     : function (data_name, data_value, data_type) {return data_value;},
				unit      : function (data_name, data_value, data_type) {return GIWIK.data.units.getDataTypeUnit(data_name, data_value, data_type);},
				units     : function (data_name, data_value, data_type) {return ['meter_per_second2'];},
				'default' : function (data_name, data_value, data_type) {return this.units(data_name, data_value, data_type)[0];}
			},
			angle : // source : °
			{
				code      : 1,
				precision : null,
				value     : function (data_name, data_value, data_type)
				{
					var value = data_value;

					switch (data_name)
					{
						case 'heading':
						case 'roll':
						case 'pitch': value = GIWIK.data.attitude_convention.process(data_name, data_value, data_type); break;
						default:                                                                                        break;
					}

					switch (GIWIK.data.info[data_name].unit)
					{
						case 'mil'              : value = value / 0.05625;	break;
						case 'milliradian'				: value = value * (3.14159/180) * 1000;	break
						case 'degree' : default : 							break;
					}

					return value;
				},
				unit      : function (data_name, data_value, data_type) {return GIWIK.data.units.getDataTypeUnit(data_name, data_value, data_type);},
				units     : function (data_name, data_value, data_type) {return ['degree','mil'];},
				'default' : function (data_name, data_value, data_type) {return this.units(data_name, data_value, data_type)[0];}
			},
			date : // source : "YYYY/MM/DD" ou "DD/MM/YYYY" ou "YYYY/MM/DD HH:MM:SS(.SSS)?" ou "DD/MM/YYYY HH:MM:SS(.SSS)?" ou timestamp UNIX en s ou ms
			{
				code      : 2,
				precision : null,
				value     : function (data_name, data_value, data_type) {return GIWIK.data.dates.formate(data_value);},
				unit      : function (data_name, data_value, data_type) {return GIWIK.data.units.getDataTypeUnit(data_name, data_value, data_type);},
				units     : function (data_name, data_value, data_type) {return [''];},
				'default' : function (data_name, data_value, data_type) {return this.units(data_name, data_value, data_type)[0];}
			},
			distance : // source : m
			{
				code      : 3,
				precision : null,
				value     : function (data_name, data_value, data_type)
				{
					var value;

					switch (GIWIK.data.info[data_name].unit)
					{
						case 'kilometer'	: value = data_value / (1000);	break;
						case 'meter' : default : value = data_value;
					}

					return value;
				},
				unit      : function (data_name, data_value, data_type) {return GIWIK.data.units.getDataTypeUnit(data_name, data_value, data_type);},
				units     : function (data_name, data_value, data_type) {return ['meter','foot','foot_inch','mile','nautical_mile'];},
				'default' : function (data_name, data_value, data_type) {return this.units(data_name, data_value, data_type)[0];}
			},
			duration : // source : s
			{
				code      : 4,
				precision : null,
				value     : function (data_name, data_value, data_type) {return data_value;},
				unit      : function (data_name, data_value, data_type) {return GIWIK.data.units.getDataTypeUnit(data_name, data_value, data_type);},
				units     : function (data_name, data_value, data_type) {return ['second'];},
				'default' : function (data_name, data_value, data_type) {return this.units(data_name, data_value, data_type)[0];}
			},
			gps_mode : // source : int défini dans giwik.msg.js > MSG.lists.gps_mode
			{
				code      : 5,
				precision : null,
				value     : function (data_name, data_value, data_type) {return MSG(['lists','gps_mode',data_value]);},
				unit      : function (data_name, data_value, data_type) {return GIWIK.data.units.getDataTypeUnit(data_name, data_value, data_type);},
				units     : function (data_name, data_value, data_type) {return [''];},
				'default' : function (data_name, data_value, data_type) {return this.units(data_name, data_value, data_type)[0];}
			},
			height : // source : m (altitude, depth, distance to bottom, heave, surge, sway...)
			{
				code      : 6,
				precision : null,
				value     : function (data_name, data_value, data_type) {return data_value;},
				unit      : function (data_name, data_value, data_type) {return GIWIK.data.units.getDataTypeUnit(data_name, data_value, data_type);},
				units     : function (data_name, data_value, data_type) {return ['meter','foot','foot_inch'];},
				'default' : function (data_name, data_value, data_type) {return this.units(data_name, data_value, data_type)[0];}
			},
			noise : // source : dB
			{
				code      : 7,
				precision : null,
				value     : function (data_name, data_value, data_type) {return data_value;},
				unit      : function (data_name, data_value, data_type) {return GIWIK.data.units.getDataTypeUnit(data_name, data_value, data_type);},
				units     : function (data_name, data_value, data_type) {return ['decibel'];},
				'default' : function (data_name, data_value, data_type) {return this.units(data_name, data_value, data_type)[0];}
			},
			other : // source : N/A	   Used when no unit and no processing are needed
			{
				code      : -1,
				precision : null,
				value     : function (data_name, data_value, data_type) {return data_value;},
				unit      : function (data_name, data_value, data_type) {return GIWIK.data.units.getDataTypeUnit(data_name, data_value, data_type);},
				units     : function (data_name, data_value, data_type) {return [''];},
				'default' : function (data_name, data_value, data_type) {return this.units(data_name, data_value, data_type)[0];}
			},
			position : // source : ° (décimaux)   // gestion des latitude,longitude/utm_zone,utm_east,utm_north en fonction du nom de la donnée
			{
				code      : 8,
				precision : null,
				value     : function (data_name, data_value, data_type) {return in_array(GIWIK.data.info[data_name].stype, ['latitude','longitude']) ? GIWIK.data.coordinates.latlong.d2dmdms(GIWIK.data.info[data_name].stype, data_value) : data_value;},
				unit      : function (data_name, data_value, data_type) {
					return ((in_array(GIWIK.data.info[data_name].stype,['utm','ups','osgb','mgrs','ecef']) && data_name.indexOf('zone') === -1) || (GIWIK.data.info[data_name].stype === 'georef' && data_name.indexOf('altitude') !== -1)) 
					? 'meter' 
					: (GIWIK.data.info[data_name].stype === 'georef' && data_name.match(/(east|north)$/)) 
						? 'minute' 
						: '';
				},
				units     : function (data_name, data_value, data_type) {return ['meter','minute',''];},
				'default' : function (data_name, data_value, data_type) {return this.unit(data_name, data_value, data_type);}
			},
			pressure : // source : hPa
			{
				code      : 17,
				precision : null,
				value     : function (data_name, data_value, data_type) {return data_value;},
				unit      : function (data_name, data_value, data_type) {return GIWIK.data.units.getDataTypeUnit(data_name, data_value, data_type);},
				units     : function (data_name, data_value, data_type) {return ['hectopascal'];},
				'default' : function (data_name, data_value, data_type) {return this.units(data_name, data_value, data_type)[0];}
			},
			rotation : // source °/s
			{
				code      : 9,
				precision : null,
				value     : function (data_name, data_value, data_type) {return data_value;},
				unit      : function (data_name, data_value, data_type) {return GIWIK.data.units.getDataTypeUnit(data_name, data_value, data_type);},
				units     : function (data_name, data_value, data_type) {return ['degree_per_second'];},
				'default' : function (data_name, data_value, data_type) {return this.units(data_name, data_value, data_type)[0];}
			},
			speed : // source m/s
			{
				code      : 10,
				precision : null,
				value     : function (data_name, data_value, data_type)
				{
					var value;

					switch (GIWIK.data.info[data_name].unit)
					{
						case 'knot'                       : value = data_value * (3600/1852);	break;
						case 'foot_per_second'            : value = data_value * 3.28084;  		break;
						case 'kilometer_per_hour'		  : value = data_value * (3600/1000);	break;
						case 'miles_per_hour'		  	  : value = data_value * (3600/1000) * 0.621371;	break;
						case 'meter_per_second' : default : value = data_value;
					}

					return value;
				},
				unit      : function (data_name, data_value, data_type) {return GIWIK.data.units.getDataTypeUnit(data_name, data_value, data_type);},
				units     : function (data_name, data_value, data_type) {return ['meter_per_second','foot_per_second'];},
				'default' : function (data_name, data_value, data_type) {return this.units(data_name, data_value, data_type)[0];}
			},
			temperature : // source °C
			{
				code      : 11,
				precision : null,
				value     : function (data_name, data_value, data_type)
				{
					var value;

					switch (GIWIK.data.info[data_name].unit)
					{
						case 'degree_fahrenheit'           : value = data_value * 9 / 5 + 32;  break;
						case 'degree_celcius'    : default : value = data_value;
					}

					return value;
				},
				unit      : function (data_name, data_value, data_type) {return GIWIK.data.units.getDataTypeUnit(data_name, data_value, data_type);},
				units     : function (data_name, data_value, data_type) {return ['degree_celcius','degree_fahrenheit'];},
				'default' : function (data_name, data_value, data_type) {return this.units(data_name, data_value, data_type)[0];}
			},
			time : // cf. type date
			{
				code      : 12,
				precision : null,
				value     : function (data_name, data_value, data_type) {return GIWIK.data.dates.formate(data_value,{format:data_type});},
				unit      : function (data_name, data_value, data_type) {return GIWIK.data.units.getDataTypeUnit(data_name, data_value, data_type);},
				units     : function (data_name, data_value, data_type) {return [''];},
				'default' : function (data_name, data_value, data_type) {return this.units(data_name, data_value, data_type)[0];}
			},
			latitude : // source : °
			{
				code      : 13,
				precision : null,
				value     : function (data_name, data_value, data_type) {return GIWIK.data.coordinates.latlong.d2dmdms(data_type,data_value);},
				unit      : function (data_name, data_value, data_type) {return GIWIK.data.units.getDataTypeUnit(data_name, data_value, data_type);},
				units     : function (data_name, data_value, data_type) {return [''];},
				'default' : function (data_name, data_value, data_type) {return this.units(data_name, data_value, data_type)[0];}
			},
			longitude : // source : °
			{
				code      : 14,
				precision : null,
				value     : function (data_name, data_value, data_type) {return GIWIK.data.coordinates.latlong.d2dmdms(data_type,data_value);;},
				unit      : function (data_name, data_value, data_type) {return GIWIK.data.units.getDataTypeUnit(data_name, data_value, data_type);},
				units     : function (data_name, data_value, data_type) {return [''];},
				'default' : function (data_name, data_value, data_type) {return this.units(data_name, data_value, data_type)[0];}
			},
			frequency : // source : Hz
			{
				code      : 15,
				precision : null,
				value     : function (data_name, data_value, data_type) {return data_value;},
				unit      : function (data_name, data_value, data_type) {return GIWIK.data.units.getDataTypeUnit(data_name, data_value, data_type);},
				units     : function (data_name, data_value, data_type) {return ['hertz'];},
				'default' : function (data_name, data_value, data_type) {return this.units(data_name, data_value, data_type)[0];}
			},
			percentage : // source : %
			{
				code      : 16,
				precision : null,
				value     : function (data_name, data_value, data_type) {return data_value;},
				unit      : function (data_name, data_value, data_type) {return GIWIK.data.units.getDataTypeUnit(data_name, data_value, data_type);},
				units     : function (data_name, data_value, data_type) {return ['percent'];},
				'default' : function (data_name, data_value, data_type) {return this.units(data_name, data_value, data_type)[0];}
			},
			utm : // source : m
			{
				code      : 18,
				precision : null,
				value     : function (data_name, data_value, data_type) {return data_value;},
				unit      : function (data_name, data_value, data_type) {return GIWIK.data.units.getDataTypeUnit(data_name, data_value, data_type);},
				units     : function (data_name, data_value, data_type) {return ['meter'];},
				'default' : function (data_name, data_value, data_type) {return this.units(data_name, data_value, data_type)[0];}
			}
		},

		// Unités
		units :
		{
			// Récupère l'unité définie pour un type de donnée
			getDataTypeUnit : function (data_name, data_value, data_type)
			{
				// console.log (new Date().getTime()+' '+data_type);

				// print_r(GIWIK.data.info);

				// Cas d'un type de donnée sous forme de code
				if (typeof data_type == 'number')
				{
					// Traduction en "data_type" sous forme de chaîne
					data_type = GIWIK.data.getDataTypeFromCode(data_type);
				}

				// // Unités par défaut
				var _stored_units  = STORAGE.get('units', {}),
					_app_units,
					units,
					unit = "";

				// Si le type est inconnu, on arrête le traitement
				if (!(data_type in GIWIK.data.types))
				{
					return unit;
				}

				// Si le choix des unités doit s'effectuer parmi une liste spécifique fournie dans app.js
				if (GIWIK._plugins.options.units && typeof GIWIK._plugins.options.units[data_type] == 'object')
				{
					units = GIWIK._plugins.options.units[data_type];
				}
				else
				{
					units = GIWIK.data.types[data_type].units(data_name, data_value, data_type);
				}

				// Si l'unité du type de donnée est stockée et qu'elle est valide
				if (_stored_units[data_type] !== undefined && in_array(_stored_units[data_type], units, true))
				{
					unit = _stored_units[data_type];
				}
				// Sinon, on la définit par défaut et on la stocke
				else
				{
					unit = GIWIK.data.types[data_type]['default'](data_name, data_value, data_type);
					_stored_units[data_type] = unit;
					STORAGE.setPermanent('units', _stored_units);
				}

				return unit;
			},

			// Affecte une unité par type de donnée. (efface toute association préexistante)
			// ex de formatage : _units = {speed:'knot',angle:'degree'}
			setDataTypeUnits : function (_units)
			{
				STORAGE.setPermanent('units', _units);
			},
			// Formate l'unité en fonction de la valeur à laquelle elle se rapporte
			formate : function (value, unit)
			{
				return (in_array(typeof value,['number','string']) && value != 'N/A' && unit)
						? ((in_array(unit,['degree','degree_celcius','degree_fahrenheit']) ? '' : ' ') + MSG(['units',unit]))
						: '';
			}
		},

		process : function (data_name, data_value, data_type, _options)
		{
			var _type, value, unit, _data_info, precision, precision_unit;

			if (typeof _options != 'object')
			{
				_options = {};
			}

			// Si la phase d'init n'est pas commencée ou pas terminée -----------
			if (!GIWIK.data.info[data_name] || GIWIK.data.info[data_name].init === true)
			{
				if (!GIWIK.data.info[data_name])
				{
					// Initialisation du tableau des infos de la donnée
					GIWIK.data.initInfo(data_name);
				}

				// stockage de ses infos dans GIWIK.data.info
				GIWIK.data.setInfo(data_name, data_value, data_type, _options);
			}
			//-------------------------------------------------------------------

			_data_info = GIWIK.data.info[data_name];

			// Si la donnée doit être masquée
			if (_data_info.type === false)
			{
				$('#'+GIWIK.data.getDomId(data_name)+'_info').hide();
				return;
			}

			// Si la donnée n'est pas fournie, on saute les traitements
			if (data_value === 'N/A' || data_value === '- - -')
			{
				value = data_value;
				unit  = "";
			}
			else
			{
				// Si la valeur est un écart type, on la traite avec la fonction dédie
				value = (_data_info.is_stddev) ? GIWIK.data.stddev.process(data_name, data_value, _data_info.type) : data_value;

				// Si un type de donnée est défini pour la valeur
				if (_data_info.type !== null)
				{
					_type = GIWIK.data.types[_data_info.type];

					// Si une fonction de traitement est définie pour le type de donnée
					if (typeof _type.value == 'function')
					{
						value = _type.value(data_name, value, _data_info.type);
					}

					// Si une précision est à appliquer
					if (typeof _data_info.precision == 'number')
					{
						// console.log('>>>>>>>>>>>>>>>>>', data_name, 'unit:', _data_info.unit, 'precision:', _data_info.precision);

						// Si la valeur est soous forme de chaîne, on la transforme en nombre
						if (typeof value == 'string' && !isNaN(value))
						{
							value = Number(value);
						}
						// Si la valeur est bien un nombre, on applique la précision
						if (typeof value == 'number')
						{
							value = value.toFixed(_data_info.precision);
						}
					}
				}

				// Récupération de l'unité
				unit = GIWIK.data.units.formate(value, _data_info.unit);

				// Si écart type, ajout de ± avant le return
				if (_data_info.is_stddev)
				{
					value = "±"+value;
				}
			}

			// console.log ("process -> ("+data_name+", "+data_value+", "+data_type+((data_type !== _data_info.type) ? ">"+_data_info.type : "")+") : "+value + unit);

			return value + unit;
		},

		// Tableau de stockage des infos des données
		info :
		{
			// ---- Structure ------
			// data_name :
			// {
			//		init : [boolean] // passe à false à la 1ère exécution de la fonction setInfo pour ne construire ce tableau "data_name" qu'une seule fois
			//		status : [int]   // statut de la donnée
			//		type : [string]
			//		stype : [string] ou [null]
			//		precision : [int] ou [null] si la valeur est une chaîne
			//		unit : [string]		// utilisée à la fois pour les calculs sur la donnée et pour l'affichage de l'unité via "MSG.units". ex. "meter"
			//      is_stddev : [boolean]  // s'il s'agit d'un écart type
			//      parent : [object {name:xxxx,type:xxxx}] si écart type ou [null] sinon   // Si écart type, stockage des infos de la donnée parente
			// }
		},

		// Initialisation du tableau d'informations de la donnée
		initInfo : function (data_name)
		{
			// console.log('initInfo '+data_name);

			GIWIK.data.info[data_name] =
			{
				init   : true,		// passera à false à la 1ère exécution de la fonction setInfo
				status : 1
			};
		},

		// Cas du 1er appel de la fonction pour la donnée : stockage de ses infos dans GIWIK.data.info
		setInfo : function (data_name, data_value, data_type, _options)
		{
			// console.log('setInfo '+data_name);

			var data_stype,
				data_is_stddev,
				precision,
				_data_info = GIWIK.data.info[data_name];

			if (typeof _options != 'object')
			{
				_options = {};
			}

			// Cas d'un type de donnée sous forme de code
			if (typeof data_type == 'number')
			{
				// Traduction en "data_type" sous forme de chaîne
				data_type = GIWIK.data.getDataTypeFromCode(data_type);
			}

			if (data_type == 'position')
			{
				if (data_name.indexOf('latitude') != -1)
				{
					data_stype = 'latitude';
				}
				else if (data_name.indexOf('longitude') != -1)
				{
					data_stype = 'longitude';
				}
				else if (data_name.indexOf('utm') != -1)
				{
					data_stype = 'utm';
				}
				else if (data_name.indexOf('ups') != -1)
				{
					data_stype = 'ups';
				}
				else if (data_name.indexOf('osgb') != -1)
				{
					data_stype = 'osgb';
				}
				else if (data_name.indexOf('mgrs') != -1)
				{
					data_stype = 'mgrs';
				}
				else if (data_name.indexOf('georef') != -1)
				{
					data_stype = 'georef';
				}
				else if (data_name.indexOf('ecef') != -1)
				{
					data_stype = 'ecef';
				}
			}

			// type de donnée (ex. "position")
			//		false si donnée masquée
			// 		null si unité passée à la place d'un type 	-> pas de traitement sur la valeur et prise en compte de l'unité spécifiée
			//		"other" par défaut 							-> pas de traitement sur la valeur et pas d'unité
			//		[type défini dans GIWIK.data.types]		-> possibilité de traitement sur la valeur et gestion automatique de l'unité
			_data_info.type  = (GIWIK.data.types[data_type] || data_type === false) ? data_type : (MSG.units[data_type] ? null : "other");

			// sous-type de donnée (ex. latitude)
			//		null par défaut
			_data_info.stype = (typeof data_stype == 'string') ? data_stype : null;

			// unité de la donnée
			//		si le type de donnée est défini et gère l'unité, elle est définie par ce biais
			//		si le type de donnée est null, on utilise l'unité fournie avec le nom de la donnée
			_data_info.unit  = (_data_info.type === null)
								? data_type
								: ((_data_info.type && typeof GIWIK.data.types[_data_info.type].unit == 'function')
									? GIWIK.data.types[_data_info.type].unit(data_name, data_value, data_type)
									: "");

			// OBSOLETE
			// précision de la donnée, définie à partir du nombre de chiffres après la virgule de la chaine fournie
			//		-> les valeurs DOIVENT être fournies sous forme de chaine pour avoir une précision pertinente
			// GIWIK.data.info[data_name].precision = GIWIK.data.getPrecisionFromData(data_value, data_type);

			// Précision à appliquer (précision de l'unité source, sans tenir compte de l'unité courante)
			// 1) Détermination de la précision (sans tenir compte de l'unité de la donnée)
			// 	 1.1) SI précision forcée directement via les options de la fonction process
			// 	 1.2) OU SI le type de donnée est géré ET qu'une précision est définie pour ce type de donnée
			// 	 1.3) par défaut la précision est déduite du nombre de digits reçu
			// 2) Détermination de la précision en fonction de l'unité de la donnée
			_data_info.precision = (typeof _options.precision == 'number')
						? _options.precision
						: ((GIWIK.data.types[_data_info.type] && typeof GIWIK.data.types[_data_info.type].precision == 'number')
							? GIWIK.data.types[_data_info.type].precision
							: GIWIK.data.getPrecisionFromData(data_value, _data_info.type));

			// console.log(data_name, _data_info.precision, '->', GIWIK.data.getPrecisionForUnit(_data_info.precision, _data_info.unit))

			// Précision à appliquer en fonction de l'unit courante
			_data_info.precision = GIWIK.data.getPrecisionForUnit(data_name, data_value);

			// La donnée est-elle un écart-type
			_data_info.is_stddev = (data_name.indexOf('stddev') != -1) ? true : false;

			// Si la donnée est un écart type, on récupère le nom et le type de la donnée parente
			if (_data_info.is_stddev);
			{
				var data_name_parent = data_name.replace(/_stddev$/i,''),
					data_type_parent = (GIWIK.data.info[data_name_parent] !== undefined) ? GIWIK.data.info[data_name_parent].type : null;
			}

			_data_info.parent = (data_name_parent) ? {name:data_name_parent, type:data_type_parent} : null;

			// Si la donnée est valide et que ses infos sont stockées, la phase d'init est donc terminée.
			_data_info.init   = (data_value === 'N/A') ? true : false;

			// console.log(GIWIK.data.info[data_name]);
		},

		// GIWIK Assigner une couleur aux mesures impactées par un évènement [status, tableau_des_données_impactées]
		setStatus : function (status, event_or_domid)
		{
			var data_name,
				_data = [],
				type,
				i;

			if (typeof status != 'number')
			{
				return;
			}

			// Si le 2ème argument est l'ID d'un élément DOM
			if (event_or_domid !== undefined && document.getElementById(event_or_domid))
			{
				_data.normal = [event_or_domid];	// En "normal" et pas "expert" pour que l'élément soit systématiquement traité
				_data.expert = [];

				// Si un écart type existe pour la donnée, on l'ajoute
				if (document.getElementById(event_or_domid+'_stddev'))
				{
					_data.normal.push(event_or_domid+'_stddev');
				}
			}
			// Si le 2ème argument correspond à un évènement
			else if (event_or_domid !== undefined && GIWIK._data_status_event[event_or_domid])
			{
				_data.normal = GIWIK._data_status_event[event_or_domid].normal;
				_data.expert = GIWIK._data_status_event[event_or_domid].expert;
			}
			// Si aucun évènement particulier n'a été spécifié, toutes les données doivent être impactées par le statut
			else
			{
				_data.normal = array_keys(GIWIK._system_data.normal);	// Récupération des noms des données (clés) dans un tableau
				_data.expert = array_keys(GIWIK._system_data.expert);	// 		"					"				"
			}

			// Boucle sur les sous-tableau "normal" et "expert"
			for (type in _data)
			{
				// Les infos normales concernent toutes les pages (y compris l'expert view)
				// Les infos expertes ne concernent que l'expertview (qui traite donc les infos normales + experte)
				if ((type == 'normal' && HEADING.name != 'control_expertview') || HEADING.name == 'control_expertview')
				{
					// Application des classes css à toutes les données impactées
					for (i=0; i<_data[type].length; i++)
					{
						data_name = _data[type][i];

						// if (data_name != 'time')
						// {
							$('#'+GIWIK.data.getDomId(data_name)+'_info').css('color',GIWIK.css['color_'+status]);

							// Stockage du statut de la donnée dans le tableau GIWIK.data.info -------------------
							if (!GIWIK.data.info[data_name]) {GIWIK.data.initInfo(data_name);}
							GIWIK.data.info[data_name].status = status;
							//------------------------------------------------------------------------------------
						// }
					}
				}
			}
		},

		// liste des normes d'écarts types disponibles
		stddev :
		{
			_pos_norms : ['rms','cep50','cep95'],

			// norme d'écart type par défaut
			pos_norm : 'rms',

			process : function (data_name, data_value, data_type)
			{
				// Cas particulier de "N/A" qu'on affiche tel quel
				if (data_value === 'N/A')
				{
					return data_value;
				}
				else if (isNaN(data_value))
				{
					return data_value;
				}
				else
				{
					data_value = parseFloat(data_value);
				}

				var data_info = GIWIK.data.info[data_name];

				// Checking parent's data type to know if a processing has to be done.
				// Note : height is listed to include altitude/depth. No other "height" data got stddev.
				if (in_array(data_info.parent.type, ['position','latitude','longitude','height','speed','angle']))
				{
					switch (GIWIK.data.stddev.pos_norm)
					{
						case 'cep50' : return ((data_value*0.67).toFixed(data_info.precision)); break;
						case 'cep95' : return ((data_value*2.00).toFixed(data_info.precision)); break;
						case 'rms'   :
						default      :	                                                        break;
					}
				}
				return data_value.toFixed(data_info.precision);
			}
		}
	};

	// // GIWIK.data.types : déclaration des alias par code ex GIWIK.data.types.acceleration === GIWIK.data.types[0]
	// (function () {
	// 	var name, type;

	// 	for (name in GIWIK.data.types)
	// 	{
	// 		type = GIWIK.data.types[name];
	// 		GIWIK.data.types[type.code] = type;

	// 		GIWIK.data.types[type.code].name = name;
	// 		delete GIWIK.data.types[type.code].code;
	// 	}
	// }());


// PLUGINS ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————

	// Teste la disopnibilité d'un plugin en fonction de la rubrique en cours
	// options : {required_by:nom_du_plugin_requierant_l_autre_plugin} -> spécifie que la présence du plugin est obligatoire. Affiche une alerte en cas d'absence du plugin
	GIWIK.isPluginAvailable = function (name, _options)
	{
		if (!_options)
		{
			var _options = {};
		}

		var plugin_available = GIWIK._plugins[name] &&
			                   (in_array(GIWIK._plugins[name].use_on, [HEADING.name, 'all_headings']) || in_array(HEADING.name, GIWIK._plugins[name].use_on));

		if (!plugin_available && _options.required_by)
		{
			alert(MSG(['debug','plugin_required']).replace(/%host_plugin%/,_options.required_by).replace(/%required_plugin%/,name));
		}
		return plugin_available;
	};


// FENÊTRE (GIWIK.window) ———————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————

	GIWIK.window =
	{
		// Récupération des dimensions de la fenêtre courante sous forme d'un tableau [0 => width, 1 => height]
		getDimensions : function ()
		{
			// Cas particulier des anciennes version d'IE
			if (GIWIK._context.ie < 9)
			{
				// IE<9 doivenet attendre l'évènement "load" pour retourner la taille de la fenêtre
				if (!(document.body)) {return false;}

				// IE<9 ne calcule pas la largeur de la même façon au niveau de la barre de scroll, on compense donc de 21px
				return [document.body.offsetWidth+21, document.body.offsetHeight];
			}

			// Cas standard
			return [window.innerWidth, window.innerHeight];
		},

		// Définition des dimensions de la fenêtre courante ()
		setDimensions : function (width, height)
		{
			// Par défaut la largeur ne change pas
			if (!width)
			{
				// var width  = $('body').width(); // pause problème sous Windows : la fenêtre rétréci au rechargement
				var width  = (window.innerWidth) ? window.innerWidth : document.body.clientWidth;
			}

			// Par défaut la hauteur se calle sur la hauteur du contenu (body)
			if (!height)
			{
				var height = $('body').height();
			}

			height += 60;	 // (GIWIK._context.gecko ? 70 : 60) pour gecko dans le cas où la barre d'état est affichée (elle rogne sur la hauteur disponible)

			if (GIWIK._context.windows)
			{
				width  += 16;
				height += 17;

				// Pour contrer les 2 liserés noirs d'1px
				if (GIWIK._context.gecko)
				{
					width  += 2;
				}
			}

			window.resizeTo(width, height);
		},
		getHash : function ()
		{
			return window.location.hash.replace('#','');
		},
		setHash : function (hash)
		{
			window.location.hash = hash;
		},
		// Detection du mode d'affichage de la page (full, medium ou small) en fonction de sa largeur
		getSize : function ()
		{
			var width = GIWIK.window.getDimensions()[0];
			var size = null;

			// Définition de la limite entre l'état medium et l'état full en fonction du mode d'affichage de l'IHM (compact ou standard)
			if (GIWIK.ihm_compactmode)
			{
				if (width < 627)
				{
					size = 'small';

					GIWIK.css_compactmode = 'compact';
				}
				else
				{
					size = 'full';

					GIWIK.css_compactmode = 'compact';
				}
			}
			else
			{
				if (width < 641)
				{
					size = 'small';
				}
				else if (width < 771)
				{
					// Si les boutons sont absents alors que le mode compact est désactivé, on passe directement à "small"
					size = (typeof GIWIK._maincontrol_buttons != 'object') ? 'small' : 'medium';
				}
				else
				{
					size = 'full';
				}

				GIWIK.css_compactmode = '';
			}

			width = null;

			// Pour les appareils mobiles, on reste toujours en taille "small"
			if (GIWIK._context.mobile_device) {return 'full';}

			return size;
		},

		// Redimensionnement d'une fenêtre pour occuper toute la hauteur disponible à l'écran
		setFullHeight : function (action)
		{
			var new_width = null;
			var new_height = null;

			switch (action)
			{
				case 'show':
					if (GIWIK._context.ie < 9)
					{
						new_height = screen.height - window.screenTop;
					}
					else if (GIWIK._context.opera)
					{
						new_height = window.opener.outerHeight - window.screenTop + 50;
					}
					else
					{
						new_height = screen.height - window.screenY - 50;
					}
					window.resizeTo(window.popup_init_width,new_height);
					break;

				default:
					new_width = window.popup_init_width;
					new_height = window.popup_init_height;
					window.resizeTo(window.popup_init_width,window.popup_init_height);
					break;
			}
		},

		// Ouverture d'une nouvelle fenêtre
		open : function (page, title, width, height, top, left, options)
		{
			if (top  == 'auto') {top  = (screen.height-height)/2 - 50;} // -50 pour compenser l'épaisser des barres de menus du navigateur
			if (left == 'auto') {left = (screen.width-width)/2;}

			// Stockage du nom de tous les popups dans le cookie de session ——————————————————————————————
			// Utilisation de setTimeout pour s'assurer de l'exécution du script
			// (sous Firefox, il n'est exécuté qu'au 2ème clic sur le lien d'ouverture du popup)
			setTimeout("var _popups = STORAGE.get('popupwin');"

			+"if (!_popups || _popups.constructor !== Array)"
			+"{"
				+"_popups = [];"
			+"}"

			+"if (!in_array('"+title+"', _popups))"
			+"{"
				+"_popups.push('"+title+"');"

				+"STORAGE.set('popupwin', _popups);"
			+"}"
			/*+"print_r(STORAGE.get('popupwin'));"*/, 1000);
			// ———————————————————————————————————————————————————————————————————————————————————————————

			// Overture du popup, le tout stocké dans une variable pour pouvoir agir sur le popup depuis une autre fenêtre
			window[title] = window.open(page, title, "top="+top+",left="+left+", width="+width+", height="+height+", "+options);

			// Si la fenêtre a bien été ouverte (-> non bloquée)
			if (window[title])
			{
				window[title].focus();
			}
		},

		// Construction d'une chaine d'appel à la fonction d'ouverture de popup GIWIK.window.open(). Gestion auto du nom du popup et de sa hauteur en fonction de la hauteur du logo produit (1 ou 2 lignes)
		constructOpenString : function (link, width, height, top, left, options)
		{
			if (GIWIK._systems[GIWIK.system_type].logo_2ndline())
			{
				height = height+10;
			}

			if (!options)
			{
				options = "toolbar=0, menubar=0, status=0, resizable=0, scrollbars=0";
			}

			var ow_name =  GIWIK.window.getName(GIWIK.window.getFolderName(link));

			return "javascript:GIWIK.window.open('"+link+"', '"+ow_name+"', "+width+", "+height+", "+top+", "+left+", '"+options+"')";
		},

		getName : function (folder)
		{
			if (typeof folder == 'undefined')
			{
				return window.name;
			}

			if (typeof folder == 'string' && folder.match(/[.\/]/))
			{
				folder = GIWIK.window.getFolderName(folder);
			}

			return GIWIK.system_name+"_"+folder.replace(/[\.\/]+/g,"");
		},

		getFolderName : function (url)
		{
			var _split = url.split("/");

			for (var i=_split.length; i>=0; i--)
			{
				if (_split[i] && _split[i].match(/^\w+$/))
				{
					return _split[i];
				}
			}
		},

		// Application du titre HTML du document (avec par défaut "nom_du_produit - IXBLUE"). Le paramètre "name" permet de remplacer le nom du produit.
		setTitle : function (name)
		{
			if (typeof name !== 'string' || name === "")
			{
				var name = GIWIK.system_name.replace(/_+/gi, " ");
			}
			document.title = name+" - IXBLUE";
		}
	};

	GIWIK.window.resize = GIWIK.window.setDimensions;


// RÉSEAU ———————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————

	// Appel asynchrone PONCTUEL d'une URL (CGI, PHP etc.)
	GIWIK.ajax = function (url, _options)
	{
		// liste des options (celles-ci prévallent sur les options globales définies dans app.js) ---------------------------------------------------------------------------
		// eval_rtxt (boolean)			pour mettre en mémoire un code JavaScript valide retourné par le serveur
		// replace_standard_callback 	(function ou string) mise en place d'un callback en remplacement du callback standard (GIWIK.analyzeResponseText())
		// before_standard_callback		(function ou string) mise en place d'un callback additionnel appelé AVANT l'analyse standard par GIWIK.analyzeResponseText()
		// after_standard_callback		(function ou string) mise en place d'un callback additionnel appelé APRÈS l'analyse standard par GIWIK.analyzeResponseText()
		// before_data_group_processing (function ou string) fonction appelée AVANT GIWIK.analyzeResponseText.dataGroup (utile pour une fusion de statuts par ex. GAPS & PHINS)
		// w3c_cgi_syntax (boolean)		syntaxe W3C pour la requête ("=" obligatoire pour chaque paramètre)
		// response_headers_nocache 	(boolean)	"false" pour indiquer que l'embarqué ne retourne pas de headers http permettant d'éviter la mise en cache
		// _mode6 (boolean)				activation de la mécanique de contrôle de prise en compte par l'embarqué (mode 6)
		// _mode6.specific_params		Définition des paramètres à utiliser en remplacement des paramètres passés au mode 4
		// _error_callback				(function si pas de distinction entre les codes d'erreurs, objet {code1:function,code2:function...} sinon
		//								Définition d'actions callback en cas d'erreur HTTP
		// 								Code	Description
		// 								100		Continue
		// 								101		Switching protocols
		// 								200		OK
		// 								201		Created
		// 								202		Accepted
		// 								203		Non-Authoritative Information
		// 								204		No Content
		// 								205		Reset Content
		// 								206		Partial Content
		// 								300		Multiple Choices
		// 								301		Moved Permanently
		// 								302		Found
		// 								303		See Other
		// 								304		Not Modified
		// 								305		Use Proxy
		// 								307		Temporary Redirect
		// 								400		Bad Request
		// 								401		Unauthorized
		// 								402		Payment Required
		// 								403		Forbidden
		// 								404		Not Found
		// 								405		Method Not Allowed
		// 								406		Not Acceptable
		// 								407		Proxy Authentication Required
		// 								408		Request Timeout
		// 								409		Conflict
		// 								410		Gone
		// 								411		Length Required
		// 								412		Precondition Failed
		// 								413		Request Entity Too Large
		// 								414		Request-URI Too Long
		// 								415		Unsupported Media Type
		// 								416		Requested Range Not Suitable
		// 								417		Expectation Failed
		// 								500		Internal Server Error
		// 								501		Not Implemented
		// 								502		Bad Gateway
		// 								503		Service Unavailable
		// 								504		Gateway Timeout
		// 								505		HTTP Version Not Supported
		//-------------------------------------------------------------------------------------------------------------------------------------------------------------------


		// Si XMLHttpRequest non supporté par le navigateur -------------------------
		if (!window.XMLHttpRequest)
		{
			alert("XMLHTTPRequest missing...");
			return;
		}
		// l'url doit être de type string -------------------------------------------
		if (typeof url != 'string')
		{
			return false;
		}
		//---------------------------------------------------------------------------


		// Si l'objet "_options" n'est pas défini, on l'initialise vide
		if (typeof _options != 'object' || _options === null)
		{
			var _options = {};
		}


		// Si le system requiert une syntaxe CGI W3C (notamment niveau "=")
		if (_options.w3c_cgi_syntax === false || (typeof _options.w3c_cgi_syntax != 'boolean' && GIWIK.w3c_cgi_syntax === false)) // Spécifié dans app.js ou directement dans les options de la requête
		{
			url = url.replace(/=(&|$)/g, "$1");
		}

		// **OBSOLETE** Si le serveur web ne renvoie pas d'headers (cf ci-dessous) permettant d'éviter la mise en cache par le navigateur, on ajoute un paramètre à l'url à charger (n millisecondes depuis 1er janvier 70)
		// Cache-Control : no-cache, no-store, must-revalidate, post-check=0, pre-check=0
		// Expires : Thu, 19 Nov 1981 08:52:00 GMT
		if (_options.response_headers_nocache === false || (typeof _options.response_headers_nocache != 'boolean' && GIWIK.response_headers_nocache === false)) // Spécifié dans app.js ou directement dans les options de la requête
		{
			url += ((url.indexOf('?') == -1) ? '?' : '&')+'ms='+new Date().getTime();
		}

		// Si mode json et que le paramètre supplémentaire "json" est demandé
		if (GIWIK._plugins.json && GIWIK._plugins.json.url_param === true)
		{
			url += "&json=1";
		}

		// Création de l'objet XMLHttp
		var HTTP_request = new XMLHttpRequest();
		HTTP_request.open("GET", url, true);

		// Contre la mise en cache
		HTTP_request.setRequestHeader('Cache-Control','no-store, no-cache, must-revalidate');


		HTTP_request.onreadystatechange = function ()
		{
			if (HTTP_request.readyState == 4)
			{
				// Si la requète a abouti
				if (HTTP_request.status == 200)
				{
					var rtxt  = HTTP_request.responseText;																			// string de réponse
					var ctype = (HTTP_request.getResponseHeader('Content-Type').indexOf("/json") != -1) ? "json" : "javascript";	// header "Content-Type" pour détection json / javascript (par défaut)

					// Ca particulier des options qui annulent l'appel automatique à GIWIK.analyzeResponseText
					if (typeof _options.eval_rtxt != 'undefined' || typeof _options.replace_standard_callback != 'undefined')
					{
						// Si un eval de la réponse est spécifié (-> le code renvoyé doit être du JavaScript valide)
						if (_options.eval_rtxt === true)
						{
							// Mise en mémoire des données reçues
							GIWIK.ajax.store(url, rtxt, ctype);
						}

						// Si un callback particulier est spécifié sous forme de string (en remplacement du callback standard)
						if (typeof _options.replace_standard_callback == 'string')
						{
							eval(_options.replace_standard_callback);
						}
						// - sous forme de fonction
						else if (typeof _options.replace_standard_callback == 'function')
						{
							_options.replace_standard_callback(rtxt, ctype);
						}
					}
					// Par défaut, la réponse est analysée par GIWIK.analyzeResponseText()
					else
					{
						// Si une fonction de callback pre analyse standard est définie sous forme de string
						if (typeof _options.before_standard_callback == 'string')
						{
							eval(_options.before_standard_callback);
						}
						// - sous forme de fonction
						else if (typeof _options.before_standard_callback == 'function')
						{
							_options.before_standard_callback(rtxt, ctype);
						}

						// Exécution du callback standard
						GIWIK.analyzeResponseText(url, rtxt, ctype, _options);

						// Si une fonction de callback post analyse standard est définie sous forme de string
						if (typeof _options.after_standard_callback == 'string')
						{
							eval(_options.after_standard_callback);
						}
						// - sous forme de fonction
						else if (typeof _options.after_standard_callback == 'function')
						{
							_options.after_standard_callback(rtxt, ctype);
						}
					}
				}
				// Si un callback d'erreur correspondant au code de statut HTTP a été définie
				else if (_options._error_callback && (in_array(typeof _options._error_callback, ['string','function']) || in_array(typeof _options._error_callback[HTTP_request.status], ['string','function'])))
				{
					// Action "tous codes d'erreur" sous forme de string
					if (typeof _options._error_callback == 'string')
					{
						eval(_options._error_callback);
					}
					// Action "tous codes d'erreur" sous forme de fonction
					else if (typeof _options._error_callback == 'function')
					{
						_options._error_callback(url, _options, HTTP_request.status);
					}
					else if (typeof _options._error_callback[HTTP_request.status] == 'string')
					{
						eval(_options._error_callback[HTTP_request.status]);
					}
					// Action "tous codes d'erreur" sous forme de fonction
					else if (typeof _options._error_callback[HTTP_request.status] == 'function')
					{
						_options._error_callback[HTTP_request.status](url, _options, HTTP_request.status);
					}
				}
				// Si la requète n'a pas abouti
				else
				{
					GIWIK.analyzeHTTPError(url, _options, HTTP_request.status);
				}
				HTTP_request = null;
			}
		};
		HTTP_request.send(null);
	};

	// Stockage des informations reçues
	GIWIK.ajax.store = function (url, rtxt, ctype, _url_params)
	{
		if (typeof _url_params != "object")
		{
			// Récupération des paramètres GET sous forme de tableau
			var _url_params = GIWIK.getParamsFromString(url);
		}

		var param;

		try
		{
			// Gestion de l'effacement des données en mémoire ---------------------------------------------------------------------------------------------
			for (param in _url_params)
			{
				// Si le paramètre en mémoire est un tableau (associatif ou pas), on efface les données en mémoire
				if (typeof window[system][param] == 'object')
				{
					switch (window[system][param].constructor)
					{
						case Array  : window[system][param] = []; break;
						case Object : window[system][param] = {}; break;
					}
				}
			}
			//----------------------------------------------------------------------------------------------------------------------------------------------

			// Si la réponse est en json
			if (ctype == 'json')
			{
				GIWIK.analyzeJSON(rtxt);
			}
			else
			{
				eval(rtxt);
			}
		}
		catch (e)
		{
			throw new Error("Error processing following response from URL "+url+' : '+rtxt);
		}
	};

	// Traitement de la réponse à toute requête HTTP passée via GIWIK.ajax
	GIWIK.analyzeResponseText = function (url, rtxt, ctype, _options)
	{
		// Si l'objet "_options" n'est pas défini, on l'initialise vide
		if (typeof _options != 'object') {var _options = {};}

		// Récupération des paramètres GET sous forme de tableau
		var _url_params = GIWIK.getParamsFromString(url);

		var mode      = _url_params['mode'],	// Mode de communication IHM<->serveur (lecture, écriture, commande etc.)
			get_conf  = false,					// Flag pour récupération des données
			read_conf = false,					// Flags pour lecture des données
			param,								// Nom d'un paramètre passé
			arg;								// Argument d'un paramètre

		// Récupération de l'heure du client
		GIWIK.update_date = new Date();

		// Sauvegarde de l'heure de la dernière réponse de l'embarqué
		GIWIK.last_refresh_time = GIWIK.update_date.getTime();

		// Mise en mémoire des données reçues
		GIWIK.ajax.store(url, rtxt, ctype, _url_params);

		if (typeof _url_params['mode'] != 'undefined')
		{
			mode = parseInt(mode);
		}

		switch (mode)
		{
			// S'il s'agit d'un mode de lecture de données de contrôle (0:mode léger, 1:mode standard, 2: mode expert)
			case 0:
			case 1:
			case 2:
			{
				if (GIWIK.analyzeResponseText.dataGroup(ctype, _options))
				{
					get_conf = true;
				}
				break;
			}

			// LECTURE DE PARAMÈTRES
			case 3:
			{
				for (param in _url_params)
				{
					if (in_array(param,['mode','ms'])) {continue;}

					// S'il s'agit d'un mode de lecture de données de contrôle (0:mode léger, 1:mode standard, 2: mode expert)
					if (param == 'DataGroup')
					{
						if (GIWIK.analyzeResponseText.dataGroup(ctype, _options))
						{
							get_conf = true;
						}
					}
					// Pour tous les paramètres autres que DataGroup
					else
					{
						// on demande l'actualisation des valeurs dans la page en cours pour vérifier leur bonne prise en compte
						read_conf = true;
					}
					break;
				}
				break;
			}

			// ÉCRITURE DE PARAMÈTRES
			case 4:
			{
				// Si l'option est activée dans app.js -> on sauvegarde dans la prom (un getConf() suivra automatiquement)
				if (GIWIK.save_to_prom_needed)
				{
					GIWIK.ajax(GIWIK.cgifile+"?mode=5&cmd=2");
				}
				// Si un mode 6 est nécessaire (déclaré globalement dans app.js et pas désactivé par l'option _mode6:false)
				else if (GIWIK._mode6 && _options._mode6 !== false)
				{
					// Récupération des paramètres passés (autres que "mode" et l'éventuel "ms")
					var conf_params = '';

					// Si des paramètres spécifiques doivent être passés en mode 6
					if (_options._mode6 && typeof _options._mode6._specific_params == 'object')
					{
						for (var param in _options._mode6._specific_params)
						{
							conf_params += '&'+param+'='+_options._mode6._specific_params[param];
						}
					}
					else
					{
						for (var param in _url_params)
						{
							if (in_array(param,['mode','ms'])){continue;}

							conf_params += '&'+param+'=';

							// Cas particuliers des paramètres qui nécessitent le passage d'un ID OU des paramètres qui nécessitent le passage de 2 ID
							if (in_array(param, GIWIK._mode6._id_asking) || in_array(param, GIWIK._mode6._2id_asking))
							{
								// S'il n'existe pas déjà, initialisation du tableau "_updated" correspondant au paramètre
								if (typeof window[system][param+'_updated'] != 'object')
								{
									window[system][param+'_updated'] = [];
								}

								// Découpage des éventuels couples de valeur
								var _value_groups = _url_params[param].split(';');

								// Ajout du ou des ID (si plusieurs, séparés par des ",")
								var n = 0;
								var id;
								for (var i in _value_groups)
								{
									if (_value_groups[i] != "")
									{
										if (n>0){conf_params += ',';}

										if (in_array(param, GIWIK._mode6._id_asking))
										{
											id = _value_groups[i].match(/^\d+/)[0];
											conf_params += id;

											// Remise à "false" de tous les flags de mise à jour concernés
											window[system][param+'_updated'][id] = false;
										}
										else if (in_array(param, GIWIK._mode6._2id_asking))
										{
											id = _value_groups[i].match(/^(\d+),(\d+)/);
											conf_params += id[1]+","+id[2];

											// Remise à "false" de tous les flags de mise à jour concernés
											window[system][param+'_updated'][id] = false;
										}
										n++;
									}
								}
								n = null;
								id = null;
								_value_groups = null;
							}
							else
							{
								// Remise à "false" de tous les flags de mise à jour concernés
								window[system][param+'_updated'] = false;
							}

						}
					}

					// Envoi de la requète dans n ms
					setTimeout("GIWIK.ajax('"+GIWIK.cgifile+"?mode=6"+conf_params+"');", GIWIK._mode6.frequency);
				}
				// Cas des produits sans save_to_prom ni mode6
				else
				{
					get_conf = true;
				}
				break;
			}

			// COMMANDE
			case 5:
			{
				// S'il s'agit d'un "save to prom", on demande une lecture de conf dans la foulée
				if (GIWIK.save_to_prom_needed && _url_params['cmd'] && _url_params['cmd'] == 2)
				{
					get_conf = true;
				}
				break;
			}

			// CONTROLE DE PRISE EN COMPTE D'ECRITURE
			case 6:
			{
				get_conf = true;
				var url_md5 = md5(url);

				// Tableau global stockant le nombre de tentatives mode6 effectuées pour une url
				if (typeof GIWIK._mode6_retry_count != 'object')          {GIWIK._mode6_retry_count = [];}
				if (typeof GIWIK._mode6_retry_count[url_md5] != 'number') {GIWIK._mode6_retry_count[url_md5] = 0;}

				var cond;
				// On vérifie que tous les paramètres ont bien été pris en compte par l'embarqué
				for (var param in _url_params)
				{
					if (in_array(param,['mode','ms'])){continue;}

					// Construction de la condition en fonction de la nature du paramètre (Transp ou nom)
					cond = '';

					// Cas particuliers des paramètres qui nécessitent le passage d'un ID (auquel peuvent correspondrent plusieurs ID donc plusieurs "_updated")
					if (in_array(param, GIWIK._mode6._id_asking))
					{
						// Découpage des ID
						var _id = _url_params[param].split(',');

						// Ajout du ou des ID (si plusieurs, séparés par des ",")
						var n = 0;
						for (var i in _id)
						{
							if (_id[i] != "")
							{
								if (n>0){cond += ' || ';}

								cond += "!window[system]."+param+"_updated["+_id[i]+"]";
								n++;
							}
						}
						_id = null;
					}
					// Cas particuliers des paramètres qui nécessitent le passage de 2 ID (-> 1 seul "_updated")
					else if (in_array(param, GIWIK._mode6._2id_asking))
					{
						cond += "!window[system]."+param+"_updated['"+_url_params[param]+"']";
					}
					else
					{
						cond += "!window[system]."+param+"_updated";
					}
					//alert(cond);
					// Si au moins 1 paramètre n'est pas encore pris en compte, on relance un mode 6 dans n ms
					if (eval(cond))
					{
						GIWIK._mode6_retry_count[url_md5]++;

						// Si on n'a pas dépassé le nombre max de mode6 pour cette requète, on bloque le getConf() et on relance un mode6
						if (GIWIK._mode6_retry_count[url_md5] < GIWIK._mode6.max_retry)
						{
							get_conf = false;
							setTimeout("GIWIK.ajax('"+url+"');", GIWIK._mode6.frequency);
						}
						break;
					}
				}
				cond = null;

				// Si getConf() va être appelée (== tous les paramètres ont bien été pris en compte par l'embarqué), on remet le compteur à 0 pour cette requète
				if (get_conf)
				{
					GIWIK._mode6_retry_count[url_md5] = 0;
				}

				url_md5 = null;
				break;
			}
			default:
		}

		// RÉCUPÉRATION DE LA CONF DEMANDÉE
		if (get_conf)
		{
			HEADING.getConf();
		}
		// LECTURE DE LA CONF DEMANDÉE ("else if" car la récupération induit une lecture de conf)
		else if (read_conf)
		{
			HEADING.readConf();
		}
	};

	// Gestion dynamique du type de système
	GIWIK.analyzeResponseText.systemType = function (system_type)
	{
		// Si l'embarqué renvoie un system_type (gestion dynamique du type de système)
		if (typeof system_type == 'number')
		{
			// Si le system_type renvoyé par l'embarqué ne correspond pas à la valeur en mémoire OU si on se trouve en attente de confirmation du system_type
			if (system_type !== GIWIK.system_type || GIWIK.system_type_has_to_be_confirmed)
			{
				// Si le system_type renvoyé est valide ET pas déjà stocké dans le cookie (cette dernière condition pour que le SYSTEM.system_type ait toujours le dessus sur un GIWIK.system_type écrit en dur dans app.js)
				if (GIWIK._systems[system_type])
				{
					// Stockage de la valeur
					STORAGE.setPermanent('system_type', system_type);

					// Suppression du garde-fou lors d'un changemet de page
					window.onbeforeunload = null;

					// on recharge la page
					window.location.reload();
					return false;
				}
				// Si le system_type n'est pas valide ET que is_started = false ET qu'on ne se trouve pas déjà sur la page de loading
				else if (window[system].is_started === false && !GIWIK.preload_mode)
				{
					// Stockage de la valeur
					STORAGE.setPermanent('system_type', system_type);

					// Suppression du garde-fou lors d'un changemet de page
					window.onbeforeunload = null;

					// Refirection vers la page de chargement
					GIWIK.goToPreloadPage();
					return false;
				}
				// Si le system_type renvoyé est faux ET que is_started = true, on est face à un système vierge (usine)
				else if (window[system].is_started === true && STORAGE.get('system_type') !== 0)
				{
					// On force le system_type par défaut
					STORAGE.setPermanent('system_type', 0);

					// Suppression du garde-fou lors d'un changemet de page
					window.onbeforeunload = null;

					// on recharge la page
					window.location.reload();
					return false;
				}
			}
		}
	};

	// Traitement de la partie "dataGroup"
	GIWIK.analyzeResponseText.dataGroup = function (ctype, _options)
	{
		// Si une fonction de callback pré traitement du groupe de données est définie sous forme de string -------------------------------------
		if (_options && typeof _options.before_data_group_processing == 'string')
		{
			if(eval(_options.before_data_group_processing) === false)
			{
				return false;
			}
		}
		// Sous forme de fonction
		else if (_options && typeof _options.before_data_group_processing == 'function')
		{
			if(_options.before_data_group_processing() === false)
			{
				return false;
			}
		}
		//---------------------------------------------------------------------------------------------------------------------------------------

		// Gestion dynamique du type de système
		if (GIWIK.analyzeResponseText.systemType(window[system].system_type) === false)
		{
			return;		// Le traitement du type de système nécessite un rechargement ou un changement d'URL
		}

		// Demande un getConf ultérieur
		var get_conf = false;

		// Si on sort d'une phase de perte de connexion
		if (GIWIK.connection_lost)
		{
			GIWIK.connection_lost = false;	// retour à false du flag de perte de connexion
			var connection_back = true;		// flag local indiquant le retour de la connexion suite à une perte
		}

		// Si l'état démarré/arrêté du système a changé ou qu'on sort d'une phase de perte de connexion
		if (window[system].is_started !== GIWIK.system_is_started || connection_back)
		{
			if (window[system].is_started === true)
			{
				// Si on sort d'une phase de perte de connexion on recharge la configuration
				if (connection_back)
				{
					get_conf = true;
				}

				// Lors de la toute première réponse ET cas d'un système sans _ui_status
				if (window[system]._ui_status === undefined)
				{
					// Récupération automatique de la conf
					get_conf = true;
				}
				// Lors de la toute première réponse ET si le tableau _ui_status est disponible, gestion des statuts système
				else if (GIWIK._ui_status === undefined)
				{
					// Initialisation de la variable destinée à stocker la conf des statuts
					GIWIK._ui_status = [];

					// Si pas déjà défini, instanciation de l'objet listant les modules de statuts détaillés (page control)
					if (typeof GIWIK._ds_sensors == 'undefined')
					{
						GIWIK._ds_sensors = [];
					}

					// Copie du tableau des capteurs des statuts détaillés vers le tableau global des capteurs (qui contient en plus les transpondeurs éventuels)
					GIWIK._sensors = array_copy(GIWIK._ds_sensors);

					// Instanciation du tableau d'états des modules (par défaut, tous les modules sont en état ok)
					GIWIK._sensors_status = [];

					for (var i=0; i<GIWIK._ds_sensors.length; i++)
					{
						GIWIK._sensors_status[i] = 1;
					}

					// Construction du tableau de comportement des bits de statuts
					GIWIK.statusBitsInfo.init();

					// Récupération automatique de la conf
					get_conf = true;


					// Spécifique APD
					if (GIWIK._plugins.transponders)
					{
						GIWIK.analyzeResponseText.TP_onFirstStart();
					}


					if (typeof HEADING.constructDetailedStatusMsg == 'function')
					{
						// Construction des messages de statut dans les modules du popup "detailed status" (+ transpondeurs éventuels)
						HEADING.constructDetailedStatusMsg();
					}
				}

				// Si l'IHM est dotée d'un voyant principal de statut
				if (window.Statuschevron)
				{
					window.Statuschevron.setStatus(1,true);
				}

				if (typeof GIWIK._sensors == 'object')
				{
					// Les messages de statuts détaillés doivent être visibles
					for (var i=0; i<GIWIK._sensors.length; i++)
					{
						$('#sensor'+i+'_infos_ctnr').css('display','block');
					}
				}

				if (HEADING.name == 'maintenance')
				{
					// Cas spécial d'un restart après mise à jour de l'IHM
					if (STORAGE.get('webpage_has_to_be_refreshed') === true)
					{
						STORAGE.setSession("webpage_has_to_be_refreshed", false);

						STORAGE.setSession('preload_img_main_isdone', false);
						//STORAGE.setSession('preload_img_mechanical_isdone', false);

						// La page est rechargée (sans tenir compte des caches du navigateur)
						window.location.reload(true);
					}
				}

				if (typeof GIWIK.setDetailedStatusActivity == 'function')
				{
					GIWIK.setDetailedStatusActivity(1);
				}
			}
			else if (window[system].is_started === false)
			{
				if (GIWIK.is_started_false_means_shutdown === true)
				{
					if (window.Statuschevron)
					{
						window.Statuschevron.setStatus(0);		// chevron gris
					}
					MSG.setGlobalStatus(400);					// message "system shutdown"

					// On force l'affichage du statut général
					$('#status').css('visibility','visible');
				}
				else
				{
					if (window.Statuschevron)
					{
						window.Statuschevron.setStatus(10);		// chevron clignotant
					}
					MSG.setGlobalStatus(401);					// message "system initializing"
				}

				GIWIK.data.setStatus(0);

				if (typeof GIWIK.setDetailedStatusActivity == 'function')
				{
					GIWIK.setDetailedStatusActivity(0);
				}
			}

			// Gestion de l'activation/désactivation des éléments de formulaire & des boutons de validation/annulation en fonction de l'état du système
			if (HEADING.init.isdone)
			{
				HEADING.setSettingsActivity();
			}
			// Si la phase d'init n'est pas terminée (=== la page est chargée sur un système en is_started === false)
			// On lance le timer sur getData (il est normalement lancé à la fin du cycle, en fin de méthode "display")
			else
			{
				// Appel AJAX périodique si la communication websocket n'est pas activée
				if (!GIWIK._plugins.websocket)
				{
					// Définition d'un timer appelant getData --------------------------
					GIWIK.setTimer("HEADING.getData();", GIWIK.update_timeout);
					//------------------------------------------------------------------
				}
			}
		}

		// Si le system est démarré
		if (window[system].is_started === true)
		{
			// Analyse des statuts détaillés si disponibles
			if (typeof window[system]._ui_status == 'object')
			{
				// Si les statuts détaillés ont changé (ou n'ont jamais été analysés)
				// OU le statut global ont changé
				// OU le tableau des bits de statut à changé (paramétrage de perte de synchro)
				// OU qu'on sort d'une phase de perte de connexion
				// OU IHM gérant des transpondeurs avec un changement d'état du tracking
				if (GIWIK._ui_status === undefined ||
					window[system]._ui_status.join(',') != GIWIK._ui_status.join(',') ||
					window[system].is_started !== GIWIK.system_is_started ||
					GIWIK.status_bits_info_modified ||
					connection_back ||
					(GIWIK._plugins.transponders && window[system].is_tracking !== GIWIK.system_is_tracking))
				{
					GIWIK.status_bits_info_modified = false;

					GIWIK._ui_status_unified = GIWIK.statusBitsInfo.unify(window[system]._ui_status); // Unification des statuts dans un tableau

					var	_system_actions     = {}, // {bit:action} actions à effectuer une fois le traitement effectué (standards + spécifiques)
						_system_actions_raw = {}, // {bit:action} actions à effectuer (résultat brut c'est à dire contenant les actions spéciales et des doublons)
						_system_actions_spe = {}, // {bit:action} actions spécifiques
						 system_action      = 1,  // action issue de la synthèse des actions non spécifiques (l'action 3 l'emporte sur la 2 etc.)
						_specific_actions   = {}, // actions spécifiques à traiter par GIWIK.analyzeAction d'app.js
						_new_sensors_status = [], // initialisation du tableau contenant le statut de chaque catpeur/module (somme des status des bits de chaque module)
						_sensors_separator  = []; // initialisation du tableau indiquant si le séparateur données/statuts doit être affiché (s'il existe)

					// alert(window[system]._ui_status+'\r\n'+GIWIK._ui_status_unified);

					// L'état de chaque module est fixé à 1 par défaut (fonctionnement nominal) et l'éventuel séparateur est masqué
					for (var i=0; i<GIWIK._sensors.length; i++)
					{
						_new_sensors_status[i] = 1;
						_sensors_separator[i]  = 'displaynone';
					}
					//alert(_new_sensors_status);

					// Définition du nombre d'entiers du tableau window[system]._ui_status à analyser (si IHM transpondeurs ET (system off OU tracking off), on ne prend en compte que les n int système, pas ceux des transp)
					var nb_int_analyzed = ((GIWIK._plugins.transponders && (window[system].is_started === false || window[system].is_tracking === false))
										  ? (GIWIK.ui_status_offset + GIWIK.ui_status_nb_int_for_system)
										  : window[system]._ui_status.length);

					for (var bit=0; bit<GIWIK.ui_status_bit_depth*nb_int_analyzed; bit++)
					{
						if (!GIWIK._status_bits_info[bit]) {continue;}

						var _bit = GIWIK._status_bits_info[bit];	// print_r (_bit);

							// Etat du bit : on (levé) / off (baissé)
							_bit.state  = (GIWIK._ui_status_unified[bit]) ? 'on' : 'off';

							// Action définie sur l'état du bit (d'après les action_on et action_off de GIWIK._status_bits_info)
							_bit.action = _bit['action_'+_bit.state];

						// Analyse du bit si un code message est défini ET/OU si une action est définie
						if (_bit.msg !== -1 || (_bit.action !== -1 && _bit.action !== 1))
						{
							// Si le module correspond à un transpondeur ET qu'il n'est pas in_use (mot de statut à 0 dans _ui_status), on passe au bit suivant
							if (_bit.module >= GIWIK._ds_sensors.length && window[system]._ui_status[GIWIK.ui_status_offset + GIWIK.ui_status_nb_int_for_system + (_bit.module - GIWIK._ds_sensors.length)] == 0)
							{
								continue;
							}

							// Statut défini pour l'état du bit (d'après les status_on et status_off de GIWIK._status_bits_info) [function ou int]
							_bit.status = (typeof _bit['status_'+_bit.state] == 'function') ? _bit['status_'+_bit.state](_bit) : _bit['status_'+_bit.state];

							// Si une action est définie pour l'état du bit, on la stocke
							if (_bit.action !== -1 && _bit.action !== 1)
							{
								// Cas particulier de l'action 4 : remontée de la couleur on ou off correspondant à l'état du bit
								// Le prefix "bit" pour la clé est utilisé pour autoriser le tri par asort (limitation JS avec les clés numériques)
								_system_actions_raw['bit'+bit] = (_bit.action === 4 && in_array(_bit.status,[0,2,3],true)) ? _bit.status : _bit.action;
							}

							// Application de la couleur adaptée au label du statut détaillé correspondant au bit en cours + gestion du message
							if (typeof HEADING.constructDetailedStatusMsg == 'function')
							{
								var bit_element = '#'+GIWIK.statusBitsInfo.msgDomId(bit);

								// console.log (bit+' '+_bit.status);
								if (_bit.status === -1)
								{
									$(bit_element).css('display','none');
								}
								else
								{
									if (typeof _bit.msg == 'function')
									{
										$(bit_element).html(_bit.msg());
									}

									$(bit_element).css({'display':'','color':GIWIK.css['color_'+_bit.status]});

									if (_bit.module !== -1)
									{
										_sensors_separator[_bit.module] = 'displayblock';
									}
								}
							}

							// Si l'état du bit est "plus grave" que l'état du module, ce dernier prend la valeur d'état de ce bit
							if (_bit.status > _new_sensors_status[_bit.module])
							{
								_new_sensors_status[_bit.module] = _bit.status;
							}

							_bit = null;
						}
					}
					nb_int_analyzed = null;

					// Tri des actions par ordre croissant (l'ID d'une action détermine donc l'ordre d'exécution)
					_system_actions = asort(_system_actions_raw);

					// Isolation des actions spécifiques (> 4)
					var action;
					for (var bit in _system_actions)
					{
						action = _system_actions[bit];

						if (action > 4)
						{
							_system_actions_spe[bit] = action;
						}
					}

					GIWIK.shutdown_action = in_array(0, _system_actions, true);								 	// Indique la présence d'une action "shutdown";
					GIWIK.error_action    = GIWIK.shutdown_action ? false : in_array(3, _system_actions, true);	// Indique la présence d'une action "error";
					GIWIK.warning_action  = GIWIK.error_action    ? false : in_array(2, _system_actions, true); // Indique la présence d'une action "warning"

					// Définition de l'action système résultant de l'analyse des actions standards (0,1,2,3,4) AVANT l'exécution des actions spécifiques
					// l'action 0 (shutdown) l'emporte sur la 3 (alert) qui l'emporte sur la 2 (warning) qui l'emporte sur la 1 (ok)
					system_action = (GIWIK.shutdown_action) ? 0 : ((GIWIK.error_action) ? 3 : ((GIWIK.warning_action) ? 2 : 1));

					// Définition finale des actions avec l'ajout en 1ère position de l'action déduite de la somme des actions standards
					// (le n° de bit correspondant n'a pas de sens dans ce cas précis)
					_system_actions = array_merge({"***status":system_action}, _system_actions_spe);

					if (GIWIK._plugins.transponders)
					{
						GIWIK.analyzeResponseText.TP_status(_new_sensors_status);
					}

					// Si plugin control chargé
					if (GIWIK._plugins.control)
					{
						// A migrer dans plugin.control
						if (HEADING.name == 'control' || HEADING.name == 'control_expertview')
						{
							if (HEADING.name == 'control')
							{
								// Application de la couleur du voyant de chaque module
								for (var i=0; i<GIWIK._sensors.length; i++)
								{
									if (typeof window['Led_Sensor'+i] != 'object')
									{
										window['Led_Sensor'+i] = new Led('Led_Sensor'+i, false);
										window['Led_Sensor'+i].construct('sensor'+i+'_led');
										window['Led_Sensor'+i].show();
									}

									window['Led_Sensor'+i].setStatus(_new_sensors_status[i]);

									// Gestion de l'affichage du séparateur données/statuts s'il existe
									if (document.getElementById('sensor'+i+'_separator') && GIWIK.css.getClass('sensor'+i+'_separator') != _sensors_separator[i])
									{
										GIWIK.css.setClass('sensor'+i+'_separator', _sensors_separator[i]);
									}
								}
							}
						}
					}
					_sensors_separator = null;

					// Exécution de l'action standard résultant de la synthèse des action <= 4
					switch (system_action)
					{
						// Shutdown
						case 0:
							if (typeof window.Statuschevron == 'object') {window.Statuschevron.setStatus(0, true);}
							if (GIWIK._plugins.control)	{MSG.setGlobalStatus(400);}
							break;
						// Ok
						case 1:
							if (typeof window.Statuschevron == 'object') {window.Statuschevron.setStatus(1, true);}

							// Affichage du message de statut standard
							// S'il s'agit d'une IHM gérant des transpondeurs et que le système est en tracking
							if (GIWIK._plugins.transponders && window[system].is_tracking === true)
							{
								if (GIWIK._plugins.control)	{MSG.setGlobalStatus(300);}
							}
							// Cas standard
							else
							{
								if (GIWIK._plugins.control) {MSG.setGlobalStatus(404);}
							}
							break;
						// Warning
						case 2:
							if (typeof window.Statuschevron == 'object') {window.Statuschevron.setStatus(2, true);}
							if (GIWIK._plugins.control) {MSG.setGlobalStatus(1501);}
							break;
						// Alert
						case 3:
							if (typeof window.Statuschevron == 'object') {window.Statuschevron.setStatus(3, true);}

							if (GIWIK._plugins.control)
							{
								if (HEADING.name == 'control')
								{
									for (var j in _new_sensors_status)
									{
										if (_new_sensors_status[j] == 3)
										{
											// Modules système
											if (j < GIWIK._ds_sensors.length)
											{
												// Si au moins une alerte concerne un module système (et pas un éventuel transpondeur)
												// ET (que ce module système n'était pas déjà en alerte OU qu'on se trouvait précédemment en déconnexion), on demande l'ouverture des statuts détaillés
												if (connection_back || _new_sensors_status[j] != GIWIK._sensors_status[j])
												{
													MSG.setGlobalStatus(2501);

													// Pour les IHM ne gérant PAS de transpondeurs ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
													if (!GIWIK._plugins.transponders)
													{
														// Ouverture des statuts détaillés
														HEADING.displayDetailedStatus('open');
													}
													//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
												}
												break;
											}
											// Modules transponders s'ils existent
											else
											{
												// Si l'alerte ne concerne pas un module système (donc un transpondeur) et que cette alerte est nouvelle OU que les statuts détaillés sont ouverts (et donc masquent les transpondeurs), on ferme les statuts détaillés
												if ((connection_back || _new_sensors_status[j] != GIWIK._sensors_status[j]) && GIWIK.css.getClass('popup_status') != 'displaynone')
												{
													MSG.setGlobalStatus(2601);

													// Fermeture des statuts détaillés
													//HEADING.displayDetailedStatus('close');
													break;
												}
											}
										}
									}
									// NOTE : les modules système ont la priorité sur les transpondeurs -> en cas d'erreur système + erreur transpondeur, ce sont les statuts détaillés du système qui s'affichent
								}
							}
							break;
					}

					if (GIWIK._plugins.control)
					{
						if (system_action === 0)
						{
							GIWIK.data.setStatus(0);

							if (typeof GIWIK.setDetailedStatusActivity == 'function')
							{
								GIWIK.setDetailedStatusActivity(0);
							}
						}
						else
						{
							GIWIK.data.setStatus(1);

							if (typeof GIWIK.setDetailedStatusActivity == 'function')
							{
								GIWIK.setDetailedStatusActivity(1);
							}
						}
					}

					GIWIK._sensors_status = array_copy(_new_sensors_status);	 // print_r(GIWIK._sensors_status,'GIWIK._sensors_status');

					// Traitement des actions spécifiques
					if (typeof GIWIK.analyzeActions == 'function')
					{
						GIWIK.analyzeActions(_system_actions);
					}

					// Gestion du statut et de la visibilité des groupes de statuts --------------------------------------------------------------------------------------------------
					if (GIWIK.statusBitsInfo.groups)
					{
						var group, _group, group_position, _group, i, _bit, group_status, group_empty;

						// Une fois que les action sont effectuées on met à jour les statuts des groupes de paramètres (au cas ou une action aurait modifié le statut d'un message)
						for (group in GIWIK.statusBitsInfo.groups.names)
						{
							_group = GIWIK.statusBitsInfo.groups.names[group];

							// Par défaut un groupe de statut a le statut (0) gris. Il se cale sur le statut le plus grave.
							group_status = 0;
							group_empty = true;

							for (i in _group.bits)
							{
								_bit = _group.bits[i];

								if (_bit.status !== -1 && _bit.status > group_status)
								{
									group_status = _bit.status;
								}

								if (_bit.msg !== -1 && _bit.status !== -1)
								{
									group_empty = false;
								}
							}

							// Statut
							$('#'+_group.dom_id+' div.ds_group_led > div').css('background',GIWIK.css['color_'+group_status]);

							// Visibilité
							if (_group.visible && (_group.visible_when_empty  ||  !group_empty))
							{
								$('#'+_group.dom_id).addClass('visible');
								$('#'+_group.dom_id).removeClass('hidden');
							}
							else
							{
								$('#'+_group.dom_id).addClass('hidden');
								$('#'+_group.dom_id).removeClass('visible');
							}
						}
					}
					//-----------------------------------------------------------------------------------------------------------------------------------------------------------

					_new_sensors_status = null;

					GIWIK._ui_status = array_copy(window[system]._ui_status);
				}
			}

			// Affichage des mesures (le 1er appel à readData est lancé par le 1èr passage dans la méthode readConf)
			if (HEADING.init.isdone)
			{
				HEADING.readData();
			}
		}

		// Sauvegarde du dernier état "is_started"
		GIWIK.system_is_started = window[system].is_started;

		return get_conf;
	};

	// version générique du traitement de l'erreur générée suite à la requette HTTP (GET) pour les IHM techno CGI
	GIWIK.analyzeHTTPError = function (url, _options, status)
	{
		// Si l'url est appelée de façon récurrente par le timer global, on ne la relance pas
		// SAUF si on se trouve dans le cas d'un chargement de page depuis les caches navigateur (!!!) avec le serveur qui ne répond plus
		// DANS CE CAS on réexécute getData en lui passant un paramètre lui permettant de se mettre directement en connexion lost
		if (in_array(url, HEADING._url_ajax) || !HEADING.init.isdone)
		{
			if (!HEADING.init.isdone)
			{
				setTimeout("HEADING.getData('connection_lost');",1000);
			}
			return;
		}

		var _url_params = GIWIK.getParamsFromString(url);

		// Stockage en mémoire de l'objet "_options" pour le réutiliser dans le setTimeout()
		GIWIK._http_errors[url] = (_options) ? _options : {};

		// Si la requete qui n'a pas abouti concernait une requête autres que la requête périodique getData (qui sera donc automatiquement relancée), c'est à dire :
		// une lecture (3), une écriture de conf (4), une commande (5), ou un contrôle de prise en compte d'écriture (6)
		// --> on la relance
		// if ((_url_params.mode >= 3 && _url_params.DataGroup === undefined) || !HEADING.init.isdone)
		if (_url_params.mode >= 3)
		{
			// Déclaration du timeout avec à la clé l'effacement de l'entrée concernée dans GIWIK._http_errors
			setTimeout("GIWIK.ajax('"+url+"', GIWIK._http_errors['"+url+"']);delete GIWIK._http_errors['"+url+"'];", 1000);
		}

		_url_params = null;
	};

	// Récupération des paramètres d'une chaine (ou URL) sous forme d'un tableau associatif
	GIWIK.getParamsFromString = function (str)
	{
		// Suppression des éventuelles ancres ("#")
		str = str.replace(/#[^\?&]*/gi,"");

		var _str_params = {};

		var _str_split = str.split('?');

		if (_str_split !== null && _str_split.length > 0)
		{
			// Si la chaine ne comportait pas de "?"
			if (_str_split.length == 1)
			{
				var str_params = _str_split[0];
			}
			// Si la chaine comportait un "?"
			else
			{
				var str_params = _str_split[1];
			}
			//alert(str_params);

			//str_params

			//alert(str_params);

			// Suppression des éventuels "&" de début et fin de chaine
			var match_exp1 = /^&+(.+)$/i.exec(str_params);
			if (match_exp1 !== null && match_exp1.length > 1)
			{
				str_params = match_exp1[1];
			}

			var match_exp2 = /^&+(.+)$/i.exec(str_params);
			if (match_exp2 !== null && match_exp2.length > 1)
			{
				str_params = match_exp2[1];
			}

			// Split des différents couples clé/valeur
			var _temp = str_params.split('&');

			if (_temp !== null && _temp.length > 0)
			{
				var param_key;
				var param_value;
				var _temp2 = new Array();

				for (var i=0; i<_temp.length; i++)
				{
					_temp2 = _temp[i].split('=');

					param_key   = _temp2[0];
					param_value = _temp2[1] ? _temp2[1] : '';

					_str_params[param_key] = param_value;
				}
			}
		}
		return _str_params;
	};

	// Mise en place d'un timer ["timer_name" (string) est optionnel. Par défaut, le timer est contenu dans la variable "window.timer_global"]
	GIWIK.setTimer = function (action, period, timer_name)
	{
		// Par défaut, la variable globale contenant le timer s'appelle window.timer_global
		var variable_name = (typeof timer_name == 'undefined') ? "window.timer_global" : timer_name;

		// Par défaut la période est celle définie dans app.js
		if (typeof period != "number")
		{
			var period = GIWIK.update_timeout;
		}

		// Si un timer global est déjà défini, on le supprime
		if (eval("typeof "+variable_name+" != 'undefined'"))
		{
			eval("clearInterval("+variable_name+");");
			eval(variable_name+" = null;"); // VS BUG FF qui a tendance à combiner un ancien timer avec un nouveau
		}

		// 1ère exécution immédiate de l'action pour ne pas avoir à attendre la valeur du setInterval()
		eval(action);

		// Mise en place du timer
		eval(variable_name+" = setInterval(\""+action+"\", "+period+");");
	};

	// Définition de l'action "restart" en fonction du contexte (après une mise à jour IHM etc.)
	// [optional_action contient la chaine qui doit être évaluée seulement si le confirm est positif, skip_confirm = true désactive le message de confirmation]
	GIWIK.getRestartAction = function (optional_action, skip_confirm)
	{
		return function ()
		{
			if (window[system].is_started && (skip_confirm || (!skip_confirm && confirm(MSG(['confirm','restart'])))))
			{
				window.Statuschevron.setStatus(10);
				HEADING.setSettingsActivity('disable');

				if (STORAGE.get('refresh_on_next_restart'))
				{
					STORAGE.setSession('refresh_on_next_restart', false);
					STORAGE.setSession('webpage_has_to_be_refreshed', true);
				}

				// Si une commande optionnelle est définie
				if (typeof optional_action == 'function')
				{
					optional_action();
				}

				// Si une commande spécifique est définie
				if (typeof GIWIK._plugins.maintenance.restart_system.action == 'function')
				{
					GIWIK._plugins.maintenance.restart_system.action();
				}
				// Commande par défaut
				else
				{
					GIWIK.ajax(GIWIK.cgifile+'?mode=5&cmd=1');
				}
			}
		};
	};

	// Redirection sur la page de chargement avec gestion de l'url d'origine
	GIWIK.goToPreloadPage = function ()
	{
		window.location.replace('./?preload=&params='+document.location.search+document.location.hash);
	};


// REGEXP : Liste des expressions régulières utilisées par GIWIK (GIWIK.regexp) —————————————————————————————————————————————————————————————————————————————————————————
	GIWIK.regexp =
	{
		get_page_parent : /^([a-z\d-])+_/i 		// récupère le dossier parent de la page en cours
	};


// STYLES (GIWIK.css) ———————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————

	// Mise en mémoire d'une variable de style utilisée pour la génération dynamique des CSS via JS
	GIWIK.css.init = function (style_name, style_value)
	{
		if (GIWIK.css[style_name] === undefined)
		{
			GIWIK.css[style_name] = style_value;
		}
	};

	// Ecrire une feuille de style directement dans le document (avant l'évènement "load")
	GIWIK.css.write = function (styles)
	{
		if (!styles) {return;}

		var css = '<style type="text/css">'+styles+'</style>';

		// Si la phase d'init est terminée on appelle les fichiers via ajax
		if (HEADING.init.isdone)
		{
			$('head').append(css);
		}
		// Sinon on écrit directement le tag <style> dans le document
		else
		{
			document.write(css);
		}
	};

	// Assigner une classe à un element (remplace toutes les autres classes déjà présentes)
	GIWIK.css.setClass = function (id_element, newclass)
	{
		if(!document.getElementById(id_element))
		{
			console.error("GIWIK.css.getClass() : DOM element \""+id_element+"\" is missing");
			return false;
		}
		else
		{
			if (document.getElementById(id_element).className != newclass)
			{
				document.getElementById(id_element).className = newclass;
			}
		}
	};

	// Récupérer le nom de la classe affectée à un élément
	GIWIK.css.getClass = function (id_element)
	{
		if(!document.getElementById(id_element))
		{
			console.error("GIWIK.css.getClass() : DOM element \""+id_element+"\" is missing");
			return false;
		}
		else
		{
			return document.getElementById(id_element).className;
		}
	};

	// Assigner un style à un element
	GIWIK.css.setStyle = function (id_element, name, value)
	{
		if(!document.getElementById(id_element))
		{
			console.error("GIWIK.css.getStyle() : DOM element \""+id_element+"\" is missing");
			return false;
		}
		else
		{
			$('#'+id_element).css(name, value);
		}
	};

	// Récupérer un style affecté à un élément
	GIWIK.css.getStyle = function (id_element)
	{
		if(!document.getElementById(id_element))
		{
			console.error("GIWIK.css.getClass() : DOM element \""+id_element+"\" is missing");
			return false;
		}
		else
		{
			return $('#'+id_element).css(name);
		}
	};

	// Définir une couleur
	GIWIK.css.RGBA = function (red, green, blue, alpha)
	{
		// IE8 ne gère pas les couleurs rgba
		if (GIWIK._context.ie < 9)
		{
			return "rgb("+red+","+green+","+blue+")";
		}

		return "rgba("+red+","+green+","+blue+","+alpha+")";
	};

	// Convertir une couleur rvb en hexa.
	// La couleur RVB est passée soit sous forme de 3 arguments R,V,B soit sous forme de chaine CSS rgb(X,X,X) ou rgba(X,X,X,X)
	// Attention : la couleur retournée ne contient pas l'alpha même si présent en entrée (CSS incompatible avec l'alpha en notation hexa)
	GIWIK.css.RGBtoHex = function (red, green, blue)
	{
		// Si la couleur est passée sous la forme rgba(X,X,X,X)
		if (typeof red == 'string')
		{
			_rgb = red.replace(/(rgba?\(|\)$)/gi,"").split(",");

			var red   = parseInt(_rgb[0]),
				green = parseInt(_rgb[1]),
				blue  = parseInt(_rgb[2]);
		}
	    var bgr = (red + (256 * green) + (65536 * blue)).toString(16);

	    return '#'+bgr.substr(4,2)+bgr.substr(2,2)+bgr.substr(0,2);
	};


// EFFETS ———————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————

	GIWIK.fx =
	{
		// Fonctions de rotation d'un élément
		rotation :
		{
			toTarget : function (actual_angle, target_angle)
			{
				var delta = target_angle-actual_angle, n;

				// Si les 2 angles sont situés dans le même demi cercle (ou sont identiques)
				if (Math.abs(delta) <= 180)	{/*console.log('magic cond1');*/ n = 0;}

				// Si le chemin le plus court vers l'angle cible est une rotation horaire
				else if (delta < 0)	        {/*console.log('magic cond2');*/ n = 360;}

				// Si le chemin le plus court vers l'angle cible est une rotation anti-horaire
				else                        {/*console.log('magic cond3');*/ n = -360;}

				return (delta + n);
			},
			// Fonction pour connaitre la rotation (en deg) d'un élement
			getCurrent : function (jq_obj)
			{
				var angle = 0,
					matrix = jq_obj.css("-webkit-transform") ||
							 jq_obj.css("-moz-transform")	 ||
							 jq_obj.css("-ms-transform")	 ||
							 jq_obj.css("-o-transform")		 ||
							 jq_obj.css("transform");

				if (matrix !== 'none')
				{
					var values = matrix.split('(')[1].split(')')[0].split(','),
						a = values[0],
						b = values[1];

					angle = Math.round(Math.atan2(b, a) * (180/Math.PI));
				}

				return angle;
			}
		}
	};


// CONTENU ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————

	// Ecrire du code HTML dans un élément DOM
	// Fonction intégralement basée sur jQuery, elle permet de signaler l'absence d'un élément DOM dans la console
	// "method" (optionnel) peut prendre les valeurs suivantes :
	//   - "html"    : écrire dans l'élément "id_element" en écrasant tout le contenu (défaut)
	//   - "prepend" : écrire dans l'élément "id_element" AVANT tout contenu
	//   - "append"  : écrire dans l'élément "id_element" APRÈS tout contenu
	//   - "before"  : écrire juste avant l'élément "id_element"
	//   - "after"   : écrire juste après l'élément "id_element"
	GIWIK.write = function (id_element, content, method)
	{
		if(!document.getElementById(id_element))
		{
			console.error("GIWIK.write() : No HTML element named " + id_element);
			return false;
		}
		if (!in_array(method,['html','prepend','append','before','after']))
		{
			method = 'html';
		}
		$('#'+id_element)[method](content);
	};

	// Retourne un ID DOM valide à partir d'une chaine ou d'un nombre
	GIWIK.domId = function (element)
	{
		if (typeof element === 'undefined') {console.log('Error: GIWIK.domId received undefined value'); return;}

		if (typeof element === 'string')
		{
			var element = String(element);
		}
		// Tout caractère autre que ceux autorisés est remplacé par un "_"
		return element.replace(/[^a-z0-9_-]/gi,'_');
	};

	// Affecte une action à l'évènement onclick d'un élément
	GIWIK.setClick = function (id_element, action)
	{
		if (document.getElementById(id_element))
		{
			switch (typeof action)
			{
				case 'string'   : document.getElementById(id_element).onclick = function () {eval(action)}; break;
				case 'function' : document.getElementById(id_element).onclick = action; break;
				default         : return false;
			}
			document.getElementById(id_element).style.cursor = "pointer";
		}
	};

	// Affecte des actions aux évènements d'un objet liés à la souris (onmouseover, onmouseout, onmousedown et onmouseup)
	GIWIK.setMouseEvent = function (id_element, action_mouseover, action_mouseout, action_mousedown, action_mouseup)
	{
		if (document.getElementById(id_element))
		{
			switch (typeof action_mouseover)
			{
				case 'string'   : document.getElementById(id_element).onmouseover = function () {eval(action_mouseover)}; break;
				case 'function' : document.getElementById(id_element).onmouseover = action_mouseover; break;
			}
			switch (typeof action_mouseout)
			{
				case 'string'   : document.getElementById(id_element).onmouseout = function () {eval(action_mouseout)}; break;
				case 'function' : document.getElementById(id_element).onmouseout = action_mouseout; break;
			}
			switch (typeof action_mousedown)
			{
				case 'string'   : document.getElementById(id_element).onmousedown = function () {eval(action_mousedown)}; break;
				case 'function' : document.getElementById(id_element).onmousedown = action_mousedown; break;
			}
			switch (typeof action_mouseup)
			{
				case 'string'   : document.getElementById(id_element).onmouseup = function () {eval(action_mouseup)}; break;
				case 'function' : document.getElementById(id_element).onmouseup = action_mouseup; break;
			}
		}
	};

	// Recupérer la position absolue d'un element dans la page HTML
	GIWIK.getPosition = function (id_element)
	{
		var element = document.getElementById(id_element);
		var offset_top = offset_left = 0;

		if (element.offsetParent)
		{
			offset_top = element.offsetTop;
			offset_left = element.offsetLeft;

			while (element = element.offsetParent)
			{
				offset_top += element.offsetTop;
				offset_left += element.offsetLeft;
			}
		}

		var _offset = new Array();
		_offset['top'] = offset_top;
		_offset['left'] = offset_left;

		return _offset;
	};

	// Compte le nombre de modules de statuts détaillés à partir du tableau GIWIK._ds_sensors
	GIWIK.countDsSensors = function (_array)
	{
		var n = 0;
		for (var key_s in _array)
		{
			// S'il s'agit d'un tableau
			if (typeof _array[key_s] == 'object')
			{
				for (var key_s2 in _array[key_s]){n++;}
			}
			else
			{
				n++;
			}
		}
		return n;
	};

	// Retourne le nom de la fenêtre du datalogger en fonction du nom du produit et du port (utile pour chaque page pour les IHM avec balises)
	GIWIK.makeDataloggerWindowName = function (port)
	{
		// Port Repeater par défaut
		if (!port){var port = 'Repeater';}

		return GIWIK.system_name+"_datalogger_output"+port;
	};

	// Gestion des boutons de validation/annulation
	GIWIK.validationButtons =
	{
		// Affiche les boutons de validation/annulation si un paramètre est modifié
		display : function (cancel_always_on, validate_always_on)
		{
			if (window.settings_modified === false && window.settings_modified_unload === false)
			{
				GIWIK.validationButtons.cancel_state   = (cancel_always_on)   ? 'enable' : 'disable';
				GIWIK.validationButtons.validate_state = (validate_always_on) ? 'enable' : 'disable';
			}
			else
			{
				GIWIK.validationButtons.cancel_state   = 'enable';
				GIWIK.validationButtons.validate_state = 'enable';
			}

			if (typeof GIWIK.validationButtons.display.specific == 'function')
			{
				var _specific = GIWIK.validationButtons.display.specific();

				if (typeof _specific == 'object')
				{
					if (_specific.cancel_state)
					{
						GIWIK.validationButtons.cancel_state = _specific.cancel_state;
					}
					if (_specific.validate_state)
					{
						GIWIK.validationButtons.validate_state = _specific.validate_state;
					}
				}
			}

			window.Cancel_settings[GIWIK.validationButtons.cancel_state]();
			window.Validate_settings[GIWIK.validationButtons.validate_state]();
		},

		// GIWIK Construction des boutons cancel/send (appelée depuis HEADING.construct)
		construct : function (_options)
		{
			if (!_options || _options.constructor != Object)
			{
				_options = {};
				//_options.cancel|send.action    [string] -> spécifier des actions spécifiques en plus des getConf() et sendConf() standards
				//_options.cancel|send.label     [string] -> label du bouton
				//_options.cancel|send.always_on [bool]   -> le bouton doit toujours être activé
				//_options.no_margin_top         [bool]   -> pas de marge haute
			}

			if (!_options.cancel || _options.cancel.constructor != Object)
			{
				_options.cancel = {};
			}

			if (!_options.send || _options.send.constructor != Object)
			{
				_options.send = {};
			}

			var css_class = (_options.no_margin_top) ? 'separator1_nomargintop' : 'separator1';

			var cs = ''
			+'<div id="cancelsend_master_ctnr">' // Pour pouvoir masquer les boutons sans se soucier de l'action de setSettingsActivity() (qui agit sur cancelsend_ctnr)
				+'<div id="cancelsend_ctnr" style="display:none">'
					+'<hr class="'+css_class+'" />'
					+'<div id="btn_cancel" style="display:none"></div>'
					+'<div id="btn_validate" style="display:none"></div>'
				+'</div>'
			+'</div>';

			GIWIK.write('cancelsend', cs);

			var cancel_label = (typeof _options.cancel.label == 'string' && _options.cancel.label !== '') ? _options.cancel.label : MSG(['buttons','cancel_settings']);
			var send_label =   (typeof _options.send.label   == 'string' && _options.send.label   !== '') ? _options.send.label   : MSG(['buttons','validate_settings']);

			window.Cancel_settings = new Button('Cancel_settings', true);
			window.Cancel_settings.construct('btn_cancel',cancel_label,'default',2);
			window.Cancel_settings.setAction(function ()
			{
				// Passage à false pour griser les boutons de validation/annulation
				window.settings_modified = false;
				window.settings_modified_unload = false;

				if (_options.cancel.action)
				{
					if (typeof _options.cancel.action == "string")
					{
						eval(_options.cancel.action);
					}
					else if (typeof _options.cancel.action == "function")
					{
						if (_options.cancel.action() === false)
						{
							return false;
						}
					}
				}
				HEADING.getConf();
			});
			window.Cancel_settings.disable();
			window.Cancel_settings.show();

			window.Validate_settings = new Button('Validate_settings', true);
			window.Validate_settings.construct('btn_validate',send_label);
			window.Validate_settings.setAction(function ()
			{
				// Passage à false pour griser les boutons de validation/annulation
				window.settings_modified = false;
				window.settings_modified_unload = false;

				if (_options.send.action)
				{
					if (typeof _options.send.action == "string")
					{
						eval(_options.send.action);
					}
					else if (typeof _options.send.action == "function")
					{
						if (_options.send.action() === false)
						{
							return false;
						}
					}
				}
				HEADING.sendConf();
			});
			window.Validate_settings.disable();
			window.Validate_settings.show();

			GIWIK.setTimer("GIWIK.validationButtons.display("+_options.cancel.always_on+","+_options.send.always_on+");", 100, "window.settings_timer");
		}
	};

	// Construction des boites de paramètres
	GIWIK.box = function (content, box_title, cancel_send, _table_info, _td_info)
	{
		if (typeof cancel_send == 'undefined')
		{
			cancel_send = true;
		}

		var table_id    = (typeof _table_info == 'object' && _table_info[0] && _table_info[0] != '') ? _table_info[0] : 'box_config';
		var table_class = (typeof _table_info == 'object' && _table_info[1] && _table_info[1] != '') ? _table_info[1] : 'box';

		var td_id    = (typeof _td_info == 'object' && _td_info[0] && _td_info[0] != '') ? _td_info[0] : table_id+'_content';
		var td_class = (typeof _td_info == 'object' && _td_info[1] && _td_info[1] != '') ? _td_info[1] : 'box_content';

		var box = ''

		+'<table id="'+table_id+'" class="'+table_class+'">\n'
			+'<tr>\n'
				+'<td colspan="2" class="box_border_t"><span id="'+table_id+'_title" class="box_titlei">'+box_title+'</span></td>\n'
				+'<td class="box_corner_tr"></td>\n'
			+'</tr>\n'
			+'<tr>\n'
				+'<td class="box_border_l"></td>\n'
				+'<td id="'+td_id+'" class="'+td_class+'">'+content+'</td>\n'
				+'<td class="box_border_r"></td>\n'
			+'</tr>\n';

			// Si les boutons cancel/send doivent être affichés
			if (cancel_send)
			{
				box += '<tr>\n'
					+'<td class="box_border_l"></td>\n'
					+'<td id="cancelsend"></td>\n'
					+'<td class="box_border_r"></td>\n'
				+'</tr>\n';
			}

			box += '<tr>\n'
				+'<td class="box_corner_bl"></td>\n'
				+'<td class="box_border_b"></td>\n'
				+'<td class="box_corner_br"></td>\n'
			+'</tr>\n'
		+'</table>\n';

		return box;
	};

	// Gestion des groupes de paramètres
	GIWIK.paramGroup =
	{
		// Construction
		construct : function (id_element, label, action, callback)
		{
			// 1. Ajout des deux <div> qui vont contenir le titre et le contenu lui même
			$('#'+id_element).prepend(
				'<div id="'+id_element+'_title"></div>'
				+'<div id="'+id_element+'_ctnr"></div>'
			);

			// 2. Déplacement de tous les éléments hors 2 <div> fraîchement ajoutés dans le div "_ctnr"
			//    --> On parcourt les frères du <div> qui doit recevoir le contenu
		    $('#'+id_element+'_ctnr').siblings().each(function(i)
		   	{
		   		// S'il ne s'agit pas du <div> "_title"
		   		if (i > 0)
		   		{
		   			// On déplace l'élément dans le <div> "_ctnr"
		   			$(this).appendTo('#'+id_element+'_ctnr');
		   		}
		   	});

			// Construction du nouveau contenu avec l'ajout du titre et d'un div conteneur pour afficher/masquer le groupe de paramèters
			var cnt_header = ''
				+'<table class="line_param">'
					+'<tr>'
						+'<td>'
							+'<div id="'+id_element+'_picto" class="line_param_picto">▼</div>'
							+'<div id="'+id_element+'_label" class="line_param_label"></div>'
							// Insertion du picto target blank quand il s'agit d'un lien
							+((action && !in_array(action, ['show', 'hide', 'displaynone']) && action.match(/^link:/)) ? '&nbsp;<img src="'+GIWIK.directories.img+'/target_blank'+GIWIK.css.night_suffix+'.gif" />' : '')
						+'</td>'
						+'<td class="line_param_separator">'
							+'<div></div>'
						+'</td>'
					+'</tr>'
				+'</table>';

		    $('#'+id_element+'_title').html(cnt_header);

			// Ecriture du label du titre
			GIWIK.paramGroup.setLabel(id_element, label);

			$('#'+id_element).css({'display':'block'});
			//--------------------------------------------------------------

			// Application des css en fonction de l'état enroulé/déroulé du groupe de paramètres
			GIWIK.paramGroup.display(id_element, action, callback);
		},

		// Gère l'affichage des lignes d'intitulés de paramètres (en paramètres, l'id du groupe de paramètres, le label et l'état (show: params dépliés, hide: params repliés, displaynone: rien ne s'affiche) mouseover sert à contourner l'absence de onmouseover après un onclick
		display : function (id_element, action, callback)
		{
			var title_id   = id_element+'_title';
			var title_path = document.getElementById(title_id);
			var ctnr_id    = id_element+'_ctnr';
			var picto_id   = id_element+'_picto';

			if (typeof callback != 'function')
			{
				var callback = function () {};
			}

			if (action && !in_array(action, ['show', 'hide', 'displaynone']) && action.match(/^link:/))
			{
				var link   = action.replace(/^link:/gi, "");
				var action = 'link';
			}

			switch (action)
			{
				// Le groupe de paramètres est replié par défaut
				case 'hide':
					if (!HEADING.init.isdone)
					{
						$('#'+id_element).css('display','block');
						$('#'+title_id).css('display','block');
						$("#"+ctnr_id).css('display','none');

						// IE <= 8 bogue avec l'animation du picto
						if (GIWIK._context.ie <= 8)
						{
							$("#"+picto_id).css({'transform': 'rotate(-90deg)'});
						}
						else
						{
							$('#'+picto_id).velocity({'rotateZ': '-90deg'},0);
						}

						callback();
					}
					else
					{
						setTimeout("$('#"+id_element+"').slideDown(200, function() {"
							+"$('#"+id_element+"').height('');"	// VS bug occasionnel de repliement à cause d'une hauteur fixée automatiquement par jQuery (testé sous 1.11.1)
							+"$('#"+title_id+"').slideDown(100, function() {"
								+"$('#"+ctnr_id+"').slideUp(200, "+callback+");"
							+"});"
						+"});",1);


						// IE <= 8 bogue avec l'animation du picto
						if (GIWIK._context.ie <= 8)
						{
							$("#"+picto_id).css({'transform': 'rotate(-90deg)'});
						}
						else
						{
							$('#'+picto_id).velocity({'rotateZ': '-90deg'});
						}
					}

					if (title_path !== null)
					{
						title_path.onclick = function ()
						{
							GIWIK.paramGroup.display(id_element, 'show', 'over');
						};
					}
					break;

				// Le groupe est invisible
				case 'displaynone':
					if (!HEADING.init.isdone)
					{
						$('#'+id_element).css('display','none');

						callback();
					}
					else
					{
						if ($('#'+id_element+':animated').length) {$('#'+id_element).stop();}

						$('#'+id_element).slideUp(200, function () {
							$('#'+id_element).css('display','none');	// Nécessaire quand slideUp est appelée alors que l'élément n'est pas visible (limitation jQuery)
							callback();
						});
					}
					break;

				// Le groupe de paramètres est vide et le label est un lien href
				case 'link':
					if (!HEADING.init.isdone)
					{
						$('#'+id_element).css('display','block');
						$('#'+title_id).css('display','block');
						$("#"+ctnr_id).css('display','none');

						callback();
					}
					else
					{
						setTimeout("$('#"+id_element+"').slideDown(200, function() {"
							+"$('#"+id_element+"').height('');"	// VS bug occasionnel de repliement à cause d'une hauteur fixée automatiquement par jQuery (testé sous 1.11.1)
							+"$('#"+title_id+"').slideDown(100, function() {"
								+"$('#"+ctnr_id+"').slideUp(200, "+callback+");"
							+"});"
						+"});",1);
					}

					// IE <= 8 bogue avec l'animation du picto
					if (GIWIK._context.ie <= 8)
					{
						$("#"+picto_id).css({'transform': 'rotate(-90deg)'});
					}
					else
					{
						$('#'+picto_id).velocity({'rotateZ': '-90deg'},0);
					}

					if (title_path !== null)
					{
						title_path.onclick = function ()
						{
							eval(link);
						};
					}
					break;

				case 'show':// Par défaut, "show" : le groupe de paramètres est déplié par défaut

				default:
					if (!HEADING.init.isdone)
					{
						$('#'+id_element).css('display','block');
						$('#'+title_id).css('display','block');
						$("#"+ctnr_id).css('display','block');

						// IE <= 8 bogue avec l'animation du picto
						if (GIWIK._context.ie <= 8)
						{
							$("#"+picto_id).css({'transform': 'rotate(0deg)'});
						}
						else
						{
							$('#'+picto_id).velocity({'rotateZ': '0deg'},0);
						}

						callback();
					}
					else
					{
						setTimeout("$('#"+id_element+"').slideDown(200, function() {"
							+"$('#"+id_element+"').height('');"	// VS bug occasionnel de repliement à cause d'une hauteur fixée automatiquement par jQuery (testé sous 1.11.1)
							+"$('#"+title_id+"').slideDown(100, function() {"
								+"$('#"+ctnr_id+"').slideDown(200, "+callback+");"
							+"});"
						+"});",1);

						// IE <= 8 boguent avec l'animation du picto
						if (GIWIK._context.ie <= 8)
						{
							$("#"+picto_id).css({'transform': 'rotate(0deg)'});
						}
						else
						{
							$('#'+picto_id).velocity({'rotateZ': '0deg'});
						}
					}

					if (title_path !== null)
					{
						title_path.onclick = function (){GIWIK.paramGroup.display(id_element, 'hide', 'over');};
					}
					break;
			}
		},

		setLabel : function (id_element, label)
		{
			GIWIK.write(id_element+'_label', label.spaces_to_nbsp());
		},

		getLabel : function (id_element)
		{
			return $('#'+id_element+'_label').html();
		}
	};

	// Vérifie si un élément est visible à l'écran en tenant compte du scrolling
	GIWIK.checkElementVisibility = function (id_element)
	{
		// Si visibility:hidden ou display:none de l'élément ou d'un de ses parents ou si hors champ
	    return (!$('#'+id_element).is(':visible') || ($('#'+id_element).offset().top - $(window).scrollTop()) < 0) ? false : true;
	};

	// Gestion de l'affichage des menus déroulants du menu de navigation principal
	GIWIK.displaySubmenu = function (id, action)
	{
		if (typeof id != 'undefined' && typeof action != 'undefined')
		{
			// Teste si le tableaux des sous rubriques est bien chargé par JavaScript
			if (typeof GIWIK._subheadings == 'object')
			{
				if (count(GIWIK._subheadings[id]) > 0)
				{
					var subheading = document.getElementById('subheading'+id);

					// POSITIONNEMENT DU MENU ...........................................................................................................
					// Detection de la position du menu parent par rapport au haut gauche de la fenetre
					var offset_top = offset_left = 0;

					// Recuperation de la position verticale du conteneur du menu principal		(la position verticale du menu parent pose probleme avec la variation de taille des polices)
					var _offset = new Array();
					_offset = GIWIK.getPosition ('mainmenu_ctnr');
					offset_top = _offset['top'];

					// Recuperation de la position horizontale du menu parent
					var _offset = new Array();
					_offset = GIWIK.getPosition ('heading'+id);
					offset_left = _offset['left'];

					// Application des coordonnees
					subheading.style.top = parseInt(offset_top) + 24 + 'px';
					subheading.style.left = parseInt(offset_left) - 3 + 'px';

					// VISIBILITE .......................................................................................................................
					switch (action)
					{
						case 'show':
							GIWIK.css.setClass('subheading'+id, 'subheading_'+GIWIK.window_size);

							// Si un timer de fermeture a été déclaré (lors d'un onmouseout), il est supprimé
							if (typeof window._timer_submenu == 'object')
							{
								clearTimeout(window._timer_submenu[id]);
							}
							break;

						case 'hide':
							if (typeof window._timer_submenu != 'object'){window._timer_submenu = new Array();}

							window._timer_submenu[id] = setTimeout("GIWIK.css.setClass('subheading"+id+"', 'displaynone');", 30);
							break;
					}

					//document.title += "+";
				}
			}
		}
	};

	// Pour construction des modules (voyant + nom + infos) de controle (dans le popup des statuts détaillés ou pour les transpondeurs de GAPS/RAMSES) [id_first_box] sert à définir l'id de la première boite (utile pour les transpondeurs de GAPS/RAMSES)
	GIWIK.displayControlBoxes = function (box_number, box_width, box_height, firstbox_id, _displaynone)
	{
		/*
			STRUCTURE D'UN CAPTEUR
			- IE 7/8 ne gerent pas "display:table-row" et "table-cell"
				--> utilisation d'un tableau a la place d'une combinaison de div pour garrantir une parfaite elasticite en cas d'un contenu trop long

			ALIGNEMENT ET CENTRAGE DES CAPTEURS
			- Seuls Opera, Safari et les Gecko >=1.9 gèrent la propriété css "display:inline-block"
				--> FF1/2 et IE obligent a contourner cette carrence par "display:inline"
				Or dans ce mode d'affichage, les marges ne sont pas prises en compte
				--> L'astuce consiste a inclure les marges directement dans le tableau
				--> De plus, FF1/2 buggent à l'utilisation de vertical-align: top, donc on laisse les capteurs alignés par le bas
		*/

		// Par défaut, l'id de la première boite est 0
		if (typeof firstbox_id != 'number'){var firstbox_id = 0;}

		// Par défaut, aucune boite ne doit être masquée
		if (typeof _displaynone != 'object'){var _displaynone = new Array();}

		//alert(firstbox_id+' '+(firstbox_id+box_number));

		for (var i=firstbox_id; i<firstbox_id+box_number; i++)
		{
			// Si le module est bien présent dans la page
			if (document.getElementById('sensor'+i))
			{
				// Si la boite doit être masquée
				if (in_array(i, _displaynone))
				{
					$('#sensor'+i).css('display','none');
					continue;
				}

				$('#sensor'+i).css({
					'display': 'inline-table',
					'verticalAlign': 'top',
					'width': (typeof box_width == 'number') ? box_width : '',
					'height':(typeof box_height == 'number') ? box_height : ''
				});

				$('#sensor'+i+'_content').css({
					'width': (typeof box_width == 'number') ? box_width-30 : '',
					'height':(typeof box_height == 'number') ? box_height-30 : ''
				});

				// Pour IE<9
				if (GIWIK._context.ie < 9)
				{
					$('#sensor'+i).css({'display':'inline'});
				}
			}
		}
	};

	// Protection d'une page par password à passer en GET ("password"). On compare ici les 2 chaines sous forme MD5
	GIWIK.restrictAccess = function ()
	{
		if (typeof window._GET['password'] != 'string' || md5(window._GET['password']) != window.password_md5)
		{
			$('body').html('<div id="content"><div id="preload_images"></div><h1 style="display:block;text-align:center;padding-top:100px;">Sorry, restricted area</h1></div>');
			return false;
		}
		return true;
	};

	// Classe Heading : gestion du contenu spécifique de la rubrique en cours. Instanciée dans l'objet "HEADING" ————————————————————————————————————————————————————————————
	function Heading (self)
	{
		this.self = self;				// Nom de l'instance
		this.rootParent = this;			// Object racine
		this.name;						// Nom de la rubrique en cours
		this.index;						// Index de la rubrique dans le tableau GIWIK._headings
		this._heading_inputs = [];		// Déclaration du tableau contenant tous les éléments (champs, checkboxes, radios, masques etc.) ayant le pouvoir d'activation/désactivation (hormis le cas spécial des boutons "cancel/send")
		this.data_mode;					// Mode d'envoi des packets de données (0:léger, 1:standard ou 2:complet)
		// this._url_ajax = [];			// Tableau associatif des url à appeler régulièrement {url:options}
		this.url_ajax_to_be_called = 0;	// Index de la prochaine url à appeler (ajax uniquement, pas websocket)
		// this._url_ajax_options = [];	// Tableau des options à passer à GIWIK.ajax() pour chaque url de this._url_ajax (voir doc de GIWIK.ajax());
		this._baseFunctions =			// Fonctions de base destinées à être exécutées via execBaseFunction()
		[
			//'init',
			'construct',
			'getData',
			'readData',
			'readConf',
			'getConf',
			'sendConf',
			'display',
			'setSettingsActivity'
		];

		// Détection de la rubrique en cours ————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————

		// Recherche du nom du dossier en cours dans l'url (dossier le plus profond)
		var _taburl = window.location.pathname.split(/[\/]+/gi); // pathname = url de type lien absolu sans paramètres

		// Definition de la rubrique en cours
		this.name = ((_taburl[_taburl.length-1] == '') ? _taburl[_taburl.length-2] : _taburl[_taburl.length-1]).toLowerCase(); // IE<9 ne cree pas d'entrée dans le tableau de resultat pour le "/" de fin d'url

		var _heading_split = this.name.split("_");

		window.highlight_menu    = (_heading_split.length > 0) ? _heading_split[0] : "";
		window.highlight_submenu = (_heading_split.length > 1) ? _heading_split[0]+"_"+_heading_split[1] : "";

		// Récupération de l'adresse ip en cours
		window.ip = window.location.host;


		// Fonction générique de base (construct, getConf, readConf et display)
		// L'ordre de déclaration des fonctions définit l'ordre d'execution
		// Si une des fonctions éxécutées return false, c'est toute la fonction readConf qui s'arrête
		this.execBaseFunction = function (o, p, n, recursion)
		{
			if (!recursion)
			{
				// GIWIK.debug(n);
			}

			o.isExecuting = true;

			// n: nom de l'objet parent
			// o: objet à traiter
			// i: item
			// j: child-item
			// p: parameter

			var r,				//  r: élément du tableau "r"
				_r = [],		// _r: tableau renvoyé en return
				i, j;

			// o doit être un objet
			if (!o && !in_array(o.constructor, [Function, Object, Array]))
			{
				o.isExecuting = false;
				// console.log("n is not Function, Object or Array -> return false");
				return false;
			}

			if (recursion && o.constructor === Function)
			{
				r = o(p);

				// console.log('\t    '+recursion);
				// console.log('\t    -> executed');

				// Si la fonction retourne false, on stoppe le traitement de la fonction parente
				if (r === false)
				{
					o.isExecuting = false;
					return false;
				}
				// Sinon on stocke le résultat
				else if (r !== undefined)
				{
					_r = array_merge(_r, ((typeof r != 'object') ? [r] : r));
				}
			}
			else
			{
				// console.log(n);
			}

			for (i in o)
			{
				// console.log('\t .'+i);

				if (!o[i] || !in_array(o[i].constructor, [Function, Object, Array], true) || i === 'rootParent')
				{
					// console.log('\t    -> continue');
					continue;
				}

				if (o[i].constructor === Function)
				{
					// Les fonctions d'init ne s'exécutent qu'un seule fois, au chargement de la page
					if (i == 'init' && this.init.isdone)
					{
						continue;
					}

					// Exécution de la fonction et stockage du résultat
					r = o[i](p);

					// console.log('\t    -> executed');

					// Si la fonction retourne false, on stoppe le traitement de la fonction parente
					if (r === false)
					{
						o.isExecuting = false;
						return false;
					}
					// Sinon on stocke le résultat
					else if (r !== undefined)
					{
						_r = array_merge(_r, ((typeof r != 'object') ? [r] : r));
					}
				}

				if (count(o[i] > 0))
				{
					for (j in o[i])
					{
						// console.log('\t .'+j);

						if (!o[i][j] || !in_array(o[i][j].constructor, [Function, Object, Array], true) || j === 'rootParent')
						{
							// console.log('\t    -> continue');
							continue;
						}

						// Exécution de la fonction et stockage du résultat
						r = this.execBaseFunction(o[i][j], p, n, 'récursion .'+i+'.'+j);

						// Si la fonction retourne false, on stoppe le traitement de la fonction parente
						if (r === false)
						{
							o.isExecuting = false;
							return false;
						}
						// Sinon on stocke le résultat
						else if (r !== undefined)
						{
							_r = array_merge(_r, ((typeof r != 'object') ? [r] : r));
						}
					}
				}
			}
			o.isExecuting = false;

			// Retour de l'ensemble des retours
			return _r;
		};

		// Méthode "getData" (si plusieurs url spécifiées, elles seront appelées chacune à leur tour) ——————————————————————————————————————————————————————————————————————
		this.getData = function (param)
		{
			if (!GIWIK.init.isdone) {setTimeout(this.self+".getData()", 20); return;}

			// Récupération de l'heure du client
			var call_date = new Date();


			// Traitement récursif des fonctions filles ------------------------------------------------------------------------------
	 		var _r = this.execBaseFunction(this.getData, param, 'getData'); // tableau des retours des méthodes filles de getData
	 		//------------------------------------------------------------------------------------------------------------------------

	 		if (_r === false)
			{
				return false;
			}

			// Websocket
			if (GIWIK._plugins.websocket)
			{
				GIWIK.websocket.getData(_r);
			}
			// AJAX
			else
			{
				var _url_ajax = [],
					_url_ajax_options = [];

				if (_r && _r.constructor == Object)
				{
					// Sauvegarde des url à appeler régulièrement
					_url_ajax = array_keys(_r);

					// Sauvegarde des options de chaque url
					_url_ajax_options = array_values(_r);
				}
				else
				{
					// Par défaut GIWIK.cgifile seul est appelé
					_url_ajax = [GIWIK.cgifile+"?mode="+(GIWIK.data_groups ? '3&DataGroup=' : '')+this.data_mode];

					// Par défaut, pas d'options
					_url_ajax_options = [null];
				}


				// Envoi de la requête (si la récupération de données par groupe est disponible, les modes 0,1,2 sont remplacés par mode=3&DataGroup=0,1,2)
				GIWIK.ajax(_url_ajax[this.url_ajax_to_be_called], _url_ajax_options[this.url_ajax_to_be_called]);

				// Définition de l'index de la prochaine url à appeler
				this.url_ajax_to_be_called = (this.url_ajax_to_be_called+1 < _url_ajax.length) ? this.url_ajax_to_be_called+1 : 0;


				// DETECTION DE PERTE/RETOUR DE CONNEXION AVEC LE SERVEUR -------------------------------------------------------------------------------------------------------
				// La reprise de connexion est gérée dans GIWIK.analyzeResponseText() dès qu'une requête abouti à nouveau
				// s'il ne s'agit pas du 1er parsing on vérifie que le dernier parsing a eu lieu il y moins de n secondes
				// s'il s'agit du 1er parsing et que getData est rappelée par GIWIK.analyzeHTTPErrors (qui lui passe 'connection_lost')
				if ((typeof GIWIK.last_refresh_time == 'number' && (GIWIK.last_refresh_time < call_date.getTime() - GIWIK.connection_timeout))
					|| typeof GIWIK.last_refresh_time != 'number' && param == 'connection_lost')
				{
					// si la connexion n'est pas déjà perdue
					if (!GIWIK.connection_lost)
					{
						GIWIK.connection_lost = true; // !!! laisser cette ligne au début du if !!! pour éviter les memory overflow quand on déplace la fenêtre du navigateur

						if (typeof window.Statuschevron == 'object')
						{
							// Chevron en état d'alerte
							window.Statuschevron.setStatus(3);
						}

						HEADING.setSettingsActivity('disable');

						MSG.setGlobalStatus(2502);

						if (!(GIWIK.ihm_compactmode === false && GIWIK.window_size != 'full'))
						{
							// On force l'affichage du statut général (si élément "status" présent === si page control)
							$('#status').css('visibility','visible');
						}
					}
				}
			}
		};

		// Méthode "readData" ———————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
		this.readData = function (param)
		{
			// Vérification de l'activation des cookies
			STORAGE.checkCookies();

			// Traitement récursif des fonctions filles ------------------------------------------------------------------------------
			var _r = this.execBaseFunction(this.readData, param, 'readData'); // tableau des retours des méthodes filles de readData
			//------------------------------------------------------------------------------------------------------------------------

			if (_r === false)
			{
				return false;
			}

			// Appel de la méthode display à la fin du premier traitement de la fonction (cloture de la phase d'init de l'objet HEADING)
			if (!this.init.isdone)
			{
				// setTimeout(this.self+".display();",10); // setTimeout pour fluidifier l'affichage (laise le temps aux animations de "display" et/ou readData de se lancer)
				this.display();
			}
		};
		//———————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————


		// Méthode "readConf" ———————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
		this.readConf = function (param)
		{
			// Traitement récursif des fonctions filles ------------------------------------------------------------------------------
			var _r = this.execBaseFunction(this.readConf, param, 'readConf'); // tableau des retours des méthodes filles de readConf
			//------------------------------------------------------------------------------------------------------------------------

			if (_r === false)
			{
				return false;
			}

			// Appel de la méthode readData à la fin du premier traitement de la fonction
			if (!this.init.isdone)
			{
				this.readData();
			}
		};
		//———————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————


		// Méthode "getConf" ————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
		this.getConf = function (param)
		{
			//---------------------------------------------------------------------------------------------------------------------
			var _r = this.execBaseFunction(this.getConf, param, 'getConf');	// tableau des retours des méthodes filles de getConf
			//---------------------------------------------------------------------------------------------------------------------

			if (_r === false)
			{
				return false;
			}

			// Envoi de la requête si au moins un paramètre est passé
			if (count(_r) > 0)
			{
				// Websocket
				if (GIWIK._plugins.websocket)
				{
					GIWIK.websocket.getConf(_r);
				}
				// AJAX
				else
				{
					var q = "", i;

					for (i in _r)
					{
						if (in_array(typeof _r[i], ['string','number','boolean']))
						{
							q += '&'+i+'='+_r[i];
						}
					}

					if (q)
					{
						GIWIK.ajax(GIWIK.cgifile+'?mode=3'+q);
					}
				}
			}
			// Sinon, on lance directement le readConf
			else
			{
				this.readConf();
			}
		};
		// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————


		// Méthode "construct" ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
		this.construct = function (param)
		{
			// Définition du mode de récupération des données par défaut
			if (typeof this.data_mode != 'number')
			{
				switch (this.name)
				{
					case 'control_expertview' : this.data_mode = 2; break;	// Pour l'expert view -> mode expert
					case 'control'            : this.data_mode = 1; break;	// Pour la page control -> mode standard
					default                   : this.data_mode = 0; break;	// Pour toutes les autres pages -> mode léger
				}
			}

			// Traitement récursif des fonctions filles ---------------------------------------------------------------------------------
			var _r = this.execBaseFunction(this.construct, param, 'construct'); // tableau des retours des méthodes filles de construct
			//---------------------------------------------------------------------------------------------------------------------------

			// Si phase de preload, masquage du contenu
			if (GIWIK.preload_mode)
			{
				$('#header,#contenttop,#productlogo_ctnr,#content').hide();
			}

			if (_r === false)
			{
				return false;
			}

			// Construction des boutons de validation si la balise hôte est présente dans le DOM
			if ($('#cancelsend').length)
			{
				GIWIK.validationButtons.construct(_r.validation_buttons);
			}

			//this.setGlobalTimer(_r._set_timers);

			// Appel AJAX périodique si la communication websocket n'est pas activée
			if (!GIWIK._plugins.websocket)
			{
				this.getData();
			}


			// Marque que la phase de construction est terminée
			this.construct.isdone = true;
		};

		this.construct.header = function (param)		// GIWIK : entête
		{
			// Les popups ne possèdent pas de header
			if (this.rootParent.is_external_popup) {return;}

			$('body').append('<div id="header"></div>');

			// Si le bandeau de navigation doit être caché ///////////////////////////////////
			if (GIWIK.no_navbar)
			{
				$('#header').hide();
				$('html,body').css({overflow:'auto',overflowY:'auto'});
			}
			//////////////////////////////////////////////////////////////////////////////////


			var tmpl_header = "",
				url,
				url_params,
				idlastheading,
				subheadingcss,
				cssclass,
				mouse_events,
				i, j;

			// Sous menus ........................................................................................................................................
			for (i=0; i<GIWIK._headings.length; i++)
			{
				tmpl_header += '<ul id="subheading'+i+'" class="displaynone" onmouseover="GIWIK.displaySubmenu('+i+',\'show\')" onmouseout="GIWIK.displaySubmenu('+i+',\'hide\')">'; // VS bug IE6  onmouseover="GIWIK.css.setClass(\'subheading'+i+'\', \'subheading\');"

				idlastheading = count(GIWIK._subheadings[i]) - 1;

				for (j=0; j<count(GIWIK._subheadings[i]); j++)
				{
					// Definition de la classe CSS à appliquer
						subheadingcss = "subheading";

						// Si l'entree est active
						if (GIWIK._subheadings[i][j][1] == window.highlight_submenu)
						{
							subheadingcss += "i";
						}

						// S'il s'agit de la derniere entree
						if (j == idlastheading)
						{
							subheadingcss += "_last";
						}

					// Construction des paramètres de l'url cible si défini dans GIWIK._subheadings comme 3ème paramètre
					url_params = (typeof GIWIK._subheadings[i][j][2] == 'string') ? '?'+GIWIK._subheadings[i][j][2] : '';

					// Construction de l'url (passage de l'url en JS si elle n'est pas déjà sous cette forme pour autoriser le fonctionnement WebApp)
					url = GIWIK._subheadings[i][j][1];
					url = (url.match(/^javascript:/i)) ? url : 'javascript:window.location.href=\'../'+url+'/'+url_params+'\'';

					tmpl_header += '<li><a id="subheading'+i+'" class="'+subheadingcss+'" href="'+url+'">'+GIWIK._subheadings[i][j][0]+'</a></li>';
				}
				tmpl_header += '</ul>';
			}
			//....................................................................................................................................................

			tmpl_header += '<div id="top_bg">'
				+'<div id="top_ctnr">'
					+'<div id="logoixblue" class="displaynone"><img src="'+GIWIK.directories.img+'/logo_ixblue.png"/ class="retina"></div>'
					+'<div id="topmenu" class="displaynone">';
						if (GIWIK._secondary_headings.length > 0)
						{
							for (var sh=0; sh<GIWIK._secondary_headings.length; sh++)
							{
								// Construction de l'url (passage de l'url en JS si elle n'est pas déjà sous cette forme pour autoriser le fonctionnement WebApp)
								url = GIWIK._secondary_headings[sh][2];
								url = (url.match(/^javascript:/i)) ? url : 'javascript:window.location.href=\''+url+'\'';

								tmpl_header += '<a id="'+GIWIK._secondary_headings[sh][1]+'" href="'+url+'">'+GIWIK._secondary_headings[sh][0]+'</a>';
								if (sh != GIWIK._secondary_headings.length-1) {tmpl_header += '<span class="topmenu_spacer">|</span>';}
							}
						}
					tmpl_header += '</div>'
				+'</div>'
			+'</div>'

			+'<div id="mainmenu_bg" class="displaynone">'

				+'<div id="mainmenu_ctnr">'

					+'<div id="mainmenu" class="displaynone">';

					for (i=0; i<GIWIK._headings.length; i++)
					{
						// Les iPhones/iPod/iPad ne gèrent pas Java donc pas d'enregistrement des données
						if (GIWIK._headings[i][1] == 'datalogging' && (GIWIK._context.mobile_device || GIWIK._context.ipad)) {continue;}
						if (GIWIK._headings[i][0] == null) {continue;}

						if (GIWIK._headings[i][1] == window.highlight_menu)
						{
							cssclass = "headingactive";

							// Cas particulier dans lequel 'installation' doit être highlighté alors qu'on se trouve dans setup
							if (array_key_exists('i', window._GET) && GIWIK._headings[i][1] != 'installation')
							{
								cssclass = "heading";
							}
						}
						else
						{
							cssclass = "heading";

							// Cas particulier dans lequel 'installation' doit être highlighté alors qu'on se trouve dans setup
							if (array_key_exists('i', window._GET) && GIWIK._headings[i][1] == 'installation')
							{
								cssclass = "headingactive";
							}
						}

						if (i>0)
						{
							tmpl_header += '<span id="heading_sep'+i+'" style="display: none;"'+'>|</span>';	//à merger avec le tronc giwik
						}

						// S'il on est pas sur un appareil mobile (-> tactile), on définit les evenements lies au comportement des sous-menus
						if (!GIWIK._context.mobile_device && !GIWIK._context.ipad)
						{
							mouse_events = 'onmouseover = "GIWIK.displaySubmenu('+i+',\'show\')" onmouseout="GIWIK.displaySubmenu('+i+',\'hide\')"';
						}
						else
						{
							mouse_events = '';
						}

						// Construction des paramètres de l'url cible si défini dans GIWIK._headings comme 3ème paramètre
						url_params = (typeof GIWIK._headings[i][2] == 'string') ? '?'+GIWIK._headings[i][2] : '';

						// Construction de l'url (passage de l'url en JS si elle n'est pas déjà sous cette forme pour autoriser le fonctionnement WebApp)
						url = GIWIK._headings[i][1];
						url = (url.match(/^javascript:/i)) ? url : 'javascript:window.location.href=\'../'+url+'/'+url_params+'\'';

						// Les liens sont définis en JS pour permettre le mode WebApp sur iPad
						tmpl_header += '<a id="heading'+i+'" class="'+cssclass+'" href="'+url+'" '+mouse_events+ ' style="display: none;"'+'>'+GIWIK._headings[i][0]+'</a>';	//à merger avec le tronc giwik
					}

					tmpl_header += '</div>'

					+'<div id="help" class="displaynone"><a class="help" href="javascript:open_help()">'+MSG(['headings','help'])+'</a></div>'

				+'</div>'

			+'</div>';

			//alert(tmpl_header);
			$('#header').html(tmpl_header);
		};

		this.construct.content = function (param)		// GIWIK : contenu spécifique à la page
		{
			if (!this.rootParent.is_external_popup)
			{
				$("body").append('<div id="content" class="displaynone"></div>');
			}

			$("body").append('<div id="preload_images"></div>');

			// Prechargement des images
			GIWIK.init.preloadImages();
		};
		// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————


		// Méthode "sendConf" ———————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
		this.sendConf = function (param)
		{
			// Traitement récursif des fonctions filles --------------------------------------------------------------------------------
			var _r = this.execBaseFunction(this.sendConf, param, 'sendConf');	// tableau des retours des méthodes filles de sendConf
			//--------------------------------------------------------------------------------------------------------------------------

			if (_r === false)
			{
				// window.settings_modified = true;  évaluer les conséquences
				return false;
			}

			// Envoi de la requête si au moins un paramètre est passé
			if (count(_r) > 0)
			{
				// Websocket
				if (GIWIK._plugins.websocket)
				{
					GIWIK.websocket.sendConf(_r);
				}
				// AJAX
				else
				{
					var q = "",		// requête envoyée à la fin du traitement
						p,			// nom d'un paramètre
						v;			// valeur d'un paramètre

					for (p in _r)
					{
						v = _r[p];

						if (in_array(typeof v, ['string','number','boolean']))
						{
							switch (typeof v)
							{
								case 'string' :
									// v = encodeURIComponent(v); // encodeURIComponent pas utilisé car les INS ne comprennent pas les caractères hexa
									v = v.replace(/\?/g,'%3F')
									  	 .replace(/&/g, '%26')
									  	 .replace(/#/g, '%23')
									  	 .replace(/\+/g,'%2B')
									  	 .replace(/=/g, '%3D');
									//	 .replace(/"/g,'%22')	  // doit être géré côté cgi pour la réponse
									break;

								case 'boolean' :
									v = (v) ? 'true' : 'false';
									break;
							}

							q += '&'+p+'='+v;
						}
					}

					GIWIK.ajax(GIWIK.cgifile+'?mode=4'+q);
				}
			}
		};
		// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————


		// Méthode "display" ————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
		// Gestion dynamique de la mise en page du contenu (en fonction de la largeur de la fenetre)
		this.display = function (is_resize)
		{
			// Cas particulier du tout 1er démarrage de l'IHM, on n'affiche rien en attendant le system_type via le 1er mode 0/1/2
			if (GIWIK.system_type_has_to_be_confirmed) {return false;}

			if (is_resize)
			{
				if (!this.rootParent.init.isdone)
				{
					return false;
				}

				var new_window_size = GIWIK.window.getSize();

				// Redimensionnnement si la taille de la fenêtre (small/medium/full) a changé
				// Pour IE<9, à cause d'une gestion chaotique de l'évènement "onresize", on fait redimensionner systématiquement.
				if (GIWIK._context.ie < 9 || GIWIK.window_size != new_window_size)
				{
					// console.log('resize');
					GIWIK.window_size = new_window_size;
					GIWIK.maincontrol_size = (HEADING.name == 'control') ? GIWIK.window_size : 'mini';
				}
			}

			//---------------------------------------------------------
			this.execBaseFunction(this.display, is_resize, 'display');
			//---------------------------------------------------------

			// Gestion des images hd pour les écrans de type "retina" —————————————————————————————————————————————————————————————————————————————
			// Toutes les images dotées de la classe "retina" sont remplacées par une version 4X plus définie (whidth et height X2)
			$('img.retina').each(function () {
				var img        = $(this),
					src_actual = img.attr('src'),
					sfx        = (window.devicePixelRatio > 1) ? '@2x' : '',
					src_needed = src_actual.replace(/(@\dx)?\.(png|gif|jpe?g)$/, sfx+'.$2');

				// Si l'image actuelle doit être changée
				if (src_actual != src_needed)
				{
					img.attr('src', src_needed);  // console.log('devicePixelRatio:'+window.devicePixelRatio+' '+src_actual+' != '+src_needed)
				}
			});
			//—————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————

			// Activation/désactivation des paramètres lors de l'initialisation
			if (!this.rootParent.init.isdone)
			{
				this.rootParent.setSettingsActivity();

				// Partie spécifique à la page control si le plugin control est disponible
				if (this.rootParent.name == 'control' && GIWIK._plugins.control)
				{
					// Affichage d'office du popup statut s'il vient d'y avoir clic sur le chevron sur une autre page que control où si le div main_content est vide (dans le cookie -> popupstatus:visible)
					if (STORAGE.get('popupstatus') == 'visible')
					{
						// Affichage du popup
						this.rootParent.displayDetailedStatus('open');
					}
					else
					{
						// Masquage du popup
						this.rootParent.displayDetailedStatus('close');
					}
				}

				// Cas particulier des popups
				if (this.is_external_popup)
				{
					// Masquage de la barre de scroll verticale
					$('html').css('overflow-y', 'auto');

					// Ajout du titre de la boite de config
					document.title = strip_tags($('.box_titlei')[0].innerHTML).toUpperCase()+' - '+document.title;

					// Gestion automatique de la taille du popup
					if (!HEADING.init.isdone)
					{
						GIWIK.window.setDimensions(undefined, ((HEADING.name == 'datalogger') ? $('body').height()+20 : undefined));
					}
				}
				// Cas standard
				else
				{
					// Ajout une marge basse au body pour faire respirer la page
					$('#content').css('margin-bottom', '20px');
				}

				if (GIWIK._context.mobile_device)
				{
					// On s'assure que le body à une hauteur suffisante pour pouvoir toujour scroller pour cacher la barre de navigation
					$('body').css({'min-height':screen.availHeight*2.5});

					// Masquage automatique de la barre d'adresse si aucune ancre n'est définie
					if (!document.location.hash)
					{
						$('html,body').animate({scrollTop:'0'}, 500);
					}
				}

				// Affectation des fonctions liées aux évènements JavaScript (évènement resize absent des popups)
				if (window.addEventListener)
				{
					window.addEventListener('resize', function () {HEADING.display(true);}, false);
				}
				else	// PLAN B pour IE<9
				{
					window.attachEvent('onresize', function () {HEADING.display(true);});
				}

				// Appel AJAX périodique si la communication websocket n'est pas activée
				if (!GIWIK._plugins.websocket)
				{
					// Définition du timer appelant getData ----------------------------
					GIWIK.setTimer(this.self+".getData();", GIWIK.update_timeout);
					//------------------------------------------------------------------
				}

				// La fin du premier appel à cette méthode Display() marque la fin de la phase d'init pour l'objet HEADING
				this.rootParent.init.isdone = true;
			}
		};

		// Gestion dynamique de la mise en page au niveau de l'entete (en fonction de la largeur de la fenetre)
		this.display.header = function (is_resize)
		{
			if (this.rootParent.is_external_popup) {return};	// ne concerne pas les popups

			// Application des classes CSS
			GIWIK.css.setClass('header', 'header_'+GIWIK.window_size);
			GIWIK.css.setClass('top_ctnr', 'top_ctnr_'+GIWIK.window_size+GIWIK.css_compactmode);
			GIWIK.css.setClass('logoixblue', 'logoixblue_'+GIWIK.window_size);
			GIWIK.css.setClass('topmenu', 'topmenu_'+GIWIK.window_size);
			GIWIK.css.setClass('mainmenu_bg', 'mainmenu_bg');
			GIWIK.css.setClass('mainmenu_ctnr', 'mainmenu_ctnr_'+GIWIK.window_size+GIWIK.css_compactmode);
			GIWIK.css.setClass('mainmenu', 'mainmenu_'+GIWIK.window_size);

			// $('#mainmenu>a:first-child').css('padding-left','0px');
			// $('#mainmenu>a:last-child').css('padding-right','0px');

			// iPhone : crucial pour éviter un bug de taille de police qui explose la mise en page !
			if (GIWIK._context.iphone)
			{
				$('#mainmenu').css({'margin-top': '-1px'});
			}
		};

		this.display.content = function (is_resize)
		{
			// Taille actuelle de la fenetre
			if (HEADING.is_external_popup)
			{
				GIWIK.css.setClass('content', 'displayblock');
			}
			else
			{
				var width,bg;
				switch (GIWIK.window_size+GIWIK.css_compactmode)
				{
					case 'full'        : width = '760px'; bg = 'red';    break;
					case 'fullcompact' : width = '616px'; bg = 'green';  break;
					default            : width = '100%';  bg = 'yellow'; break;	// medium, small ou fullwidth
				}

				GIWIK.css.setClass('content', 'content');

				//$('#content').css({'background': bg});

				$('#content').css({
					'width':width,
					'margin-left':'auto',
					'margin-right':'auto'
				});
			}
			// Pour les vrais navigateurs sauf pour les plateformes mobiles, ajout de l'effet de "fade in" au chargement de la page
			if (!is_resize && !this.rootParent.content_fadedin && !GIWIK._context.ie < 9 && !GIWIK._context.mobile_device)
			{
				$('#content').css('display','none');
				$('#content').fadeIn(500);

				// Marque le fait que le contenu de la rubrique est apparu avec l'effet de fade in. Utile pour avoir l'effet uniquement au chargement de la page
				this.rootParent.content_fadedin = true;
			}
		};
		// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————


		// Vérifie que les fonctions de base n'ont pas été écrasées
		this.checkBaseFunctions = function ()
		{
			// Garde fou contre l'écrasement malencontreux des méthodes de base (readConf, getConf, construct, sendConf et display)
			for (var i in this._baseFunctions)
			{
				if (typeof this[this._baseFunctions[i]].rootParent == 'undefined')
				{
					alert("Error : function \""+this.self+"."+this._baseFunctions[i]+"\" has been replaced !");
					return;
				}
			}
		};

		// Méthode "Init" (exécutée APRÈS l'évènement "load") ———————————————————————————————————————————————————————————————————————————————————————————————————————————————
		this.init = function (param)
		{
			// Vérifie que les fonctions de base n'ont pas été écrasées
			this.checkBaseFunctions();

			// Flag marquant le déroulement de la phase d'init de l'objet
			this.init.isdone = false;

			// Effacement de tout code HTML déja présent
			$('body').html("");

			// Pour les anciennes version d'IE on ne peut connaitre la taille de la fenêtre qu'APRÈS l'évènement "load"
			if (GIWIK._context.ie < 9)
			{
				GIWIK.window_size = GIWIK.window.getSize();
				GIWIK.maincontrol_size = (HEADING.name == 'control') ? GIWIK.window_size : 'mini';
			}

			// Détermination de l'index de la rubrique active
			for (var i in GIWIK._headings)
			{
				if (GIWIK._headings[i][1] == HEADING.name)
				{
					HEADING.index = i;
				}
			}

			// Cas des pages "menu" via navigation par clic et non par onglet (-> si la rubrique en cours possède des sous rubriques) -----------------------------------
			if (count(GIWIK._subheadings[this.index]) > 0)
			{
				this.construct.subheadings = function ()
				{
					var submenu = '',
						css_highlight = '',
						url_params,
						url,
						html = '',
						i = this.rootParent.index,
						j;

					for (j=0; j<count(GIWIK._subheadings[i]); j++)
					{
						// Construction des paramètres de l'url cible si défini dans GIWIK._subheadings comme 3ème paramètre
						url_params = (typeof GIWIK._subheadings[i][j][2] == 'string') ? '?'+GIWIK._subheadings[i][j][2] : '';

						// Construction de l'url (passage de l'url en JS si elle n'est pas déjà sous cette forme pour autoriser le fonctionnement WebApp)
						url = GIWIK._subheadings[i][j][1];
						url = (url.match(/^javascript:/i)) ? url : 'javascript:window.location.href=\'../'+url+'/'+url_params+'\'';

						html += '<a id="subheading'+i+'" href="'+url+'">'+GIWIK._subheadings[i][j][0]+'</a>';
					}

					$('#content').html('<div id="submenu">'+html+'</div>');
				};
			}

			this.construct();
		};
		// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————

		// Active/désactive les modules de saisie et leurs boutons cancel/send (undefined, "enable" ou "disable")
		this.setSettingsActivity = function (action_asked)
		{
			// console.log ('setSettingsActivity('+action_asked+')');

			// Traitement récursif des fonctions filles ------------------------------------------------------
			var _r = this.execBaseFunction(this.setSettingsActivity, action_asked, 'setSettingsActivity');
			// -----------------------------------------------------------------------------------------------

			if (_r === false)
			{
				return false;
			}
		};

		// Définition de l'action par défaut
		this.setSettingsActivity.checkAction = function (action_asked)
		{
			// Si l'action n'est pas définie ou 'enable', elle est vérifiée
			// if (in_array(action_asked, [undefined, 'enable'], true)) // bug avec IE8
			if (action_asked === undefined || action_asked === 'enable')
			{
				var action = (window[system].is_started === true && (!window.Statuschevron || window.Statuschevron.getStatus() !== 10) && GIWIK.connection_lost !== true) ? 'enable' : 'disable';
			}
			else
			{
				var action = 'disable';
			}

			// console.log('checkAction phase 1 '+action_asked+' --> '+action);

			// Si une fonction spécifique existe pour la définition l'action par défaut
			if (typeof this.rootParent.setSettingsActivityCheckActionSpecific == 'function')
			{
				var action_specific = this.rootParent.setSettingsActivityCheckActionSpecific(action);

				if (in_array(action_specific,['enable','disable']))
				{
					action = action_specific;
				}
				else if (action_specific === false)
				{
					return false;
				}

				// console.log('checkAction phase 2 -> '+action);
			}

			// Si l'action demandée a été corrigée en fonction du contexte, on relance la fonction avec le bon paramètre (utile pour les setSettingsActivity.global, local etc.)
			if (action !== action_asked)
			{
				// console.log('RELANCE de setSettingsActivity ('+action+')');

				// On relance la fonction setSettingsActivity dans 1ms, le temps que l'actuel appel soit arrêté
				setTimeout(this.rootParent.self+".setSettingsActivity('"+action+"');",1);
				return false;
			}
			else
			{
				// console.log('FIN de checkAction ('+action+')');

				this.rootParent.setSettingsActivity.action = action;
			}
		};

		this.setSettingsActivity.execAction = function (action)
		{
			var missing_object = false;

			switch (action)
			{
				case 'enable':
					if (this.rootParent.activity !== 1)
					{
						for (var i in this.rootParent._heading_inputs)
						{
							// Si l'objet existe
							if (typeof window[this.rootParent._heading_inputs[i]] == 'object')
							{
								// Activation des modules (les modules dont "auto_enable" vaut "false" ne sont pas concernés)
								if (window[this.rootParent._heading_inputs[i]].auto_enable)
								{
									window[this.rootParent._heading_inputs[i]].enable();
								}
							}
							else
							{
								missing_object = true;
							}
						}

						if (window.settings_modified === true || window.settings_modified_unload === true)
						{
							if (typeof window.Cancel_settings == 'object')   {window.Cancel_settings.enable();}
							if (typeof window.Validate_settings == 'object') {window.Validate_settings.enable();}
						}
						else
						{
							if (typeof window.Cancel_settings == 'object')   {window.Cancel_settings.disable();}
							if (typeof window.Validate_settings == 'object') {window.Validate_settings.disable();}
						}

						if (typeof window.Cancel_settings == 'object' && typeof window.Validate_settings == 'object')
						{
							$('#cancelsend_ctnr')[(this.state === undefined) ? 'show' : 'slideDown']();
						}

						// Si tous les objets ont bien été activés, on marque l'object HEADING comme tel
						if (!missing_object && this.rootParent.init.isdone)
						{
							this.rootParent.activity = 1;
						}
					}
					break;

				case 'disable':
					if (this.rootParent.activity !== 0)
					{
						// Désactivation des modules de saisie
						for (var i in this.rootParent._heading_inputs)
						{
							// Si l'objet existe
							if (typeof window[this.rootParent._heading_inputs[i]] == 'object')
							{
								window[this.rootParent._heading_inputs[i]].disable();
							}
							else
							{
								missing_object = true;
							}
						}

						// Masquage des boutons cancel et send s'ils sont présents
						if (typeof window.Cancel_settings == 'object' && typeof window.Validate_settings == 'object')
						{
							$('#cancelsend_ctnr')[(this.state === undefined) ? 'hide' : 'slideUp']();
						}

						// Si tous les objets ont bien été désactivés, on marque l'object HEADING comme tel
						if (!missing_object && this.rootParent.init.isdone)
						{
							// clearTimeout(window.set_settings_activity_disable);
							this.rootParent.activity = 0;
						}
					}
					break;
			}

			//alert('action : '+action+'\nmissing object(s) : '+missing_object+'\n'+print_r(this._heading_inputs));
			missing_object = null;

			// Stockage de l'état courant
			this.state = action;
		};

		// Pour la gestion d'éventuels boutons de contrôle
		this.setSettingsActivity.controlButtons = function () {};


		// Lors d'un évènement fermeture/rechargement/changement de la page : apparition d'une boite de dialogue si on des paramètres n'ont pas été sauvegardés
		this.confirmUnload = function ()
		{
			// Stockage de l'URL (pour un éventuel retour ultérieur à celle-ci)
			// --> permet de contourner le fait que la propriété native document.referrer ne stocke pas les ancres et est parfois désactivée par le navigateur
			STORAGE.setSession('referrer', document.URL);

			// VS BUG IE<9 qui considère qu'il y a onbeforeunload à chaque requête AJAX, il faut les 2 flags à "true"
			// Autrement si un des 2 flags est true
			// Ou si on est en logging (datalogger)
			if ((GIWIK._context.ie < 9 && window.settings_modified === true && window.settings_modified_unload === true)
			 ||
			 (!GIWIK._context.ie < 9 && window.settings_modified === true || window.settings_modified_unload === true)
			 ||
			 window.is_logging)
			{
				var return_msg = (window.is_logging) ? MSG(['confirm','unload_datalogger']) : MSG(['confirm','unload']);
				return return_msg;
			}
		};

		// Initialisation d'une fonction de base (pourvue des méthodes global, _plugins et local)
		this.initBaseFunction = function (fn_name)
		{
			this[fn_name].rootParent = this;	// GIWIK : objet racine pour utilisation de "this" dans les méthodes de second niveau

			// Méthodes par défaut (l'ordre des déclarations ci-dessous définit l'ordre d'execution des fonctions)
			this[fn_name].first         = false;			// EQUIPE GIWIK / EQUIPES PRODUITS : commune à toutes les pages, exécutée avant tous les autres traitements (giwik.app.js ou plugins)
			this[fn_name].global        = false;			// EQUIPES PRODUITS : commune à toutes les pages (à surdéclarer dans app.js)
			this[fn_name]._plugins      = {};				// EQUIPES PRODUITS : spécifiques à chaque plugin concerné par la page
			this[fn_name].local         = false;			// EQUIPES PRODUITS : spécifique à la page courante (à surdéclarer dans xxxx.app.js)
			this[fn_name].last          = function () {};	// EQUIPES PRODUITS : commune à toutes les pages, exécutée après tous les autres traitements (à surdéclarer dans app.js)
			this[fn_name].last.global   = false;			//			"
			this[fn_name].last._plugins = {};				//			"
			this[fn_name].last.local    = false;			//			"
		};

		// Normalement affecté au 1er appel de this.baseFunction, cette étape anticipée permet de détecter lors de l'init les écrasement de fonction par absence de la propriété rootParent
		for (var i in this._baseFunctions)
		{
			this.initBaseFunction(this._baseFunctions[i]);
		}
	};


	// Classe Storage : gestion du stockage local des informations ——————————————————————————————————————————————————————————————————————————————————————————————————————————
	function Storage (system_name)
	{
		// Selon leur duree de vie de la donnée, on utilisera :
		// - setSession() pour un stockage qui dure le temps de la session
		// - setPermanent() pour un stockage permanent
		//
		// Pour la recuperation d'une donnee de configuration, on utilisera la
		// methode get() qui permet, en option, de suggerer une valeur par defaut
		// si la donnee n'a pas encore ete definie.

		this.system_name        = system_name;									// nom du produit
		this.sess_cookiename    = system_name+"_sess";							// nom du cookie de session
		this.perm_cookiename    = system_name+"_perm";							// nom du cookie permanent
		this.sess_cookieoptions = "path=/";										// options du cookie de session
		this.perm_cookieoptions = "path=/; expires=Tue, 01 Jan 2030 00:00:00";	// options du cookie permanent

		/*	Constructeur Conf()
		 *
		 *	L'objet cree est initialise avec la configuration stockee dans les
		 *	cookies "<system_name>_perm" et "<system_name>_sess".
		 */
		this.conf = {};					// objet voué à stocker toutes le couples clé/valeur

		//------------------------------------------------------------------------------
		/*	Methode get()
		 *
		 *	Recupere la valeur de la donnée de configuration appelee <name>.
		 *
		 *	Le paramètre <default_value> est optionnel et permet de spécifier une
		 *	valeur par défaut à retourner si <name> n'a jamais été définie avant.
		 */
		this.get = function (name, default_value)
		{
			// Si la valeur retournée est un tableau ou un objet (tableau associatif), on retourne une copie de celle-ci pour éviter les problèmes de référence
			return (typeof this.conf[name] == 'undefined') ? default_value : ((typeof this.conf[name] == 'object') ? array_copy(this.conf[name]) : this.conf[name]);
		};

		//------------------------------------------------------------------------------
		/*	Methode set() alias de setSession()
		 *
		 *	Positionne la donnée de configuration <name> a la valeur <value>.
		 */
		this.set = function (name, value)
		{
			this.setSession(name, value);
		};

		//------------------------------------------------------------------------------
		/*	Methode setPermanent()
		 *
		 *	Positionne la donnée de configuration <name> à la valeur <value> et
		 *	rend cette donnée indéfiniment persistante, c'est-a-dire qu'elle
		 *	survivra a la fermeture du navigateur.
		 *
		 *	<value> est optionnelle. Si le paramètre n'est pas spécifié, la valeur
		 *	actuelle de la donnée est utilisee.
		 */
		this.setPermanent = function (name, value)
		{
			this._store_in_cookie(this.perm_cookiename, this.perm_cookieoptions, name, value);
		};

		//------------------------------------------------------------------------------
		/*	Methode setSession()
		 *
		 *	Positionne la donnée de configuration <name> à la valeur <value> et
		 *	rend cette donnée persistante tout au long de la session, c'est-a-dire
		 *	jusqu'a la fermeture du navigateur.
		 *
		 *	<value> est optionnelle. Si le paramètre n'est pas spécifié, la valeur
		 *	actuelle de la donnée est utilisée.
		 */
		this.setSession = function (name, value)
		{
			this._store_in_cookie(this.sess_cookiename, this.sess_cookieoptions, name, value);
		};

		//------------------------------------------------------------------------------
		/*	Methode del()
		 *
		 *	Supprime la donnée de configuration <name>.
		 */
		this.del = function (name)
		{
			if (name in this.conf)
			{
				if (name in this[this.sess_cookiename])
				{
		    		this.setSession(name, undefined);
		    	}

		    	if (name in this[this.perm_cookiename])
				{
		    		this.setPermanent(name, undefined);
		    	}
			}
		};

		//------------------------------------------------------------------------------
		/*	Methode reset()
		 *
		 *	Supprime tout le contenu stocké.
		 */
		this.reset = function ()
		{
			this._store_in_cookie(this.perm_cookiename, this.perm_cookieoptions, undefined, undefined, true);
			this._store_in_cookie(this.sess_cookiename, this.sess_cookieoptions, undefined, undefined, true);
		};

		//------------------------------------------------------------------------------
		/*	Methode privée _store_in_cookie()
		 *
		 *	Stocke dans le cookie <cookie_name> l'ensemble des donnee de
		 *	configuration qui lui sont associees.
		 *
		 *	Le parametre <cookie_options> est optionnel et permet de specifier les
		 *	options de stockage du cookie dans le navigateur (chemin, domaine,
		 *	expiration, etc.)
		 *
		 *	Le parametre <conf_name>, s'il est present, represente une donnee de
		 *	configuration a ajouter au cookie. <conf_name> doit correspondre a une
		 *	donnee de type primaire sinon une exception est levee.
		 *
		 *	Le parametre <conf_value>, s'il est present, represente la valeur de la
		 *	donnee de configuration <conf_name> qui sera mise a jour.
		 */
		this._store_in_cookie = function (cookie_name, cookie_options, conf_name, conf_value, reset)
		{
			// Vérification de l'activation des cookies
			this.checkCookies();

			// Cas particulier du reset (=== effacement complet) du contenu des cookies
			if (reset === true)
			{
				this[cookie_name] = {};
			}
			// Le couple clé / valeur doit être correctement défini (cle:string et valeur: non undefined) et ne pas déjà exister à l'identique
			else if (typeof conf_name != 'string' || this.conf[conf_name] === conf_value)
			{
				return;
			}
			// Suppression d'un paramètre
			else if (typeof conf_value == 'undefined')
			{
				// Suppression de la propriété dans l'objet conf global
				delete this.conf[conf_name];

				// Suppression de la propriété dans l'objet spécifique au cookie "cookie_name"
				delete this[cookie_name][conf_name];
			}
			// Stockage d'unparamètre
			else
			{
				// Mise en Mémoire dans l'objet conf global
				this.conf[conf_name] = conf_value;

				// Stockage dans l'objet spécifique au cookie "cookie_name"
				this[cookie_name][conf_name] = conf_value;
			}

			// On refabrique le cookie avec la nouvelle valeur et on le stocke
			var cookie = cookie_name + '='+encodeURIComponent(JSON.stringify(this[cookie_name]));

			if (cookie_options)
			{
				cookie += '; '+cookie_options;
			}

			document.cookie = cookie;
			////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		};


		//------------------------------------------------------------------------------
		/*	Methode privée _restore_from_cookie()
		 *
		 *	Recupere l'ensemble des donnee de configuration stockées dans le cookie.
		 *	<cookie_name>. Grâce à JSON, les types de données sont conservés.
		 */
		this._restore_from_cookie = function (cookie_name)
		{
			// Vérification de l'activation des cookies
			this.checkCookies();

			var cookies = document.cookie.split(/\s*;\s*/);
			var cookie_conf = {};

			for (var i in cookies)
			{
				// Protection contre les cookies mal formatés (le split requiert une string)
				if (typeof cookies[i] != 'string'){continue;}

				// Chaque cookies[n] est de la forme "nom=<code_JSON>"
				var _elems = cookies[i].split(/\s*=\s*/);

				if (_elems[0] == cookie_name)
				{
					// Si le cookie contient du JSON valide, on le charge en mémoire
					try{cookie_conf = JSON.parse(decodeURIComponent(_elems[1]));}
					// Sinon, on ne fait rien, le cookie sera écrasé par la suite dès le 1er appel à _store_in_cookie()
					catch(e){}
				}
			}

			// Stockage du contenu du cookie
			this[cookie_name] = cookie_conf;

			// Remplissage de la variable d'accès aux données
			for (var conf_name in cookie_conf)
			{
				this.conf[conf_name] = cookie_conf[conf_name];
			}
		};

		// Vérification de l'activation des cookies du naigateur
		this.checkCookies = function ()
		{
			if (!GIWIK.init.beforeLoadEvent.isdone)
			{
				return;
			}

			// Si les cookies sont désactivés et que le message d'avertissement n'est pas déjà présent
			if (!navigator.cookieEnabled)
			{
				if (!window.Usermsg_cookies)
				{
					// On affiche le message d'avertissement
					$('body').prepend('<div id="alert_cookies_ctnr"><div id="alert_cookies"></div></div>');

					window.Usermsg_cookies = new User_msg();
					window.Usermsg_cookies.construct('alert_cookies',3,MSG(['alerts','cookies']));

					// Cas de la page de prechargement
					if (GIWIK.preload_mode)
					{
						$('#alert_cookies_ctnr').css({'margin-top':'8%','max-width':'600px'});
						$('#preload_anim').css({'display':'none'});
					}
				}
				return false;
			}
			// Si les cookies viennent d'être réactivés alors que le message d'avertissement est encore présent
			else if (window.Usermsg_cookies)
			{
				// On recharge la page
				window.location.reload();
				return;
			}

			return true;
		};

		// On importe la configuration stockee dans les cookies
		this._restore_from_cookie(this.perm_cookiename); //print_r(this[this.perm_cookiename],'restore cookie permanent');
		this._restore_from_cookie(this.sess_cookiename); //print_r(this[this.sess_cookiename],'restore cookie session');
	};


// MESSAGES (MSG) : affichage des messages et table des messages —————————————————————————————————————————————————————————————————————————————————————————————————————————————

	// Fonction MSG()
	// Retourne un message de la table dans la langue courante par défaut.
	// Les options sont passées sous forme d'objet {}:
	// font_case: 'lower'|'upper' --> gestion de la casse
	// disable_undefined_console_msg -> désactive le message dans la console en cas d'inexistance du message (utile pour tester l'existence du message)
	// lang:      'en'|'fr'...    --> pour forcer la langue
	// remove_br: true/balse      --> supprime toutes les balises HTML de retour à la ligne "<br/>"
	// default: message par défaut en cas d'absence du message dans la table des messages
	// Retourne la version anglaise si pas de traduction disponible dans la langue demandée
	function MSG (_target, _options)
	{
		if (typeof _target != 'object')     {if (GIWIK.simulation_mode){alert('MSG():\n"'+_target+'" \'s type is not an array');} return;}
		if (typeof _options != 'object')    {var _options = {};}

		// Langue à retourner
		var lang = (_options.lang) ? _options.lang : GIWIK.lang

		// Ajout de la langue à la liste des arguments
		_target.push(lang);

		// Message à retourner
		var msg;

		// Initialisation de la chaîne qui va être complètée avec les arguments
		var string = "MSG";

		// Test de validité pour chaque argument passé
		for (var i in _target)
		{
			// Cas de la langue (dernière clé du tableau)
			if (i == _target.length-1 && lang != 'en' && typeof eval(string)[lang] == 'undefined')
			{
				string += "['en']";
			}
			else
			{
				string += "['"+_target[i]+"']";
			}

			if (typeof eval(string) == 'undefined')
			{
				break;
			}
		}

		msg = eval(string);

		// Si le message est une fonction, on l'exécute pour obtenir la chaîne attendue
		if (typeof msg == 'function')
		{
			msg = msg();
		}
		else if (typeof msg == 'string')
		{
			// Si une case particulière est demandée
			if (_options.font_case)
			{
				switch (_options.font_case)
				{
					case 'upper': msg = msg.toUpperCase(); break;
					case 'lower': msg = msg.toLowerCase(); break;
				}
			}

			// Supprime les balises <br/> d'une chaine
			if (_options.remove_br)
			{
				msg = msg.replace(/<br\s*\/?>/gi, "");
			}
		}
		else if (typeof msg == 'undefined')
		{
			if (typeof _options['default'] != 'undefined')
			{
				msg = _options['default'];
			}
			else
			{
				if (GIWIK.simulation_mode && !_options.disable_undefined_console_msg)
				{
					console.log('MSG():\n"'+string+'" \'s is undefined');
				}
			}
		}

		string = null;

		return msg;
	};

	// Définition de l'état (couleur) d'un message en fonction de son code
	MSG.defineState = function (message_code)
	{
		if (message_code || message_code === 0)
		{
			if (typeof message_code == 'string') {message_code = parseFloat(message_code);}

			// S'il s'agit d'un code "warning"
			if ((message_code >= 1000 && message_code <= 1999) || (message_code >= 20000 && message_code <= 29999))
			{
				var state = '2';
			}
			// S'il s'agit d'un code "erreur"
			else if ((message_code >= 2000 && message_code <= 2999) || (message_code >= 30000 && message_code <= 39999))
			{
				var state = '3';
			}
			// S'il s'agit d'un code de fonctionnement nominal
			else
			{
				var state = '1';
			}
			return state;
		}
	};

	// Gestion de l'affichage des messages de statut via leur code [statuscode] (global et optionnellement détaillé)
	// [global_is_string_and_use_state et detailed_is_string_and_use_state permettent de d'afficher les 2 messages global et detail
	// sans passer par la table des messages et de leur appliquer l'état (couleur) passé]
	MSG.setGlobalStatus = function (global_code_or_string, global_state, detailed_code_or_string, detailed_state)
	{
		if (HEADING.name != 'control')
		{
			return;
		}

		var global_msg   = (typeof global_code_or_string == 'string')
						 ? global_code_or_string
						 // statuscodes_deducted spécifique SSD : codes déduits, non-transmis par l'embarqué
						 : (MSG['statuscodes_deducted'])
						 	? MSG(['statuscodes_deducted',global_code_or_string])
						 	: MSG(['statuscodes',global_code_or_string], {'default':""});

		var global_state = (typeof global_state == 'number')
						 ? global_state
						 : MSG.defineState(global_code_or_string);

		// Si le message a changé
		if (global_msg !== HEADING.global_status_msg_html)
		{
			// Stockage du code HTML du nouveau message
			HEADING.global_status_msg_html = global_msg;

			$('#global_msg').html(HEADING.global_status_msg_html);
			$('#global_msg').css('color', GIWIK.css['color_'+global_state]);
		}

		MSG.setDetailedStatus(detailed_code_or_string, detailed_state);
	};

	// Gestion de l'affichage du message de statut détaillé à partir d'un code [statuscode] ou d'une chaîne (s'affiche sous le message global sur la page control)
	// detailed_is_string_and_use_state : cf. ci-dessus
	MSG.setDetailedStatus = function (detailed_code_or_string, detailed_state)
	{
		if (HEADING.name != 'control')
		{
			return;
		}

		var detailed_msg   = (typeof detailed_code_or_string == 'string')
						 ? detailed_code_or_string
						 : MSG(['detailedstatuscodes',detailed_code_or_string], {'default':""});

		var detailed_state = (typeof detailed_state == 'number')
						 ? detailed_state
						 : MSG.defineState(detailed_code_or_string);

		// Si le message a changé
		if (detailed_msg !== HEADING.detailed_status_msg_html)
		{
			// Stockage du code HTML du nouveau message
			HEADING.detailed_status_msg_html = detailed_msg;

			$('#detailed_msg').html(HEADING.detailed_status_msg_html);
			$('#detailed_msg').css('color', GIWIK.css['color_'+detailed_state]);
		}
	};


// STATUS ———————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————

	// Traitement des bits de statuts
	GIWIK.statusBitsInfo =
	{
		// Traitement sur les bits AVANT l'exécution de la méthode "unify" (à redéclarer dans status.js de la partie applicative)
		preUnify : function (_ui_status)
		{
			return _ui_status;
		},

		// Rassemble tous les bits de statuts en un tableau
		unify : function (_ui_status)
		{
			_ui_status = this.preUnify(_ui_status);

			// Initialisation pour SAMS qui ne passe pas par GIWIK.statusBitsInfo.init
			GIWIK.initUIStatusBitDepth();

			var _ui_status_unified = [];

			for (var i=0; i<_ui_status.length; i++)
			{
				for (var j=0; j<GIWIK.ui_status_bit_depth; j++)
				{
					_ui_status_unified[j+GIWIK.ui_status_bit_depth*i] = ((_ui_status[i] >> j) & 0x1);
				}
			}

			_ui_status_unified = this.postUnify(_ui_status_unified);

			return _ui_status_unified;
		},

		// Traitement sur les bits APRÈS l'exécution de la méthode "unify" (à redéclarer dans status.js de la partie applicative)
		postUnify : function (_ui_status_unified)
		{
			return _ui_status_unified;
		},

		// Initialise le tableau des bits de statuts et appelle la fonction de définition de ces bits (GIWIK.statusBitsInfo.set() dans status.js)
		init : function ()
		{
			// Si aucune déclaration de statuts (-> absence de fichier status.js)
			if (!GIWIK.statusBitsInfo.set) {return;}

			// Définition du nombre d'entiers utilisés pour les statuts systèmes, on considère que TOUS les entiers sont pour le système
			GIWIK.ui_status_nb_int_for_system = (typeof window[system].fixed_status == 'number')
				? window[system].fixed_status
				: (window[system]._ui_status ? window[system]._ui_status.length : 0);

			// Initialisation de la variable de définition de l'offset sur les entiers de statuts (ui_status),
			// si pas définie dans app.js via l'option "before_data_group_processing" de la fonction GIWIK.ajax
			// (cas de la communication multi-systèmes avec combinaison de leurs statuts. Les statuts additionnels sont ajoutés AVANT les statuts système)
			if (typeof GIWIK.ui_status_offset != 'number')
			{
				GIWIK.ui_status_offset = 0;
			}

			// Initialisation du nombre par défaut de bits dans chaque entier de statut
			GIWIK.initUIStatusBitDepth();

			GIWIK._status_bits_info = [];

			// Définition des bits de statuts
			GIWIK.statusBitsInfo.set();

			// copie des statuts vers un tableau "usine" qui ne sera pas modifié
			GIWIK.statusBitsInfo.backup();

			// Gestion de l'ordre des statuts (si le plugin co,ntrol est chargé et la fonction dédiée disponible)
			if (typeof GIWIK.statusBitsInfo.fillGroups === 'function')
			{
				GIWIK.statusBitsInfo.fillGroups();
			}
		},

		// Copie des statuts vers un tableau "usine" qui ne sera pas modifié
		backup : function ()
		{
			if (!GIWIK._status_bits_info_factory){GIWIK._status_bits_info_factory = [];}

			for (var i=0; i<GIWIK.ui_status_bit_depth*window[system]._ui_status.length; i++)
			{
				if (GIWIK._status_bits_info[i])
				{
					GIWIK._status_bits_info_factory[i] = [];

					for (var param in GIWIK._status_bits_info[i])
					{
						GIWIK._status_bits_info_factory[i][param] = GIWIK._status_bits_info[i][param];
					}
				}
			}
		},

		// Met à jour le tableau des status (notamment utile avec la lecture du cookie permanent) [numéro du bit à modifier, paramètre du bit à modifier, nouvelle valeur]
		update : function (bit, _info)
		{
			for (var param in _info)
			{
				var value = _info[param];

				// Si le nouveau code est -1, retour au paramètre usine
				value = (value === -1) ? GIWIK._status_bits_info_factory[bit][param] : value;

				// S'il y a lieu, modification de la valeur
				if (GIWIK._status_bits_info[bit][param] !== value)
				{
					GIWIK._status_bits_info[bit][param] = value;

					// Indique au parseur des bits de statut (dans GIWIK.analyzeResponseText) que le tableau des bits de statut a changé et que ça vaut le coup d'analyser les bits
					GIWIK.status_bits_info_modified = true;
				}
			}
		}
	};

	// Initialisation du nombre par défaut de bits dans chaque entier de statut
	GIWIK.initUIStatusBitDepth = function ()
	{
		// Valeur max gérée par JavaScript
		var max_value = 32;

		// La si variable n'est pas définie, on la fixe au max
		if (typeof GIWIK.ui_status_bit_depth != 'number')
		{
			GIWIK.ui_status_bit_depth = max_value;
		}
		// Si elle est trop grande
		else if (GIWIK.ui_status_bit_depth > max_value)
		{
			alert("Error : GIWIK.ui_status_bit_depth is set at "+GIWIK.ui_status_bit_depth+" while max value is "+max_value);
		}
	};

	// Retourne un tableau de bits à partir d'un entier sur n bits
	GIWIK.intToBitsArray = function (value, bit_depth)
	{
			if (typeof bit_depth != 'number') {var bit_depth = 32;}

			var _bits = [];

			for (var i=0; i<bit_depth; i++)
			{
				_bits[i] = ((value >> i) & 0x1);
			}

			return _bits;
	};


// OBJETS DE SAISIE ET DE NAVIGATION ————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————

	// Liste des classes devant se voir affecter les méthodes communes définies dans GIWIK._input_methods
	GIWIK._input_classes =
	{
		'all' : ['Button','Menu','Chevron','Led','Switch','Input_int','Input_text','Input_select','Input_radio','Input_checkbox','Input_file','Input_latlong','User_msg','Mask'],
		'int_and_text' : ['Input_int','Input_text']
	}

	// Méthodes génériques des objets de saisie (si la méthode n'est pas déjà définie dans la classe cible)
	GIWIK._input_methods =
	{
		'all' :
		{
			getValue : function ()
			{
				return this.value;
			},

			// Action sur l'évènement "onchange"
			setAction : function (action, only_when_init_done)
			{
				if (!in_array(typeof action,['function','string']) || (this.action && action.toString() === this.action.toString()))
				{
					return;
				}

				this.action = action;
				this.action_only_when_init_done = (only_when_init_done) ? true : false;

				if (typeof this.__setActionSpecific == 'function')
				{
					this.__setActionSpecific();
				}
			},

			// Retourne l'action définie sur l'évènement "change"
			getAction : function ()
			{
				return this.action;
			},

			// Ajoute une action à la suite de l'action définie sur l'évènement "change" [where=before/after]
			addAction : function (action, position)
			{
				// Si l'action passée n'est pas valable, on sort
				if (!(action && in_array(typeof action,['function','string'])))
				{
					return;
				}

				// Si l'action existante n'est pas définie ou nulle, il s'agit d'un setAction
				if (!this.getAction())
				{
					this.setAction(action);
					return;
				}

				if (!in_array(position, ['before','after']))
				{
					var position = 'after';
				}

				var action_old = this.getAction(),
					action_new = "",

					regexp1 = /^function\s*\(\)\s*\{\s*/,
					regexp2 = /\}$/;


				if (typeof action == 'function')
				{
					action = action.toString().replace(regexp1,"").replace(regexp2,"");
				}

				if (typeof action_old == 'function')
				{
					action_old = action_old.toString().replace(regexp1,"").replace(regexp2,"");
				}

				switch (position)
				{
					case 'before': action_new = action + action_old; break;
					case 'after' : action_new = action_old + action; break;
				}

				if (typeof action_old == 'string')
				{
					this.setAction(action_new);
				}
				else if (typeof action_old == 'function')
				{
					eval(this.self+".setAction(function () {"+action_new+"});");
				}

				//alert(this.getAction());
			},

			// Exécute sur le champ l'action définie sur l'évènement "change"
			execAction : function (no_action)
			{
				// Si l'action ne doit pas être exécutée avant la fin de la phase d'init, on sort
				if (no_action || (this.action_only_when_init_done && !HEADING.init.isdone))
				{
					return;
				}

				var action = this.getAction();

				switch (typeof action)
				{
					case 'string'   : return eval(action); break;
					case 'function' : return action();     break;
				}
			},

			// Action exécutée AVANT setValue(), permet notamment la mise en place de gardes-fou
			setActionBefore : function (action, only_when_init_done)
			{
				if (!in_array(typeof action,['function','string']) || (this.action && action.toString() === this.action.toString()))
				{
					return;
				}

				this.action_before = action;
				this.action_before_only_when_init_done = (only_when_init_done) ? true : false;

				if (typeof this.__setActionBeforeSpecific == 'function')
				{
					this.__setActionBeforeSpecific();
				}
			},

			// Retourne l'action définie avant tout setValue
			getActionBefore : function ()
			{
				return this.action_before;
			},

			// Exécute l'action définie avant tout setValue
			execActionBefore : function (no_action)
			{
				// Si l'action ne doit pas être exécutée avant la fin de la phase d'init, on sort
				if (no_action || (this.action_before_only_when_init_done && !HEADING.init.isdone))
				{
					return;
				}

				var action = this.getActionBefore();

				switch (typeof action)
				{
					case 'string'   : return eval(action); break;
					case 'function' : return action();     break;
				}
			},

			setActionOnFocus : function (action, only_when_init_done)
			{
				if (!in_array(typeof action,['function','string']) || (this.action_onclick && action.toString() === this.action_onclick.toString()))
				{
					return;
				}

				this.action_onclick = action;
				this.action_onclick_only_when_init_done = (only_when_init_done) ? true : false;

				if (typeof this.__setActionOnFocusSpecific == 'function')
				{
					this.__setActionOnFocusSpecific();
				}
			},

			getActionOnFocus : function ()
			{
				return this.action_onclick;
			},

			// Exécute sur le champ l'action définie sur l'évènement "click"
			execActionOnFocus : function (no_action)
			{
				// Si l'action ne doit pas être exécutée avant la fin de la phase d'init, on sort
				if (no_action || (this.action_onclick_only_when_init_done && !HEADING.init.isdone))
				{
					return;
				}

				var action = this.getActionOnFocus();

				switch (typeof action)
				{
					case 'string'   : eval(action); break;
					case 'function' : action();     break;
				}
			},

			setActionOnBlur : function (action, only_when_init_done)
			{
				if (!in_array(typeof action,['function','string']) || (this.action_onblur && action.toString() === this.action_onblur.toString()))
				{
					return;
				}

				this.action_onblur = action;
				this.action_onblur_only_when_init_done = (only_when_init_done) ? true : false;

				if (typeof this.__setActionOnBlurSpecific == 'function')
				{
					this.__setActionOnBlurSpecific();
				}
			},

			getActionOnBlur : function ()
			{
				return this.action_onblur;
			},

			// Exécute sur le champ l'action définie sur l'évènement "blur"
			execActionOnBlur : function (no_action)
			{
				// Si l'action ne doit pas être exécutée avant la fin de la phase d'init, on sort
				if (no_action || (this.action_onblur_only_when_init_done && !HEADING.init.isdone))
				{
					return;
				}

				var action = this.getActionOnBlur();

				switch (typeof action)
				{
					case 'string'   : eval(action); break;
					case 'function' : action();     break;
				}
			},

			hide : function (_options)
			{
				if (typeof _options != 'object') {var _options = {};}

				if (!this.element_path)
				{
					console.error(this.self+'.hide : DOM element "'+this.idelem+'" is missing');
					return false;
				}

				if (_options.hidden)
				{
					this.element_path.style.visibility = 'hidden';
				}
				else
				{
					if ((!HEADING.init.isdone && _options.animation !== true) || _options.animation === false || GIWIK._context.ie < 9)
					{
						this.element_path.style.display = 'none';
					}
					else
					{
						$('#'+this.idelem)[($('#'+this.idelem).is(':visible')) ? 'slideUp' : 'hide']();
					}
				}

				this.is_visible = false;

				if (typeof this.__hideSpecific == 'function')
				{
					this.__hideSpecific(_options);
				}
			},

			show : function (_options)
			{
				if (typeof _options != 'object') {var _options = {};}

				if (!this.element_path)
				{
					console.error(this.self+'.show : DOM element "'+this.idelem+'" is missing');
					return false;
				}

				this.element_path.style.visibility = 'visible';

				if ((!HEADING.init.isdone && _options.animation !== true) || _options.animation === false || GIWIK._context.ie < 9)
				{
					this.element_path.style.display = 'block';
				}
				else
				{
					$('#'+this.idelem).slideDown();
				}

				this.is_visible = true;

				if (typeof this.__showSpecific == 'function')
				{
					this.__showSpecific(_options);
				}
			},

			isVisible : function ()
			{
				// Utilisation de is_visible et pas des styles pour permettre de tester la visibilité d'un objet
				// juste après un "show" ou un "hide" qui prennent du temps dans le cas d'une animation
				return this.is_visible;
			},

			enable : function ()
			{
				if (this.state === 1)
				{
					return;
				}

				this.state = 1;

				// if (this.inputid/* && typeof document.getElementById(this.inputid).disabled != 'undefined'*/)
				// {
				// 	// Les champs de formulaires (file, text, select, checkbox etc.) boguent si on utilise la propriété JS ou l'attribut "disabled" ne serait-ce qu'une fois
				// 	//    -> perte du nom de fichier dans les données envoyées
				// 	// A FAIRE : gérer l'état disable des Input_radio et Input_checkbox sans l'attribut "disabled"
				// 	if (in_array(this.constructor, [Input_file, Input_int, Input_text, Input_select],true))
				// 	{
				// 		// if (typeof document.getElementById(this.inputid).readOnly != 'undefined')
				// 		// {
				// 			document.getElementById(this.inputid).readOnly = false;
				// 		// }
				// 	}
				// 	else
				// 	{
				//		if (typeof document.getElementById(this.inputid).disabled != 'undefined')
				//		{
				//			document.getElementById(this.inputid).disabled = false;
				//		}
				//	}
				// }

				if (this.inputid && typeof document.getElementById(this.inputid).disabled != 'undefined')
				{
					// Les input file boguent si on joue avec cette propriété JS ou avec l'attribut disabled via setAttribute('disabled','disabled')
					// -> perte du nom de fichier dans les headers envoyés
					if (this.constructor !== Input_file)
					{
						document.getElementById(this.inputid).disabled = false;
					}
				}


				$('#'+this.idelem).css('opacity',1);

				if (typeof this.__enableSpecific == 'function')
				{
					this.__enableSpecific();
				}
			},

			disable : function ()
			{
				if (this.state === 0)
				{
					return;
				}

				this.state = 0;

				if (this.inputid && typeof document.getElementById(this.inputid).disabled != 'undefined')
				{
					// Les input file boguent si on joue avec cette propriété JS ou avec l'attribut disabled via removeAttribute('disabled')
					// -> perte du nom de fichier dans les headers envoyés
					if (this.constructor !== Input_file)
					{
						document.getElementById(this.inputid).disabled = true;
					}
				}


				// if (this.inputid)
				// {
				//	Les champs de formulaires (file, text, select, checkbox etc.) boguent si on utilise la propriété JS ou l'attribut "disabled" ne serait-ce qu'une fois
				//	   -> perte du nom de fichier dans les données envoyées
				//	A FAIRE : gérer l'état disable des Input_radio et Input_checkbox sans l'attribut "disabled"
				//	if (in_array(this.constructor, [Input_file, Input_int, Input_text, Input_select],true))
				//	{
				//		// if (typeof document.getElementById(this.inputid).readOnly != 'undefined')
				//		// {
				//			if (this.inputid === 'select_pulsein_input_')
				//			{
				//				console.log(this.inputid, document.getElementById(this.inputid).readOnly)
				//			}
				//			setInterval("document.getElementById('"+this.inputid+"').readOnly = true;",100);
				//			if (this.inputid === 'select_pulsein_input_')
				//			{
				//				console.log(this.inputid, document.getElementById(this.inputid).readOnly)
				//			}
				//		// }
				//	}
				//	else
				//	{
				//		if (typeof document.getElementById(this.inputid).disabled != 'undefined')
				//		{
				//			document.getElementById(this.inputid).disabled = true;
				//		}
				//	}
				// }

				$('#'+this.idelem).css('opacity',0.5);
				$('#'+this.labelid+',#'+this.inputid).css('cursor','default');

				// background pour les navigateurs anciens (IE<9) qui boguent avec la transparence
				if (GIWIK._context.ie < 9)
				{
					if (this.constructor !== Button)
					{
						$("#"+this.idelem).css({'background':GIWIK.css.color_background});
					}
				}

				if (typeof this.__disableSpecific == 'function')
				{
					this.__disableSpecific();
				}
			},

			isEnabled : function ()
			{
				return this.state;
			},

			// OBSOLÈTE, remplacée par "enable"
			activate : function ()
			{
				alert('*** GIWIK error ***\n'+this.self+'.activate no longer exists, use '+this.self+'.enable instead');
			},

			// OBSOLÈTE, remplacée par "disable"
			deactivate : function ()
			{
				alert('*** GIWIK error ***\n'+this.self+'.deactivate no longer exists, use '+this.self+'.disable instead');
			},

			// A IMPLÉMENTER DANS TOUTES LES CLASSES
			setStatus : function (status)
			{
				if (!in_array(status,[0,1,2,3],true))
				{
					var status = 1;
				}

				if (status === this.status)
				{
					return;
				}

				$('#'+this.labelid+',#'+this.inputid+',#'+this.unitid).css('color',GIWIK.css['color_'+status]);

				if (typeof this.__setStatusSpecific == 'function')
				{
					this.__setStatusSpecific(status);
				}

				this.status = status;
			},

			getStatus : function ()
			{
				return this.status;
			},


			// Définition d'un titre (== attribut HTML title pour étiquette au survol de la souris)
			setTitle : function (title)
			{
				if (typeof title == 'string')
				{
					this.title = title;
					this.element_path.title = this.title;
				}
			},

			getTitle : function ()
			{
				return this.title;
			},

			setLabel : function (label)
			{
				if (this.label_path && typeof label == 'string' && label !== this.label)
				{
					this.label = label;
					this.label_path.innerHTML = this.label;
				}
			},

			getLabel : function (label)
			{
				return this.label;
			},

			setUnit : function (unit)
			{
				if (this.unit_path && unit !== this.unit)
				{
					// Gestion de la visibilité de l'élément parent en fonction de la présence d'une unité (tr ou td selon le mode d'affichage)
					$('#'+this.unitid).parents((this.mode == 'linear') ? 'td' : 'tr').eq(0).css('display',(!unit) ? 'none' : '');

					this.unit = unit;
					this.unit_path.innerHTML = this.unit;
				}
			},

			getUnit : function (unit)
			{
				return this.unit;
			},

			__isSymboleKey : function (key_code)
			{
				// S'il d'agit d'une touche correspondant à un symbole (exit les touches : "entrée haut bas gauche droite tab capslock maj ctrl alt pause windows menu page-pré page-suiv fin début f1->f12 command (mac)")
				if (typeof key_code != 'undefined' && !in_array(key_code,[13,38,40,37,39,9,20,16,17,18,19,91,93,33,34,35,36,112,113,114,115,116,117,118,119,120,121,122,123,224]))
				{
					return true;
				}
				else
				{
					return false;
				}
			},

			// Renvoie la variable "window.settings_modified" à true (lors d'un clic sur l'un des items du menu) si la fonction a été activée par this.onchange_setmod
			__settingsModified : function (event)
			{
				if (event && HEADING.init.isdone && this.onchange_setmod === true)
				{
					window.settings_modified = true;
				}
			},

			__doOnKeyUp : function (evt)
			{
				// Aucune action si le controle est désactivé
				if (this.state !== 1)
				{
					return;
				}

				var key_code = (typeof evt.keyCode == 'number') ? evt.keyCode : (window.event ? window.event.keyCode : null);	// Plan B pour IE

				if (typeof this.__doOnKeyUpSpecific == 'function')
				{
					this.__doOnKeyUpSpecific(key_code);
				}
			},

			__doOnKeyDown : function (evt)
			{
				// Aucune action si le controle est désactivé
				if (this.state !== 1)
				{
					return;
				}

				var key_code = (typeof evt.keyCode == 'number') ? evt.keyCode : (window.event ? window.event.keyCode : null);	// Plan B pour IE

				if (typeof this.__doOnKeyDownSpecific == 'function')
				{
					this.__doOnKeyDownSpecific(key_code);
				}
			},
			__setAutoActivity : function (auto_activity)
			{
				if (auto_activity === true && !in_array(this.self, HEADING._heading_inputs))
				{
					HEADING._heading_inputs.push(this.self);
				}
			}
		},
		// Spécifique Input_int et Input_text
		'int_and_text':
		{
			__enableSpecific : function ()
			{
				if (!this.readonly)
				{
					$('#'+this.inputid).css('cursor','text');
				}
			},

			__disableSpecific : function ()
			{
				$('#'+this.inputid).css('cursor','default');
			},

			__doOnKeyUpSpecific : function (key_code)
			{
				// Si la touche est un symbole ou la touche "entrée", on vérifie la valeur
				if (this.__isSymboleKey(key_code) || key_code == 13)
				{
					this.setValue(this.input_path.value, false, 'onkeyup', key_code);
				}
			}
		}
	};

	// Classe Chevron
	function Chevron (self)
	{
		this.idelem;				// Id de l'element dans lequel le bouton est instancie
		this.element_path;			// chemin DOM de cet element
		this.self = self;			// nom de l'instance
		this.size;					// type du bouton (grand ou petit)
		this.state;					// Definit l'etat du menu :	0  -> inactif,
									//							1  -> actif
		this.status;				// Definit le statut du chevron :	0  -> inactif,
									//									1  -> actif + fonctionnement nominal
									//									2  -> actif + alerte legere
									//									3  -> actif + erreur
									//									10 -> attente
		this.action;				// Action lors d'un clic
		this.title;					// Titre de l'élément (s'affiche lors du survol)
		this.width_full = 122;		// largeur full du bouton
		this.height_full = 122;		// hauteur full du bouton
		this.width_small = 100;		// largeur reduite
		this.height_small = 100;	// hauteur reduite
		this.width_mini = 74;		// largeur mini (pages autres que "control")
		this.height_mini = 74;		// largeur mini (pages autres que "control")

		this.width  = this['width_'+GIWIK.window_size];	// largeur par defaut
		this.height = this['height_'+GIWIK.window_size];	// hauteur par defaut

		this.img_suffix;				// Permet d'ajouter dynamiquement un suffixe au lien de l'image de fond en fonction de l'état du Chevron

		this.bg_status10;				// couleur courante de l'état 10
		this.timeout_status10;			// contient le timer de l'état 10
		//.......................................................................................................................................................


		this.construct = function (id_element)
		{
			//......................................................
			this.idelem = id_element;
			this.element_path  = document.getElementById(this.idelem);
			//......................................................

			$('#'+this.idelem).html('<img src="'+GIWIK.directories.img+'/chevron'+GIWIK.css.night_suffix+'.png">');

			var title, action;

			if (HEADING.name == 'control')
			{
				title = MSG(['chevron','control_mouseover']);
				action = "HEADING.displayDetailedStatus('switch');";
			}
			else if (HEADING.is_external_popup)
			{
				title = MSG(['chevron','extpopup_mouseover']);
				action = this.self+".__displayMainWindow();";
			}
			else
			{
				title = MSG(['chevron','other_mouseover']);
				action = "STORAGE.setPermanent('popupstatus', 'visible');"+this.self+".__displayMainWindow();";
			}

			// Affectation de l'action
			eval
			(
				"this.element_path.onclick = function ()"
				+"{"
					+"if("+this.self+".state === 1 && "+this.self+".execActionBefore() !== false)"
					+"{"
						+this.self+".execAction();"
					+"}"
				+"};"
			);

			this.state = 1; // le chevron ne peut pas être désactivé

			this.setAction(action);
			this.setTitle(title);
			this.resize(GIWIK.maincontrol_size);
			this.setStatus(1);
			this.show();
		};

		this.resize = function (newsize)
		{
			if (newsize == 'medium')
			{
				newsize = 'full';
			}

			if (newsize != this.size)
			{
				this.size = newsize;

				switch (this.size)
				{
					case 'small':
						this.width = this.width_small;
						this.height = this.height_small;
						break;
					case 'mini':
						this.width = this.width_mini;
						this.height = this.height_mini;
						break;
					default:
						this.width = this.width_full;
						this.height = this.height_full;
						break;
				}

				$('#'+this.idelem).css({
					'width': this.width,
					'height': this.height,
					'border-radius': this.width/2
				});

				$('#'+this.idelem+' img').css({
					'width': this.width,
					'height': this.height
				});
			}
		};

		this.setStatus = function (newstatus, force)
		{
			// Pendant l'update d'un firmware ou son upload vers l'embarqué, l'état est 10 (chevron en attente)
			if (HEADING.firmware_updating || HEADING.sending_file)
			{
				newstatus = 10;
			}

			// Si le statut n'est pas forcé, vérification que la nouvelle valeur n'est pas en conflit avec la dernière analyse des statuts (ui_statuts)
			if (!force && typeof GIWIK.error_action == 'boolean' && typeof GIWIK.warning_action == 'boolean') // SSD n'est pas concernée
			{
				// Si un ok est demandé alors qu'un statut plus grave (2 ou 3) ou qu'un shutdown est déjà en place, on ignore le nouveau statut
				// Si un warning est demandé alors qu'une alerte (plus grave) ou qu'un shutdown est déjà en place, on ignore le nouveau statut
				// Si un error est demandé alors qu'un shutdown est déjà en place, on ignore le nouveau statut
				if ((newstatus === 1 && (GIWIK.shutdown_action || GIWIK.error_action || GIWIK.warning_action)) ||
					(newstatus === 2 && (GIWIK.shutdown_action || GIWIK.error_action)) ||
					(newstatus === 3 && (GIWIK.shutdown_action)))
				{
					return;
				}
			}

			// Si l'état a changé
			if (this.status != newstatus)
			{
				// Si l'état précédent était l'état d'attente, on supprime le timer
				if (this.status == 10)
				{
					clearInterval(this.timeout_status10);
				}

				this.status = newstatus;

				// Cas particulier de l'état d'attente qui nécessite de swapper 2 background
				if (this.status == 10)
				{
					this.bg_status10 = 1;

					var bg_swap = this.self+".bg_status10 = ("+this.self+".bg_status10 === 1) ? 0 : 1;$('#"+this.idelem+"').css('background-color',GIWIK.css['color_'+"+this.self+".bg_status10]);";

					this.timeout_status10 = setInterval(bg_swap,500);

					bg_swap = null;
				}
				else
				{
					//this.element_path.style.background = 'no-repeat url('+GIWIK.directories.img+'/chevron_'+this.size+this.status+this.img_suffix+'.png)';
					$('#'+this.idelem).css('background-color', GIWIK.css['color_'+this.status]);
				}
				this.show();
			}
		};

		this.getStatus = function ()
		{
			return this.status;
		};

		this.setValue = this.setStatus;

		this.getValue = this.getStatus;

		this.enable = function () {};

		this.disable = function () {};

		this.__setActionSpecific = function ()
		{
			// Type de curseur en fonction de l'existence d'une action
			this.element_path.style.cursor = (typeof this.action != 'undefined') ? 'pointer' : 'default';
		};

		this.__displayMainWindow = function ()
		{
			// Dans le cas d'un popup externe
			if (HEADING.is_external_popup)
			{
				// Si la fenêtre principale (qui a servi à ouvrir le popup) est ouverte
				if (window.opener && window.opener.closed == false)
				{
					// On met la fenêtre principale au premier plan
					window.opener.focus();

					// Si elle ne se trouve pas sur la page "control", on y va !
					if (window.opener.document.location.href.indexOf("/control/") == -1)
					{
						// Ecriture dans le cookie pour que les statuts détaillés s'ouvrent avec la page "control"
						STORAGE.setPermanent('popupstatus', 'visible');

						window.opener.document.location.href = '../control/';
					}
					// Sinon, on ouvre les statuts détaillés
					else
					{
						/*if (System_state)
						{
							// POUR GAPS ET RAMSES : TEST A COMPLETER
							// Si au moins une alerte concerne un module système (et pas un éventuel transpondeur)
							for (var j=0; j<GIWIK._ds_sensors.length; j++)
							{
								if (_new_sensors_status[j] == 3)
								{
									window.opener.HEADING.displayDetailedStatus('open');
								}
							}
						}
						else
						{*/
							window.opener.HEADING.displayDetailedStatus('open');
						//}
					}
				}
				// Sinon, on rouvre l'IHM principale à la page "control"
				else
				{
					// Ecriture dans le cookie pour que les statuts détaillés s'ouvrent avec la page "control"
					STORAGE.setPermanent('popupstatus', 'visible');

					GIWIK.window.open('../control/', GIWIK.system_name, 900, 600, 'auto', 'auto', 'location=1, menubar=1, toolbar=1, resize=1, scrollbars=1');
				}
			}
			else
			{
				window.focus();

				// Retour sur la page "control" si on n'y est pas déjà 
				if (HEADING.name != 'control')
				{
					window.document.location.href = '../control/';
				}
			}

			// récupération de la position du popup expert view
			var top_pos  = (window.screenY) ? window.screenY : window.screenTop;	// Plan B pour IE
			var left_pos = (window.screenX) ? window.screenX : window.screenLeft;	// Plan B pour IE

			//alert(top_pos+' '+left_pos);
		};
	};

	// Classe Led
	function Led (self)
	{
		this.idelem;				// Id de l'element dans lequel le bouton est instancie
		this.element_path;			// chemin DOM de cet element
		this.self = self;			// nom de l'instance
		this.size;					// type du bouton (grand ou petit)
		this.state;					// Definit l'etat du menu :	0  -> inactif,
									//							1  -> actif
		this.status;				// Definit le statut du voyant :	0  -> inactif,
									//									1  -> actif + fonctionnement nominal
									//									2  -> actif + alerte legere
									//									3  -> actif + erreur
									//									10 -> attente
		this.action;				// Action lors d'un clic

		this.width_full = 38;		// largeur full du voyant
		this.height_full = 38;		// hauteur full du voyant
		this.width_medium = 30;		// largeur medium
		this.height_medium = 30;	// hauteur medium
		this.width_small = 25;		// largeur small
		this.height_small = 25;		// hauteur small
		this.width_mini = 18;		// largeur mini (pages autres que "control")
		this.height_mini = 18;		// largeur mini (pages autres que "control")

		this.width;					// largeur courante du voyant
		this.height;				// hauteur courante du voyant
		this.margin;				// spécifie des marges pour le module (0px 0px 0px 0px)
		this.margin_left;			// spécifie une marge gauche

		this.img_suffix;				// Permet d'ajouter dynamiquement un suffixe au lien de l'image de fond en fonction de l'état du Chevron
		//.......................................................................................................................................................


		this.construct = function (id_element, size)
		{
			//......................................................
			this.idelem = id_element;
			this.element_path  = document.getElementById(this.idelem);
			//......................................................

			if (!this.element_path)
			{
				console.error(this.self+'.construct : DOM element "'+this.idelem+'" is missing');
				return false;
			}

			$('#'+this.idelem).html('<img src="'+GIWIK.directories.img+'/led'+GIWIK.css.night_suffix+'.png" />');

			// Affectation de l'action
			eval
			(
				"this.element_path.onclick = function ()"
				+"{"
					+"if("+this.self+".state === 1 && "+this.self+".execActionBefore() !== false)"
					+"{"
						+this.self+".execAction();"
					+"}"
				+"};"
			);

			this.state = 1; // le chevron ne peut pas être désactivé

			this.resize((size) ? size : 'full');
			this.setStatus(1);
			this.show();
		};

		this.resize = function (newsize)
		{
			// if (newsize == 'medium')
			// {
			// 	newsize = 'full';
			// }

			if (newsize != this.size)
			{
				this.size = newsize;

				switch (this.size)
				{
					case 'medium':
						this.width  = this.width_medium;
						this.height = this.height_medium;
						break;
					case 'small':
						this.width  = this.width_small;
						this.height = this.height_small;
						break;
					case 'mini':
						this.width  = this.width_mini;
						this.height = this.height_mini;
						break;
					case 'full':
					default:
						this.width  = this.width_full;
						this.height = this.height_full;
						break;
				}

				$('#'+this.idelem).css({
					'width': this.width,
					'height': this.height,
					'margin': '0 auto 0 auto',
					'border-radius': this.width/2,
					'overflow': 'hidden'
					// ,'box-shadow': '2px 2px 4px rgba(0,0,0,0.3)' flat design
				});

				$('#'+this.idelem+' img').css({
					'width': this.width,
					'height': this.height,
					'border-radius': this.width/2 // pour Opera
				});

				// Si une marge a été définie
				if (typeof this.margin != 'undefined')
				{
					this.element_path.style.margin = this.margin;
				}
				// Si une marge gauche a été définie
				if (typeof this.margin_left != 'undefined')
				{
					this.element_path.style.marginLeft = this.margin_left+'px';
				}
			}
		};

		this.setStatus = function (newstatus)
		{
			// Pendant l'update d'un firmware ou son upload vers l'embarqué, l'état est 10 (chevron en attente)
			if (HEADING.firmware_updating || HEADING.sending_file)
			{
				newstatus = 10;
			}

			// Si l'état a changé
			if (this.status != newstatus)
			{
				// Si l'état précédent était l'état d'attente, on supprime le timer
				if (this.status == 10){clearInterval(this.timeout_status10);}

				this.status = newstatus;

				// Cas particulier de l'état d'attente qui nécessite de swapper 2 background
				if (this.status == 10)
				{
					//var bg_swap = this.self+".element_path.style.background-color = "+this.self+".element_path.style.background.match(/0\.png/gi) ? 'no-repeat url("+GIWIK.directories.img+"/chevron_"+this.size+"1"+GIWIK.css.color_suffix+".png)' : 'no-repeat url("+GIWIK.directories.img+"/chevron_"+this.size+"0.png)'";
					var bg_swap = "$('#"+this.idelem+"').css('background-color',$('#"+this.idelem+"').css('background-color') == GIWIK.css.color_0 ? GIWIK.css.color_1 : GIWIK.css.color_0);";

					this.timeout_status10 = setInterval(bg_swap,500);

					bg_swap = null;
				}
				else
				{
					//this.element_path.style.background = 'no-repeat url('+GIWIK.directories.img+'/chevron_'+this.size+this.status+this.img_suffix+'.png)';
					$('#'+this.idelem).css('background-color', GIWIK.css['color_'+this.status]);
				}
				this.show();
			}
		};

		this.getStatus = function ()
		{
			return this.status;
		};

		this.setValue = this.setStatus;

		this.getValue = this.getStatus;

		this.enable = function () {};

		this.disable = function () {};

		// Action complémentaire spécifique cette classe
		this.__setActionSpecific = function ()
		{
			// Type de curseur en fonction de l'existence d'une action
			this.element_path.style.cursor = (typeof this.action != 'undefined') ? 'pointer' : 'default';
		};
	};

	// Classe Button
	/*
	function Button (self, auto_activity)
	{
		this.idelem;					// Id de l'element dans lequel le bouton est instancie
		this.element_path;				// chemin DOM de cet element
		this.self = self; 				// nom de l'instance
		this.type;						// type du bouton
		this.status;					// image du background quand le bouton est down (fonction de this.type)
		this.color_up = '#333333';		// couleur de la police pour l'état up
		this.label = '';				// label du bouton
		this.size = 'small';			// taille de l'objet (full, small, smaller ou mini) ou auto (taille ajustée dynamiquement en fct de la largeur de la fenêtre)
		this.action = false;
		this.state;						// Definit l'etat du bouton :	1 -> clicable, 0 -> inactif
		this.visibility;				// Difinit si le bouton est visible ou non
		this.width;						// Width en fonction de la taille (full, small, smaller, mini)
		this.height;					// Height	"	"	"	"	"	"	"	"	"	"	"	"

		this.auto_enable = (auto_activity) ? true : false;	// Gestion automatique de la méthode "enable" via HEADING.setSettingsActivity() si "auto_activity" vaut "true"

		this.__setAutoActivity(auto_activity);
		//...................................................................................................................................................


		this.construct = function (id_element, label, size, status)
		{
			//......................................................
			this.idelem = id_element;
			this.label = label;
			this.element_path  = document.getElementById(this.idelem);
			//......................................................

			if (status == 'orange') // pour compaticilité
			{
				var status = 2;
			}
			else if (status == 'red')	// pour compaticilité
			{
				var status = 3;
			}

			this.element_path.innerHTML = '<img src="'+GIWIK.directories.img+'/button'+GIWIK.css.night_suffix+'.png"/><table><tr><td>'+this.label+'</td></tr></table>';

			this.margin = (typeof this.margin != 'undefined') ? this.margin : '0 0 0 0';

			this.element_path.style.margin = this.margin;

			this.label_path = this.element_path.getElementsByTagName('td')[0];

			this.image_path = this.element_path.getElementsByTagName('img')[0];

			eval("this.element_path.onclick     = function () {if ("+this.self+".state === 1 && "+this.self+".execActionBefore() !== false) {"+this.self+".execAction();}};");
			eval("this.element_path.onmouseover = function () {if ("+this.self+".state === 1){"+this.self+".__mouseOver();}};");
			eval("this.element_path.onmouseout  = function () {if ("+this.self+".state === 1){"+this.self+".__mouseOut();}};");

			$('#'+this.idelem+' td').css({
				'text-align': 'center',
				'vertical-align': 'middle',
				//'user-select': 'none',  // pas encore implémenté, commenté pour éviter une erreur dans la console
				'-moz-user-select': 'none',
				'-khtml-user-select': 'none',
				'-o-user-select': 'none',
				'-webkit-user-select': 'none',
				'-ms-user-select': 'none'
			});

			this.setStatus(status);

			this.resize(size);
			this.disable();
			this.show();
		};

		this.setValue = function (value)
		{
			this.setLabel(value);
		};

		this.getValue = function ()
		{
			this.getLabel();
		};

		this.resize = function (size)
		{
			this.size = in_array(size,['full','medium','default','small','mini']) ? size : 'default';

			switch (this.size)
			{
				case 'full':
				case 'medium': 	// Seulement pour GIWIK en interne
					this.width = 110;
					this.height = 106;
					this.font = 'normal 12px Arial';
					break;
				case 'default':
					this.width = 95;
					this.height = 92;
					this.font = 'normal 11px Arial';
					break;
				case 'small':
					this.width = 81;
					this.height = 78;
					this.font = 'normal 11px Arial';
					break;
				case 'mini':
					this.width = 69;
					this.height = 66;
					this.font = 'normal 10px/11px Arial';
					break;
			}

			$('#'+this.idelem+',#'+this.idelem+' img,#'+this.idelem+' table').css({
				'width':this.width,
				'height':this.height,
				'vertical-align':'top'
			});

			$('#'+this.idelem+' table').css({
				'margin-top':-this.height,
				'font':this.font
			});

			this.__displayButtonUp();
		};

		this.hide = function (_options)
		{
			if (typeof _options != 'object')
			{
				var _options = {};
			}

			if (_options.hidden) {this.element_path.style.visibility = 'hidden';}
			else				 {this.element_path.style.display = 'none';}
		};

		this.show = function (_options)
		{
			if (typeof _options != 'object')
			{
				var _options = {};
			}

			this.element_path.style.visibility = 'visible';
			this.element_path.style.display = 'table';
		};

		this.__enableSpecific = function (action)
		{
			this.__mouseOut();

			$('#'+this.idelem).css
			({
				'opacity' : (GIWIK.css.night_mode) ? 0.85 : 1,	// (Si mode nuit, on met une légère transparence pour atténuer le blanc grâce au fond noir)
				'cursor'  : 'pointer'
			});
		};

		this.__disableSpecific = function ()
		{
			this.__mouseOut();

			$('#'+this.idelem).css
			({
				'opacity' : (GIWIK.css.night_mode) ? 0.35 : 0.35,
				'cursor'  : 'default'
			});
		};

		this.__setStatusSpecific = function (status)
		{
			this.__mouseOut();

			$('#'+this.idelem).css('background-color', GIWIK.css['color_'+status]);
		};

		this.__mouseOver = function ()
		{
			this.__displayButtonDown();
			this.element_path.style.color =  GIWIK.css['color_'+this.status];
		};

		this.__mouseOut = function ()
		{
			this.__displayButtonUp();
			this.element_path.style.color = this.color_up;
		};

		this.__displayButtonUp = function ()
		{
			this.element_path.style.background = 'transparent';
			this.image_path.src = GIWIK.directories.img+"/button"+GIWIK.css.night_suffix+".png";
		};

		this.__displayButtonDown = function ()
		{
			this.element_path.style.background = GIWIK.css['color_'+this.status];
			this.image_path.src = GIWIK.directories.img+"/buttoni"+GIWIK.css.night_suffix+".png";
		};
	};
*/
// Classe Button
	function Button (self, auto_activity, _options)
	{
		this._options = _options || {}, // options
		this._options.type = this._options.type || 'default';	// version ronde bombée par défaut, "flat" optionnellement


		this.idelem;					// Id de l'element dans lequel le bouton est instancie
		this.element_path;				// chemin DOM de cet element
		this.self = self; 				// nom de l'instance
		this.type;						// type du bouton
		this.status;					// image du background quand le bouton est down (fonction de this.type)
		this.color_up = '#333333';		// couleur de la police pour l'état up
		this.label = '';				// label du bouton
		this.size = 'small';			// taille de l'objet (full, small, smaller ou mini) ou auto (taille ajustée dynamiquement en fct de la largeur de la fenêtre)
		this.action = false;
		this.state;						// Definit l'etat du bouton :	1 -> clicable, 0 -> inactif
		this.visibility;				// Difinit si le bouton est visible ou non
		this.width;						// Width en fonction de la taille (full, small, smaller, mini)
		this.height;					// Height	"	"	"	"	"	"	"	"	"	"	"	"

		this.auto_enable = (auto_activity) ? true : false;	// Gestion automatique de la méthode "enable" via HEADING.setSettingsActivity() si "auto_activity" vaut "true"

		this.__setAutoActivity(auto_activity);
		//...................................................................................................................................................

		this.construct = function (id_element, label, size, status)
		{
			//......................................................
			this.idelem = id_element;
			this.label = label;
			this.element_path  = document.getElementById(this.idelem);
			//......................................................

			if (status == 'orange') // pour compaticilité
			{
				var status = 2;
			}
			else if (status == 'red')	// pour compaticilité
			{
				var status = 3;
			}

			if (this._options.type === 'default')
			{
				this.element_path.innerHTML = '<img src="'+GIWIK.directories.img+'/button'+GIWIK.css.night_suffix+'.png"/><table><tr><td>'+this.label+'</td></tr></table>';

				this.label_path = this.element_path.getElementsByTagName('td')[0];

				this.image_path = this.element_path.getElementsByTagName('img')[0];

				$('#'+this.idelem+' td').css({
					'text-align': 'center',
					'vertical-align': 'middle',
					//'user-select': 'none',  // pas encore implémenté, commenté pour éviter une erreur dans la console
					'-moz-user-select': 'none',
					'-khtml-user-select': 'none',
					'-o-user-select': 'none',
					'-webkit-user-select': 'none',
					'-ms-user-select': 'none'
				});
			}
			else
			{
				this.element_path.innerHTML = '<button>'+this.label+'</button>';
			}

			this.margin = (typeof this.margin != 'undefined') ? this.margin : '0 0 0 0';

			this.element_path.style.margin = this.margin;



			eval("this.element_path.onclick     = function () {if ("+this.self+".state === 1 && "+this.self+".execActionBefore(false,'onclick') !== false) {"+this.self+".execAction(false,'onclick');}};");
			eval("this.element_path.onmouseover = function () {if ("+this.self+".state === 1){"+this.self+".__mouseOver();}};");
			eval("this.element_path.onmouseout  = function () {if ("+this.self+".state === 1){"+this.self+".__mouseOut();}};");
			eval("this.element_path.onmousedown = function () {if ("+this.self+".state === 1){"+this.self+".__mouseDown();}};");
			eval("this.element_path.onmouseup   = function () {if ("+this.self+".state === 1){"+this.self+".__mouseUp();}};");

			this.setStatus(status);

			this.resize(size, this.width, this.height);
			this.disable();
			this.show();
		};

		this.setValue = function (value)
		{
			this.setLabel(value);
		};

		this.getValue = function ()
		{
			this.getLabel();
		};
		// Application d'une taille prédéfinie ou passage de width et height via la taille "custom"
		this.resize = function (size, width, height, font)
		{
			this.size = in_array(size,['full','medium','default','small','mini']) ? size : 'default';

			// Si le bouton est de type circulaire, on interdit les paramètres width, height et font
			if (this._options.type === 'default')
			{
				var width, height, font;
			}

			switch (this.size)
			{
				case 'full':
				case 'medium': 	// Seulement pour GIWIK en interne
					this.width  = width || 110;
					this.height = height || 106;
					this.font   = font || ((this._options.type === 'default') ? 'normal 12px Arial' : 'normal 14px Arial');
					break;
				case 'default':
					this.width  = width || 95;
					this.height = height || 92;
					this.font   = font || ((this._options.type === 'default') ? 'normal 11px Arial' : 'normal 13px Arial');
					break;
				case 'small':
					this.width  = width || 81;
					this.height = height || 78;
					this.font   = font || ((this._options.type === 'default') ? 'normal 11px Arial' : 'normal 13px Arial');
					break;
				case 'mini':
					this.width  = width || 69;
					this.height = height || 66;
					this.font   = font || ((this._options.type === 'default') ? 'normal 10px/11px Arial' : 'normal 12px Arial');
					break;
			}

			if (this._options.type === 'default')
			{
				$('#'+this.idelem+',#'+this.idelem+' img,#'+this.idelem+' table').css({
					'width':this.width,
					'height':this.height,
					'vertical-align':'top'
				});

				$('#'+this.idelem+' table').css({
					'margin-top':-this.height,
					'font':this.font
				});
			}
			else
			{
				$('#'+this.idelem+', #'+this.idelem+' button').css({
					'width':this.width,
					'height':this.height/2,
					'border-radius':'3px'
				});
				$('#'+this.idelem+' button').css({
					'margin-top':0,
					'font':this.font,
					'border': 'solid 2px transparent'
				});
			}

			this.__displayButtonUp();
		};

		this.hide = function (_options)
		{
			if (typeof _options != 'object')
			{
				var _options = {};
			}

			if (_options.hidden) {this.element_path.style.visibility = 'hidden';}
			else				 {this.element_path.style.display = 'none';}
		};

		this.show = function (_options)
		{
			if (typeof _options != 'object')
			{
				var _options = {};
			}

			this.element_path.style.visibility = 'visible';
			this.element_path.style.display = (this._options.type === 'default') ? 'table' : 'inline-block';
		};

		this.__enableSpecific = function (action)
		{
			if (this._options.type === 'default')
			{
				this.__mouseOut();

				$('#'+this.idelem).css
				({
					'opacity' : (GIWIK.css.display_mode === 'night') ? 0.85 : 1,	// (Si mode nuit, on met une légère transparence pour atténuer le blanc grâce au fond noir)
					'cursor'  : 'pointer'
				});
			}
			else
			{
				$('#'+this.idelem+' button')
					.removeAttr('disabled')
					.css({
						'cursor':'pointer',
						'opacity':1
					});
			}
		};

		this.__disableSpecific = function ()
		{
			this.__mouseOut();

			if (this._options.type === 'default')
			{
				$('#'+this.idelem).css
				({
					'opacity' : (GIWIK.css.display_mode === 'night') ? 0.35 : 0.35,
					'cursor'  : 'default'
				});
			}
			else
			{
				$('#'+this.idelem+' button')
					.attr('disabled','')
					.css({
						'cursor':'default',
						'opacity':1
					});
			}
		};

		this.__setStatusSpecific = function (status)
		{
			this.__mouseOut();

			if (this._options.type === 'default')
			{
				$('#'+this.idelem).css('background-color', GIWIK.css['color_'+status]);
			}
		};

		this.__mouseOver = function ()
		{
			this.__displayButtonOver();

			if (this._options.type === 'default')
			{
				this.element_path.style.color =  GIWIK.css['color_'+this.status];
			}
		};

		this.__mouseOut = function ()
		{
			this.__displayButtonUp();

			if (this._options.type === 'default')
			{
				this.element_path.style.color = this.color_up;
			}
		};

		this.__mouseDown = function ()
		{
			this.__displayButtonDown();
		};

		this.__mouseUp = function ()
		{
			this.__displayButtonUp();
		};

		// État relevé (non-enfoncé)
		this.__displayButtonUp = function ()
		{
			if (this._options.type === 'default')
			{
				this.element_path.style.background = 'transparent';
				this.image_path.src = GIWIK.directories.img+"/button"+GIWIK.css.night_suffix+".png";
			}
			else
			{
				$('#'+this.idelem+' button').css({
					'color': GIWIK.css.color_button_text,
					'border-color': 'transparent',
					'background': GIWIK.css.color_button_bg,
					'opacity': 1
				});
			}
		};

		// État survolé
		this.__displayButtonOver = function ()
		{
			if (this._options.type === 'default')
			{
				this.element_path.style.background = GIWIK.css['color_'+this.status];
				this.image_path.src = GIWIK.directories.img+"/buttoni"+GIWIK.css.night_suffix+".png";
			}
			else
			{
				var color = GIWIK.css['color_'+this.status];
				$('#'+this.idelem+' button').css({
					'color': GIWIK.css.color_button_texti,
					'border-color': color,
					'background': color,
					'opacity': 1
				});
			}
		};

		// État enfoncé
		this.__displayButtonDown = function ()
		{
			if (this._options.type === 'default')
			{

			}
			else
			{
				var color = GIWIK.css['color_'+this.status];
				$('#'+this.idelem+' button').css({
					'color': GIWIK.css.color_button_texti,
					'border-color': color,
					'background': color,
					'opacity':0.5
				});
			}
		};
	};
	
	
	// Classe Menu (onglets)
	function Menu (self, auto_activity)
	{
		this.self = self; 				// nom de l'instance
		this.idelem;					// Id de l'element dans lequel le select est instancie
		this.element_path;				// chemin DOM de cet element
		this._value;					// tableau contenant les valeurs des options
		this._text;						// tableau contenant les textes des options. Possibilité de passer des sous-titres en concaténant "->label_du_sous_titre" au label de l'item
		this._status;					// tableau contenant les statuts des options
		this.action = false;			// action lors d'un click
		this.action_before = false;		// action lors d'un click
		this.mode = 'default';			// mode boutons prev/next (default) ou linéaire (linear)
		this.state;						// Definit l'etat du menu :	0  -> inactif,
										//							1  -> actif
		this.options_number;			// nombre d'option contenues dans le select
		this.selected_option = -1;		// option selectionnee (0 -> option 1 etc. / par défaut aucune option n'est sélectionnée via la valeur "-1")
		this.value;						// valeur de l'option selectionnee
		this.selected_value;			// idem

		this.onchange_setmod = false;	// renvoie la variable settings_modified à true lors d'une modification (pour l'activations des boutons cancel/send)

		this.margin;			    	// spécifie des marges pour le module (0px 0px 0px 0px)
		this.margin_left;				// spécifie une marge gauche

		this.item_height = 18;			// hauteur de chaque élément du menu
		this.item_width = 83;			// largeur de chaque élément du menu (hors padding)
		this.item_padding = 0;			// padding (gauche et droit) commun à tous les éléments du menu
		this.item_margin;				// marge entre les éléments du menu (droite pour l'orientation horizontale et basse pour la verticale)
		this.num_item_per_row;			// nombre d'items par ligne (5 par défaut)

		this.auto_enable = (auto_activity) ? true : false;	// Gestion automatique de la méthode "enable" via HEADING.setSettingsActivity() si "auto_activity" vaut "true"

		this.__setAutoActivity(auto_activity);
		//.............................................................................................................


		this.construct = function (id_element, mode, _value, _text, onchange_setmod, item_width, item_height)
		{
			//......................................................
			this.idelem = id_element;
			this.mode = mode;
			this._value = _value;
			this._text = (typeof _text == 'object' && _text !== null) ? _text : _value;
			if (typeof onchange_setmod == 'boolean'){this.onchange_setmod = onchange_setmod};
			this.element_path = document.getElementById(this.idelem);

			if (!this.element_path)
			{
				console.error(this.self+'.construct : DOM element "'+this.idelem+'" is missing');
				return false;
			}

			// Optionnel
			if (typeof item_width  != 'undefined') {this.item_width  = parseFloat(item_width); }
			if (typeof item_height != 'undefined') {this.item_height = parseFloat(item_height);}

			// Par défaut, la marge séparant les items est de 1px pour le mode vertical et 5px pour le mode horizontal
			if (typeof this.item_margin == 'undefined'){this.item_margin = this.mode == 'vertical' ? 1 : 5;}

			this.margin = (typeof this.margin != 'undefined') ? this.margin : '0 0 0 0';

			this.setList(_value, _text);
			this.setStatus(1);
			this.resize();
			this.disable();
			this.show();
		};

		// Initialise le module : definit l'option selectionnee à partir de sa valeur (no_action permet de désactiver l'action associée)
		this.setValue = function (value, no_action, event)
		{
			// Si la valeur n'est pas comprise dans l'offre, elle est considérée comme undefined
			// Test utilse en cas de setList() avec une offre qui ne contient plus la valeur courrante stockée (this.value)
			if (!in_array(value, this._value, true))
			{
				value = undefined;
			}

			// Si la valeur passée ne correpond pas à la valeur stockée
			if (this.value !== value)
			{
				// Exécution de la fonction "garde-fou"
				if (this.execActionBefore(no_action) === false)
				{
					return false;
				}

				// Si elle existe, appel de la méthode de gestion particulière du flag window.settings_modified AVANT le garde fou (utile notamment pour le tableau des inputs)
				if (typeof HEADING.setSettingsModified == 'function')
				{
					HEADING.setSettingsModified(false, value);
				}

				// Garde fou contre la perte de paramétrage lors d'un clic sur un item (window.settings_modified_unload permet de spécifier qu'on ne souhaite un message de confirmation qu à l'unload. ie : tableau des inputs de PHINS)
				if (window.settings_modified === true)
				{
					if (!confirm(MSG(['confirm','unload'])))
					{
						return false;
					}
					else
					{
						// Si elle existe, appel de la méthode de gestion particulière du flag window.settings_modified avec le paramètre true pour indiquer qu'il y a déjà eu confirmation et que ce n'est pas la peine de recommencer (tableau inputs)
						if (typeof HEADING.setSettingsModified == 'function')
						{
							HEADING.setSettingsModified(true);
						}
						else
						{
							window.settings_modified = false;
						}
					}
				}

				if (in_array(value, this._value, true))
				{
					this.value = value;
					this.selected_value = this.value;

					for (var i=0; i<this.options_number; i++)
					{
						if (this._value[i] == this.value)
						{
							this.selected_option = i;
							break;
						}
					}

					// Evaluation de l'action si on n'est pas en "no_action"
					this.execAction(no_action);
				}
				else
				{
					this.value = undefined;
					this.selected_value = this.value;
					this.selected_option = -1;
				}

				this.__applyClassNames();

				this.__settingsModified(event);
			}

		};

		this.getValueLabel = function ()
		{
			return this._text[this.selected_option];
		};

		// Retourne toutes les valeurs, labels et statuts associés sous forme d'un tableau comprenant 3 sous-tableaux (valeurs, labels, statuts)
		this.getList = function ()
		{
			var _values = [],
				_labels = [],
				_status = [],
				i;

			for (i in this._value)
			{
				_values.push(this._value[i]);
				_labels.push(this._text[i]);
				_status.push(this._status[i]);
			}

			return {
				_values : _values,
				_labels : _labels,
				_status : _status
			};
		};

		// Mise à jour des options (label et valeurs) [par défaut, les options sont ajoutées au select via javascript. l'option is_construct permet de renvoyer le code HTML des options pour la phase de construction.]
		this.setList = function (_value, _text, _status)
		{
			if (typeof _value == 'object')
			{
				this._value = _value;
				// Si aucun tableau de texte n'est transmis, les valeurs sont utilisées
				this._text = array_map(function(value){return trim(value);}, (typeof _text == 'object' && _text !== null) ? _text : this._value);
				this._status = [];

				this.options_number = this._value.length;						// Nombre d'options du menu

				// Par défaut, 5 items par ligne
				if (typeof this.num_item_per_row == 'undefined')
				{
					this.num_item_per_row = 5;
				}
				this.num_rows = Math.ceil(this.options_number/this.num_item_per_row);



				this._last_row_item = [];
				var item_position = 0;
				// calcul du dernier item de chaque ligne
				for (var i=0; i<this.options_number; i++)
				{
					item_position = (item_position == this.num_item_per_row) ? 1 : item_position+1;

					if (item_position == this.num_item_per_row || i == this.options_number-1)
					{
						this._last_row_item.push(i);
					}
				}
				//......................................................

				// Récupération des éventuels sous-titres d'item (dans this._text : label_de_l_item->label_sous_titre)
				this._subtitle = [];
				for (var i in this._text)
				{
					if (typeof this._text[i] == 'string' && this._text[i].indexOf("->") != -1)
					{
						var _matches = this._text[i].split("->");
						this._text[i] = _matches[0];
						this._subtitle[i] = _matches[1];
					}
				}

				var a_style = '',
					a_style_subtitle = '',
					a_style_width  = (typeof this.item_width == 'number') ? 'width:'+this.item_width+'px;' : '',
					a_style_height = 'line-height:'+this.item_height+'px;',
					a_style_margin = '',
					a_style_padding = '',
					opacity = (typeof this.element_path.style.opacity != 'undefined') ? 'opacity: 0.5' : 'filter:alpha(opacity=50)',
					mask,
					css_subtitle,
					margin_bottom,
					margin_right,
					content = '<table class="objmenu0"><tr>';

					for (var i=0; i<this.options_number; i++)
					{
						// définition des marges des items ------------------------------------------------------------------------------------------

						// Marge droite si mode horizontal ET qu'il ne s'agit pas du dernier item d'une ligne
						margin_right = (this.mode != 'vertical' && !in_array(i, this._last_row_item)) ? this.item_margin : 0;

						// Marge basse si mode vertical
						margin_bottom = (this.mode == 'vertical' || Math.ceil((i+1)/this.num_item_per_row) != this.num_rows) ? this.item_margin : 0;

						// Marge de l'item
						a_style_margin = 'margin: 0 '+margin_right+'px '+(this._subtitle[i] ? 0 : margin_bottom)+'px 0;';

						// Marge du sous-titre
						a_style_margin_subtitle = 'margin: 1px '+margin_right+'px '+(this._subtitle[i] ? margin_bottom : 0)+'px 0;';


						// Gestion des bords arrondis ------------------------------------------------------------------------------------------------
						var a_style_border = '';
						if (this.mode == 'vertical')
						{
							a_style_border += 'border-top-left-radius: 4px;border-bottom-left-radius: 4px;';
						}
						else
						{
							a_style_border += 'border-radius: 3px;';
						}

						a_style_padding = 'padding:' +((this.item_padding !== 0) ? '0 '+this.item_padding+'px' : '0')+';';

						a_style_subtitle = a_style_margin_subtitle;
						a_style = a_style_height+a_style_margin+a_style_padding+a_style_border; // la largeur sera appliquée par this.resize();

						css_subtitle = (typeof this._subtitle[i] == 'string') ? 'objmenu_subtitle' : 'displaynone';

						content +='<td>'
									+'<div>'
										+'<a id="'+this.idelem+i+'" href="javascript:void(0)" style="'+a_style+'">'+this._text[i]+'</a>'
										+'<div class="'+css_subtitle+'" style="'+a_style_subtitle+'">'+this._subtitle[i]+'</div>'
									+'</div>'
								+'</td>';

						if (i+1 != this.options_number && (this.mode == 'vertical' || in_array(i, this._last_row_item)))
						{
							content += '</tr></table>';
							content += '<table class="objmenu0"><tr>';
						}
					}

				content += '</tr></table>';

				this.element_path.innerHTML = content;

				this.element_path.style.margin = this.margin;
				if (typeof this.margin_left != 'undefined')
				{
					this.element_path.style.marginLeft = this.margin_left+'px';
				}

				for (var i=0; i<this.options_number; i++)
				{
					eval
					(
						"document.getElementById('"+this.idelem+i+"').onclick = function () "
						+"{"
							+"if ("+this.self+".state === 1)"
							+"{"
								+this.self+".setValue("+this.self+"._value["+i+"], false, 'onclick');"
							+"}"
						+"};"
					);
				}

				this.resize();
				this.setValue(this.value);
				this.__applyClassNames();
			}
		};

		this.getLabel = this.getValueLabel;
		this.setLabel = function () {};

		this.resize = function (item_width, item_height)
		{
			if (typeof item_width == 'number')
			{
				this.item_width = item_width;
			}

			if (typeof item_height == 'number')
			{
				this.item_height = item_height;
			}

			for (var i=0; i<this.options_number; i++)
			{
				document.getElementById(this.idelem+i).style.width = this.item_width+'px';
				document.getElementById(this.idelem+i).style.height = this.item_height+'px';
			}
		};

		this.__enableSpecific = function ()
		{
			GIWIK.css.setClass(this.idelem, 'objmenu1');

			this.__applyClassNames();
		};

		this.__disableSpecific = function ()
		{
			GIWIK.css.setClass(this.idelem, 'objmenu0');

			$('.objmenu').bind({
				'mouseenter': function () {return false;},
				'mouseleave': function () {return false;}
			});
		};

		this.__setStatusSpecific = function (status)
		{
			$('.objmenui').css({
				'color': GIWIK.css.color_menu,
				'background-color': GIWIK.css['color_'+status]
			});

			$('.objmenui').bind('mouseenter mouseleave', function () {$(this).css('color', GIWIK.css.color_menu)});

			$('.objmenu').css({
				'background-color': GIWIK.css.color_0
			});

			$('.objmenu').bind({
				'mouseenter': function () {$(this).css('color', (status === 0) ? GIWIK.css.color_menu : GIWIK.css['color_'+status])},
				'mouseleave': function () {$(this).css('color', GIWIK.css.color_menu)}
			});
		};

		this.__applyClassNames = function ()
		{
			for (var i=0; i<this.options_number; i++)
			{
				if (i == this.selected_option)
				{
					GIWIK.css.setClass(this.idelem+i, 'objmenui');
				}
				else
				{
					GIWIK.css.setClass(this.idelem+i, 'objmenu');
				}
			}
			this.__setStatusSpecific(this.status)
		};
	};

	// Classe Switch
	function Switch (self, auto_activity)
	{
		this.self = self; 				// nom de l'instance
		this.idelem;					// Id de l'element dans lequel le select est instancie
		this.inputid, this.switchid;	// Id du switch
		this.label;						// Label du switch
		this.element_path;				// chemin DOM de cet element
		this.switch_path;				// chemin DOM du select
		this._value;					// tableau contenant les 2 valeurs du switch (0:état off, 1:état on)
		this.action = false;			// action lors d'un onchange
		this.mode = 'default';			// mode boutons prev/next (default) ou linéaire (linear)
		this.state;						// Definit l'etat du switch :	0  -> inactif,
										//								1  -> actif
		this.value;						// valeur actuelle du switch

		this.height = 20;				// height du conteneur du module
		this.label_width;		// width du label en mode "linear"

		this.font_size = 13;			// taille de la police (13[px] par défaut)
		this.margin;					// spécifie des marges pour le module (0px 0px 0px 0px)
		this.margin_left;				// spécifie une marge gauche

		this.onchange_setmod = true;	// renvoie la variable settings_modified à true lors d'une modification (pour l'activations des boutons cancel/send)

		this.auto_enable = (auto_activity) ? true : false;	// Gestion automatique de la méthode "enable" via HEADING.setSettingsActivity() si "auto_activity" vaut "true"

		this.__setAutoActivity(auto_activity);
		//.............................................................................................................

		this.construct = function (id_element, mode, label, _value, onchange_setmod)
		{
			//......................................................
			this.idelem = id_element;
			this.inputid = id_element+'_input_';  this.switchid = this.inputid;
			this.mode = mode;
			this.label = label;
			this.labelid = id_element+'_label_';
			this._value = _value;
			if (typeof onchange_setmod != 'undefined'){this.onchange_setmod = onchange_setmod;}
			this.element_path = document.getElementById(this.idelem);

			if (!this.element_path)
			{
				console.error(this.self+'.construct : DOM element "'+this.idelem+'" is missing');
				return false;
			}
			//......................................................

			var content = '';

			switch (this.mode)
			{
				case 'linear':
					this.margin = (typeof this.margin != 'undefined') ? this.margin : '12px 0 0 0';

					var label_style = '';

					label_style += 'text-align:left;';

					// Si une largeur spéciale du label à été définie
					if (typeof this.label_width == 'number')
					{
						label_style += 'width:'+this.label_width+'px;';
					}

					// Cas d'un label sur 2 lignes
					if (this.label.match(/<br\s*\/?>/i))
					{
						label_style += 'top:-1px;';
						label_style += 'line-height:12px;';
					}



					content += '<table><tr>';
						if (this.label != ''){content += '<td class="switch_label_linear" style="'+label_style+'"><div id="'+this.labelid+'">'+this.label+'</div></td>';}
						content += '<td><div id="'+this.switchid+'"></div></td>';
					content += '</tr></table>';


					this.element_path.innerHTML = content;

					if (typeof this.height == 'number')
					{
						this.element_path.style.height = this.height+'px';
					}
					break;

				default:
					this.margin = (typeof this.margin != 'undefined') ? this.margin : '0 0 0 0';

					content += '<table>';
						if (this.label != ''){content += '<tr><td class="switch_label"><div id="'+this.labelid+'">'+this.label+'</div></td></tr>';}
						content += '<tr><td align="center" valign="middle"><div id="'+this.switchid+'"></div></td>';
						content += '</tr>';
					content += '</table>';

					this.element_path.innerHTML = content;
					break;
			}

			this.element_path.style.backgroundColor = GIWIK.css.color_background;

			this.element_path.style.margin = this.margin;
			if (typeof this.margin_left != 'undefined'){this.element_path.style.marginLeft = this.margin_left+'px';}

			//...................................................................................................................
			this.input_path  = document.getElementById(this.inputid);			// Chemin DOM du switch
			this.switch_path = this.input_path;					// Pour compatibilité
			this.label_path  = document.getElementById(this.labelid);			// Chemin DOM du label
			//...................................................................................................................

			eval
			(
				"this.input_path.onclick = function ()"
				+"{"
				 	+"if ("+this.self+".state === 1)"
				 	+"{"
						+this.self+".setValue(("+this.self+".value == "+this.self+"._value[0]) ? "+this.self+"._value[1] : "+this.self+"._value[0], false, 'onclick');"
					+"}"
				+"};"
			);

			this.disable();
			this.show();
		};

		// Initialise le module : definit l'option selectionnee à partir de sa valeur
		this.setValue = function (value, no_action, event)
		{
			if (this.value === value) {return;}

			// Exécution de la fonction "garde-fou"
			if (this.execActionBefore(no_action) === false)
			{
				return false;
			}

			this.value = (in_array(value, this._value, true)) ? value : this._value[0];

			var css = (this.value === this._value[1]) ? 1 : 0;

			GIWIK.css.setClass(this.switchid, 'switch_'+css);

			// Déclanchement de l'action
			this.execAction(no_action);

			// Si le setValue correspond à une action utilisateur
			this.__settingsModified(event);
		};

		this.__enableSpecific = function ()
		{
			$('#'+this.idelem).css('opacity', (GIWIK.css.night_mode) ? 0.85 : 1);
			$('#'+this.inputid).css('cursor', 'pointer');
		};

		this.__disableSpecific = function ()
		{
			$('#'+this.idelem).css('opacity', (GIWIK.css.night_mode) ? 0.35 : 0.5);
		};
	};

	// Classe Input_int (champ de saisie d'un nombre)
	function Input_int (self, auto_activity)
	{
		this.self = self;				// nom de l'instance du potentiometre
		this.idelem;					// id de l'élément dans lequel le potentiometre est généré
		this.element_path;				// chemin DOM de cet element
		this.mode = 'default';			// mode par défault (default), linéaire (linear) ou potentiomètre (potentiometer)
		this.readonly;					// le champ est-il en lecture seule
		this.state;						// définit l'etat de l'input : 1 -> clicable, 0 -> inactif
		this.value;						// valeur du champ (dernière valeur valide)
		this.action = false;			// action lors de la modification de la valeur du champ (valeurs valides uniquement)
		this.action_onclick = false;	// action lors du focus du champ
		this.action_onblur = false;		// action lors de la perte du focus du champ

		this.label_width;		// width du label en mode "linear"
		this.input_width;		// width du champ en mode "linear"
		this.border_input = '1px solid';// style de bordure du champs de saisie
		this.low_fontsize;				// permet d'afficher une taille de police plus faible en mode "linear"
		this.margin;					// spécifie des marges pour le module (0px 0px 0px 0px)
		this.margin_left;				// spécifie une marge gauche
		this.text_align;				// alignement du texte dans le champ

		this.curs = 'pointer'; 			// type de curseur sur images

		this.src0 = GIWIK.directories.img+"/input_led0.png";
		this.src1 = GIWIK.directories.img+"/input_led1.png";
		this.fond = GIWIK.directories.img+"/input_bg1"+GIWIK.css.night_suffix+".gif";

		this.onchange_setmod = true;	// renvoie la variable settings_modified à true lors d'une modification (pour l'activations des boutons cancel/send)

		this.enable_novalue = false;	// Définit si aucune valeur entrée est acceptable

		this.auto_enable = (auto_activity) ? true : false;	// Gestion automatique de la méthode "enable" via HEADING.setSettingsActivity() si "auto_activity" vaut "true"

		this.label;						// label de l'objet
		this.vstep;						// valeur du pas
		this.jstep;						// valeur du saut de pas lors d'un "onpress" d'une flèche de direction (jump step)
		this.vmin;						// valeur mini
		this.vmax;						// valeur maxi
		this.mini;						// indice mini
		this.maxi;						// indice maxi
		this.prec;						// Précision (nombre de décimales) déduite du pas (vstep) (this.vstep=0.001 donne this.prec=3)

		this.__setAutoActivity(auto_activity);

		// Spécifique mode "potentiometer" ----------------------------------------------------------------------------------------------------
		this.num_leds;					// nombre total de leds
		this.r    = 64.7;				// rayon du potentiometre
		this.offx = 10;
		this.offy = 15;
		this.led_size = 10;				// diamètre des diodes
		this.amin = 20;  				// angle de debut de graduation
		this.amax = 340; 				// angle de fin de graduation
		this.offa = -90; 				// angle de correction d'origine par rapport au zero trigo
		//.....................................................................................................................................


		this.construct = function (id_element, mode, label, vstep, vmin, vmax, unit, jstep, onchange_setmod)
		{
			this.idelem = id_element;
			this.mode   = mode;
			this.label = label;
			this.unit  = unit;
			this.labelid = id_element+'_label_';
			this.inputid = id_element+'_input_';
			this.unitid  = id_element+'_unit_';

			this.vstep  = parseFloat(vstep);
			this.digits = count_decimals(this.vstep);
			this.vmin   = parseFloat(vmin);
			this.vmax   = parseFloat(vmax);
			this.jstep  = jstep ? parseFloat(jstep) : this.vstep;

			this.element_path = document.getElementById(this.idelem);

			if (typeof onchange_setmod != 'undefined'){this.onchange_setmod = onchange_setmod;}

			if (typeof this.readonly != 'boolean'){this.readonly = false;}
			if (this.readonly){this.border_input = '0px solid '+GIWIK.css.color_background;} // transparent n'est pas pris en compte

			if (!this.element_path)
			{
				console.error(this.self+'.construct : DOM element "'+this.idelem+'" is missing');
				return false;
			}
			//......................................................

			var tmp = ''
			+'<table>'
				+'<tr>'
					+'<td><div id="'+this.labelid+'">'+this.label+'</div></td>'
					+(this.mode != 'linear' ? '</tr><tr>' : '')
					+'<td><input type="text" id="'+this.inputid+'" name="'+this.inputid+'" value=""></td>'
					+(this.mode != 'linear' ? '</tr><tr>' : '')
					+'<td><div id="'+this.unitid+'">'+this.unit+'</div></td>'
				+'</tr>'
			+'</table>';

			// Potentiomètre : génération des diodes
			if (this.mode == 'potentiometer')
			{
				// Calcul du nombre de marches entre les valeurs min et max
				var num_steps = (this.vmax-this.vmin)/this.vstep;

				// Nombre total de leds
				this.num_leds = num_steps + 1;

				// Calcul de l'angle (en °) séparant chaque led
				var led_angle = (this.amax-this.amin) / num_steps;

				// Valeur associée à une marche
				var led_value;

				var k=0;
				for (var i=this.amin;Math.round(i)<=this.amax;i+=led_angle)
				{
					imgcoords = this.__polar2rect(0.9*this.r+1 , (this.__correctAngle( (i * Math.PI / 180) , this.offa) * Math.PI / 180 ));
					xl = imgcoords[0] + this.r + this.offx - this.led_size/2 + 2;
					yl = imgcoords[1] + this.r + this.offy - this.led_size/2 + ((GIWIK._context.ie == 7) ? 1 : -1);

					// Calcul de la valeur associée à la led
					led_value = this.vmin + k*this.jstep;

					tmp += ""
						+"<div id='led"+k+"' style='position:absolute;left:"+(Math.round(xl-12))+"px;top:"+(Math.round(yl-16))+"px;z-index:10;'>"
							+"<img id='img"+k+"["+this.idelem+"]' src='"+this.src0+"' width='"+(this.led_size)+"' height='"+(this.led_size)+"' onmouseover='"+this.self+".__rollOver(this,"+led_value+",1);' onmouseout='"+this.self+".__rollOver(this,"+led_value+",0);' onclick='if ("+this.self+".onchange_setmod == true){window.settings_modified = true;}"+this.self+".setValue("+led_value+");' style='cursor:"+this.curs+"'>"
						+"</div>";

					k++;
				}

				this.mini=0;
				this.maxi=k;
			}

			this.element_path.innerHTML = tmp;

			//...........................................................................
			this.label_path   = document.getElementById(this.labelid);
			this.input_path   = document.getElementById(this.inputid);
			this.unit_path    = document.getElementById(this.unitid);
			//...........................................................................

			$('#'+this.idelem).css({
				margin: (typeof this.margin != 'undefined') ? this.margin : '12px 0 0 0',
				textAlign: 'center'
			});
			if (typeof this.margin_left == 'number')
			{
				$('#'+this.idelem).css({marginLeft: parseFloat(this.margin_left)+'px'});
			}

			$('#'+this.labelid).css({
				textAlign: 'center',
				font: 'bold 12px/12px arial',
				cursor: 'default',
				whiteSpace: 'nowrap'
			});

			$('#'+this.inputid).css({
				paddingTop: '0px',
				paddingBottom: '0px',
				paddingLeft: '3px',
				paddingRight: '3px',
				textAlign: (typeof this.text_align == 'string') ? this.text_align : 'center',
				font: 'bold 18px/18px arial',
				backgroundColor: 'transparent',
				border: this.border_input,
				borderRadius: 3
			});

			$('#'+this.unitid).css({
				textAlign: 'center',
				font: 'bold 12px/12px arial',
				cursor: 'default'
			});

			this.setStatus(1);
			//...........................................................................


			switch (this.mode)
			{
				case 'linear':
					this.low_fontsize = true;

					$('#'+this.labelid).css({
						display: (!this.label) ? 'none' : 'block',
						'min-width': (typeof this.label_width == 'number') ? this.label_width : '',	// si une largeur spécifique pour le label est spécifiée
						textAlign: 'left',
						paddingRight: '10px'
					});

					$('#'+this.unitid).css({
						display: (!this.unit) ? 'none' : 'block',
						textAlign: 'left',
						paddingLeft: '6px'
					});
					break;

				case 'potentiometer':
					this.low_fontsize = false;

					$('#'+this.idelem).css({
						position: 'relative',
						textAlign: 'center'
					});

					// Style du tableau conteneur
					$('#'+this.idelem+' table').eq(0).css({
						width:'130px',
						height:'130px',
						background: 'no-repeat 0 0 url('+this.fond+')'
					});
					$('#'+this.labelid).closest('td').css({height:'54px',verticalAlign:'bottom'});
					$('#'+this.inputid).closest('td').css({height:'25px'});
					$('#'+this.unitid).closest('td').css({height:'51px',verticalAlign:'top'});

					$('#'+this.labelid).css({
						marginBottom:(this.label.match(/<br\s*\/?>/i)) ? '8px' : '12px'	// moins de marge basse si label sur 2 lignes (via <br/>)
					});

					$('#'+this.inputid).css({
						paddingBottom: '1px'
					});

					$('#'+this.unitid).css({
						marginTop:'10px'
					});
					break;

				default:
					this.low_fontsize = (typeof this.low_fontsize == 'boolean') ? this.low_fontsize : true;

					// Style du tableau conteneur
					$('#'+this.idelem+' table').eq(0).css({
						marginLeft:'auto',
						marginRight:'auto'
					});

					$('#'+this.inputid).css({marginTop:'11px'});
					$('#'+this.unitid).css({marginTop:'11px'});
			}

			if (GIWIK._context.ie < 9)
			{
				$('#'+this.inputid).css({
					paddingTop: '1px'
				});

				if (GIWIK._context.ie == 7)
				{
					$('#'+this.idelem).css({
						textAlign: 'left'
					});
				}
			}

			if (GIWIK._context.ie < 9) {$("#"+this.idelem).css({'background':GIWIK.css.color_background});} // IE<9 bogue sur la transparence

			$('#'+this.inputid).css({
				width: (typeof this.input_width == 'number') ? this.input_width : '81px'	// si une largeur spécifique pour l'input est spécifiée
			});

			// si le mode faible taille de police est activé
			if (this.low_fontsize == true)
			{
				$('#'+this.inputid).css({
					height: 22 - parseFloat($('#'+this.inputid).css('padding-top')) - parseFloat($('#'+this.inputid).css('padding-bottom')) - parseFloat($('#'+this.inputid).get(0).style.border.match(/(\d+)(px|em)/i)[0])*2,
					fontSize: '15px'
				});
			}

			// Correction de la largeur
			$('#'+this.inputid).css({
				width: parseFloat($('#'+this.inputid).css('width')) - parseFloat($('#'+this.inputid).css('padding-left')) - parseFloat($('#'+this.inputid).css('padding-right')) - parseFloat($('#'+this.inputid).get(0).style.border.match(/(\d+)(px|em)/i)[0])
			});

			eval("this.input_path.onkeydown = function (evt) {"+this.self+".__doOnKeyDown(evt ? evt : window.event/*pour IE8*/);};");
			eval("this.input_path.onkeyup   = function (evt) {"+this.self+".__doOnKeyUp(evt ? evt : window.event/*pour IE8*/);};");
			eval("this.input_path.onblur    = function ()    {"+this.self+".setValue("+this.self+".input_path.value, false, 'onblur');};");
			eval("this.input_path.onfocus   = function ()    {if("+this.self+".state === 1){"+this.self+".execActionOnFocus();}else{"+this.self+".input_path.blur();}};");

			this.disable();
			this.show();
		};

		this.setValue = function (value_precheck, no_action, event, key_code)
		{
			// Pour la touche "entrée" on blur le champ (ce qui va appeler automatiquement un setValue())
			if (key_code == 13)
			{
				this.input_path.blur();
				return;
			}

			// Si la valeur n'a pas changé
			if (event != 'onblur' && ((value_precheck === "" && this.value === "") || (this.value === parseFloat(value_precheck))))
			{
				return;
			}

			// Exécution de la fonction "garde-fou"
			if (this.execActionBefore(no_action) === false)
			{
				return false;
			}

			// Remplacement de l'éventuelle virgule par un point
			if (typeof value_precheck == 'string')
			{
				value_precheck = value_precheck.replace(/[,]/,".");
			}

			// Initialisation de la variable contenant la valeur vérifiée
			var val = (typeof value_precheck == 'string') ? parseFloat(value_precheck) : value_precheck;   // document.title += val+' ';

			// S'il peut n'y avoir aucune valeur
			if (this.enable_novalue == true && (isNaN(val) || trim(val) === ''))
			{
				val = '';
			}
			// Sinon
			else
			{
				// Si la valeur n'est pas un nombre
				if (isNaN(val) || trim(val) === '')
				{
					// Si le parseFloat est correct, on l'utilise
					if (parseFloat(val) >= this.vmin && parseFloat(val) <= this.vmax)
					{
						val = parseFloat(val);
					}
					// Sinon, on met 0 si 0 est compris dans les bornes, autrement on met la valeur minimum
					else
					{
						val = (0 >= this.vmin && 0 <= this.vmax) ? 0 : this.vmin;
					}
				}
				// Si la valeur est trop basse
				else if (val < this.vmin)
				{
					val = this.vmin;
				}
				// Si la valeur est trop haute
				else if (val > this.vmax)
				{
					val = this.vmax;
				}

				// Arrondi pour coller au pas défini
				val = Math.round(parseFloat(val)/this.vstep)*this.vstep;

				// Correction du bug de décimales javascript
				val = eval(val.toFixed(this.digits));
			}

			// console.log('val:'+val+'\nvalue_precheck:'+value_precheck+'\nisSymboleKey:'+this.__isSymboleKey(key_code))

			// Si la valeur n'est pas valide ET qu'il s'agit d'une touche symbole, la valeur passe en rouge
			if (val != value_precheck && this.__isSymboleKey(key_code))
			{
				// Application de la couleur rouge
				this.setStatus(3);
				//this.input_path.value = value_precheck;
			}
			else
			{
				// Sauvegarde de l'ancienne valeur pour pouvoir la comparer à la nouvelle
				this.old_value = real_parseFloat(this.value);

				// Mise à jour de la valeur de l'objet avec la valeur vérifiée
				this.value = val;


				// Pour l'initialisation automatique (par getConf()), l'évènement "onblur" et pour les actions flèche haute et basse, on remplace la valeur du champ par la valeur vérifiée
				if (!key_code || in_array(key_code,[38,40]) || event == 'onblur')
				{
					this.input_path.value = this.value;
				}

				// Application de la couleur bleue
				this.setStatus(1);


				// Execution des actions si la valeur a changé
				if (this.value !== this.old_value)
				{
					this.execAction(no_action);

					this.__settingsModified(event);
				}

				// Si une action pour l'évènement "onblur" a été définie
				if (event == 'onblur')
				{
					this.execActionOnBlur(no_action);
				}
			}

			val = null;

			if (this.mode == 'potentiometer')
			{
				// Actualisaion des diodes
				this.__displayLeds();
			}
		};

		// Mise à jour Valeurs Min Max
		this.updateBounds = function (vmin, vmax)
		{
			this.vmin   = parseFloat(vmin);
			this.vmax   = parseFloat(vmax);

			this.setValue(this.value);
		};

		this.__doOnKeyDownSpecific = function (key_code)
		{
			switch (key_code)
			{
				// Haut
				case 38 :
					// Si la valeur n'est pas déjà maximum
					if (this.value < this.vmax)
					{
						// Si la valeur + jump step dépasse le max, on fixe la valeur au max
						if (this.value + this.jstep > this.vmax)
						{
							this.setValue(this.vmax, false, 'onkeydown', key_code);
						}
						// Autrement, on incrémente de la valeur du jump step
						else
						{
							this.setValue((this.value+this.jstep).toFixed(this.digits), false, 'onkeydown', key_code);
						}
					}
					break;

				// Bas
				case 40 :
					// Si la valeur n'est pas déjà minimum
					if (this.value > this.vmin)
					{
						// Si la valeur - jump step dépasse le min, on fixe la valeur au min
						if (this.value - this.jstep < this.vmin)
						{
							this.setValue(this.vmin, false, 'onkeydown', key_code);
						}
						// Autrement, on décrémente de la valeur du jump step
						else
						{
							this.setValue((this.value - this.jstep).toFixed(this.digits), false, 'onkeydown', key_code);
						}
					}
					break;

				// Gauche
				case 37 :
					break;

				// Droite
				case 39 :
					break;
			}
		};

		// Méthodes spécifiques au mode "potentiometer" —————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
		this.__correctAngle = function (angleRad,offAngle)
		{
			var angleDeg = (angleRad*180/Math.PI)+offAngle;

			if (angleDeg  < 0)
			{
				angleDed = 360 + angleDeg;
			}
			else if (angleDeg >= 360)
			{
				angleDeg = angleDeg - 360;
			}
			return angleDeg;
		};

		// r en radians, retourne array [ x ; y ]
		this.__polar2rect = function (r,theta)
		{
			var x = r*Math.cos(theta),
				y = r*Math.sin(theta);

			return [x,y];
		};

		this.__displayLeds = function (value, is_init)
		{
			// Si aucune valeur n'est passée, on prend la valeur en cours
			value = value ? value : this.value;

			var led_value;

			for (var i=0; i<this.num_leds; i++)
			{
				led_value = this.vmin + i*this.jstep;

				if (led_value <= value)
				{
					document.getElementById('img'+i+'['+this.idelem+']').src = this.src1;
				}
				else
				{
					document.getElementById('img'+i+'['+this.idelem+']').src = this.src0;
				}
			}
			led_value = null;
		};

		this.__rollOver = function (img, value, way)
		{
			if (value == this.value){return;}

			this.input_path.value = way ? value : this.value;
			this.setStatus(way ? 0 : 1);
			img.src = way ? this.src1 : (value > this.value ? this.src0 : this.src1);
		};
	};

	// Classe Input_text (champ de saisie d'un texte libre)
	function Input_text (self, auto_activity)
	{
		this.self = self;				// nom de l'instance du module
		this.idelem;					// id de l'élément dans lequel le module est généré
		this.element_path;				// chemin DOM de cet element
		this.init = true;				// indique qu'il s'agit de la première initialisation du module
		this.label;						// label
		this.mode = 'default';			// mode d'affichage par vertical (default) ou linéaire (linear)
		this.readonly;					// le champ est-il en lecture seule
		this.state;						// définit l'etat du champ : 1 -> clicable, 0 -> inactif
		this.value = "";				// valeur du champ (dernière valeur valide)
		this.action = false;			// action lors de la modification de la valeur du champ (valeurs valides uniquement)
		this.action_onclick = false;	// action lors du focus du champ
		this.action_onblur = false;		// action lors de la perte du focus du champ

		this.height;					// height du conteneur (hauteur globale)
		this.label_width;		// width du label en mode "linear"
		this.input_width;		// width du champ en mode "linear"
		this.border_input = '1px solid';// style de bordure du champs de saisie
		this.low_fontsize;				// permet d'afficher une taille de police plus faible en mode "linear"
		this.fontsize;					// taille de la police du champ
		this.margin;					// spécifie des marges pour le module (0px 0px 0px 0px)
		this.margin_left;				// spécifie une marge gauche
		this.text_align;				// alignement du texte dans le champ

		this.onchange_setmod = true;	// renvoie la variable settings_modified à true lors d'une modification (pour l'activations des boutons cancel/send)

		this.enable_novalue = false;	// Définit si aucune valeur entrée est acceptable

		this.auto_enable = (auto_activity) ? true : false;	// Gestion automatique de la méthode "enable" via HEADING.setSettingsActivity() si "auto_activity" vaut "true"

		this.input_type;				// type de champ input : 'text'(défaut) ou  'password'
		this.input_max_length;			// Nombre de caractères max du champ

		this.__setAutoActivity(auto_activity);
		//.....................................................................................................................................

		this.construct = function (id_element, mode, label, unit, onchange_setmod)
		{
			this.idelem = id_element;
			this.mode = mode;
			this.label = label;
			this.unit  = unit;
			this.labelid = id_element+'_label_';
			this.inputid = id_element+'_input_';
			this.unitid  = id_element+'_unit_';

			this.element_path = document.getElementById(this.idelem);

			if (typeof onchange_setmod != 'undefined'){this.onchange_setmod = onchange_setmod;}

			if (typeof this.readonly != 'boolean'){this.readonly = false;}
			if (this.readonly){this.border_input = '0px solid '+GIWIK.css.color_background;} // transparent n'est pas pris en compte

			if (!this.input_type){this.input_type = 'text';}

			if (!this.element_path)
			{
				console.error(this.self+'.construct : DOM element "'+this.idelem+'" is missing');
				return false;
			}
			//......................................................

			var tmp = ''
			+'<table>'
				+'<tr>'
					+'<td><div id="'+this.labelid+'">'+this.label+'</div></td>'
					+(this.mode != 'linear' ? '</tr><tr>' : '')
					+'<td><input type="'+this.input_type+'" id="'+this.inputid+'" name="'+this.inputid+'" value="" /></td>'
					+(this.mode != 'linear' ? '</tr><tr>' : '')
					+'<td><div id="'+this.unitid+'">'+this.unit+'</div></td>'
				+'</tr>'
			+'</table>';


			this.element_path.innerHTML = tmp;

			//...........................................................................
			this.label_path   = document.getElementById(this.labelid);
			this.input_path   = document.getElementById(this.inputid);
			this.unit_path    = document.getElementById(this.unitid);
			//...........................................................................

			$('#'+this.idelem).css({
				margin: (typeof this.margin != 'undefined') ? this.margin : '12px 0 0 0',
				textAlign: 'center'
			});
			if (typeof this.margin_left == 'number'){$('#'+this.idelem).css({marginLeft: parseFloat(this.margin_left)+'px'});}

			$('#'+this.labelid).css({
				textAlign: 'center',
				font: 'bold 12px/12px arial',
				cursor: 'default',
				whiteSpace: 'nowrap'
			});

			$('#'+this.inputid).css({
				paddingTop: '0px',
				paddingBottom: '0px',
				paddingLeft: '3px',
				paddingRight: '3px',
				textAlign: (typeof this.text_align == 'string') ? this.text_align : 'center',
				font: 'bold 25px/12px arial',
				backgroundColor: 'transparent',
				border: this.border_input,
				borderRadius: 3
			});

			$('#'+this.unitid).css({
				textAlign: 'center',
				font: 'bold 12px/12px arial',
				cursor: 'default'
			});

			this.setStatus(1);
			//...........................................................................

			switch (this.mode)
			{
				case 'linear':
					this.low_fontsize = true;

					$('#'+this.labelid).css({
						display: (!this.label) ? 'none' : 'block',
						'min-width': (typeof this.label_width == 'number') ? this.label_width : '',	// si une largeur spécifique pour le label est spécifiée
						textAlign: 'left',
						paddingRight: '10px'
					});

					$('#'+this.unitid).css({
						display: (!this.unit) ? 'none' : 'block',
						textAlign: 'left',
						paddingLeft: '6px'
					});

					if (GIWIK._context.ie < 9)
					{
						$('#'+this.inputid).css({
							paddingTop: '2px'
						});

						if (GIWIK._context.ie == 7)
						{
							$('#'+this.idelem).css({
								textAlign: 'left'
							});
						}
					}
					break;

				case 'default':
					this.low_fontsize = (typeof this.low_fontsize == 'boolean') ? this.low_fontsize : true;

					// Style du tableau conteneur
					$('#'+this.idelem+' table').eq(0).css({
						marginLeft:'auto',
						marginRight:'auto'
					});

					$('#'+this.inputid).css({marginTop:'11px',paddingBottom:'1px'});
					$('#'+this.unitid).css({marginTop:'11px'});
					break;
			}

			$('#'+this.inputid).css({
				width: (typeof this.input_width == 'number') ? this.input_width : '81px'	// si une largeur spécifique pour l'input est spécifiée
			});

			// si le mode faible taille de police est activé
			if (this.low_fontsize == true)
			{
				$('#'+this.inputid).css({
					height: 22 - parseFloat($('#'+this.inputid).css('padding-top')) - parseFloat($('#'+this.inputid).css('padding-bottom')) - parseFloat($('#'+this.inputid).get(0).style.border.match(/(\d+)(px|em)/i)[0])*2,
					fontSize: '13px'
				});
			}

			// Correction de la largeur
			$('#'+this.inputid).css({
				width: parseFloat($('#'+this.inputid).css('width')) - parseFloat($('#'+this.inputid).css('padding-left')) - parseFloat($('#'+this.inputid).css('padding-right')) - parseFloat($('#'+this.inputid).get(0).style.border.match(/(\d+)(px|em)/i)[0])
			});

			eval("this.input_path.onkeydown = function (evt) {"+this.self+".__doOnKeyDown(evt ? evt : window.event/*pour IE8*/);};");
			eval("this.input_path.onkeyup   = function (evt) {"+this.self+".__doOnKeyUp(evt ? evt : window.event/*pour IE8*/);};");
			eval("this.input_path.onblur    = function ()    {"+this.self+".setValue("+this.self+".input_path.value, false, 'onblur');};");
			eval("this.input_path.onfocus   = function ()    {if("+this.self+".state === 1){"+this.self+".execActionOnFocus();}else{"+this.self+".input_path.blur();}};");

			this.disable();
			this.show();
		};

		this.setValue = function (value_precheck, no_action, event, key_code)
		{
			// Pour la touche "entrée" on blur le champ (ce qui va appeler automatiquement un setValue())
			if (key_code == 13)
			{
				this.input_path.blur();
				return;
			}

			// Si la valeur n'a pas changé
			if (event != 'onblur' && this.value === value_precheck)
			{
				return;
			}

			// Exécution de la fonction "garde-fou"
			if (this.execActionBefore(no_action) === false)
			{
				return false;
			}

			// Pour être sûr que val est de type "string"
			var val = ''+value_precheck;

			// Si une longueur de chaine max est définie
			if (typeof this.input_max_length == 'number')
			{
				this.input_path.maxLength = this.input_max_length;
				val = val.slice(0,this.input_path.maxLength);
			}

			if (this.input_regex)
			{
				val = val.replace(this.input_regex, '');
			}

			if (this.enable_novalue == true && trim(val) == '')
			{
				val = '';
			}

			// Si la valeur n'est pas valide ET qu'il s'agit d'une touche symbole, la valeur passe en rouge
			if (val != value_precheck && this.__isSymboleKey(key_code))
			{
				// Application de la couleur rouge
				this.setStatus(3);
			}
			else
			{
				// Sauvegarde de l'ancienne valeur pour pouvoir la comparer à la nouvelle
				this.old_value = ''+this.value;

				// Mise à jour de la valeur de l'objet avec la valeur vérifiée
				this.value = val;

				// Pour la touche "entrée" on blur le champ (ce qui va appeler automatiquement un setValue())
				if (key_code == 13)
				{
					this.input_path.blur();
					return;
				}
				// Pour l'initialisation automatique (par getConf()), l'évènement "onblur" et pour les actions flèche haute et basse, on remplace la valeur du champ par la valeur vérifiée
				else if (!key_code || in_array(key_code,[38,40]) || event == 'onblur')
				{
					this.input_path.value = this.value;
				}

				// Application de la couleur bleue
				this.setStatus(1);

				// Execution des actions si la valeur a changé
				if (this.value !== this.old_value)
				{
					this.execAction(no_action);

					this.__settingsModified(event);
				}

				// Si une action pour l'évènement "onblur" a été définie
				if (event == 'onblur')
				{
					this.execActionOnBlur(no_action);
				}
			}

			val = null;
		};

		// Méthode spécifique pour le cas d'un champ de type password qui est rempli automatiquement par le navigateur quand utilisé dans un formulaire HTML
		this.getValue = function ()
		{
			return (this.input_type == 'password') ? this.input_path.value : this.value;
		};
	};

	// Classe Input_select (menu déroulant)
	function Input_select (self, auto_activity)
	{
		this.self = self; 			// nom de l'instance
		this.idelem;				// Id de l'element dans lequel le select est instancie
		this.inputid;				// Id du select
		this.previd;				// Id du bouton "prev"
		this.nextid;				// Id du bouton "next"
		this.unit;					// Unite de la valeur
		this.label;					// Label du menu
		this.element_path;			// chemin DOM de cet element
		this.input_path;			// chemin DOM du select
		this.prev_path;				// Chemin DOM du bouton "prev"
		this.next_path;				// Chemin DOM du bouton "next"
		this._value;				// tableau contenant les valeurs des options
		this._text;					// tableau contenant les textes des options
		this._status;				// tableau contenant les statuts des options
		this.action = false;		// action lors d'un onchange
		this.mode = 'default';		// mode boutons prev/next (default) ou linéaire (linear)
		this.state;					// Definit l'etat de l'objet de saisie :	0  -> inactif,
									//											1  -> actif
		this.select_html;			// code HTML de la balise <select>
		this.options_html;			// code HTML des options
		this.options_number;		// nombre d'option contenues dans le select
		this.selected_option = -1;	// index de l'option selectionnée (0 -> option 1 etc. / par défaut aucune option n'est sélectionnée via la valeur "-1")
		this.selected_value;		// valeur de l'option selectionnée
		this.value;					// alias de this.selected_value
		this.selected_label;		// label de l'option selectionnée

		this.height = 22;			// height du conteneur du module
		this.label_width;			// width du label en mode "linear"
		this.input_width;			// longueur du menu déroulant (px)
		this.input_height = 22;		// hauteur du menu déroulant (px)
		this.low_fontsize;			// taille de la police (basse par défaut)
		this.font_size;				// taille de la police manuelle
		this.text_align;			// left par défaut
		this.margin;				// spécifie des marges pour le module (0px 0px 0px 0px)
		this.margin_left;			// spécifie une marge gauche

		this.onchange_setmod = true;// renvoie la variable settings_modified à true lors d'une modification (pour l'activations des boutons cancel/send)

		this.auto_enable = (auto_activity) ? true : false;	// Gestion automatique de la méthode "enable" via HEADING.setSettingsActivity() si "auto_activity" vaut "true"

		this.__setAutoActivity(auto_activity);
		//.............................................................................................................

		this.construct = function (id_element, mode, label, _value, _text, unit, onchange_setmod)
		{
			//......................................................
			this.idelem = id_element;
			this.selectctnrid = id_element+'_ctnr_';
			this.inputid 	  = id_element+'_input_';
			this.labelid 	  = id_element+'_label_';
			this.previd 	  = id_element+'_prev_';
			this.nextid 	  = id_element+'_next_';
			this.unitid 	  = id_element+'_unit_';
			this.mode = mode;
			this.label = (typeof label != "string") ? "undefined" : label;
			this._value = _value;
			this._text = _text;
			this.unit = unit;
			if (typeof onchange_setmod == 'boolean'){this.onchange_setmod = onchange_setmod;}
			this.element_path = document.getElementById(this.idelem);

			if (!this.element_path)
			{
				console.error(this.self+'.construct : DOM element "'+this.idelem+'" is missing');
				return false;
			}
			//.......................................................................

			var content = '';

			this.element_path.style.height = this.height+'px';

			var style_widthselect = '';

			if (typeof this.input_width == 'number')
			{
				style_widthselect = "width:"+(this.input_width+1)+"px;"; // +1 pour coller exactement à la propriéte input_width des objets Input_in et Input_text
			}

			this.text_align = (typeof this.text_align == 'string') ? this.text_align : 'left';

			switch (this.mode)
			{
				case 'linear':
					this.margin = (typeof this.margin != 'undefined') ? this.margin : '12px 0 0 0';
					this.select_html = '<select id="'+this.inputid+'" name="'+this.inputid+'" class="input_select_select" style="'
						+'height:'+this.input_height+'px;'
						+style_widthselect
						+((GIWIK._context.ie <= 8) ? 'padding-bottom:1px;padding-left:1px;' : '') // BUG IE <=8 : Correction alignement
					+'">';

					var label_style = '';

					label_style += 'text-align:left;';

					// Si une largeur spéciale du label à été définie
					if (typeof this.label_width == 'number')
					{
						label_style += 'width:'+(this.label_width+2)+'px;';
					}

					// Si aucun label passé on masque la cellule
					if (!this.label)
					{
						label_style += 'display:none;';
					}
					// Cas d'un label sur 2 lignes
					else if (this.label.match(/<br\s*\/?>/i))
					{
						label_style += 'top:-1px;';
						label_style += 'line-height:11px;';
					}

					content += '<table';
					if (typeof this.height != 'number'){content += ' class="input_select_ctnr"';}
					content += '><tr>';
						content += '<td class="label_linear" style="'+label_style+'"><div id="'+this.labelid+'">'+this.label+'</div></td>'
						content += '<td><div id="'+this.selectctnrid+'">'+this.select_html+this.options_html+'</select></div></td>';
						content += '<td class="unit_linear"'+ ((!this.unit) ? ' style="display:none"' : '')+'><div id="'+this.unitid+'">'+this.unit+'</div></td>'
					content += '</tr></table>';
					// Génération des boutons prev et next non affichés (différentes méthodes nécessitent leur existence DOM)
					content += '<div id="'+this.previd+'" class="displaynone" onclick="'+this.self+'.__goPrevOption();"></div>';
					content += '<div id="'+this.nextid+'" class="displaynone" onclick="'+this.self+'.__goNextOption();"></div>';

					this.element_path.innerHTML = content;


					//this.element_path.style.backgroundColor = "#FF0000";
					break;

				default:
					this.margin = (typeof this.margin != 'undefined') ? this.margin : '12px 0 0 0';

					this.select_html = '<select id="'+this.inputid+'" name="'+this.inputid+'" class="input_select_select" style="height:'+this.input_height+'px'+style_widthselect+';">';

					content += '<table class="input_select_ctnr">'
						+'<tr'+ ((!this.label) ? ' style="display:none"' : '')+'><td class="label" colspan="3"><div id="'+this.labelid+'" style="padding-right:10px;">'+this.label+'</div></td></tr>'
						+'<tr>'
							+'<td class="input_select_btn_ctnr"><div id="'+this.previd+'" class="input_select_prev"></div></td>'
							+'<td align="center" valign="middle"><div id="'+this.selectctnrid+'">'+this.select_html+this.options_html+'</select></div></td>'
							+'<td class="input_select_btn_ctnr" align=right><div id="'+this.nextid+'" class="input_select_next"></div></td>'
						+'</tr>'
						'<tr'+ ((!this.unit) ? ' style="display:none"' : '')+'><td class="unit" colspan="3"><div id="'+this.unitid+'">'+this.unit+'</div></td></tr>'
					+'</table>';

					this.element_path.innerHTML = content;
					break;
			}

			GIWIK.css.setClass(this.idelem,'input_select');

			this.element_path.style.margin = this.margin;
			if (typeof this.margin_left != 'undefined'){this.element_path.style.marginLeft = this.margin_left+'px';}

			//...................................................................................................................
			this.input_path  = document.getElementById(this.inputid);				// Chemin DOM du select
			this.selectctnrid_path = document.getElementById(this.selectctnrid);	// Chemin DOM du conteneur du select
			this.label_path = document.getElementById(this.labelid);				// Chemin DOM du label
			this.prev_path  = document.getElementById(this.previd);					// Chemin DOM du bouton "prev"
			this.next_path  = document.getElementById(this.nextid);					// Chemin DOM du bouton "next"
			this.unit_path  = document.getElementById(this.unitid);					// Chemin DOM de l'unité
			//...................................................................................................................

			this.setList(this._value, this._text);

			eval("this.input_path.onchange  = function ()    {"+this.self+".setValue("+this.self+"._value["+this.self+".input_path.selectedIndex], false, 'onchange');};");
			eval("this.input_path.onkeydown = function (evt) {"+this.self+".__doOnKeyDown(evt ? evt : window.event/*pour IE8*/);};");
			eval("this.input_path.onkeyup   = function (evt) {"+this.self+".__doOnKeyUp(evt ? evt : window.event/*pour IE8*/);};");
			eval("this.input_path.onblur    = function ()    {if("+this.self+".state === 1){"+this.self+".execActionOnBlur();}};");
			eval("this.input_path.onfocus   = function ()    {if("+this.self+".state === 1){"+this.self+".execActionOnFocus();}else{"+this.self+".input_path.blur();}};");

			eval("this.prev_path.onclick    = function ()    {"+this.self+".__goPrevOption();};");
			eval("this.next_path.onclick    = function ()    {"+this.self+".__goNextOption();};");

			this.disable();
			this.show();
		};

		// Initialise le module : definit l'option selectionnee à partir de sa valeur (no_action permet d'inhiber l'action lors d'un setValue --> utile pour la matrice des inputs)
		this.setValue = function (value, no_action, event, key_code)
		{
			// Pour la touche "entrée" on blur le champ (ce qui va appeler automatiquement un setValue())
			if (key_code == 13)
			{
				this.input_path.blur();
				return;
			}

			// Si la valeur n'a pas changé
			if (event != 'onblur' && this.value === value)
			{
				return;
			}

			// Exécution de la fonction "garde-fou"
			if (this.execActionBefore(no_action) === false)
			{
				return false;
			}

			//......................................................................................................................................
			this.value = (typeof value == 'string') ? trim(value) : value;	// Valeur de l'option sélectionnée
			this.selected_value = this.value;								// Obsolète, pour compatibilité uniquement
			//......................................................................................................................................

			// Si la valeur fournie est présente dans le tableau des valeurs dispo
			this.selected_option = array_search(this.value, this._value, true);

			// Si la valeur est absente, on ne sélectionne aucune valeur (-1)
			if (this.selected_option === false)
			{
				this.selected_option = -1;
				this.value = undefined;
				this.selected_value = this.value;
			}

			if (!in_array(event,['onchange','goprev','gonext']))
			{
				this.input_path.selectedIndex = this.selected_option;
			}

			// Label de l'option sélectionnée
			this.selected_label = this._text[this.selected_option];

			// Application de la couleur de chaque option
			this.setItemStatus(this._status);

			// Execution des actions si la valeur a changé
			if (this.value !== this.old_value)
			{
				this.execAction(no_action);

				this.__settingsModified(event);
			}
		};

		this.getValueLabel = function ()
		{
			return this._text[this.selected_option];
		};

		// Mise à jour des options (label et valeurs) [par défaut, les options sont ajoutées au select via javascript. l'option is_construct permet de renvoyer le code HTML des options pour la phase de construction.]
		this.setList = function (_value, _text, _status)
		{
			if (typeof _value == 'object')
			{
				this._value = _value;
				// Si aucun tableau de texte n'est transmis, les valeurs sont utilisées
				this._text = array_map(function(value){return trim(value);}, (typeof _text == 'object' && _text !== null) ? _text : this._value);


				// Si le low_fontsize n'a pas été défini
				if (this.low_fontsize === undefined)
				{
					var low_fontsize = false,
						text,
						i;

					// Si la liste des labels contient autre chose des nombres, on passe en taille de police basse
					for (i in this._text)
					{
						text = this._text[i];

						if (typeof text == 'string' && !text.match(/^([A-Z]{1,1})?\d+(\.\d+)?([A-Z]{1,1})?$/))
						{
							low_fontsize = true;
							break;
						}
					}
				}

				this.options_html = '';

				var num = this._value.length,
					nbsp_left = "",
					nbsp_right = "",
					value,
					text,
					status,
					i;

				// Pour Opera, ajout d'un espace au début de chaque option pour contrer l'absence de padding-left
				if (GIWIK._context.ie || GIWIK._context.presto)
				{
					nbsp_left += "&nbsp;";
				}

				// Pour FireFox, ajout d'un espace à la fin de chaque option pour contrer l'absence de padding-right
				if (GIWIK._context.ie || GIWIK._context.gecko || GIWIK._context.presto)
				{
					nbsp_right += "&nbsp;";
				}

				for (i=0; i<num; i++)
				{
					value  = trim(this._value[i]);
					text   = trim(this._text[i]);

					this.options_html += '<option value="'+value+'" style="padding-left:4px;text-align:'+this.text_align+';"';

					// S'il s'agit de l'option sélectionnée
					if (value === this.value) {this.options_html += ' SELECTED';}

					this.options_html += '>'+nbsp_left+text+nbsp_right+'</option>';
				}

				$('#'+this.inputid).html(this.options_html);

				// Définition de la taille de police et de l'alignement
				$('#'+this.inputid).css({
					'font': "bold "+(this.font_size ? this.font_size : (this.low_fontsize === true || low_fontsize === true) ? 13 : 15)+"px/18px arial",
					'text-align': this.text_align,
					'padding-left': (this.text_align == 'center' && GIWIK._context.gecko) ? '15px' : 0 // Début 2013, seul Firefox sait aligner le contenu d'un select au centre
				});

				//.........................................................................................................
				this.options_number = this.input_path.options.length;			// Nombre d'options du select
				//.........................................................................................................

				this.setItemStatus(_status);
			}
		};

		// Retourne toutes les valeurs, labels et statuts associés sous forme d'un tableau comprenant 3 sous-tableaux (valeurs, labels, statuts)
		this.getList = function ()
		{
			var _values = [],
				_labels = [],
				_status = [],
				i;

			for (i in this._value)
			{
				_values.push(this._value[i]);
				_labels.push(this._text[i]);
				_status.push(this._status[i]);
			}

			return {
				_values : _values,
				_labels : _labels,
				_status : _status
			};
		};

		// Mise en place d'un label de groupe à une position précise (sous forme de sélection jQuery "before" SANS l'id de l'objet,
		// ex. "option:eq(1)" pour placer un label de groupe avant la 2ème option) dans la liste définie par setList
		// si le label est vide, GIWIK considère qu'il s'agit d'un saut de ligne
		this.setGroup = function (label, position)
		{
			if (typeof label != 'string' || !position) {return false;}

			var colon = '',
				css   = '';

			// Si le label est vide
			if (label.match(/^\s*(&nbsp;)*\s*$/i))
			{
				label = '&nbsp;';
				css   = ' class="linebreak"';
			}
			else
			{
				colon = ' :';
			}

			// Insertion du label de groupe à la position définie via l'argument "position"
			$('#'+this.idelem+' '+position).before('<optgroup label="'+label+colon+'"'+css+'></optgroup>');
		};

		// Affecte une couleur de statut à chaque option
		this.setItemStatus = function (_status)
		{
			// Si aucun tableau de statuts n'est transmis, on utilise le statut 1 pour toutes les valeurs
			this._status = (typeof _status == 'object') ? _status : array_map(function(value){return 1;}, this._value);

			var status,
				nth_child;

			// 1- On applique une couleur à tout le select en fonction de la valeur courante (va affecter aussi les options)
			if (this.selected_option !== -1)
			{
				var current_value_status = (typeof this._status[this.selected_option] == 'number') ? this._status[this.selected_option] : 1;

				this.setStatus(current_value_status);
			}

			// 2- Une fois la couleur du select appliquée, on applique une couleur à chaque option (ne fonctionne que sous Firefox et IE)
			for (var i in this._value)
			{
				status = (typeof this._status[i] == 'number') ? this._status[i] : 1;	// si le statut n'existe pas pour l'option, on le met à 1
				nth_child = parseInt(i)+1;

				$('#'+this.idelem+' option:nth-child('+nth_child+')').css('color', GIWIK.css['color_'+status]);
			}
		};

		// Retourne la liste des statuts des options
		this.getOptionStatus = function (_status)
		{
			return this._status;
		};

		this.__enableSpecific = function ()
		{
			$('#'+this.inputid).css('cursor','pointer');
		};

		this.__setStatusSpecific = function (status)
		{
			$('#'+this.inputid).css('border-color',GIWIK.css['color_'+status]);
		};

		this.__doOnKeyUpSpecific = function (key_code)
		{
			// Si touche entrée ou flèches directionnelles
			if (in_array(key_code,[13,37,38,39,40]))
			{
				if (this.input_path.selectedIndex != this.selected_option || key_code == 13)
				{
					this.setValue(this._value[this.input_path.selectedIndex], false, 'onkeyup', key_code);
				}
			}
		};

		// Selectionne l'option suivante
		this.__goPrevOption = function ()
		{
			// Aucune action si le controle est désactivé
			if (this.state !== 1)
			{
				return;
			}

			// Si on ne se trouve pas deja a la premiere option
			if (this.selected_option > 0)
			{
				this.input_path.selectedIndex--;	// Ne déclanche pas l'évènement "change"
				this.setValue(this._value[this.input_path.selectedIndex], false, 'goprev');
			}
		};

		// Selectionne l'option precedente
		this.__goNextOption = function ()
		{
			// Aucune action si le controle est désactivé
			if (this.state !== 1)
			{
				return;
			}

			// Si on ne se trouve pas deja a la derniere option
			if (this.selected_option < this._value.length-1)
			{
				this.input_path.selectedIndex++;	// Ne déclanche pas l'évènement "change"
				this.setValue(this._value[this.input_path.selectedIndex], false, 'gonext');
			}
		};
	};

	// Classe Input_radio (bouton radio) [les différents objets d'un même groupe doivent être nommés de façon croissante Radio_xxxx0 Radio_xxxx1 etc en partant de 0]
	function Input_radio (self, auto_activity)
	{
		this.self = self;			// nom de l'instance
		this.idelem;				// Id de l'element conteneur dans lequel le select est instancie
		this.inputid;				// Id du bouton radio
		this.labelid;				// Id du label
		this.group_name				// nom du groupe (balise "name") auquel le bouton radio appartient

		this.label;					// label
		this.element_path;			// chemin DOM de l'élément conteneur
		this.input_path;			// chemin DOM du bouton radio
		this.label_path;			// chemin DOM du label

		this.action = false;		// action lors d'un clic
		this.mode = 'default';		// mode d'affichage (default ou linear)
		this.state;	 				// Definit l'etat du radio :	0  -> inactif,
													//				1  -> actif
		this.option_value;			// valeur propre du bouton radio

		this.height = 22;			// hauteur du conteneur
		this.label_width;	// width du label en mode "linear"
		this.padding_label_linear;	// padding du label en mode "linear"
		this.margin;				// spécifie des marges pour le module (0px 0px 0px 0px)
		this.margin_left;			// spécifie une marge gauche

		this.onchange_setmod = true;// renvoie la variable settings_modified à true lors d'une modification (pour l'activations des boutons cancel/send)

		this.auto_enable = (auto_activity) ? true : false;	// Gestion automatique de la méthode "enable" via HEADING.setSettingsActivity() si "auto_activity" vaut "true"

		this.__setAutoActivity(auto_activity);
		//.............................................................................................................


		this.construct = function (id_element, group_name, mode, label, value, onchange_setmod)
		{
			//......................................................
			this.idelem = id_element;
			this.group_name = group_name;
			this.inputid = id_element+'_input_';
			this.labelid = id_element+'_label_';
			this.mode = mode;
			this.label = label;
			this.option_value = value;

			this.onchange_setmod = onchange_setmod;
			this.element_path = document.getElementById(this.idelem);

			if (!this.element_path)
			{
				console.error(this.self+'.construct : DOM element "'+this.idelem+'" is missing');
				return false;
			}
			//......................................................

			var content = ''

			+'<table class="input_radio_ctnr"><tr>'
				+'<td><input type="radio" id="'+this.inputid+'" name="'+this.group_name+'" value="'+this.option_value+'" /></td>'
				+((this.mode == 'linear') ? '' : '</tr><tr>')
				+'<td><label for="'+this.inputid+'" id="'+this.labelid+'">'+this.label+'</label></td>'
			+'</tr></table>';

			this.element_path.innerHTML = content;

			// Styles ...............................................................................................
			$('#'+this.idelem).css({
				'height': this.height,
				'cursor': 'default',
				'margin': (typeof this.margin != 'undefined') ? this.margin : '12px 0 0 '+(this.mode == 'linear' ? '-20' : '0')+'px' // mode linear : marge négative pour alignement sur le label
			});
			if (typeof this.margin_left == 'number'){$('#'+this.idelem).css({marginLeft: parseFloat(this.margin_left)+'px'});}

			$('#'+this.idelem+' td').css({
				'height': this.height,
				'vertical-align': 'middle',
				'text-align': 'center'
			});

			$('#'+this.labelid).css({
				'display': (this.label == '') ? 'none' : '',
				'font': 'normal 12px arial'
			});

			this.setStatus(1);

			if (this.mode == 'linear')
			{
				$('#'+this.inputid).css({
					'margin-top': '2px'
				});

				$('#'+this.idelem+' td').css({
					'text-align': 'left'
				});

				$('#'+this.inputid).closest('td').css({
					'width': '20px'
				});

				$('#'+this.labelid).css({
					'white-space': 'nowrap',
					'width': (typeof this.label_width == 'number') ? this.label_width : ''
				});
			}
			else
			{
				$('#'+this.idelem+' td').css({
					'text-align': 'center'
				});
			}

			//.........................................................................................................
			this.input_path  = document.getElementById(this.inputid);		// Chemin DOM du bouton radio
			this.label_path  = document.getElementById(this.labelid);		// Chemin DOM du label
			//.........................................................................................................

			eval("this.input_path.onchange  = function ()    {"+this.self+".setValue("+this.self+".option_value, false, 'onchange');};");
			eval("this.input_path.onkeydown = function (evt) {"+this.self+".__doOnKeyDown(evt ? evt : window.event/*pour IE8*/);};");
			eval("this.input_path.onkeyup   = function (evt) {"+this.self+".__doOnKeyUp(evt ? evt : window.event/*pour IE8*/);};");
			eval("this.input_path.onblur    = function ()    {if("+this.self+".state === 1){"+this.self+".execActionOnBlur();}};");
			eval("this.input_path.onfocus   = function ()    {if("+this.self+".state === 1){"+this.self+".execActionOnFocus();}else{"+this.self+".input_path.blur();}};");

			// VS BUG IE8 qui ne déclanche l'évènement "change" que lors de la perte du focus
			if (GIWIK._context.ie <= 8){this.input_path.onclick = this.input_path.onchange;}

			this.disable();
			this.show();
		};

		// Initialise le module : definit l'option selectionnee à partir de sa valeur
		this.setValue = function (value, no_action, event, key_code)
		{
			// Pour la touche "entrée" on blur le champ (ce qui va appeler automatiquement un setValue())
			if (key_code == 13)
			{
				this.input_path.blur();
				return;
			}

			// Si le radio ne doit pas être sélectionné
			if (this.option_value !== value)
			{
			 	return;
			}

			// Exécution de la fonction "garde-fou"
			if (this.execActionBefore(no_action) === false)
			{
				return false;
			}

			// Sélection du radio
			this.input_path.checked = true;


			// Mise à jour de l'apparence des autres labels du groupe (ceux non cochés)
			var _radio = document.getElementsByName(this.group_name);
			var radio_length = _radio.length;

			var raw_object_name = this.__getObjectName();
			var object_name = '';

			for (var i=0; i<radio_length; i++)
			{
				object_name = raw_object_name+i;

				// Si la valeur du radio correspond
				if (window[object_name].option_value === value)
				{
					// Sélection du radio
					window[object_name].input_path.checked = true;

					// Mise en évidence du label coché
					window[object_name].label_path.style.fontWeight = 'bold';
				}
				else
				{
					window[object_name].label_path.style.fontWeight = 'normal';
				}
			}

			// Execution des actions
			this.execAction(no_action);

			this.__settingsModified(event);
		};

		// Retourne la valeur d'un groupe de boutons radio
		this.getValue = function ()
		{
			var _radio = document.getElementsByName(this.group_name);
			var radio_length = _radio.length;

			for (var i=0; i<radio_length; i++)
			{
				if (_radio[i].checked == true)
				{
					return eval(this.__getObjectName(i)).option_value;
				}
			}
		};

		this.__enableSpecific = function ()
		{
			$('#'+this.labelid+',#'+this.inputid).css('cursor','pointer');
		};

		this.__doOnKeyUpSpecific = function (key_code)
		{
			// Si la touche est "entrée", on lance un setValue qui va lancer un blur
			if (key_code == 13)
			{
				this.setValue(this.option_value, false, 'onkeyup', key_code);
			}
		};

		// Nom de l'objet. Si pas d'id passé, renvoie le nom brut (sans l'int en fin de son nom)
		this.__getObjectName = function (i)
		{
			return this.self.replace(/[0-9]+$/gi, (typeof i == 'number') ? i : '');
		};
	};

	// Classe Input_checkbox (case à cocher)
	function Input_checkbox (self, auto_activity)
	{
		this.self = self;		// nom de l'instance
		this.idelem;			// Id de l'element conteneur dans lequel le select est instancie
		this.inputid;			// Id de la case à cocher

		this.label;				// label
		this.element_path;		// chemin DOM de l'élément conteneur
		this.input_path;      	// chemin DOM de la case à cocher

		this.action = false;	// action lors d'un clic
		this.mode = 'default';	// mode d'affichage (default ou linear)
		this.state;	 			// Definit l'etat de la case à cocher :	0  -> inactif,
								//					1  -> actif
		this._value;			// tableau des deux valeurs possibles [unchecked, checked]
		this.value;				// valeur courante de la checkbox (enfonction de son état cochée/décochée)
		this.selected_value;	// IDEM

		this.width = 25;		// largeur du conteneur
		this.height = 22;		// hauteur du conteneur
		this.label_width;		// width du label en mode "linear"
		this.margin;			// spécifie des marges pour le module (0px 0px 0px 0px)
		this.margin_left;		// spécifie une marge gauche
		this.low_fontsize;		// permet d'afficher une taille de police plus faible en mode "linear"

		this.onchange_setmod = true;	// renvoie la variable settings_modified à true lors d'une modification (pour l'activations des boutons cancel/send)

		this.auto_enable = (auto_activity) ? true : false;	// Gestion automatique de la méthode "enable" via HEADING.setSettingsActivity() si "auto_activity" vaut "true"

		this.__setAutoActivity(auto_activity);
		//.............................................................................................................


		this.construct = function (id_element, mode, label, _value, onchange_setmod)
		{
			//......................................................
			this.idelem = id_element;
			this.mode   = mode;

			this.label = label;
			this.labelid = id_element+'_label_';
			this.inputid = id_element+'_input_';

			this.element_path = document.getElementById(this.idelem);

			if (typeof onchange_setmod != 'undefined'){this.onchange_setmod = onchange_setmod;}

			if (typeof this.readonly != 'boolean'){this.readonly = false;}

			this._value = _value;

			if (!this.element_path)
			{
				console.error(this.self+'.construct : DOM element "'+this.idelem+'" is missing');
				return false;
			}
			//......................................................

			var tmp = ''
			+'<table>'
				+'<tr>'
					+'<td><label id="'+this.labelid+'" for="'+this.inputid+'">'+this.label+'</label></td>'
					+(this.mode != 'linear' ? '</tr><tr>' : '')
					+'<td><input type="checkbox" id="'+this.inputid+'" name="'+this.inputid+'" value=""></td>'
				+'</tr>'
			+'</table>';

			this.element_path.innerHTML = tmp;

			//...........................................................................
			this.label_path   = document.getElementById(this.labelid);
			this.input_path   = document.getElementById(this.inputid);
			//...........................................................................

			$('#'+this.idelem).css({
				'height': this.height,
				margin: (typeof this.margin != 'undefined') ? this.margin : '12px 0 0 0',
				textAlign: 'center'
			});
			if (typeof this.margin_left == 'number'){$('#'+this.idelem).css({marginLeft: parseFloat(this.margin_left)+'px'});}

			$('#'+this.labelid).css({
				textAlign: 'center',
				font: 'bold 12px/12px arial',
				cursor: 'default',
				whiteSpace: 'nowrap'
			});

			this.setStatus(1);
			//...........................................................................


			switch (this.mode)
			{
				case 'linear':
					this.low_fontsize = true;

					$('#'+this.labelid).css({
						display: (!this.label) ? 'none' : 'block',
						'min-width': (typeof this.label_width == 'number') ? this.label_width : '',	// si une largeur spécifique pour le label est spécifiée
						textAlign: 'left',
						paddingRight: '10px'
					});
					break;

				default:
					this.low_fontsize = (typeof this.low_fontsize == 'boolean') ? this.low_fontsize : true;

					// Style du tableau conteneur
					$('#'+this.idelem+' table').eq(0).css({
						marginLeft:'auto',
						marginRight:'auto'
					});

					$('#'+this.labelid).css({marginTop:'11px'});
					break;

			}

			if (GIWIK._context.ie < 9)
			{
				if (GIWIK._context.ie == 7)
				{
					$('#'+this.idelem).css({
						textAlign: 'left'
					});
				}
			}

			// si le mode faible taille de police est activé
			if (this.low_fontsize == true)
			{
				$('#'+this.inputid).closest('td').css({
					paddingTop: '3px',
					paddingBottom: '0px',
					height: this.height - parseFloat($('#'+this.inputid).closest('td').css('padding-top')) - parseFloat($('#'+this.inputid).closest('td').css('padding-bottom')),
					verticalAlign:'middle'
				});
			}

			// VS bug IE8
			if (GIWIK._context.ie < 9)
			{
				eval("this.input_path.onclick  = function ()    {"+this.self+".setValue("+this.self+".input_path.checked ? "+this.self+"._value[1] : "+this.self+"._value[0], false, 'onchange');};");
			}
			else
			{
				eval("this.input_path.onchange  = function ()    {"+this.self+".setValue("+this.self+".input_path.checked ? "+this.self+"._value[1] : "+this.self+"._value[0], false, 'onchange');};");
			}

			eval("this.input_path.onkeydown = function (evt) {"+this.self+".__doOnKeyDown(evt ? evt : window.event/*pour IE8*/);};");
			eval("this.input_path.onkeyup   = function (evt) {"+this.self+".__doOnKeyUp(evt ? evt : window.event/*pour IE8*/);};");
			eval("this.input_path.onblur    = function ()    {if("+this.self+".state === 1){"+this.self+".execActionOnBlur();}};");
			eval("this.input_path.onfocus   = function ()    {if("+this.self+".state === 1){"+this.self+".execActionOnFocus();}else{"+this.self+".input_path.blur();}};");

			this.disable();
			this.show();
		};

		// Initialise le module : definit l'option selectionnee à partir de sa valeur
		this.setValue = function (value, no_action, event, key_code)
		{
			// Pour la touche "entrée" on blur le champ (ce qui va appeler automatiquement un setValue())
			if (key_code == 13)
			{
				this.input_path.blur();
				return;
			}

			// Si la valeur n'a pas changé
			if (this.value === value)
			{
			 	return;
			}

			// Exécution de la fonction "garde-fou"
			if (this.execActionBefore(no_action) === false)
			{
				return false;
			}

			//.........................................................................................................................
			if (in_array(value, this._value, true)){this.value = value;}
			else{this.value = this._value[0];}

			// Pour compatibilité
			this.selected_value = this.value;
			//.........................................................................................................................

			if (!event)
			{
				// Cochage de la case
				this.input_path.checked = (this.value === this._value[1]) ? true : false;
			}

			// Execution des actions
			this.execAction(no_action);

			this.__settingsModified(event);
		};

		this.__enableSpecific = function ()
		{
			$('#'+this.labelid+',#'+this.inputid).css('cursor','pointer');
		};

		this.__doOnKeyUpSpecific = function (key_code)
		{
			// Si la touche est "entrée", on lance un setValue qui va lancer un blur
			if (key_code == 13)
			{
				this.setValue(this.option_value, false, 'onkeyup', key_code);
			}
		};
	};

	// Classe Input_file (chargement de fichier)
	function Input_file (self, auto_activity)
	{
		this.self = self;				// nom de l'instance
		this.idelem;					// Id de l'element dans lequel l'input est instancie
		this.inputctnrid;				// Id du conteneur de l'input
		this.inputid;					// Id de l'input file
		this.label;						// Label du menu
		this.element_path;				// chemin DOM du conteneur global
		this.input_path;				// chemin DOM de l'input
		this.inputctnr_path;			// chemin DOM du conteneur de l'input
		this.action = false;			// action lors d'un onchange
		this.form_name;					// nom du formulaire
		this.form_action;				// url de destination du formulaire
		this.input_name;				// nom de l'input
		this.state;						// Definit l'etat du controle :	0 -> inactif, 1  -> actif
		this.value = "";				// Valeur du champ (chemin du fichier sélectionné)
		this.label_width;				// width du label en mode "linear"
		this.size_input = 22;			// longueur de l'input (pour FF qui ne comprend pas le style width, pas en px !)
		this.width_input = 268;			// longueur de l'input (px)
		this.height_input = 20;			// hauteur de l'input (px)
		this.font_size = 13;			// taille de la police (13[px] par défaut)
		this.margin;					// spécifie des marges pour le module (0px 0px 0px 0px)
		this.margin_left;				// spécifie une marge gauche

		this.onchange_setmod = true;	// renvoie la variable settings_modified à true lors d'une modification (pour l'activations des boutons cancel/send)

		this.auto_enable = (auto_activity) ? true : false;	// Gestion automatique de la méthode "enable" via HEADING.setSettingsActivity() si "auto_activity" vaut "true"

		this.__setAutoActivity(auto_activity);
		//.............................................................................................................

		this.construct = function (id_element, label, _value, onchange_setmod)
		{
			//......................................................
			this.idelem			 = id_element;
			this.inputctnrid	 = id_element+'_ctnr_';
			this.inputid		 = id_element+'_input_';
			this.labelid 		 = id_element+'_label_';
			this.maskid 		 = id_element+'_mask_';
			this.input_name		 = _value.input_name;
			this.label			 = label;
			this.form_name		 = _value.form_name;
			this.form_action	 = _value.form_action;
			this.onchange_setmod = onchange_setmod;
			this.element_path	 = document.getElementById(this.idelem);

			if (!this.element_path)
			{
				console.error(this.self+'.construct : DOM element "'+this.idelem+'" is missing');
				return false;
			}
			//......................................................

			var content = '';

			// + 2 pour IE car il compte les 2px de bordure dans la hauteur
			if (GIWIK._context.ie < 9){this.height_input += 2;}

			var label_style = '';

			label_style += 'text-align:left;';

			// Si une largeur spéciale du label à été définie
			if (typeof this.label_width == 'number')
			{
				label_style += 'min-width:'+this.label_width+'px;';
			}

			// Cas d'un label sur 2 lignes
			if (this.label.match(/<br\s*\/?>/i))
			{
				label_style += 'top:-1px;';
				label_style += 'line-height:12px;';
			}

			this.margin = (typeof this.margin != 'undefined') ? this.margin : '12px 0 0 0';

			content += '<form name="'+this.form_name+'" method="post" enctype="multipart/form-data">';

			content += '<table class="input_file_ctnr" style="margin:'+this.margin+';'+((typeof this.margin_left != 'undefined') ? 'margin-left:'+this.margin_left+'px;' : '')+'"><tr>';
				if (this.label != ''){content += '<td class="label" style="'+label_style+'"><div id="'+this.labelid+'">'+this.label+'</div></td>';}
				content += '<td class="input"><div id="'+this.inputctnrid+'">';
						content += '<input type="file" id="'+this.inputid+'" name="'+this.input_name+'" class="input_file" size="'+this.size_input+'" style="width:'+this.width_input+'px;font-size:'+this.font_size+'px;" />';
						content += '<div id="'+this.maskid+'" style="height:'+(this.height_input+4)+'px;width:108%;position:relative;margin-top:-'+(this.height_input+4)+'px"> </div>'
				content += '</div></td>';
			content += '</tr></table>';

			content += '</form>';


			this.element_path.innerHTML = content;

			//...................................................................................................................
			this.inputctnr_path = document.getElementById(this.inputctnrid);	// Chemin DOM du conteneur de l'input
			this.label_path     = document.getElementById(this.labelid);		// Chemin DOM du label
			this.input_path     = document.getElementById(this.inputid);		// Chemin DOM de l'input
			this.mask_path      = document.getElementById(this.maskid);			// Chemin DOM du masque
			//...................................................................................................................

			// Bug IE sur la hauteur trop faible de l'input
			if (GIWIK._context.ie < 9){this.input_path.style.height = '22px';}

			// Affectation de l'action du formulaire
			this.setFormAction(this.form_action);

			eval("this.input_path.onchange  = function ()    {"+this.self+".setValue("+this.self+".input_path.value, false, 'onchange');};");
			eval("this.input_path.onkeydown = function (evt) {"+this.self+".__doOnKeyDown(evt ? evt : window.event/*pour IE8*/);};");
			eval("this.input_path.onkeyup   = function (evt) {"+this.self+".__doOnKeyUp(evt ? evt : window.event/*pour IE8*/);};");
			eval("this.input_path.onblur    = function ()    {if("+this.self+".state === 1){"+this.self+".execActionOnBlur();}};");
			eval("this.input_path.onfocus   = function ()    {if("+this.self+".state === 1){"+this.self+".execActionOnFocus();}else{"+this.self+".input_path.blur();}};");

			eval("this.input_path.onclick   = function ()    {if("+this.self+".state === 1){}else{"+this.self+".input_path.blur();return false;}};");

			this.disable();
			this.show();
		};

		// Mise à jour de l'index et de la valeur de l'option sélectionnée lors d'un évènement "onchange"
		this.setValue = function (value, no_action, event, key_code)
		{
			// Pour la touche "entrée" on blur le champ (ce qui va appeler automatiquement un setValue())
			if (key_code == 13)
			{
				this.input_path.blur();
				return;
			}

			// Si la valeur n'a pas changé
			if (this.value === value)
			{
			 	return;
			}

			// Exécution de la fonction "garde-fou"
			if (this.execActionBefore(no_action) === false)
			{
				return false;
			}

			if (event == 'onchange')
			{
				// Sauvegarde du nom du fichier sous forme encodée pour pouvoir passer directement la valeur dans une URL (le "match()" sert à supprimer les inutiles "C:\fake_path\" retournés par Opera et IE avant le nom de fichier)
				this.value = encodeURIComponent(this.input_path.value.match(/[^\/\\]+$/gi));
			}
			else
			{
				// La valeur d'un input file ne peut pas être définie par JavaScript, seulement vidée (raisons de sécurité)
				this.value = "";
				this.input_path.value = this.value;
			}

			this.execAction(no_action);

			this.__settingsModified(event);
		};

		// Définition de l'action du formulaire, c'est à dire de l'url de destination
		this.setFormAction = function (form_action)
		{
			this.form_action = form_action;

			document[this.form_name].action = this.form_action;
		};

		this.__enableSpecific = function ()
		{
			$('#'+this.inputid).css('cursor','pointer');
			$('#'+this.maskid).css('display','none');		// désactivation du masque
		};

		this.__disableSpecific = function ()
		{
			$('#'+this.maskid).css('display','block');		// activation du masque pour empêcher le clic sur l'input
		};
	};

	// Classe Input_latlong (gestion des notations de latlong)
	function Input_latlong (self, auto_activity)
	{
		this.self = self;				// nom de l'instance
		this.idelem;					// id de l'élément dans lequel le potentiometre est généré
		this.type;						// "latitude" ou "longitude"
		this.hemisphere;				// gestion de la saisie de l'hémisphère (N/S ou E/W en fonction du type) true par défaut
		this.object_basename;
		this.id_element;
		this.action = false;
		this.element_path;				// chemin DOM de cet element
		this.state;						// définit l'etat de l'input : 1 -> clicable, 0 -> inactif
		this.readonly;					// le champ est-il en lecture seule
		this.d_min_value;
		this.d_max_value;
		this.m_min_value;
		this.m_max_value;
		this.s_min_value;
		this.s_max_value;
		this._childObjects = [];		// contient tous les noms des enfants de l'objet
		this.precision;					// nombre entier
		this.precision_num_decimals;	// nbre de décimales sur la notation degrés décimaux
		this.label_width;				// width du label en mode "linear"

		this.onchange_setmod = true;	// renvoie la variable settings_modified à true lors d'une modification (pour l'activations des boutons cancel/send)

		this.__setAutoActivity(auto_activity);

		// Construction d'un bloc de saisie de latitude ou de longitude en fonction de la notation courante (la précision à fournir est celle des "degrés décimaux")
		this.construct = function (id_element, label, precision, type, hemisphere, onchange_setmod)
		{
			this.type                   = type;
			this.hemisphere             = (typeof hemisphere == 'boolean') ? hemisphere : true;		// true par défaut
			this.object_basename        = this.self;
			this.id_element             = id_element;
			this.idelem                 = id_element;
			this.element_path           = document.getElementById(this.idelem);
			this.precision              = precision;		// nombre entier
			this.precision_num_decimals = count_decimals(this.precision);
			this.onchange_setmod        = onchange_setmod;

			if (!this.element_path)
			{
				console.error(this.self+'.construct : DOM element "'+this.idelem+'" is missing');
				return false;
			}

			var input_min_value,
				input_max_value,
				html = "",
				object_name,
				unit,
				unit_label,
				input_label,
				input_num_decimals,
				num_decimals = count_decimals(this.precision),
				input_width,
				_hemisphere = [],
				input_margin_left,
				_inputs = [];

			// On s'assure qu'il s'agit bien d'une latitude ou d'une longitude
			if (!in_array(this.type, ['latitude','longitude']))
			{
				return false;
			}

			switch (GIWIK.latlong_notation)
			{
				case 'd'  : 					break;
				case 'dm' : num_decimals -= 2;	break;
				case 'dms': num_decimals -= 4;	break;

				default   : alert('Error : "GIWIK.latlong_notation" is not defined yet\n"'+this.self+'" might be set in "HEADING.readConf" instead of "HEADING.construct"'); return; break;
			}

			// Stockage de chaque champ à créer
			for (var i=0; i<GIWIK.latlong_notation.length; i++)
			{
				letter = GIWIK.latlong_notation[i];
				if (in_array(letter, ['d','m','s']))
				{
					_inputs.push(letter);
				}
			}
			_inputs.push('h');	// Ajout de l'hémisphère


			// Si latitude
			if (this.type == 'latitude')
			{
				this.d_min_value = 0;
				this.d_max_value = 90;
				_hemisphere = ['N','S'];
			}
			// Si longitude
			else if (this.type == 'longitude')
			{
				this.d_min_value = 0;
				this.d_max_value = 180;
				_hemisphere = ['E','W'];
			}
			else
			{
				return;
			}

			// Contruction du code HTML voué à accueillir les objets
			html += '<table><tr>';

			for (var i in _inputs)
			{
				letter = _inputs[i];
				html += '<td><div id="'+this.id_element+'_'+letter+'"></div></td>';
			}

			html += '</tr></table>';
			$('#'+this.id_element).html(html);

			// Instanciation des objets
			for (var i in _inputs)
			{
				letter = _inputs[i];
				object_name = this.object_basename+'_'+letter;

				// Stockage des noms des objets enfants et de l'id de leur élément conteneur
				this._childObjects[this.id_element+'_'+letter] = object_name;

				if (letter == 'h')
				{
					window[object_name] = new Input_select(object_name, auto_activity);
					window[object_name].margin = '0 0 0 4px';
					window[object_name].construct(this.id_element+'_'+letter,'linear','',_hemisphere,_hemisphere,'',this.onchange_setmod);
					window[object_name][(this.hemisphere === false) ? 'hide' : 'show']();
					continue;
				}

				input_label = (letter == 'd') ? label : '';
				input_num_decimals = 0;
				unit = '';
				unit_label = '';
				input_margin_left = 0;

				switch (letter) {
					case 'd':
						if (GIWIK.latlong_notation == 'd')
						{
							input_num_decimals = num_decimals;
							input_width = 44 + (11 * input_num_decimals);
						}
						else
						{
							input_width = 34;
						}
						unit = 'degree';
						input_margin_left = 0;
						input_min_value = this.d_min_value;
						input_max_value = this.d_max_value;
						break;
					case 'm':
						if (GIWIK.latlong_notation == 'dm')
						{
							input_num_decimals = num_decimals;
							input_width = 34 + (11 * input_num_decimals);
							this.m_max_value = 60 - Math.pow(10,-input_num_decimals);
						}
						else
						{
							input_width = 34;
							this.m_max_value = 59;
						}
						unit = 'minute_latlong';
						input_margin_left = 3;
						this.m_min_value = 0;
						input_min_value = this.m_min_value;
						input_max_value = this.m_max_value;
						break;
					case 's':
							input_num_decimals = num_decimals;
							unit = 'second_latlong';
							input_width = 34 + (11 * input_num_decimals);
							input_margin_left = 3;
							this.s_min_value = 0;
							this.s_max_value = 60 - Math.pow(10,-input_num_decimals);
							input_min_value = this.s_min_value;
							input_max_value = this.s_max_value;
						break;
					case 'h':
						break;
				}

				unit_label = unit ? MSG(['units',unit]) : '';

				if (unit_label)
				{
					if (letter == 'd')
					{
						unit_label = '<span style="font-size:16px;">'+unit_label+'</span>';
					}
					else if (in_array(letter,['m','s']))
					{
						unit_label = '<span style="font-size:18px;font-weight:bold;">'+unit_label+'</span>';
					}
				}

				window[object_name] = new Input_int(object_name, auto_activity);
				if (letter == 'd' && this.label_width){window[object_name].label_width = this.label_width;}
				window[object_name].input_width = input_width;
				window[object_name].margin = '0 0 0 '+input_margin_left+'px';
				window[object_name].construct(this.id_element+'_'+letter,'linear',input_label,Math.pow(10,-input_num_decimals),input_min_value,input_max_value,unit_label,1,this.onchange_setmod);
				window[object_name].show();

				// Réduction de l'espace par défaut se trouvant entre l'input et son unité
				$('#'+this.id_element+'_'+letter+'_unit_').css('padding-left','2px');
			}

			$('#'+this.idelem).css({margin: (typeof this.margin != 'undefined') ? this.margin : '12px 0 0 0'});

			if (typeof this.margin_left == 'number'){$('#'+this.idelem).css({marginLeft: parseFloat(this.margin_left)+'px'});}
		};

		this.setValue = function (value, no_action, event, key_code)
		{
			var object_name;

			// Si la valeur n'est pas un nombre, elle prend la valeur 0 par défaut
			if (isNaN(value))
			{
				value = 0;
			}

			// Si l'hémisphère n'est pas gérée, la valeur doit toujours être positive
			if (this.hemisphere === false && value < 0)
			{
				value = value * -1;
			}

			// Création d'un tableau de valeurs (fonction de la notation lat/long courante) à partir d'une position en degrés
			var _split = GIWIK.data.coordinates.latlong.d2dmdms(this.type,value,{precision:this.precision_num_decimals}).match(GIWIK.data.coordinates.latlong._regexp[GIWIK.latlong_notation]);

			switch (GIWIK.latlong_notation)
			{
				case 'd'  : var _return = {d:parseFloat(_split[1]+'.'+_split[2]),h:_split[3]}; break;
				case 'dm' : var _return = {d:parseFloat(_split[1]),m:parseFloat(_split[2]+'.'+_split[3]),h:_split[4]}; break;
				case 'dms': var _return = {d:parseFloat(_split[1]),m:parseFloat(_split[2]),s:parseFloat(_split[3]+'.'+_split[4]),h:_split[5]}; break;
			}

			for (var letter in _return)
			{
				object_name = this.object_basename+'_'+letter;
				value = _return[letter];
				window[object_name].setValue(value, no_action, event, key_code);
			}
		};

		this.getValue = function ()
		{
			switch (GIWIK.latlong_notation)
			{
				case 'd'  : var value = window[this.object_basename+'_d'].getValue()+'°'+window[this.object_basename+'_h'].getValue(); break;
				case 'dm' : var value = window[this.object_basename+'_d'].getValue()+'°'+window[this.object_basename+'_m'].getValue()+'\''+window[this.object_basename+'_h'].getValue(); break;
				case 'dms': var value = window[this.object_basename+'_d'].getValue()+'°'+window[this.object_basename+'_m'].getValue()+'\''+window[this.object_basename+'_s'].getValue()+'"'+window[this.object_basename+'_h'].getValue(); break;
			}

			return GIWIK.data.coordinates.latlong.dms2d(this.type, value, {precision:this.precision_num_decimals});
		};

		this.setStatus = function (status)
		{
			for (var id in this._childObjects)
			{
				window[this._childObjects[id]].setStatus(status);
			}
		};

		this.enable = function ()
		{
			for (var id in this._childObjects)
			{
				window[this._childObjects[id]].enable();
			}
		};

		this.disable = function ()
		{
			for (var id in this._childObjects)
			{
				window[this._childObjects[id]].disable();
			}
		};

		this.__checkValue = function ()
		{
			// Si la valeur en degrés est à son maximum, les éventuels champs minutes et secondes passent à 0 et on interdit toute autre valeur
			if (window[this.object_basename+'_d'].getValue() === this.d_max_value)
			{
				if (typeof window[this.object_basename+'_m'] == 'object')
				{
					window[this.object_basename+'_m'].setValue(0);
					window[this.object_basename+'_m'].updateBounds(0,0);
				}
				if (typeof window[this.object_basename+'_s'] == 'object')
				{
					window[this.object_basename+'_s'].setValue(0);
					window[this.object_basename+'_s'].updateBounds(0,0);
				}
			}
			else
			{
				if (typeof window[this.object_basename+'_m'] == 'object')
				{
					window[this.object_basename+'_m'].updateBounds(0,this.m_max_value);
				}
				if (typeof window[this.object_basename+'_s'] == 'object')
				{
					window[this.object_basename+'_s'].updateBounds(0,this.s_max_value);
				}
			}
		};

		// Action complémentaire spécifique cette classe
		this.__setActionSpecific = function ()
		{
			// Affectation de l'action à tous les objets fils
			var i = -1;
			for (var id in this._childObjects)
			{
				i++;
				window[this._childObjects[id]].setAction(this.action, this.action_only_when_init_done);

				// Pour le champs des degrés, exécution de la méthode __checkValue de l'objet parent AVANT l'exécution de l'action
				if (i === 0)
				{
					window[this._childObjects[id]].addAction(this.object_basename+".__checkValue();", 'before');
				}
			}
		};

		// Action complémentaire spécifique cette classe
		this.__setActionBeforeSpecific = function ()
		{
			// Affectation de l'action à tous les objets fils
			var i = -1;
			for (var id in this._childObjects)
			{
				i++;
				window[this._childObjects[id]].setActionBefore(this.action, this.action_before_only_when_init_done);
			}
		};

		// Action complémentaire spécifique cette classe
		this.__setActionOnFocusSpecific = function ()
		{
			// Affectation de l'action à tous les objets fils
			var i = -1;
			for (var id in this._childObjects)
			{
				i++;
				window[this._childObjects[id]].setActionOnFocus(this.action, this.action_onfocus_only_when_init_done);
			}
		};

		// Action complémentaire spécifique cette classe
		this.__setActionOnBlurSpecific = function ()
		{
			// Affectation de l'action à tous les objets fils
			var i = -1;
			for (var id in this._childObjects)
			{
				i++;
				window[this._childObjects[id]].setActionOnBlur(this.action, this.action_onblur_only_when_init_done);
			}
		};
	};

	// Classe User_msg (encart d'info utilisateur)
	function User_msg (self, auto_activity)
	{
		this.self = self; 					// nom de l'instance
		this.idelem;						// Id de l'element dans lequel le select est instancie
		this.element_path;      			// chemin DOM de cet element
		this.idelem_border;					// Id du <div> des bordures
		this.idelem_status;					// Id du <div> marquant l'état du message
		this.idelem_msg;					// Id du <div> conteneur du texte
		this.idelem_opt;					// Id du <td> conteneur du texte optionnel
		this.label_path;					// chemin DOM du texte
		this.value = "";					// message
		this.optional_value;				// optionnel : pour l'ajout d'un bouton à droite du texte
		this.got_border;					// Indique la présence de la bordure autour du message
		this.state;							// Definit l'etat de l'objet :	0  -> inactif, le message n'est pas affiché
											//								1  -> actif, le message est affiché
		this.status = 0;				// Définit l'état du message lui même -> sa couleur

		this.margin = '0';
		this.width = '100%';

		this.auto_enable = (auto_activity) ? true : false;	// Gestion automatique de la méthode "enable" via HEADING.setSettingsActivity() si "auto_activity" vaut "true"

		this.__setAutoActivity(auto_activity);
		//.............................................................................................................


		this.construct = function (id_element, status, value, optional_value, got_border)
		{
			//..........................................................
			this.idelem = id_element;
			this.element_path = document.getElementById(this.idelem);
			this.idelem_border = id_element+'_ctnr_';
			this.idelem_status = id_element+'_status_';
			this.idelem_msg = id_element+'_msg_';
			this.idelem_opt = id_element+'_opt_';
			if (typeof status != 'undefined'){this.status = status;}
			if (typeof value == 'string' && value !== ""){this.value = value;}
			this.optional_value = optional_value;
			this.text_align = (optional_value != null) ? 'left' : 'center'; // Si du code HTML optionel est passé (ex. bouton restart), le texte est aligné à gauche, sinon il est centré

			if (!this.element_path)
			{
				console.error(this.self+'.construct : DOM element "'+this.idelem+'" is missing');
				return false;
			}
			//...........................................................

			// Display none avant la construction pour un affichage élégant
			this.element_path.style.display = 'none';

			var content = '<div id="'+this.idelem_border+'"><table class="usermsg_tab"><tr><td class="td_msg"><div id="'+this.idelem_status+'"><div id="'+this.idelem_msg+'" class="usermsg" style="text-align:'+this.text_align+'">'+this.value+'</div></div></td>';

			if (typeof optional_value == 'string'){content += '<td id="'+this.idelem_opt+'" valign="middle">'+optional_value+'</td>';}

			content += '</div>';

			this.element_path.innerHTML = content;

			this.element_path.style.margin = this.margin;
			this.element_path.style.width  = this.width;
			if (typeof this.min_width == 'string'){this.element_path.style.minWidth = this.min_width;}

			//...............................................................
			this.label_path = document.getElementById(this.idelem_msg);
			this.opt_path   = document.getElementById(this.idelem_opt);
			//...............................................................

			this.setStatus(this.status, got_border);
			this.show();
		};

		this.setStatus = function (status, got_border)
		{
			if (status != this.status)
			{
				//this.__scrollToMsg();	// Pose problème pour les appels récurents
			}

			this.status = parseFloat(status);
			this.got_border = (typeof got_border == 'undefined' || got_border === true) ? true : false;

			var border_status_suffix = (this.got_border === false) ? 'inv' : '';

			GIWIK.css.setClass(this.idelem, 'state_'+this.status);
			GIWIK.css.setClass(this.idelem_border, 'border_state_'+this.status+border_status_suffix);
			GIWIK.css.setClass(this.idelem_status, 'state_'+this.status);

			$('#'+this.idelem+' hr').css('border-top','solid 1px '+GIWIK.css['color_'+this.status]);
		};

		this.setValue = function (value)
		{
			if (!in_array(typeof value, ['string','undefined']))
			{
				return false;
			}

			if (value != this.value)
			{
				this.value = (typeof value == 'string') ? value.replace(/^(<br\s*\/?>)+/i,'').replace(/(<br\s*\/?>)+$/i,"") : "";
				this.label_path.innerHTML = (this.value) ? this.value : "&nbsp;";  // (par défaut "&nbsp;" pour que la hauteur de l'objet prenne en compte la ligne du message)

				$('#'+this.idelem+' hr').css('border-top','solid 1px '+GIWIK.css['color_'+this.status]);
				//this.__scrollToMsg();	// Pose problème pour les appels récurents
			}
		};

		this.setOptionalValue = function (value)
		{
			if (!in_array(typeof value, ['string','undefined']))
			{
				return false;
			}

			if (value != this.optional_value)
			{
				this.optional_value = (typeof value == 'string') ? value.replace(/^(<br\s*\/?>)+/i,'').replace(/(<br\s*\/?>)+$/i,"") : undefined;
				this.opt_path.innerHTML = (this.optional_value) ? this.optional_value : "&nbsp;";  // (par défaut "&nbsp;" pour que la hauteur de l'objet prenne en compte la ligne du message)
			}
		};

		this.getOptionalValue = function ()
		{
			return this.optional_value;
		};

		this.addValue = function (value, position)
		{
			if (typeof value != 'string' || value === "")
			{
				return false;
			}

			if (!in_array(position,['before','after']))
			{
				var position = "after";
			}

			var br = (!value || !this.value) ? "" : "<br/>";

			switch (position)
			{
				case 'before': this.setValue(value+br+this.value);	break;
				case 'after' : this.setValue(this.value+br+value);	break;
			}
		};

		this.__showSpecific = function (_options)
		{
			this.__scrollToMsg();
		};

		this.__scrollToMsg = function ()
		{
			if (HEADING.init.isdone)
			{
				if (!GIWIK.checkElementVisibility(this.idelem))
				{
					$('html,body').animate({scrollTop:$('#'+this.idelem).offset().top-10},200);
				}
			}
		};
	};

	// Classe Mask
	function Mask (self, auto_activity)
	{
		this.self = self; 			// nom de l'instance
		this.idelem;				// Id de l'element conteneur dans lequel le select est instancie
		this.state;					// Definit l'etat du controle :	0 -> inactif, 1  -> actif
		this.height;				// hauteur du masque
		this.element_path;			// chemin DOM de l'élément conteneur

		this.auto_enable = (auto_activity) ? true : false;	// Gestion automatique de la méthode "enable" via HEADING.setSettingsActivity() si "auto_activity" vaut "true"

		this.__setAutoActivity(auto_activity);
		//.............................................................................................................

		this.construct = function (id_element, height)
		{
			//......................................................
			this.idelem = id_element;
			this.height = height;

			this.element_path = document.getElementById(this.idelem);

			if (!this.element_path)
			{
				console.error(this.self+'.construct : DOM element "'+this.idelem+'" is missing');
				return false;
			}
			//......................................................

			this.element_path.style.display =  'block';
			this.element_path.style.position =  'relative';
			this.element_path.style.height = this.height+'px';
			this.element_path.style.marginTop = '-'+this.height+'px';
			this.element_path.style.backgroundColor = GIWIK.css.color_background;

			if (typeof this.element_path.style.opacity != 'undefined')
			{
				this.element_path.style.opacity = 0.5;
			}
			else
			{
				this.element_path.style.filter = "alpha(opacity=50)";
			}

			this.disable();
			this.show();
		};

		this.enable = function ()
		{
			this.state = 1;
			this.element_path.style.display = 'none';
		};

		this.disable = function ()
		{
			this.state = 0;
			this.element_path.style.display = 'block';
		};
	};

	// Application des méthodes génériques à toutes les classes
	for (var i in GIWIK._input_classes.all)
	{
		for (var method in GIWIK._input_methods.all)
		{
			// Ajout de la méthode si elle n'est pas déjà définie (ou à false)
			if (typeof window[GIWIK._input_classes.all[i]][method] == 'undefined')
			{
				window[GIWIK._input_classes.all[i]].prototype[method] = GIWIK._input_methods.all[method];
			}
		}
	}

	// Application des méthodes communes aux classes Input_int et Input_text
	for (var i in GIWIK._input_classes.int_and_text)
	{
		for (var method in GIWIK._input_methods.int_and_text)
		{
			// Ajout de la méthode si elle n'est pas déjà définie (ou à false)
			if (typeof window[GIWIK._input_classes.int_and_text[i]][method] == 'undefined')
			{
				window[GIWIK._input_classes.int_and_text[i]].prototype[method] = GIWIK._input_methods.int_and_text[method];
			}
		}
	}


// ARRAY OPERATIONS —————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————

	// Vérification de la présence d'une valeur dans un tableau. Retourne true si la valeur est trouvée, sinon false.
	// [option "strict pour prendre en compte le type des variables]
	function in_array (value, _array, strict)
	{
		for (var i in _array)
		{
			if ((!strict && _array[i] == value) || (strict && _array[i] === value))
			{
				return true;
			}
		}
		return false;
	};

	// Recherche d'une valeur (string ou int) dans un tableau. Si strict est absent ou false, la recherche ne tient pas compte du type.
	// Si une valeur est trouvée, la fonction retourne l'index de la valeur, sinon elle retourne false
	function array_search (value, _array, strict)
	{
		for (var i in _array)
		{
			if ((!strict && _array[i] == value) || (strict && _array[i] === value))
			{
				return i;
			}
		}
		return false;
	};

	// Renvoie le tableau de l'intersection des valeurs de 2 tableaux (les clés ne sont pas conservées)
	function array_intersect (_array1, _array2)
	{
		var _array_intersect = new Array();

		for (var i in _array1)
		{
			if (in_array(_array1[i], _array2))
			{
				_array_intersect.push(_array1[i]);
			}
		}

		return _array_intersect;
	};

	// Fusionne plusieurs tableaux en un seul
	function array_merge ()
	{
	    // http://kevin.vanzonneveld.net
	    // +   original by: Brett Zamir (http://brett-zamir.me)
	    // +   bugfixed by: Nate
	    // +   input by: josh
	    // +   bugfixed by: Brett Zamir (http://brett-zamir.me)
	    // *     example 1: arr1 = {"color": "red", 0: 2, 1: 4}
	    // *     example 1: arr2 = {0: "a", 1: "b", "color": "green", "shape": "trapezoid", 2: 4}
	    // *     example 1: array_merge(arr1, arr2)
	    // *     returns 1: {"color": "green", 0: 2, 1: 4, 2: "a", 3: "b", "shape": "trapezoid", 4: 4}
	    // *     example 2: arr1 = []
	    // *     example 2: arr2 = {1: "data"}
	    // *     example 2: array_merge(arr1, arr2)
	    // *     returns 2: {0: "data"}
	    var args = Array.prototype.slice.call(arguments),
	        argl = args.length,
	        arg,
	        retObj = {},
	        k = '',
	        argil = 0,
	        j = 0,
	        i = 0,
	        ct = 0,
	        toStr = Object.prototype.toString,
	        retArr = true;

	    for (i = 0; i < argl; i++)
	    {
	        if (toStr.call(args[i]) !== '[object Array]')
	        {
	            retArr = false;
	            break;
	        }
	    }

	    if (retArr)
	    {
	        retArr = [];
	        for (i = 0; i < argl; i++)
	        {
	            retArr = retArr.concat(args[i]);
	        }
	        return retArr;
	    }

	    for (i = 0, ct = 0; i < argl; i++)
	    {
	        arg = args[i];
	        if (toStr.call(arg) === '[object Array]')
	        {
	            for (j = 0, argil = arg.length; j < argil; j++)
	            {
	                retObj[ct++] = arg[j];
	            }
	        }
	        else
	        {
	            for (k in arg)
	            {
	                if (arg.hasOwnProperty(k))
	                {
	                    if (parseInt(k, 10) + '' === k)
	                    {
	                        retObj[ct++] = arg[k];
	                    }
	                    else
	                    {
	                        retObj[k] = arg[k];
	                    }
	                }
	            }
	        }
	    }
	    return retObj;
	};

	// Dédoublonne un tableau
	function array_unique (inputArr)
	{
		// http://kevin.vanzonneveld.net
		// + original by: Carlos R. L. Rodrigues (http://www.jsfromhell.com)
		// + input by: duncan
		// + bugfixed by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
		// + bugfixed by: Nate
		// + input by: Brett Zamir (http://brett-zamir.me)
		// + bugfixed by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
		// + improved by: Michael Grier
		// + bugfixed by: Brett Zamir (http://brett-zamir.me)
		// % note 1: The second argument, sort_flags is not implemented;
		// % note 1: also should be sorted (asort?) first according to docs
		// * example 1: array_unique(['Kevin','Kevin','van','Zonneveld','Kevin']);
		// * returns 1: {0: 'Kevin', 2: 'van', 3: 'Zonneveld'}
		// * example 2: array_unique({'a': 'green', 0: 'red', 'b': 'green', 1: 'blue', 2: 'red'});
		// * returns 2: {a: 'green', 0: 'red', 1: 'blue'}
		var key = '',
			tmp_arr2 = {},
			val = '';

		var __array_search = function (needle, haystack) {
			var fkey = '';
			for (fkey in haystack)
			{
				if (haystack.hasOwnProperty(fkey))
				{
					if ((haystack[fkey] + '') === (needle + ''))
					{
						return fkey;
					}
				}
			}
			return false;
		};

		for (key in inputArr)
		{
			if (inputArr.hasOwnProperty(key))
			{
				val = inputArr[key];
				if (false === __array_search(val, tmp_arr2))
				{
					tmp_arr2[key] = val;
				}
			}
		}

		return tmp_arr2;
	};

	// Renvoie toutes les clés d'un tableau ou d'un objet (uniquement les clés de 1er niveau dans ce cas) (fonction PHPjs customisée
	function array_keys (_array, search_value, strict)
	{
		// http://kevin.vanzonneveld.net
		// +   original by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
		// +      input by: Brett Zamir (http://brett-zamir.me)
		// +   bugfixed by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
		// +   improved by: jd
		// +   improved by: Brett Zamir (http://brett-zamir.me)
		// *     example 1: array_keys( {firstname: 'Kevin', surname: 'van Zonneveld'} );
		// *     returns 1: {0: 'firstname', 1: 'surname'}

		var search = typeof search_value !== 'undefined',
		tmp_arr = [],
		include = true,
		key = '';

		for (key in _array)
		{
			if (_array.hasOwnProperty(key))
			{
				include = true;
				if (search)
				{
				if (strict && _array[key] !== search_value)
				{
						include = false;
				}
				else if (_array[key] != search_value)
				{
						include = false;
				}
				}
				if (include)
				{
					tmp_arr[tmp_arr.length] = (key.match(/^\d+$/)) ? eval(key) : key;
				}
			}
		}
		return tmp_arr;
	};

	// Retourne toutes les valeurs d'un tableau
	function array_values (_array)
	{
		var _values_array = new Array();

		for (var key in _array)
		{
			_values_array.push(_array[key]);
		}

		return _values_array;
	};

	// Trie un tableau par ses clés
	function ksort (inputArr, sort_flags)
	{
		// http://kevin.vanzonneveld.net
		// +   original by: GeekFG (http://geekfg.blogspot.com)
		// +   improved by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
		// +   improved by: Brett Zamir (http://brett-zamir.me)
		// %          note 1: The examples are correct, this is a new way
		// %        note 2: This function deviates from PHP in returning a copy of the array instead
		// %        note 2: of acting by reference and returning true; this was necessary because
		// %        note 2: IE does not allow deleting and re-adding of properties without caching
		// %        note 2: of property position; you can set the ini of "phpjs.strictForIn" to true to
		// %        note 2: get the PHP behavior, but use this only if you are in an environment
		// %        note 2: such as Firefox extensions where for-in iteration order is fixed and true
		// %        note 2: property deletion is supported. Note that we intend to implement the PHP
		// %        note 2: behavior by default if IE ever does allow it; only gives shallow copy since
		// %        note 2: is by reference in PHP anyways
		// %        note 3: Since JS objects' keys are always strings, and (the
		// %        note 3: default) SORT_REGULAR flag distinguishes by key type,
		// %        note 3: if the content is a numeric string, we treat the
		// %        note 3: "original type" as numeric.
		// -    depends on: i18n_loc_get_default
		// -    depends on: strnatcmp
		// *     example 1: data = {d: 'lemon', a: 'orange', b: 'banana', c: 'apple'};
		// *     example 1: data = ksort(data);
		// *     results 1: {a: 'orange', b: 'banana', c: 'apple', d: 'lemon'}
		// *     example 2: ini_set('phpjs.strictForIn', true);
		// *     example 2: data = {2: 'van', 3: 'Zonneveld', 1: 'Kevin'};
		// *     example 2: ksort(data);
		// *     results 2: data == {1: 'Kevin', 2: 'van', 3: 'Zonneveld'}
		// *     returns 2: true
		var tmp_arr = {},
			keys = [],
			sorter, i, k, that = this,
			strictForIn = false,
			populateArr = {};

		switch (sort_flags)
		{
			case 'SORT_STRING':
				// compare items as strings
				sorter = function (a, b) {
					return that.strnatcmp(a, b);
				};
				break;
			case 'SORT_LOCALE_STRING':
				// compare items as strings, based on the current locale (set with  i18n_loc_set_default() as of PHP6)
				var loc = this.i18n_loc_get_default();
				sorter = this.php_js.i18nLocales[loc].sorting;
				break;
			case 'SORT_NUMERIC':
				// compare items numerically
				sorter = function (a, b) {
					return ((a + 0) - (b + 0));
				};
				break;
				// case 'SORT_REGULAR': // compare items normally (don't change types)
			default:
				sorter = function (a, b) {
					var aFloat = parseFloat(a),
					bFloat = parseFloat(b),
					aNumeric = aFloat + '' === a,
					bNumeric = bFloat + '' === b;
					if (aNumeric && bNumeric) {
						return aFloat > bFloat ? 1 : aFloat < bFloat ? -1 : 0;
					} else if (aNumeric && !bNumeric) {
						return 1;
					} else if (!aNumeric && bNumeric) {
						return -1;
					}
					return a > b ? 1 : a < b ? -1 : 0;
				};
				break;
		}

		// Make a list of key names
		for (k in inputArr) {
			if (inputArr.hasOwnProperty(k)) {
				keys.push(k);
			}
		}
		keys.sort(sorter);

		// BEGIN REDUNDANT
		this.php_js = this.php_js || {};
		this.php_js.ini = this.php_js.ini || {};
		// END REDUNDANT
		strictForIn = this.php_js.ini['phpjs.strictForIn'] && this.php_js.ini['phpjs.strictForIn'].local_value && this.php_js.ini['phpjs.strictForIn'].local_value !== 'off';
		populateArr = strictForIn ? inputArr : populateArr;

		// Rebuild array with sorted key names
		for (i = 0; i < keys.length; i++) {
			k = keys[i];
			tmp_arr[k] = inputArr[k];
			if (strictForIn) {
				delete inputArr[k];
			}
		}
		for (i in tmp_arr) {
			if (tmp_arr.hasOwnProperty(i)) {
				populateArr[i] = tmp_arr[i];
			}
		}

		return strictForIn || populateArr;
	};

	// Recherche l'existence d'une clé dans un tableau ou un objet (retourne true ou false)
	function array_key_exists (key, _array)
	{
			if (typeof _array != 'object') {return false;}

			return key in _array;
	};

	// Copie un tableau (associatif ou non) : permet d'éviter les problèmes de référence lors de la copie simple par l'opérateur "="
	function array_copy (_array)
	{
		if (typeof _array != 'object') {return false;}

		var _copy = (_array.constructor === Array) ? [] : {};

		for (var i in _array)
		{
			_copy[i] = _array[i];
		}

		return _copy;
	};

	// Compte tous les éléments d'un tableau ou d'un objet
	function count (_array, mode)
	{
	    // http://kevin.vanzonneveld.net
	    // +   original by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
	    // +      input by: Waldo Malqui Silva
	    // +   bugfixed by: Soren Hansen
	    // +      input by: merabi
	    // +   improved by: Brett Zamir (http://brett-zamir.me)
	    // +   bugfixed by: Olivier Louvignes (http://mg-crea.com/)
	    // +   improved by: Guillaume Viriot (prise en charge des fonctions)
	    // *     example 1: count([[0,0],[0,-4]], 'COUNT_RECURSIVE');
	    // *     returns 1: 6
	    // *     example 2: count({'one' : [1,2,3,4,5]}, 'COUNT_RECURSIVE');
	    // *     returns 2: 6
	    var key, cnt = 0;

	    if (_array === null || typeof _array === 'undefined')
	    {
	        return 0;
	    }
	    else if (!in_array(_array.constructor, [Array, Object, Function], true))	// GVI : ajout du constructor "Function"
	    {
	        return 1;
	    }

	    if (mode === 'COUNT_RECURSIVE')
	    {
	        mode = 1;
	    }
	    if (mode !== 1)
	    {
	        mode = 0;
	    }

	    for (key in _array)
	    {
	        if (_array.hasOwnProperty(key))
	        {
	            cnt++;
	            if (mode === 1 && _array[key] && in_array(_array.constructor, [Array, Object, Function], true)) // GVI : ajout du constructor "Function"
	            {
	                cnt += this.count(_array[key], 1);
	            }
	        }
	    }

	    return cnt;
	};

	// Trie un tableau d'après ses valeurs
	function sort (_array)
	{
		var _values = [];

		for (var i in _array)
		{
			_values.push(_array[i]);
		}

		return _values.sort();
	};

	// Tri un tableau d'après ses valeurs en ordre inverse
	function rsort (_array)
	{
		var _values = [];

		for (var i in _array)
		{
			_values.push(_array[i]);
		}

		return _values.sort().reverse();
	};

	// Trie un tableau d'après ses valeurs en conservant les indexes (! ne fonctionne pas avec des clés numériques à cause d'une limitation JS)
	function asort (inputArr, sort_flags)
	{
		// http://kevin.vanzonneveld.net
		// + original by: Brett Zamir (http://brett-zamir.me)
		// + improved by: Brett Zamir (http://brett-zamir.me)
		// + input by: paulo kuong
		// + improved by: Brett Zamir (http://brett-zamir.me)
		// + bugfixed by: Adam Wallner (http://web2.bitbaro.hu/)
		// + improved by: Theriault
		// % note 1: SORT_STRING (as well as natsort and natcasesort) might also be
		// % note 1: integrated into all of these functions by adapting the code at
		// % note 1: http://sourcefrog.net/projects/natsort/natcompare.js
		// % note 2: The examples are correct, this is a new way
		// % note 2: Credits to: http://javascript.internet.com/math-related/bubble-sort.html
		// % note 3: This function deviates from PHP in returning a copy of the array instead
		// % note 3: of acting by reference and returning true; this was necessary because
		// % note 3: IE does not allow deleting and re-adding of properties without caching
		// % note 3: of property position; you can set the ini of "phpjs.strictForIn" to true to
		// % note 3: get the PHP behavior, but use this only if you are in an environment
		// % note 3: such as Firefox extensions where for-in iteration order is fixed and true
		// % note 3: property deletion is supported. Note that we intend to implement the PHP
		// % note 3: behavior by default if IE ever does allow it; only gives shallow copy since
		// % note 3: is by reference in PHP anyways
		// % note 4: Since JS objects' keys are always strings, and (the
		// % note 4: default) SORT_REGULAR flag distinguishes by key type,
		// % note 4: if the content is a numeric string, we treat the
		// % note 4: "original type" as numeric.
		// - depends on: strnatcmp
		// - depends on: i18n_loc_get_default
		// * example 1: data = {d: 'lemon', a: 'orange', b: 'banana', c: 'apple'};
		// * example 1: data = asort(data);
		// * results 1: data == {c: 'apple', b: 'banana', d: 'lemon', a: 'orange'}
		// * returns 1: true
		// * example 2: ini_set('phpjs.strictForIn', true);
		// * example 2: data = {d: 'lemon', a: 'orange', b: 'banana', c: 'apple'};
		// * example 2: asort(data);
		// * results 2: data == {c: 'apple', b: 'banana', d: 'lemon', a: 'orange'}
		// * returns 2: true
		var valArr = [], valArrLen = 0,
			k, i, ret, sorter, that = this,
			strictForIn = false,
			populateArr = {};

		switch (sort_flags)
		{
			case 'SORT_STRING':
				// compare items as strings
				sorter = function (a, b) {
				  return that.strnatcmp(a, b);
				};
				break;
			case 'SORT_LOCALE_STRING':
				// compare items as strings, based on the current locale (set with i18n_loc_set_default() as of PHP6)
				var loc = this.i18n_loc_get_default();
				sorter = this.php_js.i18nLocales[loc].sorting;
				break;
			case 'SORT_NUMERIC':
				// compare items numerically
				sorter = function (a, b) {
				  return (a - b);
				};
				break;
			case 'SORT_REGULAR':
				// compare items normally (don't change types)
			default:
				sorter = function (a, b)
				{
					var aFloat = parseFloat(a),
					bFloat = parseFloat(b),
					aNumeric = aFloat + '' === a,
					bNumeric = bFloat + '' === b;
					if (aNumeric && bNumeric)
					{
						return aFloat > bFloat ? 1 : aFloat < bFloat ? -1 : 0;
					}
					else if (aNumeric && !bNumeric)
					{
						return 1;
					}
					else if (!aNumeric && bNumeric)
					{
						return -1;
					}
					return a > b ? 1 : a < b ? -1 : 0;
				};
				break;
		}

		// BEGIN REDUNDANT
		this.php_js = this.php_js || {};
		this.php_js.ini = this.php_js.ini || {};
		// END REDUNDANT
		strictForIn = this.php_js.ini['phpjs.strictForIn'] && this.php_js.ini['phpjs.strictForIn'].local_value && this.php_js.ini['phpjs.strictForIn'].local_value !== 'off';
		populateArr = strictForIn ? inputArr : populateArr;

		// Get key and value arrays
		for (k in inputArr)
		{
			if (inputArr.hasOwnProperty(k))
			{
		  		valArr.push([k, inputArr[k]]);
		  		if (strictForIn)
		  		{
		    		delete inputArr[k];
		  		}
			}
		}

		valArr.sort(function (a, b)
		{
			return sorter(a[1], b[1]);
		});

		// Repopulate the old array
		for (i = 0, valArrLen = valArr.length; i < valArrLen; i++)
		{
			populateArr[valArr[i][0]] = valArr[i][1];
		}

		return strictForIn || populateArr;
	};

	// Trie un tableau en ordre inverse en conservant les indexes
	function arsort (inputArr, sort_flags)
	{
		// http://kevin.vanzonneveld.net
		// + original by: Brett Zamir (http://brett-zamir.me)
		// + improved by: Brett Zamir (http://brett-zamir.me)
		// + improved by: Theriault
		// % note 1: SORT_STRING (as well as natsort and natcasesort) might also be
		// % note 1: integrated into all of these functions by adapting the code at
		// % note 1: http://sourcefrog.net/projects/natsort/natcompare.js
		// % note 2: The examples are correct, this is a new way
		// % note 2: Credits to: http://javascript.internet.com/math-related/bubble-sort.html
		// % note 3: This function deviates from PHP in returning a copy of the array instead
		// % note 3: of acting by reference and returning true; this was necessary because
		// % note 3: IE does not allow deleting and re-adding of properties without caching
		// % note 3: of property position; you can set the ini of "phpjs.strictForIn" to true to
		// % note 3: get the PHP behavior, but use this only if you are in an environment
		// % note 3: such as Firefox extensions where for-in iteration order is fixed and true
		// % note 3: property deletion is supported. Note that we intend to implement the PHP
		// % note 3: behavior by default if IE ever does allow it; only gives shallow copy since
		// % note 3: is by reference in PHP anyways
		// % note 4: Since JS objects' keys are always strings, and (the
		// % note 4: default) SORT_REGULAR flag distinguishes by key type,
		// % note 4: if the content is a numeric string, we treat the
		// % note 4: "original type" as numeric.
		// - depends on: i18n_loc_get_default
		// * example 1: data = {d: 'lemon', a: 'orange', b: 'banana', c: 'apple'};
		// * example 1: data = arsort(data);
		// * returns 1: data == {a: 'orange', d: 'lemon', b: 'banana', c: 'apple'}
		// * example 2: ini_set('phpjs.strictForIn', true);
		// * example 2: data = {d: 'lemon', a: 'orange', b: 'banana', c: 'apple'};
		// * example 2: arsort(data);
		// * results 2: data == {a: 'orange', d: 'lemon', b: 'banana', c: 'apple'}
		// * returns 2: true
		var valArr = [], valArrLen = 0,
			k, i, ret, sorter, that = this,
			strictForIn = false,
			populateArr = {};

		switch (sort_flags)
		{
			case 'SORT_STRING':
				// compare items as strings
				sorter = function (a, b)
				{
					return that.strnatcmp(b, a);
				};
				break;
			case 'SORT_LOCALE_STRING':
				// compare items as strings, based on the current locale (set with i18n_loc_set_default() as of PHP6)
				var loc = this.i18n_loc_get_default();
				sorter = this.php_js.i18nLocales[loc].sorting;
				break;
			case 'SORT_NUMERIC':
				// compare items numerically
				sorter = function (a, b)
				{
					return (a - b);
				};
				break;
			case 'SORT_REGULAR':
				// compare items normally (don't change types)
			default:
				sorter = function (b, a)
				{
					var aFloat = parseFloat(a),
						bFloat = parseFloat(b),
						aNumeric = aFloat + '' === a,
						bNumeric = bFloat + '' === b;
					if (aNumeric && bNumeric)
					{
						return aFloat > bFloat ? 1 : aFloat < bFloat ? -1 : 0;
					}
					else if (aNumeric && !bNumeric)
					{
						return 1;
					}
					else if (!aNumeric && bNumeric)
					{
						return -1;
					}
					return a > b ? 1 : a < b ? -1 : 0;
				};
				break;
		}

		// BEGIN REDUNDANT
		this.php_js = this.php_js || {};
		this.php_js.ini = this.php_js.ini || {};
		// END REDUNDANT
		strictForIn = this.php_js.ini['phpjs.strictForIn'] && this.php_js.ini['phpjs.strictForIn'].local_value && this.php_js.ini['phpjs.strictForIn'].local_value !== 'off';
		populateArr = strictForIn ? inputArr : populateArr;


		// Get key and value arrays
		for (k in inputArr)
		{
			if (inputArr.hasOwnProperty(k))
			{
				valArr.push([k, inputArr[k]]);
				if (strictForIn)
				{
					delete inputArr[k];
				}
			}
		}
		valArr.sort(function (a, b)
		{
			return sorter(a[1], b[1]);
		});

		// Repopulate the old array
		for (i = 0, valArrLen = valArr.length; i < valArrLen; i++)
		{
			populateArr[valArr[i][0]] = valArr[i][1];
		}

		return strictForIn || populateArr;
	};

	// Applique une fonction à chaque élément
	function array_map (callback)
	{
		// Applies the callback to the elements in given arrays.
		//
		// version: 1004.2314
		// discuss at: http://phpjs.org/functions/array_map    // +   original by: Andrea Giammarchi (http://webreflection.blogspot.com)
		// +   improved by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
		// +   improved by: Brett Zamir (http://brett-zamir.me)
		// %	note 1: Takes a function as an argument, not a function's name
		// %	note 2: If the callback is a string, it can only work if the function name is in the global context    // *     example 1: array_map( function (a){return (a * a * a)}, [1, 2, 3, 4, 5] );
		// *     returns 1: [ 1, 8, 27, 64, 125 ]
		var argc = arguments.length, argv = arguments;
		var j = argv[1].length, i = 0, k = 1, m = 0;
		var tmp = [], tmp_ar = [];

		while (i < j)
		{
			while (k < argc)
			{
				tmp[m++] = argv[k++][i];
			}
			m = 0;
			k = 1;

			if (callback)
			{
				if (typeof callback === 'string')
				{
					callback = this.window[callback];
				}
				tmp_ar[i++] = callback.apply(null, tmp);
			}
			else
			{
				tmp_ar[i++] = tmp;
			}

			tmp = [];
		}
		return tmp_ar;
	};

	// Récupère la plus petite valeur d'un tableau
	function min (_array)
	{
		var min = false;
		var value;

		for (var i in _array)
		{
			value = (typeof _array[i] == 'string' && typeof parseFloat(_array[i]) == 'number') ? parseFloat(_array[i]) : _array[i];

			if (typeof value == 'number')
			{
				if (min == false || _array[i] < min)
				{
					min = _array[i];
				}
			}
		}
		return min;
	};

	// Récupère la plus grande valeur d'un tableau
	function max (_array)
	{
		var max = false;
		var value;

		for (var i in _array)
		{
			value = (typeof _array[i] == 'string' && typeof parseFloat(_array[i]) == 'number') ? parseFloat(_array[i]) : _array[i];

			if (typeof value == 'number')
			{
				if (max == false || _array[i] > max)
				{
					max = _array[i];
				}
			}
		}
		return max;
	};

	// Dumpe un tableau ou un objet (inspiré de print_r PHP, source phpjs.org modifié par GVI)
	function print_r (array, return_alert)
	{
		// phpjs.org, original by: Michael White (http://getsprink.com)
		// update by Guillaume Viriot
		var output = '',
		pad_char = ' ',
		pad_val = 4,
		getFuncName = function (fn)
		{
			var name = (/\W*function\s+([\w\$]+)\s*\(/).exec(fn);
			if (!name)
			{
				return '(Anonymous)';
			}
			return name[1];
		},
		repeat_char = function (len, pad_char)
		{
			var str = '';
			for (var i = 0; i < len; i++)
			{
				str += pad_char;
			}
			return str;
		},
		formatArray = function (obj, cur_depth, pad_val, pad_char)
		{
			if (cur_depth > 0)
			{
				cur_depth++;
			}

			var base_pad = repeat_char(pad_val * cur_depth, pad_char);
			var thick_pad = repeat_char(pad_val * (cur_depth + 1), pad_char);
			var str = '';

			if (typeof obj === 'object' && obj !== null && obj.constructor && getFuncName(obj.constructor) !== 'PHPJS_Resource')
			{
				str += '\n' + base_pad + ((obj.constructor === Array) ? '[\n' : '{\n');

				for (var key in obj)
				{
					if (Object.prototype.toString.call(obj[key]) === '[object Array]' || Object.prototype.toString.call(obj[key]) === '[object Object]')
					{
						str += thick_pad + '"' + key + '" : ' + formatArray(obj[key], cur_depth + 1, pad_val, pad_char);
					}
					else
					{
						str += thick_pad + '"' + key + '" : ' + ((typeof obj[key] == "string") ? '"'+obj[key]+'"' : obj[key]) + '\n';
					}
				}
				str += base_pad + ((obj.constructor === Array) ? ']\n' : '}\n');
			}
			else if (obj === null)
			{
				str = 'null';
			}
			else if (obj === undefined)
			{
				str = 'undefined';
			}
			else
			{
				str = obj.toString();
			}

			return str;
		};

		output = formatArray(array, 0, pad_val, pad_char);

		if (return_alert !== true)
		{
			console.log(output);
		}
		else
		{
			alert(output);
		}
	};

	// Retourne une liste de nombres
	function make_num_list (min, max, step)
	{
		if (!step){var step = 1;}

		var _return = new Array();
		for (var i=min; i<max+step/* évite les problèmes d'arrondis de i<=max*/; i=i+step)
		{
			_return.push(Math.round(i*1000000)/1000000);
		}
		return _return;
	};

	// Retourne une liste d'entiers (format string en ordre croissant) avec zerofill de longueur n sous forme d'un tableau
	// (si length n'est pas spécifiée, on prend la length du max) hexa:true pour passer en mode hexadécimal
	function make_num_list_zerofill (min, max, length, hexa)
	{
		if (!length){var length = (''+max).length;}

		if (hexa)
		{
			min = hexa_to_decimal(min);
			max = hexa_to_decimal(max);
		}

		var i_string;
		var _return = new Array();
		for (var i=min; i<=max; i++)
		{
			i_string = (hexa) ? decimal_to_hexa(i) : ''+i;
			while (i_string.length<length)
			{
				i_string = '0'+i_string;
			}
			_return.push(i_string);
		}
		return _return;
	};


// FONCTIONS DIVERSES ———————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————

	// Ajout d'une méthode "trim" à l'objet String
	String.prototype.trim = function ()
	{
		return this.replace(/^\s+/, "").replace(/\s+$/, "");
	};

	// Fonction "trim" : supprime les espaces en début et fin de chaine (== méthode trim sauf qu'elle teste le type de la variable à traiter)
	function trim (string)
	{
		if (typeof string == 'string')
		{
			string = string.trim();
		}
		return string;
	};

	// Ajout d'une méthode "spaces_to_nbsp" à l'objet String pour convertir les espaces en "&nbsp;"
	String.prototype.spaces_to_nbsp = function ()
	{
		return this.replace(/[ ]+(?!\/)/gi, "&nbsp;");
	};

	// Réécriture de la fonction parseFloat() native pour que les chaines ne commençant pas par un digit soient prises en compte et ne renvoient pas un NaN
	function real_parseFloat (string)
	{
		if (typeof string == 'string')
		{
			string.replace(/^[^\d]*(\d+(\.\d+)?).*$/i, '$1', string);
		}
		return string;
	};

	// Réécriture de la fonction parseInt() native pour que les chaines ne commençant pas par un digit soient prises en compte et ne renvoient pas un NaN
	function real_parseInt (string)
	{
		if (typeof string == 'string')
		{
			string.replace(/^[^\d]*(\d+).*$/i, '$1', string);
		}
		return string;
	};

	// GIWIK Déduit le nom de paramètre à partir du nom de liste par suppression de "List" en fin de chaîne
	function listname_to_paramname (listname)
	{
		return listname.replace(/List$/, "");
	};

	// Décodage des caractères HTML
	function html_decode (s)
	{
		var out = "";

		if (s==null){return;}

		var l = s.length;
		for (var i=0; i<l; i++)
		{
			var ch = s.charAt(i);

			if (ch == '&')
			{
				var semicolonIndex = s.indexOf(';', i+1);

				if (semicolonIndex > 0)
				{
					var entity = s.substring(i + 1, semicolonIndex);

					if (entity.length > 1 && entity.charAt(0) == '#')
					{
						if (entity.charAt(1) == 'x' || entity.charAt(1) == 'X')
						{
							ch = String.fromCharCode(eval('0'+entity.substring(1)));
						}
						else
						{
							ch = String.fromCharCode(eval(entity.substring(1)));
						}
					}
					else
					{
						switch (entity)
						{
							case 'quot': 	ch = String.fromCharCode(0x0022); break;
							case 'amp': 	ch = String.fromCharCode(0x0026); break;
							case 'lt': 		ch = String.fromCharCode(0x003c); break;
							case 'gt': 		ch = String.fromCharCode(0x003e); break;
							case 'nbsp': 	ch = String.fromCharCode(0x00a0); break;
							case 'iexcl': 	ch = String.fromCharCode(0x00a1); break;
							case 'cent': 	ch = String.fromCharCode(0x00a2); break;
							case 'pound': 	ch = String.fromCharCode(0x00a3); break;
							case 'curren': 	ch = String.fromCharCode(0x00a4); break;
							case 'yen': 	ch = String.fromCharCode(0x00a5); break;
							case 'brvbar': 	ch = String.fromCharCode(0x00a6); break;
							case 'sect': 	ch = String.fromCharCode(0x00a7); break;
							case 'uml': 	ch = String.fromCharCode(0x00a8); break;
							case 'copy': 	ch = String.fromCharCode(0x00a9); break;
							case 'ordf': 	ch = String.fromCharCode(0x00aa); break;
							case 'laquo': 	ch = String.fromCharCode(0x00ab); break;
							case 'not': 	ch = String.fromCharCode(0x00ac); break;
							case 'shy': 	ch = String.fromCharCode(0x00ad); break;
							case 'reg': 	ch = String.fromCharCode(0x00ae); break;
							case 'macr': 	ch = String.fromCharCode(0x00af); break;
							case 'deg': 	ch = String.fromCharCode(0x00b0); break;
							case 'plusmn': 	ch = String.fromCharCode(0x00b1); break;
							case 'sup2': 	ch = String.fromCharCode(0x00b2); break;
							case 'sup3': 	ch = String.fromCharCode(0x00b3); break;
							case 'acute': 	ch = String.fromCharCode(0x00b4); break;
							case 'micro': 	ch = String.fromCharCode(0x00b5); break;
							case 'para': 	ch = String.fromCharCode(0x00b6); break;
							case 'middot': 	ch = String.fromCharCode(0x00b7); break;
							case 'cedil': 	ch = String.fromCharCode(0x00b8); break;
							case 'sup1': 	ch = String.fromCharCode(0x00b9); break;
							case 'ordm': 	ch = String.fromCharCode(0x00ba); break;
							case 'raquo': 	ch = String.fromCharCode(0x00bb); break;
							case 'frac14': 	ch = String.fromCharCode(0x00bc); break;
							case 'frac12': 	ch = String.fromCharCode(0x00bd); break;
							case 'frac34': 	ch = String.fromCharCode(0x00be); break;
							case 'iquest': 	ch = String.fromCharCode(0x00bf); break;
							case 'Agrave': 	ch = String.fromCharCode(0x00c0); break;
							case 'Aacute': 	ch = String.fromCharCode(0x00c1); break;
							case 'Acirc': 	ch = String.fromCharCode(0x00c2); break;
							case 'Atilde': 	ch = String.fromCharCode(0x00c3); break;
							case 'Auml': 	ch = String.fromCharCode(0x00c4); break;
							case 'Aring': 	ch = String.fromCharCode(0x00c5); break;
							case 'AElig': 	ch = String.fromCharCode(0x00c6); break;
							case 'Ccedil': 	ch = String.fromCharCode(0x00c7); break;
							case 'Egrave': 	ch = String.fromCharCode(0x00c8); break;
							case 'Eacute': 	ch = String.fromCharCode(0x00c9); break;
							case 'Ecirc': 	ch = String.fromCharCode(0x00ca); break;
							case 'Euml': 	ch = String.fromCharCode(0x00cb); break;
							case 'Igrave': 	ch = String.fromCharCode(0x00cc); break;
							case 'Iacute': 	ch = String.fromCharCode(0x00cd); break;
							case 'Icirc': 	ch = String.fromCharCode(0x00ce); break;
							case 'Iuml': 	ch = String.fromCharCode(0x00cf); break;
							case 'ETH': 	ch = String.fromCharCode(0x00d0); break;
							case 'Ntilde': 	ch = String.fromCharCode(0x00d1); break;
							case 'Ograve': 	ch = String.fromCharCode(0x00d2); break;
							case 'Oacute': 	ch = String.fromCharCode(0x00d3); break;
							case 'Ocirc': 	ch = String.fromCharCode(0x00d4); break;
							case 'Otilde': 	ch = String.fromCharCode(0x00d5); break;
							case 'Ouml': 	ch = String.fromCharCode(0x00d6); break;
							case 'times': 	ch = String.fromCharCode(0x00d7); break;
							case 'Oslash': 	ch = String.fromCharCode(0x00d8); break;
							case 'Ugrave': 	ch = String.fromCharCode(0x00d9); break;
							case 'Uacute': 	ch = String.fromCharCode(0x00da); break;
							case 'Ucirc': 	ch = String.fromCharCode(0x00db); break;
							case 'Uuml': 	ch = String.fromCharCode(0x00dc); break;
							case 'Yacute': 	ch = String.fromCharCode(0x00dd); break;
							case 'THORN': 	ch = String.fromCharCode(0x00de); break;
							case 'szlig': 	ch = String.fromCharCode(0x00df); break;
							case 'agrave': 	ch = String.fromCharCode(0x00e0); break;
							case 'aacute': 	ch = String.fromCharCode(0x00e1); break;
							case 'acirc': 	ch = String.fromCharCode(0x00e2); break;
							case 'atilde': 	ch = String.fromCharCode(0x00e3); break;
							case 'auml': 	ch = String.fromCharCode(0x00e4); break;
							case 'aring': 	ch = String.fromCharCode(0x00e5); break;
							case 'aelig': 	ch = String.fromCharCode(0x00e6); break;
							case 'ccedil': 	ch = String.fromCharCode(0x00e7); break;
							case 'egrave': 	ch = String.fromCharCode(0x00e8); break;
							case 'eacute': 	ch = String.fromCharCode(0x00e9); break;
							case 'ecirc': 	ch = String.fromCharCode(0x00ea); break;
							case 'euml': 	ch = String.fromCharCode(0x00eb); break;
							case 'igrave': 	ch = String.fromCharCode(0x00ec); break;
							case 'iacute': 	ch = String.fromCharCode(0x00ed); break;
							case 'icirc': 	ch = String.fromCharCode(0x00ee); break;
							case 'iuml': 	ch = String.fromCharCode(0x00ef); break;
							case 'eth': 	ch = String.fromCharCode(0x00f0); break;
							case 'ntilde': 	ch = String.fromCharCode(0x00f1); break;
							case 'ograve': 	ch = String.fromCharCode(0x00f2); break;
							case 'oacute': 	ch = String.fromCharCode(0x00f3); break;
							case 'ocirc': 	ch = String.fromCharCode(0x00f4); break;
							case 'otilde': 	ch = String.fromCharCode(0x00f5); break;
							case 'ouml': 	ch = String.fromCharCode(0x00f6); break;
							case 'divide': 	ch = String.fromCharCode(0x00f7); break;
							case 'oslash': 	ch = String.fromCharCode(0x00f8); break;
							case 'ugrave': 	ch = String.fromCharCode(0x00f9); break;
							case 'uacute': 	ch = String.fromCharCode(0x00fa); break;
							case 'ucirc': 	ch = String.fromCharCode(0x00fb); break;
							case 'uuml': 	ch = String.fromCharCode(0x00fc); break;
							case 'yacute': 	ch = String.fromCharCode(0x00fd); break;
							case 'thorn': 	ch = String.fromCharCode(0x00fe); break;
							case 'yuml': 	ch = String.fromCharCode(0x00ff); break;
							case 'OElig': 	ch = String.fromCharCode(0x0152); break;
							case 'oelig': 	ch = String.fromCharCode(0x0153); break;
							case 'Scaron': 	ch = String.fromCharCode(0x0160); break;
							case 'scaron': 	ch = String.fromCharCode(0x0161); break;
							case 'Yuml': 	ch = String.fromCharCode(0x0178); break;
							case 'fnof': 	ch = String.fromCharCode(0x0192); break;
							case 'circ': 	ch = String.fromCharCode(0x02c6); break;
							case 'tilde': 	ch = String.fromCharCode(0x02dc); break;
							case 'Alpha': 	ch = String.fromCharCode(0x0391); break;
							case 'Beta': 	ch = String.fromCharCode(0x0392); break;
							case 'Gamma': 	ch = String.fromCharCode(0x0393); break;
							case 'Delta': 	ch = String.fromCharCode(0x0394); break;
							case 'Epsilon': ch = String.fromCharCode(0x0395); break;
							case 'Zeta': 	ch = String.fromCharCode(0x0396); break;
							case 'Eta': 	ch = String.fromCharCode(0x0397); break;
							case 'Theta': 	ch = String.fromCharCode(0x0398); break;
							case 'Iota': 	ch = String.fromCharCode(0x0399); break;
							case 'Kappa': 	ch = String.fromCharCode(0x039a); break;
							case 'Lambda': 	ch = String.fromCharCode(0x039b); break;
							case 'Mu': 		ch = String.fromCharCode(0x039c); break;
							case 'Nu': 		ch = String.fromCharCode(0x039d); break;
							case 'Xi': 		ch = String.fromCharCode(0x039e); break;
							case 'Omicron': ch = String.fromCharCode(0x039f); break;
							case 'Pi': 		ch = String.fromCharCode(0x03a0); break;
							case ' Rho ': 	ch = String.fromCharCode(0x03a1); break;
							case 'Sigma': 	ch = String.fromCharCode(0x03a3); break;
							case 'Tau': 	ch = String.fromCharCode(0x03a4); break;
							case 'Upsilon': ch = String.fromCharCode(0x03a5); break;
							case 'Phi': 	ch = String.fromCharCode(0x03a6); break;
							case 'Chi': 	ch = String.fromCharCode(0x03a7); break;
							case 'Psi': 	ch = String.fromCharCode(0x03a8); break;
							case 'Omega': 	ch = String.fromCharCode(0x03a9); break;
							case 'alpha': 	ch = String.fromCharCode(0x03b1); break;
							case 'beta': 	ch = String.fromCharCode(0x03b2); break;
							case 'gamma': 	ch = String.fromCharCode(0x03b3); break;
							case 'delta': 	ch = String.fromCharCode(0x03b4); break;
							case 'epsilon': ch = String.fromCharCode(0x03b5); break;
							case 'zeta': 	ch = String.fromCharCode(0x03b6); break;
							case 'eta': 	ch = String.fromCharCode(0x03b7); break;
							case 'theta': 	ch = String.fromCharCode(0x03b8); break;
							case 'iota': 	ch = String.fromCharCode(0x03b9); break;
							case 'kappa': 	ch = String.fromCharCode(0x03ba); break;
							case 'lambda': 	ch = String.fromCharCode(0x03bb); break;
							case 'mu': 		ch = String.fromCharCode(0x03bc); break;
							case 'nu': 		ch = String.fromCharCode(0x03bd); break;
							case 'xi': 		ch = String.fromCharCode(0x03be); break;
							case 'omicron': ch = String.fromCharCode(0x03bf); break;
							case 'pi': 		ch = String.fromCharCode(0x03c0); break;
							case 'rho': 	ch = String.fromCharCode(0x03c1); break;
							case 'sigmaf': 	ch = String.fromCharCode(0x03c2); break;
							case 'sigma': 	ch = String.fromCharCode(0x03c3); break;
							case 'tau': 	ch = String.fromCharCode(0x03c4); break;
							case 'upsilon': ch = String.fromCharCode(0x03c5); break;
							case 'phi': 	ch = String.fromCharCode(0x03c6); break;
							case '	chi': 	ch = String.fromCharCode(0x03c7); break;
							case 'psi': 	ch = String.fromCharCode(0x03c8); break;
							case 'omega': 	ch = String.fromCharCode(0x03c9); break;
							case 'thetasym':ch = String.fromCharCode(0x03d1); break;
							case 'upsih': 	ch = String.fromCharCode(0x03d2); break;
							case 'piv': 	ch = String.fromCharCode(0x03d6); break;
							case 'ensp': 	ch = String.fromCharCode(0x2002); break;
							case 'emsp': 	ch = String.fromCharCode(0x2003); break;
							case 'thinsp': 	ch = String.fromCharCode(0x2009); break;
							case 'zwnj': 	ch = String.fromCharCode(0x200c); break;
							case 'zwj': 	ch = String.fromCharCode(0x200d); break;
							case 'lrm': 	ch = String.fromCharCode(0x200e); break;
							case 'rlm': 	ch = String.fromCharCode(0x200f); break;
							case 'ndash': 	ch = String.fromCharCode(0x2013); break;
							case 'mdash': 	ch = String.fromCharCode(0x2014); break;
							case 'lsquo': 	ch = String.fromCharCode(0x2018); break;
							case 'rsquo': 	ch = String.fromCharCode(0x2019); break;
							case 'sbquo': 	ch = String.fromCharCode(0x201a); break;
							case 'ldquo': 	ch = String.fromCharCode(0x201c); break;
							case 'rdquo': 	ch = String.fromCharCode(0x201d); break;
							case 'bdquo': 	ch = String.fromCharCode(0x201e); break;
							case 'dagger': 	ch = String.fromCharCode(0x2020); break;
							case 'Dagger': 	ch = String.fromCharCode(0x2021); break;
							case 'bull': 	ch = String.fromCharCode(0x2022); break;
							case 'hellip': 	ch = String.fromCharCode(0x2026); break;
							case 'permil': 	ch = String.fromCharCode(0x2030); break;
							case 'prime': 	ch = String.fromCharCode(0x2032); break;
							case 'Prime': 	ch = String.fromCharCode(0x2033); break;
							case 'lsaquo': 	ch = String.fromCharCode(0x2039); break;
							case 'rsaquo': 	ch = String.fromCharCode(0x203a); break;
							case 'oline': 	ch = String.fromCharCode(0x203e); break;
							case 'frasl': 	ch = String.fromCharCode(0x2044); break;
							case 'euro': 	ch = String.fromCharCode(0x20ac); break;
							case 'image': 	ch = String.fromCharCode(0x2111); break;
							case 'weierp': 	ch = String.fromCharCode(0x2118); break;
							case 'real': 	ch = String.fromCharCode(0x211c); break;
							case 'trade': 	ch = String.fromCharCode(0x2122); break;
							case 'alefsym': ch = String.fromCharCode(0x2135); break;
							case 'larr': 	ch = String.fromCharCode(0x2190); break;
							case 'uarr': 	ch = String.fromCharCode(0x2191); break;
							case 'rarr': 	ch = String.fromCharCode(0x2192); break;
							case 'darr': 	ch = String.fromCharCode(0x2193); break;
							case 'harr': 	ch = String.fromCharCode(0x2194); break;
							case 'crarr': 	ch = String.fromCharCode(0x21b5); break;
							case 'lArr': 	ch = String.fromCharCode(0x21d0); break;
							case 'uArr': 	ch = String.fromCharCode(0x21d1); break;
							case 'rArr': 	ch = String.fromCharCode(0x21d2); break;
							case 'dArr': 	ch = String.fromCharCode(0x21d3); break;
							case 'hArr': 	ch = String.fromCharCode(0x21d4); break;
							case 'forall': 	ch = String.fromCharCode(0x2200); break;
							case 'part': 	ch = String.fromCharCode(0x2202); break;
							case 'exist': 	ch = String.fromCharCode(0x2203); break;
							case 'empty': 	ch = String.fromCharCode(0x2205); break;
							case 'nabla': 	ch = String.fromCharCode(0x2207); break;
							case 'isin': 	ch = String.fromCharCode(0x2208); break;
							case 'notin': 	ch = String.fromCharCode(0x2209); break;
							case 'ni': 		ch = String.fromCharCode(0x220b); break;
							case 'prod': 	ch = String.fromCharCode(0x220f); break;
							case 'sum': 	ch = String.fromCharCode(0x2211); break;
							case 'minus': 	ch = String.fromCharCode(0x2212); break;
							case 'lowast': 	ch = String.fromCharCode(0x2217); break;
							case 'radic': 	ch = String.fromCharCode(0x221a); break;
							case 'prop': 	ch = String.fromCharCode(0x221d); break;
							case 'infin': 	ch = String.fromCharCode(0x221e); break;
							case 'ang': 	ch = String.fromCharCode(0x2220); break;
							case 'and': 	ch = String.fromCharCode(0x2227); break;
							case 'or': 		ch = String.fromCharCode(0x2228); break;
							case 'cap': 	ch = String.fromCharCode(0x2229); break;
							case 'cup': 	ch = String.fromCharCode(0x222a); break;
							case 'int': 	ch = String.fromCharCode(0x222b); break;
							case 'there4': 	ch = String.fromCharCode(0x2234); break;
							case 'sim': 	ch = String.fromCharCode(0x223c); break;
							case 'cong': 	ch = String.fromCharCode(0x2245); break;
							case 'asymp': 	ch = String.fromCharCode(0x2248); break;
							case 'ne': 		ch = String.fromCharCode(0x2260); break;
							case 'equiv': 	ch = String.fromCharCode(0x2261); break;
							case 'le': 		ch = String.fromCharCode(0x2264); break;
							case 'ge': 		ch = String.fromCharCode(0x2265); break;
							case 'sub': 	ch = String.fromCharCode(0x2282); break;
							case 'sup': 	ch = String.fromCharCode(0x2283); break;
							case 'nsub': 	ch = String.fromCharCode(0x2284); break;
							case 'sube': 	ch = String.fromCharCode(0x2286); break;
							case 'supe': 	ch = String.fromCharCode(0x2287); break;
							case 'oplus': 	ch = String.fromCharCode(0x2295); break;
							case 'otimes': 	ch = String.fromCharCode(0x2297); break;
							case 'perp': 	ch = String.fromCharCode(0x22a5); break;
							case 'sdot': 	ch = String.fromCharCode(0x22c5); break;
							case 'lceil': 	ch = String.fromCharCode(0x2308); break;
							case 'rceil': 	ch = String.fromCharCode(0x2309); break;
							case 'lfloor': 	ch = String.fromCharCode(0x230a); break;
							case 'rfloor': 	ch = String.fromCharCode(0x230b); break;
							case 'lang': 	ch = String.fromCharCode(0x2329); break;
							case 'rang': 	ch = String.fromCharCode(0x232a); break;
							case 'loz': 	ch = String.fromCharCode(0x25ca); break;
							case 'spades': 	ch = String.fromCharCode(0x2660); break;
							case 'clubs': 	ch = String.fromCharCode(0x2663); break;
							case 'hearts': 	ch = String.fromCharCode(0x2665); break;
							case 'diams': 	ch = String.fromCharCode(0x2666); break;
							default: ch = ''; break;
						}
					}
					i = semicolonIndex;
				}
			}
			out += ch;
		}
		return out;
	};

	// Supprime tous les tags d'une chaine
	function strip_tags (str, allowed_tags)
	{
		// Strips HTML and PHP tags from a string
		//
		// version: 1008.1718
		// discuss at: http://phpjs.org/functions/strip_tags    // +   original by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
		// +   improved by: Luke Godfrey
		// +      input by: Pul
		// +   bugfixed by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
		// +   bugfixed by: Onno Marsman    // +      input by: Alex
		// +   bugfixed by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
		// +      input by: Marc Palau
		// +   improved by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
		// +      input by: Brett Zamir (http://brett-zamir.me)    // +   bugfixed by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
		// +   bugfixed by: Eric Nagel
		// +      input by: Bobby Drake
		// +   bugfixed by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
		// +   bugfixed by: Tomasz Wesolowski    // *     example 1: strip_tags('<p>Kevin</p> <b>van</b> <i>Zonneveld</i>', '<i><b>');
		// *     returns 1: 'Kevin <b>van</b> <i>Zonneveld</i>'
		// *     example 2: strip_tags('<p>Kevin <img src="someimage.png" onmouseover="someFunction()">van <i>Zonneveld</i></p>', '<p>');
		// *     returns 2: '<p>Kevin van Zonneveld</p>'
		// *     example 3: strip_tags("<a href='http://kevin.vanzonneveld.net'>Kevin van Zonneveld</a>", "<a>");    // *     returns 3: '<a href='http://kevin.vanzonneveld.net'>Kevin van Zonneveld</a>'
		// *     example 4: strip_tags('1 < 5 5 > 1');
		// *     returns 4: '1 < 5 5 > 1'
		var key = '', allowed = false;
		var matches = [];    var allowed_array = [];
		var allowed_tag = '';
		var i = 0;
		var k = '';
		var html = '';
		var replacer = function (search, replace, str)
		{
			return str.split(search).join(replace);
		};
		// Build allowes tags associative array
		if (allowed_tags)
		{
			allowed_array = allowed_tags.match(/([a-zA-Z0-9]+)/gi);
		}
		str += '';

		// Match tags
		matches = str.match(/(<\/?[\S][^>]*>)/gi);
		// Go through all HTML tags
		for (key in matches)
		{
			if (isNaN(key))
			{
				// IE7 Hack
				continue;
			}

			// Save HTML tag
			html = matches[key].toString();
			 // Is tag not in allowed list? Remove from str!
			allowed = false;

			// Go through all allowed tags
			for (k in allowed_array)
			{
				// Init
				allowed_tag = allowed_array[k];
				i = -1;

				if (i != 0) { i = html.toLowerCase().indexOf('<'+allowed_tag+'>');}	if (i != 0) { i = html.toLowerCase().indexOf('<'+allowed_tag+' ');}
				if (i != 0) { i = html.toLowerCase().indexOf('</'+allowed_tag)   ;}

				// Determine
				if (i == 0) {allowed = true; break;}
			}
			if (!allowed)
			{
				str = replacer(html, "", str); // Custom replace. No regexing
			}
		}
		return str;
	};

	// Conversion d'une valeur hexadecimale->décimale
	function decimal_to_hexa (decimal_value)
	{
		return decimal_value.toString(16).toUpperCase();
	};

	// Conversion d'une valeur décimale->hexadecimale
	function hexa_to_decimal (hexa_value)
	{
		return parseInt(hexa_value,16);
	};

	// Encodage UTF8 d'un chaine
	function utf8_encode (argString)
	{
		// http://kevin.vanzonneveld.net
		// +   original by: Webtoolkit.info (http://www.webtoolkit.info/)
		// +   improved by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
		// +   improved by: sowberry
		// +    tweaked by: Jack
		// +   bugfixed by: Onno Marsman
		// +   improved by: Yves Sucaet
		// +   bugfixed by: Onno Marsman
		// +   bugfixed by: Ulrich
		// +   bugfixed by: Rafal Kukawski
		// *     example 1: utf8_encode('Kevin van Zonneveld');
		// *     returns 1: 'Kevin van Zonneveld'

		if (argString === null || typeof argString === "undefined")
		{
			return "";
		}

		var string = (argString + ''); // .replace(/\r\n/g, "\n").replace(/\r/g, "\n");
		var utftext = "",
		start, end, stringl = 0;

		start = end = 0;
		stringl = string.length;
		for (var n = 0; n < stringl; n++)
		{
			var c1 = string.charCodeAt(n);
			var enc = null;

			if (c1 < 128)
			{
				end++;
			}
			else if (c1 > 127 && c1 < 2048)
			{
				enc = String.fromCharCode((c1 >> 6) | 192) + String.fromCharCode((c1 & 63) | 128);
			}
			else
			{
				enc = String.fromCharCode((c1 >> 12) | 224) + String.fromCharCode(((c1 >> 6) & 63) | 128) + String.fromCharCode((c1 & 63) | 128);
			}
			if (enc !== null)
			{
				if (end > start)
				{
					utftext += string.slice(start, end);
				}
				utftext += enc;
				start = end = n + 1;
			}
		}

		if (end > start)
		{
			utftext += string.slice(start, stringl);
		}

		return utftext;
	};

	// MD5 (Message-Digest Algorithm)
	function md5 (str)
	{
		// http://kevin.vanzonneveld.net
		// +   original by: Webtoolkit.info (http://www.webtoolkit.info/)
		// +   namespaced by: Michael White (http://getsprink.com)
		// +   tweaked by: Jack
		// +   improved by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
		// +   input by: Brett Zamir (http://brett-zamir.me)
		// +   bugfixed by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
		// -   depends on: utf8_encode
		// *   example 1: md5('Kevin van Zonneveld');
		// *   returns 1: '6e658d4bfcb59cc13f96c14450ac40b9'
		var xl;

		var rotateLeft = function(lValue, iShiftBits)
		{
			return (lValue << iShiftBits) | (lValue >>> (32 - iShiftBits));
		};

		var addUnsigned = function (lX, lY)
		{
			var lX4, lY4, lX8, lY8, lResult;
			lX8 = (lX & 0x80000000);
			lY8 = (lY & 0x80000000);
			lX4 = (lX & 0x40000000);
			lY4 = (lY & 0x40000000);
			lResult = (lX & 0x3FFFFFFF) + (lY & 0x3FFFFFFF);
			if (lX4 & lY4)
			{
				return (lResult ^ 0x80000000 ^ lX8 ^ lY8);
			}
			if (lX4 | lY4)
			{
				if (lResult & 0x40000000)
				{
					return(lResult ^ 0xC0000000 ^ lX8 ^ lY8);
				}
				else
				{
					return(lResult ^ 0x40000000 ^ lX8 ^ lY8);
				}
			}
			else
			{
				return (lResult ^ lX8 ^ lY8);
			}
		};

		var _F = function(x, y, z)
		{
			return (x & y) | ((~x) & z);
		};
		var _G = function(x, y, z)
		{
			return (x & z) | (y & (~z));
		};
		var _H = function(x, y, z)
		{
			return (x ^ y ^ z);
		};
		var _I = function(x, y, z)
		{
			return (y ^ (x | (~z)));
		};

		var _FF = function(a, b, c, d, x, s, ac) {
			a = addUnsigned(a, addUnsigned(addUnsigned(_F(b, c, d), x), ac));
			return addUnsigned(rotateLeft(a, s), b);
		};

		var _GG = function(a, b, c, d, x, s, ac) {
			a = addUnsigned(a, addUnsigned(addUnsigned(_G(b, c, d), x), ac));
			return addUnsigned(rotateLeft(a, s), b);
		};

		var _HH = function(a, b, c, d, x, s, ac)
		{
			a = addUnsigned(a, addUnsigned(addUnsigned(_H(b, c, d), x), ac));
			return addUnsigned(rotateLeft(a, s), b);
		};

		var _II = function(a, b, c, d, x, s, ac)
		{
			a = addUnsigned(a, addUnsigned(addUnsigned(_I(b, c, d), x), ac));
			return addUnsigned(rotateLeft(a, s), b);
		};

		var convertToWordArray = function(str)
		{
			var lWordCount;
			var lMessageLength = str.length;
			var lNumberOfWords_temp1 = lMessageLength + 8;
			var lNumberOfWords_temp2 = (lNumberOfWords_temp1 - (lNumberOfWords_temp1 % 64)) / 64;
			var lNumberOfWords = (lNumberOfWords_temp2 + 1) * 16;
			var lWordArray = new Array(lNumberOfWords - 1);
			var lBytePosition = 0;
			var lByteCount = 0;
			while (lByteCount < lMessageLength)
			{
				lWordCount = (lByteCount - (lByteCount % 4)) / 4;
				lBytePosition = (lByteCount % 4) * 8;
				lWordArray[lWordCount] = (lWordArray[lWordCount] | (str.charCodeAt(lByteCount) << lBytePosition));
				lByteCount++;
			}
			lWordCount = (lByteCount - (lByteCount % 4)) / 4;
			lBytePosition = (lByteCount % 4) * 8;
			lWordArray[lWordCount] = lWordArray[lWordCount] | (0x80 << lBytePosition);
			lWordArray[lNumberOfWords - 2] = lMessageLength << 3;
			lWordArray[lNumberOfWords - 1] = lMessageLength >>> 29;
			return lWordArray;
		};

		var wordToHex = function (lValue)
		{
			var wordToHexValue = "",
				wordToHexValue_temp = "",
				lByte, lCount;
			for (lCount = 0; lCount <= 3; lCount++)
			{
				lByte = (lValue >>> (lCount * 8)) & 255;
				wordToHexValue_temp = "0" + lByte.toString(16);
				wordToHexValue = wordToHexValue + wordToHexValue_temp.substr(wordToHexValue_temp.length - 2, 2);
			}
			return wordToHexValue;
		};

		var x = [],
		k, AA, BB, CC, DD, a, b, c, d, S11 = 7,
		S12 = 12,
		S13 = 17,
		S14 = 22,
		S21 = 5,
		S22 = 9,
		S23 = 14,
		S24 = 20,
		S31 = 4,
		S32 = 11,
		S33 = 16,
		S34 = 23,
		S41 = 6,
		S42 = 10,
		S43 = 15,
		S44 = 21;

		str = this.utf8_encode(str);
		x = convertToWordArray(str);
		a = 0x67452301;
		b = 0xEFCDAB89;
		c = 0x98BADCFE;
		d = 0x10325476;

		xl = x.length;
		for (k = 0; k < xl; k += 16)
		{
			AA = a;
			BB = b;
			CC = c;
			DD = d;
			a = _FF(a, b, c, d, x[k + 0], S11, 0xD76AA478);
			d = _FF(d, a, b, c, x[k + 1], S12, 0xE8C7B756);
			c = _FF(c, d, a, b, x[k + 2], S13, 0x242070DB);
			b = _FF(b, c, d, a, x[k + 3], S14, 0xC1BDCEEE);
			a = _FF(a, b, c, d, x[k + 4], S11, 0xF57C0FAF);
			d = _FF(d, a, b, c, x[k + 5], S12, 0x4787C62A);
			c = _FF(c, d, a, b, x[k + 6], S13, 0xA8304613);
			b = _FF(b, c, d, a, x[k + 7], S14, 0xFD469501);
			a = _FF(a, b, c, d, x[k + 8], S11, 0x698098D8);
			d = _FF(d, a, b, c, x[k + 9], S12, 0x8B44F7AF);
			c = _FF(c, d, a, b, x[k + 10], S13, 0xFFFF5BB1);
			b = _FF(b, c, d, a, x[k + 11], S14, 0x895CD7BE);
			a = _FF(a, b, c, d, x[k + 12], S11, 0x6B901122);
			d = _FF(d, a, b, c, x[k + 13], S12, 0xFD987193);
			c = _FF(c, d, a, b, x[k + 14], S13, 0xA679438E);
			b = _FF(b, c, d, a, x[k + 15], S14, 0x49B40821);
			a = _GG(a, b, c, d, x[k + 1], S21, 0xF61E2562);
			d = _GG(d, a, b, c, x[k + 6], S22, 0xC040B340);
			c = _GG(c, d, a, b, x[k + 11], S23, 0x265E5A51);
			b = _GG(b, c, d, a, x[k + 0], S24, 0xE9B6C7AA);
			a = _GG(a, b, c, d, x[k + 5], S21, 0xD62F105D);
			d = _GG(d, a, b, c, x[k + 10], S22, 0x2441453);
			c = _GG(c, d, a, b, x[k + 15], S23, 0xD8A1E681);
			b = _GG(b, c, d, a, x[k + 4], S24, 0xE7D3FBC8);
			a = _GG(a, b, c, d, x[k + 9], S21, 0x21E1CDE6);
			d = _GG(d, a, b, c, x[k + 14], S22, 0xC33707D6);
			c = _GG(c, d, a, b, x[k + 3], S23, 0xF4D50D87);
			b = _GG(b, c, d, a, x[k + 8], S24, 0x455A14ED);
			a = _GG(a, b, c, d, x[k + 13], S21, 0xA9E3E905);
			d = _GG(d, a, b, c, x[k + 2], S22, 0xFCEFA3F8);
			c = _GG(c, d, a, b, x[k + 7], S23, 0x676F02D9);
			b = _GG(b, c, d, a, x[k + 12], S24, 0x8D2A4C8A);
			a = _HH(a, b, c, d, x[k + 5], S31, 0xFFFA3942);
			d = _HH(d, a, b, c, x[k + 8], S32, 0x8771F681);
			c = _HH(c, d, a, b, x[k + 11], S33, 0x6D9D6122);
			b = _HH(b, c, d, a, x[k + 14], S34, 0xFDE5380C);
			a = _HH(a, b, c, d, x[k + 1], S31, 0xA4BEEA44);
			d = _HH(d, a, b, c, x[k + 4], S32, 0x4BDECFA9);
			c = _HH(c, d, a, b, x[k + 7], S33, 0xF6BB4B60);
			b = _HH(b, c, d, a, x[k + 10], S34, 0xBEBFBC70);
			a = _HH(a, b, c, d, x[k + 13], S31, 0x289B7EC6);
			d = _HH(d, a, b, c, x[k + 0], S32, 0xEAA127FA);
			c = _HH(c, d, a, b, x[k + 3], S33, 0xD4EF3085);
			b = _HH(b, c, d, a, x[k + 6], S34, 0x4881D05);
			a = _HH(a, b, c, d, x[k + 9], S31, 0xD9D4D039);
			d = _HH(d, a, b, c, x[k + 12], S32, 0xE6DB99E5);
			c = _HH(c, d, a, b, x[k + 15], S33, 0x1FA27CF8);
			b = _HH(b, c, d, a, x[k + 2], S34, 0xC4AC5665);
			a = _II(a, b, c, d, x[k + 0], S41, 0xF4292244);
			d = _II(d, a, b, c, x[k + 7], S42, 0x432AFF97);
			c = _II(c, d, a, b, x[k + 14], S43, 0xAB9423A7);
			b = _II(b, c, d, a, x[k + 5], S44, 0xFC93A039);
			a = _II(a, b, c, d, x[k + 12], S41, 0x655B59C3);
			d = _II(d, a, b, c, x[k + 3], S42, 0x8F0CCC92);
			c = _II(c, d, a, b, x[k + 10], S43, 0xFFEFF47D);
			b = _II(b, c, d, a, x[k + 1], S44, 0x85845DD1);
			a = _II(a, b, c, d, x[k + 8], S41, 0x6FA87E4F);
			d = _II(d, a, b, c, x[k + 15], S42, 0xFE2CE6E0);
			c = _II(c, d, a, b, x[k + 6], S43, 0xA3014314);
			b = _II(b, c, d, a, x[k + 13], S44, 0x4E0811A1);
			a = _II(a, b, c, d, x[k + 4], S41, 0xF7537E82);
			d = _II(d, a, b, c, x[k + 11], S42, 0xBD3AF235);
			c = _II(c, d, a, b, x[k + 2], S43, 0x2AD7D2BB);
			b = _II(b, c, d, a, x[k + 9], S44, 0xEB86D391);
			a = addUnsigned(a, AA);
			b = addUnsigned(b, BB);
			c = addUnsigned(c, CC);
			d = addUnsigned(d, DD);
		}

		var temp = wordToHex(a) + wordToHex(b) + wordToHex(c) + wordToHex(d);

		return temp.toLowerCase();
	};

	// Retourne le nombre de chiffres après la virgule d'un nombre de type number ou string (hors série décimale composée uniquement de 0)
	function count_decimals (value)
	{
		// Valeur sous forme de nombre
		var num_value = (typeof value == 'number') ? value : parseFloat(value);

		// Si la valeur numérique n'est pas un nombre, on arrête le traitement
		if (isNaN(num_value)){return false;}

		// Valeur sous forme de chaine
		var str_value = num_value.toString(10);

		return (num_value === parseInt(num_value)) ? 0 : ((str_value.indexOf('e') !== -1) ? num_value.toFixed(str_value.match(/^\-?\de\-(\d+)$/)[1]) : str_value).match(/^\-?\d+(\.(\d+))?$/)[2].length;
	};


//***************************************************************************************************/
// INITIALISATION : PHASE 1 -> Initialisation de tout ce qui peut l'être AVANT l'évènement "load"	//
GIWIK.init();																						//
/****************************************************************************************************/


// Indique que le chargement du fichier est terminé
GIWIK._files['giwik.app.js'].loaded = true;
