// GIWIK MESSAGE


// TERMES GÉNÉRAUX //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
MSG.shared =
{
	altitude: {
		en: "Altitude",
		fr: "Altitude",
		ru: "Высота"
	},
	and: {
		en: "and",
		fr: "et",
		ru: "и"
	},
	auto: {
		en: "Auto",
		fr: "Auto",
		ru: "Авто"
	},
	code: {
		en: "Code",
		fr: "Code",
		ru: "Код"
	},
	date: {
		en: "Date",
		fr: "Date",
		ru: "Дата"
	},
	'default': {		// quotes vs bug IE8
		en: 'Default',
		fr:	'Défaut',
		ru:	"Исходный"
	},
	depth: {
		en: "Depth",
		fr: "Immersion",
		ru: "Глубина"
	},
	disable: {
		en: "Disable",
		fr: "Désactiver",
		ru: "Выключить"
	},
	disabled: {
		en: "Disabled",
		fr: "Désactivé",
		ru:	"Отменён"
	},
	embedded: {
		en: "Embedded",
		fr: "Embarqué",
		ru:	"Вставлен"
	},
	enable: {
		en: "Enable",
		fr: "Activer",
		ru: "Включить"
	},
	enabled: {
		en: "Enabled",
		fr: "Activé",
		ru:	"Применён"
	},
	forced: {
		en: "Forced",
		fr: "Forcé", fr_f: "Forcée",
		ru: "Принудительный"
	},
	frequency: {
		en: "Frequency",
		fr: "Fréquence",
		ru: "Частота"
	},
	hemisphere: {
		en: "Hemisphere",
		fr: "Hémisphère",
		ru: "Полушарие"
	},
	input: {
		en: "Input",
		fr: "Entrée",
		ru: "Вход"
	},
	inputs: {
		en: "Inputs",
		fr: "Entrées",
		ru: "Входы"
	},
	mode: {
		en: "Mode",
		fr: "Mode",
		ru: "Режим"
	},
	n_a: {
		en: "N/A",
		en: "N/A"
	},
	next: {
		en: "Next",
		fr: "Suivant",
		ru: "Следующий"
	},
	no: {
		en: "No",
		fr: "Non",
		ru: "Нет"
	},
	none: {
		en: "None",
		fr: "Aucun", fr_f: "Aucune",
		ru: "Нет" // Отсутствует
	},
	ok: {
		en: "OK",
		fr: "OK",
		ru: "ОК"
	},
	other: {
		en: "Other",
		fr: "Autre",
		ru: "Другой"
	},
	output: {
		en: "Output",
		fr: "Sortie",
		ru: "Выход"
	},
	outputs: {
		en: "Outputs",
		fr: "Sorties",
		ru: "Выходы"
	},
	position: {
		en: "Position",
		fr: "Position",
		ru: "Позиция"
	},
	previous: {
		en: "Previous",
		fr: "Précédent",
		ru: "Предыдущий"
	},
	regular: {
		en: "Regular",
		fr: "Standard",
		ru: "Обычный"
	},
	selected: {
		en: "Selected",
		fr: "Sélectionné"
		// ru ???
	},
	simulation : {
		en: "Simulation",
		fr: "Simulation",
		ru: "Моделирование"
	},
	system: {
		en: "System",
		fr: "Système",
		ru: "Система"
	},
	time: {
		en: "Time",
		fr: "Heure",
		ru: "Время"
	},
	time_left: {
		en: "Left",
		fr: "Restant",
		ru: "Левый"
	},
	'undefined': {			// quotes vs bug IE8
		en: "Undefined",
		fr: "Non défini",
		ru: "Не определено"
	},
	utm_easting: {
		en: "UTM Easting",
		fr: "UTM Est",
		ru: "UTM Восточнее"
	},
	utm_northing: {
		en: "UTM Northing",
		fr: "UTM Nord",
		ru: "UTM Севернее"
	},
	utm_zone: {
		en: "UTM Zone",
		fr: "Zone UTM",
		ru: "Зона UTM"
	},
	utm_hemisphere: {
		en: "UTM Hemisphere",
		fr: "Hémisphère UTM",
		ru: "Полушарие UTM"
	},
	yes: {
		en: "Yes",
		fr: "Oui",
		ru: "Да"
	}
};



// FORMAT DES DATES /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

MSG.date_format =
{
	en: "mm/dd/yyyy",	//yyyy/mm/dd
	fr: "dd/mm/yyyy",
	ru: "dd/mm/yyyy",
	jp: "yyyy/mm/dd",
	cn: "yyyy/mm/dd"
};



// LABELS DES BOUTONS ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

MSG.buttons =
{
	// Général
	no: 		MSG.shared.no,
	yes:		MSG.shared.yes,
	enable:		MSG.shared.enable,
	disable:	MSG.shared.disable,

	save: {
		en: "Save",
		fr: "Enregistrer",
		ru: "Сохранить"
	},
	open: {
		en: "Open",
		fr: "Ouvrir",
		ru: "Открыть"
	},
	close: {
		en: "Close",
		fr: "Fermer",
		ru: "Закрыть"
	},
	lock: {
		en: "Lock",
		fr: "Verrouiller",
		ru: "Заблокировать"
	},
	unlock: {
		en: "Unlock",
		fr: "Déverrouiller",
		ru: "Разблокировать"
	},
	apply: {
		en: "Apply",
		fr: "Appliquer",
		ru: "Применить"
	},
	calibrate: {
		en: "Calibrate",
		fr: "Calibrer",
		ru: "Калибровать"
	},
	create: {
		en: "Create",
		fr: "Créer",
		ru: "Создать"
	},
	send_file: {
		en: "Send File",
		fr: "Envoyer",
		ru: "Отправить<br/>файл"
	},
	restart: {
		en: "Restart",
		fr: "Redémarrer",
		ru: "Перезапустить"
	},
	update: {
		en: "Update",
		fr: "Mettre à jour",
		ru: "Обновить"
	},
	loadfile: {
		en: "Load File",
		fr: "Charger<br/>fichier",
		ru: "Загрузить<br/>файл"
	},
	reset: {
		en: "Reset",
		fr: "RAZ",
		ru: "Сброс"
	},
	clear: {
		en: "Clear",
		fr: "Effacer",
		ru: "Очистить"
	},
	send: {
		en: "Send",
		fr: "Envoyer",
		ru: "Отправить"
	},
	set: {
		en: "Set",
		fr: "Définir",
		ru: "Установить"
	},
	next: MSG.shared.next,
	previous: MSG.shared.previous,

	// Boutons d'annulation/sauvegarde
	cancel_settings: {
		en: "Cancel",
		fr: "Annuler",
		ru: "Отменить"
	},
	validate_settings: MSG.shared.ok,

	// [page settings_management]
	savesettings: {
		en: "Save<br/>Settings",
		fr: "Sauvegarder<br/>configuration",
		ru: "Сохранить<br/>параметры"
	},
	restoresettings: {
		en: "Restore<br/>Settings",
		fr: "Restaurer<br/>configuration",
		ru: "Загрузить<br/>параметры"
	}
};


// LABELS DES BOITES ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

MSG.box =
{
	// [commun]
		// Paramètres avancés
		params_advanced: {
			en: "Advanced Parameters",
			fr: "Paramètres avancés",
			ru: "Дополнительные параметры"
		},
		// Message de déverrouillage des paramètres d'une page
		usermsg_unlock: {
			en: "Click to unlock parameters.",
			fr: "Cliquez pour déverrouiller les paramètres.",
			ru: "Нажмите для разблокирования параметров"
		},
		// Message d'avertissement sur les conséquences d'un déverrouillage des paramètres d'une page
		usermsg_unlock_warning: {
			en: "For expert users only.",
			fr: "Réservé aux utilisateurs experts.",
			ru: "Только для опытных пользователей"
		},
		// Message utilisateur : invitation à redémarrer après avoir modifié la configuration (directement sur le produit pour les cartes GUNS)
		usermsg_restart: {
			en: "Settings have been saved.<br/>Please restart the system to take them into account.",
			fr: "La configuration a été enregistrée.<br/>Le système doit être redémarré pour la prendre en compte.",
			ru: "Параметры сохранены.<br/>Пожалуйста, перезапустите систему для их загрузки."
		},
		// Message utilisateur cartes GUNS : invitation à redémarrer physiquement le système après avoir modifié la configuration
		usermsg_restart_poweroffon: {
			en: "Settings have been saved.<br/>Please restart the system to take them into account.<br/>( Power OFF / Power ON )",
			fr: "La configuration a été enregistrée.<br/>Le système doit être redémarré pour la prendre en compte.<br/>( Power OFF / Power ON )",
			ru: "Параметры сохранены.<br/>Пожалуйста, перезапустите систему для их загрузки.<br/>( Power OFF / Power ON )"
		},

	// [page settings management]
		save_settings_title: {
			en: "Save Settings",
			fr: "Sauvegarder la configuration",
			ru: "Сохранить параметры прибора"
		},
		save_settings_intro: {
			en: "Product settings saving.",
			fr: "Sauvegarde de la configuration du produit.",
			ru: "Сохранение параметров прибора."
		},
		restore_settings_title: {
			en: "Restore Settings",
			fr: "Restaurer la configuration",
			ru: "Загрузить параметры прибора"
		},
		restore_settings_intro: {
			en: "Product settings restoration.",
			fr: "Restauration de la configuration du produit.",
			ru: "Загрузка параметров прибора"
		}
};


// LABELS DES MESURES ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

MSG.data =
{
	status: {
		en: "Status",
		fr: "Statut",
		ru: "Статус"
	},
	event: {
		en: "Event",
		fr: "Evénement",
		ru: "Событие"
	},
	heading: {
		en: "Heading",
		fr: "Cap",
		ru: "Курс"
	},
	polar_heading: {
		en: "Polar Heading",
		fr: "Cap Polaire",
		ru: "Полярный Курс"
	},
	roll: {
		en: "Roll",
		fr: "Roulis",
		ru: "Крен"
	},
	pitch: {
		en: "Pitch",
		fr: "Tangage",
		ru: "Дифферент"
	},
	heading_rate: {
		en: "Heading rate",
		fr: "Vitesse Cap",
		ru: "Скорость Поворота"
	},
	roll_rate: {
		en: "Roll rate",
		fr: "Vitesse Roulis",
		ru: "Скорость крена"
	},

	pitch_rate: {
		en: "Pitch rate",
		fr: "Vitesse tangage",
		ru: "Скорость дифферента"
	},
	stddev: {
		en: "Std. Dev.",
		fr: "Ecart type",
		ru: "Станд. откл."
	},
	latitude: {
		en: "Latitude",
		fr: "Latitude",
		ru: "Широта"
	},
	longitude: {
		en: "Longitude",
		fr: "Longitude",
		ru: "Долгота"
	},
	polar_latitude: {
		en: "Polar Lat.",
		fr: "Lat. Polaire",
		ru: "Поляр.Шир."
	},
	polar_longitude: {
		en: "Polar Long.",
		fr: "Long. Polaire",
		ru: "Поляр.Долг."
	},
	utm_easting   : MSG.shared.utm_easting,
	utm_hemisphere: MSG.shared.utm_hemisphere,
	utm_northing  : MSG.shared.utm_northing,
	utm_zone      : MSG.shared.utm_zone,

	speed: {
		en: "Speed",
		fr: "Vitesse",
		ru: "Скорость"
	},
	noise_level: {
		en: "Noise Lev.",
		fr: "Niv. bruit",
		ru: "Уровень шума."
	},
	noise: {
		en: "Noise",
		fr: "Bruit",
		ru: "Шум"
	},
	date: MSG.shared.date,

	utc_date: {
		en: "UTC Date",
		fr: "Date UTC",
		ru: "дата UTC"
	},
	local_date: {
		en: "Local Date",
		fr: "Date locale",
		ru: "Местное Дата"
	},

	time: MSG.shared.time,

	validity_time: {
		en: "Validity Time",
		fr: "Heure de validité",
		ru: "Время"
	},
	altitude: MSG.shared.altitude,

	depth: MSG.shared.depth,

	speed_x: {
		en: "X Speed",
		fr: "Vitesse X",
		ru: "X Скорость"
	},
	speed_y: {
		en: "Y Speed",
		fr: "Vitesse Y",
		ru: "Y Скорость"
	},
	speed_z: {
		en: "Z Speed",
		fr: "Vitesse Z",
		ru: "Z Скорость"
	},
	speed_x_stddev: {
		en: "X Speed Std. Dev.",
		fr: "Ecart type vitesse X",
		ru: "Станд.откл. X Скорости"
	},
	speed_y_stddev: {
		en: "Y Speed Std. Dev.",
		fr: "Ecart type vitesse Y",
		ru: "Станд.откл. Y Скорости"
	},
	speed_z_stddev: {
		en: "Z Speed Std. Dev.",
		fr: "Ecart type vitesse Z",
		ru: "Станд.откл. Z Скорости"
	},
	north_speed: {
		en: "North Speed",
		fr: "Vitesse Nord",
		ru: "Скорость к Северу"
	},
	east_speed: {
		en: "East Speed",
		fr: "Vitesse Est",
		ru: "Скорость к Востоку"
	},
	vert_speed: {
		en: "Vert. Speed",
		fr: "Vitesse verticale",
		ru: "Верт.Скорость"
	},
	speed_norm: {
		en: "Speed Norm",
		fr: "Norme vitesse",
		ru: "Норм.Скорость"
	},
	velocity: {
		en: "Celerity",
		fr: "Célérité",
		ru: "Скор.Волны"
	},
	utm_north: {
		en: "UTM North",
		fr: "UTM Nord",
		ru: "UTM Север"
	},
	utm_north_stddev: {
		en: "UTM North Std. Dev.",
		fr: "Ecart type UTM Nord",
		ru: "UTM Север Стандарт.Откл."
	},
	utm_east: {
		en: "UTM East",
		fr: "UTM Est",
		ru: "UTM Восток"
	},
	utm_east_stddev: {
		en: "UTM East Std. Dev.",
		fr: "Ecart type UTM Est",
		ru: "UTM Восток Стандарт.Откл."
	},
	system_time: {
		en: "Run Time",
		fr: "Durée de Fonct.",
		ru: "Системное Время"
	},
	utc_time: {
		en: "UTC Time",
		fr: "Heure UTC",
		ru: "Время UTC"
	},
	local_time: {
		en: "Local Time",
		fr: "Heure locale",
		ru: "Местное время"
	},
	last_utc_sync_time: {
		en: "Last UTC Sync Time",
		fr: "Dernière Heure UTC",
		ru: "Последнее время синхр. по UTC"
	},
	utc: {
		en: "UTC",
		fr: "UTC",
		ru: "Время UTC"
	},
	heading_stddev: {
		en: "Heading Std. Dev.",
		fr: "Ecart type cap",
		ru: "Станд.откл. Курса"
	},
	roll_stddev: {
		en: "Roll Std. Dev.",
		fr: "Ecart type roulis",
		ru: "Станд.откл.Крена"
	},
	pitch_stddev: {
		en: "Pitch Std. Dev.",
		fr: "Ecart type tangage",
		ru: "Станд.откл.Дифферента"
	},
	latitude_stddev: {
		en: "Latitude Std. Dev.",
		fr: "Ecart type latitude",
		ru: "Станд.откл.Широты"
	},
	longitude_stddev: {
		en: "Longitude Std. Dev.",
		fr: "Ecart type longitude",
		ru: "Станд.откл.Долготы"
	},
	altitude_stddev: {
		en: "Altitude Std. Dev.",
		fr: "Ecart type altitude",
		ru: "Станд.откл.Перемещения"
	},
	depth_stddev: {
		en: "Depth Std. Dev.",
		fr: "Ecart type immersion",
		ru: "Станд.откл.Глубины"
	},
	north_speed_stddev: {
		en: "North Speed Std. Dev.",
		fr: "Ecart type vitesse Nord",
		ru: "Станд.откл.Скорости к Северу"
	},
	east_speed_stddev: {
		en: "East Speed Std. Dev.",
		fr: "Ecart type vitesse Est",
		ru: "Станд.откл.Скорости к Востоку"
	},
	vert_speed_stddev: {
		en: "Vert. Speed Std. Dev.",
		fr: "Ecart type vitesse vert.",
		ru: "Станд.откл.Верт.Скорости"
	},
	heave: {
		en: "Heave",
		fr: "Pilonnement",
		ru: "ЛП Z"
	},
	surge: {
		en: "Surge",
		fr: "Cavalement",
		ru: "ЛП X"
	},
	sway: {
		en: "Sway",
		fr: "Embardée",
		ru: "ЛП Y"
	},
	heave_speed: {
		en: "Heave Speed",
		fr: "Vitesse de pilonnement",
		ru: "Vлп Z"
	},
	surge_speed: {
		en: "Surge Speed",
		fr: "Vitesse de cavalement",
		ru: "Vлп X"
	},
	sway_speed: {
		en: "Sway Speed",
		fr: "Vitesse d'embardée",
		ru: "Vлп Y"
	},
	mode: MSG.shared.mode,

	north_current: {
		en: "North Current",
		fr: "Courant Nord",
		ru: "Течение к Северу"
	},
	east_current: {
		en: "East Current",
		fr: "Courant Est",
		ru: "Течение к Востоку"
	},
	north_current_stddev: {
		en: "North Current Std. Dev.",
		fr: "Ecart type courant Nord",
		ru: "Станд.откл.Течения к Северу"
	},
	east_current_stddev: {
		en: "East Current Std. Dev.",
		fr: "Ecart type courant Est",
		ru: "Станд.откл.Течения к Востоку"
	},
	nobeacon: {
		en: "Beacon N°",
		fr: "N° beacon",
		ru: "Буй №"
	},
	range: {
		en: "Range",
		fr: "Distance",
		ru: "Диапазон"
	},
	range_stddev: {
		en: "Range Std. Dev.",
		fr: "Ecart type distance",
		ru: "Станд.откл.Диапазона"
	},
	range_slam: {
		en: "Estimated Range",
		fr: "Distance estimée",
		ru: "Приближ.Диапазон"
	},
	range_slam_stddev: {
		en: "Estimated Range Std. Dev.",
		fr: "Ecart type distance estimée",
		ru: "Станд.откл.Приближ.Диапазона"
	},
	range_raw: {
		en: "Measured Range",
		fr: "Distance mesurée",
		ru: "Измер.Диапазон"
	},
	range_raw_stddev: {
		en: "Measured Range Std. Dev.",
		fr: "Ecart type distance mesurée",
		ru: "Станд.откл.Измер.Диапазона"
	},
	temperature: {
		en: "Temperature",
		fr: "Température",
		ru: "Температура"
	},
	north: {
		en: "North",
		fr: "Nord",
		ru: "Север"
	},
	south: {
		en: "South",
		fr: "Sud",
		ru: "Юг"
	},
	east: {
		en: "East",
		fr: "Est",
		ru: "Восток"
	},
	west: {
		en: "West",
		fr: "Ouest",
		ru: "Запад"
	},
	quality: {
		en: "Quality",
		fr: "Qualité",
		ru: "Качество"
	},
	//UPS
	ups_zone: {
		en: "UPS Zone",
		fr: "UPS Zone",
		ru: ""
	},
	ups_north: {
		en: "UPS North",
		fr: "UPS Nord",
		ru: ""
	},
	ups_east: {
		en: "UPS East",
		fr: "UPS Est",
		ru: ""
	},
	//OSGB
	osgb_zone: {
		en: "OSGB Zone",
		fr: "OSGB Zone",
		ru: ""
	},
	osgb_north: {
		en: "OSGB North",
		fr: "OSGB Nord",
		ru: ""
	},
	osgb_east: {
		en: "OSGB East",
		fr: "OSGB Est",
		ru: ""
	},
	osgb_altitude: {
		en: "OSGB Altitude",
		fr: "OSGB Altitude",
		ru: ""
	},
	//MGRS
	mgrs_zone: {
		en: "MGRS Zone",
		fr: "MGRS Zone",
		ru: ""
	},
	mgrs_north: {
		en: "MGRS North",
		fr: "MGRS Nord",
		ru: ""
	},
	mgrs_east: {
		en: "MGRS East",
		fr: "MGRS Est",
		ru: ""
	},
	mgrs_altitude: {
		en: "MGRS Altitude",
		fr: "MGRS Altitude",
		ru: ""
	},
	//GEOREF
	georef_zone: {
		en: "GEOREF Zone",
		fr: "GEOREF Zone",
		ru: ""
	},
	georef_north: {
		en: "GEOREF North",
		fr: "GEOREF Nord",
		ru: ""
	},
	georef_east: {
		en: "GEOREF East",
		fr: "GEOREF Est",
		ru: ""
	},
	georef_altitude: {
		en: "GEOREF Altitude",
		fr: "GEOREF Altitude",
		ru: ""
	},
	//ECEF
	ecef_x: {
		en: "ECEF X",
		fr: "ECEF X",
		ru: ""
	},
	ecef_y: {
		en: "ECEF Y",
		fr: "ECEF Y",
		ru: ""
	},
	ecef_z: {
		en: "ECEF Z",
		fr: "ECEF Z",
		ru: ""
	}
};



// MESSAGES DE STATUT GLOBAL /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

MSG.statuscodes =
{

	// 0-999	Normal ....................................................................

		300: {
			en: "Now tracking",
			fr: "Tracking en cours",
			ru: "Сопровождается"
		},
		400: {
			en: "System shutdown",
			fr: "Système arrêté",
			ru: "Выключение системы"
		},
		401: {
			en: "System initializing",
			fr: "Initialisation",
			ru: "Инициализация системы"
		},
		402: {
			en: "Alignment",
			fr: "Alignement",
			ru: "Выравнивание"
		},
		403: {
			en: "Heave init",
			fr: "Init. pilonnement",
			ru: "Инициализация качки"
		},
		404: {
			en: "System ready",
			fr: "Système ok",
			ru: "Система готова"
		},
		405: {
			en: "Fine Alignment",
			fr: "Alignement fin",
			ru: "Точное выравнивание"
		},
		406: {
			en: "Fast Alignment",
			fr: "Alignement rapide",
			ru: "Быстрое выравнивание"
		},
		407: {
			en: "IMO Alignment",
			fr: "Alignement IMO",
			ru: ""
		},		
		408: {
			en: "Optimal Alignment",
			fr: "Alignement optimal",
			ru: ""
		},
		409: {
			en: "Strategic Alignment",
			fr: "Alignement strategique",
			ru: ""
		},						
	// 1000-1999	Warning messages ..........................................................

		1501: {
			en: "System warning",
			fr: "Alerte système",
			ru: "Предупреждение системы"
		},

	// 2000-2999	Alarm messages ............................................................

		// 2001-2100	Navigation
		2001: {
			en: "Invalid HRP values",
			fr: "CRT invalide",
			ru: "Неверные значения курса, крена, дифферента"
		},
		2002: {
			en: "Altitude saturation",
			fr: "Saturation altitude",
			ru: "Превышен предел верт. перем."
		},
		2003: {
			en: "Speed saturation",
			fr: "Saturation vitesse",
			ru: "Превышен скоростной предел"
		},
		2004: {
			en: "Fast alignment failure",
			fr: "Echec alignement rapide",
			ru: "Ошибка быстрого приведения"
		},
		2005: {
			en: "System saturation",
			fr: "Saturation système",
			ru: "Скорость насыщения"
		},
		// 2500-2599	General
		2501: {
			en: "System error",
			fr: "Erreur système",
			ru: "Ошибка системы"
		},
		// Perte de connexion avec le serveur
		2502: {
			en: "Connection Lost",
			fr: "Perte de connexion",
			ru: "Связь потеряна"
		},
		// 2600-2699	Transpondeurs
		2601: {
			en: "Transponder error",
			fr: "Erreur transpondeur",
			ru: "Ошибка транспондера"
		}
};


// MESSAGES DE STATUT DÉTAILLÉ ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

MSG.detailedstatuscodes = {};	// Spécifique produit


// MESSAGES DE STATUT POUR LA MISE À JOUR DU SYSTÈME /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

MSG.updatestatuscodes =
{
	sending_file: {
		en: "Sending file",
		fr: "Envoi du fichier en cours",
		ru: "Отправка файла"
	},

	// 0-1000	Normal ......................................................................

		// Mise à jour IHM OK
		1: {
			en: "GUI successfully updated.<br/>Please clear your browser cache files (after restart).",
			fr: "L'IHM a été mise à jour avec succès.<br/>Veuillez vider la mémoire cache de votre navigateur internet (après redémarrage).",
			ru: "GUI успешно обновлен.<br/>Пожалуйста, очистите файлы кэша вашего браузера (после перезагрузки)."
		},
		// Mise à jour FirmwareCINT OK
		2: {
			en: "Firmware CINT successfully updated.",
			fr: "Le firmware CINT a été mis à jour avec succès.",
			ru: "Прошивка CINT успешно обновлена"
		},
		// Mise à jour LoaderCINT OK
		3: {
			en: "Loader CINT successfully updated.",
			fr: "Le loader CINT a été mis à jour avec succès.",
			ru: "Загрузчик CINT успешно обновлён"
		},
		// Mise à jour FirmwareDSP OK
		4: {
			en: "Firmware DSP successfully updated.",
			fr: "Le firmware DSP a été mis à jour avec succès.",
			ru: "Прошивка DSP успешно обновлена"
		},
		// Mise à jour LoaderDSP OK
		5: {
			en: "Loader DSP successfully updated.",
			fr: "Le loader DSP a été mis à jour avec succès.",
			ru: "Загрузчик DSP успешно обновлён"
		},
		// Telechargement Library UDP OK
		100: {
			en: "UDP Library successfully updated.",
			fr: "La bibliothèque UDP a été mise à jour avec succès.",
			ru: "Библиотека UDP успешно обновлена"
		},

	// 1001-2000	Warning messages ............................................................


	// 2001-3000	Alarm messages ..............................................................

		// Pas de fichier sélectionné par l'utilisateur
		2001: {
			en: "No file selected !",
			fr: "Aucun fichier n'a été sélectionné !",
			ru: "Нет выбранных файлов!"
		},
		// Erreur interne
		2002: {
			en: "Internal error",
			fr: "Erreur interne",
			ru: "Внутрення ошибка"
		},
		// Mauvais fichier
		2003: {
			en: "Wrong file",
			fr: "Format de fichier inattendu",
			ru: "Неверный файл"
		},
		// Pas en mode loader pour le chargement d'un soft DSP
		2004: {
			en: "Not in loader mode",
			fr: "Pas en mode loader",
			ru: "Не в режиме загрузки"
		},
		// Erreur chargement soft DSP
		2005: {
			en: "DSP software download error",
			fr: "Erreur de téléchargement du programme DSP",
			ru: "Ошибка скачивания програмного обеспечения DSP"
		},
		// Erreur communication firmware
		2006: {
			en: "Firmware communication error",
			fr: "Communication avec le firmware impossible",
			ru: "Ошибка связи прошивки"
		},
		// Erreur Ecruiture Flash
		2007: {
			en: "Flash memory writing error",
			fr: "Erreur lors de l'écriture en Flash",
			ru: "Ошибка записи флеш памяти"
		},
		// Erreur Taille Fichier
		2008: {
			en: "File size error",
			fr: "Taille du fichier trop importante",
			ru: "Ошибка в размере файла"}

		};

// MESSAGES DE STATUTS LIES AUX ENTRÉES, SORTIES ET PULSES (IPD) ///////////////////////////////////////////////////////////////////////////////////////////////////////////////

MSG.iostatuscodes =
{
	// 0-999	Normal ......................................................................

	// 1001-1999	Warning messages ............................................................
		/*'UTC_PULSIN_OVERW'*/ 1001: {
			en: "Warning: Overwritting UTC Synchro In Configuration !",
			fr: "Attention: Ecrasement de la Configuration de l'Entrée de Synchro UTC !",
			ru: "Предупреждение: Замена синхронизации UTC в конфигурации!"
		},
		/*LOG_PULSIN_OVERW'*/ 1002: {
			en: "Warning: Overwritting LOG Synchro In Configuration !",
			fr: "Attention: Ecrasement de la Configuration de l'Entrée de Synchro LOG !",
			ru: "Предупреждение: Замена синхронизации LOG в конфигурации!"
		},
		/*PORT_PULSIN_OVERW'*/ 1003: {
			en: "Warning: Overwritting Output %X% Synchro In Configuration !",
			fr: "Attention: Ecrasement de la Configuration Synchro de la Sortie %X% !",
			ru: "Предупреждение: Замена синхронизации выхода %X% в конфигурации!"
		},
		/*PORT_PULSOUT_OVERW*/ 1004: {
			en: "Warning: Overwritting Output %X% RTC Configuration !",
			fr: "Attention: Ecrasement de la Configuration RTC de la Sortie %X% !",
			ru: "Предупреждение: Замена конфигурации выхода %X% RTC!"
		},
		/*PORT_RSIN_OVERW'*/ 1005: {
			en: "Warning: Overwritting Input %X% Serial Link Parameters !",
			fr: "Attention: Remplacement des Paramètres Série de l'Entrée %X% !",
			ru: "Предупреждение: Замена параметров последовательной связи входа %X%!"
		},
		/*PORT_RSOUT_OVERW'*/ 1006: {
			en: "Warning: Overwritting Output %X% Serial Link Parameters !",
	    	fr: "Attention: Remplacement des Paramètres Série de la Sortie %X% !",
			ru: "Предупреждение: Замена параметров последовательной связи выхода %X%!"
		},
		/*PORT_EVM_OVERW'*/ 1007: {
	    	en: "Warning: Overwritting Event Marker %X% Parameters !",
	    	fr: "Attention: Remplacement des Paramètres de l'Event Marker %X% !"
		},
		/*GPS_UTC_CONF_ADVANS'*/ 1008: {
	    	en: "Warning: No Internal %X% available on ADVANS !",
	    	fr: "Attention: Pas de %X% interne disponible !",
			ru:"Внимание: Нет внутреннего %X% на ADVANS !"
	    },
		/*PORT_INPUT_PULSE_OVERW'*/ 1009: {
	    	en: "Warning: Overwritting Travel Lock Parameters !",
	    	fr: "Attention: Remplacement des paramètres du Travel Lock !"
		},
		/*REPETAER_CONF_ADVANS'*/ 1010: {
	    	en: "Warning: %X% not available on Repeater port on ADVANS !",
	    	fr: "Attention: %X% non disponible sur le port répéteur!"
	    }

	// 2001-2999	Alarm messages ..............................................................
};


// LABELS DES RUBRIQUES /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

MSG.headings =
{
	control: {
		en: "Control",
		fr: "Contrôle",
		ru: "Контроль"
	},
	installation: {
		en: "Installation",
		fr: "Installation",
		ru: "Установка"
	},
	installation_mechanical: {
		en: "Mechanical Parameters",
		fr: "Paramètres mécaniques",
		ru: "Механические параметры"
	},
	installation_inputs: MSG.shared.inputs,

	installation_outputs: MSG.shared.outputs,

	installation_network: {
		en: "Network",
		fr: "Réseau",
		ru: "Сеть"
	},
	installation_go_to_setup: {
		en: "<span class=\"submenu_arrow\">&rarr;</span> Setup Menu",
		fr: "<span class=\"submenu_arrow\">&rarr;</span> Menu paramétrage",
		ru: "<span class=\"submenu_arrow\">&rarr;</span> Меню установки"
	},
	setup: {
		en: "Setup",
		fr: "Paramétrage",
		ru: "Установка"
	},
	setup_init: {
		en: "Init & Update",
		fr: "Init & recalage",
		ru: "Запуск и обновл-е"
	},
	setup_externalsensors: {
		en: "External Sensors",
		fr: "Capteurs externes",
		ru: "Внешн. датчик"
	},
	setup_warnings: {
		en: "Warning Configuration",
		fr: "Configuration des alertes",
		ru: "Предупреждение конфигурации"
	},
	setup_calibration: {
		en: "Calibration",
		fr: "Calibration",
		ru: "Калибровка"
	},
	setup_saverestoresettings: {
		en: "Settings Management",
		fr: "Gestion de la configuration",
		ru: "Управление установками"
	},
	setup_simulationmode: {
		en: "Simulation Mode",
		fr: "Mode simulation",
		ru: "Режим симуляции"
	},
	setup_passwords: {
		en: "Passwords",
		fr: "Mots de passe",
		ru: "Пароли"
	},
	datalogging: {
		en: "Data Logging",
		fr: "Enregistrement de données",
		ru: "Запись данных"
	},
	help: {
		en: "Help",
		fr: "Aide",
		ru: "Помощь"
	},
	maintenance: {
		en: "Maintenance",
		fr: "Maintenance",
		ru: "Поддержка"
	},
	login: {
		en: "Login",
		fr: "Identification",
		ru: "Логин"
	},
	expertview: {
		en: "Navigation Data",
		fr: "Données de navigation",
		ru: "Навигац.данные"
	},
	eventsviewer: {
		en: "Events Viewer",
		fr: "Journal",
		ru: "Просмотр событий"
	},
	chartsview: {
		en: "Charts View",
		fr: "Courbes",
		ru: "Просмотр карт"
	}
};


// PARAMETRES /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

MSG.parameters =
{
	accuracy: {
		en: "Accuracy",
		fr: "Précision",
		ru: "Точность"
	},
	action: {
		en: "Action",
		fr: "Action",
		ru: "Действие"
	},
	activation: {
		en: "Activation",
		fr: "Activation",
		ru: "Активация"
	},
	altitude: MSG.shared.altitude,

	angle: {
		en: "Angle",
		fr: "Angle",
		ru: "Угол"
	},

	attitude: {
		en: "Attitude",
		fr: "Assiette",
		ru: "Положение в пространстве"
	},
	baudrate: {
		en: "Baudrate",
		fr: "Débit<br/>en bauds",
		ru: "Скорость передачи данных"
	},
	code: MSG.shared.code,

	date: MSG.shared.date,

	delay: {
		en: "Delay",
		fr: "Délais",
		ru: "Задержка"
	},
	depth: MSG.shared.depth,

	display: {
		en: "Display",
		fr: "Afficher",
		ru: "Дисплей"
	},
	distance: {
		en: "Distance",
		fr: "Distance",
		ru: "Диапазон"
	},
	duration: {
		en: "Duration",
		fr: "Durée",
		ru: "Длительность"
	},

	frequency: MSG.shared.frequency,

	embedded: MSG.shared.embedded,

	ethernet: {
		en: "Ethernet",
		fr: "Ethernet",
		ru: "Ethernet"
	},
	extratime: {
		en: "Extrapolation",
		fr: "Extrapolation",
		ru: "Экстраполяция"
	},
	falling_edge: {
		en: "Falling Edge",
		fr: "Front Descendant",
		ru: "Падающий Край"
	},
	file: {
		en: "File",
		fr: "Fichier",
		ru: "Файл"
	},
	filter: {
		en: "Filter",
		fr: "Filtre",
		ru: "Фильтр"
	},
	filtering_mode: {
		en: "Filtering Mode",
		fr: "Mode de filtrage",
		ru: "Режим Фильтрации"
	},
	heading: {
		en: "Heading",
		fr: "Cap",
		ru: "Курс"
	},
	heading_stddev: {
		en: "Heading Std. Dev.",
		fr: "Ecart type cap",
		ru: "Станд.откл. Курса"
	},
	heave: {
		en: "Heave",
		fr: "Pilonnement",
		//ru: "Качка"
		ru: "Вертикальное перемещение"
	},
	hemisphere: MSG.shared.hemisphere,

	hide: {
		en: "Hide",
		fr: "Masquer",
		ru: "Скрыть"
	},
	input: MSG.shared.input,

	internal: {
		en: "Internal",
		fr: "Interne",
		ru: "Внутренний"
	},
	ip: {
		en: "IP"
	},
	ipport: {
		en: "Port",
		fr: "Port",
		ru: "Порт"
	},
	latitude: {
		en: "Latitude",
		fr: "Latitude",
		ru: "Широта"
	},
	levellva: {
		en: "Lever Arm",
		fr: "Bras de<br/>levier",
		ru: "Плечо"
	},
	lever_arm_primary: {
		en: "Primary Lever Arm",
		fr: "Bras de levier primaire",
		ru: "Основное смещение"
	},
	lever_arm_secondary: {
		en: "Secondary Lever Arm",
		fr: "Bras de levier secondaire",
		ru: "Вторичное смещение"
	},
	library: {
		en: "Library",
		fr: "Bibliothèque",
		ru: "Библиотека"
	},
	longitude: {
		en: "Longitude",
		fr: "Longitude",
		ru: "Долгота"
	},
	min_duration: {
		en: "Min.<br/>Duration",
		fr: "Durée min.",
		ru: "Минимальная длительность"
	},
	mode: MSG.shared.mode,

	optional: {
		en: "optional",
		fr: "optionnel",
		ru: "Выборочно"
	},
	output: MSG.shared.output,

	parameter: {
		en: "Parameter",
		fr: "Paramètre",
		ru: "Параметр"
	},
	parity: {
		en: "Parity",
		fr: "Parité",
		ru: "Контроль по четности"
	},
	physical_link: {
		en: "Physical<br/>Link",
		fr: "Lien<br/>physique",
		ru: "Физическая связь"
	},
	pitch: {
		en: "Pitch",
		fr: "Tangage",
		ru: "Дифферент"
	},
	pitch_stddev: {
		en: "Pitch Std. Dev.",
		fr: "Ecart type tangage",
		ru: "Станд.откл.Дифферента"
	},
	port: {
		en: "Port",
		fr: "Port",
		ru: "Порт"
	},
	position: MSG.shared.position,

	pps: {
		en: "PPS",
		fr: "PPS",
		ru: "Импульс/с"
	},
	pressure: {
		en: "Pressure",
		fr: "Pression",
		ru: "Давление"
	},
	protocol: {
		en: "Protocol",
		fr: "Protocole",
		ru: "Протокол"
	},
	range: {
		en: "Range",
		fr: "Portée",
		ru: "Диапазон"
	},
	rate: {
		en: "Rate",
		fr: "Fréquence",
		ru: "Скорость"
	},
	rising_edge: {
		en: "Rising Edge",
		fr: "Front Montant",
		ru: "Растущий Край"
	},
	roll: {
		en: "Roll",
		fr: "Roulis",
		ru: "Крен"
	},
	roll_stddev: {
		en: "Roll Std. Dev.",
		fr: "Ecart type roulis",
		ru: "Станд.откл.Крена"
	},
	rtc: {
		en: "RTC",
		fr: "RTC",
		ru: "RTC"
	},
	scale_factor: {
		en: "Scale Factor",
		fr: "Facteur<br/>d'échelle",
		ru: "Масштабный коэффициент"
	},
	sensor: {
		en: "Sensor",
		fr: "Capteur",
		ru: "Сенсор"
	},
	serial: {
		en: "Serial",
		fr: "Série",
		ru: "Последов."
	},
	source: {
		en: "Source",
		fr: "Source",
		ru: "Источник"
	},
	speed: {
		en: "Speed",
		fr: "Vitesse",
		ru: "Скорость"
	},
	standard: {
		en: "Standard",
		fr: "Standard",
		ru: "Стандарт"
	},
	stopbits: {
		en: "Stopbits",
		fr: "Bits<br/>d'arrêt",
		ru: "Стоповые биты"
	},
	surge: {
		en: "Surge",
		fr: "Cavalement",
		ru: "Рысканье"
	},
	sway: {
		en: "Sway",
		fr: "Embardée",
		ru: "Дрейф"
	},
	synchro: {
		en: "Synchro",
		fr: "Synchro",
		ru: "Синхронизация"
	},
	synchro_mode: {
		en: "Synchro Mode",
		fr: "Mode synchro",
		ru: "Режим Синхро"
	},
	synchroin: {
		en: "Synchro In",
		fr: "Entrée<br/>synchro",
		ru: "Синхронно"
	},
	synchroloss0: {	// Setup Warnings
		en: "Do nothing",
		fr: "Ne rien faire",
		ru: "Ничего не делать"
	},
	synchroloss1: {
		en: "Generate warning",
		fr: "Générer une alerte",
		ru: "Показывать предупреждение"
	},
	synchroloss2: {
		en: "Generate error",
		fr: "Générer une erreur",
		ru: "Показывать ошибку"
	},
	system: MSG.shared.system,

	time: MSG.shared.time,

	timeout: {
		en: "Timeout",
		fr: "Tempo.",
		ru: "Время до отключения системы"
	},
	transport_layer: {
		en: "Transport<br/>Layer",
		fr: "Couche<br/>transport",
		ru: "Транспортировать слой"
	},
	type: {
		en: "Type",
		fr: "Type",
		ru: "Тип"
	},
	utm_northing  : MSG.shared.utm_northing,
	utm_easting   : MSG.shared.utm_easting,
	utm_zone      : MSG.shared.utm_zone,
	utm_hemisphere: MSG.shared.utm_hemisphere,

	value: {
		en: "Value",
		fr: "Valeur",
		ru: "Величина"
	},
	stddev: {
		en: "Std. Dev.",
		fr: "Ecart type",
		ru: "Стандартное отклонение"
	},
	zone: {
		en: "Zone",
		fr: "Zone",
		ru: "Зона"
	},
	zda: {
		en: "ZDA"
	}
};


// UNITÉS ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

MSG.units =
{
	baud: {
		en: "Bd",
		fr: "Bd",
		ru: "бод"
	},
	centimeter: {
		en: "cm",
		fr: "cm",
		ru: "см"
	},
	day: {
		en: "d",
		fr: "j",
		ru: "день"
	},
	decibel: {
		en: "dB",
		fr: "dB",
		ru: "Дб"
	},
	degree: {
		en: "°",
		fr: "°",
		ru: "°"
	},
	degree_celcius: {
		en: "°C",
		fr: "°C"
		// ru ??
	},
	degree_fahrenheit: {
		en: "°F",
		fr: "°F"
	},
	degree_per_second: {
		en: "°/s",
		fr: "°/s",
		ru: "°/с"
	},
	foot: {
		en: "ft"
		// on garde la version en dans tous les cas
	},
	foot_per_second: {
		en: "ft/s"
		// on garde la version en dans tous les cas
	},
	gigabyte: {
		en: "GB",
		fr: "Go",
		ru: "GB"
	},
	hectopascal: {
		en: "hPa",
		fr: "hPa",
		ru: "гПа"
	},
	herz: {
		en: "Hz",
		fr: "Hz",
		ru: "Гц"
	},
	hour: {
		en: "h",
		fr: "h",
		ru: "час"
	},
	hour_long: {
		en: "Hour",
		fr: "Heure",
		ru: "Час"
	},
	hours_long: {
		en: "Hours",
		fr: "Heures",
		ru: "часa"
	},
	kelvin: {
		en: "K",
		fr: "K",
		ru: "K"
	},
	kilo_herz: {
		en: "kHz",
		fr: "kHz",
		ru: "кГц"
	},
	kilobyte: {
		en: "kB",
		fr: "ko",
		ru: "kB"
	},
	kilometer_per_hour: {
		en: "km/h",
		fr: "km/h",
		ru: "км/ч"
	},
	miles_per_hour: {
		en: "miles/h",
		fr: "miles/h"
	},
	knot: {
		en: "kt",
		fr: "nd",
		ru: "уз."
	},
	megabyte: {
		en: "MB",
		fr: "Mo",
		ru: "MB"
	},
	meter: {
		en: "m",
		fr: "m",
		ru: "м"
	},
	kilometer: {
		en: "km",
		fr: "km",
		ru: "км"
	},
	meter_per_second: {
		en: "m/s",
		fr: "m/s",
		ru: "м/с"
	},
	meter_per_second2: {
		en: "m/s²",
		fr: "m/s²",
		ru: "м/с²"
	},
	microsecond: {
		en: "µs",
		fr: "µs",
		ru: "µс"
	},
	milligal: {
		en: "mGal",
		fr: "mGal",
		ru: "mGal"
	},
	millimeter: {
		en: "mm",
		fr: "mm",
		ru: "мм"
	},
	milliradian: {
		en: "mrad",
		fr: "mrad",
		ru: "мрад"
	},
	millisecond: {
		en: "ms",
		fr: "ms",
		ru: "мс"
	},
	mil: {
		en: "mil",
		fr: "mil",
		ru: "миля"
	},
	minute: {
		en: "min.",
		fr: "min.",
		ru: "мин."
	},
	minute_latlong: {
		en: "’"
	},
	nanotesla: {
		en: "nT",
		fr: "nT",
		ru: "нТл"
	},
	nanotesla_per_meter: {
		en: "nT/m",
		fr: "nT/m",
		ru: "нТл/м"
	},
	percent: {
		en: "%",
		fr: "%",
		ru: "%"
	},
	permil: {
		en: "‰",
		fr: "‰",
		ru: "‰"
	},
	radian: {
		en: "rad",
		fr: "rad",
		ru: "рад"
	},
	second: {
		en: "s",
		fr: "s",
		ru: "с"
	},
	second_arc: {
		en: "''",
		fr: "''"
	},
	second_latlong: {
		en: "”"
	}
};



// MESSAGES DE SURVOL DU CHEVRON ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

MSG.chevron =
{
	// [page control]
	control_mouseover: {
		en: "Click to open/close detailed status",
		fr: "Cliquez pour ouvrir/fermer les statuts détaillés",
		ru: "Нажмите, чтобы открыть/закрыть подробную информацию о состоянии"
	},
	// [tous les popups externes]
	extpopup_mouseover: {
		en: "Click to view the control page on the main window",
		fr: "Cliquez pour ouvrir la page de controle sur la fenêtre principale",
		ru: "Нажмите, чтобы видеть контрольную страницу в главном окне"
	},
	// [toutes autre page]
	other_mouseover: {
		en: "Click to go to the control page",
		fr: "Cliquez pour retourner à la page de contrôle",
		ru: "Нажмите, чтобы перейти на контрольную страницу"
	}
};



// MODULES DE STATUTS DÉTAILLÉS ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

MSG.sensors = {};




// CAPTEURS (page inputs et popup des statuts détaillés) ///////////////////////////////////////////////////////////////////////////////////////////////////////////

MSG.ext_sensors =
{
 	angles: {
		en: "Angles",
		fr: "Angles",
		ru: "Углы"
	},
	ctd: {
		en: "CTD",
		fr: "CTD",
		ru: "CTD"
	},
	depth: {
		en: "Depth",
		fr: "Pression",
		ru: "Глубина"
	},
	dvl: {
		en: function () {return (GIWIK._ext_sensors && GIWIK._ext_sensors.dvl2) ? MSG.ext_sensors.dvl1.en : "DVL";},
		fr: function () {return (GIWIK._ext_sensors && GIWIK._ext_sensors.dvl2) ? MSG.ext_sensors.dvl1.fr : "DVL";},
		ru: function () {return (GIWIK._ext_sensors && GIWIK._ext_sensors.dvl2) ? MSG.ext_sensors.dvl1.ru : "ГАЛ";}
	},
	dvl1: {
		en: "DVL 1",
		fr: "DVL 1",
		ru: "ГАЛ 1"
	},
	dvl2: {
		en: "DVL 2",
		fr: "DVL 2",
		ru: "ГАЛ 2"
	},
	dvlbt: {
		en: function () {return (GIWIK._ext_sensors && GIWIK._ext_sensors.dvl2) ? MSG.ext_sensors.dvl1bt.en : "DVL BT";},
		fr: function () {return (GIWIK._ext_sensors && GIWIK._ext_sensors.dvl2) ? MSG.ext_sensors.dvl1bt.fr : "DVL BT";},
		ru: function () {return (GIWIK._ext_sensors && GIWIK._ext_sensors.dvl2) ? MSG.ext_sensors.dvl1bt.ru : "DVL Vа";}
	},
	dvl1bt: {
		en: "DVL BT 1",
		fr: "DVL BT 1",
		ru: "ГАЛ Vа 1"
	},
	dvl2bt: {
		en: "DVL BT 2",
		fr: "DVL BT 2",
		ru: "ГАЛ Vа 2"
	},
	dvlwt: {
		en: function () {return (GIWIK._ext_sensors && GIWIK._ext_sensors.dvl2) ? MSG.ext_sensors.dvl1wt.en : "DVL WT";},
		fr: function () {return (GIWIK._ext_sensors && GIWIK._ext_sensors.dvl2) ? MSG.ext_sensors.dvl1wt.fr : "DVL WT";},
		ru: function () {return (GIWIK._ext_sensors && GIWIK._ext_sensors.dvl2) ? MSG.ext_sensors.dvl1wt.ru : "ГАЛ Vо";}
	},
	dvl1wt: {
		en: "DVL WT 1",
		fr: "DVL WT 1",
		ru: "ГАЛ Vо 1"
	},
	dvl2wt: {
		en: "DVL WT 2",
		fr: "DVL WT 2",
		ru: "ГАЛ Vо 2"
	},
	emlog: {
		en: function () {return (GIWIK._ext_sensors && (GIWIK._ext_sensors.emlog2 || GIWIK._ext_sensors.logem2)) ? MSG.ext_sensors.emlog1.en : "EM Log"; },
		fr: function () {return (GIWIK._ext_sensors && (GIWIK._ext_sensors.emlog2 || GIWIK._ext_sensors.logem2)) ? MSG.ext_sensors.emlog1.fr : "Loch EM";},
		ru: function () {return (GIWIK._ext_sensors && (GIWIK._ext_sensors.emlog2 || GIWIK._ext_sensors.logem2)) ? MSG.ext_sensors.emlog1.ru : "EM Лаг"; }
	},
	emlog1: {
		en: "EM Log 1",
		fr: "Loch EM 1",
		ru: "EM Лаг 1"
	},
	emlog2: {
		en: "EM Log 2",
		fr: "Loch EM 2",
		ru: "EM Лаг 2"
	},
	gnss: {
		en: function () {return (GIWIK._ext_sensors && GIWIK._ext_sensors.gps2) ? MSG.ext_sensors.gnss1.en : "GNSS";},
		fr: function () {return (GIWIK._ext_sensors && GIWIK._ext_sensors.gps2) ? MSG.ext_sensors.gnss1.fr : "GNSS";}
	},
	gnss1: {
		en: "GNSS 1",
		fr: "GNSS 1"
	},
	gnss2: {
		en: "GNSS 2",
		fr: "GNSS 2"
	},
	gps: {
		en: function () {return (GIWIK.gnss) ? MSG.ext_sensors.gnss.en() : ((GIWIK._ext_sensors.gps2) ? MSG.ext_sensors.gps1.en() : "GPS");},
		fr: function () {return (GIWIK.gnss) ? MSG.ext_sensors.gnss.fr() : ((GIWIK._ext_sensors.gps2) ? MSG.ext_sensors.gps1.fr() : "GPS");}
	},
	gps1: {
		en: function () {return (GIWIK.gnss) ? MSG.ext_sensors.gnss1.en : "GPS 1";},
		fr: function () {return (GIWIK.gnss) ? MSG.ext_sensors.gnss1.fr : "GPS 1";}
	},
	gps2: {
		en: function () {return (GIWIK.gnss) ? MSG.ext_sensors.gnss2.en : "GPS 2";},
		fr: function () {return (GIWIK.gnss) ? MSG.ext_sensors.gnss2.fr : "GPS 2";}
	},
	gpsvtg: {
		en: function () { return (GIWIK._ext_sensors.gps2) ? MSG.ext_sensors.gps1vtg.en() : "VTG";},
		fr: function () { return (GIWIK._ext_sensors.gps2) ? MSG.ext_sensors.gps1vtg.fr() : "VTG";}
	},
	gps1vtg: {
		en: "VTG 1",
		fr: "VTG 1"
	},
	gps2vtg: {
		en: "VTG 2",
		fr: "VTG 2"
	},
	hrp: {
		en: "HRP",
		fr: "CRT",
		ru: "Курс и углы качки"
	},
	ins: {
		en: "INS",
		fr: "INS"
		// ru ???
	},
	lbl: {
		en: "LBL",
		fr: "LBL",
		ru: "Длинная база"
	},
	odometer: {
		en: "DMI",
		fr: "Odomètre",
		ru: "Одометр"
	},
	position: MSG.shared.position,

	pressure: {
		en: "Pressure",
		fr: "Pression",
		ru: "Давление"
	},
	rangemeter: {
		en: "G2ECO",
		fr: "G2ECO"
		// ru ???
	},
	svp: {
		en: "SV&P",
		fr: "SV&P"
		// ru ???
	},
	telemetry: {
		en: "Telemetry",
		fr: "Télémétrie",
		ru: "Телеметрия"
	},
	temperature: {
		en: "Temperature",
		fr: "Température",
		ru: "Температура"
	},
	usbl: {
		en: function () {return (GIWIK._ext_sensors && GIWIK._ext_sensors.usbl2) ? MSG.ext_sensors.usbl1.en : "USBL";},
		fr: function () {return (GIWIK._ext_sensors && GIWIK._ext_sensors.usbl2) ? MSG.ext_sensors.usbl1.fr : "USBL";}
		// ru ???
	},
	usbl1: {
		en: "USBL 1",
		fr: "USBL 1"
		// ru ???
	},
	usbl2: {
		en: "USBL 2",
		fr: "USBL 2"
		// ru ???
	},
	usbl3: {
		en: "USBL 3",
		fr: "USBL 3"
		// ru ???
	},
	utc: {
		en: function () {return (GIWIK._ext_sensors && GIWIK._ext_sensors.utc2) ? MSG.ext_sensors.utc1.en : "UTC";},
		fr: function () {return (GIWIK._ext_sensors && GIWIK._ext_sensors.utc2) ? MSG.ext_sensors.utc1.fr : "UTC";}
		// ru ???
	},
	utc1: {
		en: "UTC 1",
		fr: "UTC 1"
		// ru ???
	},
	utc2: {
		en: "UTC 2",
		fr: "UTC 2"
		// ru ???
	},
	zupt: {
		en: "ZUPT",
		fr: "ZUPT"
		// ru ???
	}
};



// CONTENU DES LISTES ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
MSG.lists =
{
	// Modes GPS
	gps_mode : {
		0: {
			en: MSG.shared.none.en,
			fr: MSG.shared.none.fr,
			ru: MSG.shared.none.ru
		},
		1: {
			en:	"Natural",
			fr:	"Naturel",
			ru:	"Обычный"
		},
		2: {
			en: "Differential",
			fr: "Différentiel",
			ru:	"Дифференциальный"
		},
		3: {
			en: "Military",
			fr: "Militaire",
			ru:	"Военный"
		},
		4: {
			en: "RTK",
			fr: "RTK",
			ru:	"RTK"
		},
		5: {
			en: "Float RTK",
			fr: "RTK flottant",
			ru:	"Подвижный RTK"
		},
		6: {
			en: "DDR",
			fr: "DDR",
			ru: "DDR"
		},
		7: {	// Norme NMEA 183 (v2.3)
			en: "Manual Input",
			fr: "Entrée manuelle",
			ru:	"Ручной Ввод"
		},
		8: {	// Norme NMEA 183 (v2.3)
			en: "Simulation Mode",
			fr: "Mode simulation",
			ru:	"Режим Моделироания"
		}
	},
	// Parité
	parity: {
		en: [MSG.shared.none.en,"Even","Odd"],
		fr: [MSG.shared.none.fr_f,"Paire","Impaire"],
		ru: [MSG.shared.none.ru,"Чётный","Нечётный"]
	},
	// Parité
	physical_link: {
		en: ["Serial","Ethernet"],
		fr: ["Série","Ethernet"],
		ru: ["Последов.","Ethernet"]
	},
	// Tracking Synchro Mode
	synchro_mode: {
		en: ["Internal","External"],
		fr: ["Interne","Externe"],
		ru:	["Внутренний","Внешний"]
	}
};


// CONFIRMATIONS GÉNÉRALES (à la fermeture/rechargement/changement de page, action importante ) ///////////////////////////////////////////////////////////////////////////
MSG.confirm =
{
    calibration: {
		en: "Do you want to save calibration result?",
		fr: "Voulez vous sauvegarder les résultats de cette calibration ?",
		ru: "Вы хотите сохранить результат калибровки?"
	},
	restart: {
		en: "Do you want to restart the system?",
		fr: "Souhaitez-vous redémarrer le système ?",
		ru: "Вы хотите перезапустить систему?"
	},
	// Toutes les pages (si un paramètre a été modifié et pas sauvegardé)
	unload: {
		en: "Some settings have been changed without having been validated.\nThose changes will be lost if you confirm.",
		fr: "Des paramètres ont été modifiés sans avoir été validés.\nCes changements seront perdus si vous confirmez.",
		ru: "Некоторые параметры были изменены без проверки.\nПри подтверждении изменения не будут сохранены"
	}
};


// MESSAGE D'ATTENTE /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
MSG.please_wait = {
	en: function () {return "<img src=\""+GIWIK.directories.img+"/activity"+GIWIK.css.color_suffix+((GIWIK.css.graphic_charter == 'green') ? GIWIK.css.night_suffix : '')+".gif\" />";}
};


// ALERTES PHASE INITTALISATION //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Messages spécifique à la phase d'init de GIWIK (doivent être mis en mémoire tout au début de la phase d'init, donc AVANT le chargement de la table des messages giwik.msg.js)
MSG.init =
{
	// Navigateur trop ancien pour lancer l'IHM Web
	browser_version: {
		//en:"Your Web browser version does not match the required environment of the IXBLUE Web-Based User Interface (see User Guide for more details).\nPlease update it to get the best from the Web-Based User Interface of your IXBLUE product.",
		//fr:"Votre navigateur Web ne correspond pas à l'environnement requis pour faire fonctionner l'interface Web IXBLUE (cf. documentation). Veuillez le mettre à jour."}
		en: function () {return "Your Web browser \""+GIWIK._context._browser.name+"\" is outdated.\nPlease update it.";},
		fr: function () {return "Votre navigateur Web \""+GIWIK._context._browser.name+"\" est trop ancien.\nVeuillez le mettre à jour.";},
		ru: function () {return "Устаревшая версия \""+GIWIK._context._browser.name+"\" веб-браузера.\nПожалуйста, обновите его.";}
	},
	ie_browser_mode: {
		en: "Warning : Internet Explorer is in compatibility mode.\n\nAfter closing this message's window, please press \"F12\" and select the highest browser mode available.",
		fr: "Attention : Internet Explorer est en mode \"compatibilité\".\n\nAprès avoir fermé la fenêtre de ce message, merci de presser la touche \"F12\" et de sélectionner le mode de navigation le plus élevé.",
		ru: "Внимание: Internet Explorer в режиме совместимости.\n\nПосле закрытия окна сообщения, пожалуйста, нажмите \"F12\" и выберите самый высокий из доступных режимов браузера."
	},
	ie_document_mode: {
		en: "Warning : Internet Explorer is in compatibility mode.\n\nAfter closing this message's window, please press F12 and select the highest document mode available.",
		fr: "Attention : Internet Explorer est en mode \"compatibilité\".\n\nAprès avoir fermé la fenêtre de ce message, merci d'appuyer sur la touche \"F12\" et de sélectionner le mode de document le plus élevé.",
		ru: "Внимание : Internet Explorer в режиме совместимости.\n\nПосле закрытия окна сообщения, пожалуйста, нажмите F12 и выберите самый высокий документальный режим из доступных."
	},
	// Navigateur capable de lancer l'IHM Web mais différent du navigateur qualifié
	non_qualified_browser: {
		en: function () {return "Your Web browser \""+GIWIK._context._browser.name+"\" does not match the qualified environment that enables you to get the best from the iXBlue Web-Based User Interface. (see User Guide for more details)\nYou can install this qualified environment from the provided CD-ROM.\n\nClick \"OK\" if you don't want to be reminded anymore.";},
		fr: function () {return "Votre navigateur Web \""+GIWIK._context._browser.name+" "+GIWIK._context._browser.version+"\" ne correspond pas à l'environnement qualifié vous permettant d'obtenir le meilleur de l'interface Web iXBlue. (cf. le manuel utilisateur pour plus de détails)\nVous pouvez installer cet environnement qualifié depuis le CD-ROM fourni.\n\nCliquez sur \"OK\" si vous ne souhaitez plus être averti.";},
		ru: function () {return "Вашего веб-браузера \""+GIWIK._context._browser.name+"\" не позволяет полностью использовать возможности Пользовательского Веб Интерфейса iXBlue. (см. Руководство пользователя для более подробной информации)\nВы можете установить необходимую систему с поставляемого CD.\n\nНажмите \"OK\" если не хотите последующих напоминаний.";}
	},
	wrong_system_type_in_app: {
		en: "Error : hard defined system type is not valid.",
		fr: "Erreur : le type de système défini en dur est invalide.",
		ru: "Ошибка : не верный тип системы."
	}
};
// Navigateur qualifié mais version trop ancienne
MSG.init.qualified_browser_version = MSG.init.non_qualified_browser;


// ALERTES ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
MSG.alerts =
{
	cookies: {
		en: "Alert : the GUI requires browser cookies to be activated !",
		fr: "Attention : l'IHM nécessite que les cookies du navigateur soient activés !",
		ru: "Предупреждение: Интерфейсу необходимо, чтобы cookies были активированы!"
	},
	license: {
		en: "Alert : Product License not activated !",
		fr: "Attention : la licence du produit n'est pas activée !",
		ru: "Внимание: Лицензия не активирована!"
	},
	update_no_file: {
		en: "Please choose a file.",
		fr: "Merci de choisir un fichier.",
		ru: "Выберите файл."
	}
};

// DEBUG ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
MSG.debug =
{
	plugin_required: {
		en: "Error : plugin \"%host_plugin%\" requires plugin \"%required_plugin%\" !",
		fr: "Erreur : le plugin \"%host_plugin%\" requiert le plugin \"%required_plugin%\" !",
		ru:"Ошибка : присоединено \"%host_plugin%\" требуется \"%required_plugin%\" !"
	}
};

// Indique que le chargement du fichier est terminé
GIWIK._files['giwik.msg.js'].loaded = true;