// PLUGIN COMPASS
GIWIK.init.js(['msg','css'], 'compass');

GIWIK.directories.compass = {"img" : GIWIK.directories.plugins+'/compass/img'};


HEADING.construct._plugins.compass = function ()
{
	// Si la rosace est présente dans l'IHM, elle est visible par défaut
	if (STORAGE.get('display_compass') === undefined)
	{
		STORAGE.setPermanent('display_compass', true);
	}

	if (HEADING.name == 'options')
	{
		if (GIWIK._plugins.compass.display_option)
		{
			GIWIK.write('params_display','<div id="select_compass"></div>','append');

			GIWIK.paramGroup.display('params_display', 'show');

			window.Select_compass = new Input_select('Select_compass', false);
			window.Select_compass.margin_left = HEADING.input_margins;
			window.Select_compass.label_width = HEADING.input_label_width;
			window.Select_compass.construct('select_compass','linear',MSG(['parameters','compass']),[false,true],[MSG(['parameters','hide']),MSG(['parameters','display'])],MSG(['parameters','control_page']),true);
			window.Select_compass.enable();
		}
	}
	else if (HEADING.name == 'control')
	{
		// Pour les IHM gérant par défaut une rosace, on affiche en permanence le popup des statuts détaillés si la div content_main est vide
		if (typeof GIWIK.compass != 'undefined' && document.getElementById('content_main').innerHTML == "")
		{
			STORAGE.setPermanent('popupstatus', 'visible');	// on force la visibilité du popup des statuts au chargement de la page
			window.Statuschevron.setAction(false);			// suppression de l'action au clic sur le chevron
		}
	}
};

HEADING.readConf._plugins.compass = function ()
{
	if (HEADING.name == 'options')
	{
		if (GIWIK._plugins.compass.display_option)
		{
			window.Select_compass.setValue(STORAGE.get('display_compass', true)); // par défaut la rosace est affichée
		}
	}
};

HEADING.readData._plugins.compass = function ()
{
	if (!HEADING.init.isdone) {return;}

	if (HEADING.name == 'control')
	{
		if (!document.getElementById('content_main'))
		{
			return;
		}
		else if (!document.getElementById('compass') && STORAGE.get('display_compass') === true)
		{
			GIWIK.write('content_main','<div class="compass_ctnr"><div id="compass" class="compass"></div><div id="compass_decimals" class="compass_decimals"></div><div id="compass_neddle" class="compass_neddle"></div></div>','append');
		}

		var $compass = $('#compass'),
			$compass_decimals = $('#compass_decimals');

		if ($compass.length)
		{
			var new_heading         = window[system].heading;

			if (new_heading > 360 || new_heading < -180)
			{
				GIWIK.debug('Compass error : invalid heading', new_heading);
				return;
			}

			var new_heading_int     = parseInt(new_heading),
				new_heading_int_180 = (new_heading_int > 180) ? -(360-new_heading_int) : new_heading_int,	// si besoin, passage du cap de 0/360° en -180/+180°
				new_heading_dec     = parseInt((Number(new_heading)-new_heading_int).toFixed(3)*360),
				new_heading_dec_180 = (new_heading_dec > 180) ? -(360-new_heading_dec) : new_heading_dec,	// si besoin, passage du cap de 0/360° en -180/+180°
				factor              = 1,		// La rosace est mise à jour toutes les n exécutions de readData : (1 par défaut, 2 pour limiter la charge CPU)
				easing              = 'easeOutQuad',
				duration            = (HEADING.init.isdone) ? 1400 : 0; // 1400

			if (!HEADING.compass_counter || HEADING.compass_counter >= factor)
			{
				HEADING.compass_counter = 1;
			}
			else if (factor > 1)
			{
				HEADING.compass_counter++;
			}

			// Si la rosace doit être mise à jour cette fois ci
			if (HEADING.compass_counter === 1)
			{
				// Cas spécial IE8
				if (GIWIK._context.ie <= 8)
				{
					/* Animation via jquery.transform2D
						Point positifs :
						 - gestion native de animation et css
						 - gestion native de .stop() pour stopper une animation
						 - compatible IE 8
						Points négatifs du plugin :
						 - pas de gestion de la forme +=Xdeg
						 - bug de rotation au passage de 180 à 181° (demi-tour)
						 - fluidité un peu en retrait du à la non-utilisation des animations CSS
						 - consommation CPU 30-40% > au plugins transit et velocity
						 - pas d'effets 3D
						 - pas de fonctions d'easing incluses
					*/
					$('#compass').stop(true).animate({'transform': 'rotate('+-new_heading_int+'deg)'/*,'animation-direction': 'reverse'*/}, Math.floor((GIWIK.update_timeout*factor)-50)); // , 'easeOutQuint'  // pour jquery.transform2d
					$('#compass_decimals').stop(true).animate({'transform': 'rotate('+-new_heading_dec+'deg)'/*,'animation-direction': 'reverse'*/}, Math.floor((GIWIK.update_timeout*factor)-50)); // , 'easeOutQuint'  // pour jquery.transform2d
				}
				// Cas standard : animation via CSS
				else
				{
					// $('#compass').css({'transform': 'rotate('+-new_heading_int+'deg)'});
					// $('#compass_decimals').css({'transform': 'rotate('+-new_heading_dec+'deg)'});

					/* Animation avec jquery.Transit
						Points positifs :
						 - animation très fluide grâce aux animations CSS (acceleration graphique)
						 - consommation cpu assez faible
						 - gestion native de .css()
						 - gestion de la forme +=Xdeg et d'effets 3D  (pas utilisé ici, résultat assez saccadé par les .transitionStop())
						 - effets 3D
						 - fonctions d'easing incluses
						Points négatifs du plugin :
						 - CAPITAL : pas de gestion native de .stop(), obligation de passer par une version spéciale 0.9.9 de Transit qui inclue transitionStop();
						 	-> https://raw.githubusercontent.com/tblasv/jquery.transit/098e7f1936f40475f1cf20bf949b4be3e08f2c10/jquery.transit.js
						 - bug au passage de 180 à 181 quand des valeurs absolues sont passées (forme Xdeg au lieu de +=Xdeg)
						 - pas de gestion native de .animation(), utilisation de .transition()
						 - incompatible IE 8
					*/

					// $('#compass').transitionStop();  // inutile quand durée anim < période d'actualisation
					// $('#compass').css('transition','').transition({'rotate': -new_heading_int+'deg'}, Math.floor((GIWIK.update_timeout*factor)-50), 'easeInOutQuad'); // easeInOutQuad,easeInOutQuadeaseOutQuad, easeOutSine // pour jquery Transit
					// $('#compass_decimals').transitionStop();
					// $('#compass_decimals').transition({'rotate': -new_heading_dec+'deg'}, Math.floor((GIWIK.update_timeout*factor)-50), 'easeInOutQuad');

					/* Animation avec VelocityJS
						Points positifs :
						 - animation très fluide grâce aux animations CSS (acceleration graphique)
						 - consommation cpu assez faible
						 - gestion de la forme relative +=Xdeg
						 - gestion de l'équivalent de .stop() avec .velocity("stop")
						 - effets 3D
						 - fonctions d'easing incluses
						Points négatifs du plugin :
						 - bug au passage de 359 à 0 quand des valeurs absolues sont passées (forme Xdeg au lieu de +=Xdeg)
						 - pas de gestion native de .animation() et .css(), utilisation de .velocity()
						 	-> syntaxe plus exotique que jquery.transit
						 - incompatible IE 8
					*/
					// Ancienne méthode : méthode absolue -> passage direct du cap cible   METHODE BUGGÉE AU PASSAGE DE 0 ---------------------------------------------
					// $('#compass').velocity('stop').velocity({'rotateZ': -new_heading_int+'deg'}, duration, easing);
					// $('#compass_decimals').velocity('stop').velocity({'rotateZ': -new_heading_dec+'deg'}, {duration: duration, easing: easing});
					//-------------------------------------------------------------------------------------------------------------------------------------------------

					// Nouvelle méthode : méthode relative -> passage de l'angle à appliquer pour atteindre l'angle cible
					// console.log('rotation actuelle: '+rotation, 'nouveau heading: '+new_heading_int, '-> -180/180: '+new_heading_int_180, 'mouvement: '+ rotate);

					// 1) On stoppe la précédente animation puis on applique une nouvelle
					var fx             = GIWIK.fx.rotation,
						rotation_int   = -fx.getCurrent($compass),														// rotation actuelle de la rosace
						rotate_int     = -fx.toTarget(rotation_int, new_heading_int_180),								// angle à ajouter à la rotation actuelle de la rosace
						rotation_dir = (rotate_int > 0) ? -1 : (rotate_int < 0) ? 1 : GIWIK._plugins.compass.last_dir,	// 1: clockwise, -1: anticlockwise
						rotation_dec   = -fx.getCurrent($compass_decimals),												// rotation actuelle des décimales
						rotate_dec     = -fx.toTarget(rotation_dec, new_heading_dec_180, rotation_dir),					// angle à ajouter à la rotation actuelle des décimales
						rotate_dir_dec = (rotate_dec > 0) ? -1 : 1;

					// Mémorisation du sens de rotation pour le cas où les entiers auraient terminé leur rotation avant les décimales
					// -> pour que les décimales continuent leur animation dans le sens initial
					GIWIK._plugins.compass.last_dir = rotation_dir;

					$compass.velocity('stop',true)
					        .velocity({'rotateZ': '+='+rotate_int+'deg'}, {duration: duration, easing: easing});
					$compass_decimals.velocity('stop',true)
					        .velocity({'rotateZ': '+='+rotate_dec+'deg'}, {duration: duration, easing: easing});
				}
			}
		}
	}
};

HEADING.sendConf._plugins.compass = function ()
{
	if (HEADING.name == 'options')
	{
		if (GIWIK._plugins.compass.display_option)
		{
			// Présence de la rosace
			if (window.Select_compass.getValue() !== STORAGE.get('display_compass'))
			{
				// écriture du cookie (permanent) :
				STORAGE.setPermanent('display_compass', eval(window.Select_compass.getValue()));

				if (window.Select_compass.getValue() === true)
				{
					STORAGE.setPermanent('popupstatus', 'hidden');	// pour voir la rosace quand on vient de l'autoriser, sans avoir à fermer le popup des statuts détaillés
				}
			}
		}
	}
};