// PLUGIN EVENTS_VIEWER

GIWIK.init.js(['css','msg'],'events_viewer');


HEADING.is_external_popup = true;


HEADING.display._plugins.events_viewer = function ()
{
	// Fait prendre toute la place disponible au champ de texte
	$('#eventsviewer_data').css({
		width:$(window).width()-80,
		height:$(window).height()-196
	});
};

// Initialisation EventViewer: Efface contenu
HEADING.eventsViewerInitData = function ()
{
	// Si aucune valeur définie pour le nombre d'événements visualisables
	if (typeof GIWIK._plugins.events_viewer.maxevents == 'undefined')
	{
		GIWIK._plugins.events_viewer.maxevents = 100;
	}

	// Efface contenu du <div> EventsData
	document.getElementById("eventsviewer_data").innerHTML = "";

	window.EventsIndex        = -1;	// First Access
	window.EventsNextPrevious = 2;	// Next --> FromOldest

	window.EventNumber        = 0;	// Nombre d'événements stockés
};


// Ajout Message Event Viewer
HEADING.eventsViewerAdd = function (Message, Top_Bottom)
{
	var eventslist = document.getElementById("eventsviewer_data");

	// Stockage evenement
	if (Top_Bottom == "TOP")
	{
		eventslist.innerHTML = Message + "<br/>" + eventslist.innerHTML;
	}
	else
	{
		eventslist.innerHTML += Message + "<br/>";
	}


	// Incrémente le nombre d'événements
	window.EventNumber += 1;

	if (window.EventNumber > GIWIK._plugins.events_viewer.maxevents)
	{
		// Découpage propre au dernier <br/>
		var br_pos = eventslist.innerHTML.lastIndexOf("<br/>");

		if (br_pos == -1){br_pos = eventslist.innerHTML.lastIndexOf("<br>");}

		eventslist.innerHTML = eventslist.innerHTML.substr(0, br_pos);

		window.EventNumber -= 1;
	}
};


// Activation Events: Timer pour récupération Eveneements
HEADING.eventsViewerEnable = function ()
{
	// Si aucune valeur définie pour le timer des capteurs externes
	if (typeof GIWIK._plugins.events_viewer.timeout == 'undefined'){ GIWIK._plugins.events_viewer.timeout = 800; }
	if( System_state.PPP[0]==1 ) {GIWIK._plugins.events_viewer.timeout = 4000;}

	// Timer: Get Sensor Data: Period/2 durant le chargement des anciens evenements
	GIWIK.setTimer("HEADING.getEventsLog();", GIWIK._plugins.events_viewer.timeout/2, 'window.eventsviewertimer');
};


// GetEvents
HEADING.getEventsLog = function ()
{
	var request = GIWIK.cgifile+"?mode=3"+"&EventsLog="+window.EventsIndex+","+window.EventsNextPrevious;

	GIWIK.ajax(request);
};

// Get Conf: reponse lecture Events
HEADING.getConf.local = function ()
{
	var _params = {};

	if (!HEADING.init.isdone)
	{
		_params['PPP'] = "";
	}

	return _params;
}

// Read Conf: reponse lecture Events
HEADING.readConf.local = function ()
{
	// Construction Apres 1er readConf
	if (!HEADING.init.isdone)
	{
		var Alias = "";

		var cnt = ''

		// BoxEvents Viewer
		+'<div id="eventsviewer_data"></div>';

		// Construction de la boite
		$('#content').append(GIWIK.box(cnt, MSG(['box','eventsviewer_title']) +' <span class="box_titleinfoi">'+System_state.Alias+'</span>', false,['box_eventsviewer'], ['', 'box_content_nopadding']));

		// Init
		HEADING.eventsViewerInitData();
		HEADING.eventsViewerEnable();

		return;
	}

	var event_year  = "";
	var event_month = "";
	var event_day   = "";
	var event_hour  = "";
	var event_min 	= "";
	var event_sec   = "";

	var event_datehour = "";
	var event_message = "";
	var event_state = 0;
	var event_date_type = 0;


	// Lecture Reponse Events
	var eventsframe = System_state.EventsLog;


	// Pas de Nouvel Evenement: Remet la periode du timer à sa valeur par défaut
	if (eventsframe == "" && window.lasteventsframe != "" )
	{
		// Si aucune valeur définie pour le timer des capteurs externes
		if(typeof GIWIK._plugins.events_viewer.timeout == 'undefined') {GIWIK._plugins.events_viewer.timeout = 800;}
		if( System_state.PPP[0]==1 ) {GIWIK._plugins.events_viewer.timeout = 3000;}

		// Timer: Get Sensor Data: Period/2 durant le chargement des anciens evenements
		GIWIK.setTimer("HEADING.getEventsLog();", GIWIK._plugins.events_viewer.timeout, 'window.eventsviewertimer');
	}
	else
	{
		// Découpage par Evenements
		var _tabevents = eventsframe.split("$");
	
		// Traitement de chaque evenement
		for (var i=0; i<_tabevents.length; i++)
		{
			// Découpage de la trame selon,
			// - Index, Sen1,Sen2,Alg1,Alg2,Sys1,Sys2,Alg3,YYMMDD,HHMMSS
			var _tabeventdetails = _tabevents[i].split(",");
	
			if (_tabeventdetails.length < 9){continue;}

			// Check Valid Index
			if( eval(_tabeventdetails[0])>window.EventsIndex 												// Last Index + 1
				|| ( _tabeventdetails[0]==0 && (window.EventsIndex<0 || window.EventsIndex>30) ) )  // Index 0: Valid when first or new loop
			{
				// Update Index
				window.EventsIndex = eval(_tabeventdetails[0]);

				// Passage Status vers Tableau Unifié
				var _statusevent = [];
				for (var j=0;j<System_state._ui_status.length; j++)
				{
					_statusevent[j] = (_tabeventdetails[1+j] != "") ? _tabeventdetails[1+j] : 0;
				}
				var unify_status = [];
				unify_status = GIWIK.statusBitsInfo.unify(_statusevent);


				// Lecture Date
				// Rq Date identique au message précédent Date=""
				if (_tabeventdetails[1+System_state._ui_status.length] != "")
				{
					event_year  = _tabeventdetails[1+System_state._ui_status.length].substring(0,2);
					event_month = _tabeventdetails[1+System_state._ui_status.length].substring(2,4);
					event_day   = _tabeventdetails[1+System_state._ui_status.length].substring(4,6);

					// Date par défaut: Get PC Time
					if( event_year<=6 )
					{
						// PC Time
						event_date_type = 0;

						/*Today = new Date;
						event_day = Today.getDate();				if( event_day<10) {event_day = "0"+event_day;}
						event_month = (Today.getMonth())+1;			if( event_month<10) {event_month = "0"+event_month;}
						event_year = Today.getFullYear()-2000
						event_hour = Today.getHours();				if( event_hour<10) {event_hour = "0"+event_hour;}
						event_min = Today.getMinutes();				if( event_min<10) {event_min = "0"+event_min;}
						event_sec = Today.getSeconds();				if( event_sec<10) {event_sec = "0"+event_sec;}*/
					}
					else
					{
						// UTC Time!
						event_date_type = 1;
					}
				}
				// Lecture Heure: Idem Date //(Rq: On ne traite l'heure que dans le cas d'un temps UTC)
				if (_tabeventdetails[2+System_state._ui_status.length] != "" )// && event_date_type==1)
				{
					event_hour  = _tabeventdetails[2+System_state._ui_status.length].substring(0,2);
					event_min   = _tabeventdetails[2+System_state._ui_status.length].substring(2,4);
					event_sec   = _tabeventdetails[2+System_state._ui_status.length].substring(4);
				}

				// Partie Commune Message Date et Heure: Date définie: 		"DD/MM/YYYY - xxh xxm xxs : "
				event_datehour = "";
				event_datehour += "("+((event_date_type==1) ? MSG(['parameters','utc_time']) : MSG(['parameters','pc_time'])) +") : ";
				event_datehour += GIWIK.data.dates.formate(event_day+"/"+event_month+"/"+"20"+event_year);
				event_datehour += " - ";
				event_datehour += event_hour+"h "+event_min+"m "+event_sec+"s ";
				event_datehour += " : ";



				// Partie Spécifique: Message Status
				for (var j=0; j<GIWIK.ui_status_bit_depth*System_state._ui_status.length; j++)
				{
					// Evenement sur ce Status
					if (!unify_status[j] || !GIWIK._status_bits_info[j])
					{
						continue;
					}
					// 1 code pour ce Status
					if (GIWIK._status_bits_info[j].msg > 0)
					{
						// 1 message associé à ce Status
						if (event_message = MSG(['detailedstatuscodes',GIWIK._status_bits_info[j].msg]))
						{
							event_state = GIWIK._status_bits_info[j].status_on;

							// Affichage Message
							HEADING.eventsViewerAdd('<span class="state_'+event_state+'"style="font-weight:normal">'+event_datehour+event_message+'</span>',"TOP");
						}
					}

				}	// Chaq Status
			} //Valid Index
			
		}	// Traitt Chaq Evt
	}	// Nouvel Evenemnt

	// Mémo Last Event Frame
	window.lasteventsframe = eventsframe;

};