// PLUGIN DATALOGGING

GIWIK.init.js(['css','msg'], 'internal_datalogging');

// Elaboration du nom de fichier de logging interne
HEADING.makeInternalLogFilename = function ()
{
	return GIWIK.system_name+'-'+HEADING.makeDateLogFileName()+'_';
};

if (HEADING.name == 'datalogging')
{
	HEADING.readConf._plugins.internal_datalogging = function ()
	{
		if (GIWIK._plugins.datalogging.internal_log && GIWIK._plugins.datalogging.internal_log.enabled === true)
		{
			// Variables Substitutions
			window.FlowsNb = GIWIK._plugins.datalogging.internal_log.flows.length;
			window.Flows = GIWIK._plugins.datalogging.internal_log.flows;

			// Refresh Internal File Browser with Log Dir (if needed)
			var restored_sav_dir = window[system].InternalLogInfos[5];					// Get Log dir from embedded
			restored_sav_dir = restored_sav_dir.substr(0,restored_sav_dir.length-1);	// and remove last '/' (previously added before sending to system)

			// Check if refresh needed: Init or changed by an other user (other computer)
			if( !HEADING.init.isdone || (window.Internal_Filebrowser.getsavedir() != restored_sav_dir) )
			{
				// Refresh Internal File Browser with Log Dir
				window.Internal_Filebrowser.setsavedir( restored_sav_dir );
			}

			// Internal Log Display
			HEADING.internalLog_Display();
		}

	};

	HEADING.getConf._plugins.internal_datalogging = function ()
	{
		var _params = {};

		if (GIWIK._plugins.datalogging.internal_log && GIWIK._plugins.datalogging.internal_log.enabled === true)
		{
			// Internal Log State
			_params['InternalLogInfos'] = "";

			// Port Conf
			for (var i = 0; i < GIWIK._plugins.datalogging.internal_log.output_ports.length; i++)
			{
				_params['PortConf'+GIWIK._plugins.datalogging.internal_log.output_ports[i]] = "";
			}
			for (var i = 0; i < GIWIK._plugins.datalogging.internal_log.input_ports.length; i++)
			{
				if ( !in_array(GIWIK._plugins.datalogging.internal_log.input_ports[i],['X','R','CAN']) )
				{
					_params['PortConf'+GIWIK._plugins.datalogging.internal_log.input_ports[i]] = "";
				}
			}

			// Proto List
			_params['OProList'] = "";
			_params['IProList'] = "";

			// Sensor Conf [UTC detection]
			if (GIWIK.ihm_codename == 'ins')
			{
				_params['ExtSToSerial'] = "";
			}
			else if (GIWIK.ihm_codename == 'gyro')
			{
				_params['UTCINTConf'] = "";
			}
		}

		return _params;
	};

	HEADING.sendConf._plugins.internal_datalogging = function ()
	{
		var _params = {};

		if (GIWIK._plugins.datalogging.internal_log && GIWIK._plugins.datalogging.internal_log.enabled === true)
		{
			var args = "";

			// Log Enabled
			args += window[system].InternalLogInfos[0] +',';

			// AutoLog at StartUp
			args += window.LogAtStartup.getValue() +',';

			// Unused State (by INS)
			if (window.internal_log_request == 1)
			{
				args += '1,';
			}
			else
			{
				args += '0,';
			}

			// Left Space field: Unused by INS
			args += window[system].InternalLogInfos[3] +',';

			// Left Time: Unused by INS
			args += window[system].InternalLogInfos[4] +',';

			// Log directory
			args += escape(window.Internal_Filebrowser.save_dir)+'/,';

			// Root File Name
			args += window.Internal_RootFileName.getValue()+',';

			// Segmentation
			args += window.Internal_option_select.getValue()+',';

			// Segmentation parameter
			args += window.Internal_option_value.getValue()+',';

			// Ports Selection and Suffixes Tables
			var port_selected_w = new Array();
			var port_suffix_w = new Array();

			// Initialize Ports Selection and Suffixes
			for (var i=0; i<(2*window.FlowsNb); i++)
			{
				port_selected_w[i] = '0';
				port_suffix_w[i] = "None";
			}

			// ReMap Ports Selection and Suffixes from IHM
			for (var i=0; i<(2*window.FlowsNb); i++)
			{
				// Outputs And repeater Port: No ReMapping
				if (i <= window.FlowsNb)
				{
					port_selected_w[i] = window['Checkbox_Port_In_'+i].getValue();
					port_suffix_w[i] = window['Internal_FileName_Suffix_In'+i].getValue();
				}
				// Input: ReMapping
				// Ex OCTANS: Port 'D' <= Flow 'A'
				else
				{
					if(i-window.FlowsNb <= GIWIK._plugins.datalogging.internal_log.input_ports.length)
					{
						port_selected_w[window.FlowsNb+window.Flows.indexOf(GIWIK._plugins.datalogging.internal_log.input_ports[i-window.FlowsNb-1])] = window['Checkbox_Port_In_'+i].getValue();
						port_suffix_w[window.FlowsNb+window.Flows.indexOf(GIWIK._plugins.datalogging.internal_log.input_ports[i-window.FlowsNb-1])] =  window['Internal_FileName_Suffix_In'+i].getValue();
					}
				}
			}


			// Add Outputs Selected and Suffix to Request
			for (var i=0; i<(2*window.FlowsNb); i++)
			{
				args += port_selected_w[i] + ',';
				args += port_suffix_w[i];

				if (i < (2*window.FlowsNb-1))
				{
					args += ',';
				}
			}

			// Set Request
			_params['InternalLogInfos'] = args;
		}

		return _params;
	};

	// Construction du contenu de la rubrique
	HEADING.construct._plugins.internal_datalogging = function ()
	{
		if (GIWIK._plugins.datalogging.internal_log && GIWIK._plugins.datalogging.internal_log.enabled === true)
		{
			// Variables Substitutions
			window.FlowsNb = GIWIK._plugins.datalogging.internal_log.flows.length;
			window.Flows = GIWIK._plugins.datalogging.internal_log.flows;

			// Internal Log Box
			// ---------------------
			var cnt = ''

			+'<div id="usermsg_internaldatalogging" class="displaynone"></div>'

			+'<div id="internal_savedir_manage" >'
				+'<table id="internal_savedir_ctnr" class="savedir_ctnr_class">'
					+'<tr>'
						+'<td>'
							+'<div>'
								+'<div id="internal_rootfilename" class="box_leftspace_label_class"></div>'
								+'<div class="box_savedir_class">'
									+'<div id="box_internal_savedir_label" class="box_leftspace_label_class"></div>'
									+'<div id="internal_savedir" class="savedir_class"></div>'
								+'</div>'
								+'<div class="box_savedir_class">'
									+'<div id="box_internal_leftspace_label" class="box_leftspace_label_class"></div>'
									+'<div id="internal_leftspace" class="leftspace_class"></div>'
								+'</div>'
								+'<div class="box_savedir_class">'
									+'<div id="box_internal_remainingtime_label" class="box_leftspace_label_class"></div>'
									+'<div id="internal_remainingtime" class="leftspace_class"></div>'
								+'</div>'
							+'</div>'
						+'</td>'
						+'<td id="startstop_ctnr" >'
							+'<div id="start_internal_logging" class="displaynone"></div>'
						+'</td>'
					+'</tr>'
				+'</table>'
			+ '</div>'

			+'<div id="internal_savedir_parameters" >'
				+'<table id="internal_savedir_ctnr2" class="savedir_ctnr_class">'
					+'<tr>'
						+'<td>'
							+'<div>'
								+'<div class="box_savedir_class">'
								+'<table><tr>'
									+'<td><div id="internal_option_select"></div></td>'
									+'<td><div id="internal_option_value"></div></td>'
								+'</tr></table>'
								+'</div>'
								+'<div class="box_savedir_class">'
									+'<div id="internal_logatstartup" class="leftspace_class"></div>'
								+'</div>'
							+'</div>'
						+'</td>'
					+'</tr>'
				+'</table>'
			+ '</div>'


			// Input Flows: Index 8 to 16
			// - R + A to G
			+'<div id="internal_input_selection">'
				 + '<table class="output_selection_class">';
				for (var i=window.FlowsNb; i<(2*window.FlowsNb); i++)
				{
					cnt += '<tr id="input_selection_tr'+i+'">'
						+ '<td class="checkbox_port_class"><div id="checkbox_port_in_'+i+'"></div></td>'
						+ '<td class="filename_port_class"><div id="filename_port_in_'+i+'"></div></td>'
					+ '</tr>';
				}
				cnt += '</table>'
			+ '</div>'

			// Output Flows: Index 0 to 7
			// - R + A to G
			+'<div id="internal_output_selection">'
				 + '<table class="output_selection_class">';
				for (var i=0; i<window.FlowsNb; i++)
				{
					cnt += '<tr id="input_selection_tr'+i+'">'
						+ '<td class="checkbox_port_class"><div id="checkbox_port_in_'+i+'"></div></td>'
						+ '<td class="filename_port_class"><div id="filename_port_in_'+i+'"></div></td>'
					+ '</tr>';
				}
				cnt += '</table>'
			+ '</div>';


			cnt += '<div id="internal_filebrowser" class="filebrowser_class">'
				+'<div id="internal_filebrowser_content" class="filebrowser_content_class"></div>'
			+'</div>';

			// Construction de la boite
			$('#content').append(GIWIK.box(cnt, MSG(['box','internal_datalogging_title']), true, ['box_internal_datalogging'], ['','box_content_nopadding']));

			cnt = null;


			// Internal Log Objets
			// -------------------------

			// Construction des groupes de parametres
			GIWIK.paramGroup.construct('internal_savedir_manage', MSG(['box','savedir_infos']), 'show');
			GIWIK.paramGroup.construct('internal_savedir_parameters', MSG(['box','savedir_params']), 'show');
			GIWIK.paramGroup.construct('internal_input_selection', MSG(['box','internal_log_inputselect']), 'show');
			GIWIK.paramGroup.construct('internal_output_selection', MSG(['box','internal_log_outputselect']), 'show');
			GIWIK.paramGroup.construct('internal_filebrowser', MSG(['box','savedir_filebrowser']), 'hide');


			// Instanciation de l'objet File_browser gérant l'explorateur de fichier
			window.Internal_Filebrowser = new File_browser('Internal_Filebrowser');
			window.Internal_Filebrowser.setSaveDirField('internal_savedir');
			window.Internal_Filebrowser.setFileBrowseContentField('internal_filebrowser_content');
			window.Internal_Filebrowser.setOperatingMode('cgi');
			window.Internal_Filebrowser.setLogInProgress(0);
			window.Internal_Filebrowser.construct();

			$('#box_internal_savedir_label').attr('title', MSG(['box','open_filebrowser_title']));
			GIWIK.setClick('box_internal_savedir_label', "GIWIK.paramGroup.display('internal_filebrowser', 'show');");

			GIWIK.write('box_internal_savedir_label',MSG(['box','savedir_label']));
			GIWIK.css.setClass('internal_savedir', 'floatleft');

			GIWIK.write('box_internal_leftspace_label',MSG(['box','leftspace_label']));
			GIWIK.write('internal_leftspace',"00"+MSG(['units','percent']));
			GIWIK.css.setClass('internal_leftspace', 'floatleft');

			GIWIK.write('box_internal_remainingtime_label',MSG(['box','remainingtime_label']));
			GIWIK.write('internal_remainingtime',"00"+MSG(['units','percent']));
			GIWIK.css.setClass('internal_remainingtime', 'floatleft');

			document.getElementById('box_internal_leftspace_label').style.width = GIWIK.lang=='en' ? '110px' : '135px';
			document.getElementById('box_internal_remainingtime_label').style.width = GIWIK.lang=='en' ? '110px' : '135px';


			// File Name Input
			window.Internal_RootFileName = new Input_text('Internal_RootFileName', false);
			window.Internal_RootFileName.label_width = 82;
			window.Internal_RootFileName.input_width = 215;
			window.Internal_RootFileName.margin = '10px 15px 0px 0';
			window.Internal_RootFileName.text_align = 'left';
			window.Internal_RootFileName.construct('internal_rootfilename','linear',MSG(['parameters','datalogging_root_filename']),'',false);
			window.Internal_RootFileName.input_path.style.fontWeight = 'normal';
			window.Internal_RootFileName.enable();
			window.Internal_RootFileName.show();
			window.Internal_RootFileName.setValue('');

			// Internal Log Option
			window.Internal_option_select = new Input_select('Internal_option_select', false);
			window.Internal_option_select.margin = '12px 35px 0px 0';
			window.Internal_option_select.label_width = GIWIK.lang=='en' ? 110 : 135;
			window.Internal_option_select.construct('internal_option_select','linear',MSG(['parameters','datalogging_option_label']),array_keys(MSG(['lists','datalogger','options_unit'])),MSG(['lists','datalogger','options_unit']),'',true);
			window.Internal_option_select.setAction('if(window.Internal_option_select.getValue()!=0){window.Internal_option_value.show();} else{window.Internal_option_value.hide(\'displaynone\');}', true);
			window.Internal_option_select.setValue(0);
			window.Internal_option_select.enable();
			window.Internal_option_select.show();

			window.Internal_option_value = new Input_int('Internal_option_value', false);
			window.Internal_option_value.margin = '12px 0px 0px 0';
			//window.Internal_option_value.label_width = 175;
			window.Internal_option_value.construct('internal_option_value','linear','',1/*step*/,0/*min*/,1000000/*max*/,'', 1/*jump*/,true);
			window.Internal_option_value.setValue(0);
			window.Internal_option_value.enable();
			window.Internal_option_value.hide();


			// AutoLog at StartUp
			window.LogAtStartup = new Input_checkbox('LogAtStartup', false);
			window.LogAtStartup.label_width = 175;
			window.LogAtStartup.construct('internal_logatstartup','linear',MSG(['parameters','logatstartup_label']),[0,1],true);
			window.LogAtStartup.setValue(0);
			window.LogAtStartup.enable();
			window.LogAtStartup.show();


			// External DataLogging UserMsg
			window.Usermsg_InternalDatalogging= new User_msg('usermsg_internaldatalogging', false);
			window.Usermsg_InternalDatalogging.margin = '10px 0px 0px 0px';
			window.Usermsg_InternalDatalogging.construct('usermsg_internaldatalogging', 1, '');
			window.Usermsg_InternalDatalogging.hide();

			// Input/Output Flows
			for (var i=0; i<(2*window.FlowsNb); i++)
			{
				// Port suffix name
				window['Internal_FileName_Suffix_In'+i] = new Input_text('Internal_FileName_Suffix_In'+i, false);
				window['Internal_FileName_Suffix_In'+i].label_width = 60;
				window['Internal_FileName_Suffix_In'+i].input_width = 175;
				window['Internal_FileName_Suffix_In'+i].margin = '0px 0px 0px 0px';
				window['Internal_FileName_Suffix_In'+i].construct('filename_port_in_'+i,'linear',MSG(['parameters','datalogging_suffix_filename']),'',false);
				window['Internal_FileName_Suffix_In'+i].setValue('None');
				window['Internal_FileName_Suffix_In'+i].disable();
				window['Internal_FileName_Suffix_In'+i].show();

				// CheckBox
				window['Checkbox_Port_In_'+i] = new Input_checkbox('Checkbox_Port_In_'+i, false);
				window['Checkbox_Port_In_'+i].label_width = 60;
				window['Checkbox_Port_In_'+i].margin = '0px 0px 2px 0px';

				// [Ports A-E]
				var _port_label = "";

				// Repeater Out
				if (i == 0)
				{
					_port_label = MSG(['parameters','repeater_label']);
				}
				// Output
				else if (i < window.FlowsNb)
				{
					_port_label = MSG(['parameters','datalogging_outputport_label'])+' '+GIWIK._plugins.datalogging.internal_log.output_ports[i-1];
				}
				// Repeater In: Unused!
				else if (i == window.FlowsNb)
				{
					_port_label = MSG(['parameters','repeater_label']);
				}
				// Inputs
				else
				{
					_port_label = MSG(['parameters','datalogging_inputport_label'])+' '+GIWIK._input_ports_label[i-window.FlowsNb-1];
				}

				window['Checkbox_Port_In_'+i].construct('checkbox_port_in_'+i,'linear',_port_label,[0,1],true);
				window['Checkbox_Port_In_'+i].setAction( 'HEADING.checkboxPortAction();',false);
				window['Checkbox_Port_In_'+i].setValue(0,'no_action');
				window['Checkbox_Port_In_'+i].enable();
				window['Checkbox_Port_In_'+i].show();
			}

			// Start Logging Button (Common for all ports)
			window.Start_Internal_Logging = new Button('Start_Internal_Logging', false);
			window.Start_Internal_Logging.margin = '0px 0px 0px 0px';
			window.Start_Internal_Logging.construct('start_internal_logging',MSG(['buttons','start_logging']));
			window.Start_Internal_Logging.setAction('HEADING.manageInternalDataLogging();');
			window.Start_Internal_Logging.enable();
			window.Start_Internal_Logging.show();


			// Appel Périodique de Get Conf pour affichage lors log (dont appel immediat!!)
			GIWIK.setTimer("HEADING.refreshConf();", 1000, 'window.internallogtimer');
			window.internallog_refreshcnt = 0;
		}
	};

	// [DAT 19/12/2013 (PHSUR-519)] Trie les index des protocoles en fonction du tri alphabétique de leur noms ("first_value_is_none = true" permet de conserver un paramètre "None" en position 0)
	HEADING.sort_protocols = function (_num, _list)
	{
		var my_extended_list  = new Array(_num,_list);
		var my_index_max      = 0;

		// Check if First protocol is none
		var first_value_is_none = (~System_state.OProList[0].indexOf('NONE')) ? true : false;

		//Si le premier élément n'est pas NONE
		if(first_value_is_none==false)
		{
			for(var i in my_extended_list[1])
			{
				//Recherche de l'indice du dernier protocole avant none
				if(~my_extended_list[1][i].indexOf('NONE'))
				{
					my_index_max = i;
				}
			}

			//Adaptation des indices négatifs (spécifique usine)
			for(var j in my_extended_list[0])
			{
				my_extended_list[0][j] = j-my_index_max;
			}
		}

		var _list_without_none = (first_value_is_none) ? my_extended_list[1].slice(1, count(my_extended_list[1])) : array_copy(my_extended_list[1]);

		//Construction de la chaine contenant l'éventuel label "None"
		var none_list = (first_value_is_none) ? "'"+my_extended_list[1][0]+"'," : "'"+my_extended_list[1][my_index_max]+"',";

		//Tri du tableau des labels (l'éventuelle label "None" reste en position 0)
		var _list_sorted = eval("["+none_list+"'"+array_copy(_list_without_none).sort().join("','")+"']");

		var _num_sorted  = new Array();
		for (var i in _list_sorted)
		{
			_num_sorted.push(my_extended_list[0][array_search(_list_sorted[i], my_extended_list[1], true)]);
		}

		//Suppression du doublon de NONE
		if(first_value_is_none==false)
		{
			for(var i=1;i<count(_list_sorted);i++)
			{
				if(~_list_sorted[i].indexOf('NONE'))
				{
					_num_sorted.splice(i,1);
					_list_sorted.splice(i,1);
				}
			}
		}

		return  {_num : _num_sorted, _list : _list_sorted};
	};

	// Main Internal Logging Display Function
	// --------------------------------------------------
	HEADING.refreshConf = function ()
	{
		// Internal Log Enabled
		if (GIWIK._plugins.datalogging.internal_log && GIWIK._plugins.datalogging.internal_log.enabled === true)
		{
			if (HEADING.init.isdone)
			{
				// A - Log Params Changed: Send Conf to System (Usefull for Base Dir !) [First IT Timer]
				if (window.current_internal_save_dir != window.Internal_Filebrowser.save_dir)
				{
					// Do not send con when window.Internal_Filebrowser.save_dir first defined
					if(window.current_internal_save_dir !== undefined && window.Internal_Filebrowser.save_dir != "undefined" )
					{
						window.internal_log_request = window.current_internal_log_state;
						HEADING.sendConf();
					}
					// Store Curent Save dir (to detect next change) and Reset refresh Request
					window.current_internal_save_dir = window.Internal_Filebrowser.save_dir;
				}


				// B - Log Enable: Update from INS (Time, Size) [Slow Rate]
				else if (window[system].InternalLogInfos[0] == 1)
				{
					// Slower Rate: 5s
					if (++window.internallog_refreshcnt == 5)
					{
						window.internallog_refreshcnt  = 0;

						// Update log infos
						GIWIK.ajax(GIWIK.cgifile+"?mode=3&InternalLogInfos");

						// Log in Progress...
						if (window[system].InternalLogInfos[2] == 1)
						{
							// Update Internal Filebrower(Fils Sizes)
							window.Internal_Filebrowser.getdirlist();
						}
					}
				}
			}
		}
	};

	HEADING.internalLog_Display = function ()
	{
		// Log Disabled: Disabled Internal Log
		if (window[system].InternalLogInfos[0] == 0)
		{
			$('#box_internal_datalogging').html('');
		}

		// Log Enabled
		else
		{
			// Store Log State
			window.internal_log_request = window[system].InternalLogInfos[2];


			// Left Space in percent: Always Update
			GIWIK.write('internal_leftspace', ""+window[system].InternalLogInfos[3]+MSG(['units','percent']));

			// Left Time: Alwaye Update
			if (window[system].InternalLogInfos[2] == 0 || window[system].InternalLogInfos[4] == 0) // No Log => No Left time available
			{
				GIWIK.write('internal_remainingtime', "--");
			}
			else if (window[system].InternalLogInfos[4] > (96*60)) // > 100h
			{
				var remainingtime = ">96"+MSG(['units','hour']);

				GIWIK.write('internal_remainingtime', remainingtime);
			}
			else // Log in progress => Display Left Time XXhXXmin
			{
				var remainingtime = "~";

				var hour = parseInt(window[system].InternalLogInfos[4])/60;
				var min = parseInt(window[system].InternalLogInfos[4])%60;

				if( hour<10) {remainingtime += "0";} remainingtime += ""+parseInt(hour)+MSG(['units','hour']);
				if( min<10) {remainingtime += "0";} remainingtime += ""+parseInt(min)+MSG(['units','minute']);

				GIWIK.write('internal_remainingtime', remainingtime);
			}


			// Internal Log State Modified
			if (typeof window.current_internal_log_state === 'undefined' || window.current_internal_log_state != window[system].InternalLogInfos[2])
			{
				// Automatic Log at StartUp: iff UTC Selected
				if (GIWIK.ihm_codename == 'ins')
				{
					window.UTC_selected = window[system].ExtSToSerial[0];
				}
				else if(GIWIK.ihm_codename == 'gyro')
				{
					window.UTC_selected = window[system].UTCINTConf[0];
				}

				// Automatic Log at StartUp: iff UTC Selected
				if (window.UTC_selected != 0)
				{
					window.LogAtStartup.setValue( window[system].InternalLogInfos[1] );
					window.LogAtStartup.enable();
				}
				else
				{
					window.LogAtStartup.setValue(0);
					window.LogAtStartup.disable();
				}
			}


			// State Modified or Log in Progress
			if (typeof window.current_internal_log_state === 'undefined' || window.current_internal_log_state != window[system].InternalLogInfos[2] || window[system].InternalLogInfos[2] == 1)
			{
				// Update Log State for FileBrowser
				window.Internal_Filebrowser.setLogInProgress(window[system].InternalLogInfos[2] == 1 ? 1 : 0);

				// Segmentation Option
				window.Internal_option_select.setValue(window[system].InternalLogInfos[7]);
				if (window[system].InternalLogInfos[7] == 0)
				{
					window.Internal_option_value.hide('displaynone');
				}
				else
				{
					window.Internal_option_value.show();
				}
				window.Internal_option_value.setValue(parseInt(window[system].InternalLogInfos[8]));

				// Update Ports Selection ssi State modifié
				HEADING.updateInternalLogPortsState();
			}

			// Update Current Log State
			window.current_internal_log_state = window[system].InternalLogInfos[2];


			// Update Message
			HEADING.updateInternalLogMessageState();


			// Update Button State
			HEADING.updateInternalLogButtonState();
		}
	};

	HEADING.updateInternalLogPortsState = function()
	{
		// Port Selection and Suffixes
		var port_selected_r = [];
		var port_suffix_r   = [];


		// Browse Flows
		for (var i=0; i<(2*window.FlowsNb); i++)
		{
			// Default value
			port_selected_r[i] = 0;
			port_suffix_r[i]   = "None";

			// Output and R: No ReMapping
			if (i <= window.FlowsNb)
			{
				port_selected_r[i] = window[system].InternalLogInfos[9+2*(i)];
				port_suffix_r[i] = window[system].InternalLogInfos[9+2*(i)+1];
			}
			// Input: ReMapping
			// Ex: OCTANS Flow 'A' <= Port 'D'
			else
			{
				// Si flux existe dans input_ports
				if (GIWIK._plugins.datalogging.internal_log.input_ports.indexOf(window.Flows[i-window.FlowsNb]) >= 0)
				{
					port_selected_r[(window.FlowsNb+1+GIWIK._plugins.datalogging.internal_log.input_ports.indexOf(window.Flows[i-window.FlowsNb]))] = window[system].InternalLogInfos[9+2*(i)];
					port_suffix_r[(window.FlowsNb+1+GIWIK._plugins.datalogging.internal_log.input_ports.indexOf(window.Flows[i-window.FlowsNb]))] = window[system].InternalLogInfos[9+2*(i)+1];
				}
			}
		}

		window.inputs_available_for_logging = false;

		// For all Output/Input Flows
		for (var i=0; i < (2*window.FlowsNb); i++)
		{
			Proto = 0;

			// Scan Alls Output/Input Flows
			if (i == 0)
			{
				Proto = 1;
			}
			// Output Ports (Flows<8): Depends on Output Protocol
			else if (i<GIWIK._plugins.datalogging.internal_log.output_ports.length+1)
			{
				Proto = eval('window[system].PortConf'+GIWIK._plugins.datalogging.internal_log.output_ports[i-1])[0];
			}
			// repeater Input: Disable
			else if (i == window.FlowsNb)
			{
				Proto = 0;
			}
			// Input Ports(Flows>=8): Depends on Input Protocol
			else if (i > window.FlowsNb && i<(window.FlowsNb)+GIWIK._plugins.datalogging.internal_log.input_ports.length+1)
			{
				Proto = eval('window[system].PortConf'+GIWIK._plugins.datalogging.internal_log.input_ports[i-window.FlowsNb-1])[5];
				if (Proto) window.inputs_available_for_logging = true;
			}

			// Protocol Selected: Enable Log
			if (Proto)
			{
				window['Internal_FileName_Suffix_In'+i].show('displayblock');
				window['Checkbox_Port_In_'+i].show('displayblock');

				GIWIK.css.setClass('input_selection_tr'+i, 'displayblock');
			}
			// Protocol Not selected: Disable Log
			else
			{
				window['Internal_FileName_Suffix_In'+i].setValue('None');
				window['Checkbox_Port_In_'+i].setValue(0,'no_action');

				window['Internal_FileName_Suffix_In'+i].hide();
				window['Checkbox_Port_In_'+i].hide();

				GIWIK.css.setClass('input_selection_tr'+i, 'displaynone');

				// Disable even if Enabled in CINT
				window[system].InternalLogInfos[9+2*(i)]=0;
			}
		}

		if (!window.inputs_available_for_logging)
			GIWIK.css.setClass('internal_input_selection', 'displaynone');

		// Log in progress OR not available...
		if (window[system].InternalLogInfos[2] != 0)
		{
			// Log Files Root Name
			window.Internal_RootFileName.setValue( window[system].InternalLogInfos[6] ) ;

			// Segmentation Parameters Disabled
			window.Internal_option_select.disable();
			window.Internal_option_value.disable();


			// Scan Alls Output/Input Flows
			for (var i=0; i<(2*window.FlowsNb); i++)
			{
				// Check Boxes
				window['Checkbox_Port_In_'+i].setValue( port_selected_r[i], 'no_action');
				window['Checkbox_Port_In_'+i].disable();

				// Files Suffixes
				window['Internal_FileName_Suffix_In'+i].setValue( port_suffix_r[i] );
				window['Internal_FileName_Suffix_In'+i].disable();
			}
		}

		// Log not in progress
		else
		{
			// Sort Output protocol list to take into account Factory Protocol
			var OProList_sorted = HEADING.sort_protocols(array_keys(System_state.OProList), System_state.OProList);
	
			// Log Files Root Name
			window.Internal_RootFileName.setValue( HEADING.makeInternalLogFilename() ) ;

			// Segmentation Parameters Enabled
			window.Internal_option_select.enable();
			window.Internal_option_value.enable();

			// Scan All Output/Input Flows
			for (var i=0; i<(2*window.FlowsNb); i++)
			{
				// Checkbox
				window['Checkbox_Port_In_'+i].setValue( port_selected_r[i], 'no_action' );
				window['Checkbox_Port_In_'+i].enable();

				// Compute Sufix: Repeter
				if (i==0)
				{
					port_suffix_r[i] = 'REPEATER';
				}
				// Compute Sufix: Output Port (including Factory protocols)
				else if (i<GIWIK._plugins.datalogging.internal_log.output_ports.length+1)
				{
					//port_suffix_r[i] = window[system].OProList[eval('window[system].PortConf'+GIWIK._plugins.datalogging.internal_log.output_ports[i-1])[0]];					
					port_suffix_r[i] = OProList_sorted._list[OProList_sorted._num.indexOf(eval('window[system].PortConf'+GIWIK._plugins.datalogging.internal_log.output_ports[i-1])[0])];
				}
				// Compute Sufix: Input Ports
				else if (i>(window.FlowsNb) && i<(window.FlowsNb)+GIWIK._plugins.datalogging.internal_log.input_ports.length+1)
				{
					port_suffix_r[i] = window[system].IProList[eval('window[system].PortConf'+GIWIK._plugins.datalogging.internal_log.input_ports[i-(window.FlowsNb)-1])[5]];
				}

				// Unknown Protocol/Index (Factoty protocols)				
				if( typeof(port_suffix_r[i]) == 'undefined' ){
					port_suffix_r[i] = "Unknown";
				}
				
				// Apply Suffix
				window['Internal_FileName_Suffix_In'+i].setValue( port_suffix_r[i].trim().replace(/\s+/g,'_'), 'no_action');

				// Port Suffix Enable/Disable
				if (port_selected_r[i] == 1)
				{
					window['Internal_FileName_Suffix_In'+i].enable();
				}
				else
				{
					window['Internal_FileName_Suffix_In'+i].disable();
				}
			}
		}
	};

	HEADING.updateInternalLogMessageState = function ()
	{
		var msg = "",
			state = 1;

		if (!HEADING.init.isdone)
		{
			GIWIK.paramGroup.display('internal_savedir_manage',     'show');
			GIWIK.paramGroup.display('internal_savedir_parameters', 'show');
			GIWIK.paramGroup.display('internal_input_selection',    'show');
			GIWIK.paramGroup.display('internal_output_selection',   'show');
			GIWIK.paramGroup.display('internal_filebrowser',        'show');
		}

		// Show/Hide Internal Input Selection depending on avaibility of logging ports (updateInternalLogMessageState is called periodically)
		$('#internal_input_selection')[(window.inputs_available_for_logging) ? 'show' : 'hide']();


		// Log In Progress:
		if (window[system].InternalLogInfos[2] == 1)
		{
			msg = MSG(['box','internal_logging_in_progress']);
			state = 1;
		}

		// Log Stopped
		else if (window[system].InternalLogInfos[2] == 0)
		{
			// ...
		}

		// Log Error: Not enough Space
		else if (window[system].InternalLogInfos[2] < 0)
		{
			if (window[system].InternalLogInfos[2] == -1)
			{
				msg = MSG(['box','no_space_left_for_internal_logging']);
			}
			else
			{
				msg = MSG(['box','internal_logging_error']);
			}
			state = 2;
		}

		// Update Message
		if (msg == "")
		{
			window.Usermsg_InternalDatalogging.hide();
		}
		else if (msg != window.Usermsg_InternalDatalogging.getValue())
		{
			window.Usermsg_InternalDatalogging.setValue(msg);
			window.Usermsg_InternalDatalogging.setStatus(state);
			window.Usermsg_InternalDatalogging.show();
		}
	};

	HEADING.updateInternalLogButtonState = function ()
	{
		var ButtonEnabled = 0;

		// Log In Progress: Button available
		if (window[system].InternalLogInfos[2] == 1)
		{
			// Start/Stop Button State
			window.Start_Internal_Logging.setLabel( MSG(['buttons','stop_logging']) );

			// Buton always enabled when logging
			ButtonEnabled = 1;
		}

		// Log not in progress:
		else if (window[system].InternalLogInfos[2] == 0)
		{
			// Start/Stop Button State
			window.Start_Internal_Logging.setLabel(MSG(['buttons','start_logging']));

			// One or more Output/Input port log selected
			for (var i=0; i<(2*window.FlowsNb); i++)
			{
				if (window['Checkbox_Port_In_'+i].getValue() == '1')
				{
					ButtonEnabled = 1;
				}
			}
		}

		// Log Not Available
		else
		{
			// Start/Stop Button State
			window.Start_Internal_Logging.setLabel(MSG(['buttons','start_logging']));

			ButtonEnabled = 0;
		}

		// Aplication sur Etat du Bouton
		if (ButtonEnabled == 1)
		{
			window.Start_Internal_Logging.enable();
		}
		else
		{
			window.Start_Internal_Logging.disable();
		}
	};

	HEADING.manageInternalDataLogging = function ()
	{
		// Log In Progress:
		// --> Stop logging
		if (window[system].InternalLogInfos[2] == 1)
		{
			// Stop Logging Request
			window.internal_log_request=0;

			// Send Configuration
			HEADING.sendConf();
		}

		// Log not in progress:
		// --> Start Logging
		else
		{
			// Start Logging Request
			window.internal_log_request=1;

			// Send Configuration
			HEADING.sendConf();
		}
	};

	HEADING.checkboxPortAction = function ()
	{
		// Send Conf iff System_state.InternalLogInfos received
		if(typeof window[system].InternalLogInfos != 'undefined')
		{
			// Log not in progres
			if (window[system].InternalLogInfos[2] == 0)
			{
				// One or more Input/Output port log selected
				for (var i=0; i<(2*window.FlowsNb); i++)
				{
					// Suffix disponible ssi sortie dispo pour log
					if (window['Checkbox_Port_In_'+i].getValue() == 1)
					{
						window['Internal_FileName_Suffix_In'+i].enable();
					}
					else
					{
						window['Internal_FileName_Suffix_In'+i].disable();
					}
				}
			}
			// Start button state: Disable si aucun port pour le log
			HEADING.updateInternalLogButtonState();
		}
	};
}


//----------------------------------------------------------------------------------------------------------------------
// Extensions de la classe File_browser spécifiques au "CGI mode" du logging interne
//----------------------------------------------------------------------------------------------------------------------

window.File_browser.prototype.removedir = function (dir)
{
	// Message de confirmation
	if ( !confirm( MSG(['confirm','delete_folder'])+' : '+dir+' ?') ) return;

	// Requete de suppression d'un repertoire
	var request = GIWIK.cgifile+'?mode=4&removedir='+dir+'';

	// Request avec traitement specifique de la reponse
	GIWIK.ajax(request, {eval_rtxt:true, replace_standard_callback:'window.'+this.self+'.getdirlist();'});
};

window.File_browser.prototype.removefile = function (file)
{
	// Message de confirmation
	if ( !confirm( MSG(['confirm','delete_file'])+' : '+file+' ?') ) return;

	// Requete de suppression d'un fichier
	var request = GIWIK.cgifile+'?mode=4&removefile='+file+'';

	// Request avec traitement specifique de la reponse
	GIWIK.ajax(request, {eval_rtxt:true, replace_standard_callback:'window.'+this.self+'.getdirlist();'});
};

window.File_browser.prototype.createfolder = function (dir)
{
	var request = GIWIK.cgifile+"?mode=4";

	// Indication creation rep pour reinit contenu champ saisie Rep
	this.createfolder_done = 1;

	// Requete de crateion de rep: mode=9&createdir=nomdudir
	request += '&createdir=';
	request += this.current_dir.replace(/([^\/])$/gi,'$1/');
	request += eval( 'window.'+this.self+'_Create_Folder').getValue().trim().replace(/[\\\\\"<>:\?\/\*\|]{1}/gi,'-');


	// Request avec traitement specifique de la reponse
	GIWIK.ajax(request, {eval_rtxt:true, replace_standard_callback:'window.'+this.self+'.getdirlist();'});
};