//********************************************
//Author : LBO
//Date : mars 2018
//Description : page permettant de consigner un message dat dans le postprocessing
//********************************************
GIWIK.init.js(['css','msg'],'logbook');

//---------------------------------------------------------------------------------
HEADING.updateDateTime = function ()
{
	var d = new Date();

	window.Input_Hours.setValue((''+(d.getHours())).replace(/(^[0-9]$)/, "0$1"));
	window.Input_Minutes.setValue((''+(d.getMinutes())).replace(/(^[0-9]$)/, "0$1"));
	window.Input_Seconds.setValue((''+(d.getSeconds())).replace(/(^[0-9]$)/, "0$1"));
};

//---------------------------------------------------------------------------------
HEADING.sendConf._plugins.logbook = function ()
{
	var _params = {};
	var filter_msg;
	var hour, minute, second;
	
	if(Checkbox_ManualTime.getValue() == true)
	{
		hour 	= Input_Hours.getValue();
		minute 	= Input_Minutes.getValue();
		second 	= Input_Seconds.getValue();
	}
	else
	{
		hour 	= -1;
		minute 	= -1;
		second 	= -1;
	}
	
	if(window.LogbookMessage.getValue() != ""){
		//reformatage du message, on ne garde que les chiffres, les lettres et les caractres _ . : -
		//le reste sera remplac par des _
		filter_msg = window.LogbookMessage.getValue().replace(/[^a-zA-Z0-9_.:-]/gi,'_');
		
		//on met  jour le champ de saisi poru que l'utilisateur voit le message qui va tre envoy
		window.LogbookMessage.setValue(filter_msg);
		
		//message envoy
		_params['LogbookMessage'] = hour + ','
									+ minute + ','
									+ second + ','
									+ window.LogbookIdentifier.getValue() + ',' 
									+ filter_msg;
	}
		
	return _params;
};	



//---------------------------------------------------------------------------------
HEADING.construct._plugins.logbook = function()
{
	// Gestion du logbook
	
	cnt = ''
		//+'<div id="logbook_intro" class="box_leftintro" style="width: 438px"></div>'
		+'<div id="checkbox_manualtime"></div>'
		+'<div id="manual_clock">'
			+'<table><tr>'
				+'<td><div id="input_hours"class="display_time"></div></td>'
				+'<td class="time_separator_sys">:</td>'
				+'<td><div id="input_minutes"class="display_time"></div></td>'
				+'<td class="time_separator_sys">:</td>'
				+'<td><div id="input_seconds"class="display_time"></div></td>'
			+'</tr></table>'
		+'</div>'		
		+'<div id="logbook_identifier" class="box_leftintro"></div>'
		+'<div id="logbook_message" class="box_leftintro"></div>'

	$('#content').append(GIWIK.box(cnt, '', true, ['box_logbook'], ['', 'box_content_nopadding']));
	
	GIWIK.write('box_logbook_title', MSG(['box','logbook_title']));
	//GIWIK.write('logbook_intro', MSG(['box','logbook_intro']));

	HEADING.labels_width = 80;
	HEADING.inputs_width = 38;	
	HEADING.inputs_width_text = 30;
	
	window.Checkbox_ManualTime = new Input_checkbox('Checkbox_ManualTime', true);
	window.Checkbox_ManualTime.label_width = HEADING.labels_width;
	window.Checkbox_ManualTime.construct('checkbox_manualtime','linear',MSG(['parameters','manual_time_label']),[false,true],true);
	window.Checkbox_ManualTime.setAction("if (window.Checkbox_ManualTime.getValue() === false){$('#manual_clock').slideUp(200);}else{$('#manual_clock').slideDown(200);}");
	window.Checkbox_ManualTime.setValue(false);
	window.Checkbox_ManualTime.show();	
	
	$('#checkbox_manualtime').css('display','inline-table');
	$('#checkbox_manualtime').css('width','438px');;
		
	//heure
	window.Input_Hours = new Input_int('Input_Hours', true);
	window.Input_Hours.label_width = HEADING.labels_width;
	window.Input_Hours.input_width = HEADING.inputs_width_text;
	window.Input_Hours.construct('input_hours','linear',MSG(['parameters','time']),1,0,23,"");
	window.Input_Hours.show();

	//minutes
	window.Input_Minutes = new Input_int('Input_Minutes', true);
	window.Input_Minutes.input_width = HEADING.inputs_width_text;
	window.Input_Minutes.construct('input_minutes','linear','',1,0,59,"");
	window.Input_Minutes.show();

	//secondes
	window.Input_Seconds = new Input_int('Input_Seconds', true);
	window.Input_Seconds.input_width = HEADING.inputs_width_text;
	window.Input_Seconds.construct('input_seconds','linear','',1,0,59,"");
	window.Input_Seconds.show();	
	
	
	//identifier
	window.LogbookIdentifier = new Input_int('LogbookIdentifier', true);
	window.LogbookIdentifier.label_width = HEADING.labels_width;
	window.LogbookIdentifier.input_width = 100;
	window.LogbookIdentifier.margin = 0;	
	window.LogbookIdentifier.construct('logbook_identifier'	,'linear',MSG(['box','logbookidentifier_label']),1,0,4294967295,"");
	window.LogbookIdentifier.setValue(0);
	window.LogbookIdentifier.show();
	
	//message
	window.LogbookMessage = new Input_text('LogbookMessage', true);
	window.LogbookMessage.margin = '0px 0 10px 0';
	window.LogbookMessage.input_width = 348;
	window.LogbookMessage.label_width = HEADING.labels_width;
	window.LogbookMessage.text_align = 'left';
	window.LogbookMessage.construct('logbook_message','linear',MSG(['box','logbook_label']),'',true);
	window.LogbookMessage.disable();
	window.LogbookMessage.show();
	window.LogbookMessage.input_max_length = 32;
	
	HEADING.updateDateTime();
};

