GIWIK.init.js('css');


HEADING.setSettingsActivity.local = function (action)
{
	if (action == 'enable')
	{
		HEADING._displayed_switches = [];

		HEADING.display_exts_box = false;

		// Initialisation des switches
		for (var i in HEADING._ext_sensors_switches)
		{
			var exts_name   = HEADING._ext_sensors_switches[i],
				object_name = "Switch_"+exts_name;

			if (exts_name == "zupt")
			{
				if (GIWIK.zuptmode)
				{
					// Si le capteur externe n'est pas configuré
					if (System_state.ModeZUP[1] === 0)
					{
						// On le masque : il ne peut être ni activé, ni désactivé
						window[object_name].disable();
						window[object_name].hide();

						$('#switch_'+exts_name+'_ctnr').css('display','none');
					}
					// Si le capteur externe ZUPT est configuré
					else
					{
						HEADING._displayed_switches.push(exts_name);

						//On positionne le switch dans l'état correspondant à l'embarqué
						window[object_name].setValue(eval(System_state.ModeZUP[0]), 'no_action');

						// On l'affiche
						window[object_name].enable();
						window[object_name].show();

						$('#switch_'+exts_name+'_ctnr').css('display','');

						HEADING.display_exts_box = true;
					}
				}
			}
			else
			{
				var ext_serial_index = array_search(exts_name.replace(/dvl.t/,"dvl").replace(/dvl2.t/,"dvl2").replace(/gpsvtg/,"gps").replace(/gps2vtg/,"gps2"), GIWIK._extsensors_fulllist);

				// On positionne le switch dans l'état correspondant à l'embarqué
				for (var sensor_id in GIWIK._extsensors_kfmfulllist)
				{
					var sensor_name = GIWIK._extsensors_kfmfulllist[sensor_id];

					if (sensor_name == exts_name)
					{
						if (System_state.KFMExtSensor[sensor_id] === 1)
						{
							window[object_name].setValue(0, 'no_action');
						}
						else //if ((System_state.KFMExtSensor[sensor_id] == 2) || (System_state.KFMExtSensor[sensor_id] == 0))
						{
							window[object_name].setValue(1, 'no_action');
						}
					}
				} // fin for sensor id


				// Si le capteur externe n'est pas configuré
				if (System_state.ExtSToSerial[ext_serial_index] === 0)
				{
					// On le masque car il ne peut pas être activé
					window[object_name].disable();
					window[object_name].hide();

					GIWIK.css.setClass('switch_'+exts_name+'_ctnr', 'displaynone');
				}
				// Si le capteur externe est configuré
				else
				{
		            if (!GIWIK.enable_forced_sensor)
		            {
					    HEADING._displayed_switches.push(exts_name);

					    //On positionne le switch dans l'état correspondant à l'embarqué
						window[object_name].setValue(eval(System_state.ModeZUP[0]), 'no_action');

						// On l'affiche
						window[object_name].enable();
						window[object_name].show();

						apply_css_class('switch_'+exts_name+'_ctnr', 'exts_ctnr');

						HEADING.display_exts_box = true;
	                }
	                else
	                {
	                	// Chaine "forced" pour les capteurs en mode forcé
	                	var forced = ' <span style="color:'+GIWIK.css.color_2+';font-size:11px">'+MSG(['parameters','forced'],{font_case:'lower'})+'</span>';

						// et qu'il n'est pas en mode forcé (Always True)
						if (  (exts_name == "gps"      && System_state.GPS1Forced     === 0)
						   || (exts_name == "gps2"     && System_state.GPS2Forced     === 0)
						   || (exts_name == "usbl"     && System_state.USBL1Forced    === 0)
						   || (exts_name == "usbl2"    && System_state.USBL2Forced    === 0)
						   || (exts_name == "usbl3"    && System_state.USBL3Forced    === 0)
						   || (exts_name == "logem"    && System_state.LEM1Forced     === 0)
						   || (exts_name == "logem2"   && System_state.LEM2Forced     === 0)
						   || (exts_name == "lbl"      && System_state.LBLForced      === 0)
						   || (exts_name == "dvlbt"    && System_state.DVLBTForced    === 0)
						   || (exts_name == "dvlwt"    && System_state.DVLWTForced    === 0)
						   || (exts_name == "dvl2bt"   && System_state.DVL2BTForced   === 0)
						   || (exts_name == "dvl2wt"   && System_state.DVL2WTForced   === 0)
						   || (exts_name == "depth"    && System_state.DepthForced    === 0)
						   || (exts_name == "odometer" && System_state.OdometerForced === 0)
						   || (exts_name == "dov") 
						   || (exts_name == "angles") 
						   || (exts_name == "gpsvtg"    && System_state.VTG1Forced    === 0)
						   || (exts_name == "gps2vtg"   && System_state.VTG2Forced    === 0)
						   )
						{
							// On l'affiche
							HEADING._displayed_switches.push(exts_name);

							window[object_name].setLabel(HEADING._ext_sensors_switches_labels[exts_name]);
							window[object_name].enable();
							window[object_name].show();

							GIWIK.css.setClass('switch_'+exts_name+'_ctnr', 'exts_ctnr');

							HEADING.display_exts_box = true;
						}
				        // et qu'il est en mode forcé (Always True)
						else if (  (exts_name == "gps" && System_state.GPS1Forced     === 1)
						   || (exts_name == "gps2"     && System_state.GPS2Forced     === 1)
						   || (exts_name == "usbl"     && System_state.USBL1Forced    === 1)
						   || (exts_name == "usbl2"    && System_state.USBL2Forced    === 1)
						   || (exts_name == "usbl3"    && System_state.USBL3Forced    === 1)
						   || (exts_name == "logem"    && System_state.LEM1Forced     === 1)
						   || (exts_name == "logem2"   && System_state.LEM2Forced     === 1)
						   || (exts_name == "lbl"      && System_state.LBLForced      === 1)
						   || (exts_name == "dvlbt"    && System_state.DVLBTForced    === 1)
						   || (exts_name == "dvlwt"    && System_state.DVLWTForced    === 1)
						   || (exts_name == "dvl2bt"   && System_state.DVL2BTForced   === 1)
						   || (exts_name == "dvl2wt"   && System_state.DVL2WTForced   === 1)
						   || (exts_name == "depth"    && System_state.DepthForced    === 1)
						   || (exts_name == "odometer" && System_state.OdometerForced === 1) 
						   || (exts_name == "gpsvtg"   && System_state.VTG1Forced     === 1)
						   || (exts_name == "gps2vtg"  && System_state.VTG2Forced     === 1) )
	                    {
							// On l'affiche mais il est désactivé car on est en mode "Always True" donc on n'autorise pas le mode "Always False" ou le mode "Automatic Reacquisition"
							// Il est prévu, dans une version future de faire apparaître en orange le texte "Forcé" sous le switch en question
							// ce qui permet à l'utilisateur de comprendre pourquoi il ne peut pas agir sur le switch
							HEADING._displayed_switches.push(exts_name);

							window[object_name].setValue(1);
							window[object_name].setLabel('<div class="switch_label_forced">'+HEADING._ext_sensors_switches_labels[exts_name] + forced+'</div>');
							window[object_name].disable();
							window[object_name].show();

							GIWIK.css.setClass('switch_'+exts_name+'_ctnr', 'g');

							HEADING.display_exts_box = true;
						}
	                }
				}
			} // fin test zupt
		} // for for switches

		// Gestion de l'alignement des switches -----------------------------------------------------------------------------------------
		var nb_switches = count(HEADING._displayed_switches),
			id_switch_ctnr,
			id_exts_ctnr = document.getElementById('exts_ctnr'),
			i;

		// Styles des conteneurs de chaque switch
		for (i in HEADING._displayed_switches)
		{
			id_switch_ctnr = document.getElementById('switch_'+HEADING._displayed_switches[i]+'_ctnr');
			id_switch_ctnr.style.display = (GIWIK._context.ie < 9) ? 'inline' : 'inline-block';
		}

		if (HEADING.init.isdone)
		{
			HEADING.display.local();
		}
	}
};

HEADING.display.local = function ()
{
	var coordsys = GIWIK.data.coordinates.modes[GIWIK.coordinate_mode];

	// Pour la fluidité d'affichage, lors de la phase d'init on attend la fonction HEADING.setSettingsActivity.local depuis laquelle est appelée HEADING.display.local
	if (!HEADING.init.isdone)
	{
		// Si le système de coordonnées comprend déjà une altitude, on masque l'altitude "standard"
		if (coordsys.specific_altitude)
		{
			$('#altitude_info').hide();
		}
		return;
	}
	// Affichage des données en fonction du système de coordonnées (1: UTM) ———————————————————————————————————————————————————————————————————————————
	$('.data_fullcompact' ).css('line-height', (!GIWIK.heave) ? '36px' : '29px');
	$('.data_smallcompact').css('line-height', (!GIWIK.heave) ? '31px' : '23px');

	var num_data2 = coordsys.num_values + ((GIWIK.alti_depth && !coordsys.specific_altitude) ? 1 : 0);

	// $('.data2_full,.data2_fullcompact').css({
	// 	'line-height'   : GIWIK.coordinate_mode === 1 ? (GIWIK.alti_depth ? '23px' : '28px') : (GIWIK.alti_depth ? '25px' : '32px'),
	// 	'margin-top'    : GIWIK.coordinate_mode === 1 ? (GIWIK.alti_depth ? '-5px' : '-2px') : (GIWIK.alti_depth ? '-2px' : '0px'),
	// 	'margin-bottom' : GIWIK.coordinate_mode !== 1 && !GIWIK.alti_depth ? '10px' : '0px'
	// });

	// $('.data2_small,.data2_smallcompact').css({
	// 	'line-height'   : GIWIK.coordinate_mode === 1 ? (GIWIK.alti_depth ? '17px' : '') : (GIWIK.alti_depth ? '20px' : '27px'),
	// 	'margin-top'    : GIWIK.coordinate_mode === 1 ? (GIWIK.alti_depth ? '-2px' : '0px') : (GIWIK.alti_depth ? '0px' : '0px'),
	// 	'margin-bottom' : GIWIK.coordinate_mode !== 1 && !GIWIK.alti_depth ? '6px' : '0px'
	// });

	$('.data2_full,.data2_fullcompact').css({
		'line-height'   : (num_data2 === 2) ? '32px' : (num_data2 === 3) ? '27px' : '23px',
		'margin-top'    : (num_data2 === 2) ? '0px'  : (num_data2 === 3) ? '-2px' : '-5px',
		'margin-bottom' : (num_data2 === 2) ? '10px' : '0px'
	});

	$('.data2_small,.data2_smallcompact').css({
		'line-height'   : (num_data2 === 2) ? '27px' : (num_data2 === 3) ? '20px' : '17px',
		'margin-top'    : (num_data2 === 2) ? '0px'  : (num_data2 === 3) ? '0px'  : '-2px',
		'margin-bottom' : (num_data2 === 2) ? '6px'  : '0px'
	});

	// Affichage des switchs ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
	var num_switches_per_line = (GIWIK.window_size == 'full') ? 6 : 5;

	// Affichage de la boite des capteurs externes si au moins 1 capteur est affiché
	if (HEADING.display_exts_box)
	{
		var i=1;
		$('#switch_'+HEADING._displayed_switches.join(',#switch_')).each(function(j){

			// Gestion de l'espacement entre les switchs en fonction de la taille de la fenêtre
			if (GIWIK.window_size == 'full'){$(this).css('margin', (count(HEADING._displayed_switches) < num_switches_per_line) ? '0px 30px' : '0 20px');}
			else							{$(this).css('margin', (count(HEADING._displayed_switches) < num_switches_per_line) ? '0px 25px' : '0 14px');}

			// Marge haute pour les switchs en seconde ligne
			if (i > num_switches_per_line){$(this).css('margin-top', '10px');}

			// Marge gauche nulle pour les 1ers switchs de chaque ligne
			if ((i-1) % num_switches_per_line === 0){$(this).css({'margin-left': '0'/*,'background':'blue'*/});}

			// Marge droite nulle pour les derniers switchs de chaque ligne
			if (in_array(i, [num_switches_per_line,num_switches_per_line*2,num_switches_per_line*3]) || i === count(HEADING._displayed_switches)){$(this).css({'margin-right': '0'/*,'background':'green'*/});}

			i++;
		});

		$('#box_exts').css('display', '');
	}
	else
	{
		$('#box_exts').css('display','none');
	}
};

HEADING.readData.local = function ()
{
	// Alignement,Alignement fin, navigation, Alignement Optimal, Alignement Strategic, System Ready, Alignement Rapide, Wait For Position
	if (System_state._ui_status[2]&0xF || System_state._ui_status[3]&0x00400000 || System_state._ui_status[5]&0x00200000 || System_state._ui_status[6]&0xE0000000 || System_state._ui_status[7]&0x40000)
	{
		if (window.waitposition_action)
		{
			MSG.setGlobalStatus
			(
				1502,
				null,
				"",
				2
			);
		}
		else if (window.alignment_action)
		{
			MSG.setGlobalStatus
			(
				402,
				null,
				MSG(['data','remain_algnt_time'])+" "+GIWIK.data.process('remain_algnt_time', System_state.remain_algnt_time, 'time'),
				1
			);
		}
		else if (window.fastalignment_action)
		{
			MSG.setGlobalStatus
			(
				MSG(['statuscodes',406]) + '<span class="remain_algnt_time">('+GIWIK.data.process('remain_algnt_time', System_state.remain_algnt_time, 'time')+' '+MSG(['shared','time_left'],{font_case:'lower'})+')</span>',
				null,
				((GIWIK.stddev) ? MSG(['data','heading_stddev'])+" "+GIWIK.data.process('heading_stddev', System_state.heading_stddev, 'angle')+" " : " "),
				1
			);
		}
		else if (window.finealignment_action)
		{
			MSG.setGlobalStatus
			(
				405,
				null,
				(GIWIK.stddev) ? MSG(['data','heading_stddev'])+" "+GIWIK.data.process('heading_stddev', System_state.heading_stddev, 'angle') : "",
				1
			);
		}
		else if(window.IMOalignment_action)
		{
			MSG.setGlobalStatus
			(
				407,
				null,
				(GIWIK.stddev) ? MSG(['data','heading_stddev'])+" "+GIWIK.data.process('heading_stddev', System_state.heading_stddev, 'angle') : "",
				1
			);			
		}		
		else if(window.optimalalignment_action)
		{
			MSG.setGlobalStatus
			(
				408,
				null,
				(GIWIK.stddev) ? MSG(['data','heading_stddev'])+" "+GIWIK.data.process('heading_stddev', System_state.heading_stddev, 'angle') : "",
				1
			);			
		}
		else if(window.strategicalignment_action)
		{
			MSG.setGlobalStatus
			(
				409,
				null,
				(GIWIK.stddev) ? MSG(['data','heading_stddev'])+" "+GIWIK.data.process('heading_stddev', System_state.heading_stddev, 'angle') : "",
				1
			);			
		}
		else if(window.systemready_action)
		{
			MSG.setGlobalStatus
			(
				404,
				null,
				"",
				1
			);			
		}
	}

	// Mode GPS ———————————————————————————————————————————————————————————————————————————————————————————
	if (System_state._gps_modes && GIWIK.is_gyro===false )
	{
		//if (!HEADING.init.isdone)
		{
			$('#'+GIWIK.statusBitsInfo.msgDomId(13 + 32*2/*GPS1 valid*/)).append(' <span id="gps1_mode"></span>');
			$('#'+GIWIK.statusBitsInfo.msgDomId( 5 + 32*3/*GPS2 valid*/)).append(' <span id="gps2_mode"></span>');
		}

		var gps1_mode = System_state._gps_modes[0];
		var gps2_mode = System_state._gps_modes[1];

		$('#gps1_mode').html((gps1_mode > -1) ? "("+MSG(['lists','gps_mode',gps1_mode])+")" : "");
		$('#gps2_mode').html((gps2_mode > -1) ? "("+MSG(['lists','gps_mode',gps2_mode])+")" : "");
	}

	// Status données polaires_____________________________________________________________________________
	if( GIWIK.is_gyro===true )
	{
		// Polar status in Polar mode only
		if( GIWIK.coordinate_mode !== 2 )
		{
			$('#'+GIWIK.statusBitsInfo.msgDomId(14 + 32*2/*Polar Not Valid*/)).remove();
		}
	}

	// Manage Polar Datas Display
	HEADING.updatePolarDataDisplay();

	// Manage Vehicle Datas Display
	HEADING.updateVehicleDataDisplay();	
};

HEADING.sendConf.local = function (switch_id)
{
	var _params = {},
		object_name,
		value,
		i;

	// On désactive tous les switches tant que l'embarqué n'a pas répondu -----
	for (i in HEADING._ext_sensors_switches)
	{
		object_name = "Switch_"+HEADING._ext_sensors_switches[i];
		window[object_name].disable();
	}
	//-------------------------------------------------------------------------

	object_name = "Switch_"+HEADING._ext_sensors_switches[switch_id];
	value = window[object_name].getValue();

	if (HEADING._ext_sensors_switches[switch_id] == "zupt")
	{
		if (GIWIK.zuptmode)
		{
			_params['ModeZUP'] = value+","+System_state.ModeZUP[1];
		}
	}	
	else
	{
		var sensor_id,
			sensor_name
			KFMExtSensor = array_copy(System_state.KFMExtSensor);

		for (sensor_id in GIWIK._extsensors_kfmfulllist)
		{
			sensor_name = GIWIK._extsensors_kfmfulllist[sensor_id];

			if (sensor_name == HEADING._ext_sensors_switches[switch_id])
			{
				KFMExtSensor[sensor_id] = (value === 1) ? 2 : 1;
			}
		}
		_params['KFMExtSensor'] = KFMExtSensor.join(',');
	}

	return _params;
};

HEADING.readConf.local = function ()
{
	HEADING.setSettingsActivity.local('enable');

	// Statuts détaillés : gestion de l'affichage des seuls capteurs externes configurés
	var exts_conf, i, exts_to_hide;
	for (i in System_state.ExtSToSerial)
	{
		exts_conf = System_state.ExtSToSerial[i];

		if (exts_conf === 0)
		{
			exts_to_hide = GIWIK._extsensors_fulllist[i];

			if (typeof GIWIK.statusBitsInfo.groups.names[exts_to_hide] === 'object')
			{
				$('#'+GIWIK.statusBitsInfo.groups.names[exts_to_hide].dom_id).hide();
			}
		}
	}

	// Status détaillés: Gestion du group Zupt
	if (GIWIK.zuptmode)
	{
		if( typeof  GIWIK.statusBitsInfo.groups.names['zupt'] === 'object')
		{
			if ( System_state.ModeZUP[1] === 0 )
			{
				//à commenter pour rendre visible les flags zupt relatif
				$('#'+GIWIK.statusBitsInfo.groups.names['zupt'].dom_id).hide();
			}
		}
	}

	// Gestion de la license du soft
	if (GIWIK._plugins.maintenance.license_activation)
	{
		if (System_state.LicenseState == "0")
		{
			// Affichage Message Utilisateur
			window.Usermsg_update.setStatus(3);
			window.Usermsg_update.setValue(MSG(['alerts','license']));
			window.Usermsg_update.show();
		}
		else
		{
			// Init Fenetre Message Utilisateur
			window.Usermsg_update.hide();
		}
	}
};

HEADING.getConf.local = function ()
{
	var _params = {};

	_params['ExtSToSerial'] = "";

	if (GIWIK.enable_forced_sensor)
	{
		_params['GPS1Forced']     = "";
		_params['GPS2Forced']     = "";
		_params['USBL1Forced']    = "";
		_params['USBL2Forced']    = "";
		_params['USBL3Forced']    = "";
		_params['LEM1Forced']     = "";
		_params['LEM2Forced']     = "";
		_params['LBLForced']      = "";
		_params['DVLBTForced']    = "";
		_params['DVLWTForced']    = "";
		_params['DVL2BTForced']   = "";
		_params['DVL2WTForced']   = "";
		_params['DepthForced']    = "";
		_params['OdometerForced'] = "";

		if (GIWIK.gps_vtg) {
				_params['VTG1Forced'] 	  = "";
				_params['VTG2Forced'] 	  = "";
		}
	}

	if (GIWIK._plugins.maintenance.license_activation)
	{
		_params['LicenseID']      = "";
		_params['LicenseState']   = "";
	}

	return _params;
};

HEADING.construct.local = function ()
{
	var exts,
		object_name,
		exts_name,
		data,
		data2,
		cnt,
		i;

	// Infos du bloc haut gauche
	data = ''
	+'<table>'
		+'<tr id="heading_info">'
			+'<td class="data_left"><span id="heading_label"></span></td>'
			+'<td class="data_right"><span id="heading_data"><span id="heading"></span></span></td>'
		+'</tr>'
		+'<tr id="polar_heading_info">'
			+'<td class="data_left"><span id="polar_heading_label"></span></td>'
			+'<td class="data_right"><span id="polar_heading_data"><span id="polar_heading"></span></span></td>'
		+'</tr>'
		+'<tr id="heading_stddev_info">'
			+'<td class="data_left"><span id="heading_stddev_label"></span></td>'
			+'<td class="data_right"><span id="heading_stddev_data"><span id="heading_stddev"></span></span></td>'
		+'</tr>'
		+'<tr id="roll_info">'
			+'<td class="data_left"><span id="roll_label"></span></td>'
			+'<td class="data_right"><span id="roll_data"><span id="roll"></span></span></td>'
		+'</tr>'
		+'<tr id="pitch_info">'
			+'<td class="data_left"><span id="pitch_label"></span></td>'
			+'<td class="data_right"><span id="pitch_data"><span id="pitch"></span></span></td>'
		+'</tr>';
		if (GIWIK.heave)
		{
			data+='<tr id="heave_info">'
				+'<td class="data_left"><span id="heave_label"></span></td>'
				+'<td class="data_right"><span id="heave_data"><span id="heave"></span></span></td>'
			+'</tr>';
		}
		data+='<tr id="speed_norm_info">'
			+'<td class="data_left"><span id="speed_norm_label"></td>'
			+'<td class="data_right"><span id="speed_norm_data"><span id="speed_norm"></span></span></td>'
		+'</tr>'
	+'</table>';


	// Infos du bloc haut droit
	data2 = ''
	+'<table>'
		//Lat/Long
		+'<tr id="latitude_info">'
			+'<td class="data_left"><span id="latitude_label"></span></td>'
			+'<td class="data_right"><span id="latitude_data"><span id="latitude"></span></span></td>'
		+'</tr>'
		+'<tr id="longitude_info">'
			+'<td class="data_left"><span id="longitude_label"></span></td>'
			+'<td class="data_right"><span id="longitude_data"><span id="longitude"></span></span></td>'
		+'</tr>'
		//UPT
		+'<tr id="polar_latitude_info">'
			+'<td class="data_left"><span id="polar_latitude_label"></span></td>'
			+'<td class="data_right"><span id="polar_latitude_data"><span id="polar_latitude"></span></span></td>'
		+'</tr>'
		+'<tr id="polar_longitude_info">'
			+'<td class="data_left"><span id="polar_longitude_label"></span></td>'
			+'<td class="data_right"><span id="polar_longitude_data"><span id="polar_longitude"></span></span></td>'
		+'</tr>'
		//UTM
		+'<tr id="utm_zone_info">'
			+'<td class="data_left"><span id="utm_zone_label"></span></td>'
			+'<td class="data_right"><span id="utm_zone_data"><span id="utm_zone"></span></span></td>'
		+'</tr>'
		+'<tr id="utm_north_info">'
			+'<td class="data_left"><span id="utm_north_label"></span></td>'
			+'<td class="data_right"><span id="utm_north_data"><span id="utm_north"></span></span></td>'
		+'</tr>'
		+'<tr id="utm_east_info">'
			+'<td class="data_left"><span id="utm_east_label"></span></td>'
			+'<td class="data_right"><span id="utm_east_data"><span id="utm_east"></span></span></td>'
		+'</tr>'
		//UPS
		+'<tr id="ups_zone_info">'
			+'<td class="data_left"><span id="ups_zone_label"></span></td>'
			+'<td class="data_right"><span id="ups_zone_data"><span id="ups_zone"></span></span></td>'
		+'</tr>'
		+'<tr id="ups_north_info">'
			+'<td class="data_left"><span id="ups_north_label"></span></td>'
			+'<td class="data_right"><span id="ups_north_data"><span id="ups_north"></span></span></td>'
		+'</tr>'
		+'<tr id="ups_east_info">'
			+'<td class="data_left"><span id="ups_east_label"></span></td>'
			+'<td class="data_right"><span id="ups_east_data"><span id="ups_east"></span></span></td>'
		+'</tr>'
		//OSGB British Grid
		+'<tr id="osgb_zone_info">'
			+'<td class="data_left"><span id="osgb_zone_label"></span></td>'
			+'<td class="data_right"><span id="osgb_zone_data"><span id="osgb_zone"></span></span></td>'
		+'</tr>'
		+'<tr id="osgb_north_info">'
			+'<td class="data_left"><span id="osgb_north_label"></span></td>'
			+'<td class="data_right"><span id="osgb_north_data"><span id="osgb_north"></span></span></td>'
		+'</tr>'
		+'<tr id="osgb_east_info">'
			+'<td class="data_left"><span id="osgb_east_label"></span></td>'
			+'<td class="data_right"><span id="osgb_east_data"><span id="osgb_east"></span></span></td>'
		+'</tr>'
		+'<tr id="osgb_altitude_info">'
			+'<td class="data_left"><span id="osgb_altitude_label"></span></td>'
			+'<td class="data_right"><span id="osgb_altitude_data"><span id="osgb_altitude"></span></span></td>'
		+'</tr>'
		//MGRS
		+'<tr id="mgrs_zone_info">'
			+'<td class="data_left"><span id="mgrs_zone_label"></span></td>'
			+'<td class="data_right"><span id="mgrs_zone_data"><span id="mgrs_zone"></span></span></td>'
		+'</tr>'
		+'<tr id="mgrs_north_info">'
			+'<td class="data_left"><span id="mgrs_north_label"></span></td>'
			+'<td class="data_right"><span id="mgrs_north_data"><span id="mgrs_north"></span></span></td>'
		+'</tr>'
		+'<tr id="mgrs_east_info">'
			+'<td class="data_left"><span id="mgrs_east_label"></span></td>'
			+'<td class="data_right"><span id="mgrs_east_data"><span id="mgrs_east"></span></span></td>'
		+'</tr>'
		+'<tr id="mgrs_altitude_info">'
			+'<td class="data_left"><span id="mgrs_altitude_label"></span></td>'
			+'<td class="data_right"><span id="mgrs_altitude_data"><span id="mgrs_altitude"></span></span></td>'
		+'</tr>'
		//GEOREF
		+'<tr id="georef_zone_info">'
			+'<td class="data_left"><span id="georef_zone_label"></span></td>'
			+'<td class="data_right"><span id="georef_zone_data"><span id="georef_zone"></span></span></td>'
		+'</tr>'
		+'<tr id="georef_north_info">'
			+'<td class="data_left"><span id="georef_north_label"></span></td>'
			+'<td class="data_right"><span id="georef_north_data"><span id="georef_north"></span></span></td>'
		+'</tr>'
		+'<tr id="georef_east_info">'
			+'<td class="data_left"><span id="georef_east_label"></span></td>'
			+'<td class="data_right"><span id="georef_east_data"><span id="georef_east"></span></span></td>'
		+'</tr>'
		+'<tr id="georef_altitude_info">'
			+'<td class="data_left"><span id="georef_altitude_label"></span></td>'
			+'<td class="data_right"><span id="georef_altitude_data"><span id="georef_altitude"></span></span></td>'
		+'</tr>'
		//ECEF
		+'<tr id="ecef_x_info">'
			+'<td class="data_left"><span id="ecef_x_label"></span></td>'
			+'<td class="data_right"><span id="ecef_x_data"><span id="ecef_x"></span></span></td>'
		+'</tr>'
		+'<tr id="ecef_y_info">'
			+'<td class="data_left"><span id="ecef_y_label"></span></td>'
			+'<td class="data_right"><span id="ecef_y_data"><span id="ecef_y"></span></span></td>'
		+'</tr>'
		+'<tr id="ecef_z_info">'
			+'<td class="data_left"><span id="ecef_z_label"></span></td>'
			+'<td class="data_right"><span id="ecef_z_data"><span id="ecef_z"></span></span></td>'
		+'</tr>'
		;

		//Altitude for Lat/Long, UTM and Polar (UPT/UPS)
		//if(GIWIK.coordinate_mode < 4) //Remarque daniel: Marche pas! :( (à ce moment, coordinate_mode n'est pas connu -> undefined)
		{
			if (GIWIK.alti_depth)
			{
				data2 += '<tr id="'+GIWIK.alti_depth+'_info">'
					+'<td class="data_left"><span id="'+GIWIK.alti_depth+'_label"></span></td>'
					+'<td class="data_right"><span id="'+GIWIK.alti_depth+'_data"><span id="'+GIWIK.alti_depth+'"></span></span></td>'
				+'</tr>';
			}
		}
	data2 += '</table>';


	cnt = ''
	+'<div id="usermsg_update" class="displaynone"></div>'

	+'<div id="popup_status" style="display:none">'

		+'<div id="close_popup_status_ctnr" style="display:none"><div id="close_popup_status"></div></div>'

		+'<div id="popup_status_sensors_ctnr"></div>'

		+'<table id="box_exts" class="displaynone">'
			+'<tr>'
				+'<td colspan="2" class="box_border_t"><span id="box_external_sensors_title" class="box_titlei"></span></td>'
				+'<td class="box_corner_tr"></td>'
			+'</tr>'
			+'<tr>'
				+'<td class="box_border_l"></td>'
				+'<td class="box_content_popup" id="extsensors_content"></td>'
				+'<td class="box_border_r"></td>'
			+'</tr>'
			+'<tr>'
				+'<td class="box_corner_bl"></td>'
				+'<td class="box_border_b"></td>'
				+'<td class="box_corner_br"></td>'
			+'</tr>'
		+'</table>'

	+'</div>'


	+'<div id="content_main" class="displaynone"></div>';

	GIWIK.write('content', cnt);


	cnt = '';

	for (i in GIWIK._ds_sensors)
	{
		cnt+='<table id="sensor'+i+'">'
			+'<tr>'
				+'<td>'
					+'<table class="sensor">'
						+'<tr>'
							+'<td class="sensor_corner_tl"></td>'
							+'<td class="sensor_border_t"></td>'
							+'<td class="sensor_corner_tr"></td>'
						+'</tr>'
						+'<tr>'
							+'<td class="sensor_border_l"></td>'
							+'<td id="sensor'+i+'_content" class="sensor_content">'
								+'<div id="sensor'+i+'_led"></div>'
								+'<div id="sensor'+i+'_name" class="sensor_name"></div>'
								+'<div id="sensor'+i+'_infos_ctnr">'
									+'<div id="sensor'+i+'_msg" class="displaynone"></div>'
									+'<div id="sensor'+i+'_detailed_infos_ctnr" class="displaynone">'
										+'<div id="sensor'+i+'_detailed_infos" class="detailed_infos"></div>'
									+'</div>'
								+'</div>'
							+'</td>'
							+'<td class="sensor_border_r"></td>'
						+'</tr>'
						+'<tr>'
							+'<td class="sensor_corner_bl"></td>'
							+'<td class="sensor_border_b"></td>'
							+'<td class="sensor_corner_br"></td>'
						+'</tr>'
					+'</table>'
				+'</td>'
			+'</tr>'
		+'</table>';
	}

	$('#popup_status_sensors_ctnr').append(GIWIK.box(cnt, '', false, ['box_detailed_status', 'displaynone'], ['', 'box_content_popup']));


	// Ecriture du code HTML dans les 2 blocs d'infos
	GIWIK.write('data', data);
	GIWIK.write('data2', data2);


	// Lecture du tableau des messages
	GIWIK.write('heading_label',			MSG(['data','heading']));
	GIWIK.write('polar_heading_label',		MSG(['data','polar_heading']));
	GIWIK.write('heading_stddev_label',		MSG(['data','heading_stddev']));
	GIWIK.write('roll_label',				MSG(['data','roll']));
	GIWIK.write('pitch_label',				MSG(['data','pitch']));
	
	if (GIWIK.heave)      {GIWIK.write('heave_label',MSG(['data','heave']));}
	if (GIWIK.alti_depth) {GIWIK.write(GIWIK.alti_depth+'_label',	MSG(['data',GIWIK.alti_depth]));}
	GIWIK.write('speed_norm_label',			MSG(['data','speed']));
	//UTM
	GIWIK.write('utm_zone_label',			MSG(['data','utm_zone']));
	GIWIK.write('utm_east_label',			MSG(['data','utm_easting']));
	GIWIK.write('utm_north_label',			MSG(['data','utm_northing']));
	//GIWIK.write('utm_east_label',			MSG(['data','utm_easting'])); //doublon
	//Lat/long
	GIWIK.write('latitude_label', 			MSG(['data','latitude']));
	GIWIK.write('longitude_label',			MSG(['data','longitude']));
	//UPT
	GIWIK.write('polar_latitude_label',		MSG(['data','polar_latitude']));
	GIWIK.write('polar_longitude_label',		MSG(['data','polar_longitude']));
	//UPS
	GIWIK.write('ups_zone_label',			MSG(['data','ups_zone']));
	GIWIK.write('ups_east_label',			MSG(['data','ups_east']));
	GIWIK.write('ups_north_label',			MSG(['data','ups_north']));
	//Rem: Altitude is the same as lat/long mode
	//OSGB
	GIWIK.write('osgb_zone_label',			MSG(['data','osgb_zone']));
	GIWIK.write('osgb_east_label',			MSG(['data','osgb_east']));
	GIWIK.write('osgb_north_label',			MSG(['data','osgb_north']));
	GIWIK.write('osgb_altitude_label',		MSG(['data','osgb_altitude']));
	//MGRS
	GIWIK.write('mgrs_zone_label',			MSG(['data','mgrs_zone']));
	GIWIK.write('mgrs_east_label',			MSG(['data','mgrs_east']));
	GIWIK.write('mgrs_north_label',			MSG(['data','mgrs_north']));
	GIWIK.write('mgrs_altitude_label',		MSG(['data','mgrs_altitude']));
	//GEOREF
	GIWIK.write('georef_zone_label',		MSG(['data','georef_zone']));
	GIWIK.write('georef_east_label',		MSG(['data','georef_east']));
	GIWIK.write('georef_north_label',		MSG(['data','georef_north']));
	GIWIK.write('georef_altitude_label',	MSG(['data','georef_altitude']));
	//ECEF
	GIWIK.write('ecef_x_label',				MSG(['data','ecef_x']));
	GIWIK.write('ecef_y_label',				MSG(['data','ecef_y']));
	GIWIK.write('ecef_z_label',				MSG(['data','ecef_z']));

	GIWIK.write('global_status_title',	'&nbsp;'+MSG(['data','status']))+'&nbsp;';
	GIWIK.write('box_detailed_status_title',  MSG(['box','detailed_status_title']));
	GIWIK.write('box_external_sensors_title', MSG(['box','external_sensors_title']));

	// Ecriture du titre des modules des statuts détaillés
	for (i=0; i<GIWIK._ds_sensors.length; i++)
	{
		GIWIK.write('sensor'+i+'_name', MSG(['sensors',GIWIK._ds_sensors[i]]));
	}

	$('#close_popup_status').attr('title', MSG(['box','popup_close_mouseover']));
	GIWIK.setClick('close_popup_status', "HEADING.displayDetailedStatus('close')");


	// Construction des switchs des capteurs externes //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	// Définition des switches en fonction des capteurs externes présents pour le produit
	HEADING._ext_sensors_switches = [];

	i=0;
	for (var sensor in GIWIK._ext_sensors)
	{
		// UTC et CTD ne doivent pas avoir de switch
		if (!in_array(sensor, ['utc','ctd',/*'angles',*/'utc2']))
		{
			// Cas particulier du DVL qui a 2 switchs (bt et wt)
			if (sensor == "dvl" || sensor == "dvl2")
			{
				HEADING._ext_sensors_switches.push(sensor+'bt');
				HEADING._ext_sensors_switches.push(sensor+'wt');
			}
			else if ( sensor == "gps" || sensor == "gps2")
			{
				HEADING._ext_sensors_switches.push(sensor);
				if (GIWIK.gps_vtg && GIWIK.gps_vtg_switch ) {
					HEADING._ext_sensors_switches.push(sensor+'vtg');
				}
			}
			else
			{
				HEADING._ext_sensors_switches.push(sensor);
			}
			i++;
		}
	}

	// Cas particulier de Quadrans gyro et Octans
	if (!GIWIK.sensors_switches)
	{
		HEADING._ext_sensors_switches = [];				// Pas de switches pour les capteurs externes
		//$('#altitude_info').css('display','none');	// Pas d'altitude
	}

	if (GIWIK.zuptmode)
	{
		// Ajout du zupt
		HEADING._ext_sensors_switches.push('zupt');
	}

	//alert(HEADING._ext_sensors_switches);

	exts = '<div id="exts_ctnr">';

	for (var i in HEADING._ext_sensors_switches)
	{
		exts_name = HEADING._ext_sensors_switches[i];

		exts += '<table id="switch_'+exts_name+'_ctnr" class="exts_ctnr"><tr><td><div id="switch_'+exts_name+'"></div></td></tr></table>'; // utilisation d'un <table> et pas d'un <div> pour IE car seul moyen de centrer les switches avec text-align:center sur le conteneur
	}

	exts += '</div>';

	GIWIK.write('extsensors_content', exts);

	// Stockage du label du switch pour la gestion du cas mode forcé (on ajoute un marqueur "forced" après le label)
	HEADING._ext_sensors_switches_labels = {};

	// Construction des switchs de la boite external sensors
	for (var i in HEADING._ext_sensors_switches)
	{
		exts_name   = HEADING._ext_sensors_switches[i];
		object_name = "Switch_"+exts_name;

		HEADING._ext_sensors_switches_labels[exts_name] = MSG(['ext_sensors',exts_name]);

		window[object_name] = new Switch(object_name, true);
		window[object_name].label_width = (GIWIK.lang == 'fr') ? 51 : 45;
		window[object_name].auto_enable = false;
		window[object_name].construct(object_name.toLowerCase(), 'default', HEADING._ext_sensors_switches_labels[exts_name], [0,1], false);
		window[object_name].label_path.style.font = 'normal 12px arial';
		window[object_name].label_path.style.color = GIWIK.css.color_text_std;
		window[object_name].setAction("HEADING.sendConf('"+i+"');", true);
		window[object_name].show();
	}

	// Message Utilisteur
	window.Usermsg_update = new User_msg('Usermsg_update', false); // Instanciation du message utilisateur
	window.Usermsg_update.margin = '0 0 10px 0';
	window.Usermsg_update.construct('usermsg_update',3,"");
	window.Usermsg_update.label_path.style.textDecoration = 'blink';
	window.Usermsg_update.hide();

	HEADING.ds_sensor_width  = {small:145,full:188};
	HEADING.ds_sensor_height = {small:255,full:285};
};