GIWIK.init.js(['msg','css']);

HEADING.display.local = function ()
{
	var coordsys = GIWIK.data.coordinates.modes[GIWIK.coordinate_mode];

	// Pour la fluidité d'affichage, lors de la phase d'init on attend la fonction HEADING.setSettingsActivity.local depuis laquelle est appelée HEADING.display.local
	if (!HEADING.init.isdone)
	{
		if(GIWIK._backup_sensors)
		{
			for (var ext_s in GIWIK._backup_sensors){
				$('#'+ext_s+'_ctnr').css('display','none');
			}
		}
		
		// Si le système de coordonnées comprend déjà une altitude, on masque l'altitude "standard"
		if (coordsys.specific_altitude)
		{
			$('#altitude_info').hide();
		}
		return;
	}
};

// Traitement des spécificités de certains groupes de données (UTC, Current)
// AVant appel au readconf.global pour gestion correcte affichage des blocs de données
HEADING.readConf.first = function ()
{
	// Gestion de l'affichage de certains paramètres ou groupes de paramètres
	var dvl     = (System_state.ExtSToSerial[array_search('dvl',    GIWIK._extsensors_fulllist)] != 0) ? true : false;
	var dvl2    = (System_state.ExtSToSerial[array_search('dvl2',    GIWIK._extsensors_fulllist)] != 0) ? true : false;
	var logem   = (System_state.ExtSToSerial[array_search('logem',  GIWIK._extsensors_fulllist)] != 0) ? true : false;
	var logem2  = (System_state.ExtSToSerial[array_search('logem2', GIWIK._extsensors_fulllist)] != 0) ? true : false;
	var utc     = (System_state.ExtSToSerial[array_search('utc',    GIWIK._extsensors_fulllist)] != 0) ? true : false;
	var utc2    = (System_state.ExtSToSerial[array_search('utc2',   GIWIK._extsensors_fulllist)] != 0) ? true : false;
	var current = (GIWIK.current && (dvl || dvl2 || logem || logem2)) ? true : false;

	if (!current)      {$('#current_ctnr tr').css('display','none');}
	if (!utc && !utc2) {$('#utc_utc_time_info').css('display','none');}
	$('#vehicle_attitude_ctnr tr').css('display','none');
	$('#vehicle_position_ctnr tr').css('display','none');
	
	// Gestion affichage 
	if (GIWIK._plugins.mechanical.turret)
	{
		//if( System_state.Turret === 1 )
		{
			$('#vehicle_attitude_ctnr tr').css('display','');
			$('#vehicle_position_ctnr tr').css('display','');
		}
	}
			
	// Manage Polar Datas Display
	HEADING.updatePolarDataDisplay();	
	
	// Gestion affichage données véhicule
	HEADING.updateVehicleDataDisplay();
	
};


HEADING.readConf.local = function ()
{
	// Gyro: GPS and LochEm displayed as Position and Speed external sensors
	if( GIWIK.is_gyro == true | GIWIK.system_type === 11)
	{
		GIWIK.write('gps_title',MSG(['ext_sensors','external_position']));
		GIWIK.write('logem_title',MSG(['ext_sensors','external_speed']));
		GIWIK.write('gps2_title',MSG(['ext_sensors','external_position2']));
		GIWIK.write('logem2_title',MSG(['ext_sensors','external_speed2']));	
		
		// Do not display Backup Sensors: Managed as SensorId1:
		////This part has been moved inside display.local() function: Do no work otherwise
		//if(GIWIK._backup_sensors)
		//{
		//	for (var ext_s in GIWIK._backup_sensors){
		//		eval("$('#"+ext_s+"_ctnr').css('display','none');");
		//	}
		//}
	}
};

HEADING.readData.local = function ()
{
	if (!HEADING.init.isdone)
	{
		// Cas particulier des GPS qui ne possèdent pas de valeur de position en UTM : on affiche les latitude et longitude quel que soit le mode de coordonnées
		$('#gps_latitude_info, #gps_longitude_info, #gps2_latitude_info, #gps2_longitude_info').css('display', '');
		
		// Idem USBL
		$('#usbl_latitude_info, #usbl2_latitude_info, #usbl3_latitude_info').css('display', '');		
		$('#usbl_longitude_info, #usbl2_longitude_info, #usbl3_longitude_info').css('display', '');
		
		// Idem LBL
		$('#lbl_latitude_info,#lbl_longitude_info').css('display', '');
		
	}			
	
	// Warning on ODO speed values if needed
	if( System_state._ext_sensors["odometer"] )
	{
		var status = 0;
		
		if(System_state._ext_sensors["odometer"][0]===true){
			status = ( System_state._ext_sensors["odometer"][4]==="0" ? 2 : 1 );
		}
		$('#odometer_speed,#odometer_speed_label').css('color',GIWIK.css['color_'+status]);
	}
	
	// Manage Polar Datas Display
	HEADING.updatePolarDataDisplay();

	// Manage Polar Datas Display
	HEADING.updateVehicleDataDisplay();	
	
	// Manage Turret Specificities
	if( GIWIK._plugins.mechanical.turret )
	{
		GIWIK.write('heading_and_attitude_title',	System_state.Turret===1 ? MSG(['box','angles_and_attitude_title']) : MSG(['box','heading_and_attitude_title']));
		
		GIWIK.write('heading_label', 				System_state.Turret===1 ? MSG(['data','angles_heading']) : MSG(['data','heading']));
		GIWIK.write('roll_label',    				System_state.Turret===1 ? MSG(['data','angles_roll']) : MSG(['data','roll']));
		GIWIK.write('pitch_label',	   				System_state.Turret===1 ? MSG(['data','angles_pitch']) : MSG(['data','pitch']));
	}
};


HEADING.construct.local = function ()
{
	var cnt = ''
	+'<table class="expertview_ctnr">'
		 +'<tr>'
			+'<td id="col_1" class="col">'
				+'<table class="expertview">'
					+'<tr>'
						+'<td colspan="2" class="col_s"><div id="heading_and_attitude_title" class="data_separator"></div></td>'
					+'</tr>'
					+'<tr id="heading_info">'
						+'<td class="col_n"><div class="n"><span id="heading_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="heading_data"><span id="heading"></span><span id="heading_stddev_data">(<span id="heading_stddev"></span>)</span></div></div></td>'
					+'</tr>'
					+'<tr id="polar_heading_info">'
						+'<td class="col_n"><div class="n"><span id="polar_heading_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="polar_heading_data"><span id="polar_heading"></span><span id="polar_heading_stddev_data">(<span id="polar_heading_stddev"></span>)</span></div></div></td>'
					+'</tr>'
					+'<tr id="roll_info">'
						+'<td class="col_n"><div class="n"><span id="roll_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="roll_data"><span id="roll"></span><span id="roll_stddev_data">(<span id="roll_stddev"></span>)</span></div></div></td>'
					+'</tr>'
					+'<tr id="pitch_info">'
						+'<td class="col_n"><div class="n"><span id="pitch_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="pitch_data"><span id="pitch"></span><span id="pitch_stddev_data">(<span id="pitch_stddev"></span>)</span></div></div></td>'
					+'</tr>'
				+'</table>'
				+'<table class="expertview">'
					+'<tr>'
						+'<td colspan="2" class="col_s"><div id="position_title" class="data_separator"></div></td>'
					+'</tr>'
					+'<tr id="latitude_info">'
					    +'<td class="col_n"><div class="n"><span id="latitude_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="latitude_data"><span id="latitude"></span><span id="latitude_stddev_data">(<span id="latitude_stddev"></span>)</span></div></div></td>'
					+'</tr>'
					+'<tr id="longitude_info">'
						+'<td class="col_n"><div class="n"><span id="longitude_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="longitude_data"><span id="longitude"></span><span id="longitude_stddev_data">(<span id="longitude_stddev"></span>)</span></div></div></td>'
					+'</tr>'
					+'<tr id="polar_latitude_info">'
					    +'<td class="col_n"><div class="n"><span id="polar_latitude_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="polar_latitude_data"><span id="polar_latitude"></span><span id="polar_latitude_stddev_data">(<span id="polar_latitude_stddev"></span>)</span></div></div></td>'
					+'</tr>'
					+'<tr id="polar_longitude_info">'
						+'<td class="col_n"><div class="n"><span id="polar_longitude_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="polar_longitude_data"><span id="polar_longitude"></span><span id="polar_longitude_stddev_data">(<span id="polar_longitude_stddev"></span>)</span></div></div></td>'
					+'</tr>'
					+'<tr id="utm_zone_info">'
						+'<td class="col_n"><div class="n"><span id="utm_zone_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="utm_zone_data"><span id="utm_zone"></span></div></div></td>'
					+'</tr>'
					+'<tr id="utm_east_info">'
						+'<td class="col_n"><div class="n"><span id="utm_east_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="utm_east_data"><span id="utm_east"></span><span id="utm_east_stddev_data">(<span id="utm_east_stddev"></span>)</span></div></div></td>'
					+'</tr>'
					+'<tr id="utm_north_info">'
						+'<td class="col_n"><div class="n"><span id="utm_north_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="utm_north_data"><span id="utm_north"></span><span id="utm_north_stddev_data">(<span id="utm_north_stddev"></span>)</span></div></div></td>'
					+'</tr>'
					+'<tr id="'+GIWIK.alti_depth+'_info">'
						+'<td class="col_n"><div class="n"><span id="'+GIWIK.alti_depth+'_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="'+GIWIK.alti_depth+'_data"><span id="'+GIWIK.alti_depth+'"></span><span id="'+GIWIK.alti_depth+'_unit"></span><span id="'+GIWIK.alti_depth+'_stddev_data">(<span id="'+GIWIK.alti_depth+'_stddev"></span><span id="'+GIWIK.alti_depth+'_stddev_unit"></span>)</span></div></div></td>'
					+'</tr>'
					//UPS
					+'<tr id="ups_zone_info">'
						+'<td class="col_n"><div class="n"><span id="ups_zone_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="ups_zone_data"><span id="ups_zone"></span></div></div></td>'
					+'</tr>'
					+'<tr id="ups_north_info">'
						+'<td class="col_n"><div class="n"><span id="ups_north_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="ups_north_data"><span id="ups_north"></span><span id="ups_north_stddev_data">(<span id="ups_north_stddev"></span>)</span></div></div></td>'
					+'</tr>'
					+'<tr id="ups_east_info">'
						+'<td class="col_n"><div class="n"><span id="ups_east_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="ups_east_data"><span id="ups_east"></span><span id="ups_east_stddev_data">(<span id="ups_east_stddev"></span>)</span></div></div></td>'
					+'</tr>'
					//OSGB British Grid
					+'<tr id="osgb_zone_info">'
						+'<td class="col_n"><div class="n"><span id="osgb_zone_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="osgb_zone_data"><span id="osgb_zone"></span></div></div></td>'
					+'</tr>'
					+'<tr id="osgb_north_info">'
						+'<td class="col_n"><div class="n"><span id="osgb_north_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="osgb_north_data"><span id="osgb_north"></span><span id="osgb_north_stddev_data">(<span id="osgb_north_stddev"></span>)</span></div></div></td>'
					+'</tr>'
					+'<tr id="osgb_east_info">'
						+'<td class="col_n"><div class="n"><span id="osgb_east_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="osgb_east_data"><span id="osgb_east"></span><span id="osgb_east_stddev_data">(<span id="osgb_east_stddev"></span>)</span></div></div></td>'
					+'</tr>'
					+'<tr id="osgb_altitude_info">'
						+'<td class="col_n"><div class="n"><span id="osgb_altitude_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="osgb_altitude_data"><span id="osgb_altitude"></span><span id="osgb_altitude_stddev_data">(<span id="osgb_altitude_stddev"></span>)</span></div></div></td>'
					+'</tr>'
					//MGRS
					+'<tr id="mgrs_zone_info">'
						+'<td class="col_n"><div class="n"><span id="mgrs_zone_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="mgrs_zone_data"><span id="mgrs_zone"></span></div></div></td>'
					+'</tr>'
					+'<tr id="mgrs_north_info">'
						+'<td class="col_n"><div class="n"><span id="mgrs_north_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="mgrs_north_data"><span id="mgrs_north"></span><span id="mgrs_north_stddev_data">(<span id="mgrs_north_stddev"></span>)</span></div></div></td>'
					+'</tr>'
					+'<tr id="mgrs_east_info">'
						+'<td class="col_n"><div class="n"><span id="mgrs_east_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="mgrs_east_data"><span id="mgrs_east"></span><span id="mgrs_east_stddev_data">(<span id="mgrs_east_stddev"></span>)</span></div></div></td>'
					+'</tr>'
					+'<tr id="mgrs_altitude_info">'
						+'<td class="col_n"><div class="n"><span id="mgrs_altitude_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="mgrs_altitude_data"><span id="mgrs_altitude"></span><span id="mgrs_altitude_stddev_data">(<span id="mgrs_altitude_stddev"></span>)</span></div></div></td>'
					+'</tr>'
					//GEOREF
					+'<tr id="georef_zone_info">'
						+'<td class="col_n"><div class="n"><span id="georef_zone_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="georef_zone_data"><span id="georef_zone"></span></div></div></td>'
					+'</tr>'
					+'<tr id="georef_north_info">'
						+'<td class="col_n"><div class="n"><span id="georef_north_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="georef_north_data"><span id="georef_north"></span><span id="georef_north_stddev_data">(<span id="georef_north_stddev"></span>)</span></div></div></td>'
					+'</tr>'
					+'<tr id="georef_east_info">'
						+'<td class="col_n"><div class="n"><span id="georef_east_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="georef_east_data"><span id="georef_east"></span><span id="georef_east_stddev_data">(<span id="georef_east_stddev"></span>)</span></div></div></td>'
					+'</tr>'
					+'<tr id="georef_altitude_info">'
						+'<td class="col_n"><div class="n"><span id="georef_altitude_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="georef_altitude_data"><span id="georef_altitude"></span><span id="georef_altitude_stddev_data">(<span id="georef_altitude_stddev"></span>)</span></div></div></td>'
					+'</tr>'
					//ECEF
					+'<tr id="ecef_x_info">'
						+'<td class="col_n"><div class="n"><span id="ecef_x_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="ecef_x_data"><span id="ecef_x"></span><span id="ecef_y_stddev_data">(<span id="ecef_y_stddev"></span>)</span></div></div></td>'
					+'</tr>'
					+'<tr id="ecef_y_info">'
						+'<td class="col_n"><div class="n"><span id="ecef_y_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="ecef_y_data"><span id="ecef_y"></span><span id="ecef_x_stddev_data">(<span id="ecef_x_stddev"></span>)</span></div></div></td>'
					+'</tr>'
					+'<tr id="ecef_z_info">'
						+'<td class="col_n"><div class="n"><span id="ecef_z_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="ecef_z_data"><span id="ecef_z"></span><span id="ecef_z_stddev_data">(<span id="ecef_z_stddev"></span>)</span></div></div></td>'
					+'</tr>'
				+'</table>'
				+'<table id="vehicle_attitude_ctnr" class="expertview">'
					+'<tr>'
						+'<td colspan="2" class="col_s"><div id="vehicle_attitude_title" class="data_separator"></div></td>'
					+'</tr>'
					+'<tr id="vehicle_heading_info">'
						+'<td class="col_n"><div class="n"><span id="vehicle_heading_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="vehicle_heading_data"><span id="vehicle_heading"></span><span id="vehicle_heading_stddev_data">(<span id="vehicle_heading_stddev"></span>)</span></div></div></td>'
					+'</tr>'
					+'<tr id="vehicle_roll_info">'
						+'<td class="col_n"><div class="n"><span id="vehicle_roll_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="vroll_data"><span id="vehicle_roll"></span><span id="vehicle_roll_stddev_data">(<span id="vehicle_roll_stddev"></span>)</span></div></div></td>'
					+'</tr>'
					+'<tr id="vehicle_pitch_info">'
						+'<td class="col_n"><div class="n"><span id="vehicle_pitch_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="vehicle_pitch_data"><span id="vehicle_pitch"></span><span id="vehicle_pitch_stddev_data">(<span id="vehicle_pitch_stddev"></span>)</span></div></div></td>'
					+'</tr>'					
				+'</table>' 
				+'<table id="vehicle_position_ctnr" class="expertview">'
					+'<tr>'
						+'<td colspan="2" class="col_s"><div id="vehicle_position_title" class="data_separator"></div></td>'
					+'</tr>'
					+'<tr id="vehicle_latitude_info">'
					    +'<td class="col_n"><div class="n"><span id="vehicle_latitude_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="vehicle_latitude_data"><span id="vehicle_latitude"></span><span id="vehicle_latitude_stddev_data">(<span id="vehicle_latitude_stddev"></span>)</span></div></div></td>'
					+'</tr>'
					+'<tr id="vehicle_longitude_info">'
						+'<td class="col_n"><div class="n"><span id="vehicle_longitude_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="vehicle_longitude_data"><span id="vehicle_longitude"></span><span id="vehicle_longitude_stddev_data">(<span id="vehicle_longitude_stddev"></span>)</span></div></div></td>'
					+'</tr>'
					+'<tr id="vehicle_utm_zone_info">'
						+'<td class="col_n"><div class="n"><span id="vehicle_utm_zone_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="vehicle_utm_zone_data"><span id="vehicle_utm_zone"></span></div></div></td>'
					+'</tr>'
					+'<tr id="vehicle_utm_east_info">'
						+'<td class="col_n"><div class="n"><span id="vehicle_utm_east_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="vehicle_utm_east_data"><span id="vehicle_utm_east"></span><span id="vehicle_utm_east_stddev_data">(<span id="vehicle_utm_east_stddev"></span>)</span></div></div></td>'
					+'</tr>'
					+'<tr id="vehicle_utm_north_info">'
						+'<td class="col_n"><div class="n"><span id="vehicle_utm_north_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="vehicle_utm_north_data"><span id="vehicle_utm_north"></span><span id="vehicle_utm_north_stddev_data">(<span id="vehicle_utm_north_stddev"></span>)</span></div></div></td>'
					+'</tr>'
					+'<tr id="vehicle_'+GIWIK.alti_depth+'_info">'
						+'<td class="col_n"><div class="n"><span id="vehicle_'+GIWIK.alti_depth+'_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="vehicle_'+GIWIK.alti_depth+'_data"><span id="vehicle_'+GIWIK.alti_depth+'"></span><span id="vehicle_'+GIWIK.alti_depth+'_unit"></span><span id="vehicle_'+GIWIK.alti_depth+'_stddev_data">(<span id="vehicle_'+GIWIK.alti_depth+'_stddev"></span><span id="vehicle_'+GIWIK.alti_depth+'_stddev_unit"></span>)</span></div></div></td>'
					+'</tr>'
				+'</table>'				
			+'</td>'
            +'<td id="col_2" class="col">'
				 +'<table id="heave_ctnr" class="expertview">'
					+'<tr>'
						+'<td colspan="2" class="col_s"><div id="heave_title" class="data_separator"></div></td>'
					+'</tr>'
					+'<tr id="heave_info">'
						+'<td class="col_n"><div class="n"><span id="heave_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="heave_data"><span id="heave"></span></div></div></td>'
					+'</tr>'
					+'<tr id="surge_info">'
						+'<td class="col_n"><div class="n"><span id="surge_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="surge_data"><span id="surge"></span></div></div></td>'
					+'</tr>'
					+'<tr id="sway_info">'
						+'<td class="col_n"><div class="n"><span id="sway_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="sway_data"><span id="sway"></span></div></div></td>'
					+'</tr>'
				+'</table>'
				+'<table class="expertview">'
					+'<tr>'
						+'<td colspan="2" class="col_s"><div id="utc_title" class="data_separator"></div></td>'
					+'</tr>'
					+'<tr id="systime_info">'
						+'<td class="col_n"><div class="n"><span id="systime_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="systime_data"><span id="systimedays"></span><span id="systime"></span></div></div></td>'
					+'</tr>'
					+'<tr id="utctime_info">'
						+'<td class="col_n"><div class="n"><span id="utctime_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="utctime_data"><span id="utctime"></span></div></div></td>'
					+'</tr>'
					+'<tr id="utc_utc_time_info">'
						+'<td class="col_n"><div class="n"><span id="utc_utc_time_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="utc_utc_time_data"><span id="utc_utc_time"></span></div></div></td>'
					+'</tr>'
				+'</table>'
				+'<table class="expertview">'
					+'<tr>'
						+'<td colspan="2" class="col_s"><div id="travelled_dist_title" class="data_separator"></div></td>'
					+'</tr>'
					+'<tr id="travelled_dist_info">'
						+'<td class="col_n"><div class="n"><span id="travelled_dist_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="travelled_dist_data"><span id="travelled_dist"></div></div></td>'
					+'</tr>'
				+'</table>'
				+'</td>'
            +'<td id="col_3" class="col col_last">'
            	+'<table class="expertview">'
					+'<tr>'
						+'<td colspan="2" class="col_s_last"><div id="speed_title" class="data_separator"></div></td>'
					+'</tr>'
					+'<tr id="speed_norm_info">'
						+'<td class="col_n"><div class="n"><span id="speed_norm_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="speed_norm_data"><span id="speed_norm"></span></div></div></td>'
					+'</tr>'
					+ '<tr id="north_speed_info">'
						+'<td class="col_n"><div class="n"><span id="north_speed_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="north_speed_data"><span id="north_speed"></span><span id="north_speed_stddev_data">(<span id="north_speed_stddev"></span>)</span></div></div></td>'
					+'</tr>'
					+'<tr id="east_speed_info">'
						+'<td class="col_n"><div class="n"><span id="east_speed_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="east_speed_data"><span id="east_speed"></span><span id="east_speed_stddev_data">(<span id="east_speed_stddev"></span>)</span></div></div></td>'
					+'</tr>'
					+ '<tr id="polar_north_speed_info">'
						+'<td class="col_n"><div class="n"><span id="polar_north_speed_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="polar_north_speed_data"><span id="polar_north_speed"></span><span id="polar_north_speed_stddev_data">(<span id="polar_north_speed_stddev"></span>)</span></div></div></td>'
					+'</tr>'
					+'<tr id="polar_east_speed_info">'
						+'<td class="col_n"><div class="n"><span id="polar_east_speed_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="polar_east_speed_data"><span id="polar_east_speed"></span><span id="polar_east_speed_stddev_data">(<span id="polar_east_speed_stddev"></span>)</span></div></div></td>'
					+'</tr>'
					+'<tr id="vert_speed_info"'+((!GIWIK.vertical_speed) ? ' style="display:none"' : '')+'>'
						+'<td class="col_n"><div class="n"><span id="vert_speed_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="vert_speed_data"><span id="vert_speed"></span><span id="vert_speed_stddev_data">(<span id="vert_speed_stddev"></span>)</span></div></div></td>'
					+'</tr>'
				+'</table>'
				+'<table id="current_ctnr" class="expertview">'
					+'<tr>'
						+'<td colspan="2" class="col_s"><div id="current_title" class="data_separator"></div></td>'
					+'</tr>'
					+'<tr id="north_current_info">'
						+'<td class="col_n"><div class="n"><span id="north_current_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="north_current_data"><span id="north_current"></span><span id="north_current_stddev_data">(<span id="north_current_stddev"></span>)</span></div></div></td>'
					+'</tr>'
					+'<tr id="east_current_info">'
						+'<td class="col_n"><div class="n"><span id="east_current_label"></span></div></td>'
						+'<td class="col_v"><div class="v"><div id="east_current_data"><span id="east_current"></span><span id="east_current_stddev_data">(<span id="east_current_stddev"></span>)</span></div></div></td>'
					+'</tr>'
				+'</table>'
            +'</td>'
		+'</tr>'
	+'</table>';

	$('#content').append(GIWIK.box(cnt, MSG(['box','expertview_title']), false, ['box_expertview','box_expertview']));


	$('[id$="latitude_info"],[id$="longitude_info"],[id$="utm_zone_info"],[id$="utm_north_info"],[id$="utm_east_info"]').css('display','none');
	$('[id$="polar_latitude_info"],[id$="polarlongitude_info"]').css('display','none');
	$('span[id$="_stddev_data"]').addClass(GIWIK.stddev ? 'stddev_inline' : 'displaynone');	// Les écarts types sont masqués pour les produits qui ne les gèrent pas


	// Lecture du tableau des messages
	GIWIK.write('heading_and_attitude_title',	MSG(['box','heading_and_attitude_title']));
	GIWIK.write('vehicle_attitude_title',		MSG(['box','vehicle_attitude_title']));
	GIWIK.write('heading_label', 			MSG(['data','heading']));
	GIWIK.write('polar_heading_label', 		MSG(['data','polar_heading']));
	GIWIK.write('roll_label',    			MSG(['data','roll']));
	GIWIK.write('pitch_label',	   		MSG(['data','pitch']));
	GIWIK.write('vehicle_heading_label', 		MSG(['data','vehicle_heading']));
	GIWIK.write('vehicle_roll_label', 		MSG(['data','vehicle_roll']));
	GIWIK.write('vehicle_pitch_label', 		MSG(['data','vehicle_pitch']));

	GIWIK.write('position_title',			MSG(['box','position_title']));
	GIWIK.write('latitude_label',			MSG(['data','latitude']));
	GIWIK.write('polar_latitude_label',		MSG(['data','polar_latitude']));
	GIWIK.write('longitude_label',			MSG(['data','longitude']));
	GIWIK.write('polar_longitude_label',		MSG(['data','polar_longitude']));
	
	GIWIK.write('vehicle_position_title',		MSG(['box','vehicle_position_title']));
	GIWIK.write('vehicle_latitude_label',		MSG(['data','latitude']));
	GIWIK.write('vehicle_longitude_label',		MSG(['data','longitude']));

	if (GIWIK.alti_depth)
	{
		GIWIK.write(GIWIK.alti_depth+'_label', MSG(['data',GIWIK.alti_depth]));
		GIWIK.write('vehicle_' + GIWIK.alti_depth + '_label', MSG(['data',GIWIK.alti_depth]));
	}
	// UTM
	GIWIK.write('utm_zone_label', 			MSG(['data','utm_zone']));
	GIWIK.write('utm_north_label', 			MSG(['data','utm_north']));
	GIWIK.write('utm_east_label', 			MSG(['data','utm_east']));
	GIWIK.write('vehicle_utm_zone_label', 		MSG(['data','utm_zone']));
	GIWIK.write('vehicle_utm_north_label', 		MSG(['data','utm_north']));
	GIWIK.write('vehicle_utm_east_label', 		MSG(['data','utm_east']));
	// UPS
	GIWIK.write('ups_zone_label',			MSG(['data','ups_zone']));
	GIWIK.write('ups_east_label',			MSG(['data','ups_east']));
	GIWIK.write('ups_north_label',			MSG(['data','ups_north']));
	//Rem: Altitude is the same as lat/long mode
	// OSGB
	GIWIK.write('osgb_zone_label',			MSG(['data','osgb_zone']));
	GIWIK.write('osgb_east_label',			MSG(['data','osgb_east']));
	GIWIK.write('osgb_north_label',			MSG(['data','osgb_north']));
	GIWIK.write('osgb_altitude_label',		MSG(['data','osgb_altitude']));
	// MGRS
	GIWIK.write('mgrs_zone_label',			MSG(['data','mgrs_zone']));
	GIWIK.write('mgrs_east_label',			MSG(['data','mgrs_east']));
	GIWIK.write('mgrs_north_label',			MSG(['data','mgrs_north']));
	GIWIK.write('mgrs_altitude_label',		MSG(['data','mgrs_altitude']));
	// GEOREF
	GIWIK.write('georef_zone_label',		MSG(['data','georef_zone']));
	GIWIK.write('georef_east_label',		MSG(['data','georef_east']));
	GIWIK.write('georef_north_label',		MSG(['data','georef_north']));
	GIWIK.write('georef_altitude_label',	MSG(['data','georef_altitude']));
	// ECEF
	GIWIK.write('ecef_x_label',				MSG(['data','ecef_x']));
	GIWIK.write('ecef_y_label',				MSG(['data','ecef_y']));
	GIWIK.write('ecef_z_label',				MSG(['data','ecef_z']));

	// SPEED
	GIWIK.write('speed_title',				MSG(['box','speed_title']));
	GIWIK.write('north_speed_label',		MSG(['data','north_speed']));
	GIWIK.write('east_speed_label',			MSG(['data','east_speed']));
	GIWIK.write('polar_north_speed_label',	MSG(['data','polar_north_speed']));
	GIWIK.write('polar_east_speed_label',	MSG(['data','polar_east_speed']));
	GIWIK.write('vert_speed_label',			MSG(['data','vert_speed']));
	GIWIK.write('speed_norm_label', 		MSG(['data','speed_norm']));

	// HEAVE
	GIWIK.write('heave_title',				MSG(['box','heave_title']));
	GIWIK.write('heave_label',				MSG(['data','heave']));
	GIWIK.write('surge_label',				MSG(['data','surge']));
	GIWIK.write('sway_label',				MSG(['data','sway']));

	// Groupes spéciaux -------------------------------------------------------------------------------------------------------
	// CURRENT : s'affiche quand un DVL ou un EMLog est configuré
	GIWIK.write('current_title',			MSG(['box','current_title']));
	GIWIK.write('north_current_label',		MSG(['data','north_current']));
	GIWIK.write('east_current_label',		MSG(['data','east_current']));

	// TIME : toujours présent, avec le champ "Last UTC sync time" en plus quand un UTC est configuré
	GIWIK.write('utc_title', 		 		MSG(['box','utc_title']));
	GIWIK.write('systime_label',			MSG(['data','system_time']));
	GIWIK.write('utctime_label',			MSG(['data','utc_time']));
	GIWIK.write('utc_utc_time_label',		MSG(['data','last_utc_sync_time']));

	if( GIWIK.travelled_dist )
	{
		GIWIK.write('travelled_dist_title', MSG(['box','travelled_dist_title']));
		GIWIK.write('travelled_dist_label', MSG(['box','travelled_dist']));
	}
	
	// Si le Z n'est pas géré par le produit
	if (!GIWIK.alti_depth)
	{
		$('#'+GIWIK.alti_depth+'_info').css('display','none');
	}
	if (!GIWIK.heave)
	{
		$('#heave_ctnr tr').css('display','none');
	}
};
