GIWIK.init.js(['msg','css']);


//Changement de l'affichage pour la sélection d'eau
HEADING.changewatertypedisplay = function ()
{
	window.Input_Water1.enable();

	if(window.Input_Water0.getValue() === 0)
	{
		//Case: fresh water
		window.Input_WaterDensity.enable();
	}
	else
	{
		//Case: salt water
		window.Input_WaterDensity.disable();
	}
	window.Input_WaterDensity.show();
};

// Pour les systèmes avec plus de 5 entrées quand on est sur appareil mobile
if (GIWIK._context.mobile_device && count(GIWIK._input_ports) > 5)
{
	// on augmente la taille du viewport (on écrase le view port standard)
	document.write('<meta name="viewport" content="width=750"/>');
}

// Affichage Bras de levier en focntion repère
HEADING.updateSensorLVADisplay = function()
{
	// LVA values
	var XV1 = window.Input_LeverArmXV1.getValue();
	var XV2 = window.Input_LeverArmXV2.getValue();
	var XV3 = window.Input_LeverArmXV3.getValue();
	
	// LVA Frame: Only for GPS sensor that can be set on turret
	var LVAFrame = "";
	switch (window.Menu_extsensor.getValue())
	{
		case 'gps':
		case 'gps2':
			LVAFrame = HEADING.getSystemLVAFrame(window[system].Turret,(typeof window.Select_SensorPos=='object' ? window.Select_SensorPos.getValue() : 0) );
			break;
		
		default:
			break;
	}
	// Update display
	HEADING.displayLeverarmImg(1, XV1, XV2, XV3, undefined/*No letter*/, LVAFrame);				
}

// Changement de page entrées/event markers
HEADING.changeInput = function ()
{
	window.Usermsg_conflicts.hide();

	if (window.current_input == 'input_pulses')
	{
		$('#matrix_ctnr').slideUp(200,function(){$('#inputpulses_ctnr').slideDown();});
	}
	else
	{
		$('#inputpulses_ctnr').slideUp(200,function(){$('#matrix_ctnr').slideDown();});
	}
};

HEADING.setIPaddressRange = function (transport_layer)
{
	// UDP MultiCast
	if (transport_layer === 4)
	{
		window.Input_ip_part1.updateBounds(224,239);
	}
	// UDP BraodCast, TCP ..
	else
	{
		window.Input_ip_part1.updateBounds(0,255);
	}
};


HEADING.setSettingsActivity.local = function (action)
{
	if (action == 'enable')
	{
		if (window.Menu_extsensor.getValue() == 'utc')
		{
			if (window.Select_pps.selected_option < 1)
			{
				window.Select_ppsprotocol.setValue(0);
				window.Select_ppsprotocol.disable();
				window.Select_pps.enable();
			}
		}
		HEADING.changewatertypedisplay();
	}
};

HEADING.display.local = function ()
{
	// Gestion dynamique de la marge de certains inputs (en fonction de la langue et de la taille de la fenêtre)
	if (!HEADING.init.isdone)
	{
		// Affectation de la 2nd phase d'init au chargement de la page (évènement "load")
		if (window.addEventListener)	{window.addEventListener('resize', HEADING.display.local, false);}
		else							{window.attachEvent('onresize', HEADING.display.local);}
	}

	// Resize Input Matrix Sensor Labels when using backup
	if (GIWIK._backup_sensors)
	{
		//$('#menu_extsensor_table').css('width','150px');
		window[GIWIK._plugins.matrix._object_names.rows].resize( GIWIK._plugins.matrix.force_compact===true ? 124 : 132);
	}

	//[DAT] Resizing not useful for depthoffset
	//var depthoffset_marginleft = (GIWIK.lang == 'fr') ? 142 : 172;
	//if (GIWIK.window_size != 'full'){depthoffset_marginleft = depthoffset_marginleft - 77;}

	//$('#input_depthoffset').css('margin-left', depthoffset_marginleft);
};

HEADING.BackupSensors_Refresh = function ()
{
	// BackUp sensors Enabled
	if( System_state.BackupSensors==1 )
	{
		// Update Enable/Disable button message
		GIWIK.write('backup_sensors_button',MSG(['buttons','backup_sensors_disable']));

		// Display Backup Sensors
		var _ext_s = array_keys(GIWIK._ext_sensors);

		for (var ext_s in GIWIK._backup_sensors)
		{
			index = array_search(ext_s, _ext_s);
			$('#menu_extsensor_table'+index).show();
			$('#row-'+index).show();
			$('#row-'+index).next().show();
		}
	}
	// BackUp sensors Enabled
	else
	{
		// Update Enable/Disable button message
		GIWIK.write('backup_sensors_button',MSG(['buttons','backup_sensors_enable']));

		// Hide Backup Sensors
		var _ext_s = array_keys(GIWIK._ext_sensors);

		for (var ext_s in GIWIK._backup_sensors)
		{
			index = array_search(ext_s, _ext_s);
			$('#menu_extsensor_table'+index).hide();
			$('#row-'+index).hide();
			$('#row-'+index).next().hide();
		}
	}
};

HEADING.BackupSensors_Enable = function ()
{
	// Construct and Send Enable/Disable BackUpSensors Request
	GIWIK.ajax( GIWIK.cgifile+"?mode=4" + "&BackupSensors="+(System_state.BackupSensors==1 ? "0" : "1") );

	// La page doit être rechargée
	setTimeout("window.location.reload()",200);
};



HEADING.CAN_Bus_Construct = function ()
{
	// CAN Bus Configuration Bloc
	var cnt = ''
	+'<div id="params_can_bus">'
		+'<table class="one_param_ctnr">'
			+'<tr>'
				+'<td align="left" class="inputs_params_padding">'
					+ '<div id="usermsg_no_can_params"></div>'
					+ '<div id="select_can_spec"></div>'
					+ '<div id="select_can_norm"></div>'
					+ '<div id="select_can_speed"></div>'
				+'</td>'
			+'</tr>'
		+'</table>'
	+'</div>';
	
	// Placed before Protocol Parameters
	GIWIK.write('params_protocol',cnt,'before');

	
	// Construct paramGroup
	GIWIK.paramGroup.construct('params_can_bus', MSG(['box','params_can_bus_configuration']), 'show');
	
	// CAN Specification: 2A 2B	
	window.Select_CAN_Spec = new Input_select('Select_CAN_Spec', true);
	window.Select_CAN_Spec.label_width = window.heading_labels_width;
	window.Select_CAN_Spec.construct('select_can_spec','linear',MSG(['parameters','can_bus_specification']),array_keys(System_state.CAN_SpecList),System_state.CAN_SpecList,'',true);
	window.Select_CAN_Spec.show();
	
	// CAN Norm: None, J1939
	window.Select_CAN_Norm = new Input_select('Select_CAN_Norm', true);
	window.Select_CAN_Norm.label_width = window.heading_labels_width;
	window.Select_CAN_Norm.construct('select_can_norm','linear',MSG(['parameters','can_bus_norm']),array_keys(System_state.CAN_NormList),System_state.CAN_NormList,'',true);
	window.Select_CAN_Norm.show();

	// CAN Speed
	window.Select_CAN_Speed = new Input_select('Select_CAN_Speed', true);
	window.Select_CAN_Speed.label_width = window.heading_labels_width;
	window.Select_CAN_Speed.construct('select_can_speed','linear',MSG(['parameters','can_bus_speed']),array_keys(System_state.CAN_SpeedList),System_state.CAN_SpeedList,'',true);
	window.Select_CAN_Speed.show();	
};

HEADING.CAN_Bus_SetConf = function ()
{
	// Set CAN Bus Conf: Spec, Norm, Speed
	window.Select_CAN_Spec.setValue( System_state.CAN_Conf[0] );
	window.Select_CAN_Norm.setValue( System_state.CAN_Conf[1] );
	window.Select_CAN_Speed.setValue( System_state.CAN_Conf[2] );
};
					
HEADING.CAN_Sensor_Construct = function ()
{	
	// CAN Sensor Configuration Bloc: Message List
	var cnt = ''	
	+'<div id="params_can_sensor">'
		+'<table class="one_param_ctnr">'
			+'<tr>'
				+'<td align="left" class="inputs_params_padding_small">'
					+ '<div id="select_can_message_1"></div>'
					+ '<div id="select_can_message_2"></div>'
					+ '<div id="select_can_message_3"></div>'
					+ '<div id="select_can_message_4"></div>'
					+ '<div id="select_can_message_5"></div>'
					+ '<div id="select_can_message_6"></div>'
					+ '<div id="select_can_message_7"></div>'	
					+ '<div id="select_can_message_8"></div>'					
				+'</td>'
			+'</tr>'
		+'</table>'
	+'</div>';
	
	// Placed before Protocol Parameters
	GIWIK.write('params_leverarms',cnt,'before');
		
	GIWIK.paramGroup.construct('params_can_sensor', MSG(['box','params_can_sensor_configuration']), 'show');
	
	
	// CAN Sensor Configuration
	var CANMessagesLabels = [];
	var CANMessagesIds = [];
	for (var i = 0; i < System_state.CAN_DataBlocksList.length; i++) {
		if( i%2==0 ){
			CANMessagesLabels.push(System_state.CAN_DataBlocksList[i]+" - "+System_state.CAN_DataBlocksList[i+1]);
		}else{
			CANMessagesIds.push(System_state.CAN_DataBlocksList[i]);
		}
	}
		
	// CAN Sensor DataBlock List 
	for(var i=1;i<=8;i++)
	{
		eval( "window.Select_can_message_"+i+" = new Input_select('Select_can_message_"+i+"', true)");
		eval( "window.Select_can_message_"+i+".label_width = window.heading_labels_width;");
		eval( "window.Select_can_message_"+i+".construct('select_can_message_"+i+"','linear',MSG(['parameters','can_message']),CANMessagesIds,CANMessagesLabels,'',true);");
		eval( "window.Select_can_message_"+i+".setAction('HEADING.CAN_Sensor_Refresh();');");
		eval( "window.Select_can_message_"+i+".show();");
	}	
};

HEADING.CAN_Sensor_SetConf = function ()
{
	var port_is_can = false;
	
	// Check if port Checked as CAN
	var can_port_index = array_search('CAN', GIWIK._input_ports);
	if (can_port_index)
	{
		can_port_index = eval(can_port_index) + 1;
		
		if( window.Menu_extsensor.getValue() != undefined ) {
			if (GIWIK.css.getClass('row-'+window.Menu_extsensor.getValue()+'_col-'+can_port_index) == 'cell_checked'){
				port_is_can = true;
			}
		}
	}

	// Port Configured using CAN
	if( port_is_can == true )
	{
		// Display CAN Sensor Parameters
		GIWIK.paramGroup.display('params_can_sensor', 'show');
		
		// Compute CAN Index in CAN_ExtS to retreive DataBlocksList
		var can_index = -1;
		switch (window.Menu_extsensor.getValue())
		{
			case 'utc':			can_index=0;	break;
			case 'utc2':		can_index=1;	break;
			case 'gps':			can_index=2;	break;
			case 'gps2':		can_index=3;	break;
			case 'odometer':	can_index=4;	break;
			case 'angles':		can_index=5;	break;
		}
	
		if(can_index>=0)
		{
			// Get CAN Messages List
			var can_messages_list = System_state.CAN_ExtS[can_index];

			// Reset Message
			for(i=0;i<8;i++){
				eval( "window.Select_can_message_"+(i+1)+".setValue(0);");
			}
			// Set Used Messages
			for(i=0;i<can_messages_list.length;i++){
				eval( "window.Select_can_message_"+(i+1)+".setValue(parseInt(can_messages_list["+(i)+"]));");
			}
			// Refresh: Hide None Messages
			HEADING.CAN_Sensor_Refresh();
		}
	}
	// Disable CAN if not configured
	else
	{
		GIWIK.paramGroup.display('params_can_sensor', 'displaynone');
	}
};	
		
		
HEADING.CAN_Sensor_GetConf = function ()
{
	var can_messages_list;
	var message_id = 0;

	// Get CAN Messages Original List
	var can_messages_lists = new Array();
	
	for( i=0; i<System_state.CAN_ExtS.length; i++ )
		can_messages_lists[i] = "[" + System_state.CAN_ExtS[i] + "]";
			
	// Sensor CAN Message List Index
	var can_index = -1;
	switch (window.Menu_extsensor.getValue())
	{
		case 'utc':			can_index=0;	break;
		case 'utc2':		can_index=1;	break;
		case 'gps':			can_index=2;	break;
		case 'gps2':		can_index=3;	break;
		case 'odometer':	can_index=4;	break;
		case 'angles':		can_index=5;	break;
	}
		
	// Compute Sensor New CAN Message List
	can_messages_list = '[';
	
	for(i=0;i<8;i++)
	{
		// Get Ids
		eval( "message_id = window.Select_can_message_"+(i+1)+".getValue();");
		
		// Fill in List if valid
		if( message_id != 0 && message_id != 'undefined' && message_id != undefined) {
			if( i != 0 ) {
				can_messages_list +=  ',';
			}
			can_messages_list += message_id;
		}
		else{
			break;
		}
	}	
	can_messages_list += ']';
	
	// Set New List for select Sensor
	can_messages_lists[can_index] = can_messages_list;
	
	return "" + can_messages_lists + "";
};
		
HEADING.CAN_Sensor_Refresh = function ()
{
	var display = 1;
	
	// For All Messages
	for(var i=1;i<=8;i++)
	{
		// If Display: Check for None to disable Next Messages
		if( display != 0 )
		{
			eval( " display = window.Select_can_message_"+i+".getValue();" );
			eval( " window.Select_can_message_"+i+".show();" );
		}
		// Disable after first None Message
		else
		{
			eval( " window.Select_can_message_"+i+".hide();" );
		}
	}
};

HEADING.construct.local = function ()
{

};
	
HEADING.getConf.local = function ()
{
	var _params = {};

	if( GIWIK._backup_sensors ){
		_params['BackupSensors'] = "";
	}

	// Page event markers
	if (window.current_input == 'input_pulses')
	{
		_params['PULSEIAConf'] = "";
		_params['PULSEIBConf'] = "";
		_params['PULSEICConf'] = "";
		_params['PULSEIDConf'] = "";
	}
	// Page inputs : lors de l'init, on récupère le contenu des listes dans un une 1ère requête séparée (1 seule requête complète risquerait d'être trop longue)
	else if (typeof System_state.IProList == 'undefined')
	{
		var request_lists = GIWIK.cgifile+"?mode=3";

		// Récupération du contenu des listes et de leurs valeurs en fonction du type de systeme
		var ext_sensor_cgisyntax;
		for (var ext_s in GIWIK._ext_sensors)
		{
			ext_sensor_cgisyntax = GIWIK._extsensors_fulllist_cgisyntax[array_search(ext_s, GIWIK._extsensors_fulllist)];
			request_lists += "&IProNum_"+ext_sensor_cgisyntax;
		}
		ext_sensor_cgisyntax = null;

		request_lists += "&IProList&IPulseList&EDIRIXList&ParityList&StopbitsList&LevelList&BaudrateList&ELCFIXList";

		// Envoi de la requête. Par soucis de synchronisme, on remplace le callback standard GIWIK.analyzeResponseText par l'appel de la fonction HEADING.getConf
		GIWIK.ajax(request_lists, {eval_rtxt:true,replace_standard_callback:function(){HEADING.getConf();}});

		return false;
	}

	// Récupération de l'assignation des ports, des filtres de réjection et de la conf de chacun d'eux (la demande spécifique du port associé au capteur demanderait 2 requètes successives :1) ExtSToSerial pour savoir quel port demander 2) demande de la conf du port assigné
	_params['ExtSToSerial'] = "";

	// Récupération de la configuration d'entrée/sortie complète
	_params = array_merge(_params, HEADING.getIOConfParams());


	// SI UN CAPTEUR EXTERNE EST SÉLECTIONNÉ, on demande sa conf
	if (window.Menu_extsensor.getValue() !== undefined)
	{
		switch (window.Menu_extsensor.getValue())
		{
			case 'gps':
				_params['GPSLVA'] = "";
				_params['GPS1Forced'] = "";
				if (GIWIK._plugins.mechanical.turret){
					_params['GPSPos'] = "";
				}
				if(GIWIK.geoid ){
					_params['GeoidalSep'] = "";
				}
				if(GIWIK.gps_vtg){
					_params['VTG1Forced'] = "";
				}
				break;

			case 'gps2':
				_params['GPS2LVA'] = "";
				_params['GPS2Forced'] = "";
				if (GIWIK._plugins.mechanical.turret){
					_params['GPSPos'] = "";
				}
				if(GIWIK.geoid ){
					_params['GeoidalSep'] = "";
				}
				if(GIWIK.gps_vtg){
					_params['VTG2Forced'] = "";
				}
				break;

			case 'gpsm':
				_params['GPSMLVA'] = "";
				break;

			case 'depth':
				_params['DepthLVA']    = "";
				_params['DepthOffset'] = "";
				_params['DepthForced'] = "";
				_params['WaterParams'] = "";
				break;

			case 'usbl':
				_params['USBL0LVA']  = "";
				_params['USBL0Conf'] = "";
				_params['USBL1Forced'] = "";
				break;

			case 'usbl2':
				_params['USBL1LVA']  = ""
				_params['USBL1Conf'] = "";
				_params['USBL2Forced'] = "";
				break;

			case 'usbl3':
				_params['USBL2LVA']  = "";
				_params['USBL2Conf'] = "";
				_params['USBL3Forced'] = "";
				break;

			case 'lbl':
				_params['LBLLVA'] = "";
				_params['LBLForced'] = "";
				break;

			case 'odometer':
				_params['ODOLVA'] = "";
				_params['ODOCAL'] = "";
				_params['OdometerForced'] = "";
				break;

			case 'dvl':
				_params['DVLLVA'] = "";
				_params['DVLCAL'] = "";
				_params['DVLBTForced'] = "";
				_params['DVLWTForced'] = "";
				_params['DVLCplMode'] = "";
				if( GIWIK.dvltype ){
					_params['DVLTypes'] = "";
				}
				if(GIWIK.trig_DVL_by_pulse){
					_params['DVLTriggerPulse'] = "";				
				}
				break;

			case 'dvl2':
				_params['DVL2LVA'] = "";
				_params['DVL2CAL'] = "";
				_params['DVL2BTForced'] = "";
				_params['DVL2WTForced'] = "";
				_params['DVL2CplMode'] = "";
				if( GIWIK.dvltype ){
					_params['DVLTypes'] = "";
				}
				if(GIWIK.trig_DVL_by_pulse){
					_params['DVL2TriggerPulse'] = "";
				}
				break;

			case 'logem':
				_params['LEMLVA'] = "";
				_params['LEMCAL'] = "";
				_params['LEM1Forced'] = "";
				break;

			case 'logem2':
				_params['LEM2LVA'] = "";
				_params['LEM2CAL'] = "";
				_params['LEM2Forced'] = "";
				break;

			case 'utc':
			case 'utc2':
				if ( !in_array(window.Menu_port.getValue(),['X']) )
				{
					for (var i in GIWIK._input_pulse_list)
					{
						_params['PULSEI'+GIWIK._input_pulse_list[i]+'Conf'] = "";
					}
				}
				
			case 'angles':
				if (GIWIK._plugins.mechanical.turret){
					_params['ANGLESConv'] = "";
					_params['ANGLESLatency'] = "";
				}
				break;
		}
	}
	
	// Gestion tourelle
	if (GIWIK._plugins.mechanical.turret)
	{
		_params['Turret'] = "";
	}
	
	// Gestion CAN
	if( in_array('CAN',GIWIK._input_ports) )
	{
		_params['CAN_SpecList'] = "";
		_params['CAN_NormList'] = "";
		_params['CAN_SpeedList'] = "";
		_params['CAN_Conf'] = "";
		_params['CAN_ExtS'] = "";
		_params['CAN_DataBlocksList'] = "";
	}
		
	return _params;
};

HEADING.readConf.local = function ()
{
	if (!HEADING.init.isdone)
	{
		// Page des input pulses ———————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
		if (GIWIK.input_event_markers || GIWIK.input_travel_lock)
		{
			//Menu de sélection entrées/event marker
			var evt = '';
			for (var i in GIWIK._input_pulse_list)
			{
				evt +=''
				+'<div id="params_eventmarker'+GIWIK._input_pulse_list[i]+'">'
					+'<table class="params_synchroloss">'
						+'<tr>'
							+'<td align="left">'
								//+'<div id="select_pulseport'+GIWIK._input_pulse_list[i]+'"></div>'
								+'<div id="select_pulse_feature'+GIWIK._input_pulse_list[i]+'"></div>'
							+'</td>'
						+'</tr>'
					+'</table>'
				+'</div>';
			}
			
			// var trvlock =''
				// +'<div id="params_travellock">'
					// +'<table class="params_synchroloss">' // TO COMPLETE
						// +'<tr>'
							// +'<td align="left">'
								// +'<div id="select_travellock_pulseid"></div>'
								// +'<div id="select_travellock_level"></div>'
							// +'</td>'
						// +'</tr>'
					// +'</table>'
				// +'</div>';

			// Gestion des event markers
			$('#usermsg_conflicts').after
			(
				'<div id="params_menuinputs_label" class="inputs_params_label"></div>'
				+'<div id="menu_inputs_table" style="text-align:center;"></div>'
				+'<div id="inputpulses_ctnr">'+evt+'</div>'
			);

			$('#matrix_ctnr>table').before('<hr id="main_separator" class="separator1">');

			// Menu Input Ports / Input Pulses
			window.Menu_inputs = new Menu('Menu_inputs', true);
			window.Menu_inputs.margin = '0 auto 0 auto';
			window.Menu_inputs.construct('menu_inputs_table', 'horizontal', ['inputs','input_pulses'], [MSG(['parameters','input_ports']), MSG(['parameters','input_pulses'])], false, 125, 18);
			window.Menu_inputs.raw_action = 'window.current_input=window.Menu_inputs.getValue();'; // action sans la réinitialisation du menu ext sensor ni le GetConf() (pour l'onclick sur une cellule du tableau qui doit activer une entrée dans chaque menu)
			window.Menu_inputs.setActionBefore('HEADING.current_input_changed = true; if (window.Menu_inputs.getValue() !== undefined){HEADING.current_input_changed = true;}', true); // action survenant AVANT le garde-fou de "settings_modified" lors d'un setValue()
			window.Menu_inputs.setAction(window.Menu_inputs.raw_action+"HEADING.changeInput();HEADING.getConf();", true);
			window.Menu_inputs.setValue('inputs');
			window.Menu_inputs.show();

			$('#inputpulses_ctnr').css('display','none');
			
			for (var i in GIWIK._input_pulse_list)
			{
				GIWIK.paramGroup.construct('params_eventmarker'+GIWIK._input_pulse_list[i],MSG(['box','input_pulse']) +' '+GIWIK._input_pulse_list[i], 'hide');
			}

			window.input_pulses_pro_k = [];
			window.input_pulses_pro_v = [];
			
			//Creation de la Liste à partir de la conf.
			for (var prot in System_state.IPulseList)
			{
				var pro = System_state.IPulseList[prot]
		
				if ( pro.indexOf('None')!=-1 || 	
					(GIWIK.input_event_markers && pro.indexOf('Marker')!=-1 && pro.indexOf('PP')==-1) ||
					(GIWIK.input_travel_lock && pro.indexOf('Lock')!=-1) )
				{
					input_pulses_pro_k.push(parseInt(prot));
					input_pulses_pro_v.push(pro);
				}
				//console.log(input_pulses_pro_k + " - "+input_pulses_pro_v);
				
				/*var key_pro = GIWIK._travel_lock_pro_dic[pro];
				if (GIWIK.input_travel_lock && key_pro != undefined)
				{
					if( array_search(key_pro, GIWIK._input_pulse_list_pro_k) == false){
						input_pulses.push(key_pro);
						input_pulses.push(MSG(['pulses_pro',key_pro]));
					}
				}*/
			}

			for (var i in GIWIK._input_pulse_list)
			{
				window['Select_pulse_feature'+GIWIK._input_pulse_list[i]] = new Input_select('Select_pulse_feature'+GIWIK._input_pulse_list[i], true);
				window['Select_pulse_feature'+GIWIK._input_pulse_list[i]].margin_left = 45;
				window['Select_pulse_feature'+GIWIK._input_pulse_list[i]].label_width = 80;
				window['Select_pulse_feature'+GIWIK._input_pulse_list[i]].construct('select_pulse_feature'+GIWIK._input_pulse_list[i],'linear',MSG(['parameters','feature']),input_pulses_pro_k,input_pulses_pro_v,'',true);
				window['Select_pulse_feature'+GIWIK._input_pulse_list[i]].show();
			}
			
			// B - Travel Lock
			/*GIWIK.paramGroup.construct('params_travellock',MSG(['box','params_travellock'] ), 'hide');

			window.Select_TravelLock_Id = new Input_select('Select_TravelLock_Id', true);
			window.Select_TravelLock_Id.margin_left = 45;
			window.Select_TravelLock_Id.label_width = 80;
			window.Select_TravelLock_Id.construct('select_travellock_pulseid','linear',MSG(['parameters','travellock_label']),array_keys(GIWIK._input_pulse_names),GIWIK._input_pulse_names,'',true);
			window.Select_TravelLock_Id.show();		

			window.Select_TravelLock_Level = new Input_select('Select_TravelLock_Level', true);
			window.Select_TravelLock_Level.margin_left = 45;
			window.Select_TravelLock_Level.label_width = 80;
			window.Select_TravelLock_Level.construct('select_travellock_level','linear','Level',[0,1],['Navigation Low','Navigation High'],'',true);
			window.Select_TravelLock_Level.show();*/	
			
		}

		// Page des entrées —————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————

		var cnt = '';

		if (GIWIK._plugins.mechanical.turret)
		{
			cnt += '<div id="params_sensorpos">'
					+'<table id="tab_sensorpos">'
						+'<tr>'
							+'<td><div id="select_sensor_position"></div></td>'
						+'</tr>'
					+'</table>'
				+'</div>';
		}
		
		if (GIWIK._plugins.mechanical.turret)
		{
			cnt += '<div id="params_turret_sign_conventions">'
					+'<table id="tab_turret_sign_conventions">'
						+'<tr>'
							+'<td><div id="select_turret_heading_conv"></div></td>'
						+'</tr>'
						+'<tr>'
							+'<td><div id="select_turret_roll_conv"></div></td>'
						+'</tr>'
						+'<tr>'
							+'<td><div id="select_turret_pitch_conv"></div></td>'
						+'</tr>'
					+'</table>'
				+'</div>';
				
			cnt += '<div id="params_turret_latency">'
					+'<table id="tab_turret_latency">'
						+'<tr>'
							+'<td><div id="input_turret_latency"></div></td>'
						+'</tr>'
					+'</table>'
				+'</div>';				
		}
		
		if (GIWIK.sensors_lva)
		{
			cnt += '<div id="params_leverarms">'

				+'<div><div id="leverarms1_help" class="leverarms_help"></div></div>'
				+'<div id="leverarms1_axes_img" class="leverarms_axes_img">'
					+'<div class="close_leverarms_axes_ctnr">'
						+'<div id="close_leverarms1_axes" class="close_leverarms_axes">&#215;</div>'
					+'</div>'
				+'</div>'

				+'<table id="leverarms_img">'
					+'<tr>'
						+'<td align="center" class="tdleft">'
							+'<div class="leverarms_img1_ctnr">'
								+'<div class="leverarms1_img1"></div>'
								+'<div id="leverarms1_cross1" class="leverarms_cross1"></div>'
								+'<div id="leverarms1_axe1" class="leverarms_axe1"></div>'
							+'</div>'
						+'</td>'
						+'<td align="center" class="tdright">'
							+'<div class="leverarms_img2_ctnr">'
								+'<div class="leverarms1_img2"></div>'
								+'<div id="leverarms1_cross2" class="leverarms_cross2"></div>'
								+'<div id="leverarms1_axe2" class="leverarms_axe2"></div>'
							+'</div>'
						+'</td>'
					+'</tr>'
				+'</table>'

				+'<table id="tab_leverarms">'
					+'<tr>'
						+'<td align="center"><div id="input_leverarmxv1"></div></td>'
						+'<td align="center"><div id="input_leverarmxv2"></div></td>'
						+'<td align="center"><div id="input_leverarmxv3"></div></td>'
					+'</tr>'
				+'</table>'

			+'</div>';
		}

		cnt +=
		 '<div id="params_misalignments">'
			+'<div class="params">'
				+'<div id="input_mesaroll"></div>'
				+'<div id="input_mesapitch"></div>'
				+'<div id="input_mesaheading"></div>'
				+'<div id="input_scalefactor"></div>'
			+'</div>'
		+'</div>'

		+'<div id="params_coupling_mode">'
			+'<div class="params">'
				+'<div id="checkbox_coupling_mode"></div>'
				+'<div id="select_dvltype"></div>'
			+'</div>'
		+'</div>'

		+ '<div id="params_utc">'
			+'<div class="params">'
				+'<div id="select_pps"></div>'
				+'<div id="select_ppsprotocol"></div>'
			+'</div>'
		+'</div>'

		+'<div id="params_depth">'
			+'<div class="params">'
				+'<div class="table-cell">'
					+'<div id="input_depthoffset"></div>'
				+'</div>'
				+'<div class="table-cell">'
					+'<div id="zero_depth" class="displaynone"></div>'
				+'</div>'
			+'</div>'
		+'</div>'

		+'<div id="params_watertype_selection">'
			+'<div class="params">'
				+'<table id="tab_watertype">'
						+'<td><div id="watertype">'+MSG(['parameters','watertype_label'])+'</div></td>'
						+'<td>'
							+'<div id="input_saltwater"></div>'
							+'<div id="input_freshwater"></div>'
						+'</td>'
				+'</table>'
				+'<div id="input_waterdensity"></div>'
			+'</div>'
		+'</div>'

		+'<div id="params_usbl">'
			+'<div class="params">'
				+'<div id="input_tpcode"></div>'
			+'</div>'
		+'</div>'


		+'<div id="params_geoid">'
			+'<div class="params">'
				+'<div id="input_geoid"></div>'
			+'</div>'
		+'</div>';
		
		if (GIWIK.enable_forced_sensor)
		{
			cnt +=
			 '<div id="params_advancedsettings">'
			 	+'<div class="params">'
					+'<div id="input_always_used"></div>'
					+'<div id="input_vtg_always_used"></div>'
				+'</div>'
			+'</div>';

			cnt +=
			 '<div id="params_dvl_advancedsettings">'
			 	+'<div class="params">'
					+'<div id="input_dvlbt_always_used"></div>'
					+'<div id="input_dvlwt_always_used"></div>'
				+'</div>'
			+'</div>';
		}
	
		if(GIWIK.trig_DVL_by_pulse)
		{
			cnt +=
			 '<div id="params_dvl_advancedsettings">'
			 	+'<div class="params">'
					+'<div id="select_trigger_pulse"></div>'
				+'</div>'
			+'</div>';
		}

		GIWIK.write('params_extsensor_ctnr', cnt);


		if (GIWIK._plugins.mechanical.turret){
			GIWIK.paramGroup.construct('params_sensorpos', MSG(['box','params_sensorpos']), 'hide');	
			GIWIK.paramGroup.construct('params_turret_sign_conventions', MSG(['box','params_turret_conventions']), 'hide');
			GIWIK.paramGroup.construct('params_turret_latency', MSG(['box','params_turret_latency']), 'hide');
		}
		GIWIK.paramGroup.construct('params_misalignments', MSG(['box','params_misalignments']), 'show');

		if (GIWIK.sensors_lva) {
			GIWIK.paramGroup.construct('params_leverarms', MSG(['box','params_leverarms']), 'hide');
		}
		GIWIK.paramGroup.construct('params_utc', MSG(['box','params_utc']), 'show');
		GIWIK.paramGroup.construct('params_usbl', MSG(['box','params_usbl']), 'show');
		GIWIK.paramGroup.construct('params_depth', MSG(['box','params_depth']), 'show');
		GIWIK.paramGroup.construct('params_watertype_selection', MSG(['box','params_watertype_selection']), 'show');

		GIWIK.paramGroup.construct('params_geoid', MSG(['box','params_geoid']), 'show');
		
		if (GIWIK.enable_forced_sensor)
		{
			GIWIK.paramGroup.construct('params_advancedsettings', MSG(['box','params_advancedsettings']), 'show');
			GIWIK.paramGroup.construct('params_dvl_advancedsettings', MSG(['box','params_advancedsettings']), 'show');
		}

		GIWIK.paramGroup.construct('params_coupling_mode', MSG(['box','params_coupling_mode']), 'show');

		if( GIWIK.dvltype ){
			GIWIK.paramGroup.construct('params_dvl_type', MSG(['box','params_dvl_type']), 'show');
		}
		
		if( GIWIK._backup_sensors )
		{
			// Bouton de configuration des capteurs type backup
			// $('#usermsg_tuto').after('<div id="backup_sensors_button_ctnr"><div id="backup_sensors_button"></div></div>');
			// window.Button_BackupSensors_Enable = new Button('Button_BackupSensors_Enable', false);
			// window.Button_BackupSensors_Enable.margin = "0 5px 0 10px";
			// window.Button_BackupSensors_Enable.construct('backup_sensors_button',MSG(['buttons','backup_sensors_enable']),'small');
			// window.Button_BackupSensors_Enable.setAction('HEADING.BackupSensors_Enable();');
			// window.Button_BackupSensors_Enable.enable();
			// window.Button_BackupSensors_Enable.hide; //show();

			// Label de configuration de capteurs type Backup
			$('#table_separator').before('<div id="backup_sensors_button_ctnr" class="backupsensors_label"><div id="backup_sensors_button"></div></div>');
			GIWIK.write('backup_sensors_button',MSG(['buttons','backup_sensors_enable']));
			GIWIK.setClick('backup_sensors_button', "HEADING.BackupSensors_Enable();");
		 }


		// CONF DES PORTS (pour tous les modules liés au port, current_port_settings_changed passe à true lors d'un évènement onchange pour gérer la survenue d'une éventuelle alerte contre la perte de conf et le rafraîchissement intempestif des paramètres lors d'un getConf())
		// Paramètre "IP" (l'ip est constituée de 4 Input_int)
		var ip_min  = 0;
		var ip_max  = 255;
		var ip_step = 1;
		
		window.heading_labels_width = 85;
		
		//----------------------
		window.Input_ip_part1 = new Input_int('Input_ip_part1', true);
		window.Input_ip_part1.label_width = window.heading_labels_width;
		window.Input_ip_part1.input_width = window.ip_input_width;
		window.Input_ip_part1.construct('input_ip_part1','linear',MSG(['parameters','ip']),ip_step,ip_min,ip_max,'');
		window.Input_ip_part1.setAction("HEADING.current_port_settings_changed = true;");
		window.Input_ip_part1.show();

		window.Input_ip_part2 = new Input_int('Input_ip_part2', true);
		window.Input_ip_part2.input_width = window.ip_input_width;
		window.Input_ip_part2.construct('input_ip_part2','linear','',ip_step,ip_min,ip_max,'');
		window.Input_ip_part2.setAction("HEADING.current_port_settings_changed = true;");
		window.Input_ip_part2.show();

		window.Input_ip_part3 = new Input_int('Input_ip_part3', true);
		window.Input_ip_part3.input_width = window.ip_input_width;
		window.Input_ip_part3.construct('input_ip_part3','linear','',ip_step,ip_min,ip_max,'');
		window.Input_ip_part3.setAction("HEADING.current_port_settings_changed = true;");
		window.Input_ip_part3.show();

		window.Input_ip_part4 = new Input_int('Input_ip_part4', true);
		window.Input_ip_part4.input_width = window.ip_input_width;
		window.Input_ip_part4.construct('input_ip_part4','linear','',ip_step,ip_min,ip_max,'');
		window.Input_ip_part4.setAction("HEADING.current_port_settings_changed = true;");
		window.Input_ip_part4.show();

		// Paramètre "Port ip"
		var ip_port_min  = 1;
		var ip_port_max  = 65535;
		var ip_port_step = 1;
		//----------------------
		window.Input_ip_port = new Input_int('Input_ip_port', true);
		window.Input_ip_port.label_width = window.heading_labels_width;
		window.Input_ip_port.input_width = 60;
		window.Input_ip_port.construct('input_ip_port','linear',MSG(['parameters','ipport']),ip_port_step,ip_port_min,ip_port_max,'');
		window.Input_ip_port.setAction("HEADING.current_port_settings_changed = true;");
		window.Input_ip_port.show();


		// Paramètres série
		window.Select_Parity = new Input_select('Select_Parity', true);
		window.Select_Parity.label_width = window.heading_labels_width;
		window.Select_Parity.construct('select_parity','linear',MSG(['parameters','parity']),array_keys(System_state.ParityList),System_state.ParityList,'',true);
		window.Select_Parity.setAction("HEADING.current_port_settings_changed = true;", true);
		window.Select_Parity.show();

		window.Select_Stopbits = new Input_select('Select_Stopbits', true);
		window.Select_Stopbits.label_width = window.heading_labels_width;
		window.Select_Stopbits.construct('select_stopbits','linear',MSG(['parameters','stopbits']),array_keys(System_state.StopbitsList),System_state.StopbitsList,'',true);
		window.Select_Stopbits.setAction("HEADING.current_port_settings_changed = true;", true);
		window.Select_Stopbits.show();

		window.Select_Level = new Input_select('Select_Level', true);
		window.Select_Level.label_width = window.heading_labels_width;
		window.Select_Level.construct('select_level','linear',MSG(['parameters','standard']),array_keys(System_state.LevelList),System_state.LevelList,'',true);
		window.Select_Level.setAction("HEADING.current_port_settings_changed = true;", true);
		window.Select_Level.show();

		window.Select_Baudrate = new Input_select('Select_Baudrate', true);
		window.Select_Baudrate.label_width = window.heading_labels_width;
		window.Select_Baudrate.construct('select_baudrate','linear',MSG(['parameters','baudrate']),array_keys(System_state.BaudrateList),System_state.BaudrateList,'',true);
		window.Select_Baudrate.setAction("HEADING.current_port_settings_changed = true;", true);
		window.Select_Baudrate.show();

		window.Select_EDIRIX = new Input_select('Select_EDIRIX', true);
		window.Select_EDIRIX.label_width = window.heading_labels_width;
		window.Select_EDIRIX.construct('select_edirix','linear',MSG(['parameters','physical_link']),array_keys(System_state.EDIRIXList),System_state.EDIRIXList,'',true);
		window.Select_EDIRIX.setAction("if (HEADING.init.isdone){HEADING.current_port_settings_changed = true;} HEADING.displaySerialNetworkParams(window.Select_EDIRIX.getValue());");
		window.Select_EDIRIX.show();

		window.Select_ELCFIX = new Input_select('Select_ELCFIX', true);
		window.Select_ELCFIX.label_width = window.heading_labels_width;
		window.Select_ELCFIX.construct('select_elcfix','linear',MSG(['parameters','transport_layer']),[0,1,2,3,4],System_state.ELCFIXList,'',true);
		window.Select_ELCFIX.setAction("if (HEADING.init.isdone){HEADING.current_port_settings_changed = true;} HEADING.showHideIP(); HEADING.setIPaddressRange(window.Select_ELCFIX.getValue());");
		window.Select_ELCFIX.show();

		if( in_array('CAN',GIWIK._input_ports) )
		{
			// CAN Bus Configuration
			HEADING.CAN_Bus_Construct();
			HEADING.CAN_Sensor_Construct();
		}
		
		
		// CONF DES CAPTEURS EXTERNES (pour tous les modules liés aux capteurs externes, current_extsensor_settings_changed passe à true lors d'un évènement onchange pour gérer la survenue d'une éventuelle alerte contre la perte de conf et le rafraîchissement intempestif des paramètres lors d'un getConf())

		if (GIWIK._plugins.mechanical.turret)
		{
			var SenorsNb = 0;
			for (o in GIWIK._ext_sensors) ++SenorsNb;

			for(var i=0;i<SenorsNb;i++)
			{ 
				var elem = document.getElementById('menu_extsensor_table'+i);
				
				//console.log(i+"***"+elem.text+"***"+elem.name);
				
				if( elem.text===MSG(['ext_sensors','angles']) || elem.text===MSG(['ext_sensors','turret']) )
				{
					if( System_state.Turret===1 ){
						GIWIK.write('menu_extsensor_table'+i, MSG(['ext_sensors','turret']));						
					}
					else{
						GIWIK.write('menu_extsensor_table'+i, MSG(['ext_sensors','angles']));
					}
				}
			}
		
			// Select SensorPosition
			window.Select_SensorPos = new Input_select('Select_SensorPos', true);
			window.Select_SensorPos.label_width = window.heading_labels_width;
			window.Select_SensorPos.construct('select_sensor_position','linear',MSG(['parameters','sensor_position']),[0,1,2],[MSG(['parameters','system_position_vehicule']),MSG(['parameters','system_position_turret']),MSG(['parameters','system_position_barrel'])],'',true);
			window.Select_SensorPos.setAction(HEADING.self+".current_extsensor_settings_changed = true; HEADING.updateSensorLVADisplay();", true);
			window.Select_SensorPos.show();	

			// Turret Signs Conventions
			var TurretHeadSignConvList = [MSG(['parameters','positive_clockwise']),MSG(['parameters','positive_anticlockwise'])];
			window.Select_TurretHeadingSignConv = new Input_select('Select_TurretHeadingSignConv', true);
			window.Select_TurretHeadingSignConv.label_width = window.heading_labels_width;
			window.Select_TurretHeadingSignConv.input_width = 180;
			window.Select_TurretHeadingSignConv.construct('select_turret_heading_conv','linear',MSG(['parameters','turret_heading_sign']),array_keys(TurretHeadSignConvList),TurretHeadSignConvList,'',true);
			window.Select_TurretHeadingSignConv.setAction(HEADING.self+".current_extsensor_settings_changed = true;");
			window.Select_TurretHeadingSignConv.show();				

			// Turret Signs Conventions
			var TurretRollSignConvList = [MSG(['parameters','positive_port_up']),MSG(['parameters','positive_port_down'])];
			window.Select_TurretRollSignConv = new Input_select('Select_TurretRollSignConv', true);
			window.Select_TurretRollSignConv.label_width = window.heading_labels_width;
			window.Select_TurretRollSignConv.input_width = 180;
			window.Select_TurretRollSignConv.construct('select_turret_roll_conv','linear',MSG(['parameters','turret_roll_sign']),array_keys(TurretRollSignConvList),TurretRollSignConvList,'',true);
			window.Select_TurretRollSignConv.setAction(HEADING.self+".current_extsensor_settings_changed = true;");
			window.Select_TurretRollSignConv.show();	

			// Turret Signs Conventions
			var TurretPitchSignConvList = [MSG(['parameters','positive_barrel_up']),MSG(['parameters','positive_barrel_down'])];
			window.Select_TurretPitchSignConv = new Input_select('Select_TurretPitchSignConv', true);
			window.Select_TurretPitchSignConv.label_width = window.heading_labels_width;
			window.Select_TurretPitchSignConv.input_width = 180;
			window.Select_TurretPitchSignConv.construct('select_turret_pitch_conv','linear',MSG(['parameters','turret_pitch_sign']),array_keys(TurretPitchSignConvList),TurretPitchSignConvList,'',true);
			window.Select_TurretPitchSignConv.setAction(HEADING.self+".current_extsensor_settings_changed = true;");
			window.Select_TurretPitchSignConv.show();	

			// Turret Latency
			window.Input_TurretLatency = new Input_int('Input_TurretLatency', true);
			window.Input_TurretLatency.label_width = window.heading_labels_width;
			window.Input_TurretLatency.construct('input_turret_latency','linear',MSG(['data','latency']),0.001,0,1000,MSG(['units','millisecond']));
			window.Input_TurretLatency.setAction(HEADING.self+".current_extsensor_settings_changed = true;");
			window.Input_TurretLatency.show();
		}
		
		// Mésalignement
		window.Input_MesaRoll = new Input_int('Input_MesaRoll', true);
		window.Input_MesaRoll.label_width = 98;
		window.Input_MesaRoll.construct('input_mesaroll','linear',MSG(['data','roll']),0.001,-180,180,MSG(['units','degree']));
		window.Input_MesaRoll.setAction(HEADING.self+".current_extsensor_settings_changed = true;");
		window.Input_MesaRoll.show();


		window.Input_MesaPitch = new Input_int('Input_MesaPitch', true);
		window.Input_MesaPitch.label_width = 98;
		window.Input_MesaPitch.construct('input_mesapitch','linear',MSG(['data','pitch']),0.001,-180,180,MSG(['units','degree']));
		window.Input_MesaPitch.setAction(HEADING.self+".current_extsensor_settings_changed = true;");
		window.Input_MesaPitch.show();

		window.Input_MesaHeading = new Input_int('Input_MesaHeading', true);
		window.Input_MesaHeading.label_width = 98;
		window.Input_MesaHeading.construct('input_mesaheading','linear',MSG(['data','heading']),0.001,-180,180,MSG(['units','degree']));
		window.Input_MesaHeading.setAction(HEADING.self+".current_extsensor_settings_changed = true;");
		window.Input_MesaHeading.show();

		window.Input_ScaleFactor = new Input_int('Input_ScaleFactor', true);
		window.Input_ScaleFactor.label_width = 98;
		window.Input_ScaleFactor.construct('input_scalefactor','linear',MSG(['parameters','scale_factor']),0.001,-180,180,MSG(['units','percent']));
		window.Input_ScaleFactor.setAction(HEADING.self+".current_extsensor_settings_changed = true;");
		window.Input_ScaleFactor.show();

		if (GIWIK.sensors_lva)
		{
			// bras de levier
			window.Input_LeverArmXV1 = new Input_int('Input_LeverArmXV1', true);
			window.Input_LeverArmXV1.label_width = 30;
			window.Input_LeverArmXV1.construct('input_leverarmxv1','default',MSG(['parameters','xv1']),0.001,-180,180,MSG(['units','meter']));
			window.Input_LeverArmXV1.setAction(HEADING.self+".current_extsensor_settings_changed = true; HEADING.updateSensorLVADisplay();");
			window.Input_LeverArmXV1.show();

			window.Input_LeverArmXV2 = new Input_int('Input_LeverArmXV2', true);
			window.Input_LeverArmXV2.label_width = 30;
			window.Input_LeverArmXV2.construct('input_leverarmxv2','default',MSG(['parameters','xv2']),0.001,-180,180,MSG(['units','meter']));
			window.Input_LeverArmXV2.setAction(HEADING.self+".current_extsensor_settings_changed = true; HEADING.updateSensorLVADisplay();");
			window.Input_LeverArmXV2.show();

			window.Input_LeverArmXV3 = new Input_int('Input_LeverArmXV3', true);
			window.Input_LeverArmXV3.label_width = 30;
			window.Input_LeverArmXV3.construct('input_leverarmxv3','default',MSG(['parameters','xv3']),0.001,-180,180,MSG(['units','meter']));
			window.Input_LeverArmXV3.setAction(HEADING.self+".current_extsensor_settings_changed = true; HEADING.updateSensorLVADisplay();");
			window.Input_LeverArmXV3.show();
		}

		// UTC
		window.Select_pps = new Input_select('Select_pps', true);
		window.Select_pps.label_width = 70;
		window.Select_pps.construct('select_pps','linear',MSG(['parameters','synchroin']),array_keys(GIWIK._input_pulse_names),GIWIK._input_pulse_names,'',true);
		window.Select_pps.setAction("if ("+HEADING.self+".init.isdone){"+HEADING.self+".current_extsensor_settings_changed = true;} if (window.Select_pps.selected_option < 1){window.Select_ppsprotocol.setValue(0);window.Select_ppsprotocol.disable();}else{window.Select_ppsprotocol.enable();}");
		window.Select_pps.show();

		window._ppsprotocols = System_state.IPulseList.slice(1,5);
		window.Select_ppsprotocol = new Input_select('Select_ppsprotocol', true);
		window.Select_ppsprotocol.label_width = 70;
		window.Select_ppsprotocol.construct('select_ppsprotocol','linear',MSG(['parameters','protocol']),array_keys(window._ppsprotocols),window._ppsprotocols,'',true);
		window.Select_ppsprotocol.setAction(HEADING.self+".current_extsensor_settings_changed = true;", true);
		window.Select_ppsprotocol.show();

		// Depth offset
		window.Input_DepthOffset = new Input_int('Input_DepthOffset', true);
		window.Input_DepthOffset.label_width = window.heading_labels_width+18;
		window.Input_DepthOffset.construct('input_depthoffset','linear',MSG(['parameters','depthoffset']),0.001,-100,100,MSG(['units','meter']));
		window.Input_DepthOffset.setAction(HEADING.self+".current_extsensor_settings_changed = true;");
		window.Input_DepthOffset.show();

		window.ZeroDepth = new Button('ZeroDepth', false);
		window.ZeroDepth.margin = '0 0 0 25px';
		window.ZeroDepth.construct('zero_depth',MSG(['buttons','zero_depth']),'small');
		window.ZeroDepth.setAction
		(
			"GIWIK.ajax(GIWIK.cgifile+'?mode=3&DepthOffset',"
			+"{"
				+"eval_rtxt:true,"
				+"replace_standard_callback:function(){if (Input_DepthOffset.getValue() != System_state.DepthOffset[1]){Input_DepthOffset.setValue(System_state.DepthOffset[1]);window.current_extsensor_settings_changed = true;window.settings_modified = true;}}"
			+"});"
		);
		window.ZeroDepth.enable();
		window.ZeroDepth.show();

		// Geoidf
		window.GeoidSeparationChanged = false;
		window.Input_Geoid = new Input_int('Input_Geoid', true);
		window.Input_Geoid.label_width = 110;
		window.Input_Geoid.margin = "15px 0 0 200px";
		window.Input_Geoid.construct('input_geoid','linear',MSG(['parameters','geoid']),0.001,-100,100,MSG(['units','meter']));
		window.Input_Geoid.setAction("window.GeoidSeparationChanged = true;",false);
		window.Input_Geoid.show();
		
		// Radio button Salt Water
		window.Input_Water0 = new Input_radio('Input_Water0', true);
		window.Input_Water0.margin = "10px 0 0 0";
		window.Input_Water0.construct('input_saltwater','watertype_selection','linear',MSG(['parameters','saltwatertype_label']),1,true);
		window.Input_Water0.setAction("HEADING.changewatertypedisplay();", true);
		window.Input_Water0.show();

		// Radio button Fresh Water
		window.Input_Water1 = new Input_radio('Input_Water1', false);
		window.Input_Water1.margin = "5px 0 0 0";
		window.Input_Water1.construct('input_freshwater','watertype_selection','linear',MSG(['parameters','freshwatertype_label']),0,true);
		window.Input_Water1.setAction("HEADING.changewatertypedisplay();", true);
		window.Input_Water1.show();

		// Water Density
		window.Input_WaterDensity = new Input_int('Input_WaterDensity', false);
		window.Input_WaterDensity.label_width = window.heading_labels_width+18;
		window.Input_WaterDensity.construct('input_waterdensity','linear',MSG(['parameters','waterdensity_label']),0.1,950,1100,MSG(['units','volumetric_mass_density']));
		window.Input_WaterDensity.setAction(HEADING.self+".current_extsensor_settings_changed = true;");

		// USBL
		window.Input_tpcode = new Input_text('Input_tpcode', true);
		window.Input_tpcode.label_width = window.heading_labels_width+18;
		//window.Input_tpcode.margin_left = (GIWIK.lang == 'fr') ? 0 : 30;
		window.Input_tpcode.input_max_length = 6;
		window.Input_tpcode.construct('input_tpcode','linear',MSG(['parameters','tpcode_label']),'',true);
		window.Input_tpcode.setAction(HEADING.self+".current_extsensor_settings_changed = true;");
		window.Input_tpcode.show();


		if (GIWIK.enable_forced_sensor)
		{
			// Paramètre "Always Used"
			window.Input_always_used = new Input_checkbox('Input_always_used', true);
			window.Input_always_used.label_width = window.heading_labels_width-15;
			window.Input_always_used.construct('input_always_used','linear',MSG(['parameters','always_used']),[0,1], true);
			window.Input_always_used.setAction(HEADING.self+".current_extsensor_settings_changed = true;");
			window.Input_always_used.show();

			if(GIWIK.gps_vtg){
				// Paramètre "VTG Always Used"
				window.Input_vtg_always_used = new Input_checkbox('Input_vtg_always_used', true);
				window.Input_vtg_always_used.label_width = 100;
				window.Input_vtg_always_used.margin = "15px 0 0 0";
				window.Input_vtg_always_used.construct('input_vtg_always_used','linear',MSG(['parameters','vtg_always_used']),[0,1], true);
				window.Input_vtg_always_used.setAction(HEADING.self+".current_extsensor_settings_changed = true;");
				window.Input_vtg_always_used.show();
			}
			
			// Paramètre "Dvl BT Always Used"
			window.Input_dvlbt_always_used = new Input_checkbox('Input_dvlbt_always_used', true);
			window.Input_dvlbt_always_used.label_width = window.heading_labels_width+12;
			window.Input_dvlbt_always_used.construct('input_dvlbt_always_used','linear',MSG(['parameters','dvlbt_always_used']),[0,1], true);
			window.Input_dvlbt_always_used.setAction(HEADING.self+".current_extsensor_settings_changed = true;");
			window.Input_dvlbt_always_used.show();

			// Paramètre "Dvl WT Always Used"
			window.Input_dvlwt_always_used = new Input_checkbox('Input_dvlwt_always_used', true);
			window.Input_dvlwt_always_used.label_width = window.heading_labels_width+12;
			window.Input_dvlwt_always_used.construct('input_dvlwt_always_used','linear',MSG(['parameters','dvlwt_always_used']),[0,1], true);
			window.Input_dvlwt_always_used.setAction(HEADING.self+".current_extsensor_settings_changed = true;");
			window.Input_dvlwt_always_used.show();
		}

		if(GIWIK.trig_DVL_by_pulse){
			window.Select_Trigger_pulse = new Input_select('Select_Trigger_pulse', true);
			window.Select_Trigger_pulse.label_width = 100;
			window.Select_Trigger_pulse.construct('select_trigger_pulse','linear',MSG(['parameters','trigger_pulse']),array_keys(GIWIK._output_pulse_names),GIWIK._output_pulse_names,'',true);
			window.Select_Trigger_pulse.setAction(HEADING.self+".current_extsensor_settings_changed = true;");
			window.Select_Trigger_pulse.show();		
		}
		// Paramètre "coupling mode"
		window.Checkbox_coupling_mode = new Input_checkbox('Checkbox_coupling_mode', true);
		window.Checkbox_coupling_mode.label_width = window.heading_labels_width+12;
		window.Checkbox_coupling_mode.construct('checkbox_coupling_mode','linear',MSG(['parameters','coupling_mode']),[0,1], true);
		window.Checkbox_coupling_mode.setAction(HEADING.self+".current_extsensor_settings_changed = true;");
		window.Checkbox_coupling_mode.show();
		
		// Parametres Type de DVL
		if( GIWIK.dvltype )
		{
			window.Select_DvlType = new Input_select('Select_DvlType', true);
			window.Select_DvlType.label_width = 100;
			window.Select_DvlType.margin = "15px 0 0 250px";
			window.Select_DvlType.construct('select_dvltype','linear',MSG(['parameters','dvl_type']),[0,1],[MSG(['parameters','dvl_type_standard']),MSG(['parameters','dvl_type_phasedarray'])],'',true);
			window.Select_DvlType.show();					
		}

		// Masque du label titre "protocoles"
		window.Mask_tab_inputs_protocol = new Mask('Mask_tab_inputs_protocol', true);
		window.Mask_tab_inputs_protocol.construct('mask_tab_matrix_protocol', 30);

		// Masque des labels de protocoles
		window.Mask_tab_inputs_label = new Mask('Mask_tab_inputs_label', true);
		window.Mask_tab_inputs_label.construct('mask_tab_matrix_label', 30);

		// Masque des cellules du tableau
		window.Mask_tab_inputs = new Mask('Mask_tab_inputs', true);
		window.Mask_tab_inputs.construct('mask_tab_matrix', (window.Menu_extsensor.item_height+1) * count(GIWIK._ext_sensors)); // chaque item fait Xpx de haut et possède une marge basse de 1px)

		// Pour que la fonction HEADING.updateProtocols() trie les labels par ordre alphabétique
		HEADING.sort_protocols = true;
	}

	


	// Page des input pulses ————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
	if (window.current_input == 'input_pulses')
	{
		for (var i in GIWIK._input_pulse_list)
		{
			if (array_search(System_state['PULSEI'+GIWIK._input_pulse_list[i]+'Conf'][0],input_pulses_pro_k))
			{
				window['Select_pulse_feature'+GIWIK._input_pulse_list[i]].setValue(System_state['PULSEI'+GIWIK._input_pulse_list[i]+'Conf'][0]);
				//window['Select_pulseport'+GIWIK._input_pulse_list[i]].setValue(parseInt(i)+1);
				window['Select_pulse_feature'+GIWIK._input_pulse_list[i]].enable();
			}
			else
			{
				window['Select_pulse_feature'+GIWIK._input_pulse_list[i]].setValue(0);
				//window['Select_pulse_feature'+GIWIK._input_pulse_list[i]].disable();
				//window['Select_pulseport'+GIWIK._input_pulse_list[i]].setValue(0);
			}
		}
	}

	// Page des entrées ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
	else
	{
		if( GIWIK._backup_sensors ) {HEADING.BackupSensors_Refresh();}

		// SI UN PORT EST SÉLECTIONNÉ (hors port interne)
		if (window.Menu_port.getValue() !== undefined && !in_array(window.Menu_port.getValue(),['X','R']) )
		{
			if( GIWIK._backup_sensors ) {document.getElementById('backup_sensors_button').style.visibility = 'hidden';}

			// Définition de l'index du port en cours avec un tableau comprenant "none" comme première entrée (utile pour la gestion des pulses)
			window.current_port_index_nonebased = 1+eval(array_search(window.current_port, GIWIK._input_ports));

			// et qu'il a changé
			if (!HEADING.init.isdone || HEADING.current_port_changed || HEADING.cancel_conf || HEADING.send_conf)
			{
				// CAN Port Specific Case
				if (window.Menu_port.getValue() == 'CAN' )
				{
					// Construction du titre des paramètres
					var lbl = '';

					if (GIWIK.lang == 'fr')
					{
						lbl += MSG(['box','settings_label'])+" "+MSG(['parameters','can']);
					}
					else
					{
						lbl += MSG(['parameters','can'])+" "+MSG(['box','settings_label']);
					}
					GIWIK.write('params_menuport_label', "&bull; "+lbl.toUpperCase());
					
					// Enable CAN
					GIWIK.paramGroup.display('params_can_bus', 'show');
					
					// Disable Std Port Configuration
					GIWIK.paramGroup.display('params_protocol', 'displaynone');
					GIWIK.paramGroup.display('params_device', 'displaynone');
					GIWIK.paramGroup.display('params_serial', 'displaynone');
					GIWIK.paramGroup.display('params_ethernet', 'displaynone');	
					
					// Fill CAN Bus
					HEADING.CAN_Bus_SetConf();
				
				}
				// Others Standard Ports
				else
				{
					// Disable CAN
					GIWIK.paramGroup.display('params_can_bus', 'displaynone');
					
					// Enable Std Port Configuration
					GIWIK.paramGroup.display('params_protocol', 'show');
					GIWIK.paramGroup.display('params_device', 'show');
					HEADING.displaySerialNetworkParams(window.Select_EDIRIX.getValue());
					HEADING.displaySerialNetworkParams(window.Select_EDIRIX.getValue());
					
					// CINT1 or CINT2: Based on portcof lenght
					if (System_state["PortConf"+window.current_port].length >= 16)
					{
						window.BoardType = 2;//alert( "CINT2" );
					}
					else
					{
						window.BoardType = 1;//alert( "CINT1" );
					}

					// Construction du titre des paramètres
					var lbl = '';
					var port_label = GIWIK._input_ports_label[array_search(window.Menu_port.getValue(), GIWIK._input_ports)];

					if (GIWIK.lang == 'fr')
					{
						lbl += MSG(['box','settings_label'])+" "+MSG(['parameters','input'])+" "+port_label;
					}
					else
					{
						lbl += MSG(['parameters','input'])+" "+port_label+" "+MSG(['box','settings_label']);
					}

					GIWIK.write('params_menuport_label', "&bull; "+lbl.toUpperCase());
					lbl = null;

					// Fill Components
					window.Select_Parity.setValue(System_state['PortConf'+window.current_port][7]);

					window.Select_Stopbits.setValue(System_state['PortConf'+window.current_port][8]);

					window.Select_Level.setValue(System_state['PortConf'+window.current_port][9]);

					window.Select_Baudrate.setValue(System_state['PortConf'+window.current_port][10]);

					// Selection des Links associés à ce port ...
					var Port_Link = GIWIK._input_ports_link[window.current_port_index_nonebased-1];
					var Port_EDIRIXList = [];

					for (var i=0; i<Port_Link.length; i++)
					{
						Port_EDIRIXList.push(System_state.EDIRIXList[Port_Link[i]]);
					}
					// ... et mise à jour du select
					window.Select_EDIRIX.setList(Port_Link,Port_EDIRIXList);
					window.Select_EDIRIX.setValue(System_state['EthConfI'+window.current_port][0]);

					window.Select_ELCFIX.setValue(System_state['EthConfI'+window.current_port][1]);

					// Ip //////////////////////////////////////////////////////////////////////////////////
					window._current_port_ip = System_state['EthConfI'+window.current_port][2].split('.');

					window.Input_ip_part1.setValue(window._current_port_ip[0]);
					window.Input_ip_part2.setValue(window._current_port_ip[1]);
					window.Input_ip_part3.setValue(window._current_port_ip[2]);
					window.Input_ip_part4.setValue(window._current_port_ip[3]);

					window.Input_ip_port.setValue(System_state['EthConfI'+window.current_port][3]);

					// Gestion  UDP Multicast: Limitation Plage Adresse IP 224.XX.XX.XX 239.XX.XX.XX
					HEADING.setIPaddressRange(System_state['EthConfI'+window.current_port][1]);
				}
			}
		}

		// SI UN CAPTEUR EXTERNE EST SÉLECTIONNÉ
		if (window.Menu_extsensor.getValue() !== undefined)
		{
			if( GIWIK._backup_sensors ){document.getElementById('backup_sensors_button').style.visibility = 'hidden';}

			// et qu'il a changé
			if (!HEADING.init.isdone || HEADING.current_extsensor_changed || HEADING.cancel_conf || HEADING.send_conf)
			{
				// Construction du titre des paramètres
				var lbl = '';

				if (GIWIK.lang == 'fr'){lbl += MSG(['box','settings_label'])+" "+MSG(['ext_sensors',window.Menu_extsensor.getValue()]);}
				else{lbl += MSG(['ext_sensors',window.Menu_extsensor.getValue()])+" "+MSG(['box','settings_label']);}

				GIWIK.write('params_extsensor_label', "&bull; "+lbl.toUpperCase());
				lbl = null;

				GIWIK.paramGroup.display('params_misalignments', 'displaynone');
				GIWIK.paramGroup.display('params_leverarms', 'displaynone');
				GIWIK.paramGroup.display('params_utc', 'displaynone');
				GIWIK.paramGroup.display('params_usbl', 'displaynone');
				GIWIK.paramGroup.display('params_depth', 'displaynone');
				GIWIK.paramGroup.display('params_watertype_selection', 'displaynone');
				GIWIK.paramGroup.display('params_geoid', 'displaynone');

				if (GIWIK.enable_forced_sensor)
				{
					GIWIK.paramGroup.display('params_advancedsettings', 'displaynone');
					GIWIK.paramGroup.display('params_dvl_advancedsettings', 'displaynone');
				}

				GIWIK.paramGroup.display('params_coupling_mode', 'displaynone');
				
				if( GIWIK.dvltype){
					GIWIK.paramGroup.display('params_dvl_type', 'displaynone');
				}
				
				if (GIWIK._plugins.mechanical.turret){
					GIWIK.paramGroup.display('params_sensorpos', 'displaynone');
					GIWIK.paramGroup.display('params_turret_sign_conventions', 'displaynone');
					GIWIK.paramGroup.display('params_turret_latency', 'displaynone');
				}
				
				if (GIWIK.enable_forced_sensor){
					if(GIWIK.gps_vtg){
						window.Input_vtg_always_used.hide();
					}
				}

				if( in_array('CAN',GIWIK._input_ports) )
				{
					// Sensor CAN Configuration
					HEADING.CAN_Sensor_SetConf();
				}

						
				// Sensor Lva State
				var sensor_lva_state = (GIWIK.sensors_lva_hidden==true) ? 'hide' : 'show';

				switch (window.Menu_extsensor.getValue())
				{
					case 'gps':

						// Aucun parametre
						if(!GIWIK.enable_forced_sensor && !GIWIK.sensors_lva && !GIWIK._plugins.mechanical.turret)
						{
							GIWIK.write
							(
								'params_extsensor_label',
								$('#params_extsensor_label').html()+'<div class="no_params_required">'+MSG(['box','no_params_required'])+'</div>'
							);
						}
						// Au moins 1 parametre
						else
						{
							if (GIWIK._plugins.mechanical.turret)
							{
								if(System_state.Turret===1){
									GIWIK.paramGroup.display('params_sensorpos', 'show');
								}
								window.Select_SensorPos.setValue(System_state.GPSPos[0]);
							}
							if (GIWIK.enable_forced_sensor)
							{
								GIWIK.paramGroup.display('params_advancedsettings', 'show');
								window.Input_always_used.setValue(System_state.GPS1Forced);
								if(GIWIK.gps_vtg){
									window.Input_vtg_always_used.show();
									window.Input_vtg_always_used.setValue(System_state.VTG1Forced);
								}
							}

							if (GIWIK.sensors_lva)
							{
								GIWIK.paramGroup.display('params_leverarms', sensor_lva_state);
								window.Input_LeverArmXV1.setValue(System_state.GPSLVA[0]);
								window.Input_LeverArmXV2.setValue(System_state.GPSLVA[1]);
								window.Input_LeverArmXV3.setValue(System_state.GPSLVA[2]);
							}
							
							if(GIWIK.geoid)
							{
								GIWIK.paramGroup.display('params_geoid', 'show');	
								window.Input_Geoid.setValue(System_state.GeoidalSep);	
								window.GeoidSeparationChanged = false;								
							}
						}
						break;

					case 'gps2':

						// Aucun parametre
						if(!GIWIK.enable_forced_sensor && !GIWIK.sensors_lva && !GIWIK._plugins.mechanical.turret)
						{
							GIWIK.write
							(
								'params_extsensor_label',
								$('#params_extsensor_label').html()+'<div class="no_params_required">'+MSG(['box','no_params_required'])+'</div>'
							);
						}
						// Au moins 1 parametre
						else
						{
							if (GIWIK._plugins.mechanical.turret)
							{
								if(System_state.Turret===1){
									GIWIK.paramGroup.display('params_sensorpos', 'show');
								}
								window.Select_SensorPos.setValue(System_state.GPSPos[1]);
							}
							
							if (GIWIK.enable_forced_sensor)
							{
								GIWIK.paramGroup.display('params_advancedsettings', 'show');
								window.Input_always_used.setValue(System_state.GPS2Forced);
								if(GIWIK.gps_vtg){
									window.Input_vtg_always_used.show();
									window.Input_vtg_always_used.setValue(System_state.VTG2Forced);
								}
							}

							if (GIWIK.sensors_lva)
							{
								GIWIK.paramGroup.display('params_leverarms', sensor_lva_state);
								window.Input_LeverArmXV1.setValue(System_state.GPS2LVA[0]);
								window.Input_LeverArmXV2.setValue(System_state.GPS2LVA[1]);
								window.Input_LeverArmXV3.setValue(System_state.GPS2LVA[2]);
							}
							
							if(GIWIK.geoid)
							{
								GIWIK.paramGroup.display('params_geoid', 'show');	
								window.Input_Geoid.setValue(System_state.GeoidalSep);
								window.GeoidSeparationChanged = false;									
							}
						}
						break;

					case 'gpsm':

						// Aucun parametre
						if(!GIWIK.sensors_lva)
						{
							GIWIK.write
							(
								'params_extsensor_label',
								$('#params_extsensor_label').html()+'<div class="no_params_required">'+MSG(['box','no_params_required'])+'</div>'
							);
						}
						// Au moins 1 parametre
						else
						{
							if (GIWIK.sensors_lva)
							{
								GIWIK.paramGroup.display('params_leverarms', sensor_lva_state);
								window.Input_LeverArmXV1.setValue(System_state.GPSMLVA[0]);
								window.Input_LeverArmXV2.setValue(System_state.GPSMLVA[1]);
								window.Input_LeverArmXV3.setValue(System_state.GPSMLVA[2]);
							}
						}
						break;

					case 'depth':

						GIWIK.paramGroup.display('params_depth', 'show');
						GIWIK.paramGroup.display('params_watertype_selection', 'hide');

						if (GIWIK.enable_forced_sensor)
						{
							GIWIK.paramGroup.display('params_advancedsettings', 'show');
							window.Input_always_used.setValue(System_state.DepthForced);
						}

						if (GIWIK.sensors_lva)
						{
							GIWIK.paramGroup.display('params_leverarms', sensor_lva_state);
							window.Input_LeverArmXV1.setValue(System_state.DepthLVA[0]);
							window.Input_LeverArmXV2.setValue(System_state.DepthLVA[1]);
							window.Input_LeverArmXV3.setValue(System_state.DepthLVA[2]);
						}
						window.Input_DepthOffset.setValue(System_state.DepthOffset[0]);
						//Manage the radio button
						if(System_state.WaterParams[0] == 0)
						{
							iwater_init = 1;
						}
						else
						{
							iwater_init = 0;
						}
						window.Input_Water0.setValue(iwater_init, 'no_action');
						window.Input_Water1.setValue(iwater_init, 'no_action');
						window.Input_WaterDensity.setValue(System_state.WaterParams[1]);
						break;

					case 'usbl':

						GIWIK.paramGroup.display('params_usbl', 'show');

						if (GIWIK.enable_forced_sensor)
						{
							GIWIK.paramGroup.display('params_advancedsettings', 'show');
							window.Input_always_used.setValue(System_state.USBL1Forced);
						}

						if (GIWIK.sensors_lva)
						{
							GIWIK.paramGroup.display('params_leverarms', sensor_lva_state);
							window.Input_LeverArmXV1.setValue(System_state.USBL0LVA[0]);
							window.Input_LeverArmXV2.setValue(System_state.USBL0LVA[1]);
							window.Input_LeverArmXV3.setValue(System_state.USBL0LVA[2]);
						}
						window.Input_tpcode.setValue(System_state.USBL0Conf);
						break;

					case 'usbl2':

						GIWIK.paramGroup.display('params_usbl', 'show');

						if (GIWIK.enable_forced_sensor)
						{
							GIWIK.paramGroup.display('params_advancedsettings', 'show');
							window.Input_always_used.setValue(System_state.USBL2Forced);
						}

						if (GIWIK.sensors_lva)
						{
							GIWIK.paramGroup.display('params_leverarms', sensor_lva_state);
							window.Input_LeverArmXV1.setValue(System_state.USBL1LVA[0]);
							window.Input_LeverArmXV2.setValue(System_state.USBL1LVA[1]);
							window.Input_LeverArmXV3.setValue(System_state.USBL1LVA[2]);
						}
						window.Input_tpcode.setValue(System_state.USBL1Conf);
						break;

					case 'usbl3':

						GIWIK.paramGroup.display('params_usbl', 'show');

						if (GIWIK.enable_forced_sensor)
						{
							GIWIK.paramGroup.display('params_advancedsettings', 'show');
							window.Input_always_used.setValue(System_state.USBL3Forced);
						}

						if (GIWIK.sensors_lva)
						{
							GIWIK.paramGroup.display('params_leverarms', sensor_lva_state);
							window.Input_LeverArmXV1.setValue(System_state.USBL2LVA[0]);
							window.Input_LeverArmXV2.setValue(System_state.USBL2LVA[1]);
							window.Input_LeverArmXV3.setValue(System_state.USBL2LVA[2]);
						}
						window.Input_tpcode.setValue(System_state.USBL2Conf);
						break;

					case 'lbl':

						// Aucun parametre
						if(!GIWIK.enable_forced_sensor && !GIWIK.sensors_lva)
						{
							GIWIK.write
							(
								'params_extsensor_label',
								$('#params_extsensor_label').html()+'<div class="no_params_required">'+MSG(['box','no_params_required'])+'</div>'
							);
						}
						// Au moins 1 parametre
						else
						{
							if (GIWIK.enable_forced_sensor)
							{
								GIWIK.paramGroup.display('params_advancedsettings', 'show');
								window.Input_always_used.setValue(System_state.LBLForced);
							}

							if (GIWIK.sensors_lva)
							{
								GIWIK.paramGroup.display('params_leverarms', sensor_lva_state);
								window.Input_LeverArmXV1.setValue(System_state.LBLLVA[0]);
								window.Input_LeverArmXV2.setValue(System_state.LBLLVA[1]);
								window.Input_LeverArmXV3.setValue(System_state.LBLLVA[2]);
							}
						}
						break;

					case 'odometer':
						if (GIWIK.enable_forced_sensor)
						{
							GIWIK.paramGroup.display('params_advancedsettings', 'show');
							window.Input_always_used.setValue(System_state.OdometerForced);
						}

						GIWIK.paramGroup.display('params_misalignments', 'show');

						if (GIWIK.sensors_lva)
						{
							GIWIK.paramGroup.display('params_leverarms', sensor_lva_state);
							window.Input_LeverArmXV1.setValue(System_state.ODOLVA[0]);
							window.Input_LeverArmXV2.setValue(System_state.ODOLVA[1]);
							window.Input_LeverArmXV3.setValue(System_state.ODOLVA[2]);
						}
						window.Input_MesaRoll.setValue(System_state.ODOCAL[0]);
						window.Input_MesaPitch.setValue(System_state.ODOCAL[1]);
						window.Input_MesaHeading.setValue(System_state.ODOCAL[2]);
						window.Input_ScaleFactor.setValue(System_state.ODOCAL[3]);
						break;

					case 'dvl':
						GIWIK.paramGroup.display('params_misalignments', 'show');
						GIWIK.paramGroup.display('params_coupling_mode', 'show');
						
						if( GIWIK.dvltype){
							GIWIK.paramGroup.display('params_dvl_type', 'show');
						}
						
						if (GIWIK.enable_forced_sensor)
						{
							GIWIK.paramGroup.display('params_dvl_advancedsettings', 'show');
							window.Input_dvlbt_always_used.setValue(System_state.DVLBTForced);
							window.Input_dvlwt_always_used.setValue(System_state.DVLWTForced);
						}

						if (GIWIK.sensors_lva)
						{
							GIWIK.paramGroup.display('params_leverarms', sensor_lva_state);
							window.Input_LeverArmXV1.setValue(System_state.DVLLVA[0]);
							window.Input_LeverArmXV2.setValue(System_state.DVLLVA[1]);
							window.Input_LeverArmXV3.setValue(System_state.DVLLVA[2]);
						}
						window.Input_MesaRoll.setValue(System_state.DVLCAL[0]);
						window.Input_MesaPitch.setValue(System_state.DVLCAL[1]);
						window.Input_MesaHeading.setValue(System_state.DVLCAL[2]);
						window.Input_ScaleFactor.setValue(System_state.DVLCAL[3]);

						window.Checkbox_coupling_mode.setValue(System_state.DVLCplMode);
						
						if( GIWIK.dvltype ){
							window.Select_DvlType.setValue(System_state.DVLTypes[0]);
						}
						
						if(GIWIK.trig_DVL_by_pulse){
							window.Select_Trigger_pulse.setValue(System_state.DVLTriggerPulse);
						}
						break;

					case 'dvl2':
						GIWIK.paramGroup.display('params_misalignments', 'show');
						GIWIK.paramGroup.display('params_coupling_mode', 'show');

						if( GIWIK.dvltype){
							GIWIK.paramGroup.display('params_dvl_type', 'show');
						}
						
						if (GIWIK.enable_forced_sensor)
						{
							GIWIK.paramGroup.display('params_dvl_advancedsettings', 'show');
							window.Input_dvlbt_always_used.setValue(System_state.DVL2BTForced);
							window.Input_dvlwt_always_used.setValue(System_state.DVL2WTForced);
						}

						if (GIWIK.sensors_lva)
						{
							GIWIK.paramGroup.display('params_leverarms', sensor_lva_state);
							window.Input_LeverArmXV1.setValue(System_state.DVL2LVA[0]);
							window.Input_LeverArmXV2.setValue(System_state.DVL2LVA[1]);
							window.Input_LeverArmXV3.setValue(System_state.DVL2LVA[2]);
						}
						window.Input_MesaRoll.setValue(System_state.DVL2CAL[0]);
						window.Input_MesaPitch.setValue(System_state.DVL2CAL[1]);
						window.Input_MesaHeading.setValue(System_state.DVL2CAL[2]);
						window.Input_ScaleFactor.setValue(System_state.DVL2CAL[3]);

						window.Checkbox_coupling_mode.setValue(System_state.DVL2CplMode);
						
						if( GIWIK.dvltype ){
							window.Select_DvlType.setValue(System_state.DVLTypes[1]);
						}
						
						if(GIWIK.trig_DVL_by_pulse){
							window.Select_Trigger_pulse.setValue(System_state.DVL2TriggerPulse);						
						}
						break;

					case 'logem':

						// Aucun parametre
						if(!GIWIK.enable_forced_sensor && !GIWIK.sensors_lva)
						{
							GIWIK.write
							(
								'params_extsensor_label',
								$('#params_extsensor_label').html()+'<div class="no_params_required">'+MSG(['box','no_params_required'])+'</div>'
							);
						}
						// Au moins 1 parametre
						else
						{
							GIWIK.paramGroup.display('params_misalignments', 'displaynone'); // pas encore implémenté dans l'embarqué

							if (GIWIK.enable_forced_sensor)
							{
								GIWIK.paramGroup.display('params_advancedsettings', 'show');
								window.Input_always_used.setValue(System_state.LEM1Forced);
							}

							if (GIWIK.sensors_lva)
							{
								GIWIK.paramGroup.display('params_leverarms', sensor_lva_state);
								window.Input_LeverArmXV1.setValue(System_state.LEMLVA[0]);
								window.Input_LeverArmXV2.setValue(System_state.LEMLVA[1]);
								window.Input_LeverArmXV3.setValue(System_state.LEMLVA[2]);
							}

							window.Input_MesaRoll.setValue(System_state.LEMCAL[0]);
							window.Input_MesaPitch.setValue(System_state.LEMCAL[1]);
							window.Input_MesaHeading.setValue(System_state.LEMCAL[2]);
							window.Input_ScaleFactor.setValue(System_state.LEMCAL[3]);
						}
						break;

					case 'logem2':

						// Aucun parametre
						if(!GIWIK.enable_forced_sensor && !GIWIK.sensors_lva)
						{
							GIWIK.write
							(
								'params_extsensor_label',
								$('#params_extsensor_label').html()+'<div class="no_params_required">'+MSG(['box','no_params_required'])+'</div>'
							);
						}
						// Au moins 1 parametre
						else
						{
							GIWIK.paramGroup.display('params_misalignments', 'displaynone'); // pas encore implémenté dans l'embarqué

							if (GIWIK.enable_forced_sensor)
							{
								GIWIK.paramGroup.display('params_advancedsettings', 'show');
								window.Input_always_used.setValue(System_state.LEM2Forced);
							}

							if (GIWIK.sensors_lva)
							{
								GIWIK.paramGroup.display('params_leverarms', sensor_lva_state);
								window.Input_LeverArmXV1.setValue(System_state.LEM2LVA[0]);
								window.Input_LeverArmXV2.setValue(System_state.LEM2LVA[1]);
								window.Input_LeverArmXV3.setValue(System_state.LEM2LVA[2]);
							}

							window.Input_MesaRoll.setValue(System_state.LEM2CAL[0]);
							window.Input_MesaPitch.setValue(System_state.LEM2CAL[1]);
							window.Input_MesaHeading.setValue(System_state.LEM2CAL[2]);
							window.Input_ScaleFactor.setValue(System_state.LEM2CAL[3]);
						}
						break;

					case 'angles':
						if(GIWIK._plugins.mechanical.turret){
							if( System_state.Turret===1 )
							{
								GIWIK.paramGroup.display('params_turret_sign_conventions', 'show');
								GIWIK.paramGroup.display('params_turret_latency', 'show');
							}
							else
							{
								GIWIK.write
								(
									'params_extsensor_label',
									$('#params_extsensor_label').html()+'<div class="no_params_required">'+MSG(['box','no_params_required'])+'</div>'
								);								
							}
							
							window.Select_TurretHeadingSignConv.setValue( System_state.ANGLESConv[0] );
							window.Select_TurretRollSignConv.setValue( System_state.ANGLESConv[1] );
							window.Select_TurretPitchSignConv.setValue( System_state.ANGLESConv[2] );
							
							window.Input_TurretLatency.setValue( System_state.ANGLESLatency );
						}
						break;
					
					case 'ctd':
					case 'dov':
						// Le capteur CTD ne comporte aucun paramètre -> actualisation du label
						GIWIK.write
						(
							'params_extsensor_label',
							$('#params_extsensor_label').html()+'<div class="no_params_required">'+MSG(['box','no_params_required'])+'</div>'
						);
						break;

					case 'utc':
					case 'utc2':
						var disable_utc_params = false;
						var enable_utc_noparams_message = false;
					
						// Si l'UTC est configuré en interne, on masque les paramètres
						internal_port_index = array_search('X', GIWIK._input_ports);
						if (internal_port_index)
						{
							internal_port_index = eval(internal_port_index) + 1;
							if (GIWIK.css.getClass('row-utc_col-'+internal_port_index) == 'cell_checked'){
								disable_utc_params = true;
								enable_utc_noparams_message = true;
							}
						}
						can_port_index = array_search('CAN', GIWIK._input_ports);
						if (can_port_index)
						{
							can_port_index = eval(can_port_index) + 1;
							if (GIWIK.css.getClass('row-utc_col-'+can_port_index) == 'cell_checked'){
								disable_utc_params = true;
								enable_utc_noparams_message = false;
							}
						}
						if(disable_utc_params==true )
						{
							if( enable_utc_noparams_message==true )
							{
								GIWIK.write
								(
									'params_extsensor_label',
									$('#params_extsensor_label').html()+'<div class="no_params_required">'+MSG(['box','no_params_required'])+'</div>'
								);
							}
							break;
						}

						// Sinon on affiche les paramètres
						GIWIK.paramGroup.display('params_utc', 'show');

						// On recherche un pulse configuré en PPS
						window.Select_pps.setValue(0);
						for (i=0; i<GIWIK._input_pulse_list.length; i++)
						{
							var pulse_conf = "System_state.PULSEI" + GIWIK._input_pulse_list[i] + "Conf[0]";
							var utcint_id = "System_state.PULSEI" + GIWIK._input_pulse_list[i] + "Conf[2]";

							if ((eval(pulse_conf) > 0) && (eval(pulse_conf) <= window._ppsprotocols.length))
							{
								if ( (eval(utcint_id) == 1 && window.Menu_extsensor.getValue() == 'utc')
								  || (eval(utcint_id) == 2 && window.Menu_extsensor.getValue() == 'utc2') )
								{
								window.Select_pps.setValue(1+i);
								window.Select_ppsprotocol.setValue(eval(pulse_conf) - 1);
								break;
							}
						}
						}
						break;

				}
				if (GIWIK.sensors_lva)
				{
					HEADING.updateSensorLVADisplay();
				}
			}
		}

		// Le message doit resté affiché dans les cas suivants :
		// - si serial ou serial + ethernet : on avertit de l'écrasement de la conf en sortie
		// - si le port est configuré en ethernet ET qu'il y a un conflit avec un autre port ethernet (en entrée ou en sortie)
		if (HEADING.init.isdone && !in_array(window.Select_EDIRIX.getValue(),[1,3]) && !HEADING.eth_conflict)
		{
			window.Usermsg_conflicts.hide();
		}
	}
};

HEADING.sendConf.local = function ()
{
	var _params = {};

	// PAGE DES EVENT MARKERS ———————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
	if (window.current_input == 'input_pulses')
	{
		//alert(window.Select_pulse_featureA.getValue());

		var message_warning = "";

		window.Usermsg_conflicts.hide();

		//alert(GIWIK._input_pulse_list.length);
		for (var i = 0; i < GIWIK._input_pulse_list.length; i++)
		{
			var pulse_conf_param = "PULSEI" + GIWIK._input_pulse_list[i]+ "Conf";
			var pulse_conf = "System_state."+ pulse_conf_param + "[0]";
			//_params[pulse_conf_param] =  protocole + ",0";
			//alert("Port " + GIWIK._input_pulse_list[i] +" "+ window['Select_pulseport'+GIWIK._input_pulse_list[i]].selected_option +"/ " +eval(pulse_conf));

			//On ne reconfigure que si les données sont différentes.
			if (eval(pulse_conf) != window['Select_pulse_feature'+GIWIK._input_pulse_list[i]].getValue())
			{
				if (window['Select_pulse_feature'+GIWIK._input_pulse_list[i]].selected_option != 0)
				{
					_params[pulse_conf_param] = window['Select_pulse_feature'+GIWIK._input_pulse_list[i]].getValue()+",0";

					var port = eval(pulse_conf);

					//UTC
					if (port < 5 && port > 0)
					{
						message_warning += (message_warning=="") ? "" : "<br/>";
						message_warning += MSG(['iostatuscodes','1001'/*PORT_PULSIN_OVERW'*/]);
						//deconfigurer UTC !!!
					}
					//SEROUT
					else if (port >= 5 && port <= 9)
					{
						port = port - 5;
						message_warning += (message_warning=="") ? "" : "<br/>";
						message_warning += MSG(['iostatuscodes','1003'/*PORT_PULSIN_OVERW'*/]);
						message_warning  = message_warning.replace(/%X%/, GIWIK._output_ports[port]);
					}
					
					else if(port > 14) 
					{
						message_warning += (message_warning=="") ? "" : "<br/>";
						message_warning += MSG(['iostatuscodes','1009'/*PORT_PULSIN_OVERW'*/]);
						message_warning  = message_warning.replace(/%X%/, GIWIK._input_pulse_list[i]);
					}					
					//LOG
					// else if (port == 14)
					// {
						// message_warning += (message_warning=="") ? "" : "<br/>";
						// message_warning += MSG(['iostatuscodes','1002'/*PORT_PULSIN_OVERW'*/]);
					// }
					//ODO
					// else if (port == 15) {}
				}
				else if (window['Select_pulse_feature'+GIWIK._input_pulse_list[i]].selected_option!= eval(pulse_conf))
				{
					//On deconfigure l'evenMarker.
					//alert("On Déconfigure, pulse " + GIWIK._input_pulse_list[i]);
					_params[pulse_conf_param] = "0,0";
				}
				else
				{
					//on ne fait rien
					//alert("On ne fait rien  pulse " + GIWIK._input_pulse_list[i]);
				}
			}
		}
		if (message_warning != "")
		{
			// Affichage Message Utilisateur
			window.Usermsg_conflicts.setStatus(2, true);
			window.Usermsg_conflicts.setValue(message_warning);
			window.Usermsg_conflicts.show();
		}
	}
	// PAGE DES ENTRÉES —————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
	else
	{
		var message_warning = "";

		var port,
			_portconf     = [],
			_ethiconf     = [],
			_new_portconf = [],
			_new_ethiconf = [],
			ext_s,
			cell_value,
			extstoserial  = "",
			_cell_values  = [],
			cell_classname;

		// Masquage message Utilisateur
		// window.Usermsg_conflicts.hide(); // Inutile, méthode appelée au readConf


		// AFFECTATIONS PORTS/CAPTEURS ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		_params['ExtSToSerial'] = "";

		for (var ext_s in GIWIK._ext_sensors)
		{
			// Par défaut, aucun port n'est associé
			_cell_values[ext_s] = 0;

			for (var i in GIWIK._input_ports)
			{
				port_index = parseFloat(i)+1;

				cell_classname = GIWIK.css.getClass('row-'+ext_s+'_col-'+port_index);

				// Si la case est cochée, on associe le port au capteur externe
				if (cell_classname == 'cell_checked')
				{
					////alert(_cell_values[ext_s]+' checked '+GIWIK._input_ports_index[i]);
					 if (GIWIK.system_type === 10 && (GIWIK._input_ports_index[i] === 100) && (ext_s != 'odometer'))
					 {
						 _cell_values[ext_s] = 0;
						 message_warning += (message_warning=="") ? "" : "<br/>";
						 message_warning += MSG(['iostatuscodes','1008'/*GPS_UTC_CONF_ADVANS'*/]);
						 message_warning  = message_warning.replace(/%X%/, ext_s);
					 }
					 else if (GIWIK.system_type === 10 && (GIWIK._input_ports_index[i] === 200) && (ext_s != 'gps' && ext_s != 'utc'))
					 {
						 _cell_values[ext_s] = 0;
						 message_warning += (message_warning=="") ? "" : "<br/>";
						 message_warning += MSG(['iostatuscodes','1010'/*REPEATER_CONF_ADVANS'*/]);
						 message_warning  = message_warning.replace(/%X%/, ext_s);
					 }
					 else
					 {
						_cell_values[ext_s] = GIWIK._input_ports_index[i];
					 }
				}
			}
		}

		// Pour les capteurs absents, on reprend les valeurs reçues par "System_state.ExtSToSerial"
		for (var i in GIWIK._extsensors_fulllist)
		{
			ext_s = GIWIK._extsensors_fulllist[i];

			if (typeof _cell_values[ext_s] == 'undefined')
			{
				_cell_values[ext_s] = System_state.ExtSToSerial[i];
			}
		}

		// Construction de la requête
		var n=0;
		for (var i in GIWIK._extsensors_fulllist)
		{
			ext_s = GIWIK._extsensors_fulllist[i];

			if (n>0){extstoserial += ',';}
			extstoserial += _cell_values[ext_s];
			n++;
		}
		n=null;
		//alert(extstoserial);
		_params['ExtSToSerial'] += extstoserial;

		// AFFECTATIONS PORTS/PROTOCOLES (TOUS LES PORTS SAUF PORT COURANT) //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		for (var port in window._ipro_port)
		{
			if ( !in_array(port,['X','R','CAN']) )
			{
				_portconf = System_state['PortConf'+port];

				// S'il ne s'agit pas du port courant (traité ci-dessous) et que le protocole du port à changé par rapport à System_state, on construit la requête pour mettre uniquement le protocole à jour
				if (port !== window.Menu_port.getValue() && window._ipro_port[port] != _portconf[5])
				{
					// Mise à jour du protocole dans la conf du port
					_portconf[5] = window._ipro_port[port];

					// Construction de la requête
					_params['PortConf'+port] = _portconf.join(',');
				}
			}
		}

		// SI UN PORT EST SELECTIONNÉ (sauf port interne)
		if (window.Menu_port.getValue() !== undefined && !in_array(window.Menu_port.getValue(),['X','R','CAN']) )
		{
			_portconf = eval("System_state.PortConf"+window.Menu_port.getValue());

			_new_portconf     = eval("["+_portconf.join(',')+"]");
			_new_portconf[5]  = window.Select_IPro.getValue();
			_new_portconf[7]  = window.Select_Parity.getValue();
			_new_portconf[8]  = window.Select_Stopbits.getValue();
			_new_portconf[9]  = window.Select_Level.getValue();
			_new_portconf[10] = window.Select_Baudrate.getValue();


			_ethiconf = eval("System_state.EthConfI"+window.Menu_port.getValue());

			_new_ethiconf[0] = window.Select_EDIRIX.getValue();
			_new_ethiconf[1] = window.Select_ELCFIX.getValue();
			_new_ethiconf[2] = window.Input_ip_part1.getValue()+"."+window.Input_ip_part2.getValue()+"."+window.Input_ip_part3.getValue()+"."+window.Input_ip_part4.getValue();
			_new_ethiconf[3] = window.Input_ip_port.getValue();


			// Gestion des conflits ethernet ----------------------------------------------------------------
			HEADING.eth_conflict = false;

			// Si l'entrée courante est configurée en ethernet (ou serial + ethernet)
			if (in_array(window.Select_EDIRIX.getValue(),[2,3]))
			{
				// Vérification de la validité de la configuration Ethernet
				HEADING.eth_conflict = !HEADING.checkEthConf(
					window.current_port,
					'input',
					{
						'tlayer' : _new_ethiconf[1],
						'ip'     : _new_ethiconf[2],
						'port'   : _new_ethiconf[3]
					},
					'Usermsg_conflicts');
			}

			if (HEADING.eth_conflict) {return false;}
			//-----------------------------------------------------------------------------------------------


			// Si la conf a changé (hors ethernet)
			if (_new_portconf.join(',') != _portconf.join(','))
			{
				_params['PortConf'+window.Menu_port.getValue()] = _new_portconf.join(',');
			}

			// Si la conf ethernet a changé
			if (_new_ethiconf.join(',') != _ethiconf.join(','))
			{
				_params['EthConfI'+window.Menu_port.getValue()] = _new_ethiconf.join(',');
			}
		}
		// Paramètres port CAN
		else if (window.Menu_port.getValue() !== undefined && window.Menu_port.getValue()=='CAN' )
		{
			_params['CAN_Conf'] = window.Select_CAN_Spec.getValue() + "," 
								 + window.Select_CAN_Norm.getValue() + "," 
								 + window.Select_CAN_Speed.getValue();							 
		}

		// SI UN CAPTEUR EXTERNE EST SÉLECTIONNÉ
		if (window.Menu_extsensor.getValue() !== undefined)
		{
			if (GIWIK.sensors_lva)
			{
				var request_lva = window.Input_LeverArmXV1.getValue()+","+window.Input_LeverArmXV2.getValue()+","+window.Input_LeverArmXV3.getValue();
			}

			var request_cal = window.Input_MesaRoll.getValue()+","+window.Input_MesaPitch.getValue()+","+window.Input_MesaHeading.getValue()+","+window.Input_ScaleFactor.getValue();
			var request_cnf = window.Input_tpcode.getValue();
			var request_wt  = (1-window.Input_Water0.getValue())+","+window.Input_WaterDensity.getValue();

			if (GIWIK.enable_forced_sensor)
			{
				var request_rej 	  = window.Input_always_used.getValue();
				if(GIWIK.gps_vtg){
					var request_vtg_rej   = window.Input_vtg_always_used.getValue();
				}
				var request_dvlbt_rej = window.Input_dvlbt_always_used.getValue();
				var request_dvlwt_rej = window.Input_dvlwt_always_used.getValue();
			}
			if(GIWIK.trig_DVL_by_pulse){
				var request_dvl_trigger_pulse = window.Select_Trigger_pulse.getValue();
			}
			
			switch (window.Menu_extsensor.getValue())
			{
				 case 'gps':
					_params['GPSLVA'] = request_lva;
					_params['GPS1Forced'] = request_rej;
					if(GIWIK.gps_vtg){
						_params['VTG1Forced'] = request_vtg_rej;
					}
					// Gestion Position GPS si tourelle
					if (GIWIK._plugins.mechanical.turret){
						_params['GPSPos'] = window.Select_SensorPos.getValue() + "," + System_state.GPSPos[1];
					}
					if(GIWIK.geoid && window.GeoidSeparationChanged==true)
					{
						_params['GeoidalSep'] = window.Input_Geoid.getValue();
						window.GeoidSeparationChanged=false;
					}
					break;

				case 'gps2':
					_params['GPS2LVA'] = request_lva;
					_params['GPS2Forced'] = request_rej;
					if(GIWIK.gps_vtg){
						_params['VTG2Forced'] = request_vtg_rej;	
					}						
					// Gestion Position GPS si tourelle
					if (GIWIK._plugins.mechanical.turret){
						_params['GPSPos'] = System_state.GPSPos[0] + "," + window.Select_SensorPos.getValue();
					}	
					if(GIWIK.geoid && window.GeoidSeparationChanged==true)
					{
						_params['GeoidalSep'] = window.Input_Geoid.getValue();
						window.GeoidSeparationChanged=false;
					}					
					break;

				case 'gpsm':
					_params['GPSMLVA'] = request_lva;
					break;

				case 'depth':
					_params['DepthLVA'] = request_lva;
					_params['DepthOffset'] = window.Input_DepthOffset.getValue();
					_params['DepthForced'] = request_rej;
					_params['WaterParams'] = request_wt;
					break;

				case 'usbl':
					_params['USBL0LVA'] = request_lva;
					_params['USBL0Conf'] = request_cnf;
					_params['USBL1Forced'] = request_rej;
					break;

				case 'usbl2':
					_params['USBL1LVA'] = request_lva;
					_params['USBL1Conf'] = request_cnf;
					_params['USBL2Forced'] = request_rej;
					break;

				case 'usbl3':
					_params['USBL2LVA'] = request_lva;
					_params['USBL2Conf'] = request_cnf;
					_params['USBL3Forced'] = request_rej;
					break;

				case 'lbl':
					_params['LBLLVA'] = request_lva;
					_params['LBLForced'] = request_rej;
					break;

				case 'odometer':
					_params['ODOLVA'] = request_lva;
					_params['ODOCAL'] = request_cal;
					_params['OdometerForced'] = request_rej;
					break;

				case 'dvl':
					_params['DVLLVA'] = request_lva;
					_params['DVLCAL'] = request_cal;
					_params['DVLBTForced'] = request_dvlbt_rej;
					_params['DVLWTForced'] = request_dvlwt_rej;
					_params['DVLCplMode'] = window.Checkbox_coupling_mode.getValue();
					if( GIWIK.dvltype ){
						_params['DVLTypes'] = window.Select_DvlType.getValue() + "," + System_state.DVLTypes[1];
					}
					if(GIWIK.trig_DVL_by_pulse){
						_params['DVLTriggerPulse'] = request_dvl_trigger_pulse;
					}
					break;

				case 'dvl2':
					_params['DVL2LVA'] = request_lva;
					_params['DVL2CAL'] = request_cal;
					_params['DVL2BTForced'] = request_dvlbt_rej;
					_params['DVL2WTForced'] = request_dvlwt_rej;
					_params['DVL2CplMode'] = window.Checkbox_coupling_mode.getValue();
					if( GIWIK.dvltype ){
						_params['DVLTypes'] = System_state.DVLTypes[0] + "," + window.Select_DvlType.getValue();
					}
					if(GIWIK.trig_DVL_by_pulse){
						_params['DVL2TriggerPulse'] = request_dvl_trigger_pulse;	
					}					
					break;

				case 'logem':
					_params['LEMLVA'] = request_lva;
					_params['LEMCAL'] = request_cal;
					_params['LEM1Forced'] = request_rej;
					break;

				case 'logem2':
					_params['LEM2LVA'] = request_lva;
					_params['LEM2CAL'] = request_cal;
					_params['LEM2Forced'] = request_rej;
					break;

				case 'utc':
				case 'utc2':

					internal_port_index = array_search('X', GIWIK._input_ports);
					if (internal_port_index)
					{
						internal_port_index = eval(internal_port_index) + 1;
						if (GIWIK.css.getClass('row-utc_col-'+internal_port_index) == 'cell_checked')
							break;
					}

					for (i=0; i<GIWIK._input_pulse_list.length; i++)
					{
						var pulse_conf_param = "PULSEI" + GIWIK._input_pulse_list[i] + "Conf";
						var pulse_conf = "System_state." + pulse_conf_param + "[0]";
						var utcint_id = "System_state.PULSEI" + GIWIK._input_pulse_list[i] + "Conf[2]";


						if (window.Select_pps.getValue() === i+1)
						{
							if (eval(utcint_id) == 2 && window.Menu_extsensor.getValue() == 'utc') {
								// Ecrasement de la Configuration de l'Entrée de Synchro UTC2
								message_warning += (message_warning=="") ? "" : "<br/>";
								message_warning += MSG(['iostatuscodes','1001'/*PORT_PULSIN_OVERW'*/]);
								message_warning  = message_warning.replace(/UTC/, 'UTC2');
								// alert(message_warning);
							}
							else if (eval(utcint_id) == 1  && window.Menu_extsensor.getValue() == 'utc2') {
								// Ecrasement de la Configuration de l'Entrée de Synchro UTC1
								message_warning += (message_warning=="") ? "" : "<br/>";
								message_warning += MSG(['iostatuscodes','1001'/*PORT_PULSIN_OVERW'*/]);
								message_warning  = message_warning.replace(/UTC/, 'UTC1');
								// alert(message_warning);
							}
							var protocole = 1 + window.Select_ppsprotocol.getValue();
							_params[pulse_conf_param] = protocole + ",0";

							if (window.Menu_extsensor.getValue() == 'utc')
								_params[pulse_conf_param] += ",1";
							if (window.Menu_extsensor.getValue() == 'utc2')
								_params[pulse_conf_param] += ",2";

							if (eval(pulse_conf) > window._ppsprotocols.length)
							{
								//alert(window._ppsprotocols.length);

								var port = eval(pulse_conf);

								if (port<10)
								{
									port = port - 5;
									message_warning += (message_warning=="") ? "" : "<br/>";
									message_warning += MSG(['iostatuscodes','1003'/*PORT_PULSIN_OVERW'*/]);
									message_warning  = message_warning.replace(/%X%/, GIWIK._output_ports[port]);
								}
								else if (port>=10&&port<=14)
								{
									port = port - 5;
									message_warning += (message_warning=="") ? "" : "<br/>";
									message_warning += MSG(['iostatuscodes','1007'/*PORT_PULSIN_OVERW'*/]);
									message_warning  = message_warning.replace(/%X%/, GIWIK._input_pulse_list[i]);
								}
								else
								{
									message_warning += (message_warning=="") ? "" : "<br/>";
									message_warning += MSG(['iostatuscodes','1009'/*PORT_PULSIN_OVERW'*/]);
									message_warning  = message_warning.replace(/%X%/, GIWIK._input_pulse_list[i]);
								}
							}
						}
						else
						{
							if ((eval(pulse_conf) > 0) && (eval(pulse_conf) <= window._ppsprotocols.length))
							{
								// Deconfigure other ports previously configured in PPS mode
								if ( (eval(utcint_id) == 1 && window.Menu_extsensor.getValue() == 'utc')
								|| (eval(utcint_id) == 2 && window.Menu_extsensor.getValue() == 'utc2') )
								{

									_params[pulse_conf_param] = "0,0,0";
								}
							}
						}
					}
					break;
					
				case 'angles':
				
					if (GIWIK._plugins.mechanical.turret){
						_params['ANGLESConv'] = window.Select_TurretHeadingSignConv.getValue() + "," +
												window.Select_TurretRollSignConv.getValue() + "," +
												window.Select_TurretPitchSignConv.getValue();
						_params['ANGLESLatency'] = window.Input_TurretLatency.getValue()
					}
					break;
			}

			
			// Capteurs Externe configuré en CAN
			var can_port_index = array_search('CAN', GIWIK._input_ports);
			if (can_port_index)
			{
				can_port_index = eval(can_port_index) + 1;
				
				if (GIWIK.css.getClass('row-'+window.Menu_extsensor.getValue()+'_col-'+can_port_index) == 'cell_checked'){
					
					// Send CAN Sensors Configuration
					_params['CAN_ExtS'] = HEADING.CAN_Sensor_GetConf();	
				}
			}
			
			request_rej = null;
			request_vtg_rej = null;
			request_dvlbt_rej = null;
			request_dvlwt_rej = null;

			request_lva = null;
		}	request_cal = null;

		// SI UN PORT EST SELECTIONNÉ (hors port interne)
		if (window.Menu_port.getValue() !== undefined && !in_array(window.Menu_port.getValue(),['X','R','CAN']))
		{
			//  Check si Conf Série a changé
			// --------------------------------------
			if( window.BoardType !== 2 && 				// CINT2 non concernée
			    GIWIK.same_in_out_serial_conf !== 0 &&   // Same conf for Input/output
			  ((System_state['PortConf'+window.current_port][7]  !== window.Select_Parity.getValue()) ||
			   (System_state['PortConf'+window.current_port][8]  !== window.Select_Stopbits.getValue()) ||
			   (System_state['PortConf'+window.current_port][9]  !== window.Select_Level.getValue()) ||
			   (System_state['PortConf'+window.current_port][10] !== window.Select_Baudrate.getValue())))
			{
				message_warning += (message_warning=="") ? "" : "<br/>";
				message_warning += MSG(['iostatuscodes','1006'/*PORT_RSOUT_OVERW'*/]);
				message_warning  = message_warning.replace(/%X%/, GIWIK._output_ports[window.current_port_index_nonebased-1]);
			}
		}

		// Message Alerte en cas d'ecrasement de la config Port Serie
		// -----------------------------------------------------------------------------
		if (message_warning != "")
		{
			// Affichage Message Utilisateur
			window.Usermsg_conflicts.setStatus(2, true);
			window.Usermsg_conflicts.setValue(message_warning);
			window.Usermsg_conflicts.show();
		}

		// Envoi des paramètres
		return _params;
	}

	return _params;
};