GIWIK.init.js(['msg','css']);

// [DAT 19/12/2013 (PHSUR-519)] Trie les index des protocoles en fonction du tri alphabétique de leur noms ("first_value_is_none = true" permet de conserver un paramètre "None" en position 0)
HEADING.sort_protocols = function (_num, _list)
{
	var my_extended_list  = new Array(_num,_list);
	var my_index_max      = 0;

	// Check if First protocol is none
	var first_value_is_none = (~System_state.OProList[0].indexOf('NONE')) ? true : false;

	//Si le premier élément n'est pas NONE
	if(first_value_is_none==false)
	{
		var none_is_found = false;
		for(var i in my_extended_list[1])
		{
			//Recherche de l'indice du dernier protocole avant none
			if((~my_extended_list[1][i].indexOf('NONE')) && (none_is_found == false))
			{
				my_index_max = i;
				none_is_found = true;
			}
		}

		//Adaptation des indices négatifs (spécifique usine)
		for(var j in my_extended_list[0])
		{
			my_extended_list[0][j] = j-my_index_max;
		}
	}

	var _list_without_none = (first_value_is_none) ? my_extended_list[1].slice(1, count(my_extended_list[1])) : array_copy(my_extended_list[1]);

	//Construction de la chaine contenant l'éventuel label "None"
	var none_list = (first_value_is_none) ? "'"+my_extended_list[1][0]+"'," : "'"+my_extended_list[1][my_index_max]+"',";

	//Tri du tableau des labels (l'éventuelle label "None" reste en position 0)
	var _list_sorted = eval("["+none_list+"'"+array_copy(_list_without_none).sort().join("','")+"']");

	var _num_sorted  = new Array();
	for (var i in _list_sorted)
	{
		_num_sorted.push(my_extended_list[0][array_search(_list_sorted[i], my_extended_list[1], true)]);
	}

	//Suppression du doublon de NONE
	var count_none = 0;
	for(var i=1;i<count(_list_sorted);i++)
	{
		if(~_list_sorted[i].indexOf('NONE'))
			count_none++;
	}
	
	for(var i=1;i<count(_list_sorted);i++)
	{
		if(~_list_sorted[i].indexOf('NONE'))
		{
			_num_sorted.splice(i,count_none);
			_list_sorted.splice(i,count_none);
		}
	}

	//Suppression des protocoles "NOT_USE_X"
	var count_notuse = 0;
	for(var i=1;i<count(_list_sorted);i++)
	{
		if(~_list_sorted[i].indexOf('NOT USE'))
			count_notuse++;
	}
	
	for(var i=1;i<count(_list_sorted);i++)
	{
		if(~_list_sorted[i].indexOf('NOT USE'))
		{
			_num_sorted.splice(i,count_notuse);
			_list_sorted.splice(i,count_notuse);
		}
	}
	
	return  {_num : _num_sorted, _list : _list_sorted};
};


HEADING.filter_protocols = function (_num, _list)
{
	var _num_filtered = _num;
	var _list_filtered = new Array();
	var filter_needed = false;


	/*if( GIWIK.is_gyro == true )
	{
		// Compute Output Protocol Id Filtered List
		if( window.Checkbox_realtime_heave_filter.getValue() ){ // Real Time Heave
			_num_filtered = array_intersect(_num_filtered,System_state.OProNum_RealTimeHeave);
			filter_needed = true;
		}
		if( window.Checkbox_delayed_heave_filter.getValue() ){ // Real Time Heave
			_num_filtered = array_intersect(_num_filtered,System_state.OProNum_DelayedHeave);
			filter_needed = true;
		}
	}

	// Filter Needed
	if( GIWIK.is_gyro == true && filter_needed )
	{
		// Remove values appearing twice
		for(var i=0; i<_num_filtered.length; ++i) {
			for(var j=i+1; j<_num_filtered.length; ++j) {
				if(_num_filtered[i] === _num_filtered[j])
					_num_filtered.splice(j--, 1);
			}
		}

		// Compute Corresponding Protcols Names List
		for(var i=0; i<_num_filtered.length; ++i) {
			_list_filtered.push(_list[array_search(_num_filtered[i],_num, true)]);
		}
	}
	// Filter Not needed
	else*/
	{
		_num_filtered = _num;
		_list_filtered = _list;
	}

	return  {_num : _num_filtered, _list : _list_filtered};
}



HEADING.update_protocols = function()
{
	var _protocols_filtered;
	var _protocols_sorted;

	// Filter Protocols List
	_protocols_filtered = HEADING.filter_protocols(array_keys(System_state.OProList), System_state.OProList);

	// Sort Protocols List
	_protocols_sorted = HEADING.sort_protocols(_protocols_filtered['_num'], _protocols_filtered['_list']);

	// Update protocols list
	window.Select_OPro.setList(_protocols_sorted['_num'],_protocols_sorted['_list']);

	// Check if selected proto id still in the list: If not reset proto id
	if( array_search(System_state["PortConf"+window.current_port][0],_protocols_sorted['_num'], true) == false )
	{
		System_state["PortConf"+window.current_port][0] = _protocols_sorted['_num'][0];
		window.Select_OPro.setValue(System_state["PortConf"+window.current_port][0]);
	}
}


HEADING.updatePulseOut = function ()
{
	for (i in GIWIK._output_pulse_list)
	{
		var pulse_proto = window['Select_PULSEOUT_'+i].getValue();

		switch (System_state.OPulseParamType[pulse_proto])
		{
			case 1:
				window['Input_PULSEOUT_'+i].show();
				window['Input_PULSEOUT_'+i].setLabel(MSG(['parameters','distance']));
				window['Input_PULSEOUT_'+i].setUnit(MSG(['units','meter']));
				break;
			case 2:
				window['Input_PULSEOUT_'+i].show();
				window['Input_PULSEOUT_'+i].setLabel(MSG(['parameters','period']));
				window['Input_PULSEOUT_'+i].setUnit(MSG(['units','second']));
				break;
			case 0:
			default:
				window['Input_PULSEOUT_'+i].hide();
				break;
		}
	}
};

HEADING.displayFreqPulseIn = function ()
{
	if (window.Radio_pulsein0.getValue() === 1)
	{
		window.Select_OProRate.disable();
		window.Select_pulsein.enable();
	}
	else
	{
		window.Select_pulsein.disable();
		window.Select_OProRate.enable();
	}
};

HEADING.setIPaddressRange = function (TransportLayer)
{
	// UDP MultiCast
	if (TransportLayer === 4)
	{
		window.Input_ip_part1.updateBounds(224,239);
	}
	// UDP BraodCast, TCP ..
	else
	{
		window.Input_ip_part1.updateBounds(0,255);
	}
};


HEADING.setSettingsActivity.local = function (action)
{
	if (action == 'enable')
	{
		HEADING.displayFreqPulseIn();
	}
};

HEADING.readData.local = function()
{
	/* PHSUR-349: Serial buffer full detection */
	var Index = parseInt(array_search(window.current_port, GIWIK._output_ports));
	var Status = 0x00020000 << Index;

	if( System_state._ui_status[4]&Status)
	{
		window.Serial_status.setValue(MSG(['detailedstatuscodes',GIWIK._status_bits_info[17 + Index + 32*4].msg]) + ": " + MSG(['parameters','serial_status']));
		window.Serial_status.setStatus(3);
		window.Serial_status.show();
	}
	else
	{
		window.Serial_status.hide();
	}
	
	if(GIWIK.heave)
	{
		//Specific treatment when smart heave is selected: SmartHeave -> Primary lever arm only
		if(window.Radio_Heave1.getValue() == 1)
		{
			window.Select_LevelLva.setValue(0);
		}
	}
};

HEADING.readConf.local = function ()
{
	if (!HEADING.init.isdone)
	{
		// Pulse In (Synchro In)
		window.Select_pulsein = new Input_select('Select_pulsein', true);
		window.Select_pulsein.auto_enable = false;
		window.Select_pulsein.label_width = HEADING.heading_labels_width;
		window.Select_pulsein.construct('select_pulsein','linear',MSG(['parameters','synchroin']),array_keys(GIWIK._input_pulse_names),GIWIK._input_pulse_names,'',true);
		window.Select_pulsein.show();



		// Protocole
		window.Select_OPro = new Input_select('Select_OPro', true);
		window.Select_OPro.label_width = HEADING.heading_labels_width;
		window.Select_OPro.margin_left = HEADING.inputs_left_margin;
		window.Select_OPro.construct('select_opro','linear',MSG(['parameters','protocol']),[],[],'',true);
		window.Select_OPro.show();

		if (GIWIK.is_gyro == true) {// TO COMPLETE
			// Si le protocole choisi n'est pas "from library", on cache les paramètres UDP et on vide le champ Input_file_udp
			window.Select_OPro.setAction("if (window.Select_OPro.getValueLabel().toLowerCase().indexOf('library')>=0){$('#udp_settings').slideDown();}else{$('#udp_settings').slideUp();window.Input_file_udp.setValue();};HEADING.getProtoDataBlock();",true);

			//console.log(eval("window.Select_OPro.getValueLabel().toLowerCase();"));
			//$('#udp_settings').slideDown();
		}
		else
		{
			window.Select_OPro.setAction("HEADING.getProtoDataBlock();", true);
		}


		// Bras de levier
		window.Select_LevelLva = new Input_select('Select_LevelLva', true);
		window.Select_LevelLva.label_width = HEADING.heading_labels_width;
		window.Select_LevelLva.margin_left = HEADING.inputs_left_margin;
		window.Select_LevelLva.construct('select_levellva','linear',MSG(['parameters','levellva']),array_keys(System_state.LevelLvaList),System_state.LevelLvaList,'',true);
		window.Select_LevelLva[(!GIWIK.system_lva || !GIWIK.secondary_lva) ? 'hide' : 'show']();

		if (GIWIK.hrp_output_convention == true)
		{
			// Convention HRP
			window.Select_HRPConvention = new Input_select('Select_HRPConvention', true);
			window.Select_HRPConvention.label_width = HEADING.heading_labels_width;
			window.Select_HRPConvention.margin_left = HEADING.inputs_left_margin;
			window.Select_HRPConvention.construct('select_HRPconv','linear',MSG(['parameters','hrp_conv']),array_keys(System_state.HRPConvList),System_state.HRPConvList,'',true);
		}
		
		// Rate du protocole
		var _oprorate_text  = ["None","5ms - 200Hz","10ms - 100Hz","20ms - 50Hz","30ms - 33.3Hz","40ms - 25Hz","50ms - 20Hz","100ms - 10Hz","200ms - 5Hz","300ms - 3.33Hz","400ms - 2.5Hz","500ms - 2Hz","1000ms - 1Hz","2000ms - 0.5Hz","3000ms - 0.33Hz","4000ms - 0.25Hz","5000ms - 0.2Hz","10000ms - 0.1Hz"];
		var _oprorate_value = [0, 5, 10, 20, 30, 40, 50, 100, 200, 300, 400, 500, 1000, 2000, 3000, 4000, 5000, 10000];

		window.Select_OProRate = new Input_select('Select_OProRate', true);
		window.Select_OProRate.label_width = HEADING.heading_labels_width;
		window.Select_OProRate.auto_enable = false;
		window.Select_OProRate.construct('select_oprorate','linear',MSG(['parameters','rate']),_oprorate_value,_oprorate_text,'',true);
		window.Select_OProRate.show();

		if (GIWIK.is_gyro == true)
		{
			// ZDA: MOde Gyro
			window.Checkbox_zda = new Input_checkbox('Checkbox_zda', true);
			window.Checkbox_zda.label_width = HEADING.heading_labels_width+50;
			window.Checkbox_zda.margin_left = HEADING.inputs_left_margin;
			window.Checkbox_zda.construct('checkbox_zda','linear',MSG(['parameters','zda']),[0,1],true);
			window.Checkbox_zda.show();
		}

		if (GIWIK.heave == true)
		{
			// Type de heave avec Select
			/*window.Select_Heave = new Input_select('Select_Heave', true);
			window.Select_Heave.label_width = HEADING.heading_labels_width;
			window.Select_Heave.margin_left = HEADING.inputs_left_margin;
			window.Select_Heave.construct('select_heave','linear',MSG(['parameters','heave']),array_keys(System_state.HeaveList),System_state.HeaveList,'',true);
			window.Select_Heave[(GIWIK.heave && count(System_state.HeaveList) >= 2) ? 'show' : 'hide']();*/

			// Type de heave avec radio
			for (var i=0; i<count(System_state.HeaveList); i++)
			{
				eval("window.Radio_Heave"+i+" = new Input_radio('Radio_Heave"+i+"', true);");
				eval("window.Radio_Heave"+i+".margin_left = HEADING.inputs_left_margin_radio;");
				eval("window.Radio_Heave"+i+".construct('radio_heave"+i+"','heave','linear',System_state.HeaveList["+i+"],"+i+",true);");
				eval("window.Radio_Heave"+i+".setAction('', true);");
				eval("window.Radio_Heave"+i+".show();");
				eval("window.Radio_Heave"+i+".enable();");
			}
		}

		// Mode d'altitude
		window.Select_AltiRef = new Input_select('Select_AltiRef', true);
		window.Select_AltiRef.label_width = HEADING.heading_labels_width;
		window.Select_AltiRef.margin_left = HEADING.inputs_left_margin;
		window.Select_AltiRef.construct('select_altiref','linear',MSG(['parameters','altiref']),array_keys(System_state.AltiRefList),System_state.AltiRefList,'',true);
		window.Select_AltiRef[(GIWIK.alti_depth) ? 'show' : 'hide']();

		/*if( GIWIK.is_gyro == true )
		{
			// Boutons radios pour le filtrage des protocoles fournissant du Heave
			window.Checkbox_realtime_heave_filter = new Input_checkbox('Checkbox_realtime_heave_filter', true);
			window.Checkbox_realtime_heave_filter.label_width = HEADING.heading_labels_width+50;
			window.Checkbox_realtime_heave_filter.margin_left = HEADING.inputs_left_margin;
			window.Checkbox_realtime_heave_filter.construct('checkbox_realtime_heave_filter','linear',MSG(['parameters','realtime_heave']),[0,1],true);
			window.Checkbox_realtime_heave_filter.setAction("HEADING.update_protocols();",true);
			window.Checkbox_realtime_heave_filter.show();

			window.Checkbox_delayed_heave_filter = new Input_checkbox('Checkbox_delayed_heave_filter', true);
			window.Checkbox_delayed_heave_filter.label_width = HEADING.heading_labels_width+50;
			window.Checkbox_delayed_heave_filter.margin_left = HEADING.inputs_left_margin;
			window.Checkbox_delayed_heave_filter.construct('checkbox_delayed_heave_filter','linear',MSG(['parameters','delayed_heave']),[0,1],true);
			window.Checkbox_delayed_heave_filter.setAction("HEADING.update_protocols();",true);
			window.Checkbox_delayed_heave_filter.show();
		}*/

		// Extrapolation time
		if( GIWIK.output_extrapolation == true )
		{
			window.Input_ExtraTime = new Input_int('Input_ExtraTime', true);
			window.Input_ExtraTime.label_width = HEADING.heading_labels_width;
			window.Input_ExtraTime.margin_left = HEADING.inputs_left_margin;
			window.Input_ExtraTime.construct('input_extratime','linear',MSG(['parameters','extratime']),0.01,-10,10, MSG(['units','millisecond']));
			window.Input_ExtraTime.show();
		}
		
		// Parité
		window.Select_Parity = new Input_select('Select_Parity', true);
		window.Select_Parity.label_width = HEADING.heading_labels_width;
		window.Select_Parity.margin_left = HEADING.inputs_left_margin;
		window.Select_Parity.construct('select_parity','linear',MSG(['parameters','parity']),array_keys(System_state.ParityList),System_state.ParityList,'',true);
		window.Select_Parity.show();

		// Stopbits
		window.Select_Stopbits = new Input_select('Select_Stopbits', true);
		window.Select_Stopbits.label_width = HEADING.heading_labels_width;
		window.Select_Stopbits.margin_left = HEADING.inputs_left_margin;
		window.Select_Stopbits.construct('select_stopbits','linear',MSG(['parameters','stopbits']),array_keys(System_state.StopbitsList),System_state.StopbitsList,'',true);
		window.Select_Stopbits.show();

		// Level
		window.Select_Level = new Input_select('Select_Level', true);
		window.Select_Level.label_width = HEADING.heading_labels_width;
		window.Select_Level.margin_left = HEADING.inputs_left_margin;
		window.Select_Level.construct('select_level','linear',MSG(['parameters','standard']),array_keys(System_state.LevelList),System_state.LevelList,'',true);
		window.Select_Level.show();

		// Baudrate
		window.Select_Baudrate = new Input_select('Select_Baudrate', true);
		window.Select_Baudrate.label_width = HEADING.heading_labels_width;
		window.Select_Baudrate.margin_left = HEADING.inputs_left_margin;
		window.Select_Baudrate.construct('select_baudrate','linear',MSG(['parameters','baudrate']),array_keys(System_state.BaudrateList),System_state.BaudrateList,'',true);
		window.Select_Baudrate.show();

		// EDIROX (device)
		window.Select_EDIROX = new Input_select('Select_EDIROX', true);
		window.Select_EDIROX.label_width = HEADING.heading_labels_width;
		window.Select_EDIROX.margin_left = HEADING.inputs_left_margin;
		window.Select_EDIROX.construct('select_edirox','linear',MSG(['parameters','physical_link']),array_keys(System_state.EDIROXList),System_state.EDIROXList,'',true);
		window.Select_EDIROX.setAction("HEADING.displaySerialNetworkParams(window.Select_EDIROX.getValue());");
		window.Select_EDIROX.show();

		// ELCFOX (transport)
		window.Select_ELCFOX = new Input_select('Select_ELCFOX', true);
		window.Select_ELCFOX.label_width = HEADING.heading_labels_width;
		window.Select_ELCFOX.margin_left = HEADING.inputs_left_margin;
		window.Select_ELCFOX.construct('select_elcfix','linear',MSG(['parameters','transport_layer']),array_keys(System_state.ELCFOXList),System_state.ELCFOXList,'',true);
		window.Select_ELCFOX.setAction("HEADING.showHideIP();HEADING.setIPaddressRange(window.Select_ELCFOX.getValue());");
		window.Select_ELCFOX.show();

		// Boutons radios pour le choix entre "rate" & "synchroin"
		window.Radio_pulsein0 = new Input_radio('Radio_pulsein0', true);
		window.Radio_pulsein0.margin_left = HEADING.inputs_left_margin_radio;
		window.Radio_pulsein0.construct('radio_pulsein0','pulsein','linear','',0,true);
		window.Radio_pulsein0.setAction("window.Select_pulsein.setValue(0);HEADING.displayFreqPulseIn();", true);
		window.Radio_pulsein0.show();

		window.Radio_pulsein1 = new Input_radio('Radio_pulsein1', true);
		window.Radio_pulsein1.margin_left = HEADING.inputs_left_margin_radio;
		window.Radio_pulsein1.construct('radio_pulsein1','pulsein','linear','',1,true);
		window.Radio_pulsein1.setAction("window.Select_OProRate.setValue(0);HEADING.displayFreqPulseIn();", true);
		window.Radio_pulsein1.show();

        // HB
		if (GIWIK.heart_beat) {

			window.Chkbox_heart_beat = new Input_checkbox('Chkbox_heart_beat', true);
			HEADING._heading_inputs.push('Chkbox_heart_beat');
			window.Chkbox_heart_beat.label_width = HEADING.heading_labels_width;
			window.Chkbox_heart_beat.margin_left = HEADING.inputs_left_margin;
			window.Chkbox_heart_beat.construct('chkbox_heart_beat','linear',MSG(['parameters','heart_beat_label']),[0,1], true);
			window.Chkbox_heart_beat.setAction(HEADING.self+".heart_beat_setting_changed = true;", true);
			window.Chkbox_heart_beat.show();

		}
		// END HB
		// IMO
		if (GIWIK.alarm) {
			// Radio button No Alarm
			window.Input_Alarm0 = new Input_radio('Input_Alarm0', true);
			window.Input_Alarm0.label_width = HEADING.heading_labels_width;
			window.Input_Alarm0.margin_left = HEADING.inputs_left_margin;
			window.Input_Alarm0.construct('input_no_alarm','alarm','linear',MSG(['parameters','no_alarm_label']),0,true);
			window.Input_Alarm0.setAction("window.Input_Alarm0.enable();", true);
			window.Input_Alarm0.show();

			// Radio button ALR Alarm
			window.Input_Alarm1 = new Input_radio('Input_Alarm1', true);
			window.Input_Alarm1.label_width = HEADING.heading_labels_width;
			window.Input_Alarm1.margin_left = HEADING.inputs_left_margin;
			window.Input_Alarm1.construct('input_alr_alarm','alarm','linear',MSG(['parameters','alr_alarm_label']),1,true);
			window.Input_Alarm1.setAction("window.Input_Alarm1.enable();", true);
			window.Input_Alarm1.show();

			// Radio button ALF Alarm
			window.Input_Alarm2 = new Input_radio('Input_Alarm2', true);
			window.Input_Alarm2.label_width = HEADING.heading_labels_width;
			window.Input_Alarm2.margin_left = HEADING.inputs_left_margin;
			window.Input_Alarm2.construct('input_alf_alarm','alarm','linear',MSG(['parameters','alf_alarm_label']),2,true);
			window.Input_Alarm2.setAction("window.Input_Alarm2.enable();", true);
			window.Input_Alarm2.show();
		}
		// END IMO

		for (var i in GIWIK._output_pulse_list)
		{
			window['Select_PULSEOUT_'+i]= new Input_select('Select_PULSEOUT_'+i, true);

			window['Select_PULSEOUT_'+i]= new Input_select('Select_PULSEOUT_'+i, true);
			window['Select_PULSEOUT_'+i].label_width = HEADING.heading_labels_width;
			window['Select_PULSEOUT_'+i].margin_left = HEADING.inputs_left_margin;
			window['Select_PULSEOUT_'+i].construct('select_pulseout'+i,'linear',MSG(['parameters','feature']),array_keys(System_state.OPulseList),System_state.OPulseList,'',true);
			window['Select_PULSEOUT_'+i].setAction('HEADING.updatePulseOut();', true);
			window['Select_PULSEOUT_'+i].show();

			window['Input_PULSEOUT_'+i]= new Input_int('Input_PULSEOUT_'+i, true);
			window['Input_PULSEOUT_'+i].label_width = HEADING.heading_labels_width;
			window['Input_PULSEOUT_'+i].margin_left = HEADING.inputs_left_margin;
			window['Input_PULSEOUT_'+i].construct('input_pulseout'+i,'linear','Parameter',0.01,0.0,1000,'unit');
			window['Input_PULSEOUT_'+i].hide();
		}
	
	}

	

	switch (window.Menu_type.getValue())
	{
		case 'pulses':

			$('#ports')[(HEADING.init.isdone) ? 'slideUp' : 'hide'](200, function ()
			{
				$('#pulses')[(HEADING.init.isdone) ? 'slideDown' : 'show']();
			});

			for (i in GIWIK._output_pulse_list)
			{
				// GIWIK.paramGroup.display('params_pulseout'+i, 'show');
				window['Select_PULSEOUT_'+i].setValue(System_state['PULSEO'+GIWIK._output_pulse_list[i]+'Conf'][0]);
				window['Input_PULSEOUT_' +i].setValue(System_state['PULSEO'+GIWIK._output_pulse_list[i]+'Conf'][1]);
			}

			HEADING.updatePulseOut();
		break;

		case 'ports':

			$('#pulses')[(HEADING.init.isdone) ? 'slideUp' : 'hide'](200, function ()
			{
				$('#ports')[(HEADING.init.isdone) ? 'slideDown' : 'show']();
			});

			// CINT1 or CINT2: BAsed on portcof lenght
			if (System_state["PortConf"+window.current_port].length >= 16)
			{
				window.BoardType = 2;//alert( "CINT2" );
			}
			else
			{
				window.BoardType = 1;//alert( "CINT1" );
			}

			// Définition de l'index du port en cours avec un tableau comprenant "none" comme première entrée (utile pour la gestion des pulses)
			window.current_port_index_nonebased = parseInt(array_search(window.current_port, GIWIK._output_ports)) + 1;


			if( GIWIK.is_gyro == true )
			{
				// Si elle existe : affichage de la librairie UDP chargée pour le port en cours
				window.Text_library.setValue(System_state['UDPConf'+window.current_port]);

				if (System_state['UDPConf'+window.current_port] != ""){
					window.Text_library.show();
				}
				else{
					window.Text_library.hide();
				}

				// Construction de l'adresse de l'action du formulaire
				window.Input_file_udp.setFormAction(GIWIK.cgiuploader+"?udp_port="+window.current_port+"&url="+window.location.protocol+"//"+window.location.host+window.location.pathname);
			}

			var init_value = null;

			// Pulse In (Synchro In)
			window.Select_pulsein.setValue(0);
			for (var i in GIWIK._input_pulse_list)
			{
				var conf_name = "System_state.PULSEI"+GIWIK._input_pulse_list[i]+"Conf[0]";
				var port = parseInt(window.current_port_index_nonebased) + 4;
				if (eval(conf_name) == port)
				{
					var pulse = parseInt(i) + 1;
					window.Select_pulsein.setValue(pulse);
					break;
				}
			}

			// Filtrage Protocols
			HEADING.update_protocols();

			// Protocole
			window.Select_OPro.setValue(System_state["PortConf"+window.current_port][0]);

			// Bras de levier
			window.Select_LevelLva.setValue(System_state["PortConf"+window.current_port][1]);

			if (GIWIK.hrp_output_convention == true)
			{
				// Convention
				window.Select_HRPConvention.setValue(System_state["PortConf"+window.current_port][(window.BoardType==1) ? 12 : 16]);
			}
			
			// Rate du protocole
			window.Select_OProRate.setValue(System_state["PortConf"+window.current_port][2]);

			var init_value;

			// Gestion du cochage des boutons radio (fréquence/entrée synvhro)
			if (window.Select_OProRate.selected_option > 0)
			{
				init_value = 0;
			}
			else if (window.Select_pulsein.selected_option > 0)
			{
				init_value = 1;
			}
			// Par défaut, le menu "rate" est actif
			else
			{
				init_value = 0;
			}

			window.Radio_pulsein0.setValue(init_value, 'no_action');
			window.Radio_pulsein1.setValue(init_value, 'no_action');

			if( GIWIK.is_gyro==true ){

				// ZDA
				window.Checkbox_zda.setValue(System_state['PortConf'+window.current_port][4]); // TO COMPLETE

				// Heave Protocol Filter
				/*window.Checkbox_realtime_heave_filter.setValue(0);//System_state['OProFilter'+window.current_port][0]);
				window.Checkbox_delayed_heave_filter.setValue(0);//System_state['OProFilter'+window.current_port][1]);*/
			}

			if(GIWIK.heave == true)
			{
				// Type de heave avec Select
				//window.Select_Heave.setValue(System_state["PortConf"+window.current_port][3]);

				// Type de Heave avec radio
				for( var i=0; i<count(System_state.HeaveList); i++)
				{
					eval("window.Radio_Heave"+i+".setValue(System_state['PortConf'+window.current_port][3]);");
				}

			}

			// HB
			if (GIWIK.heart_beat)
			{
				window.Chkbox_heart_beat.setValue(System_state["HBConf"+window.current_port][0]);
			}
			// END HB
			// IMO
			if (GIWIK.alarm)
			{
				window.Input_Alarm0.setValue(System_state["AlarmConf"+window.current_port][0], 'no_action');
				window.Input_Alarm1.setValue(System_state["AlarmConf"+window.current_port][0], 'no_action');
				window.Input_Alarm2.setValue(System_state["AlarmConf"+window.current_port][0], 'no_action');
			}
			// END IMO

			// mode d'altitude
			window.Select_AltiRef.setValue(System_state["PortConf"+window.current_port][4]);

			// Parité: CINT1 != CINT2
			window.Select_Parity.setValue(System_state["PortConf"+window.current_port][(window.BoardType==1) ? 7 : 12]);

			// Stopbits: CINT1 != CINT2
			window.Select_Stopbits.setValue(System_state["PortConf"+window.current_port][(window.BoardType==1) ? 8 : 13]);

			// Level
			window.Select_Level.setValue(System_state["PortConf"+window.current_port][9]);

			// Baudrate: CINT1 != CINT2
			window.Select_Baudrate.setValue(System_state["PortConf"+window.current_port][(window.BoardType==1) ? 10 : 15]);

			// extra time
			if( GIWIK.output_extrapolation == true )
			{
				window.Input_ExtraTime.setValue(System_state["PortConf"+window.current_port][11]);
			}
			
			// EDIROX (device)
			// Selection des Links associés à ce port ...
			var Port_Link = GIWIK._output_ports_link[window.current_port_index_nonebased-1];
			var Port_EDIROXList = [];

			for (var i=0; i<Port_Link.length; i++)
			{
				Port_EDIROXList.push(System_state.EDIROXList[Port_Link[i]]);
			}
			// ... et mise à jour du select
			// console.log(Port_Link);
			// console.log(Port_EDIROXList);
			// console.log(window.current_port);
			// console.log(System_state["EthConf"+window.current_port][0]);

			window.Select_EDIROX.setList(Port_Link,Port_EDIROXList);
			window.Select_EDIROX.setValue(System_state["EthConf"+window.current_port][0]);


			// ELCFOX (transport)
			window.Select_ELCFOX.setValue(System_state["EthConf"+window.current_port][1]);

			// Ip //////////////////////////////////////////////////////////////////////////////////
			window._current_port_ip = System_state["EthConf"+window.current_port][2].split('.');

			window.Input_ip_part1.setValue(window._current_port_ip[0]);
			window.Input_ip_part2.setValue(window._current_port_ip[1]);
			window.Input_ip_part3.setValue(window._current_port_ip[2]);
			window.Input_ip_part4.setValue(window._current_port_ip[3]);

			window.Input_ip_port.setValue(System_state["EthConf"+window.current_port][3]);

			// Gestion  UDP Multicast: Limitation Plage Adresse IP 224.XX.XX.XX 239.XX.XX.XX
			HEADING.setIPaddressRange(System_state["EthConf"+window.current_port][1]);

			// Le message doit resté affiché dans les cas suivants :
			// - si serial ou serial + ethernet : on avertit de l'écrasement de la conf en sortie
			// - si le port est configuré en ethernet ET qu'il y a un conflit avec un autre port ethernet (en entrée ou en sortie)
			if (HEADING.init.isdone && !in_array(window.Select_EDIROX.getValue(),[1,3]) && !HEADING.eth_conflict)
			{
				window.Usermsg_update.hide();
			}
			
			
			// Manage display depending on Repeater port
			if( window.current_port == 'R' )
			{
				// Hide
				//HEADING.displaySerialNetworkParams(0);
				// or disable ...
				window.Select_OPro.disable();
				window.Select_LevelLva.disable();
				window.Select_OProRate.disable();
				window.Select_pulsein.disable();
				window.Select_Parity.disable();
				window.Select_Stopbits.disable();
				window.Select_Level.disable();
				window.Select_Baudrate.disable();
				window.Select_EDIROX.disable();
				window.Select_ELCFOX.disable();
				window.Radio_pulsein0.disable();
				window.Radio_pulsein1.disable();
				window.Input_ip_part1.disable();
				window.Input_ip_part2.disable();
				window.Input_ip_part3.disable();
				window.Input_ip_part4.disable();
				window.Input_ip_port.disable();
				
				if( GIWIK.output_extrapolation == true ){
					window.Input_ExtraTime.hide();
				}
				window.Select_AltiRef.hide();
			}
			else
			{			
				// Show
				//HEADING.displaySerialNetworkParams(0);
				// or enable ...
				window.Select_OPro.enable();
				window.Select_LevelLva.enable();
				window.Select_OProRate.enable();
				window.Select_pulsein.enable();
				window.Select_Parity.enable();
				window.Select_Stopbits.enable();
				window.Select_Level.enable();
				window.Select_Baudrate.enable();
				window.Select_EDIROX.enable();
				window.Select_ELCFOX.enable();
				window.Radio_pulsein0.enable();
				window.Radio_pulsein1.enable();
				window.Input_ip_part1.enable();
				window.Input_ip_part2.enable();
				window.Input_ip_part3.enable();
				window.Input_ip_part4.enable();
				window.Input_ip_port.enable();
				
				// extra time
				if( GIWIK.output_extrapolation == true ){
					window.Input_ExtraTime.show();
				}
				window.Select_AltiRef[(GIWIK.alti_depth) ? 'show' : 'hide']();
			}

		break;
	}
		
	
	// emission dans un second temps de la requete pour récupérer les datablocks disponible du protocole selectionne
	HEADING.getProtoDataBlock();
	
};

HEADING.getConf.local = function ()
{
	var _params = {};

	if (!HEADING.init.isdone)
	{
		_params['AltiRefList'] = "";
		_params['OProList'] = "";
		_params['LevelLvaList'] = "";
		_params['HeaveList'] = "";
		_params['EDIROXList'] = "";
		_params['ParityList'] = "";
		_params['StopbitsList'] = "";
		_params['LevelList'] = "";
		_params['BaudrateList'] = "";
		_params['ELCFOXList'] = "";
		_params['OPulseList'] = "";
		_params['OPulseParamType'] = "";
		if (GIWIK.hrp_output_convention == true){
			_params['HRPConvList'] = "";
		}

		if( GIWIK.is_gyro == true ){
			_params['OProNum_RealTimeHeave'] = "";
			_params['OProNum_DelayedHeave'] = "";
		}
	}

	if (window.Menu_type.getValue() != 'pulses')
	{
		_params['EthConf'+window.current_port] = "";
		_params['PortConf'+window.current_port] = "";

		if( GIWIK.is_gyro==true){
			_params['UDPConf'+window.current_port] = "";
			//_params['OProFilter'+window.current_port] = "";
		}
		// HB
		if (GIWIK.heart_beat)
		{
			_params['HBConf'+window.current_port] = "";
		}
		// END HB
		// IMO
		if (GIWIK.alarm)
		{
			_params['AlarmConf'+window.current_port] = "";
		}
		// END IMO
	}

	for (i in GIWIK._input_pulse_list)
	{
		_params['PULSEI' + GIWIK._input_pulse_list[i] + 'Conf'] = "";
	}

	for (i in GIWIK._output_pulse_list)
	{
		_params['PULSEO' + GIWIK._output_pulse_list[i] + 'Conf'] = "";
	}

	// Récupération de la configuration d'entrée/sortie complète
	_params = array_merge(_params, HEADING.getIOConfParams());

	return _params;
};

HEADING.sendConf.local = function ()
{
	var _params = {};

	// Masquage message Utilisateur
	// window.Usermsg_update.hide();  // Inutile, méthode appelée au readConf

	if (window.Menu_type.getValue() == 'pulses')
	{
		for (i in GIWIK._output_pulse_list)
		{
			var value1, value2, value;
			value1 = window['Select_PULSEOUT_'+i].getValue();
			value2 = window['Input_PULSEOUT_' +i].getValue();
			value  = value1 + "," + value2;

			_params['PULSEO'+GIWIK._output_pulse_list[i]+'Conf'] = value;
		}
	}
	else
	{
		/*
		if (GIWIK.is_gyro==true)
		{
			// UDP : Si "From library" est sélectionné dans le select protocol ET
					// - qu'un fichier est envoyé (qu'une librairie soit déjà chargée ou non)
					// - OU qu'aucun fichier n'est envoyé alors qu'aucune librairie n'est chargée
			// --> on programme l'envoi du fichier dans 1000ms
			if ( window.Select_OPro.getValueLabel().toLowerCase().indexOf('library')>=0 && (window.Input_file_udp.getValue() != "" || (window.Input_file_udp.getValue() == "" && System_state['UDPConf'+window.current_port] == "")))
			{
				window.Statuschevron.setStatus(10);
				HEADING.setSettingsActivity('disable');
				setTimeout("document."+window.Input_file_udp.form_name+".submit();", 1000);
			}
		}*/


		if (GIWIK.is_gyro==true)
		{
			// User Define Protocol processing :
			// ---------------------------------
			// if "From the library" is selected
			if ( window.Select_OPro.getValueLabel().toLowerCase().indexOf('library')>=0)
			{
				if (window.Input_file_udp.getValue() != "") // if a UDP file is selected in the library
				{
					//console.log("UDP File selected = "+window.Input_file_udp.getValue());
					window.Statuschevron.setStatus(10);
					HEADING.setSettingsActivity('disable');
					// send it 500 ms after
					setTimeout("document."+window.Input_file_udp.form_name+".submit();", 500);
					// and store its name
					STORAGE.setPermanent('last_udp_file_selected', window.Input_file_udp.getValue()) ;
				}
				else if (STORAGE.get('last_udp_file_selected') != undefined)  // if no UDP file selected but already one has been selected
				{
					//console.log("Last selected UDP File = "+STORAGE.get('last_udp_file_selected'));
					window.Input_file_udp.setValue(STORAGE.get('last_udp_file_selected'));
					window.Statuschevron.setStatus(10);
					HEADING.setSettingsActivity('disable');
					// send it 500 ms after
					setTimeout("document."+window.Input_file_udp.form_name+".submit();", 500);
				}
			}
		}

		// construction de l'adresse IP
		var ip_address = window.Input_ip_part1.getValue()+"."+window.Input_ip_part2.getValue()+"."+window.Input_ip_part3.getValue()+"."+window.Input_ip_part4.getValue();


		// Gestion des conflits ethernet --------------------------------------------------------------------
		HEADING.eth_conflict = false;

		// Si la sortie courante est configurée en ethernet (ou serial + ethernet)
		if (in_array(window.Select_EDIROX.getValue(),[2,3]))
		{
			// Vérification de la validité de la configuration Ethernet
			HEADING.eth_conflict = !HEADING.checkEthConf(
				window.current_port,
				'output',
				{
					'tlayer' : window.Select_ELCFOX.getValue(),
					'ip'     : ip_address,
					'port'   : window.Input_ip_port.getValue()
				},
				'Usermsg_update');
		}

		if (HEADING.eth_conflict) {return false;}
		//---------------------------------------------------------------------------------------------------


		// gestion des pulses out ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		var message_warning="";

		// Pulse In (Synchro In)
		for (var i in GIWIK._input_pulse_list)
		{
			var pulse_conf_param = "PULSEI" + GIWIK._input_pulse_list[i] + "Conf";
			var pulse_conf_old = "System_state."+pulse_conf_param+"[0]";
			var sel_pulse;

			if (i == window.Select_pulsein.selected_option -1)
			{
				if (eval(pulse_conf_old) != parseInt(window.current_port_index_nonebased) + 4)
				{
					// Configuration du pulse sélectionné
					var port = parseInt(window.current_port_index_nonebased) + 4;
					_params[pulse_conf_param] =  port + ",0";

					if (eval(pulse_conf_old) > 0)
					{
						if (eval(pulse_conf_old) < 5)
						{
							message_warning += (message_warning=="") ? "" : "<br/>";
							message_warning += MSG(['iostatuscodes','1001'/*UTC_PULSIN_OVERW'*/]);
						}
						else if (eval(pulse_conf_old) >=5 && eval(pulse_conf_old) <10)
						{
							var port = eval(pulse_conf_old);
							port = port - 5;

							message_warning += (message_warning=="") ? "" : "<br/>";
							message_warning += MSG(['iostatuscodes','1003'/*PORT_PULSIN_OVERW'*/]);
							message_warning  = message_warning.replace(/%X%/, GIWIK._output_ports[port]);
						}
						else if (eval(pulse_conf_old) <14)
						{
							message_warning += (message_warning=="") ? "" : "<br/>";
							message_warning += MSG(['iostatuscodes','1007'/*PORT_PULSIN_OVERW'*/]);
							message_warning  = message_warning.replace(/%X%/, GIWIK._input_pulse_list[i]);
						}
						else
						{
							message_warning += (message_warning=="") ? "" : "<br/>";
							message_warning += MSG(['iostatuscodes','1009'/*PORT_PULSIN_OVERW'*/]);
							message_warning  = message_warning.replace(/%X%/, GIWIK._input_pulse_list[i]);
						}


					}
				}
			}
			else
			{
				// Déconfiguration de l'ancien pulse si besoin
				if (eval(pulse_conf_old) == parseInt(window.current_port_index_nonebased) + 4)
				{
					// Le pulse était configuré sur ce port => on le désactive
					_params[pulse_conf_param] = "0,0";
				}
			}
		}

		// Heave Protocols filtering
		/*if( GIWIK.is_gyro == true )
		{
			_params['OProFilter'+window.current_port]=window.Checkbox_realtime_heave_filter.getValue() + "," + window.Checkbox_delayed_heave_filter.getValue();
		}*/

		//  Check si Conf Série a changé
		// --------------------------------------
		if( window.BoardType !== 2 && 				// CINT2 non concernée
			GIWIK.same_in_out_serial_conf !== 0 &&   // Same conf for Input/output
		  ((System_state['PortConf'+window.current_port][7] != window.Select_Parity.getValue()) ||
		  (System_state['PortConf'+window.current_port][8] != window.Select_Stopbits.getValue()) ||
		  (System_state['PortConf'+window.current_port][9] != window.Select_Level.getValue()) ||
		  (System_state['PortConf'+window.current_port][10] != window.Select_Baudrate.getValue())))
		{
			message_warning += (message_warning=="") ? "" : "<br/>";
			message_warning += MSG(['iostatuscodes','1005'/*PORT_RSIN_OVERW'*/]);
			message_warning  = message_warning.replace(/%X%/, GIWIK._output_ports[window.current_port_index_nonebased-1]);
		}

		// Message Alerte en cas d'ecrasement de la config Pulses et Port Serie
		// ----------------------------------------------------------------------------------------
		if (message_warning != "")
		{
			// Affichage Message Utilisateur
			window.Usermsg_update.setStatus(2);
			window.Usermsg_update.setValue(message_warning);
			window.Usermsg_update.show();
		}


		// Requete ...
		if( window.BoardType == 1 ){
			_params['PortConf'+window.current_port] =
					window.Select_OPro.getValue()+","+window.Select_LevelLva.getValue()+','+
					window.Select_OProRate.getValue()+','+
					((GIWIK.heave==true) ? window.Radio_Heave0.getValue() : 0) /*window.Select_Heave.getValue()*/+','+
					((GIWIK.is_gyro==true ) ? window.Checkbox_zda.getValue() : window.Select_AltiRef.getValue()) +","+
					System_state['PortConf'+window.current_port][5]+","+
					System_state['PortConf'+window.current_port][6]+","+
					window.Select_Parity.getValue()+","+		// I/O value
					window.Select_Stopbits.getValue()+","+		// I/O value
					window.Select_Level.getValue()+","+			// I/O value
					window.Select_Baudrate.getValue()+","+		// I/O value
					(( GIWIK.output_extrapolation == true ) ? window.Input_ExtraTime.getValue() : 0 ) +","+		
					((GIWIK.hrp_output_convention == true) ? window.Select_HRPConvention.getValue() : "0");			
		}
		else
		{
			_params['PortConf'+window.current_port] =
					window.Select_OPro.getValue()+","+window.Select_LevelLva.getValue()+','+
					window.Select_OProRate.getValue()+','+
					((GIWIK.heave==true) ? window.Radio_Heave0.getValue() : 0) /*window.Select_Heave.getValue()*/+','+
					((GIWIK.is_gyro==true ) ? window.Checkbox_zda.getValue() : window.Select_AltiRef.getValue()) +","+
					System_state['PortConf'+window.current_port][5]+","+
					System_state['PortConf'+window.current_port][6]+","+
					System_state['PortConf'+window.current_port][7]+","+		// I value
					System_state['PortConf'+window.current_port][8]+","+		// I value
					window.Select_Level.getValue()+","+							// I/O value
					System_state['PortConf'+window.current_port][10]+","+		// I value
					(( GIWIK.output_extrapolation == true ) ? window.Input_ExtraTime.getValue() : 0 ) +","+				
					window.Select_Parity.getValue()+","+		// O value
					window.Select_Stopbits.getValue()+","+		// O value
					window.Select_Level.getValue()+","+			// RFU
					window.Select_Baudrate.getValue()+","+		// O value
					((GIWIK.hrp_output_convention == true) ? window.Select_HRPConvention.getValue() : "0");		
		}

		_params['EthConf'+window.current_port] =
				window.Select_EDIROX.getValue()+","+
				window.Select_ELCFOX.getValue()+","+
				ip_address+","+
				window.Input_ip_port.getValue();
		// HB
        if (GIWIK.heart_beat)
		{
			_params['HBConf'+window.current_port] =
					window.Chkbox_heart_beat.getValue();
		}
		// END HB
		// IMO
		if (GIWIK.alarm)
		{
			_params['AlarmConf'+window.current_port] = window.Input_Alarm2.getValue();
		}
		// END IMO

		if(GIWIK.ProtoListDataBlock){
			var ProtoListBlockConf_tmp = '';
			var j=0;

			for (i=0; i< (System_state['ProtoListBlockConf'+window.current_port].length)/2; i++)
			{
				var state = in_array(System_state['ProtoListBlockConf'+window.current_port][i*2].split("_").join(" ") , $('.select2_datablocks').val()) ? 1 : 0;
				
				ProtoListBlockConf_tmp += (System_state['ProtoListBlockConf'+window.current_port][i*2] + ',' + state);
				
				if(i < ((System_state['ProtoListBlockConf'+window.current_port].length)/2-1))
					ProtoListBlockConf_tmp += ',';
			}
			
			if(ProtoListBlockConf_tmp != '')
				_params['ProtoListBlockConf'+window.current_port] = ProtoListBlockConf_tmp;
		}
	}

	return _params;
};

HEADING.construct.local = function ()
{
	var cnt = ''

	+'<div id="usermsg_update"></div>'

	+'<div id="menu_type" align="center"></div>'

	+'<div id="ports" style="display:none">'
		+'<hr id="main_separator" class="separator1" />'
		+'<div id="menu_port" align="center"></div>'

		+'<div id="params_protocol">'
			+'<div id="select_opro"></div>'
			+'<div id="udp_settings">'
				+'<div id="text_library"></div>'
				+'<div id="file_upload"></div>'
			+'</div>'
			+'<div id="select_levellva"></div>'
			+'<table><tr>'
				+'<td><div id="radio_pulsein0"></div></td>'
				+'<td><div id="select_oprorate"></div></td>'
			+'</tr></table>'
			+'<table><tr>'
				+'<td><div id="radio_pulsein1"></div></td>'
				+'<td><div id="select_pulsein"></div></td>'
			+'</tr></table>'
		+'</div>'
		+'<div id="params_heave">'
			+'<div id="select_heave"></div>'
			+'<div id="radio_heave0"></div>'
			+'<div id="radio_heave1"></div>'
			+'<div id="radio_heave2"></div>'
			+'<div id="radio_heave3"></div>'
		+'</div>'
		/*+'<div id="params_protocol_filter">'
			+'<div id="checkbox_realtime_heave_filter"></div>'
			+'<div id="checkbox_delayed_heave_filter"></div>'
		+'</div>'*/
		+'<div id="params_device">'
			+'<div id="select_edirox"></div>'
		+'</div>'

		+'<div id="params_serial">'
			+'<div id="serial_status"></div>'
			+'<div id="select_parity"></div>'
			+'<div id="select_stopbits"></div>'
			+'<div id="select_level"></div>'
			+'<div id="select_baudrate"></div>'
		+'</div>'

		+'<div id="params_ethernet">'
			+'<div id="select_elcfix"></div>'
			+'<div id="ip_ctnr">\n'
				+'<table>\n'
					+'<tr>\n'
						+'<td><div id="input_ip_part1"></div></td>\n'
						+'<td class="param_ipdot">&bull;</td>\n'
						+'<td><div id="input_ip_part2"></div></td>\n'
						+'<td class="param_ipdot">&bull;</td>\n'
						+'<td><div id="input_ip_part3"></div></td>\n'
						+'<td class="param_ipdot">&bull;</td>\n'
						+'<td><div id="input_ip_part4"></div></td>\n'
					+'</tr>\n'
				+'</table>\n'
			+'</div>\n'
			+'<div id="input_ip_port"></div>'
		+'</div>'

		+'<div id="params_advancedsettings">'
			+'<div id="checkbox_zda"></div>'
			+'<div id="select_altiref"></div>'
			+'<div id="select_HRPconv"></div>'
			+'<div id="input_extratime"></div>'
		+'</div>';
	//HB
	if (GIWIK.heart_beat)
	{
		cnt+='<div id="params_heart_beat">'
			+'<div id="chkbox_heart_beat"></div>'
		+'</div>';
	}
	// END HB
	// IMO
	if (GIWIK.alarm)
	{
		cnt+='<div id="params_alarm">'
			+'<div id="input_no_alarm"></div>'
			+'<div id="input_alr_alarm"></div>'
			+'<div id="input_alf_alarm"></div>'
		+'</div>';
	}
	// END IMO
	cnt+='</div>';

	cnt+='<div id="pulses" style="display:none">';
	for (var i in GIWIK._output_pulse_list)
	{
		cnt += ''
		+'<div id="params_pulseout'+i+'">'
			+'<div id="select_pulseout'+i+'"></div>'
			+'<div id="input_pulseout'+i+'"></div>'
		+'</div>';
	}
	cnt +='</div>'

	$('#content').append(GIWIK.box(cnt, MSG(['box','output_title']), true));

	cnt = null;


	// Construction des groupes de paramètres
	/*if( GIWIK.is_gyro == true ){
		GIWIK.paramGroup.construct('params_protocol_filter', MSG(['box','params_protocol_filter']), 'show');
	}*/
	GIWIK.paramGroup.construct('params_protocol', MSG(['box','params_protocol']), 'show');
	if(GIWIK.heave == true ){
		GIWIK.paramGroup.construct('params_heave', MSG(['box','params_heave']), 'show');
	}
	GIWIK.paramGroup.construct('params_device', MSG(['box','params_device']), 'show');
	GIWIK.paramGroup.construct('params_serial',MSG(['box','params_serial']), 'show');				// L'affichage des paramètres dépend du type de lien choisi (série/éthernet)
	GIWIK.paramGroup.construct('params_ethernet',MSG(['box','params_ethernet']), 'show');			// L'affichage des paramètres dépend du type de lien choisi (série/éthernet)
	GIWIK.paramGroup.construct('params_advancedsettings', MSG(['box','params_advancedsettings']), 'show');
	
	for (var i in GIWIK._output_pulse_list)
	{
		GIWIK.paramGroup.construct('params_pulseout'+i, MSG(['box','params_pulseout'])+' '+GIWIK._output_pulse_list[i], 'show');
	}

	// HB
	if (GIWIK.heart_beat){
		GIWIK.paramGroup.construct('params_heart_beat', MSG(['box','params_heart_beat']), 'hide');
	}
	// END HB
	// IMO
	if (GIWIK.alarm){
		GIWIK.paramGroup.construct('params_alarm', MSG(['box','params_alarm']), 'hide');
	}
	// END IMO

	HEADING.inputs_left_margin = 90;	   // marge gauche des inputs
	HEADING.inputs_left_margin_radio = HEADING.inputs_left_margin - 20;	// marge gauche des radios
	HEADING.heading_labels_width = 75; 	// largeur des labels des paramètres de la page
	HEADING.ip_input_width = 36; 		// largeur des champs des paramètres de la page

	window.current_port = (window._GET['port'] && in_array(window._GET['port'], GIWIK._output_ports)) ? window._GET['port'] : GIWIK._output_ports[0];

	/*window.heading_labels_width = 70; 	// Définit la largeur des labels des paramètres de la page
	window.ip_input_width = 36; 		// Définit la largeur des champs des paramètres de la page*/

	var _available_ports_labels = new Array();
	var _available_ports_index = new Array();
	var port_label = MSG(['parameters','output']);
	var pulse_label = MSG(['parameters','pulse']);

	for (var tab_index in GIWIK._output_ports)
	{
		if (GIWIK._output_ports[tab_index] == 'R' )
		{
			_available_ports_labels.push(MSG(['parameters','repeater']));
		}
		else
		{
			_available_ports_labels.push(port_label+' '+GIWIK._output_ports[tab_index]);
		}	
		_available_ports_index.push(GIWIK._output_ports[tab_index]);
	}

	// Menu de sélection ports/pulses
	var Menu_tabs = new Array();
	var Menu_labels = new Array();

	if( GIWIK._output_ports.length != 0)
	{
		Menu_tabs.push('ports');
		Menu_labels.push(MSG(['parameters','ports']));
	}

	if( GIWIK._output_pulse_list.length != 0)
	{
		Menu_tabs.push('pulses');
		Menu_labels.push(MSG(['parameters','output_pulses']));
	}


	window.Menu_type = new Menu('Menu_type', true);
	window.Menu_type.construct('menu_type','horizontal', Menu_tabs/*['ports', 'pulses']*/, Menu_labels/* [MSG(['parameters','ports']), MSG(['parameters','pulses'])]*/,false);
	window.Menu_type.resize(150);
	window.Menu_type.setValue('ports');
	window.Menu_type.setAction("window.Usermsg_update.hide();HEADING.getConf();");
	window.Menu_type.show();

	// Par défaut on arrive sur la partie ports
	window.Menu_type.setValue('ports','no_action');	// no_action ici parce que getConf va automatiquement être appelé après la fonction "construct"



	// Menu de sélection du port
	window.Menu_port = new Menu('Menu_port', true);
	window.Menu_port.num_item_per_row = count(GIWIK._output_ports);
	window.Menu_port.construct('menu_port','horizontal',_available_ports_index,_available_ports_labels,false);
	window.Menu_port.setValue(window.current_port);
	window.Menu_port.setAction("window.Usermsg_update.hide();window.current_port=window.Menu_port.getValue();HEADING.getConf();");
	window.Menu_port.show();



	// Gestion du message utilisateur
	var upload_msg = null;

	window.Usermsg_update = new User_msg('Usermsg_update', true); // Instanciation du message utilisateur
	window.Usermsg_update.construct('usermsg_update',3,"");
	window.Usermsg_update.hide();

	// Si aucun port n'est spécifié en GET ou qu'un port est spécifié et que c'est le port courant
	if (!window._GET['port'] || (window._GET['port'] && window._GET['port'] == window.current_port))
	{
		if (window._GET['error'] && window._GET['error'].match(/^[0-9]+$/gi))
		{
			var upload_code = window._GET['error'];

			if (MSG['updatestatuscodes'][upload_code])
			{
				window.Usermsg_update.construct('usermsg_update', MSG.defineState(upload_code), MSG(['updatestatuscodes',upload_code]));
				window.Usermsg_update.show();
			}
		}
		else if (window._GET['type'])
		{
			var upload_type = window._GET['type'];

			var filename = (window._GET['name'] && window._GET['name'] != '') ? window._GET['name'] : '';

			var msg_ = MSG(['updatestatuscodes','100']);
			if (filename != ''){msg_ += "<br/><i>("+filename+")</i>";}

			switch (upload_type)
			{
				case 'UDP':
					window.Usermsg_update.construct('usermsg_update', 1, msg_);
					window.Usermsg_update.show();
					break;
			}
		}
	}


	if ( GIWIK.is_gyro == true )
	{
		// Bibliothèque UDP
		window.Text_library = new Input_text('Text_library', true);
		window.Text_library.label_width = HEADING.heading_labels_width;
		window.Text_library.input_width = 250;
		window.Text_library.margin_left = HEADING.inputs_left_margin;
		window.Text_library.border_input = '1px solid';
		window.Text_library.readonly = true;
		window.Text_library.text_align = 'left';
		window.Text_library.construct('text_library','linear',MSG(['parameters','library']),'',false);
		window.Text_library.enable();
		window.Text_library.show();

		// Input File UDP
		window.Input_file_udp = new Input_file('Input_file_udp', true);
		window.Input_file_udp.label_width = HEADING.heading_labels_width+7;
		window.Input_file_udp.margin_left = HEADING.inputs_left_margin;
		window.Input_file_udp.construct('file_upload',MSG(['parameters','file']),{form_name:'form_upload',form_action:'',input_name:'Filedata'},true);
		window.Input_file_udp.setValue();
		window.Input_file_udp.show();

		$('#udp_settings').css('display', 'none');
	}


	// Filedata + size=16

	// Paramètre "IP" (l'ip est constituée de 4 Input_int)
	var ip_min  = 0;
	var ip_max  = 255;
	var ip_step = 1;
	//----------------------
	window.Input_ip_part1 = new Input_int('Input_ip_part1', true);
	window.Input_ip_part1.label_width = HEADING.heading_labels_width;
	window.Input_ip_part1.input_width = HEADING.ip_input_width;
	window.Input_ip_part1.margin_left = HEADING.inputs_left_margin;
	window.Input_ip_part1.construct('input_ip_part1','linear',MSG(['parameters','ip']),ip_step,ip_min,ip_max,'');
	window.Input_ip_part1.show();

	window.Input_ip_part2 = new Input_int('Input_ip_part2', true);
	window.Input_ip_part2.input_width = HEADING.ip_input_width;
	window.Input_ip_part2.construct('input_ip_part2','linear','',ip_step,ip_min,ip_max,'');
	window.Input_ip_part2.show();

	window.Input_ip_part3 = new Input_int('Input_ip_part3', true);
	window.Input_ip_part3.input_width = HEADING.ip_input_width;
	window.Input_ip_part3.construct('input_ip_part3','linear','',ip_step,ip_min,ip_max,'');
	window.Input_ip_part3.show();

	window.Input_ip_part4 = new Input_int('Input_ip_part4', true);
	window.Input_ip_part4.input_width = HEADING.ip_input_width;
	window.Input_ip_part4.construct('input_ip_part4','linear','',ip_step,ip_min,ip_max,'');
	window.Input_ip_part4.show();

	// Paramètre "Port ip"
	var ip_port_min  = 1;
	var ip_port_max  = 65535;
	var ip_port_step = 1;
	//----------------------
	window.Input_ip_port = new Input_int('Input_ip_port', true);
	window.Input_ip_port.label_width = HEADING.heading_labels_width;
	window.Input_ip_port.input_width = 60;
	window.Input_ip_port.margin_left = HEADING.inputs_left_margin;
	window.Input_ip_port.construct('input_ip_port','linear',MSG(['parameters','ipport']),ip_port_step,ip_port_min,ip_port_max,'');
	window.Input_ip_port.show();

	// Message Utilisteur
	window.Usermsg_update = new User_msg('Usermsg_update', true); // Instanciation du message utilisateur
	window.Usermsg_update.margin = '-10px 0 15px 0';
	window.Usermsg_update.construct('usermsg_update',3,"");
	window.Usermsg_update.hide();

	// Statut sortie serie (full)
	window.Serial_status = new User_msg('Serial_status', false);
	window.Serial_status.margin = "10px 0 5px 0";
	window.Serial_status.construct('serial_status', 0, "");
	window.Serial_status.hide();
};


HEADING.getProtoDataBlock = function ()
{
	if(GIWIK.ProtoListDataBlock)
	{
		//suppression des balise HTML
		$( "div" ).remove( "#datablock_param" );
		
		//construction de la requete pour récupérer la liste des datablocks du protocole selectionné
		var request = GIWIK.cgifile+"?mode=3"+"&ProtoListBlockConf" + window.current_port + "=" + window.Select_OPro.getValue();

		//callback pour contruire la rubrique gérant les datablocks
		GIWIK.ajax(request, {
			eval_rtxt : true,
			replace_standard_callback : function(){	
				HEADING.constructDataBlock();
			}
		});
	}
}

//construction des objets de selection des datablocks
HEADING.constructDataBlock = function()
{	
	if(	(!window.Select_OPro.getValueLabel().match("NONE")) && 			/*si un protocole est selectionné*/
		(System_state['ProtoListBlockConf'+window.current_port] != '') &&	/*et que la reponse de l'embarqué n'est pas vide*/
		($("#datablock_param").length == 0))
	{
		
		//construction des balises HTML
		$('#params_protocol').after
		(
			'<div id="datablock_param">'
				+'<div id="buttons_datablocks_sel" align="center">'
					+'<table>'
						+'<tr>'				
							+'<td><div id="button_datablocks_sel_all"></div></td>'
							+'<td><div id="button_datablocks_sel_none"></div></td>'
						+'</tr>'
					+'</table>'
				+'</div>'			
				+'<select class="select2_datablocks" multiple="multiple" tabindex=-1></select>'
			+'</div>'
		);

		
		HEADING.tab_dataBlockName = new Array();
		var tab_dataBlockSelect = new Array();
		var tab_dataBlockSelected = new Array();
		
		//extraction sous forme de tableau des états ainsi que des noms des datablocks
		for (var i=0; i < (System_state['ProtoListBlockConf'+window.current_port].length)/2; i++)
		{
			HEADING.tab_dataBlockName[i] = System_state['ProtoListBlockConf'+window.current_port][i*2].replace(/_/g, ' ');
			tab_dataBlockSelect[i] = System_state['ProtoListBlockConf'+window.current_port][(i*2)+1];

			if(tab_dataBlockSelect[i] === 1)
			{			
				tab_dataBlockSelected.push(HEADING.tab_dataBlockName[i]);
			}			
		}
		
		//range par ordre alphabetique les datablocks
		HEADING.tab_dataBlockName = HEADING.tab_dataBlockName.sort();
		
		//remplissage du select
		for(var id_datablock in HEADING.tab_dataBlockName)
		{
			$('.select2_datablocks').append(
				'<option value="' + HEADING.tab_dataBlockName[id_datablock] + '" style="padding-left: 4px; text-align: left; color: rgb(0, 81, 146);">' + HEADING.tab_dataBlockName[id_datablock] + '</option>'
			);
		}
		
		//activation des datablocks selsectionnés
		$('.select2_datablocks').val(tab_dataBlockSelected.sort()).select2({placeholder:MSG(['parameters','datablocks_placeholder']), closeOnSelect: false});

		
		$('.select2_datablocks').on('change',function(){
			//pour mettre à jour l'état des boutons OK et Cancel lors d'interactions avec les datablocks		
			window.settings_modified = true;
		});
		
		//paramètre de la zone de selection
		$('.select2-selection--multiple').css({'overflow-y':'auto', 'max-height':'290px', 'width':'438px'});
		//largeur du menu déroulant
		$('.select2-container--default').attr('style', 'width:100%');
		//largeur du placeholder
		$('.select2-search__field').attr('style', 'width:438px');
			
		
		GIWIK.paramGroup.construct('datablock_param', MSG(['box','params_datablock']), 'show');

		var options = {};
		options.type = "flat";		
		var sel_datablock_button_width = 140;
		var sel_datablock_button_height = 50;
		var sel_datablock_button_font = 'bold 13px Arial';
		
		window.Button_DataBlock_Sel_All = new Button('Button_DataBlock_Sel_All', false, options);
		window.Button_DataBlock_Sel_All.width = sel_datablock_button_width;
		window.Button_DataBlock_Sel_All.height = sel_datablock_button_height;
		window.Button_DataBlock_Sel_All.construct('button_datablocks_sel_all',MSG(['parameters','select_all_datablocks']),"mini");
		window.Button_DataBlock_Sel_All.resize("mini",sel_datablock_button_width, sel_datablock_button_height, sel_datablock_button_font);
		window.Button_DataBlock_Sel_All.setAction('HEADING.selectAllDataBlock();');

		window.Button_DataBlock_Sel_All.show();
		window.Button_DataBlock_Sel_All.enable();
		$('#button_datablocks_sel_all').css('margin', '5px');
		
		window.Button_DataBlock_Sel_None = new Button('Button_DataBlock_Sel_None', false, options);
		window.Button_DataBlock_Sel_None.width = sel_datablock_button_width;
		window.Button_DataBlock_Sel_None.height = sel_datablock_button_height;
		window.Button_DataBlock_Sel_None.construct('button_datablocks_sel_none',MSG(['parameters','unselect_all_datablocks']),"mini");		
		window.Button_DataBlock_Sel_None.resize("mini",sel_datablock_button_width, sel_datablock_button_height, sel_datablock_button_font);		
		window.Button_DataBlock_Sel_None.setAction('HEADING.unSelectAllDataBlock();');
		window.Button_DataBlock_Sel_None.show();
		window.Button_DataBlock_Sel_None.enable();	
	}
	
	//active tous les datablocks
	HEADING.selectAllDataBlock = function()
	{
		$('.select2_datablocks').val(HEADING.tab_dataBlockName).trigger("change");
	}
	
	//désactive tous les datablocks
	HEADING.unSelectAllDataBlock = function()
	{
		$('.select2_datablocks').val(null).trigger("change");
	}
}