GIWIK.init.js(['css','msg']);

HEADING.selectDVL = function ()
{
	// Set Current Dvl calibrated
	window.Calibrated_DVL_Id = window.Select_sensor_id.getValue();

	// Indicate that DVL Id has changed
	GIWIK.ajax(GIWIK.cgifile+"?mode=3&DDRECK=0,"+window.Calibrated_DVL_Id );

	// Update Calibration values according to DVL
	eval( "window.Input_mis_roll.setValue(System_state."+(window.Calibrated_DVL_Id==2 ? "DVL2CAL" : "DVLCAL") +"[0]);");
	eval( "window.Input_mis_pitch.setValue(System_state."+(window.Calibrated_DVL_Id==2 ? "DVL2CAL" : "DVLCAL") +"[1]);");
	eval( "window.Input_mis_heading.setValue(System_state."+(window.Calibrated_DVL_Id==2 ? "DVL2CAL" : "DVLCAL") +"[2]);");
	eval( "window.Input_mis_scale.setValue(System_state."+(window.Calibrated_DVL_Id==2 ? "DVL2CAL" : "DVLCAL") +"[3]);");

	// Ask for embedded parameters
	HEADING.getConf.local();
};

HEADING.updateCalibration = function ()
{
	GIWIK.ajax(GIWIK.cgifile+"?mode=3&DDRECK");
};

HEADING.startCalibration = function ()
{
	window.Select_sensor_id.disable();
	window.Start_calibration.disable();
	window.Stop_calibration.disable();
	window.Start_calchk.disable();
	window.Stop_calchk.disable();
	HEADING.disableValidation();
	GIWIK.ajax(GIWIK.cgifile+"?mode=4&DDRECK=1,"+window.Calibrated_DVL_Id);
};

HEADING.stopCalibration = function ()
{
	window.Select_sensor_id.disable();
	window.Start_calibration.disable();
	window.Stop_calibration.disable();
	window.Start_calchk.disable();
	window.Stop_calchk.disable();
	GIWIK.ajax(GIWIK.cgifile+"?mode=4&DDRECK=2,"+window.Calibrated_DVL_Id);

};

HEADING.cancelCalibration = function ()
{
	HEADING.disableValidation();
	GIWIK.ajax(GIWIK.cgifile+"?mode=4&DDRECK=0,"+window.Calibrated_DVL_Id);
};

HEADING.enableValidation = function ()
{
	if (HEADING.init.isdone) 
	{
		if(GIWIK.use_odocal_as_syst_mesa===true){
			window.Btn_useAsSystemMisalignments.enable();
		}
	}
};

HEADING.disableValidation = function ()
{
	if (HEADING.init.isdone) 
	{
		if(GIWIK.use_odocal_as_syst_mesa===true){
			window.Btn_useAsSystemMisalignments.disable();
		}
	}
};


HEADING.updateCalChk = function ()
{
	window.Text_calchk_distance.setValue(System_state.CALCHK[1]) ;
	window.Text_calchk_hdrift.setValue(System_state.CALCHK[2]) ;
	window.Text_calchk_vdrift.setValue(System_state.CALCHK[3]) ;
	window.Text_calchk_herrorpc.setValue(System_state.CALCHK[4]) ;
	window.Text_calchk_verrorpc.setValue(System_state.CALCHK[5]) ;
	GIWIK.ajax(GIWIK.cgifile+"?mode=3&CALCHK");
};

HEADING.startCalChk = function ()
{
	window.Select_sensor_id.disable();
	window.Start_calibration.disable();
	window.Stop_calibration.disable();
	window.Start_calchk.disable();
	window.Stop_calchk.disable();
	GIWIK.ajax(GIWIK.cgifile+"?mode=4&CALCHK=1,"+window.Calibrated_DVL_Id);
};

HEADING.stopCalChk = function ()
{
	window.Select_sensor_id.disable();
	window.Start_calibration.disable();
	window.Stop_calibration.disable();
	window.Start_calchk.disable();
	window.Stop_calchk.disable();
	GIWIK.ajax(GIWIK.cgifile+"?mode=4&CALCHK=0,"+window.Calibrated_DVL_Id);
};



HEADING.readConf.local = function ()
{

	if (typeof System_state.DDRECK == 'undefined') {return;}
	if (typeof System_state.CALCHK == 'undefined') {return;}

	// Chargement page: Get DVL Id from DDRECK request
	if (!HEADING.init.isdone){
		window.Calibrated_DVL_Id = System_state.DDRECK[10];
	}

	// Pas de second DVL ou pas de calibration pour second DVL: DVL1
	if( !GIWIK._ext_sensors['dvl2'] || GIWIK.dvl2calibration===false){
		window.Calibrated_DVL_Id = 1;
	}



	// Show by default
	window.Start_calibration.show();
	window.Stop_calibration.show();
	window.Start_calchk.show();
	window.Stop_calchk.show();
	HEADING.disableValidation();
	

	// Buttons Management: Calibration ON
	if( System_state.DDRECK[0]==1 )
	{
		window.Start_calchk.disable();
		window.Stop_calchk.hide();

		window.Start_calibration.hide();
		window.Stop_calibration.show();
		window.Stop_calibration.enable();

	}
	// Buttons Management: Calibration End
	else if( System_state.DDRECK[0]==2 )
	{
		window.Start_calchk.disable();
		window.Stop_calchk.hide();

		window.Start_calibration.show();
		window.Start_calibration.disable();
		window.Stop_calibration.hide();
	}
	// Buttons Management: Check ON
	else if( System_state.CALCHK[0]==1 )
	{
		window.Start_calchk.hide();
		window.Stop_calchk.show();
		window.Stop_calchk.enable();

		window.Start_calibration.disable();
		window.Stop_calibration.hide();
	}
	else
	{
		window.Start_calchk.show();
		window.Start_calchk.enable();
		window.Stop_calchk.hide();

		window.Select_sensor_id.enable();
		window.Start_calibration.show();
		window.Start_calibration.enable();
		window.Stop_calibration.hide();
	}

	window.Text_chk_status.setValue(MSG(['parameters','dvlchk_idle_state']));

	// Check Calibration en Cours
	if (System_state.CALCHK[0] == 1)
	{
		if(System_state._ui_status[8]&0x00001000)
		{
			window.Text_chk_status.setValue(MSG(['parameters','dvlchk_progress_state']));
		}

	    window.CALCHKTimer = setTimeout("HEADING.updateCalChk();", 1000);
		window.settings_modified = true;

	}
	// Check Calibration Desactivé...
	else
	{
		window.Text_calchk_distance.setValue(System_state.CALCHK[1]) ;
	    window.Text_calchk_hdrift.setValue(System_state.CALCHK[2]) ;
	    window.Text_calchk_vdrift.setValue(System_state.CALCHK[3]) ;
		window.Text_calchk_herrorpc.setValue(System_state.CALCHK[4]) ;
		window.Text_calchk_verrorpc.setValue(System_state.CALCHK[5]) ;

     	window.settings_modified = false;
	}

	if (System_state.DDRECK[0] == 0)
	{
		window.Text_cal_status.setValue(MSG(['parameters','dvlcalib_idle_state']));
		window.Text_cal_status.input_path.style.color = GIWIK.css.color_main;

		// Pas de calibration en cours : on lit les mésalignements actuels
		if (GIWIK._ext_sensors['dvl'])
		{
			eval( "window.Input_mis_roll.setValue(System_state."+(window.Calibrated_DVL_Id==2 ? "DVL2CAL" : "DVLCAL") +"[0]);");
			eval( "window.Input_mis_pitch.setValue(System_state."+(window.Calibrated_DVL_Id==2 ? "DVL2CAL" : "DVLCAL") +"[1]);");
			eval( "window.Input_mis_heading.setValue(System_state."+(window.Calibrated_DVL_Id==2 ? "DVL2CAL" : "DVLCAL") +"[2]);");
			eval( "window.Input_mis_scale.setValue(System_state."+(window.Calibrated_DVL_Id==2 ? "DVL2CAL" : "DVLCAL") +"[3]);");
		}
		else
		{
			window.Input_mis_roll.setValue(System_state.ODOCAL[0]);
			window.Input_mis_pitch.setValue(System_state.ODOCAL[1]);
			window.Input_mis_heading.setValue(System_state.ODOCAL[2]);
			window.Input_mis_scale.setValue(System_state.ODOCAL[3]);
		}

		// Et on masque les écarts Type: 0
		window.Text_mis_scale_sd.hide();
		window.Text_mis_heading_sd.hide();
		window.Text_mis_roll_sd.hide();
		window.Text_mis_pitch_sd.hide();

		window.Text_cal_distance.setValue("0");
		window.settings_modified = false;
	}
	else
	{
		if (System_state.DDRECK[0] == 1)
		{
			//if(System_state._ui_status[8]&0x00000100) 	//Distance is computed
			if(!(System_state._ui_status[2]&0x00000002))	//end of coarse Alignement ( first 5min )
			{
				if(System_state._ui_status[8]&0x00000400 || System_state._ui_status[8]&0x00000800)
				{				
					//Display distance traveled: data is ready
					window.Text_cal_distance.setValue(System_state.DDRECK[9]);

					// Et les ecarts type associés
					window.Text_mis_scale_sd.show();
					window.Text_mis_heading_sd.show();
					window.Text_mis_roll_sd.hide(); // Roll is hidden
					window.Text_mis_pitch_sd.show();
				
					// Calibration en cours ou à valider => on affiche le résultat de la calibration
					window.Input_mis_scale.setValue(System_state.DDRECK[1]);
					window.Input_mis_heading.setValue(System_state.DDRECK[2]);
					window.Input_mis_roll.setValue(System_state.DDRECK[3]);
					window.Input_mis_pitch.setValue(System_state.DDRECK[4]);
					window.Text_cal_distance.input_path.style.color = GIWIK.css.color_main;

					window.Text_mis_scale_sd.setValue( "±"+System_state.DDRECK[5] );
					window.Text_mis_heading_sd.setValue( "±"+System_state.DDRECK[6] );
					window.Text_mis_roll_sd.setValue( "±"+System_state.DDRECK[7] );
					window.Text_mis_pitch_sd.setValue( "±"+System_state.DDRECK[8] );
				}
				
				//Rough calibration
				if(System_state._ui_status[8]&0x00000400)
				{
					window.Text_cal_status.setValue(MSG(['parameters','dvlcalib_rough_state']));
				}
				//Fine calibration
				else if(System_state._ui_status[8]&0x00000800)
				{
					window.Text_cal_status.setValue(MSG(['parameters','dvlcalib_fine_state']));
				}
				/*else
				{
					window.Text_cal_status.setValue(MSG(['parameters','dvlcalib_calibration_state']));
				}*/
			}
			//Distance is not computed
			else
			{
				window.Text_cal_status.setValue(MSG(['parameters','dvlcalib_wait_state']));
				window.Text_cal_status.input_path.style.color = GIWIK.css.color_2;

				// State waiting for alignment: Default values
				window.Input_mis_scale.setValue('0');
				window.Input_mis_heading.setValue('0');
				window.Input_mis_roll.setValue('0');
				window.Input_mis_pitch.setValue('0');
				window.Text_cal_distance.setValue('0');

				window.Input_mis_scale.input_path.style.color = GIWIK.css.color_2;
				window.Input_mis_heading.input_path.style.color = GIWIK.css.color_2;
				window.Input_mis_roll.input_path.style.color = GIWIK.css.color_2;
				window.Input_mis_pitch.input_path.style.color = GIWIK.css.color_2;
				window.Text_cal_distance.input_path.style.color = GIWIK.css.color_2;

				// Et on masque les écarts Type: 0
				window.Text_mis_scale_sd.hide();
				window.Text_mis_heading_sd.hide();
				window.Text_mis_roll_sd.hide();
				window.Text_mis_pitch_sd.hide();
			}

			// Limitation digits significatifs Ecarts Type
			var i=0;
			for(i=5; i<=8; i++)
			{
				if( System_state.DDRECK[i] > 100 ) { System_state.DDRECK[i] = eval(System_state.DDRECK[i]).toFixed(2); }
				else if( System_state.DDRECK[i] > 10 ) { System_state.DDRECK[i] = eval(System_state.DDRECK[i]).toFixed(3); }
			}

			// Ask for calibration again
			window.DVLTimer = setTimeout("HEADING.updateCalibration();", 1000);

			
			var HeadingMesa_stabilized = false;
			
			//Rovins Nano and C3
			if((GIWIK.system_type === 15) || (GIWIK.system_type === 18)){
				HeadingMesa_stabilized = ((System_state.DDRECK[6] <= 0.08) && (System_state.DDRECK[5] <= 0.196));
			}
			else{
				HeadingMesa_stabilized = (System_state.DDRECK[6] <= 0.03);
			}
			
			// Calibration en cours
			//if (System_state.DDRECK[6] > 0.03)
			if (!HeadingMesa_stabilized)
			{
				// Mésalignement de cap non stabilisé => valeur en orange
				window.Input_mis_heading.input_path.style.color = GIWIK.css.color_2;
				window.Input_mis_roll.input_path.style.color = GIWIK.css.color_2;
				window.Input_mis_pitch.input_path.style.color = GIWIK.css.color_2;
				window.Input_mis_scale.input_path.style.color = GIWIK.css.color_2;

				window.Text_mis_heading_sd.input_path.style.color = GIWIK.css.color_2;
				window.Text_mis_roll_sd.input_path.style.color = GIWIK.css.color_2;
				window.Text_mis_pitch_sd.input_path.style.color = GIWIK.css.color_2;
				window.Text_mis_scale_sd.input_path.style.color = GIWIK.css.color_2;
			}
			else
			{
				//Cap stabilisé => valeur en bleue
				window.Input_mis_heading.input_path.style.color = GIWIK.css.color_main;
				window.Input_mis_roll.input_path.style.color = GIWIK.css.color_main;
				window.Input_mis_pitch.input_path.style.color = GIWIK.css.color_main;
				window.Input_mis_scale.input_path.style.color = GIWIK.css.color_main;

				window.Text_mis_heading_sd.input_path.style.color = GIWIK.css.color_main;
				window.Text_mis_roll_sd.input_path.style.color = GIWIK.css.color_main;
				window.Text_mis_pitch_sd.input_path.style.color = GIWIK.css.color_main;
				window.Text_mis_scale_sd.input_path.style.color = GIWIK.css.color_main;
			}

		}
		else if (System_state.DDRECK[0] == 2)
		{
			// Calibration terminée, en attente de confirmation
			window.settings_modified = true;
			
			//Display last values
			window.Input_mis_scale.setValue(System_state.DDRECK[1]);
			window.Input_mis_heading.setValue(System_state.DDRECK[2]);
			window.Input_mis_pitch.setValue(System_state.DDRECK[4]);
			window.Text_cal_distance.setValue(System_state.DDRECK[9]);

			//Mise à jour état de la calibration
			window.Text_cal_status.setValue(MSG(['parameters','dvlcalib_idle_state']));
			window.Text_cal_status.input_path.style.color   = GIWIK.css.color_main;
			window.Input_mis_heading.input_path.style.color = GIWIK.css.color_main;
			window.Input_mis_roll.input_path.style.color    = GIWIK.css.color_main;
			window.Input_mis_pitch.input_path.style.color   = GIWIK.css.color_main;
			window.Input_mis_scale.input_path.style.color   = GIWIK.css.color_main;
			window.Text_cal_distance.input_path.style.color = GIWIK.css.color_main;
		}
	}

};

HEADING.readConf.local.customButtons = function (action) {

    if (!HEADING.init.isdone) {

		if(GIWIK.use_odocal_as_syst_mesa===true)
		{
			// Add button to Validate Calibration using values as Vehicule Frame Misalignment
			$('#'+window.Validate_settings.idelem).after(
				'<div id="btn_useAsSystemMisalignments" style="float:right"></div>'
			);

			// New Validation Button: Complement to standard one
			window.Btn_useAsSystemMisalignments = new Button('Btn_useAsSystemMisalignments', false);
			window.Btn_useAsSystemMisalignments.margin = '0 10px 0 0';
			window.Btn_useAsSystemMisalignments.construct('btn_useAsSystemMisalignments',MSG(['buttons','UseCalibrationAsSystemMisalignments']));
			window.Btn_useAsSystemMisalignments.setAction("if (HEADING.init.isdone) { HEADING.sendConf({use_as_system_mesa:true});}", false);
			window.Btn_useAsSystemMisalignments.disable();
			
			// Replace Standard Calibration Button Label
			window.Validate_settings.setValue(MSG(['buttons','UseCalibrationAsCalibrationData']));
		}
	}
};


HEADING.getConf.local = function ()
{
	var _params = {};

	if (GIWIK._ext_sensors['dvl'])
	{
		_params['DVLCAL'] = "";
		_params['DVL2CAL'] = "";
		_params['DDRECK'] = "";
	}
	else
	{
		_params['ODOCAL'] = "";
		_params['DDRECK'] = "";
	}
	_params['CALCHK'] = "";

	return _params;
};

HEADING.sendConf.local = function (_options)
{
	var _params = {};
	var sensor = '';
	var mode = 1;

	// Manage SendConf Options
	if (typeof _options == 'object'){
		
		if( _options.use_as_system_mesa===true ){
			mode = 2;
		}
	}
	
	// Sensor
	sensor = (GIWIK._ext_sensors['dvl']) ? ( window.Calibrated_DVL_Id==2 ? 'DVL2CAL' : 'DVLCAL') : 'ODOCAL';
	
	// Calibration Value
	_params[sensor] = window.Input_mis_roll.getValue() + "," + window.Input_mis_pitch.getValue() + "," + window.Input_mis_heading.getValue() + "," + window.Input_mis_scale.getValue();
	
	// Add Calibration Application Mode: Only when compensating system mesa 
	if( mode===2 ){
		_params[sensor] += ",2";
	}
	
	// Stop Calibration
	_params['DDRECK'] = "0,0";

	return _params;
};

HEADING.construct.local = function ()
{
	var cnt = ''

	+'<div id="params_sensor_id">\n'
		+'<table class="params_misalignments_tab">\n'
			+'<tr>\n'
				+'<td class="left">\n'
					+'<div id="select_sensor_id"></div>\n'
				+'</td>\n'
			+'</tr>\n'
		+'</table>\n'
	+'</div>\n'

	+'<div id="params_misalignments">\n'
		+'<table class="params_misalignments_tab">\n'
			+'<tr>\n'
				+'<div id="text_cal_status"></div>\n'			
			+'</tr>\n'
			+'<tr>\n'
				+'<td class="left">\n'
					+'<table><tr>'
						+'<td class="left">\n'
							//+'<div id="text_cal_status"></div>\n'
							+'<div id="input_mis_roll"></div>\n'
							+'<div id="input_mis_pitch"></div>\n'
							+'<div id="input_mis_heading"></div>\n'
							+'<div id="input_mis_scale"></div>\n'
						+'</td>\n'
						+'<td class="right_sd">\n'						
							+'<div id="text_mis_roll_sd"></div>\n'
							+'<div id="text_mis_pitch_sd"></div>\n'
							+'<div id="text_mis_heading_sd"></div>\n'
							+'<div id="text_mis_scale_sd"></div>\n'
						+'</td>\n'
					+'</tr></table>'
					+'<div id="text_cal_distance"></div>\n'
				+'</td>\n'
				+'<td class="right">\n'
				    +'<div id="start_calibration" class="displaynone"></div>\n'
				    +'<div id="stop_calibration" class="displaynone"></div>\n'
				+'</td>\n'
			+'</tr>\n'
		+'</table>\n'
	+'</div>\n';

	cnt+='<div id="params_calchk">\n'
		+'<table class="params_misalignments_tab">\n'
			+'<tr>\n'
				+'<td class="left">\n'
					+'<div id="text_chk_status"></div>\n'
					+'<div id="text_calchk_distance"></div>\n'
					+'<div id="text_calchk_hdrift"></div>\n'
					+'<div id="text_calchk_herrorpc"></div>\n'
					+'<div id="text_calchk_vdrift"></div>\n'
					+'<div id="text_calchk_verrorpc"></div>\n'
				+'</td>\n'
				+'<td class="right">\n'
				    +'<div id="start_calchk" class="displaynone"></div>\n'
				    +'<div id="stop_calchk" class="displaynone"></div>\n'
				+'</td>\n'
			+'</tr>\n'
		+'</table>\n'
	+'</div>';


    if (GIWIK._ext_sensors['dvl'])
    {
		$('#content').append(GIWIK.box(cnt, MSG(['box','dvl_calibration_title']), true, [], ['', 'box_content_nopaddingtop']));
		GIWIK.write('box_config_title',MSG(['box','dvl_calibration_title']));
		if( GIWIK._ext_sensors['dvl2'] && GIWIK.dvl2calibration===true ){
			GIWIK.paramGroup.construct('params_sensor_id', MSG(['box','params_dvl_sensor_id']), 'show');
		}
		GIWIK.paramGroup.construct('params_misalignments', MSG(['box','params_dvl_misalignments']), 'show');
		GIWIK.paramGroup.construct('params_calchk', MSG(['box','params_dvl_calchk']), 'show');

	}
	else
	{
		$('#content').append(GIWIK.box(cnt, MSG(['box','odo_calibration_title']), true, [], ['', 'box_content_nopaddingtop']));
		GIWIK.write('box_config_title',MSG(['box','odo_calibration_title']));
		GIWIK.paramGroup.construct('params_misalignments', MSG(['box','params_odo_misalignments']), 'show');
		GIWIK.paramGroup.construct('params_calchk', MSG(['box','params_odo_calchk']), 'show');
	}

    cnt = null;
	window.heading_labels_width = 71; 	// Définit la largeur des labels des paramètres de la page
	window.heading_input_width  = 80; 	// Définit la largeur des inputs des paramètres de la page
	window.status_input_width   = 160;	// Définit la largeur du label de statut

	// Parametres Sensor_ID
	window.Select_sensor_id = new Input_select('Select_sensor_id', false);
	window.Select_sensor_id.label_width = window.heading_labels_width;
	window.Select_sensor_id.input_width = window.heading_input_width;
	window.Select_sensor_id.construct('select_sensor_id','linear',MSG(['parameters','dvl_id'], {lang:'en'}),[1,2],[MSG(['ext_sensors','dvl']),MSG(['ext_sensors','dvl2'])],'',true);
	window.Select_sensor_id.enable();
	window.Select_sensor_id.setAction('HEADING.selectDVL();');
	if (GIWIK._ext_sensors['dvl2'] && GIWIK.dvl2calibration === true)
	{
		window.Select_sensor_id.show();
	}
	else{
		window.Select_sensor_id.hide();
	}


	// Paramètre "mis heading"
	window.Input_mis_heading = new Input_int('Input_mis_heading', true);
	window.Input_mis_heading.label_width = window.heading_labels_width;
	window.Input_mis_heading.input_width = window.heading_input_width;
	window.Input_mis_heading.construct('input_mis_heading','linear',MSG(['parameters','heading']),0.001,-180,180,MSG(['units','degree']));
	window.Input_mis_heading.show();
	window.Input_mis_heading.setAction('HEADING.enableValidation();');
	
	window.Text_mis_heading_sd = new Input_text('text_mis_heading_sd', false);
	window.Text_mis_heading_sd.input_width = window.heading_input_width-18;
	window.Text_mis_heading_sd.readonly = true;
	window.Text_mis_heading_sd.text_align = 'right';
	window.Text_mis_heading_sd.construct('text_mis_heading_sd','linear',"",MSG(['units','degree']));
	window.Text_mis_heading_sd.unit_path.style.paddingLeft = 0 ;
	window.Text_mis_heading_sd.enable();
	window.Text_mis_heading_sd.show();
	
	// Paramètre "mis roll"
	window.Input_mis_roll = new Input_int('Input_mis_roll', true);
	window.Input_mis_roll.label_width = window.heading_labels_width;
	window.Input_mis_roll.input_width = window.heading_input_width;
	window.Input_mis_roll.construct('input_mis_roll','linear',MSG(['parameters','roll']),0.001,-180,180,MSG(['units','degree']));
	window.Input_mis_roll.hide();
	window.Input_mis_roll.setAction('HEADING.enableValidation();');

	window.Text_mis_roll_sd = new Input_text('text_mis_roll_sd', false);
	window.Text_mis_roll_sd.input_width = window.heading_input_width-18;
	window.Text_mis_roll_sd.readonly = true;
	window.Text_mis_roll_sd.text_align = 'right';
	window.Text_mis_roll_sd.construct('text_mis_roll_sd','linear',"",MSG(['units','degree']));	
	window.Text_mis_roll_sd.unit_path.style.paddingLeft = 0 ;
	window.Text_mis_roll_sd.enable();
	window.Text_mis_roll_sd.hide();

	// Paramètre "mis pitch"
	window.Input_mis_pitch = new Input_int('Input_mis_pitch', true);
	window.Input_mis_pitch.label_width = window.heading_labels_width;
	window.Input_mis_pitch.input_width= window.heading_input_width;
	window.Input_mis_pitch.construct('input_mis_pitch','linear',MSG(['parameters','pitch']),0.001,-180,180,MSG(['units','degree']));
	window.Input_mis_pitch.show();
	window.Input_mis_pitch.setAction('HEADING.enableValidation();');

	window.Text_mis_pitch_sd = new Input_text('text_mis_pitch_sd', true);
	window.Text_mis_pitch_sd.input_width = window.heading_input_width-18;
	window.Text_mis_pitch_sd.readonly = true;
	window.Text_mis_pitch_sd.text_align = 'right';
	window.Text_mis_pitch_sd.construct('text_mis_pitch_sd','linear',"",MSG(['units','degree']));
	window.Text_mis_pitch_sd.unit_path.style.paddingLeft = 0 ;
	window.Text_mis_pitch_sd.enable();
	window.Text_mis_pitch_sd.show();

	// Paramètre "mis scale"
	window.Input_mis_scale = new Input_int('Input_mis_scale', true);
	window.Input_mis_scale.label_width = window.heading_labels_width;
	window.Input_mis_scale.input_width = window.heading_input_width;
	window.Input_mis_scale.construct('input_mis_scale','linear',MSG(['parameters','scale_factor']),0.001,-1000,1000,MSG(['units','percent']));
	window.Input_mis_scale.show();
	window.Input_mis_scale.setAction('HEADING.enableValidation();');

	window.Text_mis_scale_sd = new Input_text('text_mis_scale_sd', true);
	window.Text_mis_scale_sd.input_width = window.heading_input_width-18;
	window.Text_mis_scale_sd.readonly = true;
	window.Text_mis_scale_sd.text_align = 'right';
	window.Text_mis_scale_sd.construct('text_mis_scale_sd','linear',"",MSG(['units','percent']));
	window.Text_mis_scale_sd.unit_path.style.paddingLeft = 0 ;
	window.Text_mis_scale_sd.enable();
	window.Text_mis_scale_sd.show();


	// Paramètre "distance"
	window.Text_cal_distance = new Input_text('Text_cal_distance', true);
	window.Text_cal_distance.label_width = window.heading_labels_width;
	window.Text_cal_distance.input_width = window.heading_input_width;
	window.Text_cal_distance.low_fontsize = false;
	window.Text_cal_distance.fontsize = 15;
	window.Text_cal_distance.readonly = true;
	window.Text_cal_distance.construct('text_cal_distance','linear',MSG(['parameters','cal_distance']),MSG(['units','meter']));
	window.Text_cal_distance.show();

	window.Start_calibration = new Button('Start_calibration', false);
	window.Start_calibration.construct('start_calibration',MSG(['buttons','calibration_start']));
	window.Start_calibration.setAction('HEADING.startCalibration();');

	window.Stop_calibration = new Button('Stop_calibration', false);
	window.Stop_calibration.construct('stop_calibration',MSG(['buttons','calibration_stop']));
	window.Stop_calibration.setAction('HEADING.stopCalibration();');


	//Paramètre "calchk distance"
	window.Text_calchk_distance = new Input_text('Text_calchk_distance', true);
	window.Text_calchk_distance.label_width = window.heading_labels_width;
	window.Text_calchk_distance.input_width = window.heading_input_width;
	window.Text_calchk_distance.low_fontsize = false;
	window.Text_calchk_distance.fontsize = 15;
	window.Text_calchk_distance.readonly = true;
	window.Text_calchk_distance.construct('text_calchk_distance','linear',MSG(['parameters','calchk_distance_label']),MSG(['units','meter']));
	window.Text_calchk_distance.show();

	//Paramètre "calchk hdrift"
	window.Text_calchk_hdrift = new Input_text('Text_calchk_hdrift', true);
	window.Text_calchk_hdrift.label_width = window.heading_labels_width;
	window.Text_calchk_hdrift.input_width = window.heading_input_width;
	window.Text_calchk_hdrift.low_fontsize = false;
	window.Text_calchk_hdrift.fontsize = 15;
	window.Text_calchk_hdrift.readonly = true;
	window.Text_calchk_hdrift.construct('text_calchk_hdrift','linear',MSG(['parameters','calchk_hdrift_label']),MSG(['units','meter']));
	window.Text_calchk_hdrift.show();

	//Paramètre "calchk vdrift"
	window.Text_calchk_vdrift = new Input_text('Text_calchk_vdrift', true);
	window.Text_calchk_vdrift.label_width = window.heading_labels_width;
	window.Text_calchk_vdrift.input_width = window.heading_input_width;
	window.Text_calchk_vdrift.low_fontsize = false;
	window.Text_calchk_vdrift.fontsize = 15;
	window.Text_calchk_vdrift.readonly = true;
	window.Text_calchk_vdrift.construct('text_calchk_vdrift','linear',MSG(['parameters','calchk_vdrift_label']),MSG(['units','meter']));
	window.Text_calchk_vdrift.show();

	//Paramètre "calchk herrorpc"
	window.Text_calchk_herrorpc = new Input_text('Text_calchk_herrorpc', true);
	window.Text_calchk_herrorpc.label_width = window.heading_labels_width;
	window.Text_calchk_herrorpc.input_width = window.heading_input_width;
	window.Text_calchk_herrorpc.low_fontsize = false;
	window.Text_calchk_herrorpc.fontsize = 15;
	window.Text_calchk_herrorpc.readonly = true;
	window.Text_calchk_herrorpc.construct('text_calchk_herrorpc','linear',MSG(['parameters','calchk_herror_label']),MSG(['units','percent']));
	window.Text_calchk_herrorpc.show();

	//Paramètre "calchk verrorpc"
	window.Text_calchk_verrorpc = new Input_text('Text_calchk_verrorpc', true);
	window.Text_calchk_verrorpc.label_width = window.heading_labels_width;
	window.Text_calchk_verrorpc.input_width = window.heading_input_width;
	window.Text_calchk_verrorpc.low_fontsize = false;
	window.Text_calchk_verrorpc.fontsize = 15;
	window.Text_calchk_verrorpc.readonly = true;
	window.Text_calchk_verrorpc.construct('text_calchk_verrorpc','linear',MSG(['parameters','calchk_verror_label']),MSG(['units','percent']));
	window.Text_calchk_verrorpc.show();

	window.Start_calchk = new Button('Start_calchk', false);
	window.Start_calchk.construct('start_calchk',MSG(['buttons','calchk_start']));
	window.Start_calchk.setAction('HEADING.startCalChk();');

	window.Stop_calchk = new Button('Stop_calchk', false);
	window.Stop_calchk.construct('stop_calchk',MSG(['buttons','calchk_stop']));
	window.Stop_calchk.setAction('HEADING.stopCalChk();');

	// Paramètre "calibration status"
	window.Text_cal_status = new Input_text('Text_cal_status', true);
	window.Text_cal_status.label_width = window.heading_labels_width;
	window.Text_cal_status.input_width = window.heading_input_width;
	window.Text_cal_status.text_align = "left";
	window.Text_cal_status.readonly = true;
	window.Text_cal_status.construct('text_cal_status','linear',MSG(['parameters','calchk_status']),'');
	window.Text_cal_status.show();

	$('#text_cal_status').css('margin','12px 0px 0px 88px');
	
	// Paramètre "verification status"
	window.Text_chk_status = new Input_text('Text_chk_status', true);
	window.Text_chk_status.label_width = window.heading_labels_width;
	window.Text_chk_status.input_width = window.heading_input_width;
	window.Text_chk_status.readonly = true;
	window.Text_chk_status.construct('text_chk_status','linear',MSG(['parameters','calchk_status']),'');
	window.Text_chk_status.show();

	return {
		validation_buttons : {
			cancel : {
				action : "HEADING.cancelCalibration()",
				label  : MSG(['buttons','calibration_cancel_conf'])
			},
			send : {
				label : MSG(['buttons','calibration_update_conf'])
			},
			no_margin_top : true
		}
	};
};