//GIWIK.init.js('css');

// eval() sur System_state.ModeZUP,HeaveConf,ModeStart,ModeAlti contre l'envoi de string par les anciens firmware

HEADING.readConf.local = function ()
{
	// Gestion de l'affichage de certains paramètres ou groupes de paramètres
	var dvl     = (System_state.ExtSToSerial[array_search('dvl',    GIWIK._extsensors_fulllist)] != 0) ? true : false;
	var dvl2    = (System_state.ExtSToSerial[array_search('dvl2',    GIWIK._extsensors_fulllist)] != 0) ? true : false;
	var logem   = (System_state.ExtSToSerial[array_search('logem',  GIWIK._extsensors_fulllist)] != 0) ? true : false;
	var logem2  = (System_state.ExtSToSerial[array_search('logem2', GIWIK._extsensors_fulllist)] != 0) ? true : false;
	var current = (GIWIK.current && (dvl || dvl2 || logem || logem2)) ? true : false;

	if (!HEADING.init.isdone)
	{
		if (GIWIK.zuptmode)
		{
			// Filter Mode Zupt removing "N/A"
			var ModeZuptFilterList = [];
			var ModeZuptFilterId = [];
			for (var i = 0; i < System_state.ModeZUPList.length; i++) {
				if( System_state.ModeZUPList[i].indexOf("N/A")==-1 )
				{
					ModeZuptFilterList.push(System_state.ModeZUPList[i]);
					ModeZuptFilterId.push(i);
				}
			}
			
			window.Select_ModeZUP = new Input_select('Select_ModeZUP', true);
			window.Select_ModeZUP.label_width = window.heading_labels_width;
			window.Select_ModeZUP.construct('input_zupmode','linear',MSG(['parameters','zup_mode']),ModeZuptFilterId,ModeZuptFilterList,'',true);
			window.Select_ModeZUP.setAction("window.ZuptChanged=true;", true);
			window.Select_ModeZUP.show();
		}

		if (GIWIK.alti_depth && GIWIK.altimode)
		{
			window.Select_ModeAlti = new Input_select('Select_ModeAlti', true);
			window.Select_ModeAlti.label_width = window.heading_labels_width;
			window.Select_ModeAlti.construct('input_altimode','linear',MSG(['parameters','alti_mode']),array_keys(System_state.ModeAltiList),System_state.ModeAltiList,'',true);
			window.Select_ModeAlti.setAction("window.AltiChanged=true;", true);
			window.Select_ModeAlti.show();
		}

		/*if (GIWIK.heave) // NO MORE USED
		{
			window.Select_ModeHeave = new Input_select('Select_ModeHeave', true);
			window.Select_ModeHeave.label_width = window.heading_labels_width;
			window.Select_ModeHeave.construct('input_heavemode','linear',MSG(['parameters','heave_mode']),array_keys(System_state.ModeHeaveList),System_state.ModeHeaveList,'',true);
			window.Select_ModeHeave.setAction("window.HeaveModeChanged=true;", true);
			window.Select_ModeHeave.show();
		}*/

		// First time => create Start Mode
		if (GIWIK.startmode)
		{
			// Filter Mode Start removing "N/A"
			var ModeStartFilterList = [];
			var ModeStartFilterId = [];
			for (var i = 0; i < System_state.ModeStartList.length; i++) {
				if( System_state.ModeStartList[i].indexOf("N/A")==-1 )
				{
					ModeStartFilterList.push(System_state.ModeStartList[i]);
					ModeStartFilterId.push(i);
				}
			}
			window.Select_ModeStart = new Input_select('Select_ModeStart', true);
			window.Select_ModeStart.label_width = window.heading_labels_width;
			window.Select_ModeStart.construct('input_startmode','linear',MSG(['parameters','start_mode_label']),ModeStartFilterId,ModeStartFilterList,'',true);
			window.Select_ModeStart.setAction("window.StartModeChanged=true;", true);
			window.Select_ModeStart.show();
		}
		
		if (GIWIK.vehicletype)
		{
			window.Select_VehicleType = new Input_select('Select_VehicleType', true);
			window.Select_VehicleType.label_width = window.heading_labels_width;
			window.Select_VehicleType.construct('input_vehicletype','linear', MSG(['parameters','vehicle_type_label']),array_keys(System_state.VehiculeTypeList),System_state.VehiculeTypeList,'',true);
			window.Select_VehicleType.setAction("window.VehicleTypeChanged=true;", true);
			window.Select_VehicleType.show();
		}
		
		if (GIWIK.navigationmode)
		{
			window.Select_ModeNavigation = new Input_select('Select_ModeNavigation', true);
			window.Select_ModeNavigation.label_width = window.heading_labels_width;
			window.Select_ModeNavigation.construct('input_navigationmode','linear',MSG(['parameters','navigation_mode_label']),array_keys(System_state.ModeNavigationList),System_state.ModeNavigationList,'',true);
			window.Select_ModeNavigation.setAction("window.NavigationModeChanged=true;", true);
			window.Select_ModeNavigation.show();
		}
		
		if (GIWIK.dynamicmode)
		{
			window.Select_ModeDynamic = new Input_select('Select_ModeDynamic', true);
			window.Select_ModeDynamic.label_width = window.heading_labels_width;
			window.Select_ModeDynamic.construct('input_dynamicmode','linear',MSG(['parameters','dynamic_mode_label']),array_keys(System_state.ModeDynamicList),System_state.ModeDynamicList,'',true);
			window.Select_ModeDynamic.setAction("window.DynamicModeChanged=true;", true);
			window.Select_ModeDynamic.show();
		}

		// Paramètres courant
		//  "Temps"
		if (current)
		{
			window.Input_current_time = new Input_int('Input_current_time', true);
			window.Input_current_time.label_width = window.heading_labels_width;
			window.Input_current_time.construct('input_current_time','linear',MSG(['parameters','time_label']),0.001,0,+72000,MSG(['units','second']));
			window.Input_current_time.setAction("window.CurrentParamChanged=true;");
			window.Input_current_time.show();

			//  "Amplitude"
			window.Input_current_amplitude = new Input_int('Input_current_amplitude', true);
			window.Input_current_amplitude.label_width = window.heading_labels_width;
			window.Input_current_amplitude.construct('input_current_amplitude','linear',MSG(['parameters','amplitude_label']),0.001,0.0,+10.0,MSG(['units','meter_per_second']));
			window.Input_current_amplitude.setAction("window.CurrentParamChanged=true;");
			window.Input_current_amplitude.show();
		}

		if (GIWIK.utmzonemode)
		{
			// Paramètre "Extend UTM Zone"
			window.Input_force_utm_zone = new Input_checkbox('Input_force_utm_zone', true);
			window.Input_force_utm_zone.label_width = window.heading_labels_width;
			window.Input_force_utm_zone.construct('input_force_utm_zone','linear',MSG(['parameters','force_utm_zone']),[0,1],true);
			window.Input_force_utm_zone.setAction("window.UtmZoneModeChanged=true;");
			window.Input_force_utm_zone.show();

		}
	}

	if (GIWIK.zuptmode)
	{
		window.Select_ModeZUP.setValue(eval(System_state.ModeZUP[1]));
		window.ZuptChanged = false;
	}

	if (GIWIK.alti_depth && GIWIK.altimode)
	{
		window.Select_ModeAlti.setValue(eval(System_state.ModeAlti));
	}

	/*if (GIWIK.heave) // NO MORE USED
	{
		window.Select_ModeHeave.setValue(eval(System_state.HeaveConf));
		window.HeaveModeChanged = false;
	}*/

	if (GIWIK.startmode)
	{
		window.Select_ModeStart.setValue(eval(System_state.ModeStart));
		window.StartModeChanged = false;
	}

	if (GIWIK.vehicletype)
	{
		window.Select_VehicleType.setValue(eval(System_state.VehicleType));
		window.VehicleTypeChanged = false;
	}
	
	if (GIWIK.navigationmode)
	{
		window.Select_ModeNavigation.setValue(eval(System_state.ModeNavigation));
		window.NavigationModeChanged = false;
	}
	
	if (current)
	{
		window.Input_current_time.setValue(System_state.DVLTAM[0]);
		window.Input_current_amplitude.setValue(System_state.DVLTAM[1]);
		window.CurrentParamChanged = false;
	}

	if (GIWIK.utmzonemode)
	{
		window.Input_force_utm_zone.setValue(eval(System_state.UtmZoneMode));
		window.UtmZoneModeChanged = false;
	}

	if (GIWIK.dynamicmode)
	{
		window.Select_ModeDynamic.setValue(eval(System_state.ModeDynamic));
		window.DynamicModeChanged = false;
	}

	if (!current)
	{
		$('#params_current_title').css('display','none');
	}
	
	if (GIWIK.travelled_dist)   
	{
		window.Text_travelled_dist.setValue(System_state.TravelledDist);
	}
	
	
	window.AltiChanged = false;
	window.ManposChanged = false;
};

HEADING.getConf.local = function ()
{
	var _params = {};

	// Lors de l'init, on récupère le contenu des listes
	if (!HEADING.init.isdone)
	{
		if (GIWIK.alti_depth && GIWIK.altimode) {_params['ModeAltiList'] = "";}
		if (GIWIK.zuptmode)	  {_params['ModeZUPList'] = "";}
		// NO MORE USED if (GIWIK.heave)      {_params['ModeHeaveList'] = "";}
		if (GIWIK.startmode)  {_params['ModeStartList'] = "";}
		if (GIWIK.vehicletype)  {_params['VehiculeTypeList'] = "";}
		if (GIWIK.navigationmode)  {_params['ModeNavigationList'] = "";}
		if (GIWIK.dynamicmode)  {_params['ModeDynamicList'] = "";}
	}

	if (GIWIK.alti_depth && GIWIK.altimode) {_params['ModeAlti'] = "";}
	if (GIWIK.current)     {_params['DVLTAM'] = "";}
	if (GIWIK.zuptmode)    {_params['ModeZUP'] = "";}
	// NO MORE USED if (GIWIK.heave)       {_params['HeaveConf'] = "";}
	if (GIWIK.startmode)   {_params['ModeStart'] = "";}
	if (GIWIK.vehicletype)   {_params['VehicleType'] = "";}
	if (GIWIK.navigationmode)   {_params['ModeNavigation'] = "";}
	if (GIWIK.utmzonemode) {_params['UtmZoneMode'] = "";}
	if (GIWIK.dynamicmode)   {_params['ModeDynamic'] = "";}
	if (GIWIK.travelled_dist)   {_params['TravelledDist'] = "";}
	_params['ExtSToSerial'] = ""; //get list of selected input sensors
	
	return _params;
};

HEADING.sendConf.local = function ()
{
	var _params = {};

	// Si le système est déjà en mode ZUP, on change de mode
	// Sinon, on mémorise le mode pour l'activer sur demande depuis la page controle.
	if (GIWIK.zuptmode)
	{
		if (window.ZuptChanged)
		{
			if (window.Select_ModeZUP.getValue() == 0) // si sélection "None" alors ModeZUP désactivé 
			{
				_params['ModeZUP'] = "0,0";
			}
			else {
				_params['ModeZUP'] = eval(System_state.ModeZUP[0])+","+window.Select_ModeZUP.getValue();
			}
			window.ZuptChanged = false;
		}
	}

	if (window.AltiChanged)
	{
		_params['ModeAlti'] = window.Select_ModeAlti.getValue();
		window.AltiChanged = false;
	}

	/* if (window.HeaveModeChanged) // NO MORE USED
	{
		_params['HeaveConf'] = window.Select_ModeHeave.getValue();
		window.HeavemodeChanged = false;
	}*/

	if (window.StartModeChanged)
	{
		_params['ModeStart'] = window.Select_ModeStart.getValue();
		window.StartmodeChanged = false;
	}
	if (window.VehicleTypeChanged)
	{
		_params['VehicleType'] = window.Select_VehicleType.getValue();
		window.VehicleTypeChanged = false;
	}
	if (window.NavigationModeChanged)
	{
		_params['ModeNavigation'] = window.Select_ModeNavigation.getValue();
		window.NavigationmodeChanged = false;
	}
	if (window.DynamicModeChanged)
	{
		_params['ModeDynamic'] = window.Select_ModeDynamic.getValue();
		window.DynamicmodeChanged = false;
	}
	if (window.CurrentParamChanged)
	{
		_params['DVLTAM'] = window.Input_current_time.getValue()+","+window.Input_current_amplitude.getValue();
		window.CurrentParamChanged = false;
	}

	if (window.UtmZoneModeChanged)
	{
		_params['UtmZoneMode'] = window.Input_force_utm_zone.getValue();
		window.UtmZoneModeChanged = false;
	}

	/*if(window.TravelledDistChanged)
	{
		_params['TravelledDist'] = window.Text_travelled_dist.getValue();
		window.TravelledDistChanged = false;
	}*/

	return _params;
};


HEADING.ResetTravelledDistance = function ()
{
	GIWIK.ajax(GIWIK.cgifile+'?mode=4&TravelledDist=0');
};


HEADING.construct.local = function ()
{
	var cnt = '';


	if (GIWIK.dynamicmode)
	{
		cnt += '<div id="params_dynamicmode">'
			+'<table class="params_init">'
				+'<tr>'
					+'<td align="left">'
						+'<div id="input_dynamicmode"></div>'
					+'</td>'
				+'</tr>'
			+'</table>'
		+'</div>';
	}

	if (GIWIK.startmode)
	{
		cnt += '<div id="params_startmode">'
			+'<table class="params_init">'
				+'<tr>'
					+'<td align="left">'
						+'<div id="input_startmode"></div>'
					+'</td>'
				+'</tr>'
			+'</table>'
		+'</div>';
	}

	if (GIWIK.vehicletype)
	{
		cnt += '<div id="params_vehicletype">'
			+'<table class="params_init">'
				+'<tr>'
					+'<td align="left">'
						+'<div id="input_vehicletype"></div>'
					+'</td>'
				+'</tr>'
			+'</table>'
		+'</div>';
	}
	
	if (GIWIK.navigationmode)
	{
		cnt += '<div id="params_navigationmode">'
			+'<table class="params_init">'
				+'<tr>'
					+'<td align="left">'
						+'<div id="input_navigationmode"></div>'
					+'</td>'
				+'</tr>'
			+'</table>'
		+'</div>';
	}
	
	if (GIWIK.zuptmode)
	{
		cnt += '<div id="params_zupmode">'
			+'<table class="params_init">'
				+'<tr>'
					+'<td align="left">'
						+'<div id="input_zupmode"></div>'
					+'</td>'
				+'</tr>'
			+'</table>'
		+'</div>';
	}

	if (GIWIK.alti_depth && GIWIK.altimode)
	{
		cnt += '<div id="params_altimode">'
			+'<table class="params_init">'
				+'<tr>'
					+'<td align="left">'
						+'<div id="input_altimode"></div>'
					+'</td>'
				+'</tr>'
			+'</table>'
		+'</div>';
	}

	/*if (GIWIK.heave) // NO MORE USED
	{
		cnt += '<div id="params_heavemode">'
			+'<table class="params_init">'
				+'<tr>'
					+'<td align="left">'
						+'<div id="input_heavemode"></div>'
					+'</td>'
				+'</tr>'
			+'</table>'
		+'</div>';
	}*/

	if (GIWIK.current)
	{
		cnt += '<div id="params_current">'
			+'<table class="params_init">'
				+'<tr>'
					+'<td class="left">'
						+'<div id="input_current_time"></div>'
						+'<div id="input_current_amplitude"></div>'
					+'</td>'
				+'</tr>'
			+'</table>'
		+'</div>';
	}

	if (GIWIK.utmzonemode)
	{
		cnt += '<div id="params_utmzonemode">'
			+'<table class="params_init">'
				+'<tr>'
					+'<td class="left">'
						+'<div id="input_force_utm_zone"></div>'
					+'</td>'
				+'</tr>'
			+'</table>'
		+'</div>';
	}

	if (GIWIK.travelled_dist)
	{
		cnt += '<div id="params_travelled_dist">'
			+'<table class="params_init">'
				+'<tr>'
				+'<td class="left">'
					+'<div id="text_travelled_dist"></div>'
				+'</td>'
					 +'<td class="right">'
						+'<div id="button_reset_travelled_dist"></div>'
					+'</td>'
				+'</tr>'
			+'</table>'
		+'</div>';
	}

	$('#content').append(GIWIK.box(cnt, MSG(['box','navigation_title']), true, [], ['', 'box_content_nopaddingtop']));

	window.heading_labels_width = 90; 	// Définit la largeur des labels des paramètres de la page

	// Groupes de paramètres

	if (GIWIK.alti_depth && GIWIK.altimode)  {GIWIK.paramGroup.construct('params_altimode',    MSG(['box','params_alti']), 'show');}
	if (GIWIK.zuptmode)	   {GIWIK.paramGroup.construct('params_zupmode',     MSG(['box','params_zupt']), 'show');}
	if (GIWIK.current)	   {GIWIK.paramGroup.construct('params_current',     MSG(['box','params_current']), 'show');}
	// NO MORE USED if (GIWIK.heave)	   {GIWIK.paramGroup.construct('params_heavemode',   MSG(['box','params_heave']), 'show');}
	if (GIWIK.startmode)   {GIWIK.paramGroup.construct('params_startmode',   MSG(['box','params_start']), 'show');}
	if (GIWIK.vehicletype)   {GIWIK.paramGroup.construct('params_vehicletype',   MSG(['box','params_vehicle']), 'show');}
	if (GIWIK.navigationmode)   {GIWIK.paramGroup.construct('params_navigationmode',   MSG(['box','params_navigation']), 'show');}
	if (GIWIK.utmzonemode) {GIWIK.paramGroup.construct('params_utmzonemode', MSG(['box','params_utmzone']), 'show');}
	if (GIWIK.dynamicmode) {GIWIK.paramGroup.construct('params_dynamicmode',     MSG(['box','params_dynamic']), 'show');}
	if (GIWIK.travelled_dist) {GIWIK.paramGroup.construct('params_travelled_dist',     MSG(['box','params_travelled_dist']), 'show');}


	if (GIWIK.travelled_dist)
	{
		// Reset Travelled Distance Label
		window.Text_travelled_dist = new Input_text('Text_travelled_dist', true);
		window.Text_travelled_dist.label_width = window.heading_labels_width;
		window.Text_travelled_dist.input_width = window.heading_input_width;
		window.Text_travelled_dist.readonly = true;
		window.Text_travelled_dist.construct('text_travelled_dist','linear',MSG(['parameters','travelled_distance']),MSG(['units','meter']));
		window.Text_travelled_dist.setAction("window.TravelledDistChanged=true;");
		window.Text_travelled_dist.show();

		// Reset Travelled Distance Button
		window.Button_reset_travelled_dist = new Button('Button_reset_travelled_dist', false);
		window.Button_reset_travelled_dist.margin = "5px 00px 00px 40px";
		window.Button_reset_travelled_dist.construct('button_reset_travelled_dist',MSG(['buttons','reset_travelled_distance']),'small');
		window.Button_reset_travelled_dist.setAction("HEADING.ResetTravelledDistance()");
		window.Button_reset_travelled_dist.enable(true);

	}
};
