GIWIK.init.js('css');

HEADING.readConf.local = function ()
{
    window.Radio_synchroloss_utc0.setValue(System_state.ALERTCNF[2]);
	window.Radio_synchroloss_utc1.setValue(System_state.ALERTCNF[2]);
	window.Radio_synchroloss_utc2.setValue(System_state.ALERTCNF[2]);

	window.Radio_synchroloss_position0.setValue(System_state.ALERTCNF[3]);
	window.Radio_synchroloss_position1.setValue(System_state.ALERTCNF[3]);
	window.Radio_synchroloss_position2.setValue(System_state.ALERTCNF[3]);

	if (GIWIK.speed_sensor)
	{
	  	window.Radio_synchroloss_speed0.setValue(System_state.ALERTCNF[4]);
	  	window.Radio_synchroloss_speed1.setValue(System_state.ALERTCNF[4]);
	  	window.Radio_synchroloss_speed2.setValue(System_state.ALERTCNF[4]);
	}

	if (GIWIK.stddev)
	{
		window.Input_HeadingAccuracy.setValue(System_state.ALERTCNF[0]);
		window.Input_PositionAccuracy.setValue(System_state.ALERTCNF[1]);
	}

	// Déclanchement d'un getConf pour chaque popup ouvert (ne fonctionne qu'avec les popups ouverts depuis cette page)
	if (HEADING.init.isdone)
	{
		var _popups = STORAGE.get('popupwin'),
			popup;

		if (_popups)
		{
			for (var i in _popups)
			{
				popup = _popups[i];

				// Si le popup est ouvert
				if (window[popup])
				{
					window[popup].HEADING.getConf();
				}
			}
		}
	}
};

HEADING.sendConf.local = function ()
{
	var _params = {};

	if (GIWIK.stddev)
	{
		System_state.ALERTCNF[0] = window.Input_HeadingAccuracy.getValue();
		System_state.ALERTCNF[1] = window.Input_PositionAccuracy.getValue();
	}
	System_state.ALERTCNF[2] = window.Radio_synchroloss_utc0.getValue();
	System_state.ALERTCNF[3] = window.Radio_synchroloss_position0.getValue();
	System_state.ALERTCNF[4] = (GIWIK.speed_sensor) ? window.Radio_synchroloss_speed0.getValue() : 0;

  	_params['ALERTCNF'] = System_state.ALERTCNF.join(",");

	return _params;
};

HEADING.construct.local = function ()
{
	var cnt = ''

	+'<div id="params_synchroloss_utc">'
		+'<table class="params_synchroloss">'
			+'<tr>'
				+'<td align="left">'
					+'<div id="radio_synchroloss_utc0"></div>'
					+'<div id="radio_synchroloss_utc1"></div>'
					+'<div id="radio_synchroloss_utc2"></div>'
				+'</td>'
			+'</tr>'
		+'</table>'
	+'</div>'

	+'<div id="params_synchroloss_position">'
		+'<table class="params_synchroloss">'
			+'<tr>'
				+'<td align="left">'
					+'<div id="radio_synchroloss_position0"></div>'
					+'<div id="radio_synchroloss_position1"></div>'
					+'<div id="radio_synchroloss_position2"></div>'
				+'</td>'
			+'</tr>'
		+'</table>'
	+'</div>'

	+'<div id="params_synchroloss_speed">'
		+'<table class="params_synchroloss">'
			+'<tr>'
				+'<td align="left">'
					+'<div id="radio_synchroloss_speed0"></div>'
					+'<div id="radio_synchroloss_speed1"></div>'
					+'<div id="radio_synchroloss_speed2"></div>'
				+'</td>'
			+'</tr>'
		+'</table>'
	+'</div>'

	+'<div id="params_heading_accuracy">'
		+'<table class="params_accuracy">'
			+'<tr>'
				+'<td align="left">'
					+'<div id="list_heading_accuracy"></div>'
				+'</td>'
			+'</tr>'
		+'</table>'
	+'</div>'

	+'<div id="params_position_accuracy">'
		+'<table class="params_accuracy">'
			+'<tr>'
				+'<td align="left">'
					+'<div id="list_position_accuracy"></div>'
				+'</td>'
			+'</tr>'
		+'</table>'
	+'</div>';


	$('#content').append(GIWIK.box(cnt, MSG(['box','warnings_title']), true, [], ['', 'box_content_nopaddingtop']));

	cnt = null;


	// Construction des groupes de paramètres
	GIWIK.paramGroup.construct('params_synchroloss_utc', MSG(['box','params_synchroloss_utc']), 'show');
	GIWIK.paramGroup.construct('params_synchroloss_position', MSG(['box','params_synchroloss_position']), 'show');

	if (GIWIK.stddev)
	{
		GIWIK.paramGroup.construct('params_heading_accuracy', MSG(['box','params_heading_stdev_header']), 'show');
		GIWIK.paramGroup.construct('params_position_accuracy', MSG(['box','params_position_stdev_header']), 'show');
	}

	window.heading_labels_width = (GIWIK.lang == 'fr') ? 310 : 330; 	// Définit la largeur des labels des paramètres de la page


	// Boutons radios pour le choix de l'évènement de perte de synchro "UTC"
	window.Radio_synchroloss_utc0 = new Input_radio('Radio_synchroloss_utc0', true);
	window.Radio_synchroloss_utc0.padding_label_linear = 5;
	window.Radio_synchroloss_utc0.construct('radio_synchroloss_utc0','synchroloss_utc','linear',MSG(['parameters','synchroloss0']),-1,true);
	window.Radio_synchroloss_utc0.show();

	window.Radio_synchroloss_utc1 = new Input_radio('Radio_synchroloss_utc1', true);
	window.Radio_synchroloss_utc1.padding_label_linear = 5;
	window.Radio_synchroloss_utc1.construct('radio_synchroloss_utc1','synchroloss_utc','linear',MSG(['parameters','synchroloss1']),2,true);
	window.Radio_synchroloss_utc1.show();

	window.Radio_synchroloss_utc2 = new Input_radio('Radio_synchroloss_utc2', true);
	window.Radio_synchroloss_utc2.padding_label_linear = 5;
	window.Radio_synchroloss_utc2.construct('radio_synchroloss_utc2','synchroloss_utc','linear',MSG(['parameters','synchroloss2']),3,true);
	window.Radio_synchroloss_utc2.show();

	// Boutons radios pour le choix de l'évènement de perte de synchro position
	window.Radio_synchroloss_position0 = new Input_radio('Radio_synchroloss_position0', true);
	window.Radio_synchroloss_position0.padding_label_linear = 5;
	window.Radio_synchroloss_position0.construct('radio_synchroloss_position0','synchroloss_position','linear',MSG(['parameters','synchroloss0']),-1,true);
	window.Radio_synchroloss_position0.show();

	window.Radio_synchroloss_position1 = new Input_radio('Radio_synchroloss_position1', true);
	window.Radio_synchroloss_position1.padding_label_linear = 5;
	window.Radio_synchroloss_position1.construct('radio_synchroloss_position1','synchroloss_position','linear',MSG(['parameters','synchroloss1']),2,true);
	window.Radio_synchroloss_position1.show();

	window.Radio_synchroloss_position2 = new Input_radio('Radio_synchroloss_position2', true);
	window.Radio_synchroloss_position2.padding_label_linear = 5;
	window.Radio_synchroloss_position2.construct('radio_synchroloss_position2','synchroloss_position','linear',MSG(['parameters','synchroloss2']),3,true);
	window.Radio_synchroloss_position2.show();

	if (GIWIK.speed_sensor)
	{
		GIWIK.paramGroup.construct('params_synchroloss_speed', MSG(['box','params_synchroloss_speed']), 'show');

		// Boutons radios pour le choix de l'évènement de perte de synchro speed
	  	window.Radio_synchroloss_speed0 = new Input_radio('Radio_synchroloss_speed0', true);
	  	window.Radio_synchroloss_speed0.padding_label_linear = 5;
	  	window.Radio_synchroloss_speed0.construct('radio_synchroloss_speed0','synchroloss_speed','linear',MSG(['parameters','synchroloss0']),-1,true);
		window.Radio_synchroloss_speed0.show();

	  	window.Radio_synchroloss_speed1 = new Input_radio('Radio_synchroloss_speed1', true);
	  	window.Radio_synchroloss_speed1.padding_label_linear = 5;
	  	window.Radio_synchroloss_speed1.construct('radio_synchroloss_speed1','synchroloss_speed','linear',MSG(['parameters','synchroloss1']),2,true);
	  	window.Radio_synchroloss_speed1.show();

	  	window.Radio_synchroloss_speed2 = new Input_radio('Radio_synchroloss_speed2', true);
	  	window.Radio_synchroloss_speed2.padding_label_linear = 5;
	  	window.Radio_synchroloss_speed2.construct('radio_synchroloss_speed2','synchroloss_speed','linear',MSG(['parameters','synchroloss2']),3,true);
		window.Radio_synchroloss_speed2.show();
	}

	if (GIWIK.stddev)
	{
		// Choix de l'alerte sur précision de cap
		window.heading_accuracy_list = ["---", "0.1°", "0.2°", "0.5°", "1°"];
		window.heading_accuracy_list_values = [0, 0.1, 0.2, 0.5, 1];

		window.Input_HeadingAccuracy = new Input_select('Input_HeadingAccuracy', true);
		window.Input_HeadingAccuracy.label_width = window.heading_labels_width;
		window.Input_HeadingAccuracy.construct('list_heading_accuracy', 'linear', MSG(['parameters','params_heading_stdev_warning']),window.heading_accuracy_list_values,window.heading_accuracy_list,'',true)
		window.Input_HeadingAccuracy.show();

		// Choix de l'alerte sur précision de position
		window.position_accuracy_list = ["---", "10cm", "50cm", "1m", "5m", "10m", "100m"];
		window.position_accuracy_list_values = [0, 0.1, 0.5, 1, 5, 10, 100];

		window.Input_PositionAccuracy = new Input_select('Input_PositionAccuracy', true);
		window.Input_PositionAccuracy.label_width = window.heading_labels_width;
		window.Input_PositionAccuracy.construct('list_position_accuracy', 'linear', MSG(['parameters','params_position_stdev_warning']),window.position_accuracy_list_values,window.position_accuracy_list,'',true)
		window.Input_PositionAccuracy.show();
	}
};